import { PathReference } from '@glimmer/reference';
import { Option } from '@glimmer/util';
import VM from '../../vm/append';
import { InlineBlock } from '../../scanner';
import { CompiledExpression } from '../expressions';
export default class CompiledHasBlock extends CompiledExpression<boolean> {
    private inner;
    type: string;
    constructor(inner: CompiledGetBlock);
    evaluate(vm: VM): PathReference<boolean>;
    toJSON(): string;
}
export declare class CompiledHasBlockParams extends CompiledExpression<boolean> {
    private inner;
    type: string;
    constructor(inner: CompiledGetBlock);
    evaluate(vm: VM): PathReference<boolean>;
    toJSON(): string;
}
export interface CompiledGetBlock {
    evaluate(vm: VM): Option<InlineBlock>;
    toJSON(): string;
}
export declare class CompiledGetBlockBySymbol implements CompiledGetBlock {
    private symbol;
    private debug;
    constructor(symbol: number, debug: string);
    evaluate(vm: VM): InlineBlock;
    toJSON(): string;
}
export declare class CompiledInPartialGetBlock implements CompiledGetBlock {
    private symbol;
    private name;
    constructor(symbol: number, name: string);
    evaluate(vm: VM): InlineBlock;
    toJSON(): string;
}
