import { CompiledExpression } from '../expressions';
import { PrimitiveReference } from '../../references';
export default class CompiledHasBlock extends CompiledExpression {
    constructor(inner) {
        super();
        this.inner = inner;
        this.type = "has-block";
    }
    evaluate(vm) {
        let block = this.inner.evaluate(vm);
        return PrimitiveReference.create(!!block);
    }
    toJSON() {
        return `has-block(${this.inner.toJSON()})`;
    }
}
export class CompiledHasBlockParams extends CompiledExpression {
    constructor(inner) {
        super();
        this.inner = inner;
        this.type = "has-block-params";
    }
    evaluate(vm) {
        let block = this.inner.evaluate(vm);
        let hasLocals = block && block.symbolTable.getSymbols().locals;
        return PrimitiveReference.create(!!hasLocals);
    }
    toJSON() {
        return `has-block-params(${this.inner.toJSON()})`;
    }
}
export class CompiledGetBlockBySymbol {
    constructor(symbol, debug) {
        this.symbol = symbol;
        this.debug = debug;
    }
    evaluate(vm) {
        return vm.scope().getBlock(this.symbol);
    }
    toJSON() {
        return `get-block($${this.symbol}(${this.debug}))`;
    }
}
export class CompiledInPartialGetBlock {
    constructor(symbol, name) {
        this.symbol = symbol;
        this.name = name;
    }
    evaluate(vm) {
        let { symbol, name } = this;
        let args = vm.scope().getPartialArgs(symbol);
        return args.blocks[name];
    }
    toJSON() {
        return `get-block($${this.symbol}($ARGS).${this.name}))`;
    }
}
//# sourceMappingURL=data:application/json;base64,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