import { CompiledExpression } from '../expressions';
export default class CompiledHelper extends CompiledExpression {
    constructor(name, helper, args, symbolTable) {
        super();
        this.name = name;
        this.helper = helper;
        this.args = args;
        this.symbolTable = symbolTable;
        this.type = "helper";
    }
    evaluate(vm) {
        let { helper } = this;
        return helper(vm, this.args.evaluate(vm), this.symbolTable);
    }
    toJSON() {
        return `\`${this.name}($ARGS)\``;
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaGVscGVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vbGliL2NvbXBpbGVkL2V4cHJlc3Npb25zL2hlbHBlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsa0JBQWtCLEVBQUUsTUFBTSxnQkFBZ0IsQ0FBQztBQVFwRCxNQUFNLENBQUMsT0FBTyxxQkFBc0IsU0FBUSxrQkFBMEI7SUFHcEUsWUFBbUIsSUFBWSxFQUFTLE1BQWMsRUFBUyxJQUFrQixFQUFTLFdBQXdCO1FBQ2hILEtBQUssRUFBRSxDQUFDO1FBRFMsU0FBSSxHQUFKLElBQUksQ0FBUTtRQUFTLFdBQU0sR0FBTixNQUFNLENBQVE7UUFBUyxTQUFJLEdBQUosSUFBSSxDQUFjO1FBQVMsZ0JBQVcsR0FBWCxXQUFXLENBQWE7UUFGM0csU0FBSSxHQUFHLFFBQVEsQ0FBQztJQUl2QixDQUFDO0lBRUQsUUFBUSxDQUFDLEVBQU07UUFDYixJQUFJLEVBQUUsTUFBTSxFQUFFLEdBQUcsSUFBSSxDQUFDO1FBQ3RCLE1BQU0sQ0FBQyxNQUFNLENBQUMsRUFBRSxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLEVBQUUsQ0FBQyxFQUFFLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQztJQUM5RCxDQUFDO0lBRUQsTUFBTTtRQUNKLE1BQU0sQ0FBQyxLQUFLLElBQUksQ0FBQyxJQUFJLFdBQVcsQ0FBQztJQUNuQyxDQUFDO0NBQ0YifQ==