import { CompiledExpression } from '../expressions';
import { referenceFromParts } from '@glimmer/reference';
export default class CompiledLookup extends CompiledExpression {
    constructor(base, path) {
        super();
        this.base = base;
        this.path = path;
        this.type = "lookup";
    }
    static create(base, path) {
        if (path.length === 0) {
            return base;
        }
        else {
            return new this(base, path);
        }
    }
    evaluate(vm) {
        let { base, path } = this;
        return referenceFromParts(base.evaluate(vm), path);
    }
    toJSON() {
        return `${this.base.toJSON()}.${this.path.join('.')}`;
    }
}
export class CompiledSelf extends CompiledExpression {
    evaluate(vm) {
        return vm.getSelf();
    }
    toJSON() {
        return 'self';
    }
}
export class CompiledSymbol extends CompiledExpression {
    constructor(symbol, debug) {
        super();
        this.symbol = symbol;
        this.debug = debug;
    }
    evaluate(vm) {
        return vm.referenceForSymbol(this.symbol);
    }
    toJSON() {
        return `$${this.symbol}(${this.debug})`;
    }
}
export class CompiledInPartialName extends CompiledExpression {
    constructor(symbol, name) {
        super();
        this.symbol = symbol;
        this.name = name;
    }
    evaluate(vm) {
        let { symbol, name } = this;
        let args = vm.scope().getPartialArgs(symbol);
        return args.named.get(name);
    }
    toJSON() {
        return `$${this.symbol}($ARGS).${this.name}`;
    }
}
//# sourceMappingURL=data:application/json;base64,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