import { CompiledExpression } from '../expressions';
import VM from '../../vm/append';
import { PathReference, RevisionTag } from '@glimmer/reference';
import { Option, Dict, Opaque } from '@glimmer/util';
export declare class CompiledNamedArgs {
    keys: ReadonlyArray<string>;
    values: ReadonlyArray<CompiledExpression<Opaque>>;
    static empty(): CompiledNamedArgs;
    static create(map: Dict<CompiledExpression<Opaque>>): CompiledNamedArgs;
    length: number;
    constructor(keys: ReadonlyArray<string>, values: ReadonlyArray<CompiledExpression<Opaque>>);
    evaluate(vm: VM): EvaluatedNamedArgs;
    toJSON(): string;
}
export declare const COMPILED_EMPTY_NAMED_ARGS: CompiledNamedArgs;
export declare class EvaluatedNamedArgs {
    keys: ReadonlyArray<string>;
    values: ReadonlyArray<PathReference<Opaque>>;
    private _map;
    static create(map: Dict<PathReference<Opaque>>): EvaluatedNamedArgs;
    static empty(): EvaluatedNamedArgs;
    tag: RevisionTag;
    length: number;
    constructor(keys: ReadonlyArray<string>, values: ReadonlyArray<PathReference<Opaque>>, _map?: Option<Dict<PathReference<Opaque>>>);
    readonly map: Dict<PathReference<Opaque>>;
    get(key: string): PathReference<Opaque>;
    has(key: string): boolean;
    value(): Dict<Opaque>;
}
export declare const EVALUATED_EMPTY_NAMED_ARGS: EvaluatedNamedArgs;
