import { UNDEFINED_REFERENCE } from '../../references';
import { EMPTY_ARRAY } from '../../utils';
import { combineTagged } from '@glimmer/reference';
export class CompiledPositionalArgs {
    constructor(values) {
        this.values = values;
        this.length = values.length;
    }
    static create(values) {
        if (values.length) {
            return new this(values);
        }
        else {
            return COMPILED_EMPTY_POSITIONAL_ARGS;
        }
    }
    static empty() {
        return COMPILED_EMPTY_POSITIONAL_ARGS;
    }
    evaluate(vm) {
        let { values, length } = this;
        let references = new Array(length);
        for (let i = 0; i < length; i++) {
            references[i] = values[i].evaluate(vm);
        }
        return EvaluatedPositionalArgs.create(references);
    }
    toJSON() {
        return `[${this.values.map(value => value.toJSON()).join(", ")}]`;
    }
}
export const COMPILED_EMPTY_POSITIONAL_ARGS = new (class extends CompiledPositionalArgs {
    constructor() {
        super(EMPTY_ARRAY);
    }
    evaluate(_vm) {
        return EVALUATED_EMPTY_POSITIONAL_ARGS;
    }
    toJSON() {
        return `<EMPTY>`;
    }
});
export class EvaluatedPositionalArgs {
    constructor(values) {
        this.values = values;
        this.tag = combineTagged(values);
        this.length = values.length;
    }
    static create(values) {
        return new this(values);
    }
    static empty() {
        return EVALUATED_EMPTY_POSITIONAL_ARGS;
    }
    at(index) {
        let { values, length } = this;
        return (index < length) ? values[index] : UNDEFINED_REFERENCE;
    }
    value() {
        let { values, length } = this;
        let ret = new Array(length);
        for (let i = 0; i < length; i++) {
            ret[i] = values[i].value();
        }
        return ret;
    }
}
export const EVALUATED_EMPTY_POSITIONAL_ARGS = new (class extends EvaluatedPositionalArgs {
    constructor() {
        super(EMPTY_ARRAY);
    }
    at() {
        return UNDEFINED_REFERENCE;
    }
    value() {
        return this.values;
    }
});
//# sourceMappingURL=data:application/json;base64,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