import { CompiledExpression } from '../expressions';
import { PrimitiveReference } from '../../references';
export default class CompiledValue extends CompiledExpression {
    constructor(value) {
        super();
        this.type = "value";
        this.reference = PrimitiveReference.create(value);
    }
    evaluate(_vm) {
        return this.reference;
    }
    toJSON() {
        return JSON.stringify(this.reference.value());
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidmFsdWUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi9saWIvY29tcGlsZWQvZXhwcmVzc2lvbnMvdmFsdWUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQ0EsT0FBTyxFQUFFLGtCQUFrQixFQUFFLE1BQU0sZ0JBQWdCLENBQUM7QUFDcEQsT0FBTyxFQUFhLGtCQUFrQixFQUFFLE1BQU0sa0JBQWtCLENBQUM7QUFFakUsTUFBTSxDQUFDLE9BQU8sb0JBQTBDLFNBQVEsa0JBQXFCO0lBSW5GLFlBQVksS0FBUTtRQUNsQixLQUFLLEVBQUUsQ0FBQztRQUpILFNBQUksR0FBRyxPQUFPLENBQUM7UUFLcEIsSUFBSSxDQUFDLFNBQVMsR0FBRyxrQkFBa0IsQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDcEQsQ0FBQztJQUVELFFBQVEsQ0FBQyxHQUFPO1FBQ2QsTUFBTSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUM7SUFDeEIsQ0FBQztJQUVELE1BQU07UUFDSixNQUFNLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssRUFBRSxDQUFDLENBQUM7SUFDaEQsQ0FBQztDQUNGIn0=