import { APPEND_OPCODES } from '../../opcodes';
APPEND_OPCODES.add(20 /* OpenBlock */, (vm, { op1: _getBlock, op2: _args }) => {
    let inner = vm.constants.getOther(_getBlock);
    let rawArgs = vm.constants.getExpression(_args);
    let args = null;
    let block = inner.evaluate(vm);
    if (block) {
        args = rawArgs.evaluate(vm);
    }
    // FIXME: can we avoid doing this when we don't have a block?
    vm.pushCallerScope();
    if (block) {
        vm.invokeBlock(block, args || null);
    }
});
APPEND_OPCODES.add(21 /* CloseBlock */, vm => vm.popScope());
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYmxvY2tzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vbGliL2NvbXBpbGVkL29wY29kZXMvYmxvY2tzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUVBLE9BQU8sRUFBRSxjQUFjLEVBQW9CLE1BQU0sZUFBZSxDQUFDO0FBR2pFLGNBQWMsQ0FBQyxHQUFHLHFCQUFlLENBQUMsRUFBRSxFQUFFLEVBQUUsR0FBRyxFQUFFLFNBQVMsRUFBRSxHQUFHLEVBQUUsS0FBSyxFQUFFO0lBQ2xFLElBQUksS0FBSyxHQUFHLEVBQUUsQ0FBQyxTQUFTLENBQUMsUUFBUSxDQUFtQixTQUFTLENBQUMsQ0FBQztJQUMvRCxJQUFJLE9BQU8sR0FBRyxFQUFFLENBQUMsU0FBUyxDQUFDLGFBQWEsQ0FBZSxLQUFLLENBQUMsQ0FBQztJQUM5RCxJQUFJLElBQUksR0FBMEIsSUFBSSxDQUFDO0lBRXZDLElBQUksS0FBSyxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsRUFBRSxDQUFDLENBQUM7SUFFL0IsRUFBRSxDQUFDLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztRQUNWLElBQUksR0FBRyxPQUFPLENBQUMsUUFBUSxDQUFDLEVBQUUsQ0FBQyxDQUFDO0lBQzlCLENBQUM7SUFFRCw2REFBNkQ7SUFDN0QsRUFBRSxDQUFDLGVBQWUsRUFBRSxDQUFDO0lBRXJCLEVBQUUsQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7UUFDVixFQUFFLENBQUMsV0FBVyxDQUFDLEtBQUssRUFBRSxJQUFJLElBQUksSUFBSSxDQUFDLENBQUM7SUFDdEMsQ0FBQztBQUNILENBQUMsQ0FBQyxDQUFDO0FBRUgsY0FBYyxDQUFDLEdBQUcsc0JBQWdCLEVBQUUsSUFBSSxFQUFFLENBQUMsUUFBUSxFQUFFLENBQUMsQ0FBQyJ9