import * as content from './content';
import * as vm from './vm';
import { Insertion } from '../../upsert';
import { CompiledGetBlock } from '../../compiled/expressions/has-block';
import { Option, Dict, Opaque } from '@glimmer/util';
import { Constants } from '../../opcodes';
import { CompiledArgs } from '../expressions/args';
import { CompiledExpression } from '../expressions';
import { ComponentDefinition } from '../../component/interfaces';
import { PartialDefinition } from '../../partial';
import Environment, { Program } from '../../environment';
import { SymbolTable } from '@glimmer/interfaces';
import { ComponentBuilder as IComponentBuilder } from '../../opcode-builder';
import { BaselineSyntax, InlineBlock, Template } from '../../scanner';
import { OpcodeName as Op, ConstantArray, ConstantOther, ConstantExpression, ConstantBlock } from '../../opcodes';
export interface CompilesInto<E> {
    compile(builder: OpcodeBuilder): E;
}
export declare type RepresentsExpression = BaselineSyntax.AnyExpression | CompiledExpression<Opaque>;
export declare type Represents<E> = CompilesInto<E> | E;
export declare type Label = string;
export interface SymbolLookup {
    symbolTable: SymbolTable;
}
export declare abstract class BasicOpcodeBuilder implements SymbolLookup {
    symbolTable: SymbolTable;
    env: Environment;
    program: Program;
    private labelsStack;
    constants: Constants;
    start: number;
    constructor(symbolTable: SymbolTable, env: Environment, program: Program);
    abstract compile<E>(expr: Represents<E>): E;
    abstract compileExpression(expr: RepresentsExpression): CompiledExpression<Opaque>;
    readonly end: number;
    private readonly pos;
    private readonly nextPos;
    protected opcode(name: Op, op1?: number, op2?: number, op3?: number): void;
    push(type: number, op1?: number, op2?: number, op3?: number): void;
    private readonly labels;
    startLabels(): void;
    stopLabels(): void;
    putPartialDefinition(_definition: PartialDefinition<Opaque>): void;
    putDynamicPartialDefinition(): void;
    evaluatePartial(): void;
    putComponentDefinition(definition: ComponentDefinition<Opaque>): void;
    putDynamicComponentDefinition(): void;
    openComponent(args: Represents<CompiledArgs>, shadow?: InlineBlock): void;
    didCreateElement(): void;
    shadowAttributes(): void;
    didRenderLayout(): void;
    closeComponent(): void;
    dynamicContent(Opcode: content.AppendDynamicOpcode<Insertion>): void;
    cautiousAppend(): void;
    trustingAppend(): void;
    guardedCautiousAppend(expression: RepresentsExpression): void;
    guardedTrustingAppend(expression: RepresentsExpression): void;
    text(text: string): void;
    openPrimitiveElement(tag: string): void;
    openComponentElement(tag: string): void;
    openDynamicPrimitiveElement(): void;
    flushElement(): void;
    closeElement(): void;
    staticAttr(_name: string, _namespace: Option<string>, _value: string): void;
    dynamicAttrNS(_name: string, _namespace: string, trusting: boolean): void;
    dynamicAttr(_name: string, trusting: boolean): void;
    comment(_comment: string): void;
    modifier(_name: string, _args: Represents<CompiledArgs>): void;
    putIterator(): void;
    enterList(start: string, end: string): void;
    exitList(): void;
    enterWithKey(start: string, end: string): void;
    nextIter(end: string): void;
    openBlock(_args: Represents<CompiledArgs>, _inner: CompiledGetBlock): void;
    closeBlock(): void;
    pushRemoteElement(): void;
    popRemoteElement(): void;
    popElement(): void;
    label(name: string): void;
    pushChildScope(): void;
    popScope(): void;
    pushDynamicScope(): void;
    popDynamicScope(): void;
    putNull(): void;
    putValue(_expression: RepresentsExpression): void;
    putArgs(_args: Represents<CompiledArgs>): void;
    bindDynamicScope(_names: string[]): void;
    bindPositionalArgs(_names: string[], _symbols: number[]): void;
    bindNamedArgs(_names: string[], _symbols: number[]): void;
    bindBlocks(_names: string[], _symbols: number[]): void;
    enter(enter: string, exit: string): void;
    exit(): void;
    evaluate(_block: InlineBlock): void;
    test(testFunc: 'const' | 'simple' | 'environment' | vm.TestFunction): void;
    jump(target: string): void;
    jumpIf(target: string): void;
    jumpUnless(target: string): void;
    protected names(_names: string[]): ConstantArray;
    protected symbols(symbols: number[]): ConstantArray;
    protected other(value: Opaque): ConstantOther;
    protected args(args: Represents<CompiledArgs>): ConstantExpression;
    protected block(block: InlineBlock): ConstantBlock;
}
export default class OpcodeBuilder extends BasicOpcodeBuilder {
    component: IComponentBuilder;
    constructor(symbolTable: SymbolTable, env: Environment, program?: Program);
    compile<E>(expr: Represents<E>): E;
    compileExpression(expression: RepresentsExpression): CompiledExpression<Opaque>;
    bindPositionalArgsForLocals(locals: Dict<number>): void;
    preludeForLayout(layout: Template): void;
    yield(args: Represents<CompiledArgs>, to: string): void;
    labelled(args: Option<Represents<CompiledArgs>>, callback: BlockCallback): void;
    iter(callback: BlockCallback): void;
    unit(callback: (builder: OpcodeBuilder) => void): void;
}
export declare type BlockCallback = (dsl: OpcodeBuilder, BEGIN: Label, END: Label) => void;
