import { UpdatingOpcode } from '../../opcodes';
import { Assert } from './vm';
import { EvaluatedArgs } from '../../compiled/expressions/args';
import { CONSTANT_TAG, ReferenceCache, combine, isConst } from '@glimmer/reference';
import { APPEND_OPCODES } from '../../opcodes';
APPEND_OPCODES.add(22 /* PutDynamicComponent */, vm => {
    let reference = vm.frame.getOperand();
    let cache = isConst(reference) ? undefined : new ReferenceCache(reference);
    let definition = cache ? cache.peek() : reference.value();
    vm.frame.setImmediate(definition);
    if (cache) {
        vm.updateWith(new Assert(cache));
    }
});
APPEND_OPCODES.add(23 /* PutComponent */, (vm, { op1: _component }) => {
    let definition = vm.constants.getOther(_component);
    vm.frame.setImmediate(definition);
});
APPEND_OPCODES.add(24 /* OpenComponent */, (vm, { op1: _args, op2: _shadow }) => {
    let rawArgs = vm.constants.getExpression(_args);
    let shadow = vm.constants.getBlock(_shadow);
    let definition = vm.frame.getImmediate();
    let dynamicScope = vm.pushDynamicScope();
    let callerScope = vm.scope();
    let manager = definition.manager;
    let args = manager.prepareArgs(definition, rawArgs.evaluate(vm), dynamicScope);
    let hasDefaultBlock = !!args.blocks.default; // TODO Cleanup?
    let component = manager.create(vm.env, definition, args, dynamicScope, vm.getSelf(), hasDefaultBlock);
    let destructor = manager.getDestructor(component);
    if (destructor)
        vm.newDestroyable(destructor);
    let layout = manager.layoutFor(definition, component, vm.env);
    let selfRef = manager.getSelf(component);
    vm.beginCacheGroup();
    vm.stack().pushSimpleBlock();
    vm.pushRootScope(selfRef, layout.symbols);
    vm.invokeLayout(args, layout, callerScope, component, manager, shadow);
    vm.updateWith(new UpdateComponentOpcode(definition.name, component, manager, args, dynamicScope));
});
// export class DidCreateElementOpcode extends Opcode {
//   public type = "did-create-element";
//   evaluate(vm: VM) {
//     let manager = vm.frame.getManager();
//     let component = vm.frame.getComponent();
//     let action = 'DidCreateElementOpcode#evaluate';
//     manager.didCreateElement(component, vm.stack().expectConstructing(action), vm.stack().expectOperations(action));
//   }
//   toJSON(): OpcodeJSON {
//     return {
//       guid: this._guid,
//       type: this.type,
//       args: ["$ARGS"]
//     };
//   }
// }
APPEND_OPCODES.add(25 /* DidCreateElement */, vm => {
    let manager = vm.frame.getManager();
    let component = vm.frame.getComponent();
    let action = 'DidCreateElementOpcode#evaluate';
    manager.didCreateElement(component, vm.stack().expectConstructing(action), vm.stack().expectOperations(action));
});
// export class ShadowAttributesOpcode extends Opcode {
//   public type = "shadow-attributes";
//   evaluate(vm: VM) {
//     let shadow = vm.frame.getShadow();
//     vm.pushCallerScope();
//     if (!shadow) return;
//     vm.invokeBlock(shadow, EvaluatedArgs.empty());
//   }
//   toJSON(): OpcodeJSON {
//     return {
//       guid: this._guid,
//       type: this.type,
//       args: ["$ARGS"]
//     };
//   }
// }
// Slow path for non-specialized component invocations. Uses an internal
// named lookup on the args.
APPEND_OPCODES.add(26 /* ShadowAttributes */, vm => {
    let shadow = vm.frame.getShadow();
    vm.pushCallerScope();
    if (!shadow)
        return;
    vm.invokeBlock(shadow, EvaluatedArgs.empty());
});
// export class DidRenderLayoutOpcode extends Opcode {
//   public type = "did-render-layout";
//   evaluate(vm: VM) {
//     let manager = vm.frame.getManager();
//     let component = vm.frame.getComponent();
//     let bounds = vm.stack().popBlock();
//     manager.didRenderLayout(component, bounds);
//     vm.env.didCreate(component, manager);
//     vm.updateWith(new DidUpdateLayoutOpcode(manager, component, bounds));
//   }
// }
APPEND_OPCODES.add(27 /* DidRenderLayout */, vm => {
    let manager = vm.frame.getManager();
    let component = vm.frame.getComponent();
    let bounds = vm.stack().popBlock();
    manager.didRenderLayout(component, bounds);
    vm.env.didCreate(component, manager);
    vm.updateWith(new DidUpdateLayoutOpcode(manager, component, bounds));
});
// export class CloseComponentOpcode extends Opcode {
//   public type = "close-component";
//   evaluate(vm: VM) {
//     vm.popScope();
//     vm.popDynamicScope();
//     vm.commitCacheGroup();
//   }
// }
APPEND_OPCODES.add(28 /* CloseComponent */, vm => {
    vm.popScope();
    vm.popDynamicScope();
    vm.commitCacheGroup();
});
export class UpdateComponentOpcode extends UpdatingOpcode {
    constructor(name, component, manager, args, dynamicScope) {
        super();
        this.name = name;
        this.component = component;
        this.manager = manager;
        this.args = args;
        this.dynamicScope = dynamicScope;
        this.type = "update-component";
        let componentTag = manager.getTag(component);
        if (componentTag) {
            this.tag = combine([args.tag, componentTag]);
        }
        else {
            this.tag = args.tag;
        }
    }
    evaluate(_vm) {
        let { component, manager, args, dynamicScope } = this;
        manager.update(component, args, dynamicScope);
    }
    toJSON() {
        return {
            guid: this._guid,
            type: this.type,
            args: [JSON.stringify(this.name)]
        };
    }
}
export class DidUpdateLayoutOpcode extends UpdatingOpcode {
    constructor(manager, component, bounds) {
        super();
        this.manager = manager;
        this.component = component;
        this.bounds = bounds;
        this.type = "did-update-layout";
        this.tag = CONSTANT_TAG;
    }
    evaluate(vm) {
        let { manager, component, bounds } = this;
        manager.didUpdateLayout(component, bounds);
        vm.env.didUpdate(component, manager);
    }
}
//# sourceMappingURL=data:application/json;base64,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