import Upsert, { Insertion, CautiousInsertion, TrustingInsertion } from '../../upsert';
import { DOMTreeConstruction } from '../../dom/helper';
import { UpdatingOpcode } from '../../opcodes';
import { CompiledExpression } from '../expressions';
import { VM } from '../../vm';
import { Reference, ReferenceCache } from '@glimmer/reference';
import { Opaque } from '@glimmer/util';
import { Cursor } from '../../bounds';
import { Fragment } from '../../builder';
import { Environment } from '../../environment';
import { SymbolTable } from '@glimmer/interfaces';
export declare function normalizeTextValue(value: Opaque): string;
export declare type AppendDynamicOpcodeConstructor = typeof OptimizedCautiousAppendOpcode | typeof OptimizedTrustingAppendOpcode;
export declare abstract class AppendDynamicOpcode<T extends Insertion> {
    protected abstract normalize(reference: Reference<Opaque>): Reference<T>;
    protected abstract insert(dom: DOMTreeConstruction, cursor: Cursor, value: T): Upsert;
    protected abstract updateWith(vm: VM, reference: Reference<Opaque>, cache: ReferenceCache<T>, bounds: Fragment, upsert: Upsert): UpdatingOpcode;
    evaluate(vm: VM): void;
}
export declare abstract class GuardedAppendOpcode<T extends Insertion> extends AppendDynamicOpcode<T> {
    private expression;
    private symbolTable;
    protected abstract AppendOpcode: typeof OptimizedCautiousAppendOpcode | typeof OptimizedTrustingAppendOpcode;
    private start;
    private end;
    constructor(expression: CompiledExpression<any>, symbolTable: SymbolTable);
    evaluate(vm: VM): void;
    deopt(env: Environment): number;
}
export declare class OptimizedCautiousAppendOpcode extends AppendDynamicOpcode<CautiousInsertion> {
    type: string;
    protected normalize(reference: Reference<Opaque>): Reference<CautiousInsertion>;
    protected insert(dom: DOMTreeConstruction, cursor: Cursor, value: CautiousInsertion): Upsert;
    protected updateWith(_vm: VM, _reference: Reference<Opaque>, cache: ReferenceCache<CautiousInsertion>, bounds: Fragment, upsert: Upsert): UpdatingOpcode;
}
export declare class GuardedCautiousAppendOpcode extends GuardedAppendOpcode<CautiousInsertion> {
    type: string;
    protected AppendOpcode: typeof OptimizedCautiousAppendOpcode;
    protected normalize(reference: Reference<Opaque>): Reference<CautiousInsertion>;
    protected insert(dom: DOMTreeConstruction, cursor: Cursor, value: CautiousInsertion): Upsert;
    protected updateWith(vm: VM, reference: Reference<Opaque>, cache: ReferenceCache<CautiousInsertion>, bounds: Fragment, upsert: Upsert): UpdatingOpcode;
}
export declare class OptimizedTrustingAppendOpcode extends AppendDynamicOpcode<TrustingInsertion> {
    type: string;
    protected normalize(reference: Reference<Opaque>): Reference<TrustingInsertion>;
    protected insert(dom: DOMTreeConstruction, cursor: Cursor, value: TrustingInsertion): Upsert;
    protected updateWith(_vm: VM, _reference: Reference<Opaque>, cache: ReferenceCache<TrustingInsertion>, bounds: Fragment, upsert: Upsert): UpdatingOpcode;
}
export declare class GuardedTrustingAppendOpcode extends GuardedAppendOpcode<TrustingInsertion> {
    type: string;
    protected AppendOpcode: typeof OptimizedTrustingAppendOpcode;
    protected normalize(reference: Reference<Opaque>): Reference<TrustingInsertion>;
    protected insert(dom: DOMTreeConstruction, cursor: Cursor, value: TrustingInsertion): Upsert;
    protected updateWith(vm: VM, reference: Reference<Opaque>, cache: ReferenceCache<TrustingInsertion>, bounds: Fragment, upsert: Upsert): UpdatingOpcode;
}
