import { OpcodeJSON, UpdatingOpcode } from '../../opcodes';
import { VM, UpdatingVM } from '../../vm';
import * as Simple from '../../dom/interfaces';
import { Environment } from '../../environment';
import { Option, Opaque, Dict } from '@glimmer/util';
import { Reference, RevisionTag, PathReference } from '@glimmer/reference';
import { ModifierManager } from '../../modifier/interfaces';
import { EvaluatedArgs } from '../../compiled/expressions/args';
import { AttributeManager } from '../../dom/attribute-managers';
import { ElementOperations } from '../../builder';
export declare class SimpleElementOperations implements ElementOperations {
    private env;
    private opcodes;
    private classList;
    constructor(env: Environment);
    addStaticAttribute(element: Simple.Element, name: string, value: string): void;
    addStaticAttributeNS(element: Simple.Element, namespace: string, name: string, value: string): void;
    addDynamicAttribute(element: Simple.Element, name: string, reference: PathReference<string>, isTrusting: boolean): void;
    addDynamicAttributeNS(element: Simple.Element, namespace: Simple.Namespace, name: string, reference: PathReference<string>, isTrusting: boolean): void;
    flush(element: Simple.Element, vm: VM): void;
    private addClass(reference);
    private addAttribute(attribute);
}
export declare class ComponentElementOperations implements ElementOperations {
    private env;
    private attributeNames;
    private attributes;
    private classList;
    constructor(env: Environment);
    addStaticAttribute(element: Simple.Element, name: string, value: string): void;
    addStaticAttributeNS(element: Simple.Element, namespace: string, name: string, value: string): void;
    addDynamicAttribute(element: Simple.Element, name: string, reference: PathReference<string>, isTrusting: boolean): void;
    addDynamicAttributeNS(element: Simple.Element, namespace: Simple.Namespace, name: string, reference: PathReference<string>, isTrusting: boolean): void;
    flush(element: Simple.Element, vm: VM): void;
    private shouldAddAttribute(name);
    private addClass(reference);
    private addAttribute(name, attribute);
}
export declare class UpdateModifierOpcode extends UpdatingOpcode {
    private manager;
    private modifier;
    private args;
    type: string;
    private lastUpdated;
    constructor(manager: ModifierManager<Opaque>, modifier: Opaque, args: EvaluatedArgs);
    evaluate(vm: UpdatingVM): void;
    toJSON(): OpcodeJSON;
}
export interface Attribute {
    name: string;
    flush(env: Environment): Option<UpdatingOpcode>;
}
export declare class StaticAttribute implements Attribute {
    private element;
    name: string;
    private value;
    private namespace;
    constructor(element: Simple.Element, name: string, value: string, namespace?: string);
    flush(env: Environment): Option<UpdatingOpcode>;
}
export declare class DynamicAttribute implements Attribute {
    private element;
    private attributeManager;
    name: string;
    private reference;
    private namespace;
    private cache;
    tag: RevisionTag;
    constructor(element: Simple.Element, attributeManager: AttributeManager, name: string, reference: Reference<Opaque>, namespace?: Simple.Namespace);
    patch(env: Environment): void;
    flush(env: Environment): Option<UpdatingOpcode>;
    toJSON(): Dict<Option<string>>;
}
export declare class PatchElementOpcode extends UpdatingOpcode {
    type: string;
    private operation;
    constructor(operation: DynamicAttribute);
    evaluate(vm: UpdatingVM): void;
    toJSON(): OpcodeJSON;
}
