import { UpdatingOpcode } from '../../opcodes';
import { ConstReference } from '@glimmer/reference';
import { initializeGuid } from '@glimmer/util';
import { CONSTANT_TAG, ReferenceCache, isConst, isModified } from '@glimmer/reference';
import { APPEND_OPCODES } from '../../opcodes';
APPEND_OPCODES.add(0 /* PushChildScope */, vm => vm.pushChildScope());
APPEND_OPCODES.add(1 /* PopScope */, vm => vm.popScope());
APPEND_OPCODES.add(2 /* PushDynamicScope */, vm => vm.pushDynamicScope());
APPEND_OPCODES.add(3 /* PopDynamicScope */, vm => vm.popDynamicScope());
APPEND_OPCODES.add(4 /* Put */, (vm, { op1: reference }) => {
    vm.frame.setOperand(vm.constants.getReference(reference));
});
APPEND_OPCODES.add(5 /* EvaluatePut */, (vm, { op1: expression }) => {
    let expr = vm.constants.getExpression(expression);
    vm.evaluateOperand(expr);
});
APPEND_OPCODES.add(6 /* PutArgs */, (vm, { op1: args }) => {
    vm.evaluateArgs(vm.constants.getExpression(args));
});
APPEND_OPCODES.add(7 /* BindPositionalArgs */, (vm, { op1: _symbols }) => {
    let symbols = vm.constants.getArray(_symbols);
    vm.bindPositionalArgs(symbols);
});
APPEND_OPCODES.add(8 /* BindNamedArgs */, (vm, { op1: _names, op2: _symbols }) => {
    let names = vm.constants.getArray(_names);
    let symbols = vm.constants.getArray(_symbols);
    vm.bindNamedArgs(names, symbols);
});
APPEND_OPCODES.add(9 /* BindBlocks */, (vm, { op1: _names, op2: _symbols }) => {
    let names = vm.constants.getArray(_names);
    let symbols = vm.constants.getArray(_symbols);
    vm.bindBlocks(names, symbols);
});
APPEND_OPCODES.add(10 /* BindPartialArgs */, (vm, { op1: symbol }) => {
    vm.bindPartialArgs(symbol);
});
APPEND_OPCODES.add(11 /* BindCallerScope */, vm => vm.bindCallerScope());
APPEND_OPCODES.add(12 /* BindDynamicScope */, (vm, { op1: _names }) => {
    let names = vm.constants.getArray(_names);
    vm.bindDynamicScope(names);
});
APPEND_OPCODES.add(13 /* Enter */, (vm, { op1: start, op2: end }) => vm.enter(start, end));
APPEND_OPCODES.add(14 /* Exit */, (vm) => vm.exit());
APPEND_OPCODES.add(15 /* Evaluate */, (vm, { op1: _block }) => {
    let block = vm.constants.getBlock(_block);
    let args = vm.frame.getArgs();
    vm.invokeBlock(block, args);
});
APPEND_OPCODES.add(16 /* Jump */, (vm, { op1: target }) => vm.goto(target));
APPEND_OPCODES.add(17 /* JumpIf */, (vm, { op1: target }) => {
    let reference = vm.frame.getCondition();
    if (isConst(reference)) {
        if (reference.value()) {
            vm.goto(target);
        }
    }
    else {
        let cache = new ReferenceCache(reference);
        if (cache.peek()) {
            vm.goto(target);
        }
        vm.updateWith(new Assert(cache));
    }
});
APPEND_OPCODES.add(18 /* JumpUnless */, (vm, { op1: target }) => {
    let reference = vm.frame.getCondition();
    if (isConst(reference)) {
        if (!reference.value()) {
            vm.goto(target);
        }
    }
    else {
        let cache = new ReferenceCache(reference);
        if (!cache.peek()) {
            vm.goto(target);
        }
        vm.updateWith(new Assert(cache));
    }
});
export const ConstTest = function (ref, _env) {
    return new ConstReference(!!ref.value());
};
export const SimpleTest = function (ref, _env) {
    return ref;
};
export const EnvironmentTest = function (ref, env) {
    return env.toConditionalReference(ref);
};
APPEND_OPCODES.add(19 /* Test */, (vm, { op1: _func }) => {
    let operand = vm.frame.getOperand();
    let func = vm.constants.getFunction(_func);
    vm.frame.setCondition(func(operand, vm.env));
});
export class Assert extends UpdatingOpcode {
    constructor(cache) {
        super();
        this.type = "assert";
        this.tag = cache.tag;
        this.cache = cache;
    }
    evaluate(vm) {
        let { cache } = this;
        if (isModified(cache.revalidate())) {
            vm.throw();
        }
    }
    toJSON() {
        let { type, _guid, cache } = this;
        let expected;
        try {
            expected = JSON.stringify(cache.peek());
        }
        catch (e) {
            expected = String(cache.peek());
        }
        return {
            guid: _guid,
            type,
            args: [],
            details: { expected }
        };
    }
}
export class JumpIfNotModifiedOpcode extends UpdatingOpcode {
    constructor(tag, target) {
        super();
        this.target = target;
        this.type = "jump-if-not-modified";
        this.tag = tag;
        this.lastRevision = tag.value();
    }
    evaluate(vm) {
        let { tag, target, lastRevision } = this;
        if (!vm.alwaysRevalidate && tag.validate(lastRevision)) {
            vm.goto(target);
        }
    }
    didModify() {
        this.lastRevision = this.tag.value();
    }
    toJSON() {
        return {
            guid: this._guid,
            type: this.type,
            args: [JSON.stringify(this.target.inspect())]
        };
    }
}
export class DidModifyOpcode extends UpdatingOpcode {
    constructor(target) {
        super();
        this.target = target;
        this.type = "did-modify";
        this.tag = CONSTANT_TAG;
    }
    evaluate() {
        this.target.didModify();
    }
}
export class LabelOpcode {
    constructor(label) {
        this.tag = CONSTANT_TAG;
        this.type = "label";
        this.label = null;
        this.prev = null;
        this.next = null;
        initializeGuid(this);
        if (label)
            this.label = label;
    }
    evaluate() { }
    inspect() {
        return `${this.label} [${this._guid}]`;
    }
    toJSON() {
        return {
            guid: this._guid,
            type: this.type,
            args: [JSON.stringify(this.inspect())]
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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