import { EvaluatedArgs } from '../compiled/expressions/args';
import { FunctionExpression } from '../compiled/expressions/function';
import { CompiledProgram } from '../compiled/blocks';
import { Layout } from '../scanner';
import Environment, { DynamicScope } from '../environment';
import { ElementOperations } from '../builder';
import Bounds from '../bounds';
import * as Simple from '../dom/interfaces';
import { Destroyable, Opaque } from '@glimmer/util';
import { PathReference, RevisionTag } from '@glimmer/reference';
export declare type Component = Opaque;
export declare type ComponentClass = any;
export interface ComponentManager<T extends Component> {
    prepareArgs(definition: ComponentDefinition<T>, args: EvaluatedArgs, dynamicScope: DynamicScope): EvaluatedArgs;
    create(env: Environment, definition: ComponentDefinition<T>, args: EvaluatedArgs, dynamicScope: DynamicScope, caller: PathReference<Opaque>, hasDefaultBlock: boolean): T;
    layoutFor(definition: ComponentDefinition<T>, component: T, env: Environment): CompiledProgram;
    getSelf(component: T): PathReference<Opaque>;
    didCreateElement(component: T, element: Simple.Element, operations: ElementOperations): void;
    didRenderLayout(component: T, bounds: Bounds): void;
    didCreate(component: T): void;
    getTag(component: T): RevisionTag;
    update(component: T, args: EvaluatedArgs, dynamicScope: DynamicScope): void;
    didUpdateLayout(component: T, bounds: Bounds): void;
    didUpdate(component: T): void;
    getDestructor(component: T): Destroyable;
}
export interface ComponentLayoutBuilder {
    env: Environment;
    tag: ComponentTagBuilder;
    attrs: ComponentAttrsBuilder;
    wrapLayout(layout: Layout): void;
    fromLayout(layout: Layout): void;
}
export interface ComponentTagBuilder {
    static(tagName: string): void;
    dynamic(tagName: FunctionExpression<string>): void;
}
export interface ComponentAttrsBuilder {
    static(name: string, value: string): void;
    dynamic(name: string, value: FunctionExpression<string>): void;
}
export declare function isComponentDefinition(obj: any): obj is ComponentDefinition<Opaque>;
export declare abstract class ComponentDefinition<T> {
    name: string;
    manager: ComponentManager<T>;
    ComponentClass: ComponentClass;
    constructor(name: string, manager: ComponentManager<T>, ComponentClass: ComponentClass);
}
