import { Opaque, Option } from '@glimmer/util';
import { DOMNamespace } from './helper';
import * as Simple from './interfaces';
import { Environment } from '../environment';
export declare function defaultManagers(element: Simple.Element, attr: string, _isTrusting: boolean, _namespace: Option<string>): AttributeManager;
export declare function defaultPropertyManagers(tagName: string, attr: string): AttributeManager;
export declare function defaultAttributeManagers(tagName: string, attr: string): AttributeManager;
export declare function readDOMAttr(element: Element, attr: string): any;
export declare class AttributeManager {
    attr: string;
    constructor(attr: string);
    setAttribute(env: Environment, element: Simple.Element, value: Opaque, namespace?: DOMNamespace): void;
    updateAttribute(env: Environment, element: Element, value: Opaque, namespace?: DOMNamespace): void;
}
export declare class PropertyManager extends AttributeManager {
    setAttribute(_env: Environment, element: Simple.Element, value: Opaque, _namespace?: DOMNamespace): void;
    protected removeAttribute(env: Environment, element: Element, namespace?: DOMNamespace): void;
    updateAttribute(env: Environment, element: Element, value: Opaque, namespace?: DOMNamespace): void;
}
export declare const INPUT_VALUE_PROPERTY_MANAGER: AttributeManager;
export declare const OPTION_SELECTED_MANAGER: AttributeManager;
