import { Bounds } from '../bounds';
import * as Simple from './interfaces';
import { Option } from '@glimmer/util';
export declare const SVG_NAMESPACE = "http://www.w3.org/2000/svg";
export declare const BLACKLIST_TABLE: any;
export declare function isWhitespace(string: string): boolean;
export declare function moveNodesBefore(source: Simple.Node, target: Simple.Element, nextSibling: Simple.Node): Option<Simple.Node>[];
export declare namespace DOM {
    type Node = Simple.Node;
    type Element = Simple.Element;
    type Document = Simple.Document;
    type Comment = Simple.Comment;
    type Text = Simple.Text;
    type Namespace = Simple.Namespace;
    type HTMLElement = Simple.HTMLElement;
    class TreeConstruction {
        protected document: Document;
        protected uselessElement: HTMLElement;
        constructor(document: Document);
        protected setupUselessElement(): void;
        createElement(tag: string, context?: Element): Element;
        createElementNS(namespace: Namespace, tag: string): Element;
        setAttribute(element: Element, name: string, value: string, namespace?: string): void;
        createTextNode(text: string): Text;
        createComment(data: string): Comment;
        insertBefore(parent: Element, node: Node, reference: Option<Node>): void;
        insertHTMLBefore(parent: Element, html: string, reference: Option<Node>): Bounds;
    }
    const DOMTreeConstruction: typeof TreeConstruction;
    type DOMTreeConstruction = TreeConstruction;
}
export declare class DOMChanges {
    protected document: HTMLDocument;
    protected namespace: Option<string>;
    private uselessElement;
    constructor(document: HTMLDocument);
    setAttribute(element: Simple.Element, name: string, value: string): void;
    setAttributeNS(element: Simple.Element, namespace: string, name: string, value: string): void;
    removeAttribute(element: Simple.Element, name: string): void;
    removeAttributeNS(element: Simple.Element, namespace: string, name: string): void;
    createTextNode(text: string): Simple.Text;
    createComment(data: string): Simple.Comment;
    createElement(tag: string, context?: Simple.Element): Simple.Element;
    insertHTMLBefore(_parent: Element, nextSibling: Node, html: string): Bounds;
    insertNodeBefore(parent: Simple.Element, node: Simple.Node, reference: Simple.Node): Bounds;
    insertTextBefore(parent: Simple.Element, nextSibling: Simple.Node, text: string): Simple.Text;
    insertBefore(element: Simple.Element, node: Simple.Node, reference: Option<Simple.Node>): void;
    insertAfter(element: Simple.Element, node: Simple.Node, reference: Simple.Node): void;
}
export declare function insertHTMLBefore(this: void, _useless: Simple.HTMLElement, _parent: Simple.Element, _nextSibling: Option<Simple.Node>, html: string): Bounds;
declare let helper: typeof DOMChanges;
export default helper;
export declare const DOMTreeConstruction: typeof DOM.TreeConstruction;
export declare type DOMTreeConstruction = DOM.DOMTreeConstruction;
export { Namespace as DOMNamespace } from './interfaces';
