import { ConstReference } from '@glimmer/reference';
export class PrimitiveReference extends ConstReference {
    constructor(value) {
        super(value);
    }
    static create(value) {
        if (value === undefined) {
            return UNDEFINED_REFERENCE;
        }
        else if (value === null) {
            return NULL_REFERENCE;
        }
        else if (value === true) {
            return TRUE_REFERENCE;
        }
        else if (value === false) {
            return FALSE_REFERENCE;
        }
        else if (typeof value === 'number') {
            return new ValueReference(value);
        }
        else {
            return new StringReference(value);
        }
    }
    get(_key) {
        return UNDEFINED_REFERENCE;
    }
}
class StringReference extends PrimitiveReference {
    constructor() {
        super(...arguments);
        this.lengthReference = null;
    }
    get(key) {
        if (key === 'length') {
            let { lengthReference } = this;
            if (lengthReference === null) {
                lengthReference = this.lengthReference = new ValueReference(this.inner.length);
            }
            return lengthReference;
        }
        else {
            return super.get(key);
        }
    }
}
class ValueReference extends PrimitiveReference {
    constructor(value) {
        super(value);
    }
}
export const UNDEFINED_REFERENCE = new ValueReference(undefined);
export const NULL_REFERENCE = new ValueReference(null);
const TRUE_REFERENCE = new ValueReference(true);
const FALSE_REFERENCE = new ValueReference(false);
export class ConditionalReference {
    constructor(inner) {
        this.inner = inner;
        this.tag = inner.tag;
    }
    value() {
        return this.toBool(this.inner.value());
    }
    toBool(value) {
        return !!value;
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVmZXJlbmNlcy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL2xpYi9yZWZlcmVuY2VzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBZSxjQUFjLEVBQTRCLE1BQU0sb0JBQW9CLENBQUM7QUFLM0YsTUFBTSx5QkFBK0MsU0FBUSxjQUFpQjtJQWlCNUUsWUFBc0IsS0FBUTtRQUM1QixLQUFLLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDZixDQUFDO0lBbEJELE1BQU0sQ0FBQyxNQUFNLENBQXNCLEtBQVE7UUFDekMsRUFBRSxDQUFDLENBQUMsS0FBSyxLQUFLLFNBQVMsQ0FBQyxDQUFDLENBQUM7WUFDeEIsTUFBTSxDQUFDLG1CQUE0QyxDQUFDO1FBQ3RELENBQUM7UUFBQyxJQUFJLENBQUMsRUFBRSxDQUFDLENBQUMsS0FBSyxLQUFLLElBQUksQ0FBQyxDQUFDLENBQUM7WUFDMUIsTUFBTSxDQUFDLGNBQXVDLENBQUM7UUFDakQsQ0FBQztRQUFDLElBQUksQ0FBQyxFQUFFLENBQUMsQ0FBQyxLQUFLLEtBQUssSUFBSSxDQUFDLENBQUMsQ0FBQztZQUMxQixNQUFNLENBQUMsY0FBdUMsQ0FBQztRQUNqRCxDQUFDO1FBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxDQUFDLEtBQUssS0FBSyxLQUFLLENBQUMsQ0FBQyxDQUFDO1lBQzNCLE1BQU0sQ0FBQyxlQUF3QyxDQUFDO1FBQ2xELENBQUM7UUFBQyxJQUFJLENBQUMsRUFBRSxDQUFDLENBQUMsT0FBTyxLQUFLLEtBQUssUUFBUSxDQUFDLENBQUMsQ0FBQztZQUNyQyxNQUFNLENBQUMsSUFBSSxjQUFjLENBQUMsS0FBZSxDQUEwQixDQUFDO1FBQ3RFLENBQUM7UUFBQyxJQUFJLENBQUMsQ0FBQztZQUNOLE1BQU0sQ0FBQyxJQUFJLGVBQWUsQ0FBQyxLQUFlLENBQWlDLENBQUM7UUFDOUUsQ0FBQztJQUNILENBQUM7SUFNRCxHQUFHLENBQUMsSUFBWTtRQUNkLE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQztJQUM3QixDQUFDO0NBQ0Y7QUFFRCxxQkFBc0IsU0FBUSxrQkFBMEI7SUFBeEQ7O1FBQ1Usb0JBQWUsR0FBdUMsSUFBSSxDQUFDO0lBZXJFLENBQUM7SUFiQyxHQUFHLENBQUMsR0FBVztRQUNiLEVBQUUsQ0FBQyxDQUFDLEdBQUcsS0FBSyxRQUFRLENBQUMsQ0FBQyxDQUFDO1lBQ3JCLElBQUksRUFBRSxlQUFlLEVBQUUsR0FBRyxJQUFJLENBQUM7WUFFL0IsRUFBRSxDQUFDLENBQUMsZUFBZSxLQUFLLElBQUksQ0FBQyxDQUFDLENBQUM7Z0JBQzdCLGVBQWUsR0FBRyxJQUFJLENBQUMsZUFBZSxHQUFHLElBQUksY0FBYyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLENBQUM7WUFDakYsQ0FBQztZQUVELE1BQU0sQ0FBQyxlQUFlLENBQUM7UUFDekIsQ0FBQztRQUFDLElBQUksQ0FBQyxDQUFDO1lBQ04sTUFBTSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsR0FBRyxDQUFDLENBQUM7UUFDeEIsQ0FBQztJQUNILENBQUM7Q0FDRjtBQUlELG9CQUFzQyxTQUFRLGtCQUFxQjtJQUNqRSxZQUFZLEtBQVE7UUFDbEIsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQ2YsQ0FBQztDQUNGO0FBRUQsTUFBTSxDQUFDLE1BQU0sbUJBQW1CLEdBQWtDLElBQUksY0FBYyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0FBQ2hHLE1BQU0sQ0FBQyxNQUFNLGNBQWMsR0FBNkIsSUFBSSxjQUFjLENBQUMsSUFBSSxDQUFDLENBQUM7QUFDakYsTUFBTSxjQUFjLEdBQWdDLElBQUksY0FBYyxDQUFDLElBQUksQ0FBQyxDQUFDO0FBQzdFLE1BQU0sZUFBZSxHQUFnQyxJQUFJLGNBQWMsQ0FBQyxLQUFLLENBQUMsQ0FBQztBQUUvRSxNQUFNO0lBR0osWUFBb0IsS0FBd0I7UUFBeEIsVUFBSyxHQUFMLEtBQUssQ0FBbUI7UUFDMUMsSUFBSSxDQUFDLEdBQUcsR0FBRyxLQUFLLENBQUMsR0FBRyxDQUFDO0lBQ3ZCLENBQUM7SUFFRCxLQUFLO1FBQ0gsTUFBTSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLEVBQUUsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7SUFFUyxNQUFNLENBQUMsS0FBYTtRQUM1QixNQUFNLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQztJQUNqQixDQUFDO0NBQ0YifQ==