import { dict } from '@glimmer/util';
export function entryPoint(meta) {
    return new ProgramSymbolTable(meta);
}
export function layout(meta, wireNamed, wireYields, hasPartials) {
    let { named, yields, partialSymbol, size } = symbols(wireNamed, wireYields, hasPartials);
    return new ProgramSymbolTable(meta, named, yields, partialSymbol, size);
}
export function block(parent, locals) {
    let localsMap = null;
    let program = parent['program'];
    if (locals.length !== 0) {
        let map = localsMap = dict();
        locals.forEach(l => map[l] = program.size++);
    }
    return new BlockSymbolTable(parent, program, localsMap);
}
function symbols(named, yields, hasPartials) {
    let yieldsMap = null;
    let namedMap = null;
    let size = 1;
    if (yields.length !== 0) {
        let map = yieldsMap = dict();
        yields.forEach(y => map[y] = size++);
    }
    if (named.length !== 0) {
        let map = namedMap = dict();
        named.forEach(y => map[y] = size++);
    }
    let partialSymbol = hasPartials ? size++ : null;
    return { named: namedMap, yields: yieldsMap, partialSymbol, size };
}
export class ProgramSymbolTable {
    constructor(meta, named = null, yields = null, partialArgs = null, size = 1) {
        this.meta = meta;
        this.named = named;
        this.yields = yields;
        this.partialArgs = partialArgs;
        this.size = size;
        this.program = this;
    }
    getMeta() {
        return this.meta;
    }
    getSymbols() {
        return {
            named: this.named,
            yields: this.yields,
            locals: null,
            partialArgs: this.partialArgs
        };
    }
    getSymbol(kind, name) {
        if (kind === 'local')
            return null;
        return this[kind] && this[kind][name];
    }
    getPartialArgs() {
        return this.partialArgs || 0;
    }
}
export class BlockSymbolTable {
    constructor(parent, program, locals) {
        this.parent = parent;
        this.program = program;
        this.locals = locals;
    }
    getMeta() {
        return this.program.getMeta();
    }
    getSymbols() {
        return {
            named: null,
            yields: null,
            locals: this.locals,
            partialArgs: null
        };
    }
    getSymbol(kind, name) {
        if (kind === 'local') {
            return this.getLocal(name);
        }
        else {
            return this.program.getSymbol(kind, name);
        }
    }
    getLocal(name) {
        let { locals, parent } = this;
        let symbol = locals && locals[name];
        if (!symbol && parent) {
            symbol = parent.getSymbol('local', name);
        }
        return symbol;
    }
    getPartialArgs() {
        return this.program.getPartialArgs();
    }
}
export const EMPTY_SYMBOL_TABLE = {
    getMeta() {
        return null;
    },
    getSymbols() {
        return {
            named: null,
            yields: null,
            locals: null,
            partialArgs: null
        };
    },
    getSymbol(_kind, _name) {
        throw new Error("BUG: Calling getSymbol on EMPTY_SYMBOL_TABLE");
    },
    getPartialArgs() {
        return null;
    }
};
//# sourceMappingURL=data:application/json;base64,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