import { SerializedTemplateWithLazyBlock, SerializedTemplateBlock } from '@glimmer/wire-format';
import { PathReference } from '@glimmer/reference';
import { SymbolTable } from '@glimmer/interfaces';
import { Environment, DynamicScope } from './environment';
import { VM, RenderResult, IteratorResult } from './vm';
import { EntryPoint, PartialBlock, Layout } from './scanner';
import * as Simple from './dom/interfaces';
/**
 * Environment specific template.
 */
export interface Template<T> {
    /**
     * Template identifier, if precompiled will be the id of the
     * precompiled template.
     */
    id: string;
    /**
     * Template meta (both compile time and environment specific).
     */
    meta: T;
    /**
     * Helper to render template as root entry point.
     */
    render(self: PathReference<any>, appendTo: Simple.Element, dynamicScope: DynamicScope): TemplateIterator;
    asEntryPoint(): EntryPoint;
    asLayout(): Layout;
    asPartial(symbols: SymbolTable): PartialBlock;
    _block: SerializedTemplateBlock;
}
export interface TemplateFactory<T, U> {
    /**
     * Template identifier, if precompiled will be the id of the
     * precompiled template.
     */
    id: string;
    /**
     * Compile time meta.
     */
    meta: T;
    /**
     * Used to create an environment specific singleton instance
     * of the template.
     *
     * @param {Environment} env glimmer Environment
     */
    create(env: Environment): Template<T>;
    /**
     * Used to create an environment specific singleton instance
     * of the template.
     *
     * @param {Environment} env glimmer Environment
     * @param {Object} meta environment specific injections into meta
     */
    create(env: Environment, meta: U): Template<T & U>;
}
export declare class TemplateIterator {
    private vm;
    constructor(vm: VM);
    next(): IteratorResult<RenderResult>;
}
/**
 * Wraps a template js in a template module to change it into a factory
 * that handles lazy parsing the template and to create per env singletons
 * of the template.
 */
export default function templateFactory<T>(serializedTemplate: SerializedTemplateWithLazyBlock<T>): TemplateFactory<T, T>;
export default function templateFactory<T, U>(serializedTemplate: SerializedTemplateWithLazyBlock<T>): TemplateFactory<T, U>;
