import { assign } from '@glimmer/util';
import { ElementStack } from './builder';
import { VM } from './vm';
import Scanner from './scanner';
export class TemplateIterator {
    constructor(vm) {
        this.vm = vm;
    }
    next() {
        return this.vm.next();
    }
}
let clientId = 0;
export default function templateFactory({ id: templateId, meta, block }) {
    let parsedBlock;
    let id = templateId || `client-${clientId++}`;
    let create = (env, envMeta) => {
        let newMeta = envMeta ? assign({}, envMeta, meta) : meta;
        if (!parsedBlock) {
            parsedBlock = JSON.parse(block);
        }
        return template(parsedBlock, id, newMeta, env);
    };
    return { id, meta, create };
}
function template(block, id, meta, env) {
    let scanner = new Scanner(block, meta, env);
    let entryPoint;
    let asEntryPoint = () => {
        if (!entryPoint)
            entryPoint = scanner.scanEntryPoint();
        return entryPoint;
    };
    let layout;
    let asLayout = () => {
        if (!layout)
            layout = scanner.scanLayout();
        return layout;
    };
    let asPartial = (symbols) => scanner.scanPartial(symbols);
    let render = (self, appendTo, dynamicScope) => {
        let elementStack = ElementStack.forInitialRender(env, appendTo, null);
        let compiled = asEntryPoint().compile(env);
        let vm = VM.initial(env, self, dynamicScope, elementStack, compiled);
        return new TemplateIterator(vm);
    };
    return { id, meta, _block: block, asEntryPoint, asLayout, asPartial, render };
}
//# sourceMappingURL=data:application/json;base64,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