import { Option, Dict } from '@glimmer/util';
export declare const EMPTY_ARRAY: ReadonlyArray<never>;
export declare const EMPTY_DICT: Dict<any>;
export interface EnumerableCallback<T> {
    (item: T): void;
}
export interface Enumerable<T> {
    forEach(callback: EnumerableCallback<T>): void;
}
export interface Destroyable {
    destroy(): void;
}
export interface Range<T> {
    min(): number;
    max(): number;
    at(index: number): Option<T>;
}
export declare class ListRange<T> implements Range<T> {
    private list;
    private start;
    private end;
    constructor(list: T[], start: number, end: number);
    at(index: number): Option<T>;
    min(): number;
    max(): number;
}
