import { dict, HAS_NATIVE_WEAKMAP } from '@glimmer/util';
export const EMPTY_ARRAY = HAS_NATIVE_WEAKMAP ? Object.freeze([]) : [];
export const EMPTY_DICT = HAS_NATIVE_WEAKMAP ? Object.freeze(dict()) : dict();
export class ListRange {
    constructor(list, start, end) {
        this.list = list;
        this.start = start;
        this.end = end;
    }
    at(index) {
        if (index >= this.list.length)
            return null;
        return this.list[index];
    }
    min() {
        return this.start;
    }
    max() {
        return this.end;
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9saWIvdXRpbHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFnQixJQUFJLEVBQUUsa0JBQWtCLEVBQUUsTUFBTSxlQUFlLENBQUM7QUFFdkUsTUFBTSxDQUFDLE1BQU0sV0FBVyxHQUFHLGtCQUFrQixHQUFHLE1BQU0sQ0FBQyxNQUFNLENBQUMsRUFBRSxDQUFDLEdBQUcsRUFBRSxDQUFDO0FBQ3ZFLE1BQU0sQ0FBQyxNQUFNLFVBQVUsR0FBYyxrQkFBa0IsR0FBRyxNQUFNLENBQUMsTUFBTSxDQUFDLElBQUksRUFBTyxDQUFDLEdBQUcsSUFBSSxFQUFPLENBQUM7QUFvQm5HLE1BQU07SUFPSixZQUFZLElBQVMsRUFBRSxLQUFhLEVBQUUsR0FBVztRQUMvQyxJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQztRQUNqQixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztRQUNuQixJQUFJLENBQUMsR0FBRyxHQUFHLEdBQUcsQ0FBQztJQUNqQixDQUFDO0lBRUQsRUFBRSxDQUFDLEtBQWE7UUFDZCxFQUFFLENBQUMsQ0FBQyxLQUFLLElBQUksSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUM7WUFBQyxNQUFNLENBQUMsSUFBSSxDQUFDO1FBQzNDLE1BQU0sQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQzFCLENBQUM7SUFFRCxHQUFHO1FBQ0QsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUM7SUFDcEIsQ0FBQztJQUVELEdBQUc7UUFDRCxNQUFNLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQztJQUNsQixDQUFDO0NBQ0YifQ==