import { Scope, DynamicScope, Environment, Opcode } from '../environment';
import { ElementStack } from '../builder';
import { Option, Destroyable, Stack, LinkedList, Opaque } from '@glimmer/util';
import { PathReference } from '@glimmer/reference';
import { CompiledBlock, CompiledProgram } from '../compiled/blocks';
import { InlineBlock, PartialBlock } from '../scanner';
import { CompiledExpression } from '../compiled/expressions';
import { CompiledArgs, EvaluatedArgs } from '../compiled/expressions/args';
import { Component, ComponentManager } from '../component/interfaces';
import { VMState, ListBlockOpcode } from './update';
import RenderResult from './render-result';
import { CapturedFrame, FrameStack } from './frame';
import { UpdatingOpcode, Constants, ConstantString } from '../opcodes';
export interface PublicVM {
    env: Environment;
    getArgs(): Option<EvaluatedArgs>;
    dynamicScope(): DynamicScope;
    getSelf(): PathReference<Opaque>;
    newDestroyable(d: Destroyable): void;
}
export interface IteratorResult<T> {
    value: T | null;
    done: boolean;
}
export default class VM implements PublicVM {
    env: Environment;
    private elementStack;
    private dynamicScopeStack;
    private scopeStack;
    updatingOpcodeStack: Stack<LinkedList<UpdatingOpcode>>;
    cacheGroups: Stack<Option<UpdatingOpcode>>;
    listBlockStack: Stack<ListBlockOpcode>;
    frame: FrameStack;
    constants: Constants;
    static initial(env: Environment, self: PathReference<Opaque>, dynamicScope: DynamicScope, elementStack: ElementStack, compiledProgram: CompiledProgram): VM;
    constructor(env: Environment, scope: Scope, dynamicScope: DynamicScope, elementStack: ElementStack);
    capture(): VMState;
    goto(ip: number): void;
    beginCacheGroup(): void;
    commitCacheGroup(): void;
    enter(start: number, end: number): void;
    enterWithKey(key: string, start: number, end: number): void;
    enterList(start: number, end: number): void;
    private didEnter(opcode, updating);
    exit(): void;
    exitList(): void;
    updateWith(opcode: UpdatingOpcode): void;
    listBlock(): ListBlockOpcode;
    updating(): LinkedList<UpdatingOpcode>;
    stack(): ElementStack;
    scope(): Scope;
    dynamicScope(): DynamicScope;
    pushFrame(block: CompiledBlock, args?: Option<EvaluatedArgs>, callerScope?: Scope): void;
    pushComponentFrame(layout: CompiledBlock, args: EvaluatedArgs, callerScope: Scope, component: Component, manager: ComponentManager<Component>, shadow: Option<InlineBlock>): void;
    pushEvalFrame(start: number, end: number): void;
    pushChildScope(): void;
    pushCallerScope(): void;
    pushDynamicScope(): DynamicScope;
    pushRootScope(self: PathReference<any>, size: number): Scope;
    popScope(): void;
    popDynamicScope(): void;
    newDestroyable(d: Destroyable): void;
    getSelf(): PathReference<any>;
    referenceForSymbol(symbol: number): PathReference<any>;
    getArgs(): Option<EvaluatedArgs>;
    resume(start: number, end: number, frame: CapturedFrame): RenderResult;
    execute(start: number, end: number, initialize?: (vm: VM) => void): RenderResult;
    private prepare(start, end, initialize?);
    next(): IteratorResult<RenderResult>;
    evaluateOpcode(opcode: Opcode): void;
    invokeBlock(block: InlineBlock, args: Option<EvaluatedArgs>): void;
    invokePartial(block: PartialBlock): void;
    invokeLayout(args: EvaluatedArgs, layout: CompiledBlock, callerScope: Scope, component: Component, manager: ComponentManager<Component>, shadow: Option<InlineBlock>): void;
    evaluateOperand(expr: CompiledExpression<any>): void;
    evaluateArgs(args: CompiledArgs): void;
    bindPositionalArgs(symbols: number[]): void;
    bindNamedArgs(names: ConstantString[], symbols: number[]): void;
    bindBlocks(names: ConstantString[], symbols: number[]): void;
    bindPartialArgs(symbol: number): void;
    bindCallerScope(): void;
    bindDynamicScope(names: ConstantString[]): void;
}
