import { Scope, Environment, Opcode } from '../environment';
import { Reference, PathReference, ReferenceIterator } from '@glimmer/reference';
import { Option } from '@glimmer/util';
import { InlineBlock } from '../scanner';
import { EvaluatedArgs } from '../compiled/expressions/args';
import { Component, ComponentManager } from '../component/interfaces';
export declare class CapturedFrame {
    operand: Option<PathReference<any>>;
    args: Option<EvaluatedArgs>;
    condition: Option<Reference<boolean>>;
    constructor(operand: Option<PathReference<any>>, args: Option<EvaluatedArgs>, condition: Option<Reference<boolean>>);
}
export interface Blocks {
    default: Option<InlineBlock>;
    inverse: Option<InlineBlock>;
}
export declare class FrameStack {
    private frames;
    private frame;
    private readonly currentFrame;
    push(start: number, end: number, component?: void | {} | null | undefined, manager?: Option<ComponentManager<Component>>, shadow?: Option<InlineBlock>): void;
    pop(): void;
    capture(): CapturedFrame;
    restore(frame: CapturedFrame): void;
    getStart(): number;
    getEnd(): number;
    getCurrent(): number;
    setCurrent(ip: number): number;
    getOperand<T>(): PathReference<T>;
    setOperand<T>(operand: PathReference<T>): PathReference<T>;
    getImmediate<T>(): T;
    setImmediate<T>(value: T): T;
    getArgs(): Option<EvaluatedArgs>;
    setArgs(args: EvaluatedArgs): EvaluatedArgs;
    getCondition(): Reference<boolean>;
    setCondition(condition: Reference<boolean>): Reference<boolean>;
    getIterator(): ReferenceIterator;
    setIterator(iterator: ReferenceIterator): ReferenceIterator;
    getKey(): Option<string>;
    setKey(key: string): string;
    getBlocks(): Blocks;
    setBlocks(blocks: Blocks): Blocks;
    getCallerScope(): Scope;
    setCallerScope(callerScope: Scope): Scope;
    getComponent(): Component;
    getManager(): ComponentManager<Component>;
    getShadow(): Option<InlineBlock>;
    goto(ip: number): void;
    nextStatement(env: Environment): Option<Opcode>;
}
