import { unwrap } from '@glimmer/util';
export class CapturedFrame {
    constructor(operand, args, condition) {
        this.operand = operand;
        this.args = args;
        this.condition = condition;
    }
}
class Frame {
    constructor(start, end, component = null, manager = null, shadow = null) {
        this.start = start;
        this.end = end;
        this.component = component;
        this.manager = manager;
        this.shadow = shadow;
        this.operand = null;
        this.immediate = null;
        this.args = null;
        this.callerScope = null;
        this.blocks = null;
        this.condition = null;
        this.iterator = null;
        this.key = null;
        this.ip = start;
    }
    capture() {
        return new CapturedFrame(this.operand, this.args, this.condition);
    }
    restore(frame) {
        this.operand = frame.operand;
        this.args = frame.args;
        this.condition = frame.condition;
    }
}
export class FrameStack {
    constructor() {
        this.frames = [];
        this.frame = -1;
    }
    get currentFrame() {
        return this.frames[this.frame];
    }
    push(start, end, component = null, manager = null, shadow = null) {
        let pos = ++this.frame;
        if (pos < this.frames.length) {
            let frame = this.frames[pos];
            frame.start = frame.ip = start;
            frame.end = end;
            frame.component = component;
            frame.manager = manager;
            frame.shadow = shadow;
            frame.operand = null;
            frame.immediate = null;
            frame.args = null;
            frame.callerScope = null;
            frame.blocks = null;
            frame.condition = null;
            frame.iterator = null;
            frame.key = null;
        }
        else {
            this.frames[pos] = new Frame(start, end, component, manager, shadow);
        }
    }
    pop() {
        this.frame--;
    }
    capture() {
        return this.currentFrame.capture();
    }
    restore(frame) {
        this.currentFrame.restore(frame);
    }
    getStart() {
        return this.currentFrame.start;
    }
    getEnd() {
        return this.currentFrame.end;
    }
    getCurrent() {
        return this.currentFrame.ip;
    }
    setCurrent(ip) {
        return this.currentFrame.ip = ip;
    }
    getOperand() {
        return unwrap(this.currentFrame.operand);
    }
    setOperand(operand) {
        return this.currentFrame.operand = operand;
    }
    getImmediate() {
        return this.currentFrame.immediate;
    }
    setImmediate(value) {
        return this.currentFrame.immediate = value;
    }
    // FIXME: These options are required in practice by the existing code, but
    // figure out why.
    getArgs() {
        return this.currentFrame.args;
    }
    setArgs(args) {
        return this.currentFrame.args = args;
    }
    getCondition() {
        return unwrap(this.currentFrame.condition);
    }
    setCondition(condition) {
        return this.currentFrame.condition = condition;
    }
    getIterator() {
        return unwrap(this.currentFrame.iterator);
    }
    setIterator(iterator) {
        return this.currentFrame.iterator = iterator;
    }
    getKey() {
        return this.currentFrame.key;
    }
    setKey(key) {
        return this.currentFrame.key = key;
    }
    getBlocks() {
        return unwrap(this.currentFrame.blocks);
    }
    setBlocks(blocks) {
        return this.currentFrame.blocks = blocks;
    }
    getCallerScope() {
        return unwrap(this.currentFrame.callerScope);
    }
    setCallerScope(callerScope) {
        return this.currentFrame.callerScope = callerScope;
    }
    getComponent() {
        return unwrap(this.currentFrame.component);
    }
    getManager() {
        return unwrap(this.currentFrame.manager);
    }
    getShadow() {
        return this.currentFrame.shadow;
    }
    goto(ip) {
        this.setCurrent(ip);
    }
    nextStatement(env) {
        while (this.frame !== -1) {
            let frame = this.frames[this.frame];
            let ip = frame.ip;
            let end = frame.end;
            if (ip < end) {
                let program = env.program;
                frame.ip += 4;
                return program.opcode(ip);
            }
            else {
                this.pop();
            }
        }
        return null;
    }
}
//# sourceMappingURL=data:application/json;base64,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