import { Scope, DynamicScope, Environment } from '../environment';
import { DestroyableBounds } from '../bounds';
import { Tracker, UpdatableTracker } from '../builder';
import { Option, LinkedList, Dict } from '@glimmer/util';
import { IterationArtifacts } from '@glimmer/reference';
import { Constants, OpcodeJSON, UpdatingOpcode, UpdatingOpSeq } from '../opcodes';
import { DOMChanges } from '../dom/helper';
import * as Simple from '../dom/interfaces';
import { CapturedFrame } from './frame';
import VM from './append';
export default class UpdatingVM {
    env: Environment;
    dom: DOMChanges;
    alwaysRevalidate: boolean;
    constants: Constants;
    private frameStack;
    constructor(env: Environment, {alwaysRevalidate}: {
        alwaysRevalidate?: boolean;
    });
    execute(opcodes: UpdatingOpSeq, handler: ExceptionHandler): void;
    private readonly frame;
    goto(op: UpdatingOpcode): void;
    try(ops: UpdatingOpSeq, handler: Option<ExceptionHandler>): void;
    throw(): void;
    evaluateOpcode(opcode: UpdatingOpcode): void;
}
export interface ExceptionHandler {
    handleException(): void;
}
export interface VMState {
    env: Environment;
    scope: Scope;
    dynamicScope: DynamicScope;
    frame: CapturedFrame;
}
export declare abstract class BlockOpcode extends UpdatingOpcode implements DestroyableBounds {
    start: number;
    end: number;
    type: string;
    next: null;
    prev: null;
    protected env: Environment;
    protected scope: Scope;
    protected dynamicScope: DynamicScope;
    protected frame: CapturedFrame;
    protected children: LinkedList<UpdatingOpcode>;
    protected bounds: DestroyableBounds;
    constructor(start: number, end: number, state: VMState, bounds: DestroyableBounds, children: LinkedList<UpdatingOpcode>);
    abstract didInitializeChildren(): void;
    parentElement(): Simple.Element;
    firstNode(): Option<Simple.Node>;
    lastNode(): Option<Simple.Node>;
    evaluate(vm: UpdatingVM): void;
    destroy(): void;
    didDestroy(): void;
    toJSON(): OpcodeJSON;
}
export declare class TryOpcode extends BlockOpcode implements ExceptionHandler {
    type: string;
    private _tag;
    protected bounds: UpdatableTracker;
    constructor(start: number, end: number, state: VMState, bounds: UpdatableTracker, children: LinkedList<UpdatingOpcode>);
    didInitializeChildren(): void;
    evaluate(vm: UpdatingVM): void;
    handleException(): void;
    toJSON(): OpcodeJSON;
}
export declare class ListBlockOpcode extends BlockOpcode {
    type: string;
    map: Dict<BlockOpcode>;
    artifacts: IterationArtifacts;
    private lastIterated;
    private _tag;
    constructor(start: number, end: number, state: VMState, bounds: Tracker, children: LinkedList<UpdatingOpcode>, artifacts: IterationArtifacts);
    didInitializeChildren(listDidChange?: boolean): void;
    evaluate(vm: UpdatingVM): void;
    vmForInsertion(nextSibling: Option<Simple.Node>): VM;
    toJSON(): OpcodeJSON;
}
