"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const handlebars_1 = require("handlebars");
const builders_1 = require("./builders");
const print_1 = require("./generation/print");
const traverse_1 = require("./traversal/traverse");
const walker_1 = require("./traversal/walker");
const simple_html_tokenizer_1 = require("simple-html-tokenizer");
const handlebars_node_visitors_1 = require("./parser/handlebars-node-visitors");
const tokenizer_event_handlers_1 = require("./parser/tokenizer-event-handlers");
exports.syntax = {
    parse: preprocess,
    builders: builders_1.default,
    print: print_1.default,
    traverse: traverse_1.default,
    Walker: walker_1.default
};
function preprocess(html, options) {
    let ast = (typeof html === 'object') ? html : handlebars_1.parse(html);
    let combined = new Parser(html, options).acceptNode(ast);
    if (options && options.plugins && options.plugins.ast) {
        for (let i = 0, l = options.plugins.ast.length; i < l; i++) {
            let plugin = new options.plugins.ast[i](options);
            plugin.syntax = exports.syntax;
            combined = plugin.transform(combined);
        }
    }
    return combined;
}
exports.preprocess = preprocess;
const entityParser = new simple_html_tokenizer_1.EntityParser(simple_html_tokenizer_1.HTML5NamedCharRefs);
class Parser {
    constructor(source, options = {}) {
        this.elementStack = [];
        this.currentAttribute = null;
        this.currentNode = null;
        this.tokenizer = new simple_html_tokenizer_1.EventedTokenizer(this, entityParser);
        this.options = options;
        if (typeof source === 'string') {
            this.source = source.split(/(?:\r\n?|\n)/g);
        }
    }
    acceptNode(node) {
        return this[node.type](node);
    }
    currentElement() {
        return this.elementStack[this.elementStack.length - 1];
    }
    sourceForMustache(mustache) {
        let firstLine = mustache.loc.start.line - 1;
        let lastLine = mustache.loc.end.line - 1;
        let currentLine = firstLine - 1;
        let firstColumn = mustache.loc.start.column + 2;
        let lastColumn = mustache.loc.end.column - 2;
        let string = [];
        let line;
        if (!this.source) {
            return '{{' + mustache.path.id.original + '}}';
        }
        while (currentLine < lastLine) {
            currentLine++;
            line = this.source[currentLine];
            if (currentLine === firstLine) {
                if (firstLine === lastLine) {
                    string.push(line.slice(firstColumn, lastColumn));
                }
                else {
                    string.push(line.slice(firstColumn));
                }
            }
            else if (currentLine === lastLine) {
                string.push(line.slice(0, lastColumn));
            }
            else {
                string.push(line);
            }
        }
        return string.join('\n');
    }
}
exports.Parser = Parser;
for (let key in handlebars_node_visitors_1.default) {
    Parser.prototype[key] = handlebars_node_visitors_1.default[key];
}
for (let key in tokenizer_event_handlers_1.default) {
    Parser.prototype[key] = tokenizer_event_handlers_1.default[key];
}
//# sourceMappingURL=data:application/json;base64,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