"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function TraversalError(message, node, parent, key) {
    this.name = "TraversalError";
    this.message = message;
    this.node = node;
    this.parent = parent;
    this.key = key;
}
TraversalError.prototype = Object.create(Error.prototype);
TraversalError.prototype.constructor = TraversalError;
exports.default = TraversalError;
function cannotRemoveNode(node, parent, key) {
    return new TraversalError("Cannot remove a node unless it is part of an array", node, parent, key);
}
exports.cannotRemoveNode = cannotRemoveNode;
function cannotReplaceNode(node, parent, key) {
    return new TraversalError("Cannot replace a node with multiple nodes unless it is part of an array", node, parent, key);
}
exports.cannotReplaceNode = cannotReplaceNode;
function cannotReplaceOrRemoveInKeyHandlerYet(node, key) {
    return new TraversalError("Replacing and removing in key handlers is not yet supported.", node, null, key);
}
exports.cannotReplaceOrRemoveInKeyHandlerYet = cannotReplaceOrRemoveInKeyHandlerYet;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXJyb3JzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vbGliL3RyYXZlcnNhbC9lcnJvcnMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSx3QkFBd0IsT0FBTyxFQUFFLElBQUksRUFBRSxNQUFNLEVBQUUsR0FBRztJQUNoRCxJQUFJLENBQUMsSUFBSSxHQUFHLGdCQUFnQixDQUFDO0lBQzdCLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTyxDQUFDO0lBQ3ZCLElBQUksQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDO0lBQ2pCLElBQUksQ0FBQyxNQUFNLEdBQUcsTUFBTSxDQUFDO0lBQ3JCLElBQUksQ0FBQyxHQUFHLEdBQUcsR0FBRyxDQUFDO0FBQ2pCLENBQUM7QUFFRCxjQUFjLENBQUMsU0FBUyxHQUFHLE1BQU0sQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0FBQzFELGNBQWMsQ0FBQyxTQUFTLENBQUMsV0FBVyxHQUFHLGNBQWMsQ0FBQztBQUV0RCxrQkFBZSxjQUFjLENBQUM7QUFFOUIsMEJBQWlDLElBQUksRUFBRSxNQUFNLEVBQUUsR0FBRztJQUNoRCxNQUFNLENBQUMsSUFBSSxjQUFjLENBQ3ZCLG9EQUFvRCxFQUNwRCxJQUFJLEVBQUUsTUFBTSxFQUFFLEdBQUcsQ0FDbEIsQ0FBQztBQUNKLENBQUM7QUFMRCw0Q0FLQztBQUVELDJCQUFrQyxJQUFJLEVBQUUsTUFBTSxFQUFFLEdBQUc7SUFDakQsTUFBTSxDQUFDLElBQUksY0FBYyxDQUN2Qix5RUFBeUUsRUFDekUsSUFBSSxFQUFFLE1BQU0sRUFBRSxHQUFHLENBQ2xCLENBQUM7QUFDSixDQUFDO0FBTEQsOENBS0M7QUFFRCw4Q0FBcUQsSUFBSSxFQUFFLEdBQUc7SUFDNUQsTUFBTSxDQUFDLElBQUksY0FBYyxDQUN2Qiw4REFBOEQsRUFDOUQsSUFBSSxFQUFFLElBQUksRUFBRSxHQUFHLENBQ2hCLENBQUM7QUFDSixDQUFDO0FBTEQsb0ZBS0MifQ==