import * as nodes from '../types/nodes';
export interface NodeVisitor {
    All?: NodeHandler<nodes.BaseNode>;
    Program?: NodeHandler<nodes.Program>;
    MustacheStatement?: NodeHandler<nodes.MustacheStatement>;
    BlockStatement?: NodeHandler<nodes.BlockStatement>;
    ElementModifierStatement?: NodeHandler<nodes.ElementModifierStatement>;
    PartialStatement?: NodeHandler<nodes.PartialStatement>;
    CommentStatement?: NodeHandler<nodes.CommentStatement>;
    MustacheCommentStatement?: NodeHandler<nodes.MustacheCommentStatement>;
    ElementNode?: NodeHandler<nodes.ElementNode>;
    AttrNode?: NodeHandler<nodes.AttrNode>;
    TextNode?: NodeHandler<nodes.TextNode>;
    ConcatStatement?: NodeHandler<nodes.ConcatStatement>;
    SubExpression?: NodeHandler<nodes.SubExpression>;
    PathExpression?: NodeHandler<nodes.PathExpression>;
    StringLiteral?: NodeHandler<nodes.StringLiteral>;
    BooleanLiteral?: NodeHandler<nodes.BooleanLiteral>;
    NumberLiteral?: NodeHandler<nodes.NumberLiteral>;
    UndefinedLiteral?: NodeHandler<nodes.UndefinedLiteral>;
    NullLiteral?: NodeHandler<nodes.NullLiteral>;
    Hash?: NodeHandler<nodes.Hash>;
    HashPair?: NodeHandler<nodes.HashPair>;
}
export declare type NodeHandler<T> = NodeHandlerFunction<T> | EnterExitNodeHandler<T>;
export interface NodeHandlerFunction<T> {
    (node: T): any;
}
export interface EnterExitNodeHandler<T> {
    enter: NodeHandlerFunction<T>;
    exit: NodeHandlerFunction<T>;
    keys: any;
}
export default function traverse(node: nodes.BaseNode, visitor: NodeVisitor): void;
export declare function normalizeVisitor(visitor: NodeVisitor): {};
