"use strict";
// Regex to validate the identifier for block parameters.
// Based on the ID validation regex in Handlebars.
Object.defineProperty(exports, "__esModule", { value: true });
let ID_INVERSE_PATTERN = /[!"#%-,\.\/;->@\[-\^`\{-~]/;
// Checks the element's attributes to see if it uses block params.
// If it does, registers the block params with the program and
// removes the corresponding attributes from the element.
function parseElementBlockParams(element) {
    let params = parseBlockParams(element);
    if (params)
        element.blockParams = params;
}
exports.parseElementBlockParams = parseElementBlockParams;
function parseBlockParams(element) {
    let l = element.attributes.length;
    let attrNames = [];
    for (let i = 0; i < l; i++) {
        attrNames.push(element.attributes[i].name);
    }
    let asIndex = attrNames.indexOf('as');
    if (asIndex !== -1 && l > asIndex && attrNames[asIndex + 1].charAt(0) === '|') {
        // Some basic validation, since we're doing the parsing ourselves
        let paramsString = attrNames.slice(asIndex).join(' ');
        if (paramsString.charAt(paramsString.length - 1) !== '|' || paramsString.match(/\|/g).length !== 2) {
            throw new Error('Invalid block parameters syntax: \'' + paramsString + '\'');
        }
        let params = [];
        for (let i = asIndex + 1; i < l; i++) {
            let param = attrNames[i].replace(/\|/g, '');
            if (param !== '') {
                if (ID_INVERSE_PATTERN.test(param)) {
                    throw new Error('Invalid identifier for block parameters: \'' + param + '\' in \'' + paramsString + '\'');
                }
                params.push(param);
            }
        }
        if (params.length === 0) {
            throw new Error('Cannot use zero block parameters: \'' + paramsString + '\'');
        }
        element.attributes = element.attributes.slice(0, asIndex);
        return params;
    }
}
function childrenFor(node) {
    if (node.type === 'Program') {
        return node.body;
    }
    if (node.type === 'ElementNode') {
        return node.children;
    }
}
exports.childrenFor = childrenFor;
function appendChild(parent, node) {
    childrenFor(parent).push(node);
}
exports.appendChild = appendChild;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9saWIvdXRpbHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLHlEQUF5RDtBQUN6RCxrREFBa0Q7O0FBRWxELElBQUksa0JBQWtCLEdBQUcsNEJBQTRCLENBQUM7QUFFdEQsa0VBQWtFO0FBQ2xFLDhEQUE4RDtBQUM5RCx5REFBeUQ7QUFFekQsaUNBQXdDLE9BQU87SUFDN0MsSUFBSSxNQUFNLEdBQUcsZ0JBQWdCLENBQUMsT0FBTyxDQUFDLENBQUM7SUFDdkMsRUFBRSxDQUFDLENBQUMsTUFBTSxDQUFDO1FBQUMsT0FBTyxDQUFDLFdBQVcsR0FBRyxNQUFNLENBQUM7QUFDM0MsQ0FBQztBQUhELDBEQUdDO0FBRUQsMEJBQTBCLE9BQU87SUFDL0IsSUFBSSxDQUFDLEdBQUcsT0FBTyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUM7SUFDbEMsSUFBSSxTQUFTLEdBQUcsRUFBRSxDQUFDO0lBRW5CLEdBQUcsQ0FBQyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUM7UUFDM0IsU0FBUyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxDQUFDO0lBQzdDLENBQUM7SUFFRCxJQUFJLE9BQU8sR0FBRyxTQUFTLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDO0lBRXRDLEVBQUUsQ0FBQyxDQUFDLE9BQU8sS0FBSyxDQUFDLENBQUMsSUFBSSxDQUFDLEdBQUcsT0FBTyxJQUFJLFNBQVMsQ0FBQyxPQUFPLEdBQUcsQ0FBQyxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxLQUFLLEdBQUcsQ0FBQyxDQUFDLENBQUM7UUFDOUUsaUVBQWlFO1FBQ2pFLElBQUksWUFBWSxHQUFHLFNBQVMsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQ3RELEVBQUUsQ0FBQyxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLE1BQU0sR0FBRyxDQUFDLENBQUMsS0FBSyxHQUFHLElBQUksWUFBWSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsQ0FBQyxNQUFNLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQztZQUNuRyxNQUFNLElBQUksS0FBSyxDQUFDLHFDQUFxQyxHQUFHLFlBQVksR0FBRyxJQUFJLENBQUMsQ0FBQztRQUMvRSxDQUFDO1FBRUQsSUFBSSxNQUFNLEdBQUcsRUFBRSxDQUFDO1FBQ2hCLEdBQUcsQ0FBQyxDQUFDLElBQUksQ0FBQyxHQUFHLE9BQU8sR0FBRyxDQUFDLEVBQUUsQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDO1lBQ3JDLElBQUksS0FBSyxHQUFHLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1lBQzVDLEVBQUUsQ0FBQyxDQUFDLEtBQUssS0FBSyxFQUFFLENBQUMsQ0FBQyxDQUFDO2dCQUNqQixFQUFFLENBQUMsQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDO29CQUNuQyxNQUFNLElBQUksS0FBSyxDQUFDLDZDQUE2QyxHQUFHLEtBQUssR0FBRyxVQUFVLEdBQUcsWUFBWSxHQUFHLElBQUksQ0FBQyxDQUFDO2dCQUM1RyxDQUFDO2dCQUNELE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUM7WUFDckIsQ0FBQztRQUNILENBQUM7UUFFRCxFQUFFLENBQUMsQ0FBQyxNQUFNLENBQUMsTUFBTSxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFDeEIsTUFBTSxJQUFJLEtBQUssQ0FBQyxzQ0FBc0MsR0FBRyxZQUFZLEdBQUcsSUFBSSxDQUFDLENBQUM7UUFDaEYsQ0FBQztRQUVELE9BQU8sQ0FBQyxVQUFVLEdBQUcsT0FBTyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsQ0FBQyxFQUFFLE9BQU8sQ0FBQyxDQUFDO1FBQzFELE1BQU0sQ0FBQyxNQUFNLENBQUM7SUFDaEIsQ0FBQztBQUNILENBQUM7QUFFRCxxQkFBNEIsSUFBSTtJQUM5QixFQUFFLENBQUMsQ0FBQyxJQUFJLENBQUMsSUFBSSxLQUFLLFNBQVMsQ0FBQyxDQUFDLENBQUM7UUFDNUIsTUFBTSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUM7SUFDbkIsQ0FBQztJQUNELEVBQUUsQ0FBQyxDQUFDLElBQUksQ0FBQyxJQUFJLEtBQUssYUFBYSxDQUFDLENBQUMsQ0FBQztRQUNoQyxNQUFNLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQztJQUN2QixDQUFDO0FBQ0gsQ0FBQztBQVBELGtDQU9DO0FBRUQscUJBQTRCLE1BQU0sRUFBRSxJQUFJO0lBQ3RDLFdBQVcsQ0FBQyxNQUFNLENBQUMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7QUFDakMsQ0FBQztBQUZELGtDQUVDIn0=