function TraversalError(message, node, parent, key) {
    this.name = "TraversalError";
    this.message = message;
    this.node = node;
    this.parent = parent;
    this.key = key;
}
TraversalError.prototype = Object.create(Error.prototype);
TraversalError.prototype.constructor = TraversalError;
export default TraversalError;
export function cannotRemoveNode(node, parent, key) {
    return new TraversalError("Cannot remove a node unless it is part of an array", node, parent, key);
}
export function cannotReplaceNode(node, parent, key) {
    return new TraversalError("Cannot replace a node with multiple nodes unless it is part of an array", node, parent, key);
}
export function cannotReplaceOrRemoveInKeyHandlerYet(node, key) {
    return new TraversalError("Replacing and removing in key handlers is not yet supported.", node, null, key);
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXJyb3JzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vbGliL3RyYXZlcnNhbC9lcnJvcnMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsd0JBQXdCLE9BQU8sRUFBRSxJQUFJLEVBQUUsTUFBTSxFQUFFLEdBQUc7SUFDaEQsSUFBSSxDQUFDLElBQUksR0FBRyxnQkFBZ0IsQ0FBQztJQUM3QixJQUFJLENBQUMsT0FBTyxHQUFHLE9BQU8sQ0FBQztJQUN2QixJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQztJQUNqQixJQUFJLENBQUMsTUFBTSxHQUFHLE1BQU0sQ0FBQztJQUNyQixJQUFJLENBQUMsR0FBRyxHQUFHLEdBQUcsQ0FBQztBQUNqQixDQUFDO0FBRUQsY0FBYyxDQUFDLFNBQVMsR0FBRyxNQUFNLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxTQUFTLENBQUMsQ0FBQztBQUMxRCxjQUFjLENBQUMsU0FBUyxDQUFDLFdBQVcsR0FBRyxjQUFjLENBQUM7QUFFdEQsZUFBZSxjQUFjLENBQUM7QUFFOUIsTUFBTSwyQkFBMkIsSUFBSSxFQUFFLE1BQU0sRUFBRSxHQUFHO0lBQ2hELE1BQU0sQ0FBQyxJQUFJLGNBQWMsQ0FDdkIsb0RBQW9ELEVBQ3BELElBQUksRUFBRSxNQUFNLEVBQUUsR0FBRyxDQUNsQixDQUFDO0FBQ0osQ0FBQztBQUVELE1BQU0sNEJBQTRCLElBQUksRUFBRSxNQUFNLEVBQUUsR0FBRztJQUNqRCxNQUFNLENBQUMsSUFBSSxjQUFjLENBQ3ZCLHlFQUF5RSxFQUN6RSxJQUFJLEVBQUUsTUFBTSxFQUFFLEdBQUcsQ0FDbEIsQ0FBQztBQUNKLENBQUM7QUFFRCxNQUFNLCtDQUErQyxJQUFJLEVBQUUsR0FBRztJQUM1RCxNQUFNLENBQUMsSUFBSSxjQUFjLENBQ3ZCLDhEQUE4RCxFQUM5RCxJQUFJLEVBQUUsSUFBSSxFQUFFLEdBQUcsQ0FDaEIsQ0FBQztBQUNKLENBQUMifQ==