"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const guid_1 = require("./guid");
let proto = Object.create(null, {
    // without this, we will always still end up with (new
    // EmptyObject()).constructor === Object
    constructor: {
        value: undefined,
        enumerable: false,
        writable: true
    }
});
function EmptyObject() { }
EmptyObject.prototype = proto;
function dict() {
    // let d = Object.create(null);
    // d.x = 1;
    // delete d.x;
    // return d;
    return new EmptyObject();
}
exports.dict = dict;
class DictSet {
    constructor() {
        this.dict = dict();
    }
    add(obj) {
        if (typeof obj === 'string')
            this.dict[obj] = obj;
        else
            this.dict[guid_1.ensureGuid(obj)] = obj;
        return this;
    }
    delete(obj) {
        if (typeof obj === 'string')
            delete this.dict[obj];
        else if (obj._guid)
            delete this.dict[obj._guid];
    }
    forEach(callback) {
        let { dict } = this;
        Object.keys(dict).forEach(key => callback(dict[key]));
    }
    toArray() {
        return Object.keys(this.dict);
    }
}
exports.DictSet = DictSet;
class Stack {
    constructor() {
        this.stack = [];
        this.current = null;
    }
    toArray() {
        return this.stack;
    }
    push(item) {
        this.current = item;
        this.stack.push(item);
    }
    pop() {
        let item = this.stack.pop();
        let len = this.stack.length;
        this.current = len === 0 ? null : this.stack[len - 1];
        return item === undefined ? null : item;
    }
    isEmpty() {
        return this.stack.length === 0;
    }
}
exports.Stack = Stack;
//# sourceMappingURL=data:application/json;base64,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