"use strict";
// There is a small whitelist of namespaced attributes specially
// enumerated in
// https://www.w3.org/TR/html/syntax.html#attributes-0
//
// > When a foreign element has one of the namespaced attributes given by
// > the local name and namespace of the first and second cells of a row
// > from the following table, it must be written using the name given by
// > the third cell from the same row.
//
// In all other cases, colons are interpreted as a regular character
// with no special meaning:
//
// > No other namespaced attribute can be expressed in the HTML syntax.
Object.defineProperty(exports, "__esModule", { value: true });
const XLINK = 'http://www.w3.org/1999/xlink';
const XML = 'http://www.w3.org/XML/1998/namespace';
const XMLNS = 'http://www.w3.org/2000/xmlns/';
const WHITELIST = {
    'xlink:actuate': XLINK,
    'xlink:arcrole': XLINK,
    'xlink:href': XLINK,
    'xlink:role': XLINK,
    'xlink:show': XLINK,
    'xlink:title': XLINK,
    'xlink:type': XLINK,
    'xml:base': XML,
    'xml:lang': XML,
    'xml:space': XML,
    'xmlns': XMLNS,
    'xmlns:xlink': XMLNS
};
function getAttrNamespace(attrName) {
    return WHITELIST[attrName] || null;
}
exports.getAttrNamespace = getAttrNamespace;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmFtZXNwYWNlcy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL2xpYi9uYW1lc3BhY2VzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQSxnRUFBZ0U7QUFDaEUsZ0JBQWdCO0FBQ2hCLHNEQUFzRDtBQUN0RCxFQUFFO0FBQ0YseUVBQXlFO0FBQ3pFLHdFQUF3RTtBQUN4RSx5RUFBeUU7QUFDekUsc0NBQXNDO0FBQ3RDLEVBQUU7QUFDRixvRUFBb0U7QUFDcEUsMkJBQTJCO0FBQzNCLEVBQUU7QUFDRix1RUFBdUU7O0FBRXZFLE1BQU0sS0FBSyxHQUFHLDhCQUE4QixDQUFDO0FBQzdDLE1BQU0sR0FBRyxHQUFHLHNDQUFzQyxDQUFDO0FBQ25ELE1BQU0sS0FBSyxHQUFHLCtCQUErQixDQUFDO0FBRTlDLE1BQU0sU0FBUyxHQUFHO0lBQ2hCLGVBQWUsRUFBRSxLQUFLO0lBQ3RCLGVBQWUsRUFBRSxLQUFLO0lBQ3RCLFlBQVksRUFBRSxLQUFLO0lBQ25CLFlBQVksRUFBRSxLQUFLO0lBQ25CLFlBQVksRUFBRSxLQUFLO0lBQ25CLGFBQWEsRUFBRSxLQUFLO0lBQ3BCLFlBQVksRUFBRSxLQUFLO0lBQ25CLFVBQVUsRUFBRSxHQUFHO0lBQ2YsVUFBVSxFQUFFLEdBQUc7SUFDZixXQUFXLEVBQUUsR0FBRztJQUNoQixPQUFPLEVBQUUsS0FBSztJQUNkLGFBQWEsRUFBRSxLQUFLO0NBQ3JCLENBQUM7QUFFRiwwQkFBaUMsUUFBZ0I7SUFDL0MsTUFBTSxDQUFDLFNBQVMsQ0FBQyxRQUFRLENBQUMsSUFBSSxJQUFJLENBQUM7QUFDckMsQ0FBQztBQUZELDRDQUVDIn0=