import { HasGuid } from './guid';
import { Option } from './platform-utils';
export interface Dict<T> {
    [index: string]: T;
}
export interface Set<T> {
    add(value: T): Set<T>;
    delete(value: T): void;
    forEach(callback: (item: T) => void): void;
}
export declare function dict<T>(): Dict<T>;
export declare type SetMember = HasGuid | string;
export declare class DictSet<T extends SetMember> implements Set<T> {
    private dict;
    constructor();
    add(obj: T): Set<T>;
    delete(obj: T): void;
    forEach(callback: (item: T) => void): void;
    toArray(): string[];
}
export declare class Stack<T> {
    private stack;
    current: Option<T>;
    toArray(): T[];
    push(item: T): void;
    pop(): Option<T>;
    isEmpty(): boolean;
}
