import { ensureGuid } from './guid';
let proto = Object.create(null, {
    // without this, we will always still end up with (new
    // EmptyObject()).constructor === Object
    constructor: {
        value: undefined,
        enumerable: false,
        writable: true
    }
});
function EmptyObject() { }
EmptyObject.prototype = proto;
export function dict() {
    // let d = Object.create(null);
    // d.x = 1;
    // delete d.x;
    // return d;
    return new EmptyObject();
}
export class DictSet {
    constructor() {
        this.dict = dict();
    }
    add(obj) {
        if (typeof obj === 'string')
            this.dict[obj] = obj;
        else
            this.dict[ensureGuid(obj)] = obj;
        return this;
    }
    delete(obj) {
        if (typeof obj === 'string')
            delete this.dict[obj];
        else if (obj._guid)
            delete this.dict[obj._guid];
    }
    forEach(callback) {
        let { dict } = this;
        Object.keys(dict).forEach(key => callback(dict[key]));
    }
    toArray() {
        return Object.keys(this.dict);
    }
}
export class Stack {
    constructor() {
        this.stack = [];
        this.current = null;
    }
    toArray() {
        return this.stack;
    }
    push(item) {
        this.current = item;
        this.stack.push(item);
    }
    pop() {
        let item = this.stack.pop();
        let len = this.stack.length;
        this.current = len === 0 ? null : this.stack[len - 1];
        return item === undefined ? null : item;
    }
    isEmpty() {
        return this.stack.length === 0;
    }
}
//# sourceMappingURL=data:application/json;base64,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