import { Option } from './platform-utils';
export interface Destroyable {
    destroy(): void;
}
export interface LinkedListNode {
    next: Option<LinkedListNode>;
    prev: Option<LinkedListNode>;
}
export declare class ListNode<T> implements LinkedListNode {
    next: Option<ListNode<T>>;
    prev: Option<ListNode<T>>;
    value: T;
    constructor(value: T);
}
export declare class LinkedList<T extends LinkedListNode> implements Slice<T> {
    static fromSlice<U extends CloneableListNode>(slice: Slice<U>): LinkedList<U>;
    private _head;
    private _tail;
    constructor();
    head(): Option<T>;
    tail(): Option<T>;
    clear(): void;
    isEmpty(): boolean;
    toArray(): T[];
    splice(start: T, end: T, reference: T): void;
    nextNode(node: T): T;
    prevNode(node: T): T;
    forEachNode(callback: (node: T) => void): void;
    contains(needle: T): boolean;
    insertBefore(node: T, reference?: Option<T>): T;
    append(node: T): T;
    pop(): Option<T>;
    prepend(node: T): T;
    remove(node: T): T;
}
export interface Slice<T extends LinkedListNode> {
    head(): Option<T>;
    tail(): Option<T>;
    nextNode(node: T): Option<T>;
    prevNode(node: T): Option<T>;
    forEachNode(callback: (node: T) => void): void;
    toArray(): T[];
    isEmpty(): boolean;
    contains(needle: T): boolean;
}
export interface CloneableListNode extends LinkedListNode {
    clone(): this;
}
export declare class ListSlice<T extends LinkedListNode> implements Slice<T> {
    static toList<U extends CloneableListNode>(slice: Slice<U>): LinkedList<U>;
    private _head;
    private _tail;
    constructor(head: Option<T>, tail: Option<T>);
    forEachNode(callback: (node: T) => void): void;
    contains(needle: T): boolean;
    head(): Option<T>;
    tail(): Option<T>;
    toArray(): T[];
    nextNode(node: T): Option<T>;
    prevNode(node: T): Option<T>;
    isEmpty(): boolean;
}
export declare const EMPTY_SLICE: ListSlice<LinkedListNode>;
