export declare enum LogLevel {
    Trace = 0,
    Debug = 1,
    Warn = 2,
    Error = 3,
}
export interface Console {
    log(message: string): void;
    warn(message: string): void;
    error(message: string): void;
    trace(): void;
}
export declare class Logger {
    private console;
    level: LogLevel;
    f: Logger;
    force: Logger;
    constructor({console, level}: {
        console: Console;
        level: LogLevel;
    });
    private skipped(level);
    trace(message?: any, {stackTrace}?: {
        stackTrace?: boolean;
    }): void;
    debug(message: any, {stackTrace}?: {
        stackTrace?: boolean;
    }): void;
    warn(message: any, {stackTrace}?: {
        stackTrace?: boolean;
    }): void;
    error(message: any | any[]): void;
}
declare var _default: Logger;
export default _default;
