"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const opcodes_1 = require("./lib/opcodes");
var opcodes_2 = require("./lib/opcodes");
exports.Ops = opcodes_2.Opcodes;
function is(variant) {
    return function (value) {
        return value[0] === variant;
    };
}
exports.is = is;
var Expressions;
(function (Expressions) {
    Expressions.isUnknown = is(opcodes_1.Opcodes.Unknown);
    Expressions.isArg = is(opcodes_1.Opcodes.Arg);
    Expressions.isGet = is(opcodes_1.Opcodes.Get);
    Expressions.isConcat = is(opcodes_1.Opcodes.Concat);
    Expressions.isHelper = is(opcodes_1.Opcodes.Helper);
    Expressions.isHasBlock = is(opcodes_1.Opcodes.HasBlock);
    Expressions.isHasBlockParams = is(opcodes_1.Opcodes.HasBlockParams);
    Expressions.isUndefined = is(opcodes_1.Opcodes.Undefined);
    function isPrimitiveValue(value) {
        if (value === null) {
            return true;
        }
        return typeof value !== 'object';
    }
    Expressions.isPrimitiveValue = isPrimitiveValue;
})(Expressions = exports.Expressions || (exports.Expressions = {}));
var Statements;
(function (Statements) {
    Statements.isText = is(opcodes_1.Opcodes.Text);
    Statements.isAppend = is(opcodes_1.Opcodes.Append);
    Statements.isComment = is(opcodes_1.Opcodes.Comment);
    Statements.isModifier = is(opcodes_1.Opcodes.Modifier);
    Statements.isBlock = is(opcodes_1.Opcodes.Block);
    Statements.isComponent = is(opcodes_1.Opcodes.Component);
    Statements.isOpenElement = is(opcodes_1.Opcodes.OpenElement);
    Statements.isFlushElement = is(opcodes_1.Opcodes.FlushElement);
    Statements.isCloseElement = is(opcodes_1.Opcodes.CloseElement);
    Statements.isStaticAttr = is(opcodes_1.Opcodes.StaticAttr);
    Statements.isDynamicAttr = is(opcodes_1.Opcodes.DynamicAttr);
    Statements.isYield = is(opcodes_1.Opcodes.Yield);
    Statements.isPartial = is(opcodes_1.Opcodes.Partial);
    Statements.isDynamicArg = is(opcodes_1.Opcodes.DynamicArg);
    Statements.isStaticArg = is(opcodes_1.Opcodes.StaticArg);
    Statements.isTrustingAttr = is(opcodes_1.Opcodes.TrustingAttr);
    Statements.isDebugger = is(opcodes_1.Opcodes.Debugger);
    function isAttribute(val) {
        return val[0] === opcodes_1.Opcodes.StaticAttr || val[0] === opcodes_1.Opcodes.DynamicAttr;
    }
    Statements.isAttribute = isAttribute;
    function isArgument(val) {
        return val[0] === opcodes_1.Opcodes.StaticArg || val[0] === opcodes_1.Opcodes.DynamicArg;
    }
    Statements.isArgument = isArgument;
    function isParameter(val) {
        return isAttribute(val) || isArgument(val);
    }
    Statements.isParameter = isParameter;
    function getParameterName(s) {
        return s[1];
    }
    Statements.getParameterName = getParameterName;
})(Statements = exports.Statements || (exports.Statements = {}));
//# sourceMappingURL=data:application/json;base64,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