import { Option } from '@glimmer/util';
import { Opcodes } from './lib/opcodes';
export { Opcodes as Ops } from './lib/opcodes';
export declare type str = string;
export declare type TemplateReference = Option<SerializedBlock>;
export declare type YieldTo = str;
export declare function is<T extends any[]>(variant: number): (value: any[]) => value is T;
export declare namespace Core {
    type Expression = Expressions.Expression;
    type Path = str[];
    type Params = Expression[];
    type Hash = Option<[str[], Expression[]]>;
    type Args = [Params, Hash];
}
export declare namespace Expressions {
    type Path = Core.Path;
    type Params = Core.Params;
    type Hash = Core.Hash;
    type Unknown = [Opcodes.Unknown, Path];
    type Arg = [Opcodes.Arg, Path];
    type Get = [Opcodes.Get, Path];
    type Value = str | number | boolean | null;
    type HasBlock = [Opcodes.HasBlock, str];
    type HasBlockParams = [Opcodes.HasBlockParams, str];
    type Undefined = [Opcodes.Undefined];
    type ClientSide = [Opcodes.Function, Function];
    type Expression = Unknown | Arg | Get | Concat | HasBlock | HasBlockParams | Helper | Undefined | Value | ClientSide;
    interface Concat extends Array<any> {
        [0]: Opcodes.Concat;
        [1]: Params;
    }
    interface Helper extends Array<any> {
        [0]: Opcodes.Helper;
        [1]: Path;
        [2]: Params;
        [3]: Hash;
    }
    const isUnknown: (value: any[]) => value is [Opcodes.Unknown, string[]];
    const isArg: (value: any[]) => value is [Opcodes.Arg, string[]];
    const isGet: (value: any[]) => value is [Opcodes.Get, string[]];
    const isConcat: (value: any[]) => value is Concat;
    const isHelper: (value: any[]) => value is Helper;
    const isHasBlock: (value: any[]) => value is [Opcodes.HasBlock, string];
    const isHasBlockParams: (value: any[]) => value is [Opcodes.HasBlockParams, string];
    const isUndefined: (value: any[]) => value is [Opcodes.Undefined];
    function isPrimitiveValue(value: any): value is Value;
}
export declare type Expression = Expressions.Expression;
export declare namespace Statements {
    type Expression = Expressions.Expression;
    type Params = Core.Params;
    type Hash = Core.Hash;
    type Path = Core.Path;
    type Text = [Opcodes.Text, str];
    type Append = [Opcodes.Append, Expression, boolean];
    type Comment = [Opcodes.Comment, str];
    type Modifier = [Opcodes.Modifier, Path, Params, Hash];
    type Block = [Opcodes.Block, Path, Params, Hash, Option<SerializedBlock>, Option<SerializedBlock>];
    type Component = [Opcodes.Component, str, SerializedComponent];
    type OpenElement = [Opcodes.OpenElement, str, str[]];
    type FlushElement = [Opcodes.FlushElement];
    type CloseElement = [Opcodes.CloseElement];
    type StaticAttr = [Opcodes.StaticAttr, str, Expression, Option<str>];
    type DynamicAttr = [Opcodes.DynamicAttr, str, Expression, Option<str>];
    type Yield = [Opcodes.Yield, YieldTo, Params];
    type Partial = [Opcodes.Partial, Expression];
    type DynamicArg = [Opcodes.DynamicArg, str, Expression];
    type StaticArg = [Opcodes.StaticArg, str, Expression];
    type TrustingAttr = [Opcodes.TrustingAttr, str, Expression, str];
    type Debugger = [Opcodes.Debugger];
    const isText: (value: any[]) => value is [Opcodes.Text, string];
    const isAppend: (value: any[]) => value is [Opcodes.Append, Expressions.Expression, boolean];
    const isComment: (value: any[]) => value is [Opcodes.Comment, string];
    const isModifier: (value: any[]) => value is [Opcodes.Modifier, string[], Expressions.Expression[], [string[], Expressions.Expression[]]];
    const isBlock: (value: any[]) => value is [Opcodes.Block, string[], Expressions.Expression[], [string[], Expressions.Expression[]], SerializedBlock, SerializedBlock];
    const isComponent: (value: any[]) => value is [Opcodes.Component, string, SerializedComponent];
    const isOpenElement: (value: any[]) => value is [Opcodes.OpenElement, string, string[]];
    const isFlushElement: (value: any[]) => value is [Opcodes.FlushElement];
    const isCloseElement: (value: any[]) => value is [Opcodes.CloseElement];
    const isStaticAttr: (value: any[]) => value is [Opcodes.StaticAttr, string, Expressions.Expression, string];
    const isDynamicAttr: (value: any[]) => value is [Opcodes.DynamicAttr, string, Expressions.Expression, string];
    const isYield: (value: any[]) => value is [Opcodes.Yield, string, Expressions.Expression[]];
    const isPartial: (value: any[]) => value is [Opcodes.Partial, Expressions.Expression];
    const isDynamicArg: (value: any[]) => value is [Opcodes.DynamicArg, string, Expressions.Expression];
    const isStaticArg: (value: any[]) => value is [Opcodes.StaticArg, string, Expressions.Expression];
    const isTrustingAttr: (value: any[]) => value is [Opcodes.TrustingAttr, string, Expressions.Expression, string];
    const isDebugger: (value: any[]) => value is [Opcodes.Debugger];
    type Statement = Text | Append | Comment | Modifier | Block | Component | OpenElement | FlushElement | CloseElement | StaticAttr | DynamicAttr | Yield | Partial | StaticArg | DynamicArg | TrustingAttr | Debugger;
    type Attribute = Statements.StaticAttr | Statements.DynamicAttr;
    function isAttribute(val: Statement): val is Attribute;
    type Argument = Statements.StaticArg | Statements.DynamicArg;
    function isArgument(val: Statement): val is Argument;
    type Parameter = Attribute | Argument;
    function isParameter(val: Statement): val is Parameter;
    function getParameterName(s: Parameter): string;
}
export declare type Statement = Statements.Statement;
/**
 * A JSON object of static compile time meta for the template.
 */
export interface TemplateMeta {
    moduleName?: string;
}
/**
 * A JSON object that the Block was serialized into.
 */
export interface SerializedBlock {
    statements: Statements.Statement[];
    locals: string[];
}
export interface SerializedComponent extends SerializedBlock {
    attrs: Statements.Attribute[];
    args: Core.Hash;
}
/**
 * A JSON object that the compiled TemplateBlock was serialized into.
 */
export interface SerializedTemplateBlock extends SerializedBlock {
    named: string[];
    yields: string[];
    hasPartials: boolean;
}
/**
 * A JSON object that the compiled Template was serialized into.
 */
export interface SerializedTemplate<T extends TemplateMeta> {
    block: SerializedTemplateBlock;
    meta: T;
}
/**
 * A string of JSON containing a SerializedTemplateBlock
 * @typedef {string} SerializedTemplateBlockJSON
 */
export declare type SerializedTemplateBlockJSON = string;
/**
 * A JSON object containing the SerializedTemplateBlock as JSON and TemplateMeta.
 */
export interface SerializedTemplateWithLazyBlock<T extends TemplateMeta> {
    id?: string;
    block: SerializedTemplateBlockJSON;
    meta: T;
}
/**
 * A string of Javascript containing a SerializedTemplateWithLazyBlock to be
 * concatenated into a Javascript module.
 * @typedef {string} TemplateJavascript
 */
export declare type TemplateJavascript = string;
