import { Opcodes } from './lib/opcodes';
export { Opcodes as Ops } from './lib/opcodes';
export function is(variant) {
    return function (value) {
        return value[0] === variant;
    };
}
export var Expressions;
(function (Expressions) {
    Expressions.isUnknown = is(Opcodes.Unknown);
    Expressions.isArg = is(Opcodes.Arg);
    Expressions.isGet = is(Opcodes.Get);
    Expressions.isConcat = is(Opcodes.Concat);
    Expressions.isHelper = is(Opcodes.Helper);
    Expressions.isHasBlock = is(Opcodes.HasBlock);
    Expressions.isHasBlockParams = is(Opcodes.HasBlockParams);
    Expressions.isUndefined = is(Opcodes.Undefined);
    function isPrimitiveValue(value) {
        if (value === null) {
            return true;
        }
        return typeof value !== 'object';
    }
    Expressions.isPrimitiveValue = isPrimitiveValue;
})(Expressions || (Expressions = {}));
export var Statements;
(function (Statements) {
    Statements.isText = is(Opcodes.Text);
    Statements.isAppend = is(Opcodes.Append);
    Statements.isComment = is(Opcodes.Comment);
    Statements.isModifier = is(Opcodes.Modifier);
    Statements.isBlock = is(Opcodes.Block);
    Statements.isComponent = is(Opcodes.Component);
    Statements.isOpenElement = is(Opcodes.OpenElement);
    Statements.isFlushElement = is(Opcodes.FlushElement);
    Statements.isCloseElement = is(Opcodes.CloseElement);
    Statements.isStaticAttr = is(Opcodes.StaticAttr);
    Statements.isDynamicAttr = is(Opcodes.DynamicAttr);
    Statements.isYield = is(Opcodes.Yield);
    Statements.isPartial = is(Opcodes.Partial);
    Statements.isDynamicArg = is(Opcodes.DynamicArg);
    Statements.isStaticArg = is(Opcodes.StaticArg);
    Statements.isTrustingAttr = is(Opcodes.TrustingAttr);
    Statements.isDebugger = is(Opcodes.Debugger);
    function isAttribute(val) {
        return val[0] === Opcodes.StaticAttr || val[0] === Opcodes.DynamicAttr;
    }
    Statements.isAttribute = isAttribute;
    function isArgument(val) {
        return val[0] === Opcodes.StaticArg || val[0] === Opcodes.DynamicArg;
    }
    Statements.isArgument = isArgument;
    function isParameter(val) {
        return isAttribute(val) || isArgument(val);
    }
    Statements.isParameter = isParameter;
    function getParameterName(s) {
        return s[1];
    }
    Statements.getParameterName = getParameterName;
})(Statements || (Statements = {}));
//# sourceMappingURL=data:application/json;base64,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