;(function() {
/*!
 * @overview  Ember - JavaScript Application Framework
 * @copyright Copyright 2011-2017 Tilde Inc. and contributors
 *            Portions Copyright 2006-2011 Strobe Inc.
 *            Portions Copyright 2008-2011 Apple Inc. All rights reserved.
 * @license   Licensed under MIT license
 *            See https://raw.github.com/emberjs/ember.js/master/LICENSE
 * @version   2.13.2
 */

var enifed, requireModule, Ember;
var mainContext = this; // Used in ember-environment/lib/global.js

(function() {
  var isNode = typeof window === 'undefined' &&
    typeof process !== 'undefined' && {}.toString.call(process) === '[object process]';

  if (!isNode) {
    Ember = this.Ember = this.Ember || {};
  }

  if (typeof Ember === 'undefined') { Ember = {}; }

  if (typeof Ember.__loader === 'undefined') {
    var registry = {};
    var seen = {};

    enifed = function(name, deps, callback) {
      var value = { };

      if (!callback) {
        value.deps = [];
        value.callback = deps;
      } else {
        value.deps = deps;
        value.callback = callback;
      }

      registry[name] = value;
    };

    requireModule = function(name) {
      return internalRequire(name, null);
    };

    // setup `require` module
    requireModule['default'] = requireModule;

    requireModule.has = function registryHas(moduleName) {
      return !!registry[moduleName] || !!registry[moduleName + '/index'];
    };

    function missingModule(name, referrerName) {
      if (referrerName) {
        throw new Error('Could not find module ' + name + ' required by: ' + referrerName);
      } else {
        throw new Error('Could not find module ' + name);
      }
    }

    function internalRequire(_name, referrerName) {
      var name = _name;
      var mod = registry[name];

      if (!mod) {
        name = name + '/index';
        mod = registry[name];
      }

      var exports = seen[name];

      if (exports !== undefined) {
        return exports;
      }

      exports = seen[name] = {};

      if (!mod) {
        missingModule(_name, referrerName);
      }

      var deps = mod.deps;
      var callback = mod.callback;
      var reified = new Array(deps.length);

      for (var i = 0; i < deps.length; i++) {
        if (deps[i] === 'exports') {
          reified[i] = exports;
        } else if (deps[i] === 'require') {
          reified[i] = requireModule;
        } else {
          reified[i] = internalRequire(deps[i], name);
        }
      }

      callback.apply(this, reified);

      return exports;
    }

    requireModule._eak_seen = registry;

    Ember.__loader = {
      define: enifed,
      require: requireModule,
      registry: registry
    };
  } else {
    enifed = Ember.__loader.define;
    requireModule = Ember.__loader.require;
  }
})();

function classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError('Cannot call a class as a function');
  }
}

function inherits(subClass, superClass) {
  if (typeof superClass !== 'function' && superClass !== null) {
    throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass);
  }

  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });

  if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : defaults(subClass, superClass);
}

function taggedTemplateLiteralLoose(strings, raw) {
  strings.raw = raw;
  return strings;
}

function defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ('value' in descriptor) descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}

function createClass(Constructor, protoProps, staticProps) {
  if (protoProps) defineProperties(Constructor.prototype, protoProps);
  if (staticProps) defineProperties(Constructor, staticProps);
  return Constructor;
}

function interopExportWildcard(obj, defaults) {
  var newObj = defaults({}, obj);
  delete newObj['default'];
  return newObj;
}

function defaults(obj, defaults) {
  var keys = Object.getOwnPropertyNames(defaults);
  for (var i = 0; i < keys.length; i++) {
    var key = keys[i];
    var value = Object.getOwnPropertyDescriptor(defaults, key);
    if (value && value.configurable && obj[key] === undefined) {
      Object.defineProperty(obj, key, value);
    }
  }
  return obj;
}

var babelHelpers = {
  classCallCheck: classCallCheck,
  inherits: inherits,
  taggedTemplateLiteralLoose: taggedTemplateLiteralLoose,
  slice: Array.prototype.slice,
  createClass: createClass,
  interopExportWildcard: interopExportWildcard,
  defaults: defaults
};

enifed('@glimmer/di', ['exports', '@glimmer/util'], function (exports, _glimmerUtil) {
    'use strict';

    var Container = (function () {
        function Container(registry) {
            var resolver = arguments.length <= 1 || arguments[1] === undefined ? null : arguments[1];

            this._registry = registry;
            this._resolver = resolver;
            this._lookups = _glimmerUtil.dict();
            this._factoryLookups = _glimmerUtil.dict();
        }

        Container.prototype.factoryFor = function factoryFor(specifier) {
            var factory = this._factoryLookups[specifier];
            if (!factory) {
                if (this._resolver) {
                    factory = this._resolver.retrieve(specifier);
                }
                if (!factory) {
                    factory = this._registry.registration(specifier);
                }
                if (factory) {
                    this._factoryLookups[specifier] = factory;
                }
            }
            return factory;
        };

        Container.prototype.lookup = function lookup(specifier) {
            var singleton = this._registry.registeredOption(specifier, 'singleton') !== false;
            if (singleton && this._lookups[specifier]) {
                return this._lookups[specifier];
            }
            var factory = this.factoryFor(specifier);
            if (!factory) {
                return;
            }
            if (this._registry.registeredOption(specifier, 'instantiate') === false) {
                return factory;
            }
            var injections = this.buildInjections(specifier);
            var object = factory.create(injections);
            if (singleton && object) {
                this._lookups[specifier] = object;
            }
            return object;
        };

        Container.prototype.defaultInjections = function defaultInjections(specifier) {
            return {};
        };

        Container.prototype.buildInjections = function buildInjections(specifier) {
            var hash = this.defaultInjections(specifier);
            var injections = this._registry.registeredInjections(specifier);
            var injection = undefined;
            for (var i = 0; i < injections.length; i++) {
                injection = injections[i];
                hash[injection.property] = this.lookup(injection.source);
            }
            return hash;
        };

        return Container;
    })();

    var Registry = (function () {
        function Registry() {
            this._registrations = _glimmerUtil.dict();
            this._registeredOptions = _glimmerUtil.dict();
            this._registeredInjections = _glimmerUtil.dict();
        }

        // TODO - use symbol

        Registry.prototype.register = function register(specifier, factory, options) {
            this._registrations[specifier] = factory;
            if (options) {
                this._registeredOptions[specifier] = options;
            }
        };

        Registry.prototype.registration = function registration(specifier) {
            return this._registrations[specifier];
        };

        Registry.prototype.unregister = function unregister(specifier) {
            delete this._registrations[specifier];
            delete this._registeredOptions[specifier];
            delete this._registeredInjections[specifier];
        };

        Registry.prototype.registerOption = function registerOption(specifier, option, value) {
            var options = this._registeredOptions[specifier];
            if (!options) {
                options = {};
                this._registeredOptions[specifier] = options;
            }
            options[option] = value;
        };

        Registry.prototype.registeredOption = function registeredOption(specifier, option) {
            var options = this.registeredOptions(specifier);
            if (options) {
                return options[option];
            }
        };

        Registry.prototype.registeredOptions = function registeredOptions(specifier) {
            var options = this._registeredOptions[specifier];
            if (options === undefined) {
                var _specifier$split = specifier.split(':');

                var type = _specifier$split[0];

                options = this._registeredOptions[type];
            }
            return options;
        };

        Registry.prototype.unregisterOption = function unregisterOption(specifier, option) {
            var options = this._registeredOptions[specifier];
            if (options) {
                delete options[option];
            }
        };

        Registry.prototype.registerInjection = function registerInjection(specifier, property, source) {
            var injections = this._registeredInjections[specifier];
            if (injections === undefined) {
                this._registeredInjections[specifier] = injections = [];
            }
            injections.push({
                property: property,
                source: source
            });
        };

        Registry.prototype.registeredInjections = function registeredInjections(specifier) {
            var _specifier$split2 = specifier.split(':');

            var type = _specifier$split2[0];

            var injections = [];
            Array.prototype.push.apply(injections, this._registeredInjections[type]);
            Array.prototype.push.apply(injections, this._registeredInjections[specifier]);
            return injections;
        };

        return Registry;
    })();

    var OWNER = '__owner__';
    function getOwner(object) {
        return object[OWNER];
    }
    function setOwner(object, owner) {
        object[OWNER] = owner;
    }

    function isSpecifierStringAbsolute(specifier) {
        var _specifier$split3 = specifier.split(':');

        var type = _specifier$split3[0];
        var path = _specifier$split3[1];

        return !!(type && path && path.indexOf('/') === 0 && path.split('/').length > 3);
    }
    function isSpecifierObjectAbsolute(specifier) {
        return specifier.rootName !== undefined && specifier.collection !== undefined && specifier.name !== undefined && specifier.type !== undefined;
    }
    function serializeSpecifier(specifier) {
        var type = specifier.type;
        var path = serializeSpecifierPath(specifier);
        if (path) {
            return type + ':' + path;
        } else {
            return type;
        }
    }
    function serializeSpecifierPath(specifier) {
        var path = [];
        if (specifier.rootName) {
            path.push(specifier.rootName);
        }
        if (specifier.collection) {
            path.push(specifier.collection);
        }
        if (specifier.namespace) {
            path.push(specifier.namespace);
        }
        if (specifier.name) {
            path.push(specifier.name);
        }
        if (path.length > 0) {
            var fullPath = path.join('/');
            if (isSpecifierObjectAbsolute(specifier)) {
                fullPath = '/' + fullPath;
            }
            return fullPath;
        }
    }
    function deserializeSpecifier(specifier) {
        var obj = {};
        if (specifier.indexOf(':') > -1) {
            var _specifier$split4 = specifier.split(':');

            var type = _specifier$split4[0];
            var path = _specifier$split4[1];

            obj.type = type;
            var pathSegments = undefined;
            if (path.indexOf('/') === 0) {
                pathSegments = path.substr(1).split('/');
                obj.rootName = pathSegments.shift();
                obj.collection = pathSegments.shift();
            } else {
                pathSegments = path.split('/');
            }
            if (pathSegments.length > 0) {
                obj.name = pathSegments.pop();
                if (pathSegments.length > 0) {
                    obj.namespace = pathSegments.join('/');
                }
            }
        } else {
            obj.type = specifier;
        }
        return obj;
    }

    exports.Container = Container;
    exports.Registry = Registry;
    exports.getOwner = getOwner;
    exports.setOwner = setOwner;
    exports.OWNER = OWNER;
    exports.isSpecifierStringAbsolute = isSpecifierStringAbsolute;
    exports.isSpecifierObjectAbsolute = isSpecifierObjectAbsolute;
    exports.serializeSpecifier = serializeSpecifier;
    exports.deserializeSpecifier = deserializeSpecifier;
});
enifed('@glimmer/node', ['exports', '@glimmer/runtime'], function (exports, _glimmerRuntime) {
    'use strict';

    var NodeDOMTreeConstruction = (function (_DOMTreeConstruction) {
        babelHelpers.inherits(NodeDOMTreeConstruction, _DOMTreeConstruction);

        function NodeDOMTreeConstruction(doc) {
            _DOMTreeConstruction.call(this, doc);
        }

        // override to prevent usage of `this.document` until after the constructor

        NodeDOMTreeConstruction.prototype.setupUselessElement = function setupUselessElement() {};

        NodeDOMTreeConstruction.prototype.insertHTMLBefore = function insertHTMLBefore(parent, html, reference) {
            var prev = reference ? reference.previousSibling : parent.lastChild;
            var raw = this.document.createRawHTMLSection(html);
            parent.insertBefore(raw, reference);
            var first = prev ? prev.nextSibling : parent.firstChild;
            var last = reference ? reference.previousSibling : parent.lastChild;
            return new _glimmerRuntime.ConcreteBounds(parent, first, last);
        };

        // override to avoid SVG detection/work when in node (this is not needed in SSR)

        NodeDOMTreeConstruction.prototype.createElement = function createElement(tag) {
            return this.document.createElement(tag);
        };

        // override to avoid namespace shenanigans when in node (this is not needed in SSR)

        NodeDOMTreeConstruction.prototype.setAttribute = function setAttribute(element, name, value) {
            element.setAttribute(name, value);
        };

        return NodeDOMTreeConstruction;
    })(_glimmerRuntime.DOMTreeConstruction);

    exports.NodeDOMTreeConstruction = NodeDOMTreeConstruction;
});
enifed("@glimmer/reference", ["exports", "@glimmer/util"], function (exports, _glimmerUtil) {
    "use strict";

    var CONSTANT = 0;
    var INITIAL = 1;
    var VOLATILE = NaN;

    var RevisionTag = (function () {
        function RevisionTag() {}

        RevisionTag.prototype.validate = function validate(snapshot) {
            return this.value() === snapshot;
        };

        return RevisionTag;
    })();

    var $REVISION = INITIAL;

    var DirtyableTag = (function (_RevisionTag) {
        babelHelpers.inherits(DirtyableTag, _RevisionTag);

        function DirtyableTag() {
            var revision = arguments.length <= 0 || arguments[0] === undefined ? $REVISION : arguments[0];

            _RevisionTag.call(this);
            this.revision = revision;
        }

        DirtyableTag.prototype.value = function value() {
            return this.revision;
        };

        DirtyableTag.prototype.dirty = function dirty() {
            this.revision = ++$REVISION;
        };

        return DirtyableTag;
    })(RevisionTag);

    function combineTagged(tagged) {
        var optimized = [];
        for (var i = 0, l = tagged.length; i < l; i++) {
            var tag = tagged[i].tag;
            if (tag === VOLATILE_TAG) return VOLATILE_TAG;
            if (tag === CONSTANT_TAG) continue;
            optimized.push(tag);
        }
        return _combine(optimized);
    }
    function combineSlice(slice) {
        var optimized = [];
        var node = slice.head();
        while (node !== null) {
            var tag = node.tag;
            if (tag === VOLATILE_TAG) return VOLATILE_TAG;
            if (tag !== CONSTANT_TAG) optimized.push(tag);
            node = slice.nextNode(node);
        }
        return _combine(optimized);
    }
    function combine(tags) {
        var optimized = [];
        for (var i = 0, l = tags.length; i < l; i++) {
            var tag = tags[i];
            if (tag === VOLATILE_TAG) return VOLATILE_TAG;
            if (tag === CONSTANT_TAG) continue;
            optimized.push(tag);
        }
        return _combine(optimized);
    }
    function _combine(tags) {
        switch (tags.length) {
            case 0:
                return CONSTANT_TAG;
            case 1:
                return tags[0];
            case 2:
                return new TagsPair(tags[0], tags[1]);
            default:
                return new TagsCombinator(tags);
        }
        ;
    }

    var CachedTag = (function (_RevisionTag2) {
        babelHelpers.inherits(CachedTag, _RevisionTag2);

        function CachedTag() {
            _RevisionTag2.apply(this, arguments);
            this.lastChecked = null;
            this.lastValue = null;
        }

        CachedTag.prototype.value = function value() {
            var lastChecked = this.lastChecked;
            var lastValue = this.lastValue;

            if (lastChecked !== $REVISION) {
                this.lastChecked = $REVISION;
                this.lastValue = lastValue = this.compute();
            }
            return this.lastValue;
        };

        CachedTag.prototype.invalidate = function invalidate() {
            this.lastChecked = null;
        };

        return CachedTag;
    })(RevisionTag);

    var TagsPair = (function (_CachedTag) {
        babelHelpers.inherits(TagsPair, _CachedTag);

        function TagsPair(first, second) {
            _CachedTag.call(this);
            this.first = first;
            this.second = second;
        }

        TagsPair.prototype.compute = function compute() {
            return Math.max(this.first.value(), this.second.value());
        };

        return TagsPair;
    })(CachedTag);

    var TagsCombinator = (function (_CachedTag2) {
        babelHelpers.inherits(TagsCombinator, _CachedTag2);

        function TagsCombinator(tags) {
            _CachedTag2.call(this);
            this.tags = tags;
        }

        TagsCombinator.prototype.compute = function compute() {
            var tags = this.tags;

            var max = -1;
            for (var i = 0; i < tags.length; i++) {
                var value = tags[i].value();
                max = Math.max(value, max);
            }
            return max;
        };

        return TagsCombinator;
    })(CachedTag);

    var UpdatableTag = (function (_CachedTag3) {
        babelHelpers.inherits(UpdatableTag, _CachedTag3);

        function UpdatableTag(tag) {
            _CachedTag3.call(this);
            this.tag = tag;
            this.lastUpdated = INITIAL;
        }

        //////////

        UpdatableTag.prototype.compute = function compute() {
            return Math.max(this.lastUpdated, this.tag.value());
        };

        UpdatableTag.prototype.update = function update(tag) {
            if (tag !== this.tag) {
                this.tag = tag;
                this.lastUpdated = $REVISION;
                this.invalidate();
            }
        };

        return UpdatableTag;
    })(CachedTag);

    var CONSTANT_TAG = new ((function (_RevisionTag3) {
        babelHelpers.inherits(ConstantTag, _RevisionTag3);

        function ConstantTag() {
            _RevisionTag3.apply(this, arguments);
        }

        ConstantTag.prototype.value = function value() {
            return CONSTANT;
        };

        return ConstantTag;
    })(RevisionTag))();
    var VOLATILE_TAG = new ((function (_RevisionTag4) {
        babelHelpers.inherits(VolatileTag, _RevisionTag4);

        function VolatileTag() {
            _RevisionTag4.apply(this, arguments);
        }

        VolatileTag.prototype.value = function value() {
            return VOLATILE;
        };

        return VolatileTag;
    })(RevisionTag))();
    var CURRENT_TAG = new ((function (_DirtyableTag) {
        babelHelpers.inherits(CurrentTag, _DirtyableTag);

        function CurrentTag() {
            _DirtyableTag.apply(this, arguments);
        }

        CurrentTag.prototype.value = function value() {
            return $REVISION;
        };

        return CurrentTag;
    })(DirtyableTag))();

    var CachedReference = (function () {
        function CachedReference() {
            this.lastRevision = null;
            this.lastValue = null;
        }

        CachedReference.prototype.value = function value() {
            var tag = this.tag;
            var lastRevision = this.lastRevision;
            var lastValue = this.lastValue;

            if (!lastRevision || !tag.validate(lastRevision)) {
                lastValue = this.lastValue = this.compute();
                this.lastRevision = tag.value();
            }
            return lastValue;
        };

        CachedReference.prototype.invalidate = function invalidate() {
            this.lastRevision = null;
        };

        return CachedReference;
    })();

    var MapperReference = (function (_CachedReference) {
        babelHelpers.inherits(MapperReference, _CachedReference);

        function MapperReference(reference, mapper) {
            _CachedReference.call(this);
            this.tag = reference.tag;
            this.reference = reference;
            this.mapper = mapper;
        }

        MapperReference.prototype.compute = function compute() {
            var reference = this.reference;
            var mapper = this.mapper;

            return mapper(reference.value());
        };

        return MapperReference;
    })(CachedReference);

    function map(reference, mapper) {
        return new MapperReference(reference, mapper);
    }
    //////////

    var ReferenceCache = (function () {
        function ReferenceCache(reference) {
            this.lastValue = null;
            this.lastRevision = null;
            this.initialized = false;
            this.tag = reference.tag;
            this.reference = reference;
        }

        ReferenceCache.prototype.peek = function peek() {
            if (!this.initialized) {
                return this.initialize();
            }
            return this.lastValue;
        };

        ReferenceCache.prototype.revalidate = function revalidate() {
            if (!this.initialized) {
                return this.initialize();
            }
            var reference = this.reference;
            var lastRevision = this.lastRevision;

            var tag = reference.tag;
            if (tag.validate(lastRevision)) return NOT_MODIFIED;
            this.lastRevision = tag.value();
            var lastValue = this.lastValue;

            var value = reference.value();
            if (value === lastValue) return NOT_MODIFIED;
            this.lastValue = value;
            return value;
        };

        ReferenceCache.prototype.initialize = function initialize() {
            var reference = this.reference;

            var value = this.lastValue = reference.value();
            this.lastRevision = reference.tag.value();
            this.initialized = true;
            return value;
        };

        return ReferenceCache;
    })();

    var NOT_MODIFIED = "adb3b78e-3d22-4e4b-877a-6317c2c5c145";
    function isModified(value) {
        return value !== NOT_MODIFIED;
    }

    var ConstReference = (function () {
        function ConstReference(inner) {
            this.inner = inner;
            this.tag = CONSTANT_TAG;
        }

        ConstReference.prototype.value = function value() {
            return this.inner;
        };

        return ConstReference;
    })();

    function isConst(reference) {
        return reference.tag === CONSTANT_TAG;
    }

    var ListItem = (function (_ListNode) {
        babelHelpers.inherits(ListItem, _ListNode);

        function ListItem(iterable, result) {
            _ListNode.call(this, iterable.valueReferenceFor(result));
            this.retained = false;
            this.seen = false;
            this.key = result.key;
            this.iterable = iterable;
            this.memo = iterable.memoReferenceFor(result);
        }

        ListItem.prototype.update = function update(item) {
            this.retained = true;
            this.iterable.updateValueReference(this.value, item);
            this.iterable.updateMemoReference(this.memo, item);
        };

        ListItem.prototype.shouldRemove = function shouldRemove() {
            return !this.retained;
        };

        ListItem.prototype.reset = function reset() {
            this.retained = false;
            this.seen = false;
        };

        return ListItem;
    })(_glimmerUtil.ListNode);

    var IterationArtifacts = (function () {
        function IterationArtifacts(iterable) {
            this.map = _glimmerUtil.dict();
            this.list = new _glimmerUtil.LinkedList();
            this.tag = iterable.tag;
            this.iterable = iterable;
        }

        IterationArtifacts.prototype.isEmpty = function isEmpty() {
            var iterator = this.iterator = this.iterable.iterate();
            return iterator.isEmpty();
        };

        IterationArtifacts.prototype.iterate = function iterate() {
            var iterator = this.iterator || this.iterable.iterate();
            this.iterator = null;
            return iterator;
        };

        IterationArtifacts.prototype.has = function has(key) {
            return !!this.map[key];
        };

        IterationArtifacts.prototype.get = function get(key) {
            return this.map[key];
        };

        IterationArtifacts.prototype.wasSeen = function wasSeen(key) {
            var node = this.map[key];
            return node && node.seen;
        };

        IterationArtifacts.prototype.append = function append(item) {
            var map = this.map;
            var list = this.list;
            var iterable = this.iterable;

            var node = map[item.key] = new ListItem(iterable, item);
            list.append(node);
            return node;
        };

        IterationArtifacts.prototype.insertBefore = function insertBefore(item, reference) {
            var map = this.map;
            var list = this.list;
            var iterable = this.iterable;

            var node = map[item.key] = new ListItem(iterable, item);
            node.retained = true;
            list.insertBefore(node, reference);
            return node;
        };

        IterationArtifacts.prototype.move = function move(item, reference) {
            var list = this.list;

            item.retained = true;
            list.remove(item);
            list.insertBefore(item, reference);
        };

        IterationArtifacts.prototype.remove = function remove(item) {
            var list = this.list;

            list.remove(item);
            delete this.map[item.key];
        };

        IterationArtifacts.prototype.nextNode = function nextNode(item) {
            return this.list.nextNode(item);
        };

        IterationArtifacts.prototype.head = function head() {
            return this.list.head();
        };

        return IterationArtifacts;
    })();

    var ReferenceIterator = (function () {
        // if anyone needs to construct this object with something other than
        // an iterable, let @wycats know.

        function ReferenceIterator(iterable) {
            this.iterator = null;
            var artifacts = new IterationArtifacts(iterable);
            this.artifacts = artifacts;
        }

        ReferenceIterator.prototype.next = function next() {
            var artifacts = this.artifacts;

            var iterator = this.iterator = this.iterator || artifacts.iterate();
            var item = iterator.next();
            if (!item) return null;
            return artifacts.append(item);
        };

        return ReferenceIterator;
    })();

    var Phase;
    (function (Phase) {
        Phase[Phase["Append"] = 0] = "Append";
        Phase[Phase["Prune"] = 1] = "Prune";
        Phase[Phase["Done"] = 2] = "Done";
    })(Phase || (Phase = {}));

    var IteratorSynchronizer = (function () {
        function IteratorSynchronizer(_ref) {
            var target = _ref.target;
            var artifacts = _ref.artifacts;

            this.target = target;
            this.artifacts = artifacts;
            this.iterator = artifacts.iterate();
            this.current = artifacts.head();
        }

        IteratorSynchronizer.prototype.sync = function sync() {
            var phase = Phase.Append;
            while (true) {
                switch (phase) {
                    case Phase.Append:
                        phase = this.nextAppend();
                        break;
                    case Phase.Prune:
                        phase = this.nextPrune();
                        break;
                    case Phase.Done:
                        this.nextDone();
                        return;
                }
            }
        };

        IteratorSynchronizer.prototype.advanceToKey = function advanceToKey(key) {
            var current = this.current;
            var artifacts = this.artifacts;

            var seek = current;
            while (seek && seek.key !== key) {
                seek.seen = true;
                seek = artifacts.nextNode(seek);
            }
            this.current = seek && artifacts.nextNode(seek);
        };

        IteratorSynchronizer.prototype.nextAppend = function nextAppend() {
            var iterator = this.iterator;
            var current = this.current;
            var artifacts = this.artifacts;

            var item = iterator.next();
            if (item === null) {
                return this.startPrune();
            }
            var key = item.key;

            if (current && current.key === key) {
                this.nextRetain(item);
            } else if (artifacts.has(key)) {
                this.nextMove(item);
            } else {
                this.nextInsert(item);
            }
            return Phase.Append;
        };

        IteratorSynchronizer.prototype.nextRetain = function nextRetain(item) {
            var artifacts = this.artifacts;
            var current = this.current;

            current = _glimmerUtil.expect(current, 'BUG: current is empty');
            current.update(item);
            this.current = artifacts.nextNode(current);
            this.target.retain(item.key, current.value, current.memo);
        };

        IteratorSynchronizer.prototype.nextMove = function nextMove(item) {
            var current = this.current;
            var artifacts = this.artifacts;
            var target = this.target;
            var key = item.key;

            var found = artifacts.get(item.key);
            found.update(item);
            if (artifacts.wasSeen(item.key)) {
                artifacts.move(found, current);
                target.move(found.key, found.value, found.memo, current ? current.key : null);
            } else {
                this.advanceToKey(key);
            }
        };

        IteratorSynchronizer.prototype.nextInsert = function nextInsert(item) {
            var artifacts = this.artifacts;
            var target = this.target;
            var current = this.current;

            var node = artifacts.insertBefore(item, current);
            target.insert(node.key, node.value, node.memo, current ? current.key : null);
        };

        IteratorSynchronizer.prototype.startPrune = function startPrune() {
            this.current = this.artifacts.head();
            return Phase.Prune;
        };

        IteratorSynchronizer.prototype.nextPrune = function nextPrune() {
            var artifacts = this.artifacts;
            var target = this.target;
            var current = this.current;

            if (current === null) {
                return Phase.Done;
            }
            var node = current;
            this.current = artifacts.nextNode(node);
            if (node.shouldRemove()) {
                artifacts.remove(node);
                target.delete(node.key);
            } else {
                node.reset();
            }
            return Phase.Prune;
        };

        IteratorSynchronizer.prototype.nextDone = function nextDone() {
            this.target.done();
        };

        return IteratorSynchronizer;
    })();

    function referenceFromParts(root, parts) {
        var reference = root;
        for (var i = 0; i < parts.length; i++) {
            reference = reference.get(parts[i]);
        }
        return reference;
    }

    exports.ConstReference = ConstReference;
    exports.isConst = isConst;
    exports.ListItem = ListItem;
    exports.referenceFromParts = referenceFromParts;
    exports.IterationArtifacts = IterationArtifacts;
    exports.ReferenceIterator = ReferenceIterator;
    exports.IteratorSynchronizer = IteratorSynchronizer;
    exports.CONSTANT = CONSTANT;
    exports.INITIAL = INITIAL;
    exports.VOLATILE = VOLATILE;
    exports.RevisionTag = RevisionTag;
    exports.DirtyableTag = DirtyableTag;
    exports.combineTagged = combineTagged;
    exports.combineSlice = combineSlice;
    exports.combine = combine;
    exports.CachedTag = CachedTag;
    exports.UpdatableTag = UpdatableTag;
    exports.CONSTANT_TAG = CONSTANT_TAG;
    exports.VOLATILE_TAG = VOLATILE_TAG;
    exports.CURRENT_TAG = CURRENT_TAG;
    exports.CachedReference = CachedReference;
    exports.map = map;
    exports.ReferenceCache = ReferenceCache;
    exports.isModified = isModified;
});
enifed('@glimmer/runtime',['exports','@glimmer/util','@glimmer/reference','@glimmer/wire-format'],function(exports,_glimmerUtil,_glimmerReference,_glimmerWireFormat){'use strict';var PrimitiveReference=(function(_ConstReference){babelHelpers.inherits(PrimitiveReference,_ConstReference);function PrimitiveReference(value){_ConstReference.call(this,value);}PrimitiveReference.create = function create(value){if(value === undefined){return UNDEFINED_REFERENCE;}else if(value === null){return NULL_REFERENCE;}else if(value === true){return TRUE_REFERENCE;}else if(value === false){return FALSE_REFERENCE;}else if(typeof value === 'number'){return new ValueReference(value);}else {return new StringReference(value);}};PrimitiveReference.prototype.get = function get(_key){return UNDEFINED_REFERENCE;};return PrimitiveReference;})(_glimmerReference.ConstReference);var StringReference=(function(_PrimitiveReference){babelHelpers.inherits(StringReference,_PrimitiveReference);function StringReference(){_PrimitiveReference.apply(this,arguments);this.lengthReference = null;}StringReference.prototype.get = function get(key){if(key === 'length'){var lengthReference=this.lengthReference;if(lengthReference === null){lengthReference = this.lengthReference = new ValueReference(this.inner.length);}return lengthReference;}else {return _PrimitiveReference.prototype.get.call(this,key);}};return StringReference;})(PrimitiveReference);var ValueReference=(function(_PrimitiveReference2){babelHelpers.inherits(ValueReference,_PrimitiveReference2);function ValueReference(value){_PrimitiveReference2.call(this,value);}return ValueReference;})(PrimitiveReference);var UNDEFINED_REFERENCE=new ValueReference(undefined);var NULL_REFERENCE=new ValueReference(null);var TRUE_REFERENCE=new ValueReference(true);var FALSE_REFERENCE=new ValueReference(false);var ConditionalReference=(function(){function ConditionalReference(inner){this.inner = inner;this.tag = inner.tag;}ConditionalReference.prototype.value = function value(){return this.toBool(this.inner.value());};ConditionalReference.prototype.toBool = function toBool(value){return !!value;};return ConditionalReference;})();var Constants=(function(){function Constants(){ // `0` means NULL
this.references = [];this.strings = [];this.expressions = [];this.arrays = [];this.blocks = [];this.functions = [];this.others = [];this.NULL_REFERENCE = this.reference(NULL_REFERENCE);this.UNDEFINED_REFERENCE = this.reference(UNDEFINED_REFERENCE);}Constants.prototype.getReference = function getReference(value){return this.references[value - 1];};Constants.prototype.reference = function reference(value){var index=this.references.length;this.references.push(value);return index + 1;};Constants.prototype.getString = function getString(value){return this.strings[value - 1];};Constants.prototype.string = function string(value){var index=this.strings.length;this.strings.push(value);return index + 1;};Constants.prototype.getExpression = function getExpression(value){return this.expressions[value - 1];};Constants.prototype.expression = function expression(value){var index=this.expressions.length;this.expressions.push(value);return index + 1;};Constants.prototype.getArray = function getArray(value){return this.arrays[value - 1];};Constants.prototype.array = function array(values){var index=this.arrays.length;this.arrays.push(values);return index + 1;};Constants.prototype.getBlock = function getBlock(value){return this.blocks[value - 1];};Constants.prototype.block = function block(_block2){var index=this.blocks.length;this.blocks.push(_block2);return index + 1;};Constants.prototype.getFunction = function getFunction(value){return this.functions[value - 1];};Constants.prototype.function = function _function(f){var index=this.functions.length;this.functions.push(f);return index + 1;};Constants.prototype.getOther = function getOther(value){return this.others[value - 1];};Constants.prototype.other = function other(_other){var index=this.others.length;this.others.push(_other);return index + 1;};return Constants;})();var AppendOpcodes=(function(){function AppendOpcodes(){this.evaluateOpcode = _glimmerUtil.fillNulls(51 /* EvaluatePartial */ + 1);}AppendOpcodes.prototype.add = function add(name,evaluate){this.evaluateOpcode[name] = evaluate;};AppendOpcodes.prototype.evaluate = function evaluate(vm,opcode){var func=this.evaluateOpcode[opcode.type];func(vm,opcode);};return AppendOpcodes;})();var APPEND_OPCODES=new AppendOpcodes();var AbstractOpcode=(function(){function AbstractOpcode(){_glimmerUtil.initializeGuid(this);}AbstractOpcode.prototype.toJSON = function toJSON(){return {guid:this._guid,type:this.type};};return AbstractOpcode;})();var UpdatingOpcode=(function(_AbstractOpcode){babelHelpers.inherits(UpdatingOpcode,_AbstractOpcode);function UpdatingOpcode(){_AbstractOpcode.apply(this,arguments);this.next = null;this.prev = null;}return UpdatingOpcode;})(AbstractOpcode);APPEND_OPCODES.add(20, /* OpenBlock */function(vm,_ref){var _getBlock=_ref.op1;var _args=_ref.op2;var inner=vm.constants.getOther(_getBlock);var rawArgs=vm.constants.getExpression(_args);var args=null;var block=inner.evaluate(vm);if(block){args = rawArgs.evaluate(vm);} // FIXME: can we avoid doing this when we don't have a block?
vm.pushCallerScope();if(block){vm.invokeBlock(block,args || null);}});APPEND_OPCODES.add(21, /* CloseBlock */function(vm){return vm.popScope();});APPEND_OPCODES.add(0, /* PushChildScope */function(vm){return vm.pushChildScope();});APPEND_OPCODES.add(1, /* PopScope */function(vm){return vm.popScope();});APPEND_OPCODES.add(2, /* PushDynamicScope */function(vm){return vm.pushDynamicScope();});APPEND_OPCODES.add(3, /* PopDynamicScope */function(vm){return vm.popDynamicScope();});APPEND_OPCODES.add(4, /* Put */function(vm,_ref2){var reference=_ref2.op1;vm.frame.setOperand(vm.constants.getReference(reference));});APPEND_OPCODES.add(5, /* EvaluatePut */function(vm,_ref3){var expression=_ref3.op1;var expr=vm.constants.getExpression(expression);vm.evaluateOperand(expr);});APPEND_OPCODES.add(6, /* PutArgs */function(vm,_ref4){var args=_ref4.op1;vm.evaluateArgs(vm.constants.getExpression(args));});APPEND_OPCODES.add(7, /* BindPositionalArgs */function(vm,_ref5){var _symbols=_ref5.op1;var symbols=vm.constants.getArray(_symbols);vm.bindPositionalArgs(symbols);});APPEND_OPCODES.add(8, /* BindNamedArgs */function(vm,_ref6){var _names=_ref6.op1;var _symbols=_ref6.op2;var names=vm.constants.getArray(_names);var symbols=vm.constants.getArray(_symbols);vm.bindNamedArgs(names,symbols);});APPEND_OPCODES.add(9, /* BindBlocks */function(vm,_ref7){var _names=_ref7.op1;var _symbols=_ref7.op2;var names=vm.constants.getArray(_names);var symbols=vm.constants.getArray(_symbols);vm.bindBlocks(names,symbols);});APPEND_OPCODES.add(10, /* BindPartialArgs */function(vm,_ref8){var symbol=_ref8.op1;vm.bindPartialArgs(symbol);});APPEND_OPCODES.add(11, /* BindCallerScope */function(vm){return vm.bindCallerScope();});APPEND_OPCODES.add(12, /* BindDynamicScope */function(vm,_ref9){var _names=_ref9.op1;var names=vm.constants.getArray(_names);vm.bindDynamicScope(names);});APPEND_OPCODES.add(13, /* Enter */function(vm,_ref10){var start=_ref10.op1;var end=_ref10.op2;return vm.enter(start,end);});APPEND_OPCODES.add(14, /* Exit */function(vm){return vm.exit();});APPEND_OPCODES.add(15, /* Evaluate */function(vm,_ref11){var _block=_ref11.op1;var block=vm.constants.getBlock(_block);var args=vm.frame.getArgs();vm.invokeBlock(block,args);});APPEND_OPCODES.add(16, /* Jump */function(vm,_ref12){var target=_ref12.op1;return vm.goto(target);});APPEND_OPCODES.add(17, /* JumpIf */function(vm,_ref13){var target=_ref13.op1;var reference=vm.frame.getCondition();if(_glimmerReference.isConst(reference)){if(reference.value()){vm.goto(target);}}else {var cache=new _glimmerReference.ReferenceCache(reference);if(cache.peek()){vm.goto(target);}vm.updateWith(new Assert(cache));}});APPEND_OPCODES.add(18, /* JumpUnless */function(vm,_ref14){var target=_ref14.op1;var reference=vm.frame.getCondition();if(_glimmerReference.isConst(reference)){if(!reference.value()){vm.goto(target);}}else {var cache=new _glimmerReference.ReferenceCache(reference);if(!cache.peek()){vm.goto(target);}vm.updateWith(new Assert(cache));}});var ConstTest=function(ref,_env){return new _glimmerReference.ConstReference(!!ref.value());};var SimpleTest=function(ref,_env){return ref;};var EnvironmentTest=function(ref,env){return env.toConditionalReference(ref);};APPEND_OPCODES.add(19, /* Test */function(vm,_ref15){var _func=_ref15.op1;var operand=vm.frame.getOperand();var func=vm.constants.getFunction(_func);vm.frame.setCondition(func(operand,vm.env));});var Assert=(function(_UpdatingOpcode){babelHelpers.inherits(Assert,_UpdatingOpcode);function Assert(cache){_UpdatingOpcode.call(this);this.type = "assert";this.tag = cache.tag;this.cache = cache;}Assert.prototype.evaluate = function evaluate(vm){var cache=this.cache;if(_glimmerReference.isModified(cache.revalidate())){vm.throw();}};Assert.prototype.toJSON = function toJSON(){var type=this.type;var _guid=this._guid;var cache=this.cache;var expected=undefined;try{expected = JSON.stringify(cache.peek());}catch(e) {expected = String(cache.peek());}return {guid:_guid,type:type,args:[],details:{expected:expected}};};return Assert;})(UpdatingOpcode);var JumpIfNotModifiedOpcode=(function(_UpdatingOpcode2){babelHelpers.inherits(JumpIfNotModifiedOpcode,_UpdatingOpcode2);function JumpIfNotModifiedOpcode(tag,target){_UpdatingOpcode2.call(this);this.target = target;this.type = "jump-if-not-modified";this.tag = tag;this.lastRevision = tag.value();}JumpIfNotModifiedOpcode.prototype.evaluate = function evaluate(vm){var tag=this.tag;var target=this.target;var lastRevision=this.lastRevision;if(!vm.alwaysRevalidate && tag.validate(lastRevision)){vm.goto(target);}};JumpIfNotModifiedOpcode.prototype.didModify = function didModify(){this.lastRevision = this.tag.value();};JumpIfNotModifiedOpcode.prototype.toJSON = function toJSON(){return {guid:this._guid,type:this.type,args:[JSON.stringify(this.target.inspect())]};};return JumpIfNotModifiedOpcode;})(UpdatingOpcode);var DidModifyOpcode=(function(_UpdatingOpcode3){babelHelpers.inherits(DidModifyOpcode,_UpdatingOpcode3);function DidModifyOpcode(target){_UpdatingOpcode3.call(this);this.target = target;this.type = "did-modify";this.tag = _glimmerReference.CONSTANT_TAG;}DidModifyOpcode.prototype.evaluate = function evaluate(){this.target.didModify();};return DidModifyOpcode;})(UpdatingOpcode);var LabelOpcode=(function(){function LabelOpcode(label){this.tag = _glimmerReference.CONSTANT_TAG;this.type = "label";this.label = null;this.prev = null;this.next = null;_glimmerUtil.initializeGuid(this);if(label)this.label = label;}LabelOpcode.prototype.evaluate = function evaluate(){};LabelOpcode.prototype.inspect = function inspect(){return this.label + ' [' + this._guid + ']';};LabelOpcode.prototype.toJSON = function toJSON(){return {guid:this._guid,type:this.type,args:[JSON.stringify(this.inspect())]};};return LabelOpcode;})();var EMPTY_ARRAY=_glimmerUtil.HAS_NATIVE_WEAKMAP?Object.freeze([]):[];var EMPTY_DICT=_glimmerUtil.HAS_NATIVE_WEAKMAP?Object.freeze(_glimmerUtil.dict()):_glimmerUtil.dict();var CompiledPositionalArgs=(function(){function CompiledPositionalArgs(values){this.values = values;this.length = values.length;}CompiledPositionalArgs.create = function create(values){if(values.length){return new this(values);}else {return COMPILED_EMPTY_POSITIONAL_ARGS;}};CompiledPositionalArgs.empty = function empty(){return COMPILED_EMPTY_POSITIONAL_ARGS;};CompiledPositionalArgs.prototype.evaluate = function evaluate(vm){var values=this.values;var length=this.length;var references=new Array(length);for(var i=0;i < length;i++) {references[i] = values[i].evaluate(vm);}return EvaluatedPositionalArgs.create(references);};CompiledPositionalArgs.prototype.toJSON = function toJSON(){return '[' + this.values.map(function(value){return value.toJSON();}).join(", ") + ']';};return CompiledPositionalArgs;})();var COMPILED_EMPTY_POSITIONAL_ARGS=new ((function(_CompiledPositionalArgs){babelHelpers.inherits(_class,_CompiledPositionalArgs);function _class(){_CompiledPositionalArgs.call(this,EMPTY_ARRAY);}_class.prototype.evaluate = function evaluate(_vm){return EVALUATED_EMPTY_POSITIONAL_ARGS;};_class.prototype.toJSON = function toJSON(){return '<EMPTY>';};return _class;})(CompiledPositionalArgs))();var EvaluatedPositionalArgs=(function(){function EvaluatedPositionalArgs(values){this.values = values;this.tag = _glimmerReference.combineTagged(values);this.length = values.length;}EvaluatedPositionalArgs.create = function create(values){return new this(values);};EvaluatedPositionalArgs.empty = function empty(){return EVALUATED_EMPTY_POSITIONAL_ARGS;};EvaluatedPositionalArgs.prototype.at = function at(index){var values=this.values;var length=this.length;return index < length?values[index]:UNDEFINED_REFERENCE;};EvaluatedPositionalArgs.prototype.value = function value(){var values=this.values;var length=this.length;var ret=new Array(length);for(var i=0;i < length;i++) {ret[i] = values[i].value();}return ret;};return EvaluatedPositionalArgs;})();var EVALUATED_EMPTY_POSITIONAL_ARGS=new ((function(_EvaluatedPositionalArgs){babelHelpers.inherits(_class2,_EvaluatedPositionalArgs);function _class2(){_EvaluatedPositionalArgs.call(this,EMPTY_ARRAY);}_class2.prototype.at = function at(){return UNDEFINED_REFERENCE;};_class2.prototype.value = function value(){return this.values;};return _class2;})(EvaluatedPositionalArgs))();var CompiledNamedArgs=(function(){function CompiledNamedArgs(keys,values){this.keys = keys;this.values = values;this.length = keys.length;_glimmerUtil.assert(keys.length === values.length,'Keys and values do not have the same length');}CompiledNamedArgs.empty = function empty(){return COMPILED_EMPTY_NAMED_ARGS;};CompiledNamedArgs.create = function create(map){var keys=Object.keys(map);var length=keys.length;if(length > 0){var values=[];for(var i=0;i < length;i++) {values[i] = map[keys[i]];}return new this(keys,values);}else {return COMPILED_EMPTY_NAMED_ARGS;}};CompiledNamedArgs.prototype.evaluate = function evaluate(vm){var keys=this.keys;var values=this.values;var length=this.length;var evaluated=new Array(length);for(var i=0;i < length;i++) {evaluated[i] = values[i].evaluate(vm);}return new EvaluatedNamedArgs(keys,evaluated);};CompiledNamedArgs.prototype.toJSON = function toJSON(){var keys=this.keys;var values=this.values;var inner=keys.map(function(key,i){return key + ': ' + values[i].toJSON();}).join(", ");return '{' + inner + '}';};return CompiledNamedArgs;})();var COMPILED_EMPTY_NAMED_ARGS=new ((function(_CompiledNamedArgs){babelHelpers.inherits(_class3,_CompiledNamedArgs);function _class3(){_CompiledNamedArgs.call(this,EMPTY_ARRAY,EMPTY_ARRAY);}_class3.prototype.evaluate = function evaluate(_vm){return EVALUATED_EMPTY_NAMED_ARGS;};_class3.prototype.toJSON = function toJSON(){return '<EMPTY>';};return _class3;})(CompiledNamedArgs))();var EvaluatedNamedArgs=(function(){function EvaluatedNamedArgs(keys,values){var _map=arguments.length <= 2 || arguments[2] === undefined?null:arguments[2];this.keys = keys;this.values = values;this._map = _map;this.tag = _glimmerReference.combineTagged(values);this.length = keys.length;_glimmerUtil.assert(keys.length === values.length,'Keys and values do not have the same length');}EvaluatedNamedArgs.create = function create(map){var keys=Object.keys(map);var length=keys.length;if(length > 0){var values=new Array(length);for(var i=0;i < length;i++) {values[i] = map[keys[i]];}return new this(keys,values,map);}else {return EVALUATED_EMPTY_NAMED_ARGS;}};EvaluatedNamedArgs.empty = function empty(){return EVALUATED_EMPTY_NAMED_ARGS;};EvaluatedNamedArgs.prototype.get = function get(key){var keys=this.keys;var values=this.values;var index=keys.indexOf(key);return index === -1?UNDEFINED_REFERENCE:values[index];};EvaluatedNamedArgs.prototype.has = function has(key){return this.keys.indexOf(key) !== -1;};EvaluatedNamedArgs.prototype.value = function value(){var keys=this.keys;var values=this.values;var out=_glimmerUtil.dict();for(var i=0;i < keys.length;i++) {var key=keys[i];var ref=values[i];out[key] = ref.value();}return out;};babelHelpers.createClass(EvaluatedNamedArgs,[{key:'map',get:function(){var map=this._map;if(map){return map;}map = this._map = _glimmerUtil.dict();var keys=this.keys;var values=this.values;var length=this.length;for(var i=0;i < length;i++) {map[keys[i]] = values[i];}return map;}}]);return EvaluatedNamedArgs;})();var EVALUATED_EMPTY_NAMED_ARGS=new ((function(_EvaluatedNamedArgs){babelHelpers.inherits(_class4,_EvaluatedNamedArgs);function _class4(){_EvaluatedNamedArgs.call(this,EMPTY_ARRAY,EMPTY_ARRAY,EMPTY_DICT);}_class4.prototype.get = function get(){return UNDEFINED_REFERENCE;};_class4.prototype.has = function has(_key){return false;};_class4.prototype.value = function value(){return EMPTY_DICT;};return _class4;})(EvaluatedNamedArgs))();var EMPTY_BLOCKS={default:null,inverse:null};var CompiledArgs=(function(){function CompiledArgs(positional,named,blocks){this.positional = positional;this.named = named;this.blocks = blocks;this.type = "compiled-args";}CompiledArgs.create = function create(positional,named,blocks){if(positional === COMPILED_EMPTY_POSITIONAL_ARGS && named === COMPILED_EMPTY_NAMED_ARGS && blocks === EMPTY_BLOCKS){return this.empty();}else {return new this(positional,named,blocks);}};CompiledArgs.empty = function empty(){return COMPILED_EMPTY_ARGS;};CompiledArgs.prototype.evaluate = function evaluate(vm){var positional=this.positional;var named=this.named;var blocks=this.blocks;return EvaluatedArgs.create(positional.evaluate(vm),named.evaluate(vm),blocks);};return CompiledArgs;})();var COMPILED_EMPTY_ARGS=new ((function(_CompiledArgs){babelHelpers.inherits(_class5,_CompiledArgs);function _class5(){_CompiledArgs.call(this,COMPILED_EMPTY_POSITIONAL_ARGS,COMPILED_EMPTY_NAMED_ARGS,EMPTY_BLOCKS);}_class5.prototype.evaluate = function evaluate(_vm){return EMPTY_EVALUATED_ARGS;};return _class5;})(CompiledArgs))();var EvaluatedArgs=(function(){function EvaluatedArgs(positional,named,blocks){this.positional = positional;this.named = named;this.blocks = blocks;this.tag = _glimmerReference.combineTagged([positional,named]);}EvaluatedArgs.empty = function empty(){return EMPTY_EVALUATED_ARGS;};EvaluatedArgs.create = function create(positional,named,blocks){return new this(positional,named,blocks);};EvaluatedArgs.positional = function positional(values){var blocks=arguments.length <= 1 || arguments[1] === undefined?EMPTY_BLOCKS:arguments[1];return new this(EvaluatedPositionalArgs.create(values),EVALUATED_EMPTY_NAMED_ARGS,blocks);};EvaluatedArgs.named = function named(map){var blocks=arguments.length <= 1 || arguments[1] === undefined?EMPTY_BLOCKS:arguments[1];return new this(EVALUATED_EMPTY_POSITIONAL_ARGS,EvaluatedNamedArgs.create(map),blocks);};return EvaluatedArgs;})();var EMPTY_EVALUATED_ARGS=new EvaluatedArgs(EVALUATED_EMPTY_POSITIONAL_ARGS,EVALUATED_EMPTY_NAMED_ARGS,EMPTY_BLOCKS);APPEND_OPCODES.add(22, /* PutDynamicComponent */function(vm){var reference=vm.frame.getOperand();var cache=_glimmerReference.isConst(reference)?undefined:new _glimmerReference.ReferenceCache(reference);var definition=cache?cache.peek():reference.value();vm.frame.setImmediate(definition);if(cache){vm.updateWith(new Assert(cache));}});APPEND_OPCODES.add(23, /* PutComponent */function(vm,_ref16){var _component=_ref16.op1;var definition=vm.constants.getOther(_component);vm.frame.setImmediate(definition);});APPEND_OPCODES.add(24, /* OpenComponent */function(vm,_ref17){var _args=_ref17.op1;var _shadow=_ref17.op2;var rawArgs=vm.constants.getExpression(_args);var shadow=vm.constants.getBlock(_shadow);var definition=vm.frame.getImmediate();var dynamicScope=vm.pushDynamicScope();var callerScope=vm.scope();var manager=definition.manager;var args=manager.prepareArgs(definition,rawArgs.evaluate(vm),dynamicScope);var hasDefaultBlock=!!args.blocks.default; // TODO Cleanup?
var component=manager.create(vm.env,definition,args,dynamicScope,vm.getSelf(),hasDefaultBlock);var destructor=manager.getDestructor(component);if(destructor)vm.newDestroyable(destructor);var layout=manager.layoutFor(definition,component,vm.env);var selfRef=manager.getSelf(component);vm.beginCacheGroup();vm.stack().pushSimpleBlock();vm.pushRootScope(selfRef,layout.symbols);vm.invokeLayout(args,layout,callerScope,component,manager,shadow);vm.updateWith(new UpdateComponentOpcode(definition.name,component,manager,args,dynamicScope));}); // export class DidCreateElementOpcode extends Opcode {
//   public type = "did-create-element";
//   evaluate(vm: VM) {
//     let manager = vm.frame.getManager();
//     let component = vm.frame.getComponent();
//     let action = 'DidCreateElementOpcode#evaluate';
//     manager.didCreateElement(component, vm.stack().expectConstructing(action), vm.stack().expectOperations(action));
//   }
//   toJSON(): OpcodeJSON {
//     return {
//       guid: this._guid,
//       type: this.type,
//       args: ["$ARGS"]
//     };
//   }
// }
APPEND_OPCODES.add(25, /* DidCreateElement */function(vm){var manager=vm.frame.getManager();var component=vm.frame.getComponent();var action='DidCreateElementOpcode#evaluate';manager.didCreateElement(component,vm.stack().expectConstructing(action),vm.stack().expectOperations(action));}); // export class ShadowAttributesOpcode extends Opcode {
//   public type = "shadow-attributes";
//   evaluate(vm: VM) {
//     let shadow = vm.frame.getShadow();
//     vm.pushCallerScope();
//     if (!shadow) return;
//     vm.invokeBlock(shadow, EvaluatedArgs.empty());
//   }
//   toJSON(): OpcodeJSON {
//     return {
//       guid: this._guid,
//       type: this.type,
//       args: ["$ARGS"]
//     };
//   }
// }
// Slow path for non-specialized component invocations. Uses an internal
// named lookup on the args.
APPEND_OPCODES.add(26, /* ShadowAttributes */function(vm){var shadow=vm.frame.getShadow();vm.pushCallerScope();if(!shadow)return;vm.invokeBlock(shadow,EvaluatedArgs.empty());}); // export class DidRenderLayoutOpcode extends Opcode {
//   public type = "did-render-layout";
//   evaluate(vm: VM) {
//     let manager = vm.frame.getManager();
//     let component = vm.frame.getComponent();
//     let bounds = vm.stack().popBlock();
//     manager.didRenderLayout(component, bounds);
//     vm.env.didCreate(component, manager);
//     vm.updateWith(new DidUpdateLayoutOpcode(manager, component, bounds));
//   }
// }
APPEND_OPCODES.add(27, /* DidRenderLayout */function(vm){var manager=vm.frame.getManager();var component=vm.frame.getComponent();var bounds=vm.stack().popBlock();manager.didRenderLayout(component,bounds);vm.env.didCreate(component,manager);vm.updateWith(new DidUpdateLayoutOpcode(manager,component,bounds));}); // export class CloseComponentOpcode extends Opcode {
//   public type = "close-component";
//   evaluate(vm: VM) {
//     vm.popScope();
//     vm.popDynamicScope();
//     vm.commitCacheGroup();
//   }
// }
APPEND_OPCODES.add(28, /* CloseComponent */function(vm){vm.popScope();vm.popDynamicScope();vm.commitCacheGroup();});var UpdateComponentOpcode=(function(_UpdatingOpcode4){babelHelpers.inherits(UpdateComponentOpcode,_UpdatingOpcode4);function UpdateComponentOpcode(name,component,manager,args,dynamicScope){_UpdatingOpcode4.call(this);this.name = name;this.component = component;this.manager = manager;this.args = args;this.dynamicScope = dynamicScope;this.type = "update-component";var componentTag=manager.getTag(component);if(componentTag){this.tag = _glimmerReference.combine([args.tag,componentTag]);}else {this.tag = args.tag;}}UpdateComponentOpcode.prototype.evaluate = function evaluate(_vm){var component=this.component;var manager=this.manager;var args=this.args;var dynamicScope=this.dynamicScope;manager.update(component,args,dynamicScope);};UpdateComponentOpcode.prototype.toJSON = function toJSON(){return {guid:this._guid,type:this.type,args:[JSON.stringify(this.name)]};};return UpdateComponentOpcode;})(UpdatingOpcode);var DidUpdateLayoutOpcode=(function(_UpdatingOpcode5){babelHelpers.inherits(DidUpdateLayoutOpcode,_UpdatingOpcode5);function DidUpdateLayoutOpcode(manager,component,bounds){_UpdatingOpcode5.call(this);this.manager = manager;this.component = component;this.bounds = bounds;this.type = "did-update-layout";this.tag = _glimmerReference.CONSTANT_TAG;}DidUpdateLayoutOpcode.prototype.evaluate = function evaluate(vm){var manager=this.manager;var component=this.component;var bounds=this.bounds;manager.didUpdateLayout(component,bounds);vm.env.didUpdate(component,manager);};return DidUpdateLayoutOpcode;})(UpdatingOpcode);var Cursor=function Cursor(element,nextSibling){this.element = element;this.nextSibling = nextSibling;};var ConcreteBounds=(function(){function ConcreteBounds(parentNode,first,last){this.parentNode = parentNode;this.first = first;this.last = last;}ConcreteBounds.prototype.parentElement = function parentElement(){return this.parentNode;};ConcreteBounds.prototype.firstNode = function firstNode(){return this.first;};ConcreteBounds.prototype.lastNode = function lastNode(){return this.last;};return ConcreteBounds;})();var SingleNodeBounds=(function(){function SingleNodeBounds(parentNode,node){this.parentNode = parentNode;this.node = node;}SingleNodeBounds.prototype.parentElement = function parentElement(){return this.parentNode;};SingleNodeBounds.prototype.firstNode = function firstNode(){return this.node;};SingleNodeBounds.prototype.lastNode = function lastNode(){return this.node;};return SingleNodeBounds;})();function single(parent,node){return new SingleNodeBounds(parent,node);}function moveBounds(bounds,reference){var parent=bounds.parentElement();var first=bounds.firstNode();var last=bounds.lastNode();var node=first;while(node) {var next=node.nextSibling;parent.insertBefore(node,reference);if(node === last)return next;node = next;}return null;}function clear(bounds){var parent=bounds.parentElement();var first=bounds.firstNode();var last=bounds.lastNode();var node=first;while(node) {var next=node.nextSibling;parent.removeChild(node);if(node === last)return next;node = next;}return null;}function isSafeString(value){return !!value && typeof value['toHTML'] === 'function';}function isNode(value){return value !== null && typeof value === 'object' && typeof value['nodeType'] === 'number';}function isString(value){return typeof value === 'string';}var Upsert=function Upsert(bounds){this.bounds = bounds;};function cautiousInsert(dom,cursor,value){if(isString(value)){return TextUpsert.insert(dom,cursor,value);}if(isSafeString(value)){return SafeStringUpsert.insert(dom,cursor,value);}if(isNode(value)){return NodeUpsert.insert(dom,cursor,value);}throw _glimmerUtil.unreachable();}function trustingInsert(dom,cursor,value){if(isString(value)){return HTMLUpsert.insert(dom,cursor,value);}if(isNode(value)){return NodeUpsert.insert(dom,cursor,value);}throw _glimmerUtil.unreachable();}var TextUpsert=(function(_Upsert){babelHelpers.inherits(TextUpsert,_Upsert);TextUpsert.insert = function insert(dom,cursor,value){var textNode=dom.createTextNode(value);dom.insertBefore(cursor.element,textNode,cursor.nextSibling);var bounds=new SingleNodeBounds(cursor.element,textNode);return new TextUpsert(bounds,textNode);};function TextUpsert(bounds,textNode){_Upsert.call(this,bounds);this.textNode = textNode;}TextUpsert.prototype.update = function update(_dom,value){if(isString(value)){var textNode=this.textNode;textNode.nodeValue = value;return true;}else {return false;}};return TextUpsert;})(Upsert);var HTMLUpsert=(function(_Upsert2){babelHelpers.inherits(HTMLUpsert,_Upsert2);function HTMLUpsert(){_Upsert2.apply(this,arguments);}HTMLUpsert.insert = function insert(dom,cursor,value){var bounds=dom.insertHTMLBefore(cursor.element,value,cursor.nextSibling);return new HTMLUpsert(bounds);};HTMLUpsert.prototype.update = function update(dom,value){if(isString(value)){var bounds=this.bounds;var parentElement=bounds.parentElement();var nextSibling=clear(bounds);this.bounds = dom.insertHTMLBefore(parentElement,nextSibling,value);return true;}else {return false;}};return HTMLUpsert;})(Upsert);var SafeStringUpsert=(function(_Upsert3){babelHelpers.inherits(SafeStringUpsert,_Upsert3);function SafeStringUpsert(bounds,lastStringValue){_Upsert3.call(this,bounds);this.lastStringValue = lastStringValue;}SafeStringUpsert.insert = function insert(dom,cursor,value){var stringValue=value.toHTML();var bounds=dom.insertHTMLBefore(cursor.element,stringValue,cursor.nextSibling);return new SafeStringUpsert(bounds,stringValue);};SafeStringUpsert.prototype.update = function update(dom,value){if(isSafeString(value)){var stringValue=value.toHTML();if(stringValue !== this.lastStringValue){var bounds=this.bounds;var parentElement=bounds.parentElement();var nextSibling=clear(bounds);this.bounds = dom.insertHTMLBefore(parentElement,nextSibling,stringValue);this.lastStringValue = stringValue;}return true;}else {return false;}};return SafeStringUpsert;})(Upsert);var NodeUpsert=(function(_Upsert4){babelHelpers.inherits(NodeUpsert,_Upsert4);function NodeUpsert(){_Upsert4.apply(this,arguments);}NodeUpsert.insert = function insert(dom,cursor,node){dom.insertBefore(cursor.element,node,cursor.nextSibling);return new NodeUpsert(single(cursor.element,node));};NodeUpsert.prototype.update = function update(dom,value){if(isNode(value)){var bounds=this.bounds;var parentElement=bounds.parentElement();var nextSibling=clear(bounds);this.bounds = dom.insertNodeBefore(parentElement,value,nextSibling);return true;}else {return false;}};return NodeUpsert;})(Upsert);var COMPONENT_DEFINITION_BRAND='COMPONENT DEFINITION [id=e59c754e-61eb-4392-8c4a-2c0ac72bfcd4]';function isComponentDefinition(obj){return typeof obj === 'object' && obj && obj[COMPONENT_DEFINITION_BRAND];}var ComponentDefinition=function ComponentDefinition(name,manager,ComponentClass){this[COMPONENT_DEFINITION_BRAND] = true;this.name = name;this.manager = manager;this.ComponentClass = ComponentClass;};var CompiledExpression=(function(){function CompiledExpression(){}CompiledExpression.prototype.toJSON = function toJSON(){return 'UNIMPL: ' + this.type.toUpperCase();};return CompiledExpression;})();APPEND_OPCODES.add(29, /* Text */function(vm,_ref18){var text=_ref18.op1;vm.stack().appendText(vm.constants.getString(text));});APPEND_OPCODES.add(30, /* Comment */function(vm,_ref19){var text=_ref19.op1;vm.stack().appendComment(vm.constants.getString(text));});APPEND_OPCODES.add(32, /* OpenElement */function(vm,_ref20){var tag=_ref20.op1;vm.stack().openElement(vm.constants.getString(tag));});APPEND_OPCODES.add(33, /* PushRemoteElement */function(vm){var reference=vm.frame.getOperand();var cache=_glimmerReference.isConst(reference)?undefined:new _glimmerReference.ReferenceCache(reference);var element=cache?cache.peek():reference.value();vm.stack().pushRemoteElement(element);if(cache){vm.updateWith(new Assert(cache));}});APPEND_OPCODES.add(34, /* PopRemoteElement */function(vm){return vm.stack().popRemoteElement();});APPEND_OPCODES.add(35, /* OpenComponentElement */function(vm,_ref21){var _tag=_ref21.op1;var tag=vm.constants.getString(_tag);vm.stack().openElement(tag,new ComponentElementOperations(vm.env));});APPEND_OPCODES.add(36, /* OpenDynamicElement */function(vm){var tagName=vm.frame.getOperand().value();vm.stack().openElement(tagName);});var ClassList=(function(){function ClassList(){this.list = null;this.isConst = true;}ClassList.prototype.append = function append(reference){var list=this.list;var isConst$$=this.isConst;if(list === null)list = this.list = [];list.push(reference);this.isConst = isConst$$ && _glimmerReference.isConst(reference);};ClassList.prototype.toReference = function toReference(){var list=this.list;var isConst$$=this.isConst;if(!list)return NULL_REFERENCE;if(isConst$$)return PrimitiveReference.create(toClassName(list));return new ClassListReference(list);};return ClassList;})();var ClassListReference=(function(_CachedReference){babelHelpers.inherits(ClassListReference,_CachedReference);function ClassListReference(list){_CachedReference.call(this);this.list = [];this.tag = _glimmerReference.combineTagged(list);this.list = list;}ClassListReference.prototype.compute = function compute(){return toClassName(this.list);};return ClassListReference;})(_glimmerReference.CachedReference);function toClassName(list){var ret=[];for(var i=0;i < list.length;i++) {var value=list[i].value();if(value !== false && value !== null && value !== undefined)ret.push(value);}return ret.length === 0?null:ret.join(' ');}var SimpleElementOperations=(function(){function SimpleElementOperations(env){this.env = env;this.opcodes = null;this.classList = null;}SimpleElementOperations.prototype.addStaticAttribute = function addStaticAttribute(element,name,value){if(name === 'class'){this.addClass(PrimitiveReference.create(value));}else {this.env.getAppendOperations().setAttribute(element,name,value);}};SimpleElementOperations.prototype.addStaticAttributeNS = function addStaticAttributeNS(element,namespace,name,value){this.env.getAppendOperations().setAttribute(element,name,value,namespace);};SimpleElementOperations.prototype.addDynamicAttribute = function addDynamicAttribute(element,name,reference,isTrusting){if(name === 'class'){this.addClass(reference);}else {var attributeManager=this.env.attributeFor(element,name,isTrusting);var attribute=new DynamicAttribute(element,attributeManager,name,reference);this.addAttribute(attribute);}};SimpleElementOperations.prototype.addDynamicAttributeNS = function addDynamicAttributeNS(element,namespace,name,reference,isTrusting){var attributeManager=this.env.attributeFor(element,name,isTrusting,namespace);var nsAttribute=new DynamicAttribute(element,attributeManager,name,reference,namespace);this.addAttribute(nsAttribute);};SimpleElementOperations.prototype.flush = function flush(element,vm){var env=vm.env;var opcodes=this.opcodes;var classList=this.classList;for(var i=0;opcodes && i < opcodes.length;i++) {vm.updateWith(opcodes[i]);}if(classList){var attributeManager=env.attributeFor(element,'class',false);var attribute=new DynamicAttribute(element,attributeManager,'class',classList.toReference());var opcode=attribute.flush(env);if(opcode){vm.updateWith(opcode);}}this.opcodes = null;this.classList = null;};SimpleElementOperations.prototype.addClass = function addClass(reference){var classList=this.classList;if(!classList){classList = this.classList = new ClassList();}classList.append(reference);};SimpleElementOperations.prototype.addAttribute = function addAttribute(attribute){var opcode=attribute.flush(this.env);if(opcode){var opcodes=this.opcodes;if(!opcodes){opcodes = this.opcodes = [];}opcodes.push(opcode);}};return SimpleElementOperations;})();var ComponentElementOperations=(function(){function ComponentElementOperations(env){this.env = env;this.attributeNames = null;this.attributes = null;this.classList = null;}ComponentElementOperations.prototype.addStaticAttribute = function addStaticAttribute(element,name,value){if(name === 'class'){this.addClass(PrimitiveReference.create(value));}else if(this.shouldAddAttribute(name)){this.addAttribute(name,new StaticAttribute(element,name,value));}};ComponentElementOperations.prototype.addStaticAttributeNS = function addStaticAttributeNS(element,namespace,name,value){if(this.shouldAddAttribute(name)){this.addAttribute(name,new StaticAttribute(element,name,value,namespace));}};ComponentElementOperations.prototype.addDynamicAttribute = function addDynamicAttribute(element,name,reference,isTrusting){if(name === 'class'){this.addClass(reference);}else if(this.shouldAddAttribute(name)){var attributeManager=this.env.attributeFor(element,name,isTrusting);var attribute=new DynamicAttribute(element,attributeManager,name,reference);this.addAttribute(name,attribute);}};ComponentElementOperations.prototype.addDynamicAttributeNS = function addDynamicAttributeNS(element,namespace,name,reference,isTrusting){if(this.shouldAddAttribute(name)){var attributeManager=this.env.attributeFor(element,name,isTrusting,namespace);var nsAttribute=new DynamicAttribute(element,attributeManager,name,reference,namespace);this.addAttribute(name,nsAttribute);}};ComponentElementOperations.prototype.flush = function flush(element,vm){var env=this.env;var attributes=this.attributes;var classList=this.classList;for(var i=0;attributes && i < attributes.length;i++) {var opcode=attributes[i].flush(env);if(opcode){vm.updateWith(opcode);}}if(classList){var attributeManager=env.attributeFor(element,'class',false);var attribute=new DynamicAttribute(element,attributeManager,'class',classList.toReference());var opcode=attribute.flush(env);if(opcode){vm.updateWith(opcode);}}};ComponentElementOperations.prototype.shouldAddAttribute = function shouldAddAttribute(name){return !this.attributeNames || this.attributeNames.indexOf(name) === -1;};ComponentElementOperations.prototype.addClass = function addClass(reference){var classList=this.classList;if(!classList){classList = this.classList = new ClassList();}classList.append(reference);};ComponentElementOperations.prototype.addAttribute = function addAttribute(name,attribute){var attributeNames=this.attributeNames;var attributes=this.attributes;if(!attributeNames){attributeNames = this.attributeNames = [];attributes = this.attributes = [];}attributeNames.push(name);_glimmerUtil.unwrap(attributes).push(attribute);};return ComponentElementOperations;})();APPEND_OPCODES.add(37, /* FlushElement */function(vm){var stack=vm.stack();var action='FlushElementOpcode#evaluate';stack.expectOperations(action).flush(stack.expectConstructing(action),vm);stack.flushElement();});APPEND_OPCODES.add(38, /* CloseElement */function(vm){return vm.stack().closeElement();});APPEND_OPCODES.add(39, /* PopElement */function(vm){return vm.stack().popElement();});APPEND_OPCODES.add(40, /* StaticAttr */function(vm,_ref22){var _name=_ref22.op1;var _value=_ref22.op2;var _namespace=_ref22.op3;var name=vm.constants.getString(_name);var value=vm.constants.getString(_value);if(_namespace){var namespace=vm.constants.getString(_namespace);vm.stack().setStaticAttributeNS(namespace,name,value);}else {vm.stack().setStaticAttribute(name,value);}});APPEND_OPCODES.add(41, /* Modifier */function(vm,_ref23){var _name=_ref23.op1;var _manager=_ref23.op2;var _args=_ref23.op3;var manager=vm.constants.getOther(_manager);var rawArgs=vm.constants.getExpression(_args);var stack=vm.stack();var element=stack.constructing;var updateOperations=stack.updateOperations;var args=rawArgs.evaluate(vm);var dynamicScope=vm.dynamicScope();var modifier=manager.create(element,args,dynamicScope,updateOperations);vm.env.scheduleInstallModifier(modifier,manager);var destructor=manager.getDestructor(modifier);if(destructor){vm.newDestroyable(destructor);}vm.updateWith(new UpdateModifierOpcode(manager,modifier,args));});var UpdateModifierOpcode=(function(_UpdatingOpcode6){babelHelpers.inherits(UpdateModifierOpcode,_UpdatingOpcode6);function UpdateModifierOpcode(manager,modifier,args){_UpdatingOpcode6.call(this);this.manager = manager;this.modifier = modifier;this.args = args;this.type = "update-modifier";this.tag = args.tag;this.lastUpdated = args.tag.value();}UpdateModifierOpcode.prototype.evaluate = function evaluate(vm){var manager=this.manager;var modifier=this.modifier;var tag=this.tag;var lastUpdated=this.lastUpdated;if(!tag.validate(lastUpdated)){vm.env.scheduleUpdateModifier(modifier,manager);this.lastUpdated = tag.value();}};UpdateModifierOpcode.prototype.toJSON = function toJSON(){return {guid:this._guid,type:this.type,args:[JSON.stringify(this.args)]};};return UpdateModifierOpcode;})(UpdatingOpcode);var StaticAttribute=(function(){function StaticAttribute(element,name,value,namespace){this.element = element;this.name = name;this.value = value;this.namespace = namespace;}StaticAttribute.prototype.flush = function flush(env){env.getAppendOperations().setAttribute(this.element,this.name,this.value,this.namespace);return null;};return StaticAttribute;})();var DynamicAttribute=(function(){function DynamicAttribute(element,attributeManager,name,reference,namespace){this.element = element;this.attributeManager = attributeManager;this.name = name;this.reference = reference;this.namespace = namespace;this.cache = null;this.tag = reference.tag;}DynamicAttribute.prototype.patch = function patch(env){var element=this.element;var cache=this.cache;var value=_glimmerUtil.expect(cache,'must patch after flush').revalidate();if(_glimmerReference.isModified(value)){this.attributeManager.updateAttribute(env,element,value,this.namespace);}};DynamicAttribute.prototype.flush = function flush(env){var reference=this.reference;var element=this.element;if(_glimmerReference.isConst(reference)){var value=reference.value();this.attributeManager.setAttribute(env,element,value,this.namespace);return null;}else {var cache=this.cache = new _glimmerReference.ReferenceCache(reference);var value=cache.peek();this.attributeManager.setAttribute(env,element,value,this.namespace);return new PatchElementOpcode(this);}};DynamicAttribute.prototype.toJSON = function toJSON(){var element=this.element;var namespace=this.namespace;var name=this.name;var cache=this.cache;var formattedElement=formatElement(element);var lastValue=_glimmerUtil.expect(cache,'must serialize after flush').peek();if(namespace){return {element:formattedElement,type:'attribute',namespace:namespace,name:name,lastValue:lastValue};}return {element:formattedElement,type:'attribute',namespace:namespace === undefined?null:namespace,name:name,lastValue:lastValue};};return DynamicAttribute;})();function formatElement(element){return JSON.stringify('<' + element.tagName.toLowerCase() + ' />');}APPEND_OPCODES.add(42, /* DynamicAttrNS */function(vm,_ref24){var _name=_ref24.op1;var _namespace=_ref24.op2;var trusting=_ref24.op3;var name=vm.constants.getString(_name);var namespace=vm.constants.getString(_namespace);var reference=vm.frame.getOperand();vm.stack().setDynamicAttributeNS(namespace,name,reference,!!trusting);});APPEND_OPCODES.add(43, /* DynamicAttr */function(vm,_ref25){var _name=_ref25.op1;var trusting=_ref25.op2;var name=vm.constants.getString(_name);var reference=vm.frame.getOperand();vm.stack().setDynamicAttribute(name,reference,!!trusting);});var PatchElementOpcode=(function(_UpdatingOpcode7){babelHelpers.inherits(PatchElementOpcode,_UpdatingOpcode7);function PatchElementOpcode(operation){_UpdatingOpcode7.call(this);this.type = "patch-element";this.tag = operation.tag;this.operation = operation;}PatchElementOpcode.prototype.evaluate = function evaluate(vm){this.operation.patch(vm.env);};PatchElementOpcode.prototype.toJSON = function toJSON(){var _guid=this._guid;var type=this.type;var operation=this.operation;return {guid:_guid,type:type,details:operation.toJSON()};};return PatchElementOpcode;})(UpdatingOpcode);var First=(function(){function First(node){this.node = node;}First.prototype.firstNode = function firstNode(){return this.node;};return First;})();var Last=(function(){function Last(node){this.node = node;}Last.prototype.lastNode = function lastNode(){return this.node;};return Last;})();var Fragment=(function(){function Fragment(bounds){this.bounds = bounds;}Fragment.prototype.parentElement = function parentElement(){return this.bounds.parentElement();};Fragment.prototype.firstNode = function firstNode(){return this.bounds.firstNode();};Fragment.prototype.lastNode = function lastNode(){return this.bounds.lastNode();};Fragment.prototype.update = function update(bounds){this.bounds = bounds;};return Fragment;})();var ElementStack=(function(){function ElementStack(env,parentNode,nextSibling){this.constructing = null;this.operations = null;this.elementStack = new _glimmerUtil.Stack();this.nextSiblingStack = new _glimmerUtil.Stack();this.blockStack = new _glimmerUtil.Stack();this.env = env;this.dom = env.getAppendOperations();this.updateOperations = env.getDOM();this.element = parentNode;this.nextSibling = nextSibling;this.defaultOperations = new SimpleElementOperations(env);this.elementStack.push(this.element);this.nextSiblingStack.push(this.nextSibling);}ElementStack.forInitialRender = function forInitialRender(env,parentNode,nextSibling){return new ElementStack(env,parentNode,nextSibling);};ElementStack.resume = function resume(env,tracker,nextSibling){var parentNode=tracker.parentElement();var stack=new ElementStack(env,parentNode,nextSibling);stack.pushBlockTracker(tracker);return stack;};ElementStack.prototype.expectConstructing = function expectConstructing(method){return _glimmerUtil.expect(this.constructing,method + ' should only be called while constructing an element');};ElementStack.prototype.expectOperations = function expectOperations(method){return _glimmerUtil.expect(this.operations,method + ' should only be called while constructing an element');};ElementStack.prototype.block = function block(){return _glimmerUtil.expect(this.blockStack.current,"Expected a current block tracker");};ElementStack.prototype.popElement = function popElement(){var elementStack=this.elementStack;var nextSiblingStack=this.nextSiblingStack;var topElement=elementStack.pop();nextSiblingStack.pop(); // LOGGER.debug(`-> element stack ${this.elementStack.toArray().map(e => e.tagName).join(', ')}`);
this.element = _glimmerUtil.expect(elementStack.current,"can't pop past the last element");this.nextSibling = nextSiblingStack.current;return topElement;};ElementStack.prototype.pushSimpleBlock = function pushSimpleBlock(){var tracker=new SimpleBlockTracker(this.element);this.pushBlockTracker(tracker);return tracker;};ElementStack.prototype.pushUpdatableBlock = function pushUpdatableBlock(){var tracker=new UpdatableBlockTracker(this.element);this.pushBlockTracker(tracker);return tracker;};ElementStack.prototype.pushBlockTracker = function pushBlockTracker(tracker){var isRemote=arguments.length <= 1 || arguments[1] === undefined?false:arguments[1];var current=this.blockStack.current;if(current !== null){current.newDestroyable(tracker);if(!isRemote){current.newBounds(tracker);}}this.blockStack.push(tracker);return tracker;};ElementStack.prototype.pushBlockList = function pushBlockList(list){var tracker=new BlockListTracker(this.element,list);var current=this.blockStack.current;if(current !== null){current.newDestroyable(tracker);current.newBounds(tracker);}this.blockStack.push(tracker);return tracker;};ElementStack.prototype.popBlock = function popBlock(){this.block().finalize(this);return _glimmerUtil.expect(this.blockStack.pop(),"Expected popBlock to return a block");};ElementStack.prototype.openElement = function openElement(tag){var operations=arguments.length <= 1 || arguments[1] === undefined?this.defaultOperations:arguments[1];var element=this.dom.createElement(tag,this.element);this.constructing = element;this.operations = operations;return element;};ElementStack.prototype.flushElement = function flushElement(){var parent=this.element;var element=_glimmerUtil.expect(this.constructing,'flushElement should only be called when constructing an element');this.dom.insertBefore(parent,element,this.nextSibling);this.constructing = null;this.operations = null;this.pushElement(element);this.block().openElement(element);};ElementStack.prototype.pushRemoteElement = function pushRemoteElement(element){this.pushElement(element);var tracker=new RemoteBlockTracker(element);this.pushBlockTracker(tracker,true);};ElementStack.prototype.popRemoteElement = function popRemoteElement(){this.popBlock();this.popElement();};ElementStack.prototype.pushElement = function pushElement(element){this.element = element;this.elementStack.push(element); // LOGGER.debug(`-> element stack ${this.elementStack.toArray().map(e => e.tagName).join(', ')}`);
this.nextSibling = null;this.nextSiblingStack.push(null);};ElementStack.prototype.newDestroyable = function newDestroyable(d){this.block().newDestroyable(d);};ElementStack.prototype.newBounds = function newBounds(bounds){this.block().newBounds(bounds);};ElementStack.prototype.appendText = function appendText(string){var dom=this.dom;var text=dom.createTextNode(string);dom.insertBefore(this.element,text,this.nextSibling);this.block().newNode(text);return text;};ElementStack.prototype.appendComment = function appendComment(string){var dom=this.dom;var comment=dom.createComment(string);dom.insertBefore(this.element,comment,this.nextSibling);this.block().newNode(comment);return comment;};ElementStack.prototype.setStaticAttribute = function setStaticAttribute(name,value){this.expectOperations('setStaticAttribute').addStaticAttribute(this.expectConstructing('setStaticAttribute'),name,value);};ElementStack.prototype.setStaticAttributeNS = function setStaticAttributeNS(namespace,name,value){this.expectOperations('setStaticAttributeNS').addStaticAttributeNS(this.expectConstructing('setStaticAttributeNS'),namespace,name,value);};ElementStack.prototype.setDynamicAttribute = function setDynamicAttribute(name,reference,isTrusting){this.expectOperations('setDynamicAttribute').addDynamicAttribute(this.expectConstructing('setDynamicAttribute'),name,reference,isTrusting);};ElementStack.prototype.setDynamicAttributeNS = function setDynamicAttributeNS(namespace,name,reference,isTrusting){this.expectOperations('setDynamicAttributeNS').addDynamicAttributeNS(this.expectConstructing('setDynamicAttributeNS'),namespace,name,reference,isTrusting);};ElementStack.prototype.closeElement = function closeElement(){this.block().closeElement();this.popElement();};return ElementStack;})();var SimpleBlockTracker=(function(){function SimpleBlockTracker(parent){this.parent = parent;this.first = null;this.last = null;this.destroyables = null;this.nesting = 0;}SimpleBlockTracker.prototype.destroy = function destroy(){var destroyables=this.destroyables;if(destroyables && destroyables.length){for(var i=0;i < destroyables.length;i++) {destroyables[i].destroy();}}};SimpleBlockTracker.prototype.parentElement = function parentElement(){return this.parent;};SimpleBlockTracker.prototype.firstNode = function firstNode(){return this.first && this.first.firstNode();};SimpleBlockTracker.prototype.lastNode = function lastNode(){return this.last && this.last.lastNode();};SimpleBlockTracker.prototype.openElement = function openElement(element){this.newNode(element);this.nesting++;};SimpleBlockTracker.prototype.closeElement = function closeElement(){this.nesting--;};SimpleBlockTracker.prototype.newNode = function newNode(node){if(this.nesting !== 0)return;if(!this.first){this.first = new First(node);}this.last = new Last(node);};SimpleBlockTracker.prototype.newBounds = function newBounds(bounds){if(this.nesting !== 0)return;if(!this.first){this.first = bounds;}this.last = bounds;};SimpleBlockTracker.prototype.newDestroyable = function newDestroyable(d){this.destroyables = this.destroyables || [];this.destroyables.push(d);};SimpleBlockTracker.prototype.finalize = function finalize(stack){if(!this.first){stack.appendComment('');}};return SimpleBlockTracker;})();var RemoteBlockTracker=(function(_SimpleBlockTracker){babelHelpers.inherits(RemoteBlockTracker,_SimpleBlockTracker);function RemoteBlockTracker(){_SimpleBlockTracker.apply(this,arguments);}RemoteBlockTracker.prototype.destroy = function destroy(){_SimpleBlockTracker.prototype.destroy.call(this);clear(this);};return RemoteBlockTracker;})(SimpleBlockTracker);var UpdatableBlockTracker=(function(_SimpleBlockTracker2){babelHelpers.inherits(UpdatableBlockTracker,_SimpleBlockTracker2);function UpdatableBlockTracker(){_SimpleBlockTracker2.apply(this,arguments);}UpdatableBlockTracker.prototype.reset = function reset(env){var destroyables=this.destroyables;if(destroyables && destroyables.length){for(var i=0;i < destroyables.length;i++) {env.didDestroy(destroyables[i]);}}var nextSibling=clear(this);this.destroyables = null;this.first = null;this.last = null;return nextSibling;};return UpdatableBlockTracker;})(SimpleBlockTracker);var BlockListTracker=(function(){function BlockListTracker(parent,boundList){this.parent = parent;this.boundList = boundList;this.parent = parent;this.boundList = boundList;}BlockListTracker.prototype.destroy = function destroy(){this.boundList.forEachNode(function(node){return node.destroy();});};BlockListTracker.prototype.parentElement = function parentElement(){return this.parent;};BlockListTracker.prototype.firstNode = function firstNode(){var head=this.boundList.head();return head && head.firstNode();};BlockListTracker.prototype.lastNode = function lastNode(){var tail=this.boundList.tail();return tail && tail.lastNode();};BlockListTracker.prototype.openElement = function openElement(_element){_glimmerUtil.assert(false,'Cannot openElement directly inside a block list');};BlockListTracker.prototype.closeElement = function closeElement(){_glimmerUtil.assert(false,'Cannot closeElement directly inside a block list');};BlockListTracker.prototype.newNode = function newNode(_node){_glimmerUtil.assert(false,'Cannot create a new node directly inside a block list');};BlockListTracker.prototype.newBounds = function newBounds(_bounds){};BlockListTracker.prototype.newDestroyable = function newDestroyable(_d){};BlockListTracker.prototype.finalize = function finalize(_stack){};return BlockListTracker;})();var CompiledValue=(function(_CompiledExpression){babelHelpers.inherits(CompiledValue,_CompiledExpression);function CompiledValue(value){_CompiledExpression.call(this);this.type = "value";this.reference = PrimitiveReference.create(value);}CompiledValue.prototype.evaluate = function evaluate(_vm){return this.reference;};CompiledValue.prototype.toJSON = function toJSON(){return JSON.stringify(this.reference.value());};return CompiledValue;})(CompiledExpression);var CompiledHasBlock=(function(_CompiledExpression2){babelHelpers.inherits(CompiledHasBlock,_CompiledExpression2);function CompiledHasBlock(inner){_CompiledExpression2.call(this);this.inner = inner;this.type = "has-block";}CompiledHasBlock.prototype.evaluate = function evaluate(vm){var block=this.inner.evaluate(vm);return PrimitiveReference.create(!!block);};CompiledHasBlock.prototype.toJSON = function toJSON(){return 'has-block(' + this.inner.toJSON() + ')';};return CompiledHasBlock;})(CompiledExpression);var CompiledHasBlockParams=(function(_CompiledExpression3){babelHelpers.inherits(CompiledHasBlockParams,_CompiledExpression3);function CompiledHasBlockParams(inner){_CompiledExpression3.call(this);this.inner = inner;this.type = "has-block-params";}CompiledHasBlockParams.prototype.evaluate = function evaluate(vm){var block=this.inner.evaluate(vm);var hasLocals=block && block.symbolTable.getSymbols().locals;return PrimitiveReference.create(!!hasLocals);};CompiledHasBlockParams.prototype.toJSON = function toJSON(){return 'has-block-params(' + this.inner.toJSON() + ')';};return CompiledHasBlockParams;})(CompiledExpression);var CompiledGetBlockBySymbol=(function(){function CompiledGetBlockBySymbol(symbol,debug){this.symbol = symbol;this.debug = debug;}CompiledGetBlockBySymbol.prototype.evaluate = function evaluate(vm){return vm.scope().getBlock(this.symbol);};CompiledGetBlockBySymbol.prototype.toJSON = function toJSON(){return 'get-block($' + this.symbol + '(' + this.debug + '))';};return CompiledGetBlockBySymbol;})();var CompiledInPartialGetBlock=(function(){function CompiledInPartialGetBlock(symbol,name){this.symbol = symbol;this.name = name;}CompiledInPartialGetBlock.prototype.evaluate = function evaluate(vm){var symbol=this.symbol;var name=this.name;var args=vm.scope().getPartialArgs(symbol);return args.blocks[name];};CompiledInPartialGetBlock.prototype.toJSON = function toJSON(){return 'get-block($' + this.symbol + '($ARGS).' + this.name + '))';};return CompiledInPartialGetBlock;})();var CompiledBlock=function CompiledBlock(start,end){this.start = start;this.end = end;};var CompiledProgram=(function(_CompiledBlock){babelHelpers.inherits(CompiledProgram,_CompiledBlock);function CompiledProgram(start,end,symbols){_CompiledBlock.call(this,start,end);this.symbols = symbols;}return CompiledProgram;})(CompiledBlock);var Labels=(function(){function Labels(){this.labels = _glimmerUtil.dict();this.jumps = [];this.ranges = [];}Labels.prototype.label = function label(name,index){this.labels[name] = index;};Labels.prototype.jump = function jump(at,Target,target){this.jumps.push({at:at,target:target,Target:Target});};Labels.prototype.range = function range(at,Range,start,end){this.ranges.push({at:at,start:start,end:end,Range:Range});};Labels.prototype.patch = function patch(opcodes){for(var i=0;i < this.jumps.length;i++) {var _jumps$i=this.jumps[i];var at=_jumps$i.at;var target=_jumps$i.target;var Target=_jumps$i.Target;opcodes.set(at,Target,this.labels[target]);}for(var i=0;i < this.ranges.length;i++) {var _ranges$i=this.ranges[i];var at=_ranges$i.at;var start=_ranges$i.start;var end=_ranges$i.end;var _Range=_ranges$i.Range;opcodes.set(at,_Range,this.labels[start],this.labels[end] - 1);}};return Labels;})();var BasicOpcodeBuilder=(function(){function BasicOpcodeBuilder(symbolTable,env,program){this.symbolTable = symbolTable;this.env = env;this.program = program;this.labelsStack = new _glimmerUtil.Stack();this.constants = env.constants;this.start = program.next;}BasicOpcodeBuilder.prototype.opcode = function opcode(name,op1,op2,op3){this.push(name,op1,op2,op3);};BasicOpcodeBuilder.prototype.push = function push(type){var op1=arguments.length <= 1 || arguments[1] === undefined?0:arguments[1];var op2=arguments.length <= 2 || arguments[2] === undefined?0:arguments[2];var op3=arguments.length <= 3 || arguments[3] === undefined?0:arguments[3];this.program.push(type,op1,op2,op3);}; // helpers
BasicOpcodeBuilder.prototype.startLabels = function startLabels(){this.labelsStack.push(new Labels());};BasicOpcodeBuilder.prototype.stopLabels = function stopLabels(){var label=_glimmerUtil.expect(this.labelsStack.pop(),'unbalanced push and pop labels');label.patch(this.program);}; // partials
BasicOpcodeBuilder.prototype.putPartialDefinition = function putPartialDefinition(_definition){var definition=this.constants.other(_definition);this.opcode(50, /* PutPartial */definition);};BasicOpcodeBuilder.prototype.putDynamicPartialDefinition = function putDynamicPartialDefinition(){this.opcode(49, /* PutDynamicPartial */this.constants.other(this.symbolTable));};BasicOpcodeBuilder.prototype.evaluatePartial = function evaluatePartial(){this.opcode(51, /* EvaluatePartial */this.constants.other(this.symbolTable),this.constants.other(_glimmerUtil.dict()));}; // components
BasicOpcodeBuilder.prototype.putComponentDefinition = function putComponentDefinition(definition){this.opcode(23, /* PutComponent */this.other(definition));};BasicOpcodeBuilder.prototype.putDynamicComponentDefinition = function putDynamicComponentDefinition(){this.opcode(22 /* PutDynamicComponent */);};BasicOpcodeBuilder.prototype.openComponent = function openComponent(args,shadow){this.opcode(24, /* OpenComponent */this.args(args),shadow?this.block(shadow):0);};BasicOpcodeBuilder.prototype.didCreateElement = function didCreateElement(){this.opcode(25 /* DidCreateElement */);};BasicOpcodeBuilder.prototype.shadowAttributes = function shadowAttributes(){this.opcode(26 /* ShadowAttributes */);this.opcode(21 /* CloseBlock */);};BasicOpcodeBuilder.prototype.didRenderLayout = function didRenderLayout(){this.opcode(27 /* DidRenderLayout */);};BasicOpcodeBuilder.prototype.closeComponent = function closeComponent(){this.opcode(28 /* CloseComponent */);}; // content
BasicOpcodeBuilder.prototype.dynamicContent = function dynamicContent(Opcode){this.opcode(31, /* DynamicContent */this.other(Opcode));};BasicOpcodeBuilder.prototype.cautiousAppend = function cautiousAppend(){this.dynamicContent(new OptimizedCautiousAppendOpcode());};BasicOpcodeBuilder.prototype.trustingAppend = function trustingAppend(){this.dynamicContent(new OptimizedTrustingAppendOpcode());};BasicOpcodeBuilder.prototype.guardedCautiousAppend = function guardedCautiousAppend(expression){this.dynamicContent(new GuardedCautiousAppendOpcode(this.compileExpression(expression),this.symbolTable));};BasicOpcodeBuilder.prototype.guardedTrustingAppend = function guardedTrustingAppend(expression){this.dynamicContent(new GuardedTrustingAppendOpcode(this.compileExpression(expression),this.symbolTable));}; // dom
BasicOpcodeBuilder.prototype.text = function text(_text){this.opcode(29, /* Text */this.constants.string(_text));};BasicOpcodeBuilder.prototype.openPrimitiveElement = function openPrimitiveElement(tag){this.opcode(32, /* OpenElement */this.constants.string(tag));};BasicOpcodeBuilder.prototype.openComponentElement = function openComponentElement(tag){this.opcode(35, /* OpenComponentElement */this.constants.string(tag));};BasicOpcodeBuilder.prototype.openDynamicPrimitiveElement = function openDynamicPrimitiveElement(){this.opcode(36 /* OpenDynamicElement */);};BasicOpcodeBuilder.prototype.flushElement = function flushElement(){this.opcode(37 /* FlushElement */);};BasicOpcodeBuilder.prototype.closeElement = function closeElement(){this.opcode(38 /* CloseElement */);};BasicOpcodeBuilder.prototype.staticAttr = function staticAttr(_name,_namespace,_value){var name=this.constants.string(_name);var namespace=_namespace?this.constants.string(_namespace):0;var value=this.constants.string(_value);this.opcode(40, /* StaticAttr */name,value,namespace);};BasicOpcodeBuilder.prototype.dynamicAttrNS = function dynamicAttrNS(_name,_namespace,trusting){var name=this.constants.string(_name);var namespace=this.constants.string(_namespace);this.opcode(42, /* DynamicAttrNS */name,namespace,trusting | 0);};BasicOpcodeBuilder.prototype.dynamicAttr = function dynamicAttr(_name,trusting){var name=this.constants.string(_name);this.opcode(43, /* DynamicAttr */name,trusting | 0);};BasicOpcodeBuilder.prototype.comment = function comment(_comment){var comment=this.constants.string(_comment);this.opcode(30, /* Comment */comment);};BasicOpcodeBuilder.prototype.modifier = function modifier(_name,_args){var args=this.constants.expression(this.compile(_args));var _modifierManager=this.env.lookupModifier(_name,this.symbolTable);var modifierManager=this.constants.other(_modifierManager);var name=this.constants.string(_name);this.opcode(41, /* Modifier */name,modifierManager,args);}; // lists
BasicOpcodeBuilder.prototype.putIterator = function putIterator(){this.opcode(44 /* PutIterator */);};BasicOpcodeBuilder.prototype.enterList = function enterList(start,end){this.push(45 /* EnterList */);this.labels.range(this.pos,45, /* EnterList */start,end);};BasicOpcodeBuilder.prototype.exitList = function exitList(){this.opcode(46 /* ExitList */);};BasicOpcodeBuilder.prototype.enterWithKey = function enterWithKey(start,end){this.push(47 /* EnterWithKey */);this.labels.range(this.pos,47, /* EnterWithKey */start,end);};BasicOpcodeBuilder.prototype.nextIter = function nextIter(end){this.push(48 /* NextIter */);this.labels.jump(this.pos,48, /* NextIter */end);}; // vm
BasicOpcodeBuilder.prototype.openBlock = function openBlock(_args,_inner){var args=this.constants.expression(this.compile(_args));var inner=this.constants.other(_inner);this.opcode(20, /* OpenBlock */inner,args);};BasicOpcodeBuilder.prototype.closeBlock = function closeBlock(){this.opcode(21 /* CloseBlock */);};BasicOpcodeBuilder.prototype.pushRemoteElement = function pushRemoteElement(){this.opcode(33 /* PushRemoteElement */);};BasicOpcodeBuilder.prototype.popRemoteElement = function popRemoteElement(){this.opcode(34 /* PopRemoteElement */);};BasicOpcodeBuilder.prototype.popElement = function popElement(){this.opcode(39 /* PopElement */);};BasicOpcodeBuilder.prototype.label = function label(name){this.labels.label(name,this.nextPos);};BasicOpcodeBuilder.prototype.pushChildScope = function pushChildScope(){this.opcode(0 /* PushChildScope */);};BasicOpcodeBuilder.prototype.popScope = function popScope(){this.opcode(1 /* PopScope */);};BasicOpcodeBuilder.prototype.pushDynamicScope = function pushDynamicScope(){this.opcode(2 /* PushDynamicScope */);};BasicOpcodeBuilder.prototype.popDynamicScope = function popDynamicScope(){this.opcode(3 /* PopDynamicScope */);};BasicOpcodeBuilder.prototype.putNull = function putNull(){this.opcode(4, /* Put */this.constants.NULL_REFERENCE);};BasicOpcodeBuilder.prototype.putValue = function putValue(_expression){var expr=this.constants.expression(this.compileExpression(_expression));this.opcode(5, /* EvaluatePut */expr);};BasicOpcodeBuilder.prototype.putArgs = function putArgs(_args){var args=this.constants.expression(this.compile(_args));this.opcode(6, /* PutArgs */args);};BasicOpcodeBuilder.prototype.bindDynamicScope = function bindDynamicScope(_names){this.opcode(12, /* BindDynamicScope */this.names(_names));};BasicOpcodeBuilder.prototype.bindPositionalArgs = function bindPositionalArgs(_names,_symbols){this.opcode(7, /* BindPositionalArgs */this.names(_names),this.symbols(_symbols));};BasicOpcodeBuilder.prototype.bindNamedArgs = function bindNamedArgs(_names,_symbols){this.opcode(8, /* BindNamedArgs */this.names(_names),this.symbols(_symbols));};BasicOpcodeBuilder.prototype.bindBlocks = function bindBlocks(_names,_symbols){this.opcode(9, /* BindBlocks */this.names(_names),this.symbols(_symbols));};BasicOpcodeBuilder.prototype.enter = function enter(_enter,exit){this.push(13 /* Enter */);this.labels.range(this.pos,13, /* Enter */_enter,exit);};BasicOpcodeBuilder.prototype.exit = function exit(){this.opcode(14 /* Exit */);};BasicOpcodeBuilder.prototype.evaluate = function evaluate(_block){var block=this.constants.block(_block);this.opcode(15, /* Evaluate */block);};BasicOpcodeBuilder.prototype.test = function test(testFunc){var _func=undefined;if(testFunc === 'const'){_func = ConstTest;}else if(testFunc === 'simple'){_func = SimpleTest;}else if(testFunc === 'environment'){_func = EnvironmentTest;}else if(typeof testFunc === 'function'){_func = testFunc;}else {throw new Error('unreachable');}var func=this.constants.function(_func);this.opcode(19, /* Test */func);};BasicOpcodeBuilder.prototype.jump = function jump(target){this.push(16 /* Jump */);this.labels.jump(this.pos,16, /* Jump */target);};BasicOpcodeBuilder.prototype.jumpIf = function jumpIf(target){this.push(17 /* JumpIf */);this.labels.jump(this.pos,17, /* JumpIf */target);};BasicOpcodeBuilder.prototype.jumpUnless = function jumpUnless(target){this.push(18 /* JumpUnless */);this.labels.jump(this.pos,18, /* JumpUnless */target);};BasicOpcodeBuilder.prototype.names = function names(_names){var _this=this;var names=_names.map(function(n){return _this.constants.string(n);});return this.constants.array(names);};BasicOpcodeBuilder.prototype.symbols = function symbols(_symbols2){return this.constants.array(_symbols2);};BasicOpcodeBuilder.prototype.other = function other(value){return this.constants.other(value);};BasicOpcodeBuilder.prototype.args = function args(_args2){return this.constants.expression(this.compile(_args2));};BasicOpcodeBuilder.prototype.block = function block(_block3){return this.constants.block(_block3);};babelHelpers.createClass(BasicOpcodeBuilder,[{key:'end',get:function(){return this.program.next;}},{key:'pos',get:function(){return this.program.current;}},{key:'nextPos',get:function(){return this.program.next;}},{key:'labels',get:function(){return _glimmerUtil.expect(this.labelsStack.current,'bug: not in a label stack');}}]);return BasicOpcodeBuilder;})();function isCompilableExpression(expr){return expr && typeof expr['compile'] === 'function';}var OpcodeBuilder=(function(_BasicOpcodeBuilder){babelHelpers.inherits(OpcodeBuilder,_BasicOpcodeBuilder);function OpcodeBuilder(symbolTable,env){var program=arguments.length <= 2 || arguments[2] === undefined?env.program:arguments[2];return (function(){_BasicOpcodeBuilder.call(this,symbolTable,env,program);this.component = new ComponentBuilder(this);}).apply(this,arguments);}OpcodeBuilder.prototype.compile = function compile(expr){if(isCompilableExpression(expr)){return expr.compile(this);}else {return expr;}};OpcodeBuilder.prototype.compileExpression = function compileExpression(expression){if(expression instanceof CompiledExpression){return expression;}else {return expr(expression,this);}};OpcodeBuilder.prototype.bindPositionalArgsForLocals = function bindPositionalArgsForLocals(locals){var names=Object.keys(locals);var symbols=new Array(names.length); //Object.keys(locals).map(name => locals[name]);
for(var i=0;i < names.length;i++) {symbols[i] = locals[names[i]];}this.opcode(7, /* BindPositionalArgs */this.symbols(symbols));};OpcodeBuilder.prototype.preludeForLayout = function preludeForLayout(layout){var _this2=this;var symbols=layout.symbolTable.getSymbols();if(symbols.named){(function(){var named=symbols.named;var namedNames=Object.keys(named);var namedSymbols=namedNames.map(function(n){return named[n];});_this2.opcode(8, /* BindNamedArgs */_this2.names(namedNames),_this2.symbols(namedSymbols));})();}this.opcode(11 /* BindCallerScope */);if(symbols.yields){(function(){var yields=symbols.yields;var yieldNames=Object.keys(yields);var yieldSymbols=yieldNames.map(function(n){return yields[n];});_this2.opcode(9, /* BindBlocks */_this2.names(yieldNames),_this2.symbols(yieldSymbols));})();}if(symbols.partialArgs){this.opcode(10, /* BindPartialArgs */symbols.partialArgs);}};OpcodeBuilder.prototype.yield = function _yield(args,to){var yields=undefined,partial=undefined;var inner=undefined;if(yields = this.symbolTable.getSymbol('yields',to)){inner = new CompiledGetBlockBySymbol(yields,to);}else if(partial = this.symbolTable.getPartialArgs()){inner = new CompiledInPartialGetBlock(partial,to);}else {throw new Error('[BUG] ${to} is not a valid block name.');}this.openBlock(args,inner);this.closeBlock();}; // TODO
// come back to this
OpcodeBuilder.prototype.labelled = function labelled(args,callback){if(args)this.putArgs(args);this.startLabels();this.enter('BEGIN','END');this.label('BEGIN');callback(this,'BEGIN','END');this.label('END');this.exit();this.stopLabels();}; // TODO
// come back to this
OpcodeBuilder.prototype.iter = function iter(callback){this.startLabels();this.enterList('BEGIN','END');this.label('ITER');this.nextIter('BREAK');this.enterWithKey('BEGIN','END');this.label('BEGIN');callback(this,'BEGIN','END');this.label('END');this.exit();this.jump('ITER');this.label('BREAK');this.exitList();this.stopLabels();}; // TODO
// come back to this
OpcodeBuilder.prototype.unit = function unit(callback){this.startLabels();callback(this);this.stopLabels();};return OpcodeBuilder;})(BasicOpcodeBuilder);function compileLayout(compilable,env){var builder=new ComponentLayoutBuilder(env);compilable.compile(builder);return builder.compile();}var ComponentLayoutBuilder=(function(){function ComponentLayoutBuilder(env){this.env = env;}ComponentLayoutBuilder.prototype.wrapLayout = function wrapLayout(layout){this.inner = new WrappedBuilder(this.env,layout);};ComponentLayoutBuilder.prototype.fromLayout = function fromLayout(layout){this.inner = new UnwrappedBuilder(this.env,layout);};ComponentLayoutBuilder.prototype.compile = function compile(){return this.inner.compile();};babelHelpers.createClass(ComponentLayoutBuilder,[{key:'tag',get:function(){return this.inner.tag;}},{key:'attrs',get:function(){return this.inner.attrs;}}]);return ComponentLayoutBuilder;})();var WrappedBuilder=(function(){function WrappedBuilder(env,layout){this.env = env;this.layout = layout;this.tag = new ComponentTagBuilder();this.attrs = new ComponentAttrsBuilder();}WrappedBuilder.prototype.compile = function compile(){ //========DYNAMIC
//        PutValue(TagExpr)
//        Test
//        JumpUnless(BODY)
//        OpenDynamicPrimitiveElement
//        DidCreateElement
//        ...attr statements...
//        FlushElement
// BODY:  Noop
//        ...body statements...
//        PutValue(TagExpr)
//        Test
//        JumpUnless(END)
//        CloseElement
// END:   Noop
//        DidRenderLayout
//        Exit
//
//========STATIC
//        OpenPrimitiveElementOpcode
//        DidCreateElement
//        ...attr statements...
//        FlushElement
//        ...body statements...
//        CloseElement
//        DidRenderLayout
//        Exit
var env=this.env;var layout=this.layout;var symbolTable=layout.symbolTable;var b=builder(env,layout.symbolTable);b.startLabels();var dynamicTag=this.tag.getDynamic();var staticTag=undefined;if(dynamicTag){b.putValue(dynamicTag);b.test('simple');b.jumpUnless('BODY');b.openDynamicPrimitiveElement();b.didCreateElement();this.attrs['buffer'].forEach(function(statement){return compileStatement(statement,b);});b.flushElement();b.label('BODY');}else if(staticTag = this.tag.getStatic()){b.openPrimitiveElement(staticTag);b.didCreateElement();this.attrs['buffer'].forEach(function(statement){return compileStatement(statement,b);});b.flushElement();}b.preludeForLayout(layout);layout.statements.forEach(function(statement){return compileStatement(statement,b);});if(dynamicTag){b.putValue(dynamicTag);b.test('simple');b.jumpUnless('END');b.closeElement();b.label('END');}else if(staticTag){b.closeElement();}b.didRenderLayout();b.stopLabels();return new CompiledProgram(b.start,b.end,symbolTable.size);};return WrappedBuilder;})();function isOpenElement(value){var type=value[0];return type === _glimmerWireFormat.Ops.OpenElement || type === _glimmerWireFormat.Ops.OpenPrimitiveElement;}var UnwrappedBuilder=(function(){function UnwrappedBuilder(env,layout){this.env = env;this.layout = layout;this.attrs = new ComponentAttrsBuilder();}UnwrappedBuilder.prototype.compile = function compile(){var env=this.env;var layout=this.layout;var b=builder(env,layout.symbolTable);b.startLabels();b.preludeForLayout(layout);var attrs=this.attrs['buffer'];var attrsInserted=false;for(var i=0;i < layout.statements.length;i++) {var statement=layout.statements[i];if(!attrsInserted && isOpenElement(statement)){b.openComponentElement(statement[1]);b.didCreateElement();b.shadowAttributes();attrs.forEach(function(statement){return compileStatement(statement,b);});attrsInserted = true;}else {compileStatement(statement,b);}}b.didRenderLayout();b.stopLabels();return new CompiledProgram(b.start,b.end,layout.symbolTable.size);};babelHelpers.createClass(UnwrappedBuilder,[{key:'tag',get:function(){throw new Error('BUG: Cannot call `tag` on an UnwrappedBuilder');}}]);return UnwrappedBuilder;})();var ComponentTagBuilder=(function(){function ComponentTagBuilder(){this.isDynamic = null;this.isStatic = null;this.staticTagName = null;this.dynamicTagName = null;}ComponentTagBuilder.prototype.getDynamic = function getDynamic(){if(this.isDynamic){return this.dynamicTagName;}};ComponentTagBuilder.prototype.getStatic = function getStatic(){if(this.isStatic){return this.staticTagName;}};ComponentTagBuilder.prototype.static = function _static(tagName){this.isStatic = true;this.staticTagName = tagName;};ComponentTagBuilder.prototype.dynamic = function dynamic(tagName){this.isDynamic = true;this.dynamicTagName = [_glimmerWireFormat.Ops.Function,tagName];};return ComponentTagBuilder;})();var ComponentAttrsBuilder=(function(){function ComponentAttrsBuilder(){this.buffer = [];}ComponentAttrsBuilder.prototype.static = function _static(name,value){this.buffer.push([_glimmerWireFormat.Ops.StaticAttr,name,value,null]);};ComponentAttrsBuilder.prototype.dynamic = function dynamic(name,value){this.buffer.push([_glimmerWireFormat.Ops.DynamicAttr,name,[_glimmerWireFormat.Ops.Function,value],null]);};return ComponentAttrsBuilder;})();var ComponentBuilder=(function(){function ComponentBuilder(builder){this.builder = builder;this.env = builder.env;}ComponentBuilder.prototype.static = function _static(definition,args,_symbolTable,shadow){this.builder.unit(function(b){b.putComponentDefinition(definition);b.openComponent(compileBaselineArgs(args,b),shadow);b.closeComponent();});};ComponentBuilder.prototype.dynamic = function dynamic(definitionArgs,definition,args,_symbolTable,shadow){this.builder.unit(function(b){b.putArgs(compileArgs(definitionArgs[0],definitionArgs[1],b));b.putValue([_glimmerWireFormat.Ops.Function,definition]);b.test('simple');b.enter('BEGIN','END');b.label('BEGIN');b.jumpUnless('END');b.putDynamicComponentDefinition();b.openComponent(compileBaselineArgs(args,b),shadow);b.closeComponent();b.label('END');b.exit();});};return ComponentBuilder;})();function builder(env,symbolTable){return new OpcodeBuilder(symbolTable,env);}function entryPoint(meta){return new ProgramSymbolTable(meta);}function layout(meta,wireNamed,wireYields,hasPartials){var _symbols3=symbols(wireNamed,wireYields,hasPartials);var named=_symbols3.named;var yields=_symbols3.yields;var partialSymbol=_symbols3.partialSymbol;var size=_symbols3.size;return new ProgramSymbolTable(meta,named,yields,partialSymbol,size);}function block(parent,locals){var localsMap=null;var program=parent['program'];if(locals.length !== 0){(function(){var map=localsMap = _glimmerUtil.dict();locals.forEach(function(l){return map[l] = program.size++;});})();}return new BlockSymbolTable(parent,program,localsMap);}function symbols(named,yields,hasPartials){var yieldsMap=null;var namedMap=null;var size=1;if(yields.length !== 0){(function(){var map=yieldsMap = _glimmerUtil.dict();yields.forEach(function(y){return map[y] = size++;});})();}if(named.length !== 0){(function(){var map=namedMap = _glimmerUtil.dict();named.forEach(function(y){return map[y] = size++;});})();}var partialSymbol=hasPartials?size++:null;return {named:namedMap,yields:yieldsMap,partialSymbol:partialSymbol,size:size};}var ProgramSymbolTable=(function(){function ProgramSymbolTable(meta){var named=arguments.length <= 1 || arguments[1] === undefined?null:arguments[1];var yields=arguments.length <= 2 || arguments[2] === undefined?null:arguments[2];var partialArgs=arguments.length <= 3 || arguments[3] === undefined?null:arguments[3];var size=arguments.length <= 4 || arguments[4] === undefined?1:arguments[4];this.meta = meta;this.named = named;this.yields = yields;this.partialArgs = partialArgs;this.size = size;this.program = this;}ProgramSymbolTable.prototype.getMeta = function getMeta(){return this.meta;};ProgramSymbolTable.prototype.getSymbols = function getSymbols(){return {named:this.named,yields:this.yields,locals:null,partialArgs:this.partialArgs};};ProgramSymbolTable.prototype.getSymbol = function getSymbol(kind,name){if(kind === 'local')return null;return this[kind] && this[kind][name];};ProgramSymbolTable.prototype.getPartialArgs = function getPartialArgs(){return this.partialArgs || 0;};return ProgramSymbolTable;})();var BlockSymbolTable=(function(){function BlockSymbolTable(parent,program,locals){this.parent = parent;this.program = program;this.locals = locals;}BlockSymbolTable.prototype.getMeta = function getMeta(){return this.program.getMeta();};BlockSymbolTable.prototype.getSymbols = function getSymbols(){return {named:null,yields:null,locals:this.locals,partialArgs:null};};BlockSymbolTable.prototype.getSymbol = function getSymbol(kind,name){if(kind === 'local'){return this.getLocal(name);}else {return this.program.getSymbol(kind,name);}};BlockSymbolTable.prototype.getLocal = function getLocal(name){var locals=this.locals;var parent=this.parent;var symbol=locals && locals[name];if(!symbol && parent){symbol = parent.getSymbol('local',name);}return symbol;};BlockSymbolTable.prototype.getPartialArgs = function getPartialArgs(){return this.program.getPartialArgs();};return BlockSymbolTable;})();var Specialize=(function(){function Specialize(){this.names = _glimmerUtil.dict();this.funcs = [];}Specialize.prototype.add = function add(name,func){this.funcs.push(func);this.names[name] = this.funcs.length - 1;};Specialize.prototype.specialize = function specialize(sexp,table){var name=sexp[0];var index=this.names[name];if(index === undefined)return sexp;var func=this.funcs[index];_glimmerUtil.assert(!!func,'expected a specialization for ' + sexp[0]);return func(sexp,table);};return Specialize;})();var SPECIALIZE=new Specialize();var E=_glimmerWireFormat.Expressions;var Ops$3=_glimmerWireFormat.Ops;SPECIALIZE.add(Ops$3.Append,function(sexp,_symbolTable){var expression=sexp[1];if(Array.isArray(expression) && E.isGet(expression)){var path=expression[1];if(path.length !== 1){return [Ops$3.UnoptimizedAppend,sexp[1],sexp[2]];}}return [Ops$3.OptimizedAppend,sexp[1],sexp[2]];});SPECIALIZE.add(Ops$3.DynamicAttr,function(sexp,_symbolTable){return [Ops$3.AnyDynamicAttr,sexp[1],sexp[2],sexp[3],false];});SPECIALIZE.add(Ops$3.TrustingAttr,function(sexp,_symbolTable){return [Ops$3.AnyDynamicAttr,sexp[1],sexp[2],sexp[3],true];});SPECIALIZE.add(Ops$3.Partial,function(sexp,_table){var expression=sexp[1];if(typeof expression === 'string'){return [Ops$3.StaticPartial,expression];}else {return [Ops$3.DynamicPartial,expression];}});function compileStatement(statement,builder){var refined=SPECIALIZE.specialize(statement,builder.symbolTable);STATEMENTS.compile(refined,builder);}var Template=function Template(statements,symbolTable){this.statements = statements;this.symbolTable = symbolTable;};var Layout=(function(_Template){babelHelpers.inherits(Layout,_Template);function Layout(){_Template.apply(this,arguments);}return Layout;})(Template);var EntryPoint=(function(_Template2){babelHelpers.inherits(EntryPoint,_Template2);function EntryPoint(){_Template2.apply(this,arguments);this.compiled = null;}EntryPoint.prototype.compile = function compile(env){var compiled=this.compiled;if(!compiled){var table=this.symbolTable;var b=builder(env,table);for(var i=0;i < this.statements.length;i++) {var statement=this.statements[i];var refined=SPECIALIZE.specialize(statement,table);STATEMENTS.compile(refined,b);}compiled = this.compiled = new CompiledProgram(b.start,b.end,this.symbolTable.size);}return compiled;};return EntryPoint;})(Template);var InlineBlock=(function(_Template3){babelHelpers.inherits(InlineBlock,_Template3);function InlineBlock(){_Template3.apply(this,arguments);this.compiled = null;}InlineBlock.prototype.splat = function splat(builder){var table=builder.symbolTable;var locals=table.getSymbols().locals;if(locals){builder.pushChildScope();builder.bindPositionalArgsForLocals(locals);}for(var i=0;i < this.statements.length;i++) {var statement=this.statements[i];var refined=SPECIALIZE.specialize(statement,table);STATEMENTS.compile(refined,builder);}if(locals){builder.popScope();}};InlineBlock.prototype.compile = function compile(env){var compiled=this.compiled;if(!compiled){var table=this.symbolTable;var b=builder(env,table);this.splat(b);compiled = this.compiled = new CompiledBlock(b.start,b.end);}return compiled;};return InlineBlock;})(Template);var PartialBlock=(function(_Template4){babelHelpers.inherits(PartialBlock,_Template4);function PartialBlock(){_Template4.apply(this,arguments);this.compiled = null;}PartialBlock.prototype.compile = function compile(env){var compiled=this.compiled;if(!compiled){var table=this.symbolTable;var b=builder(env,table);for(var i=0;i < this.statements.length;i++) {var statement=this.statements[i];var refined=SPECIALIZE.specialize(statement,table);STATEMENTS.compile(refined,b);}compiled = this.compiled = new CompiledProgram(b.start,b.end,table.size);}return compiled;};return PartialBlock;})(Template);var Scanner=(function(){function Scanner(block,meta,env){this.block = block;this.meta = meta;this.env = env;}Scanner.prototype.scanEntryPoint = function scanEntryPoint(){var block=this.block;var meta=this.meta;var symbolTable=entryPoint(meta);var child=scanBlock(block,symbolTable,this.env);return new EntryPoint(child.statements,symbolTable);};Scanner.prototype.scanLayout = function scanLayout(){var block=this.block;var meta=this.meta;var named=block.named;var yields=block.yields;var hasPartials=block.hasPartials;var symbolTable=layout(meta,named,yields,hasPartials);var child=scanBlock(block,symbolTable,this.env);return new Layout(child.statements,symbolTable);};Scanner.prototype.scanPartial = function scanPartial(symbolTable){var block=this.block;var child=scanBlock(block,symbolTable,this.env);return new PartialBlock(child.statements,symbolTable);};return Scanner;})();function scanBlock(_ref26,symbolTable,env){var statements=_ref26.statements;return new RawInlineBlock(env,symbolTable,statements).scan();}var BaselineSyntax;(function(BaselineSyntax){var Ops=_glimmerWireFormat.Ops;BaselineSyntax.isScannedComponent = _glimmerWireFormat.is(Ops.ScannedComponent);BaselineSyntax.isPrimitiveElement = _glimmerWireFormat.is(Ops.OpenPrimitiveElement);BaselineSyntax.isOptimizedAppend = _glimmerWireFormat.is(Ops.OptimizedAppend);BaselineSyntax.isUnoptimizedAppend = _glimmerWireFormat.is(Ops.UnoptimizedAppend);BaselineSyntax.isAnyAttr = _glimmerWireFormat.is(Ops.AnyDynamicAttr);BaselineSyntax.isStaticPartial = _glimmerWireFormat.is(Ops.StaticPartial);BaselineSyntax.isDynamicPartial = _glimmerWireFormat.is(Ops.DynamicPartial);BaselineSyntax.isFunctionExpression = _glimmerWireFormat.is(Ops.Function);BaselineSyntax.isNestedBlock = _glimmerWireFormat.is(Ops.NestedBlock);BaselineSyntax.isScannedBlock = _glimmerWireFormat.is(Ops.ScannedBlock);BaselineSyntax.isDebugger = _glimmerWireFormat.is(Ops.Debugger);var NestedBlock;(function(NestedBlock){function defaultBlock(sexp){return sexp[4];}NestedBlock.defaultBlock = defaultBlock;function inverseBlock(sexp){return sexp[5];}NestedBlock.inverseBlock = inverseBlock;function params(sexp){return sexp[2];}NestedBlock.params = params;function hash(sexp){return sexp[3];}NestedBlock.hash = hash;})(NestedBlock = BaselineSyntax.NestedBlock || (BaselineSyntax.NestedBlock = {}));})(BaselineSyntax || (exports.BaselineSyntax = BaselineSyntax = {}));var Ops$2=_glimmerWireFormat.Ops;var RawInlineBlock=(function(){function RawInlineBlock(env,table,statements){this.env = env;this.table = table;this.statements = statements;}RawInlineBlock.prototype.scan = function scan(){var buffer=[];for(var i=0;i < this.statements.length;i++) {var statement=this.statements[i];if(_glimmerWireFormat.Statements.isBlock(statement)){buffer.push(this.specializeBlock(statement));}else if(_glimmerWireFormat.Statements.isComponent(statement)){buffer.push.apply(buffer,this.specializeComponent(statement));}else {buffer.push(statement);}}return new InlineBlock(buffer,this.table);};RawInlineBlock.prototype.specializeBlock = function specializeBlock(block$$){var path=block$$[1];var params=block$$[2];var hash=block$$[3];var template=block$$[4];var inverse=block$$[5];return [Ops$2.ScannedBlock,path,params,hash,this.child(template),this.child(inverse)];};RawInlineBlock.prototype.specializeComponent = function specializeComponent(sexp){var tag=sexp[1];var component=sexp[2];if(this.env.hasComponentDefinition(tag,this.table)){var child=this.child(component);var attrs=new RawInlineBlock(this.env,this.table,component.attrs);return [[Ops$2.ScannedComponent,tag,attrs,component.args,child]];}else {var buf=[];buf.push([Ops$2.OpenElement,tag,[]]);buf.push.apply(buf,component.attrs);buf.push([Ops$2.FlushElement]);buf.push.apply(buf,component.statements);buf.push([Ops$2.CloseElement]);return buf;}};RawInlineBlock.prototype.child = function child(block$$){if(!block$$)return null;var table=block(this.table,block$$.locals);return new RawInlineBlock(this.env,table,block$$.statements);};return RawInlineBlock;})();var CompiledLookup=(function(_CompiledExpression4){babelHelpers.inherits(CompiledLookup,_CompiledExpression4);function CompiledLookup(base,path){_CompiledExpression4.call(this);this.base = base;this.path = path;this.type = "lookup";}CompiledLookup.create = function create(base,path){if(path.length === 0){return base;}else {return new this(base,path);}};CompiledLookup.prototype.evaluate = function evaluate(vm){var base=this.base;var path=this.path;return _glimmerReference.referenceFromParts(base.evaluate(vm),path);};CompiledLookup.prototype.toJSON = function toJSON(){return this.base.toJSON() + '.' + this.path.join('.');};return CompiledLookup;})(CompiledExpression);var CompiledSelf=(function(_CompiledExpression5){babelHelpers.inherits(CompiledSelf,_CompiledExpression5);function CompiledSelf(){_CompiledExpression5.apply(this,arguments);}CompiledSelf.prototype.evaluate = function evaluate(vm){return vm.getSelf();};CompiledSelf.prototype.toJSON = function toJSON(){return 'self';};return CompiledSelf;})(CompiledExpression);var CompiledSymbol=(function(_CompiledExpression6){babelHelpers.inherits(CompiledSymbol,_CompiledExpression6);function CompiledSymbol(symbol,debug){_CompiledExpression6.call(this);this.symbol = symbol;this.debug = debug;}CompiledSymbol.prototype.evaluate = function evaluate(vm){return vm.referenceForSymbol(this.symbol);};CompiledSymbol.prototype.toJSON = function toJSON(){return '$' + this.symbol + '(' + this.debug + ')';};return CompiledSymbol;})(CompiledExpression);var CompiledInPartialName=(function(_CompiledExpression7){babelHelpers.inherits(CompiledInPartialName,_CompiledExpression7);function CompiledInPartialName(symbol,name){_CompiledExpression7.call(this);this.symbol = symbol;this.name = name;}CompiledInPartialName.prototype.evaluate = function evaluate(vm){var symbol=this.symbol;var name=this.name;var args=vm.scope().getPartialArgs(symbol);return args.named.get(name);};CompiledInPartialName.prototype.toJSON = function toJSON(){return '$' + this.symbol + '($ARGS).' + this.name;};return CompiledInPartialName;})(CompiledExpression);var CompiledHelper=(function(_CompiledExpression8){babelHelpers.inherits(CompiledHelper,_CompiledExpression8);function CompiledHelper(name,helper,args,symbolTable){_CompiledExpression8.call(this);this.name = name;this.helper = helper;this.args = args;this.symbolTable = symbolTable;this.type = "helper";}CompiledHelper.prototype.evaluate = function evaluate(vm){var helper=this.helper;return helper(vm,this.args.evaluate(vm),this.symbolTable);};CompiledHelper.prototype.toJSON = function toJSON(){return '`' + this.name + '($ARGS)`';};return CompiledHelper;})(CompiledExpression);var CompiledConcat=(function(){function CompiledConcat(parts){this.parts = parts;this.type = "concat";}CompiledConcat.prototype.evaluate = function evaluate(vm){var parts=new Array(this.parts.length);for(var i=0;i < this.parts.length;i++) {parts[i] = this.parts[i].evaluate(vm);}return new ConcatReference(parts);};CompiledConcat.prototype.toJSON = function toJSON(){return 'concat(' + this.parts.map(function(expr){return expr.toJSON();}).join(", ") + ')';};return CompiledConcat;})();var ConcatReference=(function(_CachedReference2){babelHelpers.inherits(ConcatReference,_CachedReference2);function ConcatReference(parts){_CachedReference2.call(this);this.parts = parts;this.tag = _glimmerReference.combineTagged(parts);}ConcatReference.prototype.compute = function compute(){var parts=new Array();for(var i=0;i < this.parts.length;i++) {var value=this.parts[i].value();if(value !== null && value !== undefined){parts[i] = castToString(value);}}if(parts.length > 0){return parts.join('');}return null;};return ConcatReference;})(_glimmerReference.CachedReference);function castToString(value){if(typeof value['toString'] !== 'function'){return '';}return String(value);}var CompiledFunctionExpression=(function(_CompiledExpression9){babelHelpers.inherits(CompiledFunctionExpression,_CompiledExpression9);function CompiledFunctionExpression(func,symbolTable){_CompiledExpression9.call(this);this.func = func;this.symbolTable = symbolTable;this.type = "function";this.func = func;}CompiledFunctionExpression.prototype.evaluate = function evaluate(vm){var func=this.func;var symbolTable=this.symbolTable;return func(vm,symbolTable);};CompiledFunctionExpression.prototype.toJSON = function toJSON(){var func=this.func;if(func.name){return '`' + func.name + '(...)`';}else {return "`func(...)`";}};return CompiledFunctionExpression;})(CompiledExpression);var _BaselineSyntax$NestedBlock=BaselineSyntax.NestedBlock;var defaultBlock=_BaselineSyntax$NestedBlock.defaultBlock;var params=_BaselineSyntax$NestedBlock.params;var hash=_BaselineSyntax$NestedBlock.hash;function debugCallback(context,get){console.info('Use `context`, and `get(<path>)` to debug this template.'); /* tslint:disable */debugger; /* tslint:enable */return {context:context,get:get};}function getter(vm,builder){return function(path){var parts=path.split('.');if(parts[0] === 'this'){parts[0] = null;}return compileRef(parts,builder).evaluate(vm);};}var callback=debugCallback; // For testing purposes
function setDebuggerCallback(cb){callback = cb;}function resetDebuggerCallback(){callback = debugCallback;}var Compilers=(function(){function Compilers(){this.names = _glimmerUtil.dict();this.funcs = [];}Compilers.prototype.add = function add(name,func){this.funcs.push(func);this.names[name] = this.funcs.length - 1;};Compilers.prototype.compile = function compile(sexp,builder){var name=sexp[0];var index=this.names[name];var func=this.funcs[index];_glimmerUtil.assert(!!func,'expected an implementation for ' + sexp[0]);return func(sexp,builder);};return Compilers;})();var Ops$1=_glimmerWireFormat.Ops;var STATEMENTS=new Compilers();STATEMENTS.add(Ops$1.Text,function(sexp,builder){builder.text(sexp[1]);});STATEMENTS.add(Ops$1.Comment,function(sexp,builder){builder.comment(sexp[1]);});STATEMENTS.add(Ops$1.CloseElement,function(_sexp,builder){_glimmerUtil.LOGGER.trace('close-element statement');builder.closeElement();});STATEMENTS.add(Ops$1.FlushElement,function(_sexp,builder){builder.flushElement();});STATEMENTS.add(Ops$1.Modifier,function(sexp,builder){var path=sexp[1];var params=sexp[2];var hash=sexp[3];var args=compileArgs(params,hash,builder);if(builder.env.hasModifier(path[0],builder.symbolTable)){builder.modifier(path[0],args);}else {throw new Error('Compile Error ' + path.join('.') + ' is not a modifier: Helpers may not be used in the element form.');}});STATEMENTS.add(Ops$1.StaticAttr,function(sexp,builder){var name=sexp[1];var value=sexp[2];var namespace=sexp[3];builder.staticAttr(name,namespace,value);});STATEMENTS.add(Ops$1.AnyDynamicAttr,function(sexp,builder){var name=sexp[1];var value=sexp[2];var namespace=sexp[3];var trusting=sexp[4];builder.putValue(value);if(namespace){builder.dynamicAttrNS(name,namespace,trusting);}else {builder.dynamicAttr(name,trusting);}});STATEMENTS.add(Ops$1.OpenElement,function(sexp,builder){_glimmerUtil.LOGGER.trace('open-element statement');builder.openPrimitiveElement(sexp[1]);});STATEMENTS.add(Ops$1.OptimizedAppend,function(sexp,builder){var value=sexp[1];var trustingMorph=sexp[2];var _builder$env$macros=builder.env.macros();var inlines=_builder$env$macros.inlines;var returned=inlines.compile(sexp,builder) || value;if(returned === true)return;builder.putValue(returned[1]);if(trustingMorph){builder.trustingAppend();}else {builder.cautiousAppend();}});STATEMENTS.add(Ops$1.UnoptimizedAppend,function(sexp,builder){var value=sexp[1];var trustingMorph=sexp[2];var _builder$env$macros2=builder.env.macros();var inlines=_builder$env$macros2.inlines;var returned=inlines.compile(sexp,builder) || value;if(returned === true)return;if(trustingMorph){builder.guardedTrustingAppend(returned[1]);}else {builder.guardedCautiousAppend(returned[1]);}});STATEMENTS.add(Ops$1.NestedBlock,function(sexp,builder){var _builder$env$macros3=builder.env.macros();var blocks=_builder$env$macros3.blocks;blocks.compile(sexp,builder);});STATEMENTS.add(Ops$1.ScannedBlock,function(sexp,builder){var path=sexp[1];var params=sexp[2];var hash=sexp[3];var template=sexp[4];var inverse=sexp[5];var templateBlock=template && template.scan();var inverseBlock=inverse && inverse.scan();var _builder$env$macros4=builder.env.macros();var blocks=_builder$env$macros4.blocks;blocks.compile([Ops$1.NestedBlock,path,params,hash,templateBlock,inverseBlock],builder);}); // this fixes an issue with Ember versions using glimmer-vm@0.22 when attempting
// to use nested web components.  This is obviously not correct for angle bracket components
// but since no consumers are currently using them with glimmer@0.22.x we are hard coding
// support to just use the fallback case.
STATEMENTS.add(Ops$1.Component,function(sexp,builder){var tag=sexp[1];var component=sexp[2];var attrs=component.attrs;var statements=component.statements;builder.openPrimitiveElement(tag);for(var i=0;i < attrs.length;i++) {STATEMENTS.compile(attrs[i],builder);}builder.flushElement();for(var i=0;i < statements.length;i++) {STATEMENTS.compile(statements[i],builder);}builder.closeElement();});STATEMENTS.add(Ops$1.ScannedComponent,function(sexp,builder){var tag=sexp[1];var attrs=sexp[2];var rawArgs=sexp[3];var rawBlock=sexp[4];var block=rawBlock && rawBlock.scan();var args=compileBlockArgs(null,rawArgs,{default:block,inverse:null},builder);var definition=builder.env.getComponentDefinition(tag,builder.symbolTable);builder.putComponentDefinition(definition);builder.openComponent(args,attrs.scan());builder.closeComponent();});STATEMENTS.add(Ops$1.StaticPartial,function(sexp,builder){var name=sexp[1];if(!builder.env.hasPartial(name,builder.symbolTable)){throw new Error('Compile Error: Could not find a partial named "' + name + '"');}var definition=builder.env.lookupPartial(name,builder.symbolTable);builder.putPartialDefinition(definition);builder.evaluatePartial();});STATEMENTS.add(Ops$1.DynamicPartial,function(sexp,builder){var name=sexp[1];builder.startLabels();builder.putValue(name);builder.test('simple');builder.enter('BEGIN','END');builder.label('BEGIN');builder.jumpUnless('END');builder.putDynamicPartialDefinition();builder.evaluatePartial();builder.label('END');builder.exit();builder.stopLabels();});STATEMENTS.add(Ops$1.Yield,function(sexp,builder){var to=sexp[1];var params=sexp[2];var args=compileArgs(params,null,builder);builder.yield(args,to);});STATEMENTS.add(Ops$1.Debugger,function(sexp,builder){builder.putValue([Ops$1.Function,function(vm){var context=vm.getSelf().value();var get=function(path){return getter(vm,builder)(path).value();};callback(context,get);}]);return sexp;});var EXPRESSIONS=new Compilers();function expr(expression,builder){if(Array.isArray(expression)){return EXPRESSIONS.compile(expression,builder);}else {return new CompiledValue(expression);}}EXPRESSIONS.add(Ops$1.Unknown,function(sexp,builder){var path=sexp[1];var name=path[0];if(builder.env.hasHelper(name,builder.symbolTable)){return new CompiledHelper(name,builder.env.lookupHelper(name,builder.symbolTable),CompiledArgs.empty(),builder.symbolTable);}else {return compileRef(path,builder);}});EXPRESSIONS.add(Ops$1.Concat,function(sexp,builder){var params=sexp[1].map(function(p){return expr(p,builder);});return new CompiledConcat(params);});EXPRESSIONS.add(Ops$1.Function,function(sexp,builder){return new CompiledFunctionExpression(sexp[1],builder.symbolTable);});EXPRESSIONS.add(Ops$1.Helper,function(sexp,builder){var env=builder.env;var symbolTable=builder.symbolTable;var _sexp$1=sexp[1];var name=_sexp$1[0];var params=sexp[2];var hash=sexp[3];if(env.hasHelper(name,symbolTable)){var args=compileArgs(params,hash,builder);return new CompiledHelper(name,env.lookupHelper(name,symbolTable),args,symbolTable);}else {throw new Error('Compile Error: ' + name + ' is not a helper');}});EXPRESSIONS.add(Ops$1.Get,function(sexp,builder){return compileRef(sexp[1],builder);});EXPRESSIONS.add(Ops$1.Undefined,function(_sexp,_builder){return new CompiledValue(undefined);});EXPRESSIONS.add(Ops$1.Arg,function(sexp,builder){var parts=sexp[1];var head=parts[0];var named=undefined,partial=undefined;if(named = builder.symbolTable.getSymbol('named',head)){var path=parts.slice(1);var inner=new CompiledSymbol(named,head);return CompiledLookup.create(inner,path);}else if(partial = builder.symbolTable.getPartialArgs()){var path=parts.slice(1);var inner=new CompiledInPartialName(partial,head);return CompiledLookup.create(inner,path);}else {throw new Error('[BUG] @' + parts.join('.') + ' is not a valid lookup path.');}});EXPRESSIONS.add(Ops$1.HasBlock,function(sexp,builder){var blockName=sexp[1];var yields=undefined,partial=undefined;if(yields = builder.symbolTable.getSymbol('yields',blockName)){var inner=new CompiledGetBlockBySymbol(yields,blockName);return new CompiledHasBlock(inner);}else if(partial = builder.symbolTable.getPartialArgs()){var inner=new CompiledInPartialGetBlock(partial,blockName);return new CompiledHasBlock(inner);}else {throw new Error('[BUG] ${blockName} is not a valid block name.');}});EXPRESSIONS.add(Ops$1.HasBlockParams,function(sexp,builder){var blockName=sexp[1];var yields=undefined,partial=undefined;if(yields = builder.symbolTable.getSymbol('yields',blockName)){var inner=new CompiledGetBlockBySymbol(yields,blockName);return new CompiledHasBlockParams(inner);}else if(partial = builder.symbolTable.getPartialArgs()){var inner=new CompiledInPartialGetBlock(partial,blockName);return new CompiledHasBlockParams(inner);}else {throw new Error('[BUG] ${blockName} is not a valid block name.');}});function compileArgs(params,hash,builder){var compiledParams=compileParams(params,builder);var compiledHash=compileHash(hash,builder);return CompiledArgs.create(compiledParams,compiledHash,EMPTY_BLOCKS);}function compileBlockArgs(params,hash,blocks,builder){var compiledParams=compileParams(params,builder);var compiledHash=compileHash(hash,builder);return CompiledArgs.create(compiledParams,compiledHash,blocks);}function compileBaselineArgs(args,builder){var params=args[0];var hash=args[1];var _default=args[2];var inverse=args[3];return CompiledArgs.create(compileParams(params,builder),compileHash(hash,builder),{default:_default,inverse:inverse});}function compileParams(params,builder){if(!params || params.length === 0)return COMPILED_EMPTY_POSITIONAL_ARGS;var compiled=new Array(params.length);for(var i=0;i < params.length;i++) {compiled[i] = expr(params[i],builder);}return CompiledPositionalArgs.create(compiled);}function compileHash(hash,builder){if(!hash)return COMPILED_EMPTY_NAMED_ARGS;var keys=hash[0];var values=hash[1];if(keys.length === 0)return COMPILED_EMPTY_NAMED_ARGS;var compiled=new Array(values.length);for(var i=0;i < values.length;i++) {compiled[i] = expr(values[i],builder);}return new CompiledNamedArgs(keys,compiled);}function compileRef(parts,builder){var head=parts[0];var local=undefined;if(head === null){var inner=new CompiledSelf();var path=parts.slice(1);return CompiledLookup.create(inner,path);}else if(local = builder.symbolTable.getSymbol('local',head)){var path=parts.slice(1);var inner=new CompiledSymbol(local,head);return CompiledLookup.create(inner,path);}else {var inner=new CompiledSelf();return CompiledLookup.create(inner,parts);}}var Blocks=(function(){function Blocks(){this.names = _glimmerUtil.dict();this.funcs = [];}Blocks.prototype.add = function add(name,func){this.funcs.push(func);this.names[name] = this.funcs.length - 1;};Blocks.prototype.addMissing = function addMissing(func){this.missing = func;};Blocks.prototype.compile = function compile(sexp,builder){ // assert(sexp[1].length === 1, 'paths in blocks are not supported');
var name=sexp[1][0];var index=this.names[name];if(index === undefined){_glimmerUtil.assert(!!this.missing,name + ' not found, and no catch-all block handler was registered');var func=this.missing;var handled=func(sexp,builder);_glimmerUtil.assert(!!handled,name + ' not found, and the catch-all block handler didn\'t handle it');}else {var func=this.funcs[index];func(sexp,builder);}};return Blocks;})();var BLOCKS=new Blocks();var Inlines=(function(){function Inlines(){this.names = _glimmerUtil.dict();this.funcs = [];}Inlines.prototype.add = function add(name,func){this.funcs.push(func);this.names[name] = this.funcs.length - 1;};Inlines.prototype.addMissing = function addMissing(func){this.missing = func;};Inlines.prototype.compile = function compile(sexp,builder){var value=sexp[1]; // TODO: Fix this so that expression macros can return
// things like components, so that {{component foo}}
// is the same as {{(component foo)}}
if(!Array.isArray(value))return ['expr',value];var path=undefined;var params=undefined;var hash=undefined;if(value[0] === Ops$1.Helper){path = value[1];params = value[2];hash = value[3];}else if(value[0] === Ops$1.Unknown){path = value[1];params = hash = null;}else {return ['expr',value];}if(path.length > 1 && !params && !hash){return ['expr',value];}var name=path[0];var index=this.names[name];if(index === undefined && this.missing){var func=this.missing;var returned=func(path,params,hash,builder);return returned === false?['expr',value]:returned;}else if(index !== undefined){var func=this.funcs[index];var returned=func(path,params,hash,builder);return returned === false?['expr',value]:returned;}else {return ['expr',value];}};return Inlines;})();var INLINES=new Inlines();populateBuiltins(BLOCKS,INLINES);function populateBuiltins(){var blocks=arguments.length <= 0 || arguments[0] === undefined?new Blocks():arguments[0];var inlines=arguments.length <= 1 || arguments[1] === undefined?new Inlines():arguments[1];blocks.add('if',function(sexp,builder){ //        PutArgs
//        Test(Environment)
//        Enter(BEGIN, END)
// BEGIN: Noop
//        JumpUnless(ELSE)
//        Evaluate(default)
//        Jump(END)
// ELSE:  Noop
//        Evalulate(inverse)
// END:   Noop
//        Exit
var params=sexp[2];var hash=sexp[3];var _default=sexp[4];var inverse=sexp[5];var args=compileArgs(params,hash,builder);builder.putArgs(args);builder.test('environment');builder.labelled(null,function(b){if(_default && inverse){b.jumpUnless('ELSE');b.evaluate(_default);b.jump('END');b.label('ELSE');b.evaluate(inverse);}else if(_default){b.jumpUnless('END');b.evaluate(_default);}else {throw _glimmerUtil.unreachable();}});});blocks.add('-in-element',function(sexp,builder){var block=defaultBlock(sexp);var args=compileArgs(params(sexp),null,builder);builder.putArgs(args);builder.test('simple');builder.labelled(null,function(b){b.jumpUnless('END');b.pushRemoteElement();b.evaluate(_glimmerUtil.unwrap(block));b.popRemoteElement();});});blocks.add('-with-dynamic-vars',function(sexp,builder){var block=defaultBlock(sexp);var args=compileArgs(params(sexp),hash(sexp),builder);builder.unit(function(b){b.putArgs(args);b.pushDynamicScope();b.bindDynamicScope(args.named.keys);b.evaluate(_glimmerUtil.unwrap(block));b.popDynamicScope();});});blocks.add('unless',function(sexp,builder){ //        PutArgs
//        Test(Environment)
//        Enter(BEGIN, END)
// BEGIN: Noop
//        JumpUnless(ELSE)
//        Evaluate(default)
//        Jump(END)
// ELSE:  Noop
//        Evalulate(inverse)
// END:   Noop
//        Exit
var params=sexp[2];var hash=sexp[3];var _default=sexp[4];var inverse=sexp[5];var args=compileArgs(params,hash,builder);builder.putArgs(args);builder.test('environment');builder.labelled(null,function(b){if(_default && inverse){b.jumpIf('ELSE');b.evaluate(_default);b.jump('END');b.label('ELSE');b.evaluate(inverse);}else if(_default){b.jumpIf('END');b.evaluate(_default);}else {throw _glimmerUtil.unreachable();}});});blocks.add('with',function(sexp,builder){ //        PutArgs
//        Test(Environment)
//        Enter(BEGIN, END)
// BEGIN: Noop
//        JumpUnless(ELSE)
//        Evaluate(default)
//        Jump(END)
// ELSE:  Noop
//        Evalulate(inverse)
// END:   Noop
//        Exit
var params=sexp[2];var hash=sexp[3];var _default=sexp[4];var inverse=sexp[5];var args=compileArgs(params,hash,builder);builder.putArgs(args);builder.test('environment');builder.labelled(null,function(b){if(_default && inverse){b.jumpUnless('ELSE');b.evaluate(_default);b.jump('END');b.label('ELSE');b.evaluate(inverse);}else if(_default){b.jumpUnless('END');b.evaluate(_default);}else {throw _glimmerUtil.unreachable();}});});blocks.add('each',function(sexp,builder){ //         Enter(BEGIN, END)
// BEGIN:  Noop
//         PutArgs
//         PutIterable
//         JumpUnless(ELSE)
//         EnterList(BEGIN2, END2)
// ITER:   Noop
//         NextIter(BREAK)
//         EnterWithKey(BEGIN2, END2)
// BEGIN2: Noop
//         PushChildScope
//         Evaluate(default)
//         PopScope
// END2:   Noop
//         Exit
//         Jump(ITER)
// BREAK:  Noop
//         ExitList
//         Jump(END)
// ELSE:   Noop
//         Evalulate(inverse)
// END:    Noop
//         Exit
var params=sexp[2];var hash=sexp[3];var _default=sexp[4];var inverse=sexp[5];var args=compileArgs(params,hash,builder);builder.labelled(args,function(b){b.putIterator();if(inverse){b.jumpUnless('ELSE');}else {b.jumpUnless('END');}b.iter(function(b){b.evaluate(_glimmerUtil.unwrap(_default));});if(inverse){b.jump('END');b.label('ELSE');b.evaluate(inverse);}});});return {blocks:blocks,inlines:inlines};}var badProtocols=['javascript:','vbscript:'];var badTags=['A','BODY','LINK','IMG','IFRAME','BASE','FORM'];var badTagsForDataURI=['EMBED'];var badAttributes=['href','src','background','action'];var badAttributesForDataURI=['src'];function has(array,item){return array.indexOf(item) !== -1;}function checkURI(tagName,attribute){return (tagName === null || has(badTags,tagName)) && has(badAttributes,attribute);}function checkDataURI(tagName,attribute){if(tagName === null)return false;return has(badTagsForDataURI,tagName) && has(badAttributesForDataURI,attribute);}function requiresSanitization(tagName,attribute){return checkURI(tagName,attribute) || checkDataURI(tagName,attribute);}function sanitizeAttributeValue(env,element,attribute,value){var tagName=null;if(value === null || value === undefined){return value;}if(isSafeString(value)){return value.toHTML();}if(!element){tagName = null;}else {tagName = element.tagName.toUpperCase();}var str=normalizeTextValue(value);if(checkURI(tagName,attribute)){var protocol=env.protocolForURL(str);if(has(badProtocols,protocol)){return 'unsafe:' + str;}}if(checkDataURI(tagName,attribute)){return 'unsafe:' + str;}return str;} /*
 * @method normalizeProperty
 * @param element {HTMLElement}
 * @param slotName {String}
 * @returns {Object} { name, type }
 */function normalizeProperty(element,slotName){var type=undefined,normalized=undefined;if(slotName in element){normalized = slotName;type = 'prop';}else {var lower=slotName.toLowerCase();if(lower in element){type = 'prop';normalized = lower;}else {type = 'attr';normalized = slotName;}}if(type === 'prop' && (normalized.toLowerCase() === 'style' || preferAttr(element.tagName,normalized))){type = 'attr';}return {normalized:normalized,type:type};} // properties that MUST be set as attributes, due to:
// * browser bug
// * strange spec outlier
var ATTR_OVERRIDES={ // phantomjs < 2.0 lets you set it as a prop but won't reflect it
// back to the attribute. button.getAttribute('type') === null
BUTTON:{type:true,form:true},INPUT:{ // Some version of IE (like IE9) actually throw an exception
// if you set input.type = 'something-unknown'
type:true,form:true, // Chrome 46.0.2464.0: 'autocorrect' in document.createElement('input') === false
// Safari 8.0.7: 'autocorrect' in document.createElement('input') === false
// Mobile Safari (iOS 8.4 simulator): 'autocorrect' in document.createElement('input') === true
autocorrect:true, // Chrome 54.0.2840.98: 'list' in document.createElement('input') === true
// Safari 9.1.3: 'list' in document.createElement('input') === false
list:true}, // element.form is actually a legitimate readOnly property, that is to be
// mutated, but must be mutated by setAttribute...
SELECT:{form:true},OPTION:{form:true},TEXTAREA:{form:true},LABEL:{form:true},FIELDSET:{form:true},LEGEND:{form:true},OBJECT:{form:true}};function preferAttr(tagName,propName){var tag=ATTR_OVERRIDES[tagName.toUpperCase()];return tag && tag[propName.toLowerCase()] || false;}var innerHTMLWrapper={colgroup:{depth:2,before:'<table><colgroup>',after:'</colgroup></table>'},table:{depth:1,before:'<table>',after:'</table>'},tbody:{depth:2,before:'<table><tbody>',after:'</tbody></table>'},tfoot:{depth:2,before:'<table><tfoot>',after:'</tfoot></table>'},thead:{depth:2,before:'<table><thead>',after:'</thead></table>'},tr:{depth:3,before:'<table><tbody><tr>',after:'</tr></tbody></table>'}}; // Patch:    innerHTML Fix
// Browsers: IE9
// Reason:   IE9 don't allow us to set innerHTML on col, colgroup, frameset,
//           html, style, table, tbody, tfoot, thead, title, tr.
// Fix:      Wrap the innerHTML we are about to set in its parents, apply the
//           wrapped innerHTML on a div, then move the unwrapped nodes into the
//           target position.
function domChanges(document,DOMChangesClass){if(!document)return DOMChangesClass;if(!shouldApplyFix(document)){return DOMChangesClass;}var div=document.createElement('div');return (function(_DOMChangesClass){babelHelpers.inherits(DOMChangesWithInnerHTMLFix,_DOMChangesClass);function DOMChangesWithInnerHTMLFix(){_DOMChangesClass.apply(this,arguments);}DOMChangesWithInnerHTMLFix.prototype.insertHTMLBefore = function insertHTMLBefore(parent,nextSibling,html){if(html === null || html === ''){return _DOMChangesClass.prototype.insertHTMLBefore.call(this,parent,nextSibling,html);}var parentTag=parent.tagName.toLowerCase();var wrapper=innerHTMLWrapper[parentTag];if(wrapper === undefined){return _DOMChangesClass.prototype.insertHTMLBefore.call(this,parent,nextSibling,html);}return fixInnerHTML(parent,wrapper,div,html,nextSibling);};return DOMChangesWithInnerHTMLFix;})(DOMChangesClass);}function treeConstruction(document,DOMTreeConstructionClass){if(!document)return DOMTreeConstructionClass;if(!shouldApplyFix(document)){return DOMTreeConstructionClass;}var div=document.createElement('div');return (function(_DOMTreeConstructionClass){babelHelpers.inherits(DOMTreeConstructionWithInnerHTMLFix,_DOMTreeConstructionClass);function DOMTreeConstructionWithInnerHTMLFix(){_DOMTreeConstructionClass.apply(this,arguments);}DOMTreeConstructionWithInnerHTMLFix.prototype.insertHTMLBefore = function insertHTMLBefore(parent,html,reference){if(html === null || html === ''){return _DOMTreeConstructionClass.prototype.insertHTMLBefore.call(this,parent,html,reference);}var parentTag=parent.tagName.toLowerCase();var wrapper=innerHTMLWrapper[parentTag];if(wrapper === undefined){return _DOMTreeConstructionClass.prototype.insertHTMLBefore.call(this,parent,html,reference);}return fixInnerHTML(parent,wrapper,div,html,reference);};return DOMTreeConstructionWithInnerHTMLFix;})(DOMTreeConstructionClass);}function fixInnerHTML(parent,wrapper,div,html,reference){var wrappedHtml=wrapper.before + html + wrapper.after;div.innerHTML = wrappedHtml;var parentNode=div;for(var i=0;i < wrapper.depth;i++) {parentNode = parentNode.childNodes[0];}var _moveNodesBefore=moveNodesBefore(parentNode,parent,reference);var first=_moveNodesBefore[0];var last=_moveNodesBefore[1];return new ConcreteBounds(parent,first,last);}function shouldApplyFix(document){var table=document.createElement('table');try{table.innerHTML = '<tbody></tbody>';}catch(e) {}finally {if(table.childNodes.length !== 0){ // It worked as expected, no fix required
return false;}}return true;}var SVG_NAMESPACE$1='http://www.w3.org/2000/svg'; // Patch:    insertAdjacentHTML on SVG Fix
// Browsers: Safari, IE, Edge, Firefox ~33-34
// Reason:   insertAdjacentHTML does not exist on SVG elements in Safari. It is
//           present but throws an exception on IE and Edge. Old versions of
//           Firefox create nodes in the incorrect namespace.
// Fix:      Since IE and Edge silently fail to create SVG nodes using
//           innerHTML, and because Firefox may create nodes in the incorrect
//           namespace using innerHTML on SVG elements, an HTML-string wrapping
//           approach is used. A pre/post SVG tag is added to the string, then
//           that whole string is added to a div. The created nodes are plucked
//           out and applied to the target location on DOM.
function domChanges$1(document,DOMChangesClass,svgNamespace){if(!document)return DOMChangesClass;if(!shouldApplyFix$1(document,svgNamespace)){return DOMChangesClass;}var div=document.createElement('div');return (function(_DOMChangesClass2){babelHelpers.inherits(DOMChangesWithSVGInnerHTMLFix,_DOMChangesClass2);function DOMChangesWithSVGInnerHTMLFix(){_DOMChangesClass2.apply(this,arguments);}DOMChangesWithSVGInnerHTMLFix.prototype.insertHTMLBefore = function insertHTMLBefore(parent,nextSibling,html){if(html === null || html === ''){return _DOMChangesClass2.prototype.insertHTMLBefore.call(this,parent,nextSibling,html);}if(parent.namespaceURI !== svgNamespace){return _DOMChangesClass2.prototype.insertHTMLBefore.call(this,parent,nextSibling,html);}return fixSVG(parent,div,html,nextSibling);};return DOMChangesWithSVGInnerHTMLFix;})(DOMChangesClass);}function treeConstruction$1(document,TreeConstructionClass,svgNamespace){if(!document)return TreeConstructionClass;if(!shouldApplyFix$1(document,svgNamespace)){return TreeConstructionClass;}var div=document.createElement('div');return (function(_TreeConstructionClass){babelHelpers.inherits(TreeConstructionWithSVGInnerHTMLFix,_TreeConstructionClass);function TreeConstructionWithSVGInnerHTMLFix(){_TreeConstructionClass.apply(this,arguments);}TreeConstructionWithSVGInnerHTMLFix.prototype.insertHTMLBefore = function insertHTMLBefore(parent,html,reference){if(html === null || html === ''){return _TreeConstructionClass.prototype.insertHTMLBefore.call(this,parent,html,reference);}if(parent.namespaceURI !== svgNamespace){return _TreeConstructionClass.prototype.insertHTMLBefore.call(this,parent,html,reference);}return fixSVG(parent,div,html,reference);};return TreeConstructionWithSVGInnerHTMLFix;})(TreeConstructionClass);}function fixSVG(parent,div,html,reference){ // IE, Edge: also do not correctly support using `innerHTML` on SVG
// namespaced elements. So here a wrapper is used.
var wrappedHtml='<svg>' + html + '</svg>';div.innerHTML = wrappedHtml;var _moveNodesBefore2=moveNodesBefore(div.firstChild,parent,reference);var first=_moveNodesBefore2[0];var last=_moveNodesBefore2[1];return new ConcreteBounds(parent,first,last);}function shouldApplyFix$1(document,svgNamespace){var svg=document.createElementNS(svgNamespace,'svg');try{svg['insertAdjacentHTML']('beforeEnd','<circle></circle>');}catch(e) { // IE, Edge: Will throw, insertAdjacentHTML is unsupported on SVG
// Safari: Will throw, insertAdjacentHTML is not present on SVG
}finally { // FF: Old versions will create a node in the wrong namespace
if(svg.childNodes.length === 1 && _glimmerUtil.unwrap(svg.firstChild).namespaceURI === SVG_NAMESPACE$1){ // The test worked as expected, no fix required
return false;}return true;}} // Patch:    Adjacent text node merging fix
// Browsers: IE, Edge, Firefox w/o inspector open
// Reason:   These browsers will merge adjacent text nodes. For exmaple given
//           <div>Hello</div> with div.insertAdjacentHTML(' world') browsers
//           with proper behavior will populate div.childNodes with two items.
//           These browsers will populate it with one merged node instead.
// Fix:      Add these nodes to a wrapper element, then iterate the childNodes
//           of that wrapper and move the nodes to their target location. Note
//           that potential SVG bugs will have been handled before this fix.
//           Note that this fix must only apply to the previous text node, as
//           the base implementation of `insertHTMLBefore` already handles
//           following text nodes correctly.
function domChanges$2(document,DOMChangesClass){if(!document)return DOMChangesClass;if(!shouldApplyFix$2(document)){return DOMChangesClass;}return (function(_DOMChangesClass3){babelHelpers.inherits(DOMChangesWithTextNodeMergingFix,_DOMChangesClass3);function DOMChangesWithTextNodeMergingFix(document){_DOMChangesClass3.call(this,document);this.uselessComment = document.createComment('');}DOMChangesWithTextNodeMergingFix.prototype.insertHTMLBefore = function insertHTMLBefore(parent,nextSibling,html){if(html === null){return _DOMChangesClass3.prototype.insertHTMLBefore.call(this,parent,nextSibling,html);}var didSetUselessComment=false;var nextPrevious=nextSibling?nextSibling.previousSibling:parent.lastChild;if(nextPrevious && nextPrevious instanceof Text){didSetUselessComment = true;parent.insertBefore(this.uselessComment,nextSibling);}var bounds=_DOMChangesClass3.prototype.insertHTMLBefore.call(this,parent,nextSibling,html);if(didSetUselessComment){parent.removeChild(this.uselessComment);}return bounds;};return DOMChangesWithTextNodeMergingFix;})(DOMChangesClass);}function treeConstruction$2(document,TreeConstructionClass){if(!document)return TreeConstructionClass;if(!shouldApplyFix$2(document)){return TreeConstructionClass;}return (function(_TreeConstructionClass2){babelHelpers.inherits(TreeConstructionWithTextNodeMergingFix,_TreeConstructionClass2);function TreeConstructionWithTextNodeMergingFix(document){_TreeConstructionClass2.call(this,document);this.uselessComment = this.createComment('');}TreeConstructionWithTextNodeMergingFix.prototype.insertHTMLBefore = function insertHTMLBefore(parent,html,reference){if(html === null){return _TreeConstructionClass2.prototype.insertHTMLBefore.call(this,parent,html,reference);}var didSetUselessComment=false;var nextPrevious=reference?reference.previousSibling:parent.lastChild;if(nextPrevious && nextPrevious instanceof Text){didSetUselessComment = true;parent.insertBefore(this.uselessComment,reference);}var bounds=_TreeConstructionClass2.prototype.insertHTMLBefore.call(this,parent,html,reference);if(didSetUselessComment){parent.removeChild(this.uselessComment);}return bounds;};return TreeConstructionWithTextNodeMergingFix;})(TreeConstructionClass);}function shouldApplyFix$2(document){var mergingTextDiv=document.createElement('div');mergingTextDiv.innerHTML = 'first';mergingTextDiv.insertAdjacentHTML('beforeEnd','second');if(mergingTextDiv.childNodes.length === 2){ // It worked as expected, no fix required
return false;}return true;}var SVG_NAMESPACE='http://www.w3.org/2000/svg'; // http://www.w3.org/TR/html/syntax.html#html-integration-point
var SVG_INTEGRATION_POINTS={foreignObject:1,desc:1,title:1}; // http://www.w3.org/TR/html/syntax.html#adjust-svg-attributes
// TODO: Adjust SVG attributes
// http://www.w3.org/TR/html/syntax.html#parsing-main-inforeign
// TODO: Adjust SVG elements
// http://www.w3.org/TR/html/syntax.html#parsing-main-inforeign
var BLACKLIST_TABLE=Object.create(null);["b","big","blockquote","body","br","center","code","dd","div","dl","dt","em","embed","h1","h2","h3","h4","h5","h6","head","hr","i","img","li","listing","main","meta","nobr","ol","p","pre","ruby","s","small","span","strong","strike","sub","sup","table","tt","u","ul","var"].forEach(function(tag){return BLACKLIST_TABLE[tag] = 1;});var WHITESPACE=/[\t-\r \xA0\u1680\u180E\u2000-\u200A\u2028\u2029\u202F\u205F\u3000\uFEFF]/;var doc=typeof document === 'undefined'?null:document;function isWhitespace(string){return WHITESPACE.test(string);}function moveNodesBefore(source,target,nextSibling){var first=source.firstChild;var last=null;var current=first;while(current) {last = current;current = current.nextSibling;target.insertBefore(last,nextSibling);}return [first,last];}var DOM;(function(DOM){var TreeConstruction=(function(){function TreeConstruction(document){this.document = document;this.setupUselessElement();}TreeConstruction.prototype.setupUselessElement = function setupUselessElement(){this.uselessElement = this.document.createElement('div');};TreeConstruction.prototype.createElement = function createElement(tag,context){var isElementInSVGNamespace=undefined,isHTMLIntegrationPoint=undefined;if(context){isElementInSVGNamespace = context.namespaceURI === SVG_NAMESPACE || tag === 'svg';isHTMLIntegrationPoint = SVG_INTEGRATION_POINTS[context.tagName];}else {isElementInSVGNamespace = tag === 'svg';isHTMLIntegrationPoint = false;}if(isElementInSVGNamespace && !isHTMLIntegrationPoint){ // FIXME: This does not properly handle <font> with color, face, or
// size attributes, which is also disallowed by the spec. We should fix
// this.
if(BLACKLIST_TABLE[tag]){throw new Error('Cannot create a ' + tag + ' inside an SVG context');}return this.document.createElementNS(SVG_NAMESPACE,tag);}else {return this.document.createElement(tag);}};TreeConstruction.prototype.createElementNS = function createElementNS(namespace,tag){return this.document.createElementNS(namespace,tag);};TreeConstruction.prototype.setAttribute = function setAttribute(element,name,value,namespace){if(namespace){element.setAttributeNS(namespace,name,value);}else {element.setAttribute(name,value);}};TreeConstruction.prototype.createTextNode = function createTextNode(text){return this.document.createTextNode(text);};TreeConstruction.prototype.createComment = function createComment(data){return this.document.createComment(data);};TreeConstruction.prototype.insertBefore = function insertBefore(parent,node,reference){parent.insertBefore(node,reference);};TreeConstruction.prototype.insertHTMLBefore = function insertHTMLBefore(parent,html,reference){return _insertHTMLBefore(this.uselessElement,parent,reference,html);};return TreeConstruction;})();DOM.TreeConstruction = TreeConstruction;var appliedTreeContruction=TreeConstruction;appliedTreeContruction = treeConstruction$2(doc,appliedTreeContruction);appliedTreeContruction = treeConstruction(doc,appliedTreeContruction);appliedTreeContruction = treeConstruction$1(doc,appliedTreeContruction,SVG_NAMESPACE);DOM.DOMTreeConstruction = appliedTreeContruction;})(DOM || (DOM = {}));var DOMChanges=(function(){function DOMChanges(document){this.document = document;this.namespace = null;this.uselessElement = this.document.createElement('div');}DOMChanges.prototype.setAttribute = function setAttribute(element,name,value){element.setAttribute(name,value);};DOMChanges.prototype.setAttributeNS = function setAttributeNS(element,namespace,name,value){element.setAttributeNS(namespace,name,value);};DOMChanges.prototype.removeAttribute = function removeAttribute(element,name){element.removeAttribute(name);};DOMChanges.prototype.removeAttributeNS = function removeAttributeNS(element,namespace,name){element.removeAttributeNS(namespace,name);};DOMChanges.prototype.createTextNode = function createTextNode(text){return this.document.createTextNode(text);};DOMChanges.prototype.createComment = function createComment(data){return this.document.createComment(data);};DOMChanges.prototype.createElement = function createElement(tag,context){var isElementInSVGNamespace=undefined,isHTMLIntegrationPoint=undefined;if(context){isElementInSVGNamespace = context.namespaceURI === SVG_NAMESPACE || tag === 'svg';isHTMLIntegrationPoint = SVG_INTEGRATION_POINTS[context.tagName];}else {isElementInSVGNamespace = tag === 'svg';isHTMLIntegrationPoint = false;}if(isElementInSVGNamespace && !isHTMLIntegrationPoint){ // FIXME: This does not properly handle <font> with color, face, or
// size attributes, which is also disallowed by the spec. We should fix
// this.
if(BLACKLIST_TABLE[tag]){throw new Error('Cannot create a ' + tag + ' inside an SVG context');}return this.document.createElementNS(SVG_NAMESPACE,tag);}else {return this.document.createElement(tag);}};DOMChanges.prototype.insertHTMLBefore = function insertHTMLBefore(_parent,nextSibling,html){return _insertHTMLBefore(this.uselessElement,_parent,nextSibling,html);};DOMChanges.prototype.insertNodeBefore = function insertNodeBefore(parent,node,reference){if(isDocumentFragment(node)){var firstChild=node.firstChild;var lastChild=node.lastChild;this.insertBefore(parent,node,reference);return new ConcreteBounds(parent,firstChild,lastChild);}else {this.insertBefore(parent,node,reference);return new SingleNodeBounds(parent,node);}};DOMChanges.prototype.insertTextBefore = function insertTextBefore(parent,nextSibling,text){var textNode=this.createTextNode(text);this.insertBefore(parent,textNode,nextSibling);return textNode;};DOMChanges.prototype.insertBefore = function insertBefore(element,node,reference){element.insertBefore(node,reference);};DOMChanges.prototype.insertAfter = function insertAfter(element,node,reference){this.insertBefore(element,node,reference.nextSibling);};return DOMChanges;})();function _insertHTMLBefore(_useless,_parent,_nextSibling,html){ // TypeScript vendored an old version of the DOM spec where `insertAdjacentHTML`
// only exists on `HTMLElement` but not on `Element`. We actually work with the
// newer version of the DOM API here (and monkey-patch this method in `./compat`
// when we detect older browsers). This is a hack to work around this limitation.
var parent=_parent;var useless=_useless;var nextSibling=_nextSibling;var prev=nextSibling?nextSibling.previousSibling:parent.lastChild;var last=undefined;if(html === null || html === ''){return new ConcreteBounds(parent,null,null);}if(nextSibling === null){parent.insertAdjacentHTML('beforeEnd',html);last = parent.lastChild;}else if(nextSibling instanceof HTMLElement){nextSibling.insertAdjacentHTML('beforeBegin',html);last = nextSibling.previousSibling;}else { // Non-element nodes do not support insertAdjacentHTML, so add an
// element and call it on that element. Then remove the element.
//
// This also protects Edge, IE and Firefox w/o the inspector open
// from merging adjacent text nodes. See ./compat/text-node-merging-fix.ts
parent.insertBefore(useless,nextSibling);useless.insertAdjacentHTML('beforeBegin',html);last = useless.previousSibling;parent.removeChild(useless);}var first=prev?prev.nextSibling:parent.firstChild;return new ConcreteBounds(parent,first,last);}function isDocumentFragment(node){return node.nodeType === Node.DOCUMENT_FRAGMENT_NODE;}var helper=DOMChanges;helper = domChanges$2(doc,helper);helper = domChanges(doc,helper);helper = domChanges$1(doc,helper,SVG_NAMESPACE);var helper$1=helper;var DOMTreeConstruction=DOM.DOMTreeConstruction;function defaultManagers(element,attr,_isTrusting,_namespace){var tagName=element.tagName;var isSVG=element.namespaceURI === SVG_NAMESPACE;if(isSVG){return defaultAttributeManagers(tagName,attr);}var _normalizeProperty=normalizeProperty(element,attr);var type=_normalizeProperty.type;var normalized=_normalizeProperty.normalized;if(type === 'attr'){return defaultAttributeManagers(tagName,normalized);}else {return defaultPropertyManagers(tagName,normalized);}}function defaultPropertyManagers(tagName,attr){if(requiresSanitization(tagName,attr)){return new SafePropertyManager(attr);}if(isUserInputValue(tagName,attr)){return INPUT_VALUE_PROPERTY_MANAGER;}if(isOptionSelected(tagName,attr)){return OPTION_SELECTED_MANAGER;}return new PropertyManager(attr);}function defaultAttributeManagers(tagName,attr){if(requiresSanitization(tagName,attr)){return new SafeAttributeManager(attr);}return new AttributeManager(attr);}function readDOMAttr(element,attr){var isSVG=element.namespaceURI === SVG_NAMESPACE;var _normalizeProperty2=normalizeProperty(element,attr);var type=_normalizeProperty2.type;var normalized=_normalizeProperty2.normalized;if(isSVG){return element.getAttribute(normalized);}if(type === 'attr'){return element.getAttribute(normalized);}{return element[normalized];}};var AttributeManager=(function(){function AttributeManager(attr){this.attr = attr;}AttributeManager.prototype.setAttribute = function setAttribute(env,element,value,namespace){var dom=env.getAppendOperations();var normalizedValue=normalizeAttributeValue(value);if(!isAttrRemovalValue(normalizedValue)){dom.setAttribute(element,this.attr,normalizedValue,namespace);}};AttributeManager.prototype.updateAttribute = function updateAttribute(env,element,value,namespace){if(value === null || value === undefined || value === false){if(namespace){env.getDOM().removeAttributeNS(element,namespace,this.attr);}else {env.getDOM().removeAttribute(element,this.attr);}}else {this.setAttribute(env,element,value);}};return AttributeManager;})();;var PropertyManager=(function(_AttributeManager){babelHelpers.inherits(PropertyManager,_AttributeManager);function PropertyManager(){_AttributeManager.apply(this,arguments);}PropertyManager.prototype.setAttribute = function setAttribute(_env,element,value,_namespace){if(!isAttrRemovalValue(value)){element[this.attr] = value;}};PropertyManager.prototype.removeAttribute = function removeAttribute(env,element,namespace){ // TODO this sucks but to preserve properties first and to meet current
// semantics we must do this.
var attr=this.attr;if(namespace){env.getDOM().removeAttributeNS(element,namespace,attr);}else {env.getDOM().removeAttribute(element,attr);}};PropertyManager.prototype.updateAttribute = function updateAttribute(env,element,value,namespace){ // ensure the property is always updated
element[this.attr] = value;if(isAttrRemovalValue(value)){this.removeAttribute(env,element,namespace);}};return PropertyManager;})(AttributeManager);;function normalizeAttributeValue(value){if(value === false || value === undefined || value === null){return null;}if(value === true){return '';} // onclick function etc in SSR
if(typeof value === 'function'){return null;}return String(value);}function isAttrRemovalValue(value){return value === null || value === undefined;}var SafePropertyManager=(function(_PropertyManager){babelHelpers.inherits(SafePropertyManager,_PropertyManager);function SafePropertyManager(){_PropertyManager.apply(this,arguments);}SafePropertyManager.prototype.setAttribute = function setAttribute(env,element,value){_PropertyManager.prototype.setAttribute.call(this,env,element,sanitizeAttributeValue(env,element,this.attr,value));};SafePropertyManager.prototype.updateAttribute = function updateAttribute(env,element,value){_PropertyManager.prototype.updateAttribute.call(this,env,element,sanitizeAttributeValue(env,element,this.attr,value));};return SafePropertyManager;})(PropertyManager);function isUserInputValue(tagName,attribute){return (tagName === 'INPUT' || tagName === 'TEXTAREA') && attribute === 'value';}var InputValuePropertyManager=(function(_AttributeManager2){babelHelpers.inherits(InputValuePropertyManager,_AttributeManager2);function InputValuePropertyManager(){_AttributeManager2.apply(this,arguments);}InputValuePropertyManager.prototype.setAttribute = function setAttribute(_env,element,value){var input=element;input.value = normalizeTextValue(value);};InputValuePropertyManager.prototype.updateAttribute = function updateAttribute(_env,element,value){var input=element;var currentValue=input.value;var normalizedValue=normalizeTextValue(value);if(currentValue !== normalizedValue){input.value = normalizedValue;}};return InputValuePropertyManager;})(AttributeManager);var INPUT_VALUE_PROPERTY_MANAGER=new InputValuePropertyManager('value');function isOptionSelected(tagName,attribute){return tagName === 'OPTION' && attribute === 'selected';}var OptionSelectedManager=(function(_PropertyManager2){babelHelpers.inherits(OptionSelectedManager,_PropertyManager2);function OptionSelectedManager(){_PropertyManager2.apply(this,arguments);}OptionSelectedManager.prototype.setAttribute = function setAttribute(_env,element,value){if(value !== null && value !== undefined && value !== false){var option=element;option.selected = true;}};OptionSelectedManager.prototype.updateAttribute = function updateAttribute(_env,element,value){var option=element;if(value){option.selected = true;}else {option.selected = false;}};return OptionSelectedManager;})(PropertyManager);var OPTION_SELECTED_MANAGER=new OptionSelectedManager('selected');var SafeAttributeManager=(function(_AttributeManager3){babelHelpers.inherits(SafeAttributeManager,_AttributeManager3);function SafeAttributeManager(){_AttributeManager3.apply(this,arguments);}SafeAttributeManager.prototype.setAttribute = function setAttribute(env,element,value){_AttributeManager3.prototype.setAttribute.call(this,env,element,sanitizeAttributeValue(env,element,this.attr,value));};SafeAttributeManager.prototype.updateAttribute = function updateAttribute(env,element,value,_namespace){_AttributeManager3.prototype.updateAttribute.call(this,env,element,sanitizeAttributeValue(env,element,this.attr,value));};return SafeAttributeManager;})(AttributeManager);var Scope=(function(){function Scope(references){var callerScope=arguments.length <= 1 || arguments[1] === undefined?null:arguments[1];this.callerScope = null;this.slots = references;this.callerScope = callerScope;}Scope.root = function root(self){var size=arguments.length <= 1 || arguments[1] === undefined?0:arguments[1];var refs=new Array(size + 1);for(var i=0;i <= size;i++) {refs[i] = UNDEFINED_REFERENCE;}return new Scope(refs).init({self:self});};Scope.prototype.init = function init(_ref27){var self=_ref27.self;this.slots[0] = self;return this;};Scope.prototype.getSelf = function getSelf(){return this.slots[0];};Scope.prototype.getSymbol = function getSymbol(symbol){return this.slots[symbol];};Scope.prototype.getBlock = function getBlock(symbol){return this.slots[symbol];};Scope.prototype.getPartialArgs = function getPartialArgs(symbol){return this.slots[symbol];};Scope.prototype.bindSymbol = function bindSymbol(symbol,value){this.slots[symbol] = value;};Scope.prototype.bindBlock = function bindBlock(symbol,value){this.slots[symbol] = value;};Scope.prototype.bindPartialArgs = function bindPartialArgs(symbol,value){this.slots[symbol] = value;};Scope.prototype.bindCallerScope = function bindCallerScope(scope){this.callerScope = scope;};Scope.prototype.getCallerScope = function getCallerScope(){return this.callerScope;};Scope.prototype.child = function child(){return new Scope(this.slots.slice(),this.callerScope);};return Scope;})();var Transaction=(function(){function Transaction(){this.scheduledInstallManagers = [];this.scheduledInstallModifiers = [];this.scheduledUpdateModifierManagers = [];this.scheduledUpdateModifiers = [];this.createdComponents = [];this.createdManagers = [];this.updatedComponents = [];this.updatedManagers = [];this.destructors = [];}Transaction.prototype.didCreate = function didCreate(component,manager){this.createdComponents.push(component);this.createdManagers.push(manager);};Transaction.prototype.didUpdate = function didUpdate(component,manager){this.updatedComponents.push(component);this.updatedManagers.push(manager);};Transaction.prototype.scheduleInstallModifier = function scheduleInstallModifier(modifier,manager){this.scheduledInstallManagers.push(manager);this.scheduledInstallModifiers.push(modifier);};Transaction.prototype.scheduleUpdateModifier = function scheduleUpdateModifier(modifier,manager){this.scheduledUpdateModifierManagers.push(manager);this.scheduledUpdateModifiers.push(modifier);};Transaction.prototype.didDestroy = function didDestroy(d){this.destructors.push(d);};Transaction.prototype.commit = function commit(){var createdComponents=this.createdComponents;var createdManagers=this.createdManagers;for(var i=0;i < createdComponents.length;i++) {var component=createdComponents[i];var manager=createdManagers[i];manager.didCreate(component);}var updatedComponents=this.updatedComponents;var updatedManagers=this.updatedManagers;for(var i=0;i < updatedComponents.length;i++) {var component=updatedComponents[i];var manager=updatedManagers[i];manager.didUpdate(component);}var destructors=this.destructors;for(var i=0;i < destructors.length;i++) {destructors[i].destroy();}var scheduledInstallManagers=this.scheduledInstallManagers;var scheduledInstallModifiers=this.scheduledInstallModifiers;for(var i=0;i < scheduledInstallManagers.length;i++) {var manager=scheduledInstallManagers[i];var modifier=scheduledInstallModifiers[i];manager.install(modifier);}var scheduledUpdateModifierManagers=this.scheduledUpdateModifierManagers;var scheduledUpdateModifiers=this.scheduledUpdateModifiers;for(var i=0;i < scheduledUpdateModifierManagers.length;i++) {var manager=scheduledUpdateModifierManagers[i];var modifier=scheduledUpdateModifiers[i];manager.update(modifier);}};return Transaction;})();var Opcode=(function(){function Opcode(array){this.array = array;this.offset = 0;}babelHelpers.createClass(Opcode,[{key:'type',get:function(){return this.array[this.offset];}},{key:'op1',get:function(){return this.array[this.offset + 1];}},{key:'op2',get:function(){return this.array[this.offset + 2];}},{key:'op3',get:function(){return this.array[this.offset + 3];}}]);return Opcode;})();var Program=(function(){function Program(){this.opcodes = [];this._offset = 0;this._opcode = new Opcode(this.opcodes);}Program.prototype.opcode = function opcode(offset){this._opcode.offset = offset;return this._opcode;};Program.prototype.set = function set(pos,type){var op1=arguments.length <= 2 || arguments[2] === undefined?0:arguments[2];var op2=arguments.length <= 3 || arguments[3] === undefined?0:arguments[3];var op3=arguments.length <= 4 || arguments[4] === undefined?0:arguments[4];this.opcodes[pos] = type;this.opcodes[pos + 1] = op1;this.opcodes[pos + 2] = op2;this.opcodes[pos + 3] = op3;};Program.prototype.push = function push(type){var op1=arguments.length <= 1 || arguments[1] === undefined?0:arguments[1];var op2=arguments.length <= 2 || arguments[2] === undefined?0:arguments[2];var op3=arguments.length <= 3 || arguments[3] === undefined?0:arguments[3];var offset=this._offset;this.opcodes[this._offset++] = type;this.opcodes[this._offset++] = op1;this.opcodes[this._offset++] = op2;this.opcodes[this._offset++] = op3;return offset;};babelHelpers.createClass(Program,[{key:'next',get:function(){return this._offset;}},{key:'current',get:function(){return this._offset - 4;}}]);return Program;})();var Environment=(function(){function Environment(_ref28){var appendOperations=_ref28.appendOperations;var updateOperations=_ref28.updateOperations;this._macros = null;this._transaction = null;this.constants = new Constants();this.program = new Program();this.appendOperations = appendOperations;this.updateOperations = updateOperations;}Environment.prototype.toConditionalReference = function toConditionalReference(reference){return new ConditionalReference(reference);};Environment.prototype.getAppendOperations = function getAppendOperations(){return this.appendOperations;};Environment.prototype.getDOM = function getDOM(){return this.updateOperations;};Environment.prototype.getIdentity = function getIdentity(object){return _glimmerUtil.ensureGuid(object) + '';};Environment.prototype.begin = function begin(){_glimmerUtil.assert(!this._transaction,'Cannot start a nested transaction');this._transaction = new Transaction();};Environment.prototype.didCreate = function didCreate(component,manager){this.transaction.didCreate(component,manager);};Environment.prototype.didUpdate = function didUpdate(component,manager){this.transaction.didUpdate(component,manager);};Environment.prototype.scheduleInstallModifier = function scheduleInstallModifier(modifier,manager){this.transaction.scheduleInstallModifier(modifier,manager);};Environment.prototype.scheduleUpdateModifier = function scheduleUpdateModifier(modifier,manager){this.transaction.scheduleUpdateModifier(modifier,manager);};Environment.prototype.didDestroy = function didDestroy(d){this.transaction.didDestroy(d);};Environment.prototype.commit = function commit(){this.transaction.commit();this._transaction = null;};Environment.prototype.attributeFor = function attributeFor(element,attr,isTrusting,namespace){return defaultManagers(element,attr,isTrusting,namespace === undefined?null:namespace);};Environment.prototype.macros = function macros(){var macros=this._macros;if(!macros){this._macros = macros = populateBuiltins();}return macros;};babelHelpers.createClass(Environment,[{key:'transaction',get:function(){return _glimmerUtil.expect(this._transaction,'must be in a transaction');}}]);return Environment;})();var RenderResult=(function(){function RenderResult(env,updating,bounds){this.env = env;this.updating = updating;this.bounds = bounds;}RenderResult.prototype.rerender = function rerender(){var _ref29=arguments.length <= 0 || arguments[0] === undefined?{alwaysRevalidate:false}:arguments[0];var _ref29$alwaysRevalidate=_ref29.alwaysRevalidate;var alwaysRevalidate=_ref29$alwaysRevalidate === undefined?false:_ref29$alwaysRevalidate;var env=this.env;var updating=this.updating;var vm=new UpdatingVM(env,{alwaysRevalidate:alwaysRevalidate});vm.execute(updating,this);};RenderResult.prototype.parentElement = function parentElement(){return this.bounds.parentElement();};RenderResult.prototype.firstNode = function firstNode(){return this.bounds.firstNode();};RenderResult.prototype.lastNode = function lastNode(){return this.bounds.lastNode();};RenderResult.prototype.opcodes = function opcodes(){return this.updating;};RenderResult.prototype.handleException = function handleException(){throw "this should never happen";};RenderResult.prototype.destroy = function destroy(){this.bounds.destroy();clear(this.bounds);};return RenderResult;})();var CapturedFrame=function CapturedFrame(operand,args,condition){this.operand = operand;this.args = args;this.condition = condition;};var Frame=(function(){function Frame(start,end){var component=arguments.length <= 2 || arguments[2] === undefined?null:arguments[2];var manager=arguments.length <= 3 || arguments[3] === undefined?null:arguments[3];var shadow=arguments.length <= 4 || arguments[4] === undefined?null:arguments[4];this.start = start;this.end = end;this.component = component;this.manager = manager;this.shadow = shadow;this.operand = null;this.immediate = null;this.args = null;this.callerScope = null;this.blocks = null;this.condition = null;this.iterator = null;this.key = null;this.ip = start;}Frame.prototype.capture = function capture(){return new CapturedFrame(this.operand,this.args,this.condition);};Frame.prototype.restore = function restore(frame){this.operand = frame.operand;this.args = frame.args;this.condition = frame.condition;};return Frame;})();var FrameStack=(function(){function FrameStack(){this.frames = [];this.frame = -1;}FrameStack.prototype.push = function push(start,end){var component=arguments.length <= 2 || arguments[2] === undefined?null:arguments[2];var manager=arguments.length <= 3 || arguments[3] === undefined?null:arguments[3];var shadow=arguments.length <= 4 || arguments[4] === undefined?null:arguments[4];var pos=++this.frame;if(pos < this.frames.length){var frame=this.frames[pos];frame.start = frame.ip = start;frame.end = end;frame.component = component;frame.manager = manager;frame.shadow = shadow;frame.operand = null;frame.immediate = null;frame.args = null;frame.callerScope = null;frame.blocks = null;frame.condition = null;frame.iterator = null;frame.key = null;}else {this.frames[pos] = new Frame(start,end,component,manager,shadow);}};FrameStack.prototype.pop = function pop(){this.frame--;};FrameStack.prototype.capture = function capture(){return this.currentFrame.capture();};FrameStack.prototype.restore = function restore(frame){this.currentFrame.restore(frame);};FrameStack.prototype.getStart = function getStart(){return this.currentFrame.start;};FrameStack.prototype.getEnd = function getEnd(){return this.currentFrame.end;};FrameStack.prototype.getCurrent = function getCurrent(){return this.currentFrame.ip;};FrameStack.prototype.setCurrent = function setCurrent(ip){return this.currentFrame.ip = ip;};FrameStack.prototype.getOperand = function getOperand(){return _glimmerUtil.unwrap(this.currentFrame.operand);};FrameStack.prototype.setOperand = function setOperand(operand){return this.currentFrame.operand = operand;};FrameStack.prototype.getImmediate = function getImmediate(){return this.currentFrame.immediate;};FrameStack.prototype.setImmediate = function setImmediate(value){return this.currentFrame.immediate = value;}; // FIXME: These options are required in practice by the existing code, but
// figure out why.
FrameStack.prototype.getArgs = function getArgs(){return this.currentFrame.args;};FrameStack.prototype.setArgs = function setArgs(args){return this.currentFrame.args = args;};FrameStack.prototype.getCondition = function getCondition(){return _glimmerUtil.unwrap(this.currentFrame.condition);};FrameStack.prototype.setCondition = function setCondition(condition){return this.currentFrame.condition = condition;};FrameStack.prototype.getIterator = function getIterator(){return _glimmerUtil.unwrap(this.currentFrame.iterator);};FrameStack.prototype.setIterator = function setIterator(iterator){return this.currentFrame.iterator = iterator;};FrameStack.prototype.getKey = function getKey(){return this.currentFrame.key;};FrameStack.prototype.setKey = function setKey(key){return this.currentFrame.key = key;};FrameStack.prototype.getBlocks = function getBlocks(){return _glimmerUtil.unwrap(this.currentFrame.blocks);};FrameStack.prototype.setBlocks = function setBlocks(blocks){return this.currentFrame.blocks = blocks;};FrameStack.prototype.getCallerScope = function getCallerScope(){return _glimmerUtil.unwrap(this.currentFrame.callerScope);};FrameStack.prototype.setCallerScope = function setCallerScope(callerScope){return this.currentFrame.callerScope = callerScope;};FrameStack.prototype.getComponent = function getComponent(){return _glimmerUtil.unwrap(this.currentFrame.component);};FrameStack.prototype.getManager = function getManager(){return _glimmerUtil.unwrap(this.currentFrame.manager);};FrameStack.prototype.getShadow = function getShadow(){return this.currentFrame.shadow;};FrameStack.prototype.goto = function goto(ip){this.setCurrent(ip);};FrameStack.prototype.nextStatement = function nextStatement(env){while(this.frame !== -1) {var frame=this.frames[this.frame];var ip=frame.ip;var end=frame.end;if(ip < end){var program=env.program;frame.ip += 4;return program.opcode(ip);}else {this.pop();}}return null;};babelHelpers.createClass(FrameStack,[{key:'currentFrame',get:function(){return this.frames[this.frame];}}]);return FrameStack;})();var VM=(function(){function VM(env,scope,dynamicScope,elementStack){this.env = env;this.elementStack = elementStack;this.dynamicScopeStack = new _glimmerUtil.Stack();this.scopeStack = new _glimmerUtil.Stack();this.updatingOpcodeStack = new _glimmerUtil.Stack();this.cacheGroups = new _glimmerUtil.Stack();this.listBlockStack = new _glimmerUtil.Stack();this.frame = new FrameStack();this.env = env;this.constants = env.constants;this.elementStack = elementStack;this.scopeStack.push(scope);this.dynamicScopeStack.push(dynamicScope);}VM.initial = function initial(env,self,dynamicScope,elementStack,compiledProgram){var size=compiledProgram.symbols;var start=compiledProgram.start;var end=compiledProgram.end;var scope=Scope.root(self,size);var vm=new VM(env,scope,dynamicScope,elementStack);vm.prepare(start,end);return vm;};VM.prototype.capture = function capture(){return {env:this.env,scope:this.scope(),dynamicScope:this.dynamicScope(),frame:this.frame.capture()};};VM.prototype.goto = function goto(ip){this.frame.goto(ip);};VM.prototype.beginCacheGroup = function beginCacheGroup(){this.cacheGroups.push(this.updating().tail());};VM.prototype.commitCacheGroup = function commitCacheGroup(){ //        JumpIfNotModified(END)
//        (head)
//        (....)
//        (tail)
//        DidModify
// END:   Noop
var END=new LabelOpcode("END");var opcodes=this.updating();var marker=this.cacheGroups.pop();var head=marker?opcodes.nextNode(marker):opcodes.head();var tail=opcodes.tail();var tag=_glimmerReference.combineSlice(new _glimmerUtil.ListSlice(head,tail));var guard=new JumpIfNotModifiedOpcode(tag,END);opcodes.insertBefore(guard,head);opcodes.append(new DidModifyOpcode(guard));opcodes.append(END);};VM.prototype.enter = function enter(start,end){var updating=new _glimmerUtil.LinkedList();var tracker=this.stack().pushUpdatableBlock();var state=this.capture();var tryOpcode=new TryOpcode(start,end,state,tracker,updating);this.didEnter(tryOpcode,updating);};VM.prototype.enterWithKey = function enterWithKey(key,start,end){var updating=new _glimmerUtil.LinkedList();var tracker=this.stack().pushUpdatableBlock();var state=this.capture();var tryOpcode=new TryOpcode(start,end,state,tracker,updating);this.listBlock().map[key] = tryOpcode;this.didEnter(tryOpcode,updating);};VM.prototype.enterList = function enterList(start,end){var updating=new _glimmerUtil.LinkedList();var tracker=this.stack().pushBlockList(updating);var state=this.capture();var artifacts=this.frame.getIterator().artifacts;var opcode=new ListBlockOpcode(start,end,state,tracker,updating,artifacts);this.listBlockStack.push(opcode);this.didEnter(opcode,updating);};VM.prototype.didEnter = function didEnter(opcode,updating){this.updateWith(opcode);this.updatingOpcodeStack.push(updating);};VM.prototype.exit = function exit(){this.stack().popBlock();this.updatingOpcodeStack.pop();var parent=this.updating().tail();parent.didInitializeChildren();};VM.prototype.exitList = function exitList(){this.exit();this.listBlockStack.pop();};VM.prototype.updateWith = function updateWith(opcode){this.updating().append(opcode);};VM.prototype.listBlock = function listBlock(){return _glimmerUtil.expect(this.listBlockStack.current,'expected a list block');};VM.prototype.updating = function updating(){return _glimmerUtil.expect(this.updatingOpcodeStack.current,'expected updating opcode on the updating opcode stack');};VM.prototype.stack = function stack(){return this.elementStack;};VM.prototype.scope = function scope(){return _glimmerUtil.expect(this.scopeStack.current,'expected scope on the scope stack');};VM.prototype.dynamicScope = function dynamicScope(){return _glimmerUtil.expect(this.dynamicScopeStack.current,'expected dynamic scope on the dynamic scope stack');};VM.prototype.pushFrame = function pushFrame(block,args,callerScope){this.frame.push(block.start,block.end);if(args)this.frame.setArgs(args);if(args && args.blocks)this.frame.setBlocks(args.blocks);if(callerScope)this.frame.setCallerScope(callerScope);};VM.prototype.pushComponentFrame = function pushComponentFrame(layout,args,callerScope,component,manager,shadow){this.frame.push(layout.start,layout.end,component,manager,shadow);if(args)this.frame.setArgs(args);if(args && args.blocks)this.frame.setBlocks(args.blocks);if(callerScope)this.frame.setCallerScope(callerScope);};VM.prototype.pushEvalFrame = function pushEvalFrame(start,end){this.frame.push(start,end);};VM.prototype.pushChildScope = function pushChildScope(){this.scopeStack.push(this.scope().child());};VM.prototype.pushCallerScope = function pushCallerScope(){this.scopeStack.push(_glimmerUtil.expect(this.scope().getCallerScope(),'pushCallerScope is called when a caller scope is present'));};VM.prototype.pushDynamicScope = function pushDynamicScope(){var child=this.dynamicScope().child();this.dynamicScopeStack.push(child);return child;};VM.prototype.pushRootScope = function pushRootScope(self,size){var scope=Scope.root(self,size);this.scopeStack.push(scope);return scope;};VM.prototype.popScope = function popScope(){this.scopeStack.pop();};VM.prototype.popDynamicScope = function popDynamicScope(){this.dynamicScopeStack.pop();};VM.prototype.newDestroyable = function newDestroyable(d){this.stack().newDestroyable(d);}; /// SCOPE HELPERS
VM.prototype.getSelf = function getSelf(){return this.scope().getSelf();};VM.prototype.referenceForSymbol = function referenceForSymbol(symbol){return this.scope().getSymbol(symbol);};VM.prototype.getArgs = function getArgs(){return this.frame.getArgs();}; /// EXECUTION
VM.prototype.resume = function resume(start,end,frame){return this.execute(start,end,function(vm){return vm.frame.restore(frame);});};VM.prototype.execute = function execute(start,end,initialize){this.prepare(start,end,initialize);var result=undefined;while(true) {result = this.next();if(result.done)break;}return result.value;};VM.prototype.prepare = function prepare(start,end,initialize){var elementStack=this.elementStack;var frame=this.frame;var updatingOpcodeStack=this.updatingOpcodeStack;elementStack.pushSimpleBlock();updatingOpcodeStack.push(new _glimmerUtil.LinkedList());frame.push(start,end);if(initialize)initialize(this);};VM.prototype.next = function next(){var frame=this.frame;var env=this.env;var updatingOpcodeStack=this.updatingOpcodeStack;var elementStack=this.elementStack;var opcode=undefined;if(opcode = frame.nextStatement(env)){APPEND_OPCODES.evaluate(this,opcode);return {done:false,value:null};}return {done:true,value:new RenderResult(env,_glimmerUtil.expect(updatingOpcodeStack.pop(),'there should be a final updating opcode stack'),elementStack.popBlock())};};VM.prototype.evaluateOpcode = function evaluateOpcode(opcode){APPEND_OPCODES.evaluate(this,opcode);}; // Make sure you have opcodes that push and pop a scope around this opcode
// if you need to change the scope.
VM.prototype.invokeBlock = function invokeBlock(block,args){var compiled=block.compile(this.env);this.pushFrame(compiled,args);};VM.prototype.invokePartial = function invokePartial(block){var compiled=block.compile(this.env);this.pushFrame(compiled);};VM.prototype.invokeLayout = function invokeLayout(args,layout,callerScope,component,manager,shadow){this.pushComponentFrame(layout,args,callerScope,component,manager,shadow);};VM.prototype.evaluateOperand = function evaluateOperand(expr){this.frame.setOperand(expr.evaluate(this));};VM.prototype.evaluateArgs = function evaluateArgs(args){var evaledArgs=this.frame.setArgs(args.evaluate(this));this.frame.setOperand(evaledArgs.positional.at(0));};VM.prototype.bindPositionalArgs = function bindPositionalArgs(symbols){var args=_glimmerUtil.expect(this.frame.getArgs(),'bindPositionalArgs assumes a previous setArgs');var positional=args.positional;var scope=this.scope();for(var i=0;i < symbols.length;i++) {scope.bindSymbol(symbols[i],positional.at(i));}};VM.prototype.bindNamedArgs = function bindNamedArgs(names,symbols){var args=_glimmerUtil.expect(this.frame.getArgs(),'bindNamedArgs assumes a previous setArgs');var scope=this.scope();var named=args.named;for(var i=0;i < names.length;i++) {var _name2=this.constants.getString(names[i]);scope.bindSymbol(symbols[i],named.get(_name2));}};VM.prototype.bindBlocks = function bindBlocks(names,symbols){var blocks=this.frame.getBlocks();var scope=this.scope();for(var i=0;i < names.length;i++) {var _name3=this.constants.getString(names[i]);scope.bindBlock(symbols[i],blocks && blocks[_name3] || null);}};VM.prototype.bindPartialArgs = function bindPartialArgs(symbol){var args=_glimmerUtil.expect(this.frame.getArgs(),'bindPartialArgs assumes a previous setArgs');var scope=this.scope();_glimmerUtil.assert(args,"Cannot bind named args");scope.bindPartialArgs(symbol,args);};VM.prototype.bindCallerScope = function bindCallerScope(){var callerScope=this.frame.getCallerScope();var scope=this.scope();_glimmerUtil.assert(callerScope,"Cannot bind caller scope");scope.bindCallerScope(callerScope);};VM.prototype.bindDynamicScope = function bindDynamicScope(names){var args=_glimmerUtil.expect(this.frame.getArgs(),'bindDynamicScope assumes a previous setArgs');var scope=this.dynamicScope();_glimmerUtil.assert(args,"Cannot bind dynamic scope");for(var i=0;i < names.length;i++) {var _name4=this.constants.getString(names[i]);scope.set(_name4,args.named.get(_name4));}};return VM;})();var UpdatingVM=(function(){function UpdatingVM(env,_ref30){var _ref30$alwaysRevalidate=_ref30.alwaysRevalidate;var alwaysRevalidate=_ref30$alwaysRevalidate === undefined?false:_ref30$alwaysRevalidate;this.frameStack = new _glimmerUtil.Stack();this.env = env;this.constants = env.constants;this.dom = env.getDOM();this.alwaysRevalidate = alwaysRevalidate;}UpdatingVM.prototype.execute = function execute(opcodes,handler){var frameStack=this.frameStack;this.try(opcodes,handler);while(true) {if(frameStack.isEmpty())break;var opcode=this.frame.nextStatement();if(opcode === null){this.frameStack.pop();continue;}opcode.evaluate(this);}};UpdatingVM.prototype.goto = function goto(op){this.frame.goto(op);};UpdatingVM.prototype.try = function _try(ops,handler){this.frameStack.push(new UpdatingVMFrame(this,ops,handler));};UpdatingVM.prototype.throw = function _throw(){this.frame.handleException();this.frameStack.pop();};UpdatingVM.prototype.evaluateOpcode = function evaluateOpcode(opcode){opcode.evaluate(this);};babelHelpers.createClass(UpdatingVM,[{key:'frame',get:function(){return _glimmerUtil.expect(this.frameStack.current,'bug: expected a frame');}}]);return UpdatingVM;})();var BlockOpcode=(function(_UpdatingOpcode8){babelHelpers.inherits(BlockOpcode,_UpdatingOpcode8);function BlockOpcode(start,end,state,bounds,children){_UpdatingOpcode8.call(this);this.start = start;this.end = end;this.type = "block";this.next = null;this.prev = null;var env=state.env;var scope=state.scope;var dynamicScope=state.dynamicScope;var frame=state.frame;this.children = children;this.env = env;this.scope = scope;this.dynamicScope = dynamicScope;this.frame = frame;this.bounds = bounds;}BlockOpcode.prototype.parentElement = function parentElement(){return this.bounds.parentElement();};BlockOpcode.prototype.firstNode = function firstNode(){return this.bounds.firstNode();};BlockOpcode.prototype.lastNode = function lastNode(){return this.bounds.lastNode();};BlockOpcode.prototype.evaluate = function evaluate(vm){vm.try(this.children,null);};BlockOpcode.prototype.destroy = function destroy(){this.bounds.destroy();};BlockOpcode.prototype.didDestroy = function didDestroy(){this.env.didDestroy(this.bounds);};BlockOpcode.prototype.toJSON = function toJSON(){var details=_glimmerUtil.dict();details["guid"] = '' + this._guid;return {guid:this._guid,type:this.type,details:details,children:this.children.toArray().map(function(op){return op.toJSON();})};};return BlockOpcode;})(UpdatingOpcode);var TryOpcode=(function(_BlockOpcode){babelHelpers.inherits(TryOpcode,_BlockOpcode);function TryOpcode(start,end,state,bounds,children){_BlockOpcode.call(this,start,end,state,bounds,children);this.type = "try";this.tag = this._tag = new _glimmerReference.UpdatableTag(_glimmerReference.CONSTANT_TAG);}TryOpcode.prototype.didInitializeChildren = function didInitializeChildren(){this._tag.update(_glimmerReference.combineSlice(this.children));};TryOpcode.prototype.evaluate = function evaluate(vm){vm.try(this.children,this);};TryOpcode.prototype.handleException = function handleException(){var env=this.env;var scope=this.scope;var start=this.start;var end=this.end;var dynamicScope=this.dynamicScope;var frame=this.frame;var elementStack=ElementStack.resume(this.env,this.bounds,this.bounds.reset(env));var vm=new VM(env,scope,dynamicScope,elementStack);var result=vm.resume(start,end,frame);this.children = result.opcodes();this.didInitializeChildren();};TryOpcode.prototype.toJSON = function toJSON(){var json=_BlockOpcode.prototype.toJSON.call(this);var details=json["details"];if(!details){details = json["details"] = {};}return _BlockOpcode.prototype.toJSON.call(this);};return TryOpcode;})(BlockOpcode);var ListRevalidationDelegate=(function(){function ListRevalidationDelegate(opcode,marker){this.opcode = opcode;this.marker = marker;this.didInsert = false;this.didDelete = false;this.map = opcode.map;this.updating = opcode['children'];}ListRevalidationDelegate.prototype.insert = function insert(key,item,memo,before){var map=this.map;var opcode=this.opcode;var updating=this.updating;var nextSibling=null;var reference=null;if(before){reference = map[before];nextSibling = reference['bounds'].firstNode();}else {nextSibling = this.marker;}var vm=opcode.vmForInsertion(nextSibling);var tryOpcode=null;vm.execute(opcode.start,opcode.end,function(vm){vm.frame.setArgs(EvaluatedArgs.positional([item,memo]));vm.frame.setOperand(item);vm.frame.setCondition(new _glimmerReference.ConstReference(true));vm.frame.setKey(key);var state=vm.capture();var tracker=vm.stack().pushUpdatableBlock();tryOpcode = new TryOpcode(opcode.start,opcode.end,state,tracker,vm.updating());});tryOpcode.didInitializeChildren();updating.insertBefore(tryOpcode,reference);map[key] = tryOpcode;this.didInsert = true;};ListRevalidationDelegate.prototype.retain = function retain(_key,_item,_memo){};ListRevalidationDelegate.prototype.move = function move(key,_item,_memo,before){var map=this.map;var updating=this.updating;var entry=map[key];var reference=map[before] || null;if(before){moveBounds(entry,reference.firstNode());}else {moveBounds(entry,this.marker);}updating.remove(entry);updating.insertBefore(entry,reference);};ListRevalidationDelegate.prototype.delete = function _delete(key){var map=this.map;var opcode=map[key];opcode.didDestroy();clear(opcode);this.updating.remove(opcode);delete map[key];this.didDelete = true;};ListRevalidationDelegate.prototype.done = function done(){this.opcode.didInitializeChildren(this.didInsert || this.didDelete);};return ListRevalidationDelegate;})();var ListBlockOpcode=(function(_BlockOpcode2){babelHelpers.inherits(ListBlockOpcode,_BlockOpcode2);function ListBlockOpcode(start,end,state,bounds,children,artifacts){_BlockOpcode2.call(this,start,end,state,bounds,children);this.type = "list-block";this.map = _glimmerUtil.dict();this.lastIterated = _glimmerReference.INITIAL;this.artifacts = artifacts;var _tag=this._tag = new _glimmerReference.UpdatableTag(_glimmerReference.CONSTANT_TAG);this.tag = _glimmerReference.combine([artifacts.tag,_tag]);}ListBlockOpcode.prototype.didInitializeChildren = function didInitializeChildren(){var listDidChange=arguments.length <= 0 || arguments[0] === undefined?true:arguments[0];this.lastIterated = this.artifacts.tag.value();if(listDidChange){this._tag.update(_glimmerReference.combineSlice(this.children));}};ListBlockOpcode.prototype.evaluate = function evaluate(vm){var artifacts=this.artifacts;var lastIterated=this.lastIterated;if(!artifacts.tag.validate(lastIterated)){var bounds=this.bounds;var dom=vm.dom;var marker=dom.createComment('');dom.insertAfter(bounds.parentElement(),marker,_glimmerUtil.expect(bounds.lastNode(),"can't insert after an empty bounds"));var target=new ListRevalidationDelegate(this,marker);var synchronizer=new _glimmerReference.IteratorSynchronizer({target:target,artifacts:artifacts});synchronizer.sync();this.parentElement().removeChild(marker);} // Run now-updated updating opcodes
_BlockOpcode2.prototype.evaluate.call(this,vm);};ListBlockOpcode.prototype.vmForInsertion = function vmForInsertion(nextSibling){var env=this.env;var scope=this.scope;var dynamicScope=this.dynamicScope;var elementStack=ElementStack.forInitialRender(this.env,this.bounds.parentElement(),nextSibling);return new VM(env,scope,dynamicScope,elementStack);};ListBlockOpcode.prototype.toJSON = function toJSON(){var json=_BlockOpcode2.prototype.toJSON.call(this);var map=this.map;var inner=Object.keys(map).map(function(key){return JSON.stringify(key) + ': ' + map[key]._guid;}).join(", ");var details=json["details"];if(!details){details = json["details"] = {};}details["map"] = '{' + inner + '}';return json;};return ListBlockOpcode;})(BlockOpcode);var UpdatingVMFrame=(function(){function UpdatingVMFrame(vm,ops,exceptionHandler){this.vm = vm;this.ops = ops;this.exceptionHandler = exceptionHandler;this.vm = vm;this.ops = ops;this.current = ops.head();}UpdatingVMFrame.prototype.goto = function goto(op){this.current = op;};UpdatingVMFrame.prototype.nextStatement = function nextStatement(){var current=this.current;var ops=this.ops;if(current)this.current = ops.nextNode(current);return current;};UpdatingVMFrame.prototype.handleException = function handleException(){if(this.exceptionHandler){this.exceptionHandler.handleException();}};return UpdatingVMFrame;})();APPEND_OPCODES.add(31, /* DynamicContent */function(vm,_ref31){var append=_ref31.op1;var opcode=vm.constants.getOther(append);opcode.evaluate(vm);});function isEmpty(value){return value === null || value === undefined || typeof value['toString'] !== 'function';}function normalizeTextValue(value){if(isEmpty(value)){return '';}return String(value);}function normalizeTrustedValue(value){if(isEmpty(value)){return '';}if(isString(value)){return value;}if(isSafeString(value)){return value.toHTML();}if(isNode(value)){return value;}return String(value);}function normalizeValue(value){if(isEmpty(value)){return '';}if(isString(value)){return value;}if(isSafeString(value) || isNode(value)){return value;}return String(value);}var AppendDynamicOpcode=(function(){function AppendDynamicOpcode(){}AppendDynamicOpcode.prototype.evaluate = function evaluate(vm){var reference=vm.frame.getOperand();var normalized=this.normalize(reference);var value=undefined,cache=undefined;if(_glimmerReference.isConst(reference)){value = normalized.value();}else {cache = new _glimmerReference.ReferenceCache(normalized);value = cache.peek();}var stack=vm.stack();var upsert=this.insert(vm.env.getAppendOperations(),stack,value);var bounds=new Fragment(upsert.bounds);stack.newBounds(bounds);if(cache /* i.e. !isConst(reference) */){vm.updateWith(this.updateWith(vm,reference,cache,bounds,upsert));}};return AppendDynamicOpcode;})();var GuardedAppendOpcode=(function(_AppendDynamicOpcode){babelHelpers.inherits(GuardedAppendOpcode,_AppendDynamicOpcode);function GuardedAppendOpcode(expression,symbolTable){_AppendDynamicOpcode.call(this);this.expression = expression;this.symbolTable = symbolTable;this.start = -1;this.end = -1;}GuardedAppendOpcode.prototype.evaluate = function evaluate(vm){if(this.start === -1){vm.evaluateOperand(this.expression);var value=vm.frame.getOperand().value();if(isComponentDefinition(value)){this.deopt(vm.env);vm.pushEvalFrame(this.start,this.end);}else {_AppendDynamicOpcode.prototype.evaluate.call(this,vm);}}else {vm.pushEvalFrame(this.start,this.end);}};GuardedAppendOpcode.prototype.deopt = function deopt(env){var _this3=this; // At compile time, we determined that this append callsite might refer
// to a local variable/property lookup that resolves to a component
// definition at runtime.
//
// We could have eagerly compiled this callsite into something like this:
//
//   {{#if (is-component-definition foo)}}
//     {{component foo}}
//   {{else}}
//     {{foo}}
//   {{/if}}
//
// However, in practice, there might be a large amout of these callsites
// and most of them would resolve to a simple value lookup. Therefore, we
// tried to be optimistic and assumed that the callsite will resolve to
// appending a simple value.
//
// However, we have reached here because at runtime, the guard conditional
// have detected that this callsite is indeed referring to a component
// definition object. Since this is likely going to be true for other
// instances of the same callsite, it is now appropiate to deopt into the
// expanded version that handles both cases. The compilation would look
// like this:
//
//               PutValue(expression)
//               Test(is-component-definition)
//               Enter(BEGIN, END)
//   BEGIN:      Noop
//               JumpUnless(VALUE)
//               PutDynamicComponentDefinitionOpcode
//               OpenComponent
//               CloseComponent
//               Jump(END)
//   VALUE:      Noop
//               OptimizedAppend
//   END:        Noop
//               Exit
//
// Keep in mind that even if we *don't* reach here at initial render time,
// it is still possible (although quite rare) that the simple value we
// encounter during initial render could later change into a component
// definition object at update time. That is handled by the "lazy deopt"
// code on the update side (scroll down for the next big block of comment).
var dsl=new OpcodeBuilder(this.symbolTable,env);dsl.putValue(this.expression);dsl.test(IsComponentDefinitionReference.create);dsl.labelled(null,function(dsl,_BEGIN,END){dsl.jumpUnless('VALUE');dsl.putDynamicComponentDefinition();dsl.openComponent(CompiledArgs.empty());dsl.closeComponent();dsl.jump(END);dsl.label('VALUE');dsl.dynamicContent(new _this3.AppendOpcode());});this.start = dsl.start;this.end = dsl.end; // From this point on, we have essentially replaced ourselves with a new set
// of opcodes. Since we will always be executing the new/deopted code, it's
// a good idea (as a pattern) to null out any unneeded fields here to avoid
// holding on to unneeded/stale objects:
// QUESTION: Shouldn't this whole object be GCed? If not, why not?
this.expression = null;return dsl.start;};return GuardedAppendOpcode;})(AppendDynamicOpcode);var IsComponentDefinitionReference=(function(_ConditionalReference){babelHelpers.inherits(IsComponentDefinitionReference,_ConditionalReference);function IsComponentDefinitionReference(){_ConditionalReference.apply(this,arguments);}IsComponentDefinitionReference.create = function create(inner){return new IsComponentDefinitionReference(inner);};IsComponentDefinitionReference.prototype.toBool = function toBool(value){return isComponentDefinition(value);};return IsComponentDefinitionReference;})(ConditionalReference);var UpdateOpcode=(function(_UpdatingOpcode9){babelHelpers.inherits(UpdateOpcode,_UpdatingOpcode9);function UpdateOpcode(cache,bounds,upsert){_UpdatingOpcode9.call(this);this.cache = cache;this.bounds = bounds;this.upsert = upsert;this.tag = cache.tag;}UpdateOpcode.prototype.evaluate = function evaluate(vm){var value=this.cache.revalidate();if(_glimmerReference.isModified(value)){var bounds=this.bounds;var upsert=this.upsert;var dom=vm.dom;if(!this.upsert.update(dom,value)){var cursor=new Cursor(bounds.parentElement(),clear(bounds));upsert = this.upsert = this.insert(vm.env.getAppendOperations(),cursor,value);}bounds.update(upsert.bounds);}};UpdateOpcode.prototype.toJSON = function toJSON(){var guid=this._guid;var type=this.type;var cache=this.cache;return {guid:guid,type:type,details:{lastValue:JSON.stringify(cache.peek())}};};return UpdateOpcode;})(UpdatingOpcode);var GuardedUpdateOpcode=(function(_UpdateOpcode){babelHelpers.inherits(GuardedUpdateOpcode,_UpdateOpcode);function GuardedUpdateOpcode(reference,cache,bounds,upsert,appendOpcode,state){_UpdateOpcode.call(this,cache,bounds,upsert);this.reference = reference;this.appendOpcode = appendOpcode;this.state = state;this.deopted = null;this.tag = this._tag = new _glimmerReference.UpdatableTag(this.tag);}GuardedUpdateOpcode.prototype.evaluate = function evaluate(vm){if(this.deopted){vm.evaluateOpcode(this.deopted);}else {if(isComponentDefinition(this.reference.value())){this.lazyDeopt(vm);}else {_UpdateOpcode.prototype.evaluate.call(this,vm);}}};GuardedUpdateOpcode.prototype.lazyDeopt = function lazyDeopt(vm){ // Durign initial render, we know that the reference does not contain a
// component definition, so we optimistically assumed that this append
// is just a normal append. However, at update time, we discovered that
// the reference has switched into containing a component definition, so
// we need to do a "lazy deopt", simulating what would have happened if
// we had decided to perform the deopt in the first place during initial
// render.
//
// More concretely, we would have expanded the curly into a if/else, and
// based on whether the value is a component definition or not, we would
// have entered either the dynamic component branch or the simple value
// branch.
//
// Since we rendered a simple value during initial render (and all the
// updates up until this point), we need to pretend that the result is
// produced by the "VALUE" branch of the deopted append opcode:
//
//   Try(BEGIN, END)
//     Assert(IsComponentDefinition, expected=false)
//     OptimizedUpdate
//
// In this case, because the reference has switched from being a simple
// value into a component definition, what would have happened is that
// the assert would throw, causing the Try opcode to teardown the bounds
// and rerun the original append opcode.
//
// Since the Try opcode would have nuked the updating opcodes anyway, we
// wouldn't have to worry about simulating those. All we have to do is to
// execute the Try opcode and immediately throw.
var bounds=this.bounds;var appendOpcode=this.appendOpcode;var state=this.state;var env=vm.env;var deoptStart=appendOpcode.deopt(env);var enter=_glimmerUtil.expect(env.program.opcode(deoptStart + 8),'hardcoded deopt location');var start=enter.op1;var end=enter.op2;var tracker=new UpdatableBlockTracker(bounds.parentElement());tracker.newBounds(this.bounds);var children=new _glimmerUtil.LinkedList();state.frame.condition = IsComponentDefinitionReference.create(_glimmerUtil.expect(state.frame['operand'],'operand should be populated'));var deopted=this.deopted = new TryOpcode(start,end,state,tracker,children);this._tag.update(deopted.tag);vm.evaluateOpcode(deopted);vm.throw(); // From this point on, we have essentially replaced ourselve with a new
// opcode. Since we will always be executing the new/deopted code, it's a
// good idea (as a pattern) to null out any unneeded fields here to avoid
// holding on to unneeded/stale objects:
// QUESTION: Shouldn't this whole object be GCed? If not, why not?
this._tag = null;this.reference = null;this.cache = null;this.bounds = null;this.upsert = null;this.appendOpcode = null;this.state = null;};GuardedUpdateOpcode.prototype.toJSON = function toJSON(){var guid=this._guid;var type=this.type;var deopted=this.deopted;if(deopted){return {guid:guid,type:type,deopted:true,children:[deopted.toJSON()]};}else {return _UpdateOpcode.prototype.toJSON.call(this);}};return GuardedUpdateOpcode;})(UpdateOpcode);var OptimizedCautiousAppendOpcode=(function(_AppendDynamicOpcode2){babelHelpers.inherits(OptimizedCautiousAppendOpcode,_AppendDynamicOpcode2);function OptimizedCautiousAppendOpcode(){_AppendDynamicOpcode2.apply(this,arguments);this.type = 'optimized-cautious-append';}OptimizedCautiousAppendOpcode.prototype.normalize = function normalize(reference){return _glimmerReference.map(reference,normalizeValue);};OptimizedCautiousAppendOpcode.prototype.insert = function insert(dom,cursor,value){return cautiousInsert(dom,cursor,value);};OptimizedCautiousAppendOpcode.prototype.updateWith = function updateWith(_vm,_reference,cache,bounds,upsert){return new OptimizedCautiousUpdateOpcode(cache,bounds,upsert);};return OptimizedCautiousAppendOpcode;})(AppendDynamicOpcode);var OptimizedCautiousUpdateOpcode=(function(_UpdateOpcode2){babelHelpers.inherits(OptimizedCautiousUpdateOpcode,_UpdateOpcode2);function OptimizedCautiousUpdateOpcode(){_UpdateOpcode2.apply(this,arguments);this.type = 'optimized-cautious-update';}OptimizedCautiousUpdateOpcode.prototype.insert = function insert(dom,cursor,value){return cautiousInsert(dom,cursor,value);};return OptimizedCautiousUpdateOpcode;})(UpdateOpcode);var GuardedCautiousAppendOpcode=(function(_GuardedAppendOpcode){babelHelpers.inherits(GuardedCautiousAppendOpcode,_GuardedAppendOpcode);function GuardedCautiousAppendOpcode(){_GuardedAppendOpcode.apply(this,arguments);this.type = 'guarded-cautious-append';this.AppendOpcode = OptimizedCautiousAppendOpcode;}GuardedCautiousAppendOpcode.prototype.normalize = function normalize(reference){return _glimmerReference.map(reference,normalizeValue);};GuardedCautiousAppendOpcode.prototype.insert = function insert(dom,cursor,value){return cautiousInsert(dom,cursor,value);};GuardedCautiousAppendOpcode.prototype.updateWith = function updateWith(vm,reference,cache,bounds,upsert){return new GuardedCautiousUpdateOpcode(reference,cache,bounds,upsert,this,vm.capture());};return GuardedCautiousAppendOpcode;})(GuardedAppendOpcode);var GuardedCautiousUpdateOpcode=(function(_GuardedUpdateOpcode){babelHelpers.inherits(GuardedCautiousUpdateOpcode,_GuardedUpdateOpcode);function GuardedCautiousUpdateOpcode(){_GuardedUpdateOpcode.apply(this,arguments);this.type = 'guarded-cautious-update';}GuardedCautiousUpdateOpcode.prototype.insert = function insert(dom,cursor,value){return cautiousInsert(dom,cursor,value);};return GuardedCautiousUpdateOpcode;})(GuardedUpdateOpcode);var OptimizedTrustingAppendOpcode=(function(_AppendDynamicOpcode3){babelHelpers.inherits(OptimizedTrustingAppendOpcode,_AppendDynamicOpcode3);function OptimizedTrustingAppendOpcode(){_AppendDynamicOpcode3.apply(this,arguments);this.type = 'optimized-trusting-append';}OptimizedTrustingAppendOpcode.prototype.normalize = function normalize(reference){return _glimmerReference.map(reference,normalizeTrustedValue);};OptimizedTrustingAppendOpcode.prototype.insert = function insert(dom,cursor,value){return trustingInsert(dom,cursor,value);};OptimizedTrustingAppendOpcode.prototype.updateWith = function updateWith(_vm,_reference,cache,bounds,upsert){return new OptimizedTrustingUpdateOpcode(cache,bounds,upsert);};return OptimizedTrustingAppendOpcode;})(AppendDynamicOpcode);var OptimizedTrustingUpdateOpcode=(function(_UpdateOpcode3){babelHelpers.inherits(OptimizedTrustingUpdateOpcode,_UpdateOpcode3);function OptimizedTrustingUpdateOpcode(){_UpdateOpcode3.apply(this,arguments);this.type = 'optimized-trusting-update';}OptimizedTrustingUpdateOpcode.prototype.insert = function insert(dom,cursor,value){return trustingInsert(dom,cursor,value);};return OptimizedTrustingUpdateOpcode;})(UpdateOpcode);var GuardedTrustingAppendOpcode=(function(_GuardedAppendOpcode2){babelHelpers.inherits(GuardedTrustingAppendOpcode,_GuardedAppendOpcode2);function GuardedTrustingAppendOpcode(){_GuardedAppendOpcode2.apply(this,arguments);this.type = 'guarded-trusting-append';this.AppendOpcode = OptimizedTrustingAppendOpcode;}GuardedTrustingAppendOpcode.prototype.normalize = function normalize(reference){return _glimmerReference.map(reference,normalizeTrustedValue);};GuardedTrustingAppendOpcode.prototype.insert = function insert(dom,cursor,value){return trustingInsert(dom,cursor,value);};GuardedTrustingAppendOpcode.prototype.updateWith = function updateWith(vm,reference,cache,bounds,upsert){return new GuardedTrustingUpdateOpcode(reference,cache,bounds,upsert,this,vm.capture());};return GuardedTrustingAppendOpcode;})(GuardedAppendOpcode);var GuardedTrustingUpdateOpcode=(function(_GuardedUpdateOpcode2){babelHelpers.inherits(GuardedTrustingUpdateOpcode,_GuardedUpdateOpcode2);function GuardedTrustingUpdateOpcode(){_GuardedUpdateOpcode2.apply(this,arguments);this.type = 'trusting-update';}GuardedTrustingUpdateOpcode.prototype.insert = function insert(dom,cursor,value){return trustingInsert(dom,cursor,value);};return GuardedTrustingUpdateOpcode;})(GuardedUpdateOpcode);APPEND_OPCODES.add(49, /* PutDynamicPartial */function(vm,_ref32){var _symbolTable=_ref32.op1;var env=vm.env;var symbolTable=vm.constants.getOther(_symbolTable);function lookupPartial(name){var normalized=String(name);if(!env.hasPartial(normalized,symbolTable)){throw new Error('Could not find a partial named "' + normalized + '"');}return env.lookupPartial(normalized,symbolTable);}var reference=_glimmerReference.map(vm.frame.getOperand(),lookupPartial);var cache=_glimmerReference.isConst(reference)?undefined:new _glimmerReference.ReferenceCache(reference);var definition=cache?cache.peek():reference.value();vm.frame.setImmediate(definition);if(cache){vm.updateWith(new Assert(cache));}});APPEND_OPCODES.add(50, /* PutPartial */function(vm,_ref33){var _definition=_ref33.op1;var definition=vm.constants.getOther(_definition);vm.frame.setImmediate(definition);});APPEND_OPCODES.add(51, /* EvaluatePartial */function(vm,_ref34){var _symbolTable=_ref34.op1;var _cache=_ref34.op2;var symbolTable=vm.constants.getOther(_symbolTable);var cache=vm.constants.getOther(_cache);var _vm$frame$getImmediate=vm.frame.getImmediate();var template=_vm$frame$getImmediate.template;var block=cache[template.id];if(!block){block = template.asPartial(symbolTable);}vm.invokePartial(block);});var IterablePresenceReference=(function(){function IterablePresenceReference(artifacts){this.tag = artifacts.tag;this.artifacts = artifacts;}IterablePresenceReference.prototype.value = function value(){return !this.artifacts.isEmpty();};return IterablePresenceReference;})();APPEND_OPCODES.add(44, /* PutIterator */function(vm){var listRef=vm.frame.getOperand();var args=_glimmerUtil.expect(vm.frame.getArgs(),'PutIteratorOpcode expects a populated args register');var iterable=vm.env.iterableFor(listRef,args);var iterator=new _glimmerReference.ReferenceIterator(iterable);vm.frame.setIterator(iterator);vm.frame.setCondition(new IterablePresenceReference(iterator.artifacts));});APPEND_OPCODES.add(45, /* EnterList */function(vm,_ref35){var start=_ref35.op1;var end=_ref35.op2;vm.enterList(start,end);});APPEND_OPCODES.add(46, /* ExitList */function(vm){return vm.exitList();});APPEND_OPCODES.add(47, /* EnterWithKey */function(vm,_ref36){var start=_ref36.op1;var end=_ref36.op2;var key=_glimmerUtil.expect(vm.frame.getKey(),'EnterWithKeyOpcode expects a populated key register');vm.enterWithKey(key,start,end);});var TRUE_REF=new _glimmerReference.ConstReference(true);var FALSE_REF=new _glimmerReference.ConstReference(false);APPEND_OPCODES.add(48, /* NextIter */function(vm,_ref37){var end=_ref37.op1;var item=vm.frame.getIterator().next();if(item){vm.frame.setCondition(TRUE_REF);vm.frame.setKey(item.key);vm.frame.setOperand(item.value);vm.frame.setArgs(EvaluatedArgs.positional([item.value,item.memo]));}else {vm.frame.setCondition(FALSE_REF);vm.goto(end);}});var TemplateIterator=(function(){function TemplateIterator(vm){this.vm = vm;}TemplateIterator.prototype.next = function next(){return this.vm.next();};return TemplateIterator;})();var clientId=0;function templateFactory(_ref38){var templateId=_ref38.id;var meta=_ref38.meta;var block=_ref38.block;var parsedBlock=undefined;var id=templateId || 'client-' + clientId++;var create=function(env,envMeta){var newMeta=envMeta?_glimmerUtil.assign({},envMeta,meta):meta;if(!parsedBlock){parsedBlock = JSON.parse(block);}return template(parsedBlock,id,newMeta,env);};return {id:id,meta:meta,create:create};}function template(block,id,meta,env){var scanner=new Scanner(block,meta,env);var entryPoint=undefined;var asEntryPoint=function(){if(!entryPoint)entryPoint = scanner.scanEntryPoint();return entryPoint;};var layout=undefined;var asLayout=function(){if(!layout)layout = scanner.scanLayout();return layout;};var asPartial=function(symbols){return scanner.scanPartial(symbols);};var render=function(self,appendTo,dynamicScope){var elementStack=ElementStack.forInitialRender(env,appendTo,null);var compiled=asEntryPoint().compile(env);var vm=VM.initial(env,self,dynamicScope,elementStack,compiled);return new TemplateIterator(vm);};return {id:id,meta:meta,_block:block,asEntryPoint:asEntryPoint,asLayout:asLayout,asPartial:asPartial,render:render};}var DynamicVarReference=(function(){function DynamicVarReference(scope,nameRef){this.scope = scope;this.nameRef = nameRef;var varTag=this.varTag = new _glimmerReference.UpdatableTag(_glimmerReference.CONSTANT_TAG);this.tag = _glimmerReference.combine([nameRef.tag,varTag]);}DynamicVarReference.prototype.value = function value(){return this.getVar().value();};DynamicVarReference.prototype.get = function get(key){return this.getVar().get(key);};DynamicVarReference.prototype.getVar = function getVar(){var name=String(this.nameRef.value());var ref=this.scope.get(name);this.varTag.update(ref.tag);return ref;};return DynamicVarReference;})();function getDynamicVar(vm,args,_symbolTable){var scope=vm.dynamicScope();var nameRef=args.positional.at(0);return new DynamicVarReference(scope,nameRef);}var PartialDefinition=function PartialDefinition(name,template){this.name = name;this.template = template;};var NodeType;(function(NodeType){NodeType[NodeType["Element"] = 0] = "Element";NodeType[NodeType["Attribute"] = 1] = "Attribute";NodeType[NodeType["Text"] = 2] = "Text";NodeType[NodeType["CdataSection"] = 3] = "CdataSection";NodeType[NodeType["EntityReference"] = 4] = "EntityReference";NodeType[NodeType["Entity"] = 5] = "Entity";NodeType[NodeType["ProcessingInstruction"] = 6] = "ProcessingInstruction";NodeType[NodeType["Comment"] = 7] = "Comment";NodeType[NodeType["Document"] = 8] = "Document";NodeType[NodeType["DocumentType"] = 9] = "DocumentType";NodeType[NodeType["DocumentFragment"] = 10] = "DocumentFragment";NodeType[NodeType["Notation"] = 11] = "Notation";})(NodeType || (NodeType = {}));var Simple=Object.freeze({get NodeType(){return NodeType;}});exports.Simple = Simple;exports.templateFactory = templateFactory;exports.NULL_REFERENCE = NULL_REFERENCE;exports.UNDEFINED_REFERENCE = UNDEFINED_REFERENCE;exports.PrimitiveReference = PrimitiveReference;exports.ConditionalReference = ConditionalReference;exports.OpcodeBuilderDSL = OpcodeBuilder;exports.compileLayout = compileLayout;exports.CompiledBlock = CompiledBlock;exports.CompiledProgram = CompiledProgram;exports.IAttributeManager = AttributeManager;exports.AttributeManager = AttributeManager;exports.PropertyManager = PropertyManager;exports.INPUT_VALUE_PROPERTY_MANAGER = INPUT_VALUE_PROPERTY_MANAGER;exports.defaultManagers = defaultManagers;exports.defaultAttributeManagers = defaultAttributeManagers;exports.defaultPropertyManagers = defaultPropertyManagers;exports.readDOMAttr = readDOMAttr;exports.normalizeTextValue = normalizeTextValue;exports.CompiledExpression = CompiledExpression;exports.CompiledArgs = CompiledArgs;exports.CompiledNamedArgs = CompiledNamedArgs;exports.CompiledPositionalArgs = CompiledPositionalArgs;exports.EvaluatedArgs = EvaluatedArgs;exports.EvaluatedNamedArgs = EvaluatedNamedArgs;exports.EvaluatedPositionalArgs = EvaluatedPositionalArgs;exports.getDynamicVar = getDynamicVar;exports.BlockMacros = Blocks;exports.InlineMacros = Inlines;exports.compileArgs = compileArgs;exports.setDebuggerCallback = setDebuggerCallback;exports.resetDebuggerCallback = resetDebuggerCallback;exports.BaselineSyntax = BaselineSyntax;exports.Layout = Layout;exports.UpdatingVM = UpdatingVM;exports.RenderResult = RenderResult;exports.isSafeString = isSafeString;exports.Scope = Scope;exports.Environment = Environment;exports.PartialDefinition = PartialDefinition;exports.ComponentDefinition = ComponentDefinition;exports.isComponentDefinition = isComponentDefinition;exports.DOMChanges = helper$1;exports.IDOMChanges = DOMChanges;exports.DOMTreeConstruction = DOMTreeConstruction;exports.isWhitespace = isWhitespace;exports.insertHTMLBefore = _insertHTMLBefore;exports.ElementStack = ElementStack;exports.ConcreteBounds = ConcreteBounds;});
enifed('@glimmer/util', ['exports'], function (exports) {
    // There is a small whitelist of namespaced attributes specially
    // enumerated in
    // https://www.w3.org/TR/html/syntax.html#attributes-0
    //
    // > When a foreign element has one of the namespaced attributes given by
    // > the local name and namespace of the first and second cells of a row
    // > from the following table, it must be written using the name given by
    // > the third cell from the same row.
    //
    // In all other cases, colons are interpreted as a regular character
    // with no special meaning:
    //
    // > No other namespaced attribute can be expressed in the HTML syntax.
    'use strict';

    var XLINK = 'http://www.w3.org/1999/xlink';
    var XML = 'http://www.w3.org/XML/1998/namespace';
    var XMLNS = 'http://www.w3.org/2000/xmlns/';
    var WHITELIST = {
        'xlink:actuate': XLINK,
        'xlink:arcrole': XLINK,
        'xlink:href': XLINK,
        'xlink:role': XLINK,
        'xlink:show': XLINK,
        'xlink:title': XLINK,
        'xlink:type': XLINK,
        'xml:base': XML,
        'xml:lang': XML,
        'xml:space': XML,
        'xmlns': XMLNS,
        'xmlns:xlink': XMLNS
    };
    function getAttrNamespace(attrName) {
        return WHITELIST[attrName] || null;
    }

    // tslint:disable-line
    function unwrap(val) {
        if (val === null || val === undefined) throw new Error('Expected value to be present');
        return val;
    }
    function expect(val, message) {
        if (val === null || val === undefined) throw new Error(message);
        return val;
    }
    function unreachable() {
        return new Error('unreachable');
    }

    // import Logger from './logger';
    // let alreadyWarned = false;
    // import Logger from './logger';
    function debugAssert(test, msg) {
        // if (!alreadyWarned) {
        //   alreadyWarned = true;
        //   Logger.warn("Don't leave debug assertions on in public builds");
        // }
        if (!test) {
            throw new Error(msg || "assertion failure");
        }
    }

    var LogLevel;
    (function (LogLevel) {
        LogLevel[LogLevel["Trace"] = 0] = "Trace";
        LogLevel[LogLevel["Debug"] = 1] = "Debug";
        LogLevel[LogLevel["Warn"] = 2] = "Warn";
        LogLevel[LogLevel["Error"] = 3] = "Error";
    })(LogLevel || (exports.LogLevel = LogLevel = {}));

    var NullConsole = (function () {
        function NullConsole() {}

        NullConsole.prototype.log = function log(_message) {};

        NullConsole.prototype.warn = function warn(_message) {};

        NullConsole.prototype.error = function error(_message) {};

        NullConsole.prototype.trace = function trace() {};

        return NullConsole;
    })();

    var ALWAYS = undefined;

    var Logger = (function () {
        function Logger(_ref) {
            var console = _ref.console;
            var level = _ref.level;

            this.f = ALWAYS;
            this.force = ALWAYS;
            this.console = console;
            this.level = level;
        }

        Logger.prototype.skipped = function skipped(level) {
            return level < this.level;
        };

        Logger.prototype.trace = function trace(message) {
            var _ref2 = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

            var _ref2$stackTrace = _ref2.stackTrace;
            var stackTrace = _ref2$stackTrace === undefined ? false : _ref2$stackTrace;

            if (this.skipped(LogLevel.Trace)) return;
            this.console.log(message);
            if (stackTrace) this.console.trace();
        };

        Logger.prototype.debug = function debug(message) {
            var _ref3 = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

            var _ref3$stackTrace = _ref3.stackTrace;
            var stackTrace = _ref3$stackTrace === undefined ? false : _ref3$stackTrace;

            if (this.skipped(LogLevel.Debug)) return;
            this.console.log(message);
            if (stackTrace) this.console.trace();
        };

        Logger.prototype.warn = function warn(message) {
            var _ref4 = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

            var _ref4$stackTrace = _ref4.stackTrace;
            var stackTrace = _ref4$stackTrace === undefined ? false : _ref4$stackTrace;

            if (this.skipped(LogLevel.Warn)) return;
            this.console.warn(message);
            if (stackTrace) this.console.trace();
        };

        Logger.prototype.error = function error(message) {
            if (this.skipped(LogLevel.Error)) return;
            this.console.error(message);
        };

        return Logger;
    })();

    var _console = typeof console === 'undefined' ? new NullConsole() : console;
    ALWAYS = new Logger({ console: _console, level: LogLevel.Trace });
    var LOG_LEVEL = LogLevel.Warn;
    var logger = new Logger({ console: _console, level: LOG_LEVEL });

    var objKeys = Object.keys;

    function assign(obj) {
        for (var i = 1; i < arguments.length; i++) {
            var assignment = arguments[i];
            if (assignment === null || typeof assignment !== 'object') continue;
            var keys = objKeys(assignment);
            for (var j = 0; j < keys.length; j++) {
                var key = keys[j];
                obj[key] = assignment[key];
            }
        }
        return obj;
    }
    function fillNulls(count) {
        var arr = new Array(count);
        for (var i = 0; i < count; i++) {
            arr[i] = null;
        }
        return arr;
    }

    var GUID = 0;
    function initializeGuid(object) {
        return object._guid = ++GUID;
    }
    function ensureGuid(object) {
        return object._guid || initializeGuid(object);
    }

    var proto = Object.create(null, {
        // without this, we will always still end up with (new
        // EmptyObject()).constructor === Object
        constructor: {
            value: undefined,
            enumerable: false,
            writable: true
        }
    });
    function EmptyObject() {}
    EmptyObject.prototype = proto;
    function dict() {
        // let d = Object.create(null);
        // d.x = 1;
        // delete d.x;
        // return d;
        return new EmptyObject();
    }

    var DictSet = (function () {
        function DictSet() {
            this.dict = dict();
        }

        DictSet.prototype.add = function add(obj) {
            if (typeof obj === 'string') this.dict[obj] = obj;else this.dict[ensureGuid(obj)] = obj;
            return this;
        };

        DictSet.prototype.delete = function _delete(obj) {
            if (typeof obj === 'string') delete this.dict[obj];else if (obj._guid) delete this.dict[obj._guid];
        };

        DictSet.prototype.forEach = function forEach(callback) {
            var dict = this.dict;

            Object.keys(dict).forEach(function (key) {
                return callback(dict[key]);
            });
        };

        DictSet.prototype.toArray = function toArray() {
            return Object.keys(this.dict);
        };

        return DictSet;
    })();

    var Stack = (function () {
        function Stack() {
            this.stack = [];
            this.current = null;
        }

        Stack.prototype.toArray = function toArray() {
            return this.stack;
        };

        Stack.prototype.push = function push(item) {
            this.current = item;
            this.stack.push(item);
        };

        Stack.prototype.pop = function pop() {
            var item = this.stack.pop();
            var len = this.stack.length;
            this.current = len === 0 ? null : this.stack[len - 1];
            return item === undefined ? null : item;
        };

        Stack.prototype.isEmpty = function isEmpty() {
            return this.stack.length === 0;
        };

        return Stack;
    })();

    var ListNode = function ListNode(value) {
        this.next = null;
        this.prev = null;
        this.value = value;
    };

    var LinkedList = (function () {
        function LinkedList() {
            this.clear();
        }

        LinkedList.fromSlice = function fromSlice(slice) {
            var list = new LinkedList();
            slice.forEachNode(function (n) {
                return list.append(n.clone());
            });
            return list;
        };

        LinkedList.prototype.head = function head() {
            return this._head;
        };

        LinkedList.prototype.tail = function tail() {
            return this._tail;
        };

        LinkedList.prototype.clear = function clear() {
            this._head = this._tail = null;
        };

        LinkedList.prototype.isEmpty = function isEmpty() {
            return this._head === null;
        };

        LinkedList.prototype.toArray = function toArray() {
            var out = [];
            this.forEachNode(function (n) {
                return out.push(n);
            });
            return out;
        };

        LinkedList.prototype.splice = function splice(start, end, reference) {
            var before = undefined;
            if (reference === null) {
                before = this._tail;
                this._tail = end;
            } else {
                before = reference.prev;
                end.next = reference;
                reference.prev = end;
            }
            if (before) {
                before.next = start;
                start.prev = before;
            }
        };

        LinkedList.prototype.nextNode = function nextNode(node) {
            return node.next;
        };

        LinkedList.prototype.prevNode = function prevNode(node) {
            return node.prev;
        };

        LinkedList.prototype.forEachNode = function forEachNode(callback) {
            var node = this._head;
            while (node !== null) {
                callback(node);
                node = node.next;
            }
        };

        LinkedList.prototype.contains = function contains(needle) {
            var node = this._head;
            while (node !== null) {
                if (node === needle) return true;
                node = node.next;
            }
            return false;
        };

        LinkedList.prototype.insertBefore = function insertBefore(node) {
            var reference = arguments.length <= 1 || arguments[1] === undefined ? null : arguments[1];

            if (reference === null) return this.append(node);
            if (reference.prev) reference.prev.next = node;else this._head = node;
            node.prev = reference.prev;
            node.next = reference;
            reference.prev = node;
            return node;
        };

        LinkedList.prototype.append = function append(node) {
            var tail = this._tail;
            if (tail) {
                tail.next = node;
                node.prev = tail;
                node.next = null;
            } else {
                this._head = node;
            }
            return this._tail = node;
        };

        LinkedList.prototype.pop = function pop() {
            if (this._tail) return this.remove(this._tail);
            return null;
        };

        LinkedList.prototype.prepend = function prepend(node) {
            if (this._head) return this.insertBefore(node, this._head);
            return this._head = this._tail = node;
        };

        LinkedList.prototype.remove = function remove(node) {
            if (node.prev) node.prev.next = node.next;else this._head = node.next;
            if (node.next) node.next.prev = node.prev;else this._tail = node.prev;
            return node;
        };

        return LinkedList;
    })();

    var ListSlice = (function () {
        function ListSlice(head, tail) {
            this._head = head;
            this._tail = tail;
        }

        ListSlice.toList = function toList(slice) {
            var list = new LinkedList();
            slice.forEachNode(function (n) {
                return list.append(n.clone());
            });
            return list;
        };

        ListSlice.prototype.forEachNode = function forEachNode(callback) {
            var node = this._head;
            while (node !== null) {
                callback(node);
                node = this.nextNode(node);
            }
        };

        ListSlice.prototype.contains = function contains(needle) {
            var node = this._head;
            while (node !== null) {
                if (node === needle) return true;
                node = node.next;
            }
            return false;
        };

        ListSlice.prototype.head = function head() {
            return this._head;
        };

        ListSlice.prototype.tail = function tail() {
            return this._tail;
        };

        ListSlice.prototype.toArray = function toArray() {
            var out = [];
            this.forEachNode(function (n) {
                return out.push(n);
            });
            return out;
        };

        ListSlice.prototype.nextNode = function nextNode(node) {
            if (node === this._tail) return null;
            return node.next;
        };

        ListSlice.prototype.prevNode = function prevNode(node) {
            if (node === this._head) return null;
            return node.prev;
        };

        ListSlice.prototype.isEmpty = function isEmpty() {
            return false;
        };

        return ListSlice;
    })();

    var EMPTY_SLICE = new ListSlice(null, null);

    var HAS_TYPED_ARRAYS = typeof Uint32Array !== 'undefined';
    var A = undefined;
    if (HAS_TYPED_ARRAYS) {
        A = Uint32Array;
    } else {
        A = Array;
    }
    var A$1 = A;

    var HAS_NATIVE_WEAKMAP = (function () {
        // detect if `WeakMap` is even present
        var hasWeakMap = typeof WeakMap === 'function';
        if (!hasWeakMap) {
            return false;
        }
        var instance = new WeakMap();
        // use `Object`'s `.toString` directly to prevent us from detecting
        // polyfills as native weakmaps
        return Object.prototype.toString.call(instance) === '[object WeakMap]';
    })();

    exports.getAttrNamespace = getAttrNamespace;
    exports.assert = debugAssert;
    exports.LOGGER = logger;
    exports.Logger = Logger;
    exports.LogLevel = LogLevel;
    exports.assign = assign;
    exports.fillNulls = fillNulls;
    exports.ensureGuid = ensureGuid;
    exports.initializeGuid = initializeGuid;
    exports.Stack = Stack;
    exports.DictSet = DictSet;
    exports.dict = dict;
    exports.EMPTY_SLICE = EMPTY_SLICE;
    exports.LinkedList = LinkedList;
    exports.ListNode = ListNode;
    exports.ListSlice = ListSlice;
    exports.A = A$1;
    exports.HAS_NATIVE_WEAKMAP = HAS_NATIVE_WEAKMAP;
    exports.unwrap = unwrap;
    exports.expect = expect;
    exports.unreachable = unreachable;
});
enifed("@glimmer/wire-format", ["exports"], function (exports) {
    "use strict";

    var Opcodes;
    (function (Opcodes) {
        // Statements
        Opcodes[Opcodes["Text"] = 0] = "Text";
        Opcodes[Opcodes["Append"] = 1] = "Append";
        Opcodes[Opcodes["UnoptimizedAppend"] = 2] = "UnoptimizedAppend";
        Opcodes[Opcodes["OptimizedAppend"] = 3] = "OptimizedAppend";
        Opcodes[Opcodes["Comment"] = 4] = "Comment";
        Opcodes[Opcodes["Modifier"] = 5] = "Modifier";
        Opcodes[Opcodes["Block"] = 6] = "Block";
        Opcodes[Opcodes["ScannedBlock"] = 7] = "ScannedBlock";
        Opcodes[Opcodes["NestedBlock"] = 8] = "NestedBlock";
        Opcodes[Opcodes["Component"] = 9] = "Component";
        Opcodes[Opcodes["ScannedComponent"] = 10] = "ScannedComponent";
        Opcodes[Opcodes["OpenElement"] = 11] = "OpenElement";
        Opcodes[Opcodes["OpenPrimitiveElement"] = 12] = "OpenPrimitiveElement";
        Opcodes[Opcodes["FlushElement"] = 13] = "FlushElement";
        Opcodes[Opcodes["CloseElement"] = 14] = "CloseElement";
        Opcodes[Opcodes["StaticAttr"] = 15] = "StaticAttr";
        Opcodes[Opcodes["DynamicAttr"] = 16] = "DynamicAttr";
        Opcodes[Opcodes["AnyDynamicAttr"] = 17] = "AnyDynamicAttr";
        Opcodes[Opcodes["Yield"] = 18] = "Yield";
        Opcodes[Opcodes["Partial"] = 19] = "Partial";
        Opcodes[Opcodes["StaticPartial"] = 20] = "StaticPartial";
        Opcodes[Opcodes["DynamicPartial"] = 21] = "DynamicPartial";
        Opcodes[Opcodes["DynamicArg"] = 22] = "DynamicArg";
        Opcodes[Opcodes["StaticArg"] = 23] = "StaticArg";
        Opcodes[Opcodes["TrustingAttr"] = 24] = "TrustingAttr";
        Opcodes[Opcodes["Debugger"] = 25] = "Debugger";
        // Expressions
        Opcodes[Opcodes["Unknown"] = 26] = "Unknown";
        Opcodes[Opcodes["Arg"] = 27] = "Arg";
        Opcodes[Opcodes["Get"] = 28] = "Get";
        Opcodes[Opcodes["HasBlock"] = 29] = "HasBlock";
        Opcodes[Opcodes["HasBlockParams"] = 30] = "HasBlockParams";
        Opcodes[Opcodes["Undefined"] = 31] = "Undefined";
        Opcodes[Opcodes["Function"] = 32] = "Function";
        Opcodes[Opcodes["Helper"] = 33] = "Helper";
        Opcodes[Opcodes["Concat"] = 34] = "Concat";
    })(Opcodes || (exports.Ops = Opcodes = {}));

    function is(variant) {
        return function (value) {
            return value[0] === variant;
        };
    }
    var Expressions;
    (function (Expressions) {
        Expressions.isUnknown = is(Opcodes.Unknown);
        Expressions.isArg = is(Opcodes.Arg);
        Expressions.isGet = is(Opcodes.Get);
        Expressions.isConcat = is(Opcodes.Concat);
        Expressions.isHelper = is(Opcodes.Helper);
        Expressions.isHasBlock = is(Opcodes.HasBlock);
        Expressions.isHasBlockParams = is(Opcodes.HasBlockParams);
        Expressions.isUndefined = is(Opcodes.Undefined);
        function isPrimitiveValue(value) {
            if (value === null) {
                return true;
            }
            return typeof value !== 'object';
        }
        Expressions.isPrimitiveValue = isPrimitiveValue;
    })(Expressions || (exports.Expressions = Expressions = {}));
    var Statements;
    (function (Statements) {
        Statements.isText = is(Opcodes.Text);
        Statements.isAppend = is(Opcodes.Append);
        Statements.isComment = is(Opcodes.Comment);
        Statements.isModifier = is(Opcodes.Modifier);
        Statements.isBlock = is(Opcodes.Block);
        Statements.isComponent = is(Opcodes.Component);
        Statements.isOpenElement = is(Opcodes.OpenElement);
        Statements.isFlushElement = is(Opcodes.FlushElement);
        Statements.isCloseElement = is(Opcodes.CloseElement);
        Statements.isStaticAttr = is(Opcodes.StaticAttr);
        Statements.isDynamicAttr = is(Opcodes.DynamicAttr);
        Statements.isYield = is(Opcodes.Yield);
        Statements.isPartial = is(Opcodes.Partial);
        Statements.isDynamicArg = is(Opcodes.DynamicArg);
        Statements.isStaticArg = is(Opcodes.StaticArg);
        Statements.isTrustingAttr = is(Opcodes.TrustingAttr);
        Statements.isDebugger = is(Opcodes.Debugger);
        function isAttribute(val) {
            return val[0] === Opcodes.StaticAttr || val[0] === Opcodes.DynamicAttr;
        }
        Statements.isAttribute = isAttribute;
        function isArgument(val) {
            return val[0] === Opcodes.StaticArg || val[0] === Opcodes.DynamicArg;
        }
        Statements.isArgument = isArgument;
        function isParameter(val) {
            return isAttribute(val) || isArgument(val);
        }
        Statements.isParameter = isParameter;
        function getParameterName(s) {
            return s[1];
        }
        Statements.getParameterName = getParameterName;
    })(Statements || (exports.Statements = Statements = {}));

    exports.is = is;
    exports.Expressions = Expressions;
    exports.Statements = Statements;
    exports.Ops = Opcodes;
});
enifed('backburner', ['exports'], function (exports) { 'use strict';

var NUMBER = /\d+/;

function each(collection, callback) {
  for (var i = 0; i < collection.length; i++) {
    callback(collection[i]);
  }
}

function isString(suspect) {
  return typeof suspect === 'string';
}

function isFunction(suspect) {
  return typeof suspect === 'function';
}

function isNumber(suspect) {
  return typeof suspect === 'number';
}

function isCoercableNumber(number) {
  return isNumber(number) || NUMBER.test(number);
}

function binarySearch(time, timers) {
  var start = 0;
  var end = timers.length - 2;
  var middle, l;

  while (start < end) {
    // since timers is an array of pairs 'l' will always
    // be an integer
    l = (end - start) / 2;

    // compensate for the index in case even number
    // of pairs inside timers
    middle = start + l - (l % 2);

    if (time >= timers[middle]) {
      start = middle + 2;
    } else {
      end = middle;
    }
  }

  return (time >= timers[start]) ? start + 2 : start;
}

function Queue(name, options, globalOptions) {
  this.name = name;
  this.globalOptions = globalOptions || {};
  this.options = options;
  this._queue = [];
  this.targetQueues = {};
  this._queueBeingFlushed = undefined;
}

Queue.prototype = {
  push: function(target, method, args, stack) {
    var queue = this._queue;
    queue.push(target, method, args, stack);

    return {
      queue: this,
      target: target,
      method: method
    };
  },

  pushUniqueWithoutGuid: function(target, method, args, stack) {
    var queue = this._queue;

    for (var i = 0, l = queue.length; i < l; i += 4) {
      var currentTarget = queue[i];
      var currentMethod = queue[i+1];

      if (currentTarget === target && currentMethod === method) {
        queue[i+2] = args;  // replace args
        queue[i+3] = stack; // replace stack
        return;
      }
    }

    queue.push(target, method, args, stack);
  },

  targetQueue: function(targetQueue, target, method, args, stack) {
    var queue = this._queue;

    for (var i = 0, l = targetQueue.length; i < l; i += 2) {
      var currentMethod = targetQueue[i];
      var currentIndex  = targetQueue[i + 1];

      if (currentMethod === method) {
        queue[currentIndex + 2] = args;  // replace args
        queue[currentIndex + 3] = stack; // replace stack
        return;
      }
    }

    targetQueue.push(
      method,
      queue.push(target, method, args, stack) - 4
    );
  },

  pushUniqueWithGuid: function(guid, target, method, args, stack) {
    var hasLocalQueue = this.targetQueues[guid];

    if (hasLocalQueue) {
      this.targetQueue(hasLocalQueue, target, method, args, stack);
    } else {
      this.targetQueues[guid] = [
        method,
        this._queue.push(target, method, args, stack) - 4
      ];
    }

    return {
      queue: this,
      target: target,
      method: method
    };
  },

  pushUnique: function(target, method, args, stack) {
    var KEY = this.globalOptions.GUID_KEY;

    if (target && KEY) {
      var guid = target[KEY];
      if (guid) {
        return this.pushUniqueWithGuid(guid, target, method, args, stack);
      }
    }

    this.pushUniqueWithoutGuid(target, method, args, stack);

    return {
      queue: this,
      target: target,
      method: method
    };
  },

  invoke: function(target, method, args /*, onError, errorRecordedForStack */) {
    if (args && args.length > 0) {
      method.apply(target, args);
    } else {
      method.call(target);
    }
  },

  invokeWithOnError: function(target, method, args, onError, errorRecordedForStack) {
    try {
      if (args && args.length > 0) {
        method.apply(target, args);
      } else {
        method.call(target);
      }
    } catch(error) {
      onError(error, errorRecordedForStack);
    }
  },

  flush: function(sync) {
    var queue = this._queue;
    var length = queue.length;

    if (length === 0) {
      return;
    }

    var globalOptions = this.globalOptions;
    var options = this.options;
    var before = options && options.before;
    var after = options && options.after;
    var onError = globalOptions.onError || (globalOptions.onErrorTarget &&
                                            globalOptions.onErrorTarget[globalOptions.onErrorMethod]);
    var target, method, args, errorRecordedForStack;
    var invoke = onError ? this.invokeWithOnError : this.invoke;

    this.targetQueues = Object.create(null);
    var queueItems = this._queueBeingFlushed = this._queue.slice();
    this._queue = [];

    if (before) {
      before();
    }

    for (var i = 0; i < length; i += 4) {
      target                = queueItems[i];
      method                = queueItems[i+1];
      args                  = queueItems[i+2];
      errorRecordedForStack = queueItems[i+3]; // Debugging assistance

      if (isString(method)) {
        method = target[method];
      }

      // method could have been nullified / canceled during flush
      if (method) {
        //
        //    ** Attention intrepid developer **
        //
        //    To find out the stack of this task when it was scheduled onto
        //    the run loop, add the following to your app.js:
        //
        //    Ember.run.backburner.DEBUG = true; // NOTE: This slows your app, don't leave it on in production.
        //
        //    Once that is in place, when you are at a breakpoint and navigate
        //    here in the stack explorer, you can look at `errorRecordedForStack.stack`,
        //    which will be the captured stack when this job was scheduled.
        //
        //    One possible long-term solution is the following Chrome issue:
        //       https://bugs.chromium.org/p/chromium/issues/detail?id=332624
        //
        invoke(target, method, args, onError, errorRecordedForStack);
      }
    }

    if (after) {
      after();
    }

    this._queueBeingFlushed = undefined;

    if (sync !== false &&
        this._queue.length > 0) {
      // check if new items have been added
      this.flush(true);
    }
  },

  cancel: function(actionToCancel) {
    var queue = this._queue, currentTarget, currentMethod, i, l;
    var target = actionToCancel.target;
    var method = actionToCancel.method;
    var GUID_KEY = this.globalOptions.GUID_KEY;

    if (GUID_KEY && this.targetQueues && target) {
      var targetQueue = this.targetQueues[target[GUID_KEY]];

      if (targetQueue) {
        for (i = 0, l = targetQueue.length; i < l; i++) {
          if (targetQueue[i] === method) {
            targetQueue.splice(i, 1);
          }
        }
      }
    }

    for (i = 0, l = queue.length; i < l; i += 4) {
      currentTarget = queue[i];
      currentMethod = queue[i+1];

      if (currentTarget === target &&
          currentMethod === method) {
        queue.splice(i, 4);
        return true;
      }
    }

    // if not found in current queue
    // could be in the queue that is being flushed
    queue = this._queueBeingFlushed;

    if (!queue) {
      return;
    }

    for (i = 0, l = queue.length; i < l; i += 4) {
      currentTarget = queue[i];
      currentMethod = queue[i+1];

      if (currentTarget === target &&
          currentMethod === method) {
        // don't mess with array during flush
        // just nullify the method
        queue[i+1] = null;
        return true;
      }
    }
  }
};

function DeferredActionQueues(queueNames, options) {
  var queues = this.queues = {};
  this.queueNames = queueNames = queueNames || [];

  this.options = options;

  each(queueNames, function(queueName) {
    queues[queueName] = new Queue(queueName, options[queueName], options);
  });
}

function noSuchQueue(name) {
  throw new Error('You attempted to schedule an action in a queue (' + name + ') that doesn\'t exist');
}

function noSuchMethod(name) {
  throw new Error('You attempted to schedule an action in a queue (' + name + ') for a method that doesn\'t exist');
}

DeferredActionQueues.prototype = {
  schedule: function(name, target, method, args, onceFlag, stack) {
    var queues = this.queues;
    var queue = queues[name];

    if (!queue) {
      noSuchQueue(name);
    }

    if (!method) {
      noSuchMethod(name);
    }

    if (onceFlag) {
      return queue.pushUnique(target, method, args, stack);
    } else {
      return queue.push(target, method, args, stack);
    }
  },

  flush: function() {
    var queues = this.queues;
    var queueNames = this.queueNames;
    var queueName, queue;
    var queueNameIndex = 0;
    var numberOfQueues = queueNames.length;

    while (queueNameIndex < numberOfQueues) {
      queueName = queueNames[queueNameIndex];
      queue = queues[queueName];

      var numberOfQueueItems = queue._queue.length;

      if (numberOfQueueItems === 0) {
        queueNameIndex++;
      } else {
        queue.flush(false /* async */);
        queueNameIndex = 0;
      }
    }
  }
};

function Backburner(queueNames, options) {
  this.queueNames = queueNames;
  this.options = options || {};
  if (!this.options.defaultQueue) {
    this.options.defaultQueue = queueNames[0];
  }
  this.instanceStack = [];
  this._debouncees = [];
  this._throttlers = [];
  this._eventCallbacks = {
    end: [],
    begin: []
  };

  var _this = this;
  this._boundClearItems = function() {
    clearItems();
  };

  this._timerTimeoutId = undefined;
  this._timers = [];

  this._platform = this.options._platform || {
    setTimeout: function (fn, ms) {
      return setTimeout(fn, ms);
    },
    clearTimeout: function (id) {
      clearTimeout(id);
    }
  };

  this._boundRunExpiredTimers = function () {
    _this._runExpiredTimers();
  };
}

Backburner.prototype = {
  begin: function() {
    var options = this.options;
    var onBegin = options && options.onBegin;
    var previousInstance = this.currentInstance;

    if (previousInstance) {
      this.instanceStack.push(previousInstance);
    }

    this.currentInstance = new DeferredActionQueues(this.queueNames, options);
    this._trigger('begin', this.currentInstance, previousInstance);
    if (onBegin) {
      onBegin(this.currentInstance, previousInstance);
    }
  },

  end: function() {
    var options = this.options;
    var onEnd = options && options.onEnd;
    var currentInstance = this.currentInstance;
    var nextInstance = null;

    // Prevent double-finally bug in Safari 6.0.2 and iOS 6
    // This bug appears to be resolved in Safari 6.0.5 and iOS 7
    var finallyAlreadyCalled = false;
    try {
      currentInstance.flush();
    } finally {
      if (!finallyAlreadyCalled) {
        finallyAlreadyCalled = true;

        this.currentInstance = null;

        if (this.instanceStack.length) {
          nextInstance = this.instanceStack.pop();
          this.currentInstance = nextInstance;
        }
        this._trigger('end', currentInstance, nextInstance);
        if (onEnd) {
          onEnd(currentInstance, nextInstance);
        }
      }
    }
  },

  /**
   Trigger an event. Supports up to two arguments. Designed around
   triggering transition events from one run loop instance to the
   next, which requires an argument for the first instance and then
   an argument for the next instance.

   @private
   @method _trigger
   @param {String} eventName
   @param {any} arg1
   @param {any} arg2
   */
  _trigger: function(eventName, arg1, arg2) {
    var callbacks = this._eventCallbacks[eventName];
    if (callbacks) {
      for (var i = 0; i < callbacks.length; i++) {
        callbacks[i](arg1, arg2);
      }
    }
  },

  on: function(eventName, callback) {
    if (typeof callback !== 'function') {
      throw new TypeError('Callback must be a function');
    }
    var callbacks = this._eventCallbacks[eventName];
    if (callbacks) {
      callbacks.push(callback);
    } else {
      throw new TypeError('Cannot on() event "' + eventName + '" because it does not exist');
    }
  },

  off: function(eventName, callback) {
    if (eventName) {
      var callbacks = this._eventCallbacks[eventName];
      var callbackFound = false;
      if (!callbacks) return;
      if (callback) {
        for (var i = 0; i < callbacks.length; i++) {
          if (callbacks[i] === callback) {
            callbackFound = true;
            callbacks.splice(i, 1);
            i--;
          }
        }
      }
      if (!callbackFound) {
        throw new TypeError('Cannot off() callback that does not exist');
      }
    } else {
      throw new TypeError('Cannot off() event "' + eventName + '" because it does not exist');
    }
  },

  run: function(/* target, method, args */) {
    var length = arguments.length;
    var method, target, args;

    if (length === 1) {
      method = arguments[0];
      target = null;
    } else {
      target = arguments[0];
      method = arguments[1];
    }

    if (isString(method)) {
      method = target[method];
    }

    if (length > 2) {
      args = new Array(length - 2);
      for (var i = 0, l = length - 2; i < l; i++) {
        args[i] = arguments[i + 2];
      }
    } else {
      args = [];
    }

    var onError = getOnError(this.options);

    this.begin();

    // guard against Safari 6's double-finally bug
    var didFinally = false;

    if (onError) {
      try {
        return method.apply(target, args);
      } catch(error) {
        onError(error);
      } finally {
        if (!didFinally) {
          didFinally = true;
          this.end();
        }
      }
    } else {
      try {
        return method.apply(target, args);
      } finally {
        if (!didFinally) {
          didFinally = true;
          this.end();
        }
      }
    }
  },

  /*
    Join the passed method with an existing queue and execute immediately,
    if there isn't one use `Backburner#run`.

    The join method is like the run method except that it will schedule into
    an existing queue if one already exists. In either case, the join method will
    immediately execute the passed in function and return its result.

    @method join
    @param {Object} target
    @param {Function} method The method to be executed
    @param {any} args The method arguments
    @return method result
  */
  join: function(/* target, method, args */) {
    if (!this.currentInstance) {
      return this.run.apply(this, arguments);
    }

    var length = arguments.length;
    var method, target;

    if (length === 1) {
      method = arguments[0];
      target = null;
    } else {
      target = arguments[0];
      method = arguments[1];
    }

    if (isString(method)) {
      method = target[method];
    }

    if (length === 1) {
      return method();
    } else if (length === 2) {
      return method.call(target);
    } else {
      var args = new Array(length - 2);
      for (var i = 0, l = length - 2; i < l; i++) {
        args[i] = arguments[i + 2];
      }
      return method.apply(target, args);
    }
  },


  /*
    Defer the passed function to run inside the specified queue.

    @method defer
    @param {String} queueName
    @param {Object} target
    @param {Function|String} method The method or method name to be executed
    @param {any} args The method arguments
    @return method result
  */
  defer: function(queueName /* , target, method, args */) {
    var length = arguments.length;
    var method, target, args;

    if (length === 2) {
      method = arguments[1];
      target = null;
    } else {
      target = arguments[1];
      method = arguments[2];
    }

    if (isString(method)) {
      method = target[method];
    }

    var stack = this.DEBUG ? new Error() : undefined;

    if (length > 3) {
      args = new Array(length - 3);
      for (var i = 3; i < length; i++) {
        args[i-3] = arguments[i];
      }
    } else {
      args = undefined;
    }

    if (!this.currentInstance) { createAutorun(this); }
    return this.currentInstance.schedule(queueName, target, method, args, false, stack);
  },

  deferOnce: function(queueName /* , target, method, args */) {
    var length = arguments.length;
    var method, target, args;

    if (length === 2) {
      method = arguments[1];
      target = null;
    } else {
      target = arguments[1];
      method = arguments[2];
    }

    if (isString(method)) {
      method = target[method];
    }

    var stack = this.DEBUG ? new Error() : undefined;

    if (length > 3) {
      args = new Array(length - 3);
      for (var i = 3; i < length; i++) {
        args[i-3] = arguments[i];
      }
    } else {
      args = undefined;
    }

    if (!this.currentInstance) {
      createAutorun(this);
    }
    return this.currentInstance.schedule(queueName, target, method, args, true, stack);
  },

  setTimeout: function() {
    var l = arguments.length;
    var args = new Array(l);

    for (var x = 0; x < l; x++) {
      args[x] = arguments[x];
    }

    var length = args.length,
        method, wait, target,
        methodOrTarget, methodOrWait, methodOrArgs;

    if (length === 0) {
      return;
    } else if (length === 1) {
      method = args.shift();
      wait = 0;
    } else if (length === 2) {
      methodOrTarget = args[0];
      methodOrWait = args[1];

      if (isFunction(methodOrWait) || isFunction(methodOrTarget[methodOrWait])) {
        target = args.shift();
        method = args.shift();
        wait = 0;
      } else if (isCoercableNumber(methodOrWait)) {
        method = args.shift();
        wait = args.shift();
      } else {
        method = args.shift();
        wait =  0;
      }
    } else {
      var last = args[args.length - 1];

      if (isCoercableNumber(last)) {
        wait = args.pop();
      } else {
        wait = 0;
      }

      methodOrTarget = args[0];
      methodOrArgs = args[1];

      if (isFunction(methodOrArgs) || (isString(methodOrArgs) &&
                                      methodOrTarget !== null &&
                                      methodOrArgs in methodOrTarget)) {
        target = args.shift();
        method = args.shift();
      } else {
        method = args.shift();
      }
    }

    var executeAt = Date.now() + parseInt(wait !== wait ? 0 : wait, 10);

    if (isString(method)) {
      method = target[method];
    }

    var onError = getOnError(this.options);

    function fn() {
      if (onError) {
        try {
          method.apply(target, args);
        } catch (e) {
          onError(e);
        }
      } else {
        method.apply(target, args);
      }
    }

    return this._setTimeout(fn, executeAt);
  },

  _setTimeout: function (fn, executeAt) {
    if (this._timers.length === 0) {
      this._timers.push(executeAt, fn);
      this._installTimerTimeout();
      return fn;
    }

    // find position to insert
    var i = binarySearch(executeAt, this._timers);

    this._timers.splice(i, 0, executeAt, fn);

    // we should be the new earliest timer if i == 0
    if (i === 0) {
      this._reinstallTimerTimeout();
    }

    return fn;
  },

  throttle: function(target, method /* , args, wait, [immediate] */) {
    var backburner = this;
    var args = new Array(arguments.length);
    for (var i = 0; i < arguments.length; i++) {
      args[i] = arguments[i];
    }
    var immediate = args.pop();
    var wait, throttler, index, timer;

    if (isNumber(immediate) || isString(immediate)) {
      wait = immediate;
      immediate = true;
    } else {
      wait = args.pop();
    }

    wait = parseInt(wait, 10);

    index = findThrottler(target, method, this._throttlers);
    if (index > -1) { return this._throttlers[index]; } // throttled

    timer = this._platform.setTimeout(function() {
      if (!immediate) {
        backburner.run.apply(backburner, args);
      }
      var index = findThrottler(target, method, backburner._throttlers);
      if (index > -1) {
        backburner._throttlers.splice(index, 1);
      }
    }, wait);

    if (immediate) {
      this.run.apply(this, args);
    }

    throttler = [target, method, timer];

    this._throttlers.push(throttler);

    return throttler;
  },

  debounce: function(target, method /* , args, wait, [immediate] */) {
    var backburner = this;
    var args = new Array(arguments.length);
    for (var i = 0; i < arguments.length; i++) {
      args[i] = arguments[i];
    }

    var immediate = args.pop();
    var wait, index, debouncee, timer;

    if (isNumber(immediate) || isString(immediate)) {
      wait = immediate;
      immediate = false;
    } else {
      wait = args.pop();
    }

    wait = parseInt(wait, 10);
    // Remove debouncee
    index = findDebouncee(target, method, this._debouncees);

    if (index > -1) {
      debouncee = this._debouncees[index];
      this._debouncees.splice(index, 1);
      this._platform.clearTimeout(debouncee[2]);
    }

    timer = this._platform.setTimeout(function() {
      if (!immediate) {
        backburner.run.apply(backburner, args);
      }
      var index = findDebouncee(target, method, backburner._debouncees);
      if (index > -1) {
        backburner._debouncees.splice(index, 1);
      }
    }, wait);

    if (immediate && index === -1) {
      backburner.run.apply(backburner, args);
    }

    debouncee = [
      target,
      method,
      timer
    ];

    backburner._debouncees.push(debouncee);

    return debouncee;
  },

  cancelTimers: function() {
    each(this._throttlers, this._boundClearItems);
    this._throttlers = [];

    each(this._debouncees, this._boundClearItems);
    this._debouncees = [];

    this._clearTimerTimeout();
    this._timers = [];

    if (this._autorun) {
      this._platform.clearTimeout(this._autorun);
      this._autorun = null;
    }
  },

  hasTimers: function() {
    return !!this._timers.length || !!this._debouncees.length || !!this._throttlers.length || this._autorun;
  },

  cancel: function (timer) {
    var timerType = typeof timer;

    if (timer && timerType === 'object' && timer.queue && timer.method) { // we're cancelling a deferOnce
      return timer.queue.cancel(timer);
    } else if (timerType === 'function') { // we're cancelling a setTimeout
      for (var i = 0, l = this._timers.length; i < l; i += 2) {
        if (this._timers[i + 1] === timer) {
          this._timers.splice(i, 2); // remove the two elements
          if (i === 0) {
            this._reinstallTimerTimeout();
          }
          return true;
        }
      }
    } else if (Object.prototype.toString.call(timer) === '[object Array]'){ // we're cancelling a throttle or debounce
      return this._cancelItem(findThrottler, this._throttlers, timer) ||
               this._cancelItem(findDebouncee, this._debouncees, timer);
    } else {
      return; // timer was null or not a timer
    }
  },

  _cancelItem: function(findMethod, array, timer){
    var item, index;

    if (timer.length < 3) { return false; }

    index = findMethod(timer[0], timer[1], array);

    if (index > -1) {

      item = array[index];

      if (item[2] === timer[2]) {
        array.splice(index, 1);
        this._platform.clearTimeout(timer[2]);
        return true;
      }
    }

    return false;
  },

  _runExpiredTimers: function () {
    this._timerTimeoutId = undefined;
    this.run(this, this._scheduleExpiredTimers);
  },

  _scheduleExpiredTimers: function () {
    var n = Date.now();
    var timers = this._timers;
    var i = 0;
    var l = timers.length;
    for (; i < l; i += 2) {
      var executeAt = timers[i];
      var fn = timers[i+1];
      if (executeAt <= n) {
        this.schedule(this.options.defaultQueue, null, fn);
      } else {
        break;
      }
    }
    timers.splice(0, i);
    this._installTimerTimeout();
  },

  _reinstallTimerTimeout: function () {
    this._clearTimerTimeout();
    this._installTimerTimeout();
  },

  _clearTimerTimeout: function () {
    if (!this._timerTimeoutId) {
      return;
    }
    this._platform.clearTimeout(this._timerTimeoutId);
    this._timerTimeoutId = undefined;
  },

  _installTimerTimeout: function () {
    if (!this._timers.length) {
      return;
    }
    var minExpiresAt = this._timers[0];
    var n = Date.now();
    var wait = Math.max(0, minExpiresAt - n);
    this._timerTimeoutId = this._platform.setTimeout(this._boundRunExpiredTimers, wait);
  }
};

Backburner.prototype.schedule = Backburner.prototype.defer;
Backburner.prototype.scheduleOnce = Backburner.prototype.deferOnce;
Backburner.prototype.later = Backburner.prototype.setTimeout;

function getOnError(options) {
  return options.onError || (options.onErrorTarget && options.onErrorTarget[options.onErrorMethod]);
}

function createAutorun(backburner) {
  var setTimeout = backburner._platform.setTimeout;
  backburner.begin();
  backburner._autorun = setTimeout(function() {
    backburner._autorun = null;
    backburner.end();
  }, 0);
}

function findDebouncee(target, method, debouncees) {
  return findItem(target, method, debouncees);
}

function findThrottler(target, method, throttlers) {
  return findItem(target, method, throttlers);
}

function findItem(target, method, collection) {
  var item;
  var index = -1;

  for (var i = 0, l = collection.length; i < l; i++) {
    item = collection[i];
    if (item[0] === target && item[1] === method) {
      index = i;
      break;
    }
  }

  return index;
}

function clearItems(item) {
  this._platform.clearTimeout(item[2]);
}

exports['default'] = Backburner;

Object.defineProperty(exports, '__esModule', { value: true });

});
enifed('container/container', ['exports', 'ember-debug', 'ember-utils', 'ember-environment'], function (exports, _emberDebug, _emberUtils, _emberEnvironment) {
  'use strict';

  var _Container$prototype;

  exports.default = Container;
  exports.buildFakeContainerWithDeprecations = buildFakeContainerWithDeprecations;

  var CONTAINER_OVERRIDE = _emberUtils.symbol('CONTAINER_OVERRIDE');
  var FACTORY_FOR = _emberUtils.symbol('FACTORY_FOR');
  exports.FACTORY_FOR = FACTORY_FOR;
  var LOOKUP_FACTORY = _emberUtils.symbol('LOOKUP_FACTORY');

  exports.LOOKUP_FACTORY = LOOKUP_FACTORY;
  /**
   A container used to instantiate and cache objects.
  
   Every `Container` must be associated with a `Registry`, which is referenced
   to determine the factory and options that should be used to instantiate
   objects.
  
   The public API for `Container` is still in flux and should not be considered
   stable.
  
   @private
   @class Container
   */

  function Container(registry, options) {
    this.registry = registry;
    this.owner = options && options.owner ? options.owner : null;
    this.cache = _emberUtils.dictionary(options && options.cache ? options.cache : null);
    this.factoryCache = _emberUtils.dictionary(options && options.factoryCache ? options.factoryCache : null);
    this.factoryManagerCache = _emberUtils.dictionary(options && options.factoryManagerCache ? options.factoryManagerCache : null);
    this.validationCache = _emberUtils.dictionary(options && options.validationCache ? options.validationCache : null);
    this._fakeContainerToInject = buildFakeContainerWithDeprecations(this);
    this[CONTAINER_OVERRIDE] = undefined;
    this.isDestroyed = false;
  }

  Container.prototype = (_Container$prototype = {
    /**
     @private
     @property owner
     @type Object
     */
    owner: null,

    /**
     @private
     @property registry
     @type Registry
     @since 1.11.0
     */
    registry: null,

    /**
     @private
     @property cache
     @type InheritingDict
     */
    cache: null,

    /**
     @private
     @property factoryCache
     @type InheritingDict
     */
    factoryCache: null,

    /**
     @private
     @property validationCache
     @type InheritingDict
     */
    validationCache: null,

    /**
     Given a fullName return a corresponding instance.
      The default behaviour is for lookup to return a singleton instance.
     The singleton is scoped to the container, allowing multiple containers
     to all have their own locally scoped singletons.
      ```javascript
     let registry = new Registry();
     let container = registry.container();
      registry.register('api:twitter', Twitter);
      let twitter = container.lookup('api:twitter');
      twitter instanceof Twitter; // => true
      // by default the container will return singletons
     let twitter2 = container.lookup('api:twitter');
     twitter2 instanceof Twitter; // => true
      twitter === twitter2; //=> true
     ```
      If singletons are not wanted, an optional flag can be provided at lookup.
      ```javascript
     let registry = new Registry();
     let container = registry.container();
      registry.register('api:twitter', Twitter);
      let twitter = container.lookup('api:twitter', { singleton: false });
     let twitter2 = container.lookup('api:twitter', { singleton: false });
      twitter === twitter2; //=> false
     ```
      @private
     @method lookup
     @param {String} fullName
     @param {Object} [options]
     @param {String} [options.source] The fullname of the request source (used for local lookup)
     @return {any}
     */
    lookup: function (fullName, options) {
      _emberDebug.assert('fullName must be a proper full name', this.registry.validateFullName(fullName));
      return lookup(this, this.registry.normalize(fullName), options);
    },

    /**
     Given a fullName, return the corresponding factory.
      @private
     @method lookupFactory
     @param {String} fullName
     @param {Object} [options]
     @param {String} [options.source] The fullname of the request source (used for local lookup)
     @return {any}
     */
    lookupFactory: function (fullName, options) {
      _emberDebug.assert('fullName must be a proper full name', this.registry.validateFullName(fullName));

      _emberDebug.deprecate('Using "_lookupFactory" is deprecated. Please use container.factoryFor instead.', !true, { id: 'container-lookupFactory', until: '2.13.0', url: 'http://emberjs.com/deprecations/v2.x/#toc_migrating-from-_lookupfactory-to-factoryfor' });

      return deprecatedFactoryFor(this, this.registry.normalize(fullName), options);
    }

  }, _Container$prototype[LOOKUP_FACTORY] = function (fullName, options) {
    _emberDebug.assert('fullName must be a proper full name', this.registry.validateFullName(fullName));
    return deprecatedFactoryFor(this, this.registry.normalize(fullName), options);
  }, _Container$prototype[FACTORY_FOR] = function (fullName) {
    var options = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

    if (true) {
      if (true) {
        return this.factoryFor(fullName, options);
      } else {
        /* This throws in case of a poorly designed build */
        throw new Error('If ember-no-double-extend is enabled, ember-factory-for must also be enabled');
      }
    }
    var factory = this[LOOKUP_FACTORY](fullName, options);
    if (factory === undefined) {
      return;
    }
    var manager = new DeprecatedFactoryManager(this, factory, fullName);

    _emberDebug.runInDebug(function () {
      manager = wrapManagerInDeprecationProxy(manager);
    });

    return manager;
  }, _Container$prototype.destroy = function () {
    destroyDestroyables(this);
    this.isDestroyed = true;
  }, _Container$prototype.reset = function (fullName) {
    if (arguments.length > 0) {
      resetMember(this, this.registry.normalize(fullName));
    } else {
      resetCache(this);
    }
  }, _Container$prototype.ownerInjection = function () {
    var _ref;

    return _ref = {}, _ref[_emberUtils.OWNER] = this.owner, _ref;
  }, _Container$prototype);

  /*
   * Wrap a factory manager in a proxy which will not permit properties to be
   * set on the manager.
   */
  function wrapManagerInDeprecationProxy(manager) {
    if (_emberUtils.HAS_NATIVE_PROXY) {
      var _ret = (function () {
        var validator = {
          get: function (obj, prop) {
            if (prop !== 'class' && prop !== 'create') {
              throw new Error('You attempted to access "' + prop + '" on a factory manager created by container#factoryFor. "' + prop + '" is not a member of a factory manager."');
            }

            return obj[prop];
          },
          set: function (obj, prop, value) {
            throw new Error('You attempted to set "' + prop + '" on a factory manager created by container#factoryFor. A factory manager is a read-only construct.');
          }
        };

        // Note:
        // We have to proxy access to the manager here so that private property
        // access doesn't cause the above errors to occur.
        var m = manager;
        var proxiedManager = {
          class: m.class,
          create: function (props) {
            return m.create(props);
          }
        };

        return {
          v: new Proxy(proxiedManager, validator)
        };
      })();

      if (typeof _ret === 'object') return _ret.v;
    }

    return manager;
  }

  if (true) {
    /**
     Given a fullName, return the corresponding factory. The consumer of the factory
     is responsible for the destruction of any factory instances, as there is no
     way for the container to ensure instances are destroyed when it itself is
     destroyed.
      @public
     @method factoryFor
     @param {String} fullName
     @param {Object} [options]
     @param {String} [options.source] The fullname of the request source (used for local lookup)
     @return {any}
     */
    Container.prototype.factoryFor = function _factoryFor(fullName) {
      var options = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

      var normalizedName = this.registry.normalize(fullName);

      _emberDebug.assert('fullName must be a proper full name', this.registry.validateFullName(normalizedName));

      if (options.source) {
        normalizedName = this.registry.expandLocalLookup(fullName, options);
        // if expandLocalLookup returns falsey, we do not support local lookup
        if (!normalizedName) {
          return;
        }
      }

      var cached = this.factoryManagerCache[normalizedName];

      if (cached) {
        return cached;
      }

      var factory = this.registry.resolve(normalizedName);

      if (factory === undefined) {
        return;
      }

      var manager = new FactoryManager(this, factory, fullName, normalizedName);

      _emberDebug.runInDebug(function () {
        manager = wrapManagerInDeprecationProxy(manager);
      });

      this.factoryManagerCache[normalizedName] = manager;
      return manager;
    };
  }

  function isSingleton(container, fullName) {
    return container.registry.getOption(fullName, 'singleton') !== false;
  }

  function isInstantiatable(container, fullName) {
    return container.registry.getOption(fullName, 'instantiate') !== false;
  }

  function lookup(container, fullName) {
    var options = arguments.length <= 2 || arguments[2] === undefined ? {} : arguments[2];

    if (options.source) {
      fullName = container.registry.expandLocalLookup(fullName, options);

      // if expandLocalLookup returns falsey, we do not support local lookup
      if (!fullName) {
        return;
      }
    }

    if (container.cache[fullName] !== undefined && options.singleton !== false) {
      return container.cache[fullName];
    }

    if (true) {
      return instantiateFactory(container, fullName, options);
    } else {
      var factory = deprecatedFactoryFor(container, fullName);
      var value = instantiate(factory, {}, container, fullName);

      if (value === undefined) {
        return;
      }

      if (isSingleton(container, fullName) && options.singleton !== false) {
        container.cache[fullName] = value;
      }

      return value;
    }
  }

  function isSingletonClass(container, fullName, _ref2) {
    var instantiate = _ref2.instantiate;
    var singleton = _ref2.singleton;

    return singleton !== false && isSingleton(container, fullName) && !instantiate && !isInstantiatable(container, fullName);
  }

  function isSingletonInstance(container, fullName, _ref3) {
    var instantiate = _ref3.instantiate;
    var singleton = _ref3.singleton;

    return singleton !== false && isSingleton(container, fullName) && instantiate !== false && isInstantiatable(container, fullName);
  }

  function isFactoryClass(container, fullname, _ref4) {
    var instantiate = _ref4.instantiate;
    var singleton = _ref4.singleton;

    return (singleton === false || !isSingleton(container, fullname)) && instantiate === false && !isInstantiatable(container, fullname);
  }

  function isFactoryInstance(container, fullName, _ref5) {
    var instantiate = _ref5.instantiate;
    var singleton = _ref5.singleton;

    return (singleton !== false || isSingleton(container, fullName)) && instantiate !== false && isInstantiatable(container, fullName);
  }

  function instantiateFactory(container, fullName, options) {
    var factoryManager = container[FACTORY_FOR](fullName);

    if (factoryManager === undefined) {
      return;
    }

    // SomeClass { singleton: true, instantiate: true } | { singleton: true } | { instantiate: true } | {}
    // By default majority of objects fall into this case
    if (isSingletonInstance(container, fullName, options)) {
      return container.cache[fullName] = factoryManager.create();
    }

    // SomeClass { singleton: false, instantiate: true }
    if (isFactoryInstance(container, fullName, options)) {
      return factoryManager.create();
    }

    // SomeClass { singleton: true, instantiate: false } | { instantiate: false } | { singleton: false, instantiation: false }
    if (isSingletonClass(container, fullName, options) || isFactoryClass(container, fullName, options)) {
      return factoryManager.class;
    }

    throw new Error('Could not create factory');
  }

  function markInjectionsAsDynamic(injections) {
    injections._dynamic = true;
  }

  function areInjectionsDynamic(injections) {
    return !!injections._dynamic;
  }

  function buildInjections() /* container, ...injections */{
    var _arguments = arguments;

    var hash = {};

    if (arguments.length > 1) {
      (function () {
        var container = _arguments[0];
        var injections = [];
        var injection = undefined;

        for (var i = 1; i < _arguments.length; i++) {
          if (_arguments[i]) {
            injections = injections.concat(_arguments[i]);
          }
        }

        _emberDebug.runInDebug(function () {
          container.registry.validateInjections(injections);
        });

        for (var i = 0; i < injections.length; i++) {
          injection = injections[i];
          hash[injection.property] = lookup(container, injection.fullName);
          if (!isSingleton(container, injection.fullName)) {
            markInjectionsAsDynamic(hash);
          }
        }
      })();
    }

    return hash;
  }

  function deprecatedFactoryFor(container, fullName) {
    var options = arguments.length <= 2 || arguments[2] === undefined ? {} : arguments[2];

    var registry = container.registry;

    if (options.source) {
      fullName = registry.expandLocalLookup(fullName, options);
      // if expandLocalLookup returns falsey, we do not support local lookup
      if (!fullName) {
        return;
      }
    }

    var cache = container.factoryCache;
    if (cache[fullName]) {
      return cache[fullName];
    }
    var factory = registry.resolve(fullName);
    if (factory === undefined) {
      return;
    }

    var type = fullName.split(':')[0];
    if (!factory || typeof factory.extend !== 'function' || !_emberEnvironment.ENV.MODEL_FACTORY_INJECTIONS && type === 'model') {
      if (factory && typeof factory._onLookup === 'function') {
        factory._onLookup(fullName);
      }

      // TODO: think about a 'safe' merge style extension
      // for now just fallback to create time injection
      cache[fullName] = factory;
      return factory;
    } else {
      var injections = injectionsFor(container, fullName);
      var factoryInjections = factoryInjectionsFor(container, fullName);
      var cacheable = !areInjectionsDynamic(injections) && !areInjectionsDynamic(factoryInjections);

      factoryInjections[_emberUtils.NAME_KEY] = registry.makeToString(factory, fullName);
      injections._debugContainerKey = fullName;
      _emberUtils.setOwner(injections, container.owner);

      var injectedFactory = factory.extend(injections);

      // TODO - remove all `container` injections when Ember reaches v3.0.0
      injectDeprecatedContainer(injectedFactory.prototype, container);
      injectedFactory.reopenClass(factoryInjections);

      if (factory && typeof factory._onLookup === 'function') {
        factory._onLookup(fullName);
      }

      if (cacheable) {
        cache[fullName] = injectedFactory;
      }

      return injectedFactory;
    }
  }

  function injectionsFor(container, fullName) {
    var registry = container.registry;
    var splitName = fullName.split(':');
    var type = splitName[0];

    var injections = buildInjections(container, registry.getTypeInjections(type), registry.getInjections(fullName));

    return injections;
  }

  function instantiate(factory, props, container, fullName) {
    var lazyInjections = undefined,
        validationCache = undefined;

    props = props || {};

    if (container.registry.getOption(fullName, 'instantiate') === false) {
      return factory;
    }

    if (factory) {
      if (typeof factory.create !== 'function') {
        throw new Error('Failed to create an instance of \'' + fullName + '\'. Most likely an improperly defined class or' + ' an invalid module export.');
      }

      validationCache = container.validationCache;

      _emberDebug.runInDebug(function () {
        // Ensure that all lazy injections are valid at instantiation time
        if (!validationCache[fullName] && typeof factory._lazyInjections === 'function') {
          lazyInjections = factory._lazyInjections();
          lazyInjections = container.registry.normalizeInjectionsHash(lazyInjections);

          container.registry.validateInjections(lazyInjections);
        }
      });

      validationCache[fullName] = true;

      var obj = undefined;

      if (typeof factory.extend === 'function') {
        // assume the factory was extendable and is already injected
        obj = factory.create(props);
      } else {
        // assume the factory was extendable
        // to create time injections
        // TODO: support new'ing for instantiation and merge injections for pure JS Functions
        var injections = injectionsFor(container, fullName);
        injections._debugContainerKey = fullName;

        // Ensure that a container is available to an object during instantiation.
        // TODO - remove when Ember reaches v3.0.0
        // This "fake" container will be replaced after instantiation with a
        // property that raises deprecations every time it is accessed.
        injections.container = container._fakeContainerToInject;
        obj = factory.create(_emberUtils.assign({}, injections, props));

        // TODO - remove when Ember reaches v3.0.0
        if (!Object.isFrozen(obj)) {
          injectDeprecatedContainer(obj, container);
        }
      }

      return obj;
    }
  }

  function factoryInjectionsFor(container, fullName) {
    var registry = container.registry;
    var splitName = fullName.split(':');
    var type = splitName[0];

    var factoryInjections = buildInjections(container, registry.getFactoryTypeInjections(type), registry.getFactoryInjections(fullName));
    factoryInjections._debugContainerKey = fullName;

    return factoryInjections;
  }

  var INJECTED_DEPRECATED_CONTAINER_DESC = {
    configurable: true,
    enumerable: false,
    get: function () {
      _emberDebug.deprecate('Using the injected `container` is deprecated. Please use the `getOwner` helper instead to access the owner of this object.', false, { id: 'ember-application.injected-container', until: '2.13.0', url: 'http://emberjs.com/deprecations/v2.x#toc_injected-container-access' });
      return this[CONTAINER_OVERRIDE] || _emberUtils.getOwner(this).__container__;
    },

    set: function (value) {
      _emberDebug.deprecate('Providing the `container` property to ' + this + ' is deprecated. Please use `Ember.setOwner` or `owner.ownerInjection()` instead to provide an owner to the instance being created.', false, { id: 'ember-application.injected-container', until: '2.13.0', url: 'http://emberjs.com/deprecations/v2.x#toc_injected-container-access' });

      this[CONTAINER_OVERRIDE] = value;

      return value;
    }
  };

  // TODO - remove when Ember reaches v3.0.0
  function injectDeprecatedContainer(object, container) {
    if ('container' in object) {
      return;
    }
    Object.defineProperty(object, 'container', INJECTED_DEPRECATED_CONTAINER_DESC);
  }

  function destroyDestroyables(container) {
    var cache = container.cache;
    var keys = Object.keys(cache);

    for (var i = 0; i < keys.length; i++) {
      var key = keys[i];
      var value = cache[key];

      if (isInstantiatable(container, key) && value.destroy) {
        value.destroy();
      }
    }
  }

  function resetCache(container) {
    destroyDestroyables(container);
    container.cache.dict = _emberUtils.dictionary(null);
  }

  function resetMember(container, fullName) {
    var member = container.cache[fullName];

    delete container.factoryCache[fullName];

    if (member) {
      delete container.cache[fullName];

      if (member.destroy) {
        member.destroy();
      }
    }
  }

  function buildFakeContainerWithDeprecations(container) {
    var fakeContainer = {};
    var propertyMappings = {
      lookup: 'lookup',
      lookupFactory: '_lookupFactory'
    };

    for (var containerProperty in propertyMappings) {
      fakeContainer[containerProperty] = buildFakeContainerFunction(container, containerProperty, propertyMappings[containerProperty]);
    }

    return fakeContainer;
  }

  function buildFakeContainerFunction(container, containerProperty, ownerProperty) {
    return function () {
      _emberDebug.deprecate('Using the injected `container` is deprecated. Please use the `getOwner` helper to access the owner of this object and then call `' + ownerProperty + '` instead.', false, {
        id: 'ember-application.injected-container',
        until: '2.13.0',
        url: 'http://emberjs.com/deprecations/v2.x#toc_injected-container-access'
      });
      return container[containerProperty].apply(container, arguments);
    };
  }

  var DeprecatedFactoryManager = (function () {
    function DeprecatedFactoryManager(container, factory, fullName) {
      babelHelpers.classCallCheck(this, DeprecatedFactoryManager);

      this.container = container;
      this.class = factory;
      this.fullName = fullName;
    }

    DeprecatedFactoryManager.prototype.create = function create() {
      var props = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

      return instantiate(this.class, props, this.container, this.fullName);
    };

    return DeprecatedFactoryManager;
  })();

  var FactoryManager = (function () {
    function FactoryManager(container, factory, fullName, normalizedName) {
      babelHelpers.classCallCheck(this, FactoryManager);

      this.container = container;
      this.owner = container.owner;
      this.class = factory;
      this.fullName = fullName;
      this.normalizedName = normalizedName;
      this.madeToString = undefined;
      this.injections = undefined;
    }

    FactoryManager.prototype.toString = function toString() {
      if (!this.madeToString) {
        this.madeToString = this.container.registry.makeToString(this.class, this.fullName);
      }

      return this.madeToString;
    };

    FactoryManager.prototype.create = function create() {
      var _this = this;

      var options = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

      var injections = this.injections;
      if (injections === undefined) {
        injections = injectionsFor(this.container, this.normalizedName);
        if (areInjectionsDynamic(injections) === false) {
          this.injections = injections;
        }
      }
      var props = _emberUtils.assign({}, injections, options);

      _emberDebug.runInDebug(function () {
        var lazyInjections = undefined;
        var validationCache = _this.container.validationCache;
        // Ensure that all lazy injections are valid at instantiation time
        if (!validationCache[_this.fullName] && _this.class && typeof _this.class._lazyInjections === 'function') {
          lazyInjections = _this.class._lazyInjections();
          lazyInjections = _this.container.registry.normalizeInjectionsHash(lazyInjections);

          _this.container.registry.validateInjections(lazyInjections);
        }

        validationCache[_this.fullName] = true;
      });

      if (!this.class.create) {
        throw new Error('Failed to create an instance of \'' + this.normalizedName + '\'. Most likely an improperly defined class or' + ' an invalid module export.');
      }

      var prototype = this.class.prototype;
      if (prototype) {
        injectDeprecatedContainer(prototype, this.container);
      }

      // required to allow access to things like
      // the customized toString, _debugContainerKey,
      // owner, etc. without a double extend and without
      // modifying the objects properties
      if (typeof this.class._initFactory === 'function') {
        this.class._initFactory(this);
      } else {
        // in the non-Ember.Object case we need to still setOwner
        // this is required for supporting glimmer environment and
        // template instantiation which rely heavily on
        // `options[OWNER]` being passed into `create`
        // TODO: clean this up, and remove in future versions
        _emberUtils.setOwner(props, this.owner);
      }

      return this.class.create(props);
    };

    return FactoryManager;
  })();
});

/* globals Proxy */

/*
 * This internal version of factoryFor swaps between the public API for
 * factoryFor (class is the registered class) and a transition implementation
 * (class is the double-extended class). It is *not* the public API version
 * of factoryFor, which always returns the registered class.
 */

/**
 A depth first traversal, destroying the container, its descendant containers and all
 their managed objects.
  @private
 @method destroy
 */

/**
 Clear either the entire cache or just the cache for a particular key.
  @private
 @method reset
 @param {String} fullName optional key to reset; if missing, resets everything
 */

/**
 Returns an object that can be used to provide an owner to a
 manually created instance.
  @private
 @method ownerInjection
 @returns { Object }
*/
enifed('container/index', ['exports', 'container/registry', 'container/container'], function (exports, _containerRegistry, _containerContainer) {
  /*
  Public API for the container is still in flux.
  The public API, specified on the application namespace should be considered the stable API.
  // @module container
    @private
  */

  'use strict';

  exports.Registry = _containerRegistry.default;
  exports.privatize = _containerRegistry.privatize;
  exports.Container = _containerContainer.default;
  exports.buildFakeContainerWithDeprecations = _containerContainer.buildFakeContainerWithDeprecations;
  exports.FACTORY_FOR = _containerContainer.FACTORY_FOR;
  exports.LOOKUP_FACTORY = _containerContainer.LOOKUP_FACTORY;
});
enifed('container/registry', ['exports', 'ember-utils', 'ember-debug', 'container/container'], function (exports, _emberUtils, _emberDebug, _containerContainer) {
  'use strict';

  exports.default = Registry;
  exports.privatize = privatize;

  var VALID_FULL_NAME_REGEXP = /^[^:]+:[^:]+$/;

  /**
   A registry used to store factory and option information keyed
   by type.
  
   A `Registry` stores the factory and option information needed by a
   `Container` to instantiate and cache objects.
  
   The API for `Registry` is still in flux and should not be considered stable.
  
   @private
   @class Registry
   @since 1.11.0
  */

  function Registry(options) {
    this.fallback = options && options.fallback ? options.fallback : null;

    if (options && options.resolver) {
      this.resolver = options.resolver;

      if (typeof this.resolver === 'function') {
        deprecateResolverFunction(this);
      }
    }

    this.registrations = _emberUtils.dictionary(options && options.registrations ? options.registrations : null);

    this._typeInjections = _emberUtils.dictionary(null);
    this._injections = _emberUtils.dictionary(null);
    this._factoryTypeInjections = _emberUtils.dictionary(null);
    this._factoryInjections = _emberUtils.dictionary(null);

    this._localLookupCache = Object.create(null);
    this._normalizeCache = _emberUtils.dictionary(null);
    this._resolveCache = _emberUtils.dictionary(null);
    this._failCache = _emberUtils.dictionary(null);

    this._options = _emberUtils.dictionary(null);
    this._typeOptions = _emberUtils.dictionary(null);
  }

  Registry.prototype = {
    /**
     A backup registry for resolving registrations when no matches can be found.
      @private
     @property fallback
     @type Registry
     */
    fallback: null,

    /**
     An object that has a `resolve` method that resolves a name.
      @private
     @property resolver
     @type Resolver
     */
    resolver: null,

    /**
     @private
     @property registrations
     @type InheritingDict
     */
    registrations: null,

    /**
     @private
      @property _typeInjections
     @type InheritingDict
     */
    _typeInjections: null,

    /**
     @private
      @property _injections
     @type InheritingDict
     */
    _injections: null,

    /**
     @private
      @property _factoryTypeInjections
     @type InheritingDict
     */
    _factoryTypeInjections: null,

    /**
     @private
      @property _factoryInjections
     @type InheritingDict
     */
    _factoryInjections: null,

    /**
     @private
      @property _normalizeCache
     @type InheritingDict
     */
    _normalizeCache: null,

    /**
     @private
      @property _resolveCache
     @type InheritingDict
     */
    _resolveCache: null,

    /**
     @private
      @property _options
     @type InheritingDict
     */
    _options: null,

    /**
     @private
      @property _typeOptions
     @type InheritingDict
     */
    _typeOptions: null,

    /**
     Creates a container based on this registry.
      @private
     @method container
     @param {Object} options
     @return {Container} created container
     */
    container: function (options) {
      return new _containerContainer.default(this, options);
    },

    /**
     Registers a factory for later injection.
      Example:
      ```javascript
     let registry = new Registry();
      registry.register('model:user', Person, {singleton: false });
     registry.register('fruit:favorite', Orange);
     registry.register('communication:main', Email, {singleton: false});
     ```
      @private
     @method register
     @param {String} fullName
     @param {Function} factory
     @param {Object} options
     */
    register: function (fullName, factory) {
      var options = arguments.length <= 2 || arguments[2] === undefined ? {} : arguments[2];

      _emberDebug.assert('fullName must be a proper full name', this.validateFullName(fullName));

      if (factory === undefined) {
        throw new TypeError('Attempting to register an unknown factory: \'' + fullName + '\'');
      }

      var normalizedName = this.normalize(fullName);

      if (this._resolveCache[normalizedName]) {
        throw new Error('Cannot re-register: \'' + fullName + '\', as it has already been resolved.');
      }

      delete this._failCache[normalizedName];
      this.registrations[normalizedName] = factory;
      this._options[normalizedName] = options;
    },

    /**
     Unregister a fullName
      ```javascript
     let registry = new Registry();
     registry.register('model:user', User);
      registry.resolve('model:user').create() instanceof User //=> true
      registry.unregister('model:user')
     registry.resolve('model:user') === undefined //=> true
     ```
      @private
     @method unregister
     @param {String} fullName
     */
    unregister: function (fullName) {
      _emberDebug.assert('fullName must be a proper full name', this.validateFullName(fullName));

      var normalizedName = this.normalize(fullName);

      this._localLookupCache = Object.create(null);

      delete this.registrations[normalizedName];
      delete this._resolveCache[normalizedName];
      delete this._failCache[normalizedName];
      delete this._options[normalizedName];
    },

    /**
     Given a fullName return the corresponding factory.
      By default `resolve` will retrieve the factory from
     the registry.
      ```javascript
     let registry = new Registry();
     registry.register('api:twitter', Twitter);
      registry.resolve('api:twitter') // => Twitter
     ```
      Optionally the registry can be provided with a custom resolver.
     If provided, `resolve` will first provide the custom resolver
     the opportunity to resolve the fullName, otherwise it will fallback
     to the registry.
      ```javascript
     let registry = new Registry();
     registry.resolver = function(fullName) {
        // lookup via the module system of choice
      };
      // the twitter factory is added to the module system
     registry.resolve('api:twitter') // => Twitter
     ```
      @private
     @method resolve
     @param {String} fullName
     @param {Object} [options]
     @param {String} [options.source] the fullname of the request source (used for local lookups)
     @return {Function} fullName's factory
     */
    resolve: function (fullName, options) {
      _emberDebug.assert('fullName must be a proper full name', this.validateFullName(fullName));
      var factory = resolve(this, this.normalize(fullName), options);
      if (factory === undefined && this.fallback) {
        var _fallback;

        factory = (_fallback = this.fallback).resolve.apply(_fallback, arguments);
      }
      return factory;
    },

    /**
     A hook that can be used to describe how the resolver will
     attempt to find the factory.
      For example, the default Ember `.describe` returns the full
     class name (including namespace) where Ember's resolver expects
     to find the `fullName`.
      @private
     @method describe
     @param {String} fullName
     @return {string} described fullName
     */
    describe: function (fullName) {
      if (this.resolver && this.resolver.lookupDescription) {
        return this.resolver.lookupDescription(fullName);
      } else if (this.fallback) {
        return this.fallback.describe(fullName);
      } else {
        return fullName;
      }
    },

    /**
     A hook to enable custom fullName normalization behaviour
      @private
     @method normalizeFullName
     @param {String} fullName
     @return {string} normalized fullName
     */
    normalizeFullName: function (fullName) {
      if (this.resolver && this.resolver.normalize) {
        return this.resolver.normalize(fullName);
      } else if (this.fallback) {
        return this.fallback.normalizeFullName(fullName);
      } else {
        return fullName;
      }
    },

    /**
     Normalize a fullName based on the application's conventions
      @private
     @method normalize
     @param {String} fullName
     @return {string} normalized fullName
     */
    normalize: function (fullName) {
      return this._normalizeCache[fullName] || (this._normalizeCache[fullName] = this.normalizeFullName(fullName));
    },

    /**
     @method makeToString
      @private
     @param {any} factory
     @param {string} fullName
     @return {function} toString function
     */
    makeToString: function (factory, fullName) {
      if (this.resolver && this.resolver.makeToString) {
        return this.resolver.makeToString(factory, fullName);
      } else if (this.fallback) {
        return this.fallback.makeToString(factory, fullName);
      } else {
        return factory.toString();
      }
    },

    /**
     Given a fullName check if the container is aware of its factory
     or singleton instance.
      @private
     @method has
     @param {String} fullName
     @param {Object} [options]
     @param {String} [options.source] the fullname of the request source (used for local lookups)
     @return {Boolean}
     */
    has: function (fullName, options) {
      if (!this.isValidFullName(fullName)) {
        return false;
      }

      var source = options && options.source && this.normalize(options.source);

      return has(this, this.normalize(fullName), source);
    },

    /**
     Allow registering options for all factories of a type.
      ```javascript
     let registry = new Registry();
     let container = registry.container();
      // if all of type `connection` must not be singletons
     registry.optionsForType('connection', { singleton: false });
      registry.register('connection:twitter', TwitterConnection);
     registry.register('connection:facebook', FacebookConnection);
      let twitter = container.lookup('connection:twitter');
     let twitter2 = container.lookup('connection:twitter');
      twitter === twitter2; // => false
      let facebook = container.lookup('connection:facebook');
     let facebook2 = container.lookup('connection:facebook');
      facebook === facebook2; // => false
     ```
      @private
     @method optionsForType
     @param {String} type
     @param {Object} options
     */
    optionsForType: function (type, options) {
      this._typeOptions[type] = options;
    },

    getOptionsForType: function (type) {
      var optionsForType = this._typeOptions[type];
      if (optionsForType === undefined && this.fallback) {
        optionsForType = this.fallback.getOptionsForType(type);
      }
      return optionsForType;
    },

    /**
     @private
     @method options
     @param {String} fullName
     @param {Object} options
     */
    options: function (fullName) {
      var options = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

      var normalizedName = this.normalize(fullName);
      this._options[normalizedName] = options;
    },

    getOptions: function (fullName) {
      var normalizedName = this.normalize(fullName);
      var options = this._options[normalizedName];

      if (options === undefined && this.fallback) {
        options = this.fallback.getOptions(fullName);
      }
      return options;
    },

    getOption: function (fullName, optionName) {
      var options = this._options[fullName];

      if (options && options[optionName] !== undefined) {
        return options[optionName];
      }

      var type = fullName.split(':')[0];
      options = this._typeOptions[type];

      if (options && options[optionName] !== undefined) {
        return options[optionName];
      } else if (this.fallback) {
        return this.fallback.getOption(fullName, optionName);
      }
    },

    /**
     Used only via `injection`.
      Provides a specialized form of injection, specifically enabling
     all objects of one type to be injected with a reference to another
     object.
      For example, provided each object of type `controller` needed a `router`.
     one would do the following:
      ```javascript
     let registry = new Registry();
     let container = registry.container();
      registry.register('router:main', Router);
     registry.register('controller:user', UserController);
     registry.register('controller:post', PostController);
      registry.typeInjection('controller', 'router', 'router:main');
      let user = container.lookup('controller:user');
     let post = container.lookup('controller:post');
      user.router instanceof Router; //=> true
     post.router instanceof Router; //=> true
      // both controllers share the same router
     user.router === post.router; //=> true
     ```
      @private
     @method typeInjection
     @param {String} type
     @param {String} property
     @param {String} fullName
     */
    typeInjection: function (type, property, fullName) {
      _emberDebug.assert('fullName must be a proper full name', this.validateFullName(fullName));

      var fullNameType = fullName.split(':')[0];
      if (fullNameType === type) {
        throw new Error('Cannot inject a \'' + fullName + '\' on other ' + type + '(s).');
      }

      var injections = this._typeInjections[type] || (this._typeInjections[type] = []);

      injections.push({
        property: property,
        fullName: fullName
      });
    },

    /**
     Defines injection rules.
      These rules are used to inject dependencies onto objects when they
     are instantiated.
      Two forms of injections are possible:
      * Injecting one fullName on another fullName
     * Injecting one fullName on a type
      Example:
      ```javascript
     let registry = new Registry();
     let container = registry.container();
      registry.register('source:main', Source);
     registry.register('model:user', User);
     registry.register('model:post', Post);
      // injecting one fullName on another fullName
     // eg. each user model gets a post model
     registry.injection('model:user', 'post', 'model:post');
      // injecting one fullName on another type
     registry.injection('model', 'source', 'source:main');
      let user = container.lookup('model:user');
     let post = container.lookup('model:post');
      user.source instanceof Source; //=> true
     post.source instanceof Source; //=> true
      user.post instanceof Post; //=> true
      // and both models share the same source
     user.source === post.source; //=> true
     ```
      @private
     @method injection
     @param {String} factoryName
     @param {String} property
     @param {String} injectionName
     */
    injection: function (fullName, property, injectionName) {
      this.validateFullName(injectionName);
      var normalizedInjectionName = this.normalize(injectionName);

      if (fullName.indexOf(':') === -1) {
        return this.typeInjection(fullName, property, normalizedInjectionName);
      }

      _emberDebug.assert('fullName must be a proper full name', this.validateFullName(fullName));
      var normalizedName = this.normalize(fullName);

      var injections = this._injections[normalizedName] || (this._injections[normalizedName] = []);

      injections.push({
        property: property,
        fullName: normalizedInjectionName
      });
    },

    /**
     Used only via `factoryInjection`.
      Provides a specialized form of injection, specifically enabling
     all factory of one type to be injected with a reference to another
     object.
      For example, provided each factory of type `model` needed a `store`.
     one would do the following:
      ```javascript
     let registry = new Registry();
      registry.register('store:main', SomeStore);
      registry.factoryTypeInjection('model', 'store', 'store:main');
      let store = registry.lookup('store:main');
     let UserFactory = registry.lookupFactory('model:user');
      UserFactory.store instanceof SomeStore; //=> true
     ```
      @private
     @method factoryTypeInjection
     @param {String} type
     @param {String} property
     @param {String} fullName
     */
    factoryTypeInjection: function (type, property, fullName) {
      var injections = this._factoryTypeInjections[type] || (this._factoryTypeInjections[type] = []);

      injections.push({
        property: property,
        fullName: this.normalize(fullName)
      });
    },

    /**
     Defines factory injection rules.
      Similar to regular injection rules, but are run against factories, via
     `Registry#lookupFactory`.
      These rules are used to inject objects onto factories when they
     are looked up.
      Two forms of injections are possible:
      * Injecting one fullName on another fullName
     * Injecting one fullName on a type
      Example:
      ```javascript
     let registry = new Registry();
     let container = registry.container();
      registry.register('store:main', Store);
     registry.register('store:secondary', OtherStore);
     registry.register('model:user', User);
     registry.register('model:post', Post);
      // injecting one fullName on another type
     registry.factoryInjection('model', 'store', 'store:main');
      // injecting one fullName on another fullName
     registry.factoryInjection('model:post', 'secondaryStore', 'store:secondary');
      let UserFactory = container.lookupFactory('model:user');
     let PostFactory = container.lookupFactory('model:post');
     let store = container.lookup('store:main');
      UserFactory.store instanceof Store; //=> true
     UserFactory.secondaryStore instanceof OtherStore; //=> false
      PostFactory.store instanceof Store; //=> true
     PostFactory.secondaryStore instanceof OtherStore; //=> true
      // and both models share the same source instance
     UserFactory.store === PostFactory.store; //=> true
     ```
      @private
     @method factoryInjection
     @param {String} factoryName
     @param {String} property
     @param {String} injectionName
     */
    factoryInjection: function (fullName, property, injectionName) {
      var normalizedName = this.normalize(fullName);
      var normalizedInjectionName = this.normalize(injectionName);

      this.validateFullName(injectionName);

      if (fullName.indexOf(':') === -1) {
        return this.factoryTypeInjection(normalizedName, property, normalizedInjectionName);
      }

      var injections = this._factoryInjections[normalizedName] || (this._factoryInjections[normalizedName] = []);

      injections.push({
        property: property,
        fullName: normalizedInjectionName
      });
    },

    /**
     @private
     @method knownForType
     @param {String} type the type to iterate over
    */
    knownForType: function (type) {
      var fallbackKnown = undefined,
          resolverKnown = undefined;

      var localKnown = _emberUtils.dictionary(null);
      var registeredNames = Object.keys(this.registrations);
      for (var index = 0; index < registeredNames.length; index++) {
        var fullName = registeredNames[index];
        var itemType = fullName.split(':')[0];

        if (itemType === type) {
          localKnown[fullName] = true;
        }
      }

      if (this.fallback) {
        fallbackKnown = this.fallback.knownForType(type);
      }

      if (this.resolver && this.resolver.knownForType) {
        resolverKnown = this.resolver.knownForType(type);
      }

      return _emberUtils.assign({}, fallbackKnown, localKnown, resolverKnown);
    },

    validateFullName: function (fullName) {
      if (!this.isValidFullName(fullName)) {
        throw new TypeError('Invalid Fullname, expected: \'type:name\' got: ' + fullName);
      }

      return true;
    },

    isValidFullName: function (fullName) {
      return !!VALID_FULL_NAME_REGEXP.test(fullName);
    },

    validateInjections: function (injections) {
      if (!injections) {
        return;
      }

      var fullName = undefined;

      for (var i = 0; i < injections.length; i++) {
        fullName = injections[i].fullName;

        _emberDebug.assert('Attempting to inject an unknown injection: \'' + fullName + '\'', this.has(fullName));
      }
    },

    normalizeInjectionsHash: function (hash) {
      var injections = [];

      for (var key in hash) {
        if (hash.hasOwnProperty(key)) {
          _emberDebug.assert('Expected a proper full name, given \'' + hash[key] + '\'', this.validateFullName(hash[key]));

          injections.push({
            property: key,
            fullName: hash[key]
          });
        }
      }

      return injections;
    },

    getInjections: function (fullName) {
      var injections = this._injections[fullName] || [];
      if (this.fallback) {
        injections = injections.concat(this.fallback.getInjections(fullName));
      }
      return injections;
    },

    getTypeInjections: function (type) {
      var injections = this._typeInjections[type] || [];
      if (this.fallback) {
        injections = injections.concat(this.fallback.getTypeInjections(type));
      }
      return injections;
    },

    getFactoryInjections: function (fullName) {
      var injections = this._factoryInjections[fullName] || [];
      if (this.fallback) {
        injections = injections.concat(this.fallback.getFactoryInjections(fullName));
      }
      return injections;
    },

    getFactoryTypeInjections: function (type) {
      var injections = this._factoryTypeInjections[type] || [];
      if (this.fallback) {
        injections = injections.concat(this.fallback.getFactoryTypeInjections(type));
      }
      return injections;
    }
  };

  function deprecateResolverFunction(registry) {
    _emberDebug.deprecate('Passing a `resolver` function into a Registry is deprecated. Please pass in a Resolver object with a `resolve` method.', false, { id: 'ember-application.registry-resolver-as-function', until: '3.0.0', url: 'http://emberjs.com/deprecations/v2.x#toc_registry-resolver-as-function' });
    registry.resolver = {
      resolve: registry.resolver
    };
  }

  /**
   Given a fullName and a source fullName returns the fully resolved
   fullName. Used to allow for local lookup.
  
   ```javascript
   let registry = new Registry();
  
   // the twitter factory is added to the module system
   registry.expandLocalLookup('component:post-title', { source: 'template:post' }) // => component:post/post-title
   ```
  
   @private
   @method expandLocalLookup
   @param {String} fullName
   @param {Object} [options]
   @param {String} [options.source] the fullname of the request source (used for local lookups)
   @return {String} fullName
   */
  Registry.prototype.expandLocalLookup = function Registry_expandLocalLookup(fullName, options) {
    if (this.resolver && this.resolver.expandLocalLookup) {
      _emberDebug.assert('fullName must be a proper full name', this.validateFullName(fullName));
      _emberDebug.assert('options.source must be provided to expandLocalLookup', options && options.source);
      _emberDebug.assert('options.source must be a proper full name', this.validateFullName(options.source));

      var normalizedFullName = this.normalize(fullName);
      var normalizedSource = this.normalize(options.source);

      return expandLocalLookup(this, normalizedFullName, normalizedSource);
    } else if (this.fallback) {
      return this.fallback.expandLocalLookup(fullName, options);
    } else {
      return null;
    }
  };

  function expandLocalLookup(registry, normalizedName, normalizedSource) {
    var cache = registry._localLookupCache;
    var normalizedNameCache = cache[normalizedName];

    if (!normalizedNameCache) {
      normalizedNameCache = cache[normalizedName] = Object.create(null);
    }

    var cached = normalizedNameCache[normalizedSource];

    if (cached !== undefined) {
      return cached;
    }

    var expanded = registry.resolver.expandLocalLookup(normalizedName, normalizedSource);

    return normalizedNameCache[normalizedSource] = expanded;
  }

  function resolve(registry, normalizedName, options) {
    if (options && options.source) {
      // when `source` is provided expand normalizedName
      // and source into the full normalizedName
      normalizedName = registry.expandLocalLookup(normalizedName, options);

      // if expandLocalLookup returns falsey, we do not support local lookup
      if (!normalizedName) {
        return;
      }
    }

    var cached = registry._resolveCache[normalizedName];
    if (cached !== undefined) {
      return cached;
    }
    if (registry._failCache[normalizedName]) {
      return;
    }

    var resolved = undefined;

    if (registry.resolver) {
      resolved = registry.resolver.resolve(normalizedName);
    }

    if (resolved === undefined) {
      resolved = registry.registrations[normalizedName];
    }

    if (resolved === undefined) {
      registry._failCache[normalizedName] = true;
    } else {
      registry._resolveCache[normalizedName] = resolved;
    }

    return resolved;
  }

  function has(registry, fullName, source) {
    return registry.resolve(fullName, { source: source }) !== undefined;
  }

  var privateNames = _emberUtils.dictionary(null);
  var privateSuffix = '' + Math.random() + Date.now();

  function privatize(_ref) {
    var fullName = _ref[0];

    var name = privateNames[fullName];
    if (name) {
      return name;
    }

    var _fullName$split = fullName.split(':');

    var type = _fullName$split[0];
    var rawName = _fullName$split[1];

    return privateNames[fullName] = _emberUtils.intern(type + ':' + rawName + '-' + privateSuffix);
  }
});
enifed('dag-map', ['exports'], function (exports) { 'use strict';

/**
 * A map of key/value pairs with dependencies contraints that can be traversed
 * in topological order and is checked for cycles.
 *
 * @class DAG
 * @constructor
 */
var DAG = (function () {
    function DAG() {
        this._vertices = new Vertices();
    }
    /**
     * Adds a key/value pair with dependencies on other key/value pairs.
     *
     * @public
     * @method addEdges
     * @param {string[]}   key The key of the vertex to be added.
     * @param {any}      value The value of that vertex.
     * @param {string[]|string|undefined}  before A key or array of keys of the vertices that must
     *                                            be visited before this vertex.
     * @param {string[]|string|undefined}   after An string or array of strings with the keys of the
     *                                            vertices that must be after this vertex is visited.
     */
    DAG.prototype.add = function (key, value, before, after) {
        var vertices = this._vertices;
        var v = vertices.add(key);
        v.val = value;
        if (before) {
            if (typeof before === "string") {
                vertices.addEdge(v, vertices.add(before));
            }
            else {
                for (var i = 0; i < before.length; i++) {
                    vertices.addEdge(v, vertices.add(before[i]));
                }
            }
        }
        if (after) {
            if (typeof after === "string") {
                vertices.addEdge(vertices.add(after), v);
            }
            else {
                for (var i = 0; i < after.length; i++) {
                    vertices.addEdge(vertices.add(after[i]), v);
                }
            }
        }
    };
    /**
     * Visits key/value pairs in topological order.
     *
     * @public
     * @method  topsort
     * @param {Function} fn The function to be invoked with each key/value.
     */
    DAG.prototype.topsort = function (callback) {
        this._vertices.topsort(callback);
    };
    return DAG;
}());
var Vertices = (function () {
    function Vertices() {
        this.stack = new IntStack();
        this.result = new IntStack();
        this.vertices = [];
    }
    Vertices.prototype.add = function (key) {
        if (!key)
            throw new Error("missing key");
        var vertices = this.vertices;
        var i = 0;
        var vertex;
        for (; i < vertices.length; i++) {
            vertex = vertices[i];
            if (vertex.key === key)
                return vertex;
        }
        return vertices[i] = {
            id: i,
            key: key,
            val: null,
            inc: null,
            out: false,
            mark: false
        };
    };
    Vertices.prototype.addEdge = function (v, w) {
        this.check(v, w.key);
        var inc = w.inc;
        if (!inc) {
            w.inc = [v.id];
        }
        else {
            var i = 0;
            for (; i < inc.length; i++) {
                if (inc[i] === v.id)
                    return;
            }
            inc[i] = v.id;
        }
        v.out = true;
    };
    Vertices.prototype.topsort = function (cb) {
        this.reset();
        var vertices = this.vertices;
        for (var i = 0; i < vertices.length; i++) {
            var vertex = vertices[i];
            if (vertex.out)
                continue;
            this.visit(vertex, undefined);
        }
        this.each(cb);
    };
    Vertices.prototype.check = function (v, w) {
        if (v.key === w) {
            throw new Error("cycle detected: " + w + " <- " + w);
        }
        var inc = v.inc;
        // quick check
        if (!inc || inc.length === 0)
            return;
        var vertices = this.vertices;
        // shallow check
        for (var i = 0; i < inc.length; i++) {
            var key = vertices[inc[i]].key;
            if (key === w) {
                throw new Error("cycle detected: " + w + " <- " + v.key + " <- " + w);
            }
        }
        // deep check
        this.reset();
        this.visit(v, w);
        if (this.result.len > 0) {
            var msg_1 = "cycle detected: " + w;
            this.each(function (key) {
                msg_1 += " <- " + key;
            });
            throw new Error(msg_1);
        }
    };
    Vertices.prototype.each = function (cb) {
        var _a = this, result = _a.result, vertices = _a.vertices;
        for (var i = 0; i < result.len; i++) {
            var vertex = vertices[result.stack[i]];
            cb(vertex.key, vertex.val);
        }
    };
    // reuse between cycle check and topsort
    Vertices.prototype.reset = function () {
        this.stack.len = 0;
        this.result.len = 0;
        var vertices = this.vertices;
        for (var i = 0; i < vertices.length; i++) {
            vertices[i].mark = false;
        }
    };
    Vertices.prototype.visit = function (start, search) {
        var _a = this, stack = _a.stack, result = _a.result, vertices = _a.vertices;
        stack.push(start.id);
        while (stack.len) {
            var index = stack.pop();
            if (index < 0) {
                index = ~index;
                if (search) {
                    result.pop();
                }
                else {
                    result.push(index);
                }
            }
            else {
                var vertex = vertices[index];
                if (vertex.mark) {
                    continue;
                }
                if (search) {
                    result.push(index);
                    if (search === vertex.key) {
                        return;
                    }
                }
                vertex.mark = true;
                stack.push(~index);
                var incoming = vertex.inc;
                if (incoming) {
                    var i = incoming.length;
                    while (i--) {
                        index = incoming[i];
                        if (!vertices[index].mark) {
                            stack.push(index);
                        }
                    }
                }
            }
        }
    };
    return Vertices;
}());
var IntStack = (function () {
    function IntStack() {
        this.stack = [0, 0, 0, 0, 0, 0];
        this.len = 0;
    }
    IntStack.prototype.push = function (n) {
        this.stack[this.len++] = n;
    };
    IntStack.prototype.pop = function () {
        return this.stack[--this.len];
    };
    return IntStack;
}());

exports['default'] = DAG;

Object.defineProperty(exports, '__esModule', { value: true });

});
enifed('ember-application/index', ['exports', 'ember-application/initializers/dom-templates', 'ember-application/system/application', 'ember-application/system/application-instance', 'ember-application/system/resolver', 'ember-application/system/engine', 'ember-application/system/engine-instance', 'ember-application/system/engine-parent'], function (exports, _emberApplicationInitializersDomTemplates, _emberApplicationSystemApplication, _emberApplicationSystemApplicationInstance, _emberApplicationSystemResolver, _emberApplicationSystemEngine, _emberApplicationSystemEngineInstance, _emberApplicationSystemEngineParent) {
  /**
  @module ember
  @submodule ember-application
  */

  'use strict';

  exports.Application = _emberApplicationSystemApplication.default;
  exports.ApplicationInstance = _emberApplicationSystemApplicationInstance.default;
  exports.Resolver = _emberApplicationSystemResolver.default;
  exports.Engine = _emberApplicationSystemEngine.default;
  exports.EngineInstance = _emberApplicationSystemEngineInstance.default;
  exports.getEngineParent = _emberApplicationSystemEngineParent.getEngineParent;
  exports.setEngineParent = _emberApplicationSystemEngineParent.setEngineParent;

  // add domTemplates initializer (only does something if `ember-template-compiler`
  // is loaded already)
});
enifed('ember-application/initializers/dom-templates', ['exports', 'require', 'ember-glimmer', 'ember-environment', 'ember-application/system/application'], function (exports, _require, _emberGlimmer, _emberEnvironment, _emberApplicationSystemApplication) {
  'use strict';

  var bootstrap = function () {};

  _emberApplicationSystemApplication.default.initializer({
    name: 'domTemplates',
    initialize: function () {
      var bootstrapModuleId = 'ember-template-compiler/system/bootstrap';
      var context = undefined;
      if (_emberEnvironment.environment.hasDOM && _require.has(bootstrapModuleId)) {
        bootstrap = _require.default(bootstrapModuleId).default;
        context = document;
      }

      bootstrap({ context: context, hasTemplate: _emberGlimmer.hasTemplate, setTemplate: _emberGlimmer.setTemplate });
    }
  });
});
enifed('ember-application/system/application-instance', ['exports', 'ember-utils', 'ember-debug', 'ember-metal', 'ember-runtime', 'ember-environment', 'ember-views', 'ember-application/system/engine-instance'], function (exports, _emberUtils, _emberDebug, _emberMetal, _emberRuntime, _emberEnvironment, _emberViews, _emberApplicationSystemEngineInstance) {
  /**
  @module ember
  @submodule ember-application
  */

  'use strict';

  var BootOptions = undefined;

  /**
    The `ApplicationInstance` encapsulates all of the stateful aspects of a
    running `Application`.
  
    At a high-level, we break application boot into two distinct phases:
  
    * Definition time, where all of the classes, templates, and other
      dependencies are loaded (typically in the browser).
    * Run time, where we begin executing the application once everything
      has loaded.
  
    Definition time can be expensive and only needs to happen once since it is
    an idempotent operation. For example, between test runs and FastBoot
    requests, the application stays the same. It is only the state that we want
    to reset.
  
    That state is what the `ApplicationInstance` manages: it is responsible for
    creating the container that contains all application state, and disposing of
    it once the particular test run or FastBoot request has finished.
  
    @public
    @class Ember.ApplicationInstance
    @extends Ember.EngineInstance
  */

  var ApplicationInstance = _emberApplicationSystemEngineInstance.default.extend({
    /**
      The `Application` for which this is an instance.
       @property {Ember.Application} application
      @private
    */
    application: null,

    /**
      The DOM events for which the event dispatcher should listen.
       By default, the application's `Ember.EventDispatcher` listens
      for a set of standard DOM events, such as `mousedown` and
      `keyup`, and delegates them to your application's `Ember.View`
      instances.
       @private
      @property {Object} customEvents
    */
    customEvents: null,

    /**
      The root DOM element of the Application as an element or a
      [jQuery-compatible selector
      string](http://api.jquery.com/category/selectors/).
       @private
      @property {String|DOMElement} rootElement
    */
    rootElement: null,

    init: function () {
      this._super.apply(this, arguments);

      // Register this instance in the per-instance registry.
      //
      // Why do we need to register the instance in the first place?
      // Because we need a good way for the root route (a.k.a ApplicationRoute)
      // to notify us when it has created the root-most view. That view is then
      // appended to the rootElement, in the case of apps, to the fixture harness
      // in tests, or rendered to a string in the case of FastBoot.
      this.register('-application-instance:main', this, { instantiate: false });
    },

    /**
      Overrides the base `EngineInstance._bootSync` method with concerns relevant
      to booting application (instead of engine) instances.
       This method should only contain synchronous boot concerns. Asynchronous
      boot concerns should eventually be moved to the `boot` method, which
      returns a promise.
       Until all boot code has been made asynchronous, we need to continue to
      expose this method for use *internally* in places where we need to boot an
      instance synchronously.
       @private
    */
    _bootSync: function (options) {
      if (this._booted) {
        return this;
      }

      options = new BootOptions(options);

      this.setupRegistry(options);

      if (options.rootElement) {
        this.rootElement = options.rootElement;
      } else {
        this.rootElement = this.application.rootElement;
      }

      if (options.location) {
        var router = _emberMetal.get(this, 'router');
        _emberMetal.set(router, 'location', options.location);
      }

      this.application.runInstanceInitializers(this);

      if (options.isInteractive) {
        this.setupEventDispatcher();
      }

      this._booted = true;

      return this;
    },

    setupRegistry: function (options) {
      this.constructor.setupRegistry(this.__registry__, options);
    },

    router: _emberMetal.computed(function () {
      return this.lookup('router:main');
    }).readOnly(),

    /**
      This hook is called by the root-most Route (a.k.a. the ApplicationRoute)
      when it has finished creating the root View. By default, we simply take the
      view and append it to the `rootElement` specified on the Application.
       In cases like FastBoot and testing, we can override this hook and implement
      custom behavior, such as serializing to a string and sending over an HTTP
      socket rather than appending to DOM.
       @param view {Ember.View} the root-most view
      @private
    */
    didCreateRootView: function (view) {
      view.appendTo(this.rootElement);
    },

    /**
      Tells the router to start routing. The router will ask the location for the
      current URL of the page to determine the initial URL to start routing to.
      To start the app at a specific URL, call `handleURL` instead.
       @private
    */
    startRouting: function () {
      var router = _emberMetal.get(this, 'router');
      router.startRouting();
      this._didSetupRouter = true;
    },

    /**
      @private
       Sets up the router, initializing the child router and configuring the
      location before routing begins.
       Because setup should only occur once, multiple calls to `setupRouter`
      beyond the first call have no effect.
    */
    setupRouter: function () {
      if (this._didSetupRouter) {
        return;
      }
      this._didSetupRouter = true;

      var router = _emberMetal.get(this, 'router');
      router.setupRouter();
    },

    /**
      Directs the router to route to a particular URL. This is useful in tests,
      for example, to tell the app to start at a particular URL.
       @param url {String} the URL the router should route to
      @private
    */
    handleURL: function (url) {
      var router = _emberMetal.get(this, 'router');

      this.setupRouter();
      return router.handleURL(url);
    },

    /**
      @private
    */
    setupEventDispatcher: function () {
      var dispatcher = this.lookup('event_dispatcher:main');
      var applicationCustomEvents = _emberMetal.get(this.application, 'customEvents');
      var instanceCustomEvents = _emberMetal.get(this, 'customEvents');

      var customEvents = _emberUtils.assign({}, applicationCustomEvents, instanceCustomEvents);
      dispatcher.setup(customEvents, this.rootElement);

      return dispatcher;
    },

    /**
      Returns the current URL of the app instance. This is useful when your
      app does not update the browsers URL bar (i.e. it uses the `'none'`
      location adapter).
       @public
      @return {String} the current URL
    */
    getURL: function () {
      var router = _emberMetal.get(this, 'router');
      return _emberMetal.get(router, 'url');
    },

    // `instance.visit(url)` should eventually replace `instance.handleURL()`;
    // the test helpers can probably be switched to use this implementation too

    /**
      Navigate the instance to a particular URL. This is useful in tests, for
      example, or to tell the app to start at a particular URL. This method
      returns a promise that resolves with the app instance when the transition
      is complete, or rejects if the transion was aborted due to an error.
       @public
      @param url {String} the destination URL
      @return {Promise}
    */
    visit: function (url) {
      var _this = this;

      this.setupRouter();

      var bootOptions = this.__container__.lookup('-environment:main');

      var router = _emberMetal.get(this, 'router');

      var handleTransitionResolve = function () {
        if (!bootOptions.options.shouldRender) {
          // No rendering is needed, and routing has completed, simply return.
          return _this;
        } else {
          return new _emberRuntime.RSVP.Promise(function (resolve) {
            // Resolve once rendering is completed. `router.handleURL` returns the transition (as a thennable)
            // which resolves once the transition is completed, but the transition completion only queues up
            // a scheduled revalidation (into the `render` queue) in the Renderer.
            //
            // This uses `run.schedule('afterRender', ....)` to resolve after that rendering has completed.
            _emberMetal.run.schedule('afterRender', null, resolve, _this);
          });
        }
      };

      var handleTransitionReject = function (error) {
        if (error.error) {
          throw error.error;
        } else if (error.name === 'TransitionAborted' && router._routerMicrolib.activeTransition) {
          return router._routerMicrolib.activeTransition.then(handleTransitionResolve, handleTransitionReject);
        } else if (error.name === 'TransitionAborted') {
          throw new Error(error.message);
        } else {
          throw error;
        }
      };

      var location = _emberMetal.get(router, 'location');

      // Keeps the location adapter's internal URL in-sync
      location.setURL(url);

      // getURL returns the set url with the rootURL stripped off
      return router.handleURL(location.getURL()).then(handleTransitionResolve, handleTransitionReject);
    }
  });

  ApplicationInstance.reopenClass({
    /**
     @private
     @method setupRegistry
     @param {Registry} registry
     @param {BootOptions} options
    */
    setupRegistry: function (registry) {
      var options = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

      if (!options.toEnvironment) {
        options = new BootOptions(options);
      }

      registry.register('-environment:main', options.toEnvironment(), { instantiate: false });
      registry.register('service:-document', options.document, { instantiate: false });

      this._super(registry, options);
    }
  });

  /**
    A list of boot-time configuration options for customizing the behavior of
    an `Ember.ApplicationInstance`.
  
    This is an interface class that exists purely to document the available
    options; you do not need to construct it manually. Simply pass a regular
    JavaScript object containing the desired options into methods that require
    one of these options object:
  
    ```javascript
    MyApp.visit("/", { location: "none", rootElement: "#container" });
    ```
  
    Not all combinations of the supported options are valid. See the documentation
    on `Ember.Application#visit` for the supported configurations.
  
    Internal, experimental or otherwise unstable flags are marked as private.
  
    @class BootOptions
    @namespace Ember.ApplicationInstance
    @public
  */
  BootOptions = function BootOptions() {
    var options = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

    /**
      Provide a specific instance of jQuery. This is useful in conjunction with
      the `document` option, as it allows you to use a copy of `jQuery` that is
      appropriately bound to the foreign `document` (e.g. a jsdom).
       This is highly experimental and support very incomplete at the moment.
       @property jQuery
      @type Object
      @default auto-detected
      @private
    */
    this.jQuery = _emberViews.jQuery; // This default is overridable below

    /**
      Interactive mode: whether we need to set up event delegation and invoke
      lifecycle callbacks on Components.
       @property isInteractive
      @type boolean
      @default auto-detected
      @private
    */
    this.isInteractive = _emberEnvironment.environment.hasDOM; // This default is overridable below

    /**
      Run in a full browser environment.
       When this flag is set to `false`, it will disable most browser-specific
      and interactive features. Specifically:
       * It does not use `jQuery` to append the root view; the `rootElement`
        (either specified as a subsequent option or on the application itself)
        must already be an `Element` in the given `document` (as opposed to a
        string selector).
       * It does not set up an `EventDispatcher`.
       * It does not run any `Component` lifecycle hooks (such as `didInsertElement`).
       * It sets the `location` option to `"none"`. (If you would like to use
        the location adapter specified in the app's router instead, you can also
        specify `{ location: null }` to specifically opt-out.)
       @property isBrowser
      @type boolean
      @default auto-detected
      @public
    */
    if (options.isBrowser !== undefined) {
      this.isBrowser = !!options.isBrowser;
    } else {
      this.isBrowser = _emberEnvironment.environment.hasDOM;
    }

    if (!this.isBrowser) {
      this.jQuery = null;
      this.isInteractive = false;
      this.location = 'none';
    }

    /**
      Disable rendering completely.
       When this flag is set to `true`, it will disable the entire rendering
      pipeline. Essentially, this puts the app into "routing-only" mode. No
      templates will be rendered, and no Components will be created.
       @property shouldRender
      @type boolean
      @default true
      @public
    */
    if (options.shouldRender !== undefined) {
      this.shouldRender = !!options.shouldRender;
    } else {
      this.shouldRender = true;
    }

    if (!this.shouldRender) {
      this.jQuery = null;
      this.isInteractive = false;
    }

    /**
      If present, render into the given `Document` object instead of the
      global `window.document` object.
       In practice, this is only useful in non-browser environment or in
      non-interactive mode, because Ember's `jQuery` dependency is
      implicitly bound to the current document, causing event delegation
      to not work properly when the app is rendered into a foreign
      document object (such as an iframe's `contentDocument`).
       In non-browser mode, this could be a "`Document`-like" object as
      Ember only interact with a small subset of the DOM API in non-
      interactive mode. While the exact requirements have not yet been
      formalized, the `SimpleDOM` library's implementation is known to
      work.
       @property document
      @type Document
      @default the global `document` object
      @public
    */
    if (options.document) {
      this.document = options.document;
    } else {
      this.document = typeof document !== 'undefined' ? document : null;
    }

    /**
      If present, overrides the application's `rootElement` property on
      the instance. This is useful for testing environment, where you
      might want to append the root view to a fixture area.
       In non-browser mode, because Ember does not have access to jQuery,
      this options must be specified as a DOM `Element` object instead of
      a selector string.
       See the documentation on `Ember.Applications`'s `rootElement` for
      details.
       @property rootElement
      @type String|Element
      @default null
      @public
     */
    if (options.rootElement) {
      this.rootElement = options.rootElement;
    }

    // Set these options last to give the user a chance to override the
    // defaults from the "combo" options like `isBrowser` (although in
    // practice, the resulting combination is probably invalid)

    /**
      If present, overrides the router's `location` property with this
      value. This is useful for environments where trying to modify the
      URL would be inappropriate.
       @property location
      @type string
      @default null
      @public
    */
    if (options.location !== undefined) {
      this.location = options.location;
    }

    if (options.jQuery !== undefined) {
      this.jQuery = options.jQuery;
    }

    if (options.isInteractive !== undefined) {
      this.isInteractive = !!options.isInteractive;
    }
  };

  BootOptions.prototype.toEnvironment = function () {
    var env = _emberUtils.assign({}, _emberEnvironment.environment);
    // For compatibility with existing code
    env.hasDOM = this.isBrowser;
    env.isInteractive = this.isInteractive;
    env.options = this;
    return env;
  };

  Object.defineProperty(ApplicationInstance.prototype, 'container', {
    configurable: true,
    enumerable: false,
    get: function () {
      var instance = this;
      return {
        lookup: function () {
          _emberDebug.deprecate('Using `ApplicationInstance.container.lookup` is deprecated. Please use `ApplicationInstance.lookup` instead.', false, {
            id: 'ember-application.app-instance-container',
            until: '2.13.0',
            url: 'http://emberjs.com/deprecations/v2.x/#toc_ember-applicationinstance-container'
          });
          return instance.lookup.apply(instance, arguments);
        }
      };
    }
  });

  Object.defineProperty(ApplicationInstance.prototype, 'registry', {
    configurable: true,
    enumerable: false,
    get: function () {
      return _emberRuntime.buildFakeRegistryWithDeprecations(this, 'ApplicationInstance');
    }
  });

  exports.default = ApplicationInstance;
});
enifed('ember-application/system/application', ['exports', 'ember-utils', 'ember-environment', 'ember-debug', 'ember-metal', 'ember-runtime', 'ember-views', 'ember-routing', 'ember-application/system/application-instance', 'container', 'ember-application/system/engine', 'ember-glimmer'], function (exports, _emberUtils, _emberEnvironment, _emberDebug, _emberMetal, _emberRuntime, _emberViews, _emberRouting, _emberApplicationSystemApplicationInstance, _container, _emberApplicationSystemEngine, _emberGlimmer) {
  /**
  @module ember
  @submodule ember-application
  */
  'use strict';

  var _templateObject = babelHelpers.taggedTemplateLiteralLoose(['-bucket-cache:main'], ['-bucket-cache:main']);

  var librariesRegistered = false;

  /**
    An instance of `Ember.Application` is the starting point for every Ember
    application. It helps to instantiate, initialize and coordinate the many
    objects that make up your app.
  
    Each Ember app has one and only one `Ember.Application` object. In fact, the
    very first thing you should do in your application is create the instance:
  
    ```javascript
    window.App = Ember.Application.create();
    ```
  
    Typically, the application object is the only global variable. All other
    classes in your app should be properties on the `Ember.Application` instance,
    which highlights its first role: a global namespace.
  
    For example, if you define a view class, it might look like this:
  
    ```javascript
    App.MyView = Ember.View.extend();
    ```
  
    By default, calling `Ember.Application.create()` will automatically initialize
    your application by calling the `Ember.Application.initialize()` method. If
    you need to delay initialization, you can call your app's `deferReadiness()`
    method. When you are ready for your app to be initialized, call its
    `advanceReadiness()` method.
  
    You can define a `ready` method on the `Ember.Application` instance, which
    will be run by Ember when the application is initialized.
  
    Because `Ember.Application` inherits from `Ember.Namespace`, any classes
    you create will have useful string representations when calling `toString()`.
    See the `Ember.Namespace` documentation for more information.
  
    While you can think of your `Ember.Application` as a container that holds the
    other classes in your application, there are several other responsibilities
    going on under-the-hood that you may want to understand.
  
    ### Event Delegation
  
    Ember uses a technique called _event delegation_. This allows the framework
    to set up a global, shared event listener instead of requiring each view to
    do it manually. For example, instead of each view registering its own
    `mousedown` listener on its associated element, Ember sets up a `mousedown`
    listener on the `body`.
  
    If a `mousedown` event occurs, Ember will look at the target of the event and
    start walking up the DOM node tree, finding corresponding views and invoking
    their `mouseDown` method as it goes.
  
    `Ember.Application` has a number of default events that it listens for, as
    well as a mapping from lowercase events to camel-cased view method names. For
    example, the `keypress` event causes the `keyPress` method on the view to be
    called, the `dblclick` event causes `doubleClick` to be called, and so on.
  
    If there is a bubbling browser event that Ember does not listen for by
    default, you can specify custom events and their corresponding view method
    names by setting the application's `customEvents` property:
  
    ```javascript
    let App = Ember.Application.create({
      customEvents: {
        // add support for the paste event
        paste: 'paste'
      }
    });
    ```
  
    To prevent Ember from setting up a listener for a default event,
    specify the event name with a `null` value in the `customEvents`
    property:
  
    ```javascript
    let App = Ember.Application.create({
      customEvents: {
        // prevent listeners for mouseenter/mouseleave events
        mouseenter: null,
        mouseleave: null
      }
    });
    ```
  
    By default, the application sets up these event listeners on the document
    body. However, in cases where you are embedding an Ember application inside
    an existing page, you may want it to set up the listeners on an element
    inside the body.
  
    For example, if only events inside a DOM element with the ID of `ember-app`
    should be delegated, set your application's `rootElement` property:
  
    ```javascript
    let App = Ember.Application.create({
      rootElement: '#ember-app'
    });
    ```
  
    The `rootElement` can be either a DOM element or a jQuery-compatible selector
    string. Note that *views appended to the DOM outside the root element will
    not receive events.* If you specify a custom root element, make sure you only
    append views inside it!
  
    To learn more about the events Ember components use, see
    [components/handling-events](https://guides.emberjs.com/v2.6.0/components/handling-events/#toc_event-names).
  
    ### Initializers
  
    Libraries on top of Ember can add initializers, like so:
  
    ```javascript
    Ember.Application.initializer({
      name: 'api-adapter',
  
      initialize: function(application) {
        application.register('api-adapter:main', ApiAdapter);
      }
    });
    ```
  
    Initializers provide an opportunity to access the internal registry, which
    organizes the different components of an Ember application. Additionally
    they provide a chance to access the instantiated application. Beyond
    being used for libraries, initializers are also a great way to organize
    dependency injection or setup in your own application.
  
    ### Routing
  
    In addition to creating your application's router, `Ember.Application` is
    also responsible for telling the router when to start routing. Transitions
    between routes can be logged with the `LOG_TRANSITIONS` flag, and more
    detailed intra-transition logging can be logged with
    the `LOG_TRANSITIONS_INTERNAL` flag:
  
    ```javascript
    let App = Ember.Application.create({
      LOG_TRANSITIONS: true, // basic logging of successful transitions
      LOG_TRANSITIONS_INTERNAL: true // detailed logging of all routing steps
    });
    ```
  
    By default, the router will begin trying to translate the current URL into
    application state once the browser emits the `DOMContentReady` event. If you
    need to defer routing, you can call the application's `deferReadiness()`
    method. Once routing can begin, call the `advanceReadiness()` method.
  
    If there is any setup required before routing begins, you can implement a
    `ready()` method on your app that will be invoked immediately before routing
    begins.
  
    @class Application
    @namespace Ember
    @extends Ember.Engine
    @uses RegistryProxyMixin
    @public
  */

  var Application = _emberApplicationSystemEngine.default.extend({
    /**
      The root DOM element of the Application. This can be specified as an
      element or a
      [jQuery-compatible selector string](http://api.jquery.com/category/selectors/).
       This is the element that will be passed to the Application's,
      `eventDispatcher`, which sets up the listeners for event delegation. Every
      view in your application should be a child of the element you specify here.
       @property rootElement
      @type DOMElement
      @default 'body'
      @public
    */
    rootElement: 'body',

    /**
      The `Ember.EventDispatcher` responsible for delegating events to this
      application's views.
       The event dispatcher is created by the application at initialization time
      and sets up event listeners on the DOM element described by the
      application's `rootElement` property.
       See the documentation for `Ember.EventDispatcher` for more information.
       @property eventDispatcher
      @type Ember.EventDispatcher
      @default null
      @public
    */
    eventDispatcher: null,

    /**
      The DOM events for which the event dispatcher should listen.
       By default, the application's `Ember.EventDispatcher` listens
      for a set of standard DOM events, such as `mousedown` and
      `keyup`, and delegates them to your application's `Ember.View`
      instances.
       If you would like additional bubbling events to be delegated to your
      views, set your `Ember.Application`'s `customEvents` property
      to a hash containing the DOM event name as the key and the
      corresponding view method name as the value. Setting an event to
      a value of `null` will prevent a default event listener from being
      added for that event.
       To add new events to be listened to:
       ```javascript
      let App = Ember.Application.create({
        customEvents: {
          // add support for the paste event
          paste: 'paste'
        }
      });
      ```
       To prevent default events from being listened to:
       ```javascript
      let App = Ember.Application.create({
        customEvents: {
          // remove support for mouseenter / mouseleave events
          mouseenter: null,
          mouseleave: null
        }
      });
      ```
      @property customEvents
      @type Object
      @default null
      @public
    */
    customEvents: null,

    /**
      Whether the application should automatically start routing and render
      templates to the `rootElement` on DOM ready. While default by true,
      other environments such as FastBoot or a testing harness can set this
      property to `false` and control the precise timing and behavior of the boot
      process.
       @property autoboot
      @type Boolean
      @default true
      @private
    */
    autoboot: true,

    /**
      Whether the application should be configured for the legacy "globals mode".
      Under this mode, the Application object serves as a global namespace for all
      classes.
       ```javascript
      let App = Ember.Application.create({
        ...
      });
       App.Router.reopen({
        location: 'none'
      });
       App.Router.map({
        ...
      });
       App.MyComponent = Ember.Component.extend({
        ...
      });
      ```
       This flag also exposes other internal APIs that assumes the existence of
      a special "default instance", like `App.__container__.lookup(...)`.
       This option is currently not configurable, its value is derived from
      the `autoboot` flag – disabling `autoboot` also implies opting-out of
      globals mode support, although they are ultimately orthogonal concerns.
       Some of the global modes features are already deprecated in 1.x. The
      existence of this flag is to untangle the globals mode code paths from
      the autoboot code paths, so that these legacy features can be reviewed
      for deprecation/removal separately.
       Forcing the (autoboot=true, _globalsMode=false) here and running the tests
      would reveal all the places where we are still relying on these legacy
      behavior internally (mostly just tests).
       @property _globalsMode
      @type Boolean
      @default true
      @private
    */
    _globalsMode: true,

    init: function (options) {
      this._super.apply(this, arguments);

      if (!this.$) {
        this.$ = _emberViews.jQuery;
      }

      registerLibraries();
      _emberDebug.runInDebug(function () {
        return logLibraryVersions();
      });

      // Start off the number of deferrals at 1. This will be decremented by
      // the Application's own `boot` method.
      this._readinessDeferrals = 1;
      this._booted = false;

      this.autoboot = this._globalsMode = !!this.autoboot;

      if (this._globalsMode) {
        this._prepareForGlobalsMode();
      }

      if (this.autoboot) {
        this.waitForDOMReady();
      }
    },

    /**
      Create an ApplicationInstance for this application.
       @private
      @method buildInstance
      @return {Ember.ApplicationInstance} the application instance
    */
    buildInstance: function () {
      var options = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

      options.base = this;
      options.application = this;
      return _emberApplicationSystemApplicationInstance.default.create(options);
    },

    /**
      Enable the legacy globals mode by allowing this application to act
      as a global namespace. See the docs on the `_globalsMode` property
      for details.
       Most of these features are already deprecated in 1.x, so we can
      stop using them internally and try to remove them.
       @private
      @method _prepareForGlobalsMode
    */
    _prepareForGlobalsMode: function () {
      // Create subclass of Ember.Router for this Application instance.
      // This is to ensure that someone reopening `App.Router` does not
      // tamper with the default `Ember.Router`.
      this.Router = (this.Router || _emberRouting.Router).extend();

      this._buildDeprecatedInstance();
    },

    /*
      Build the deprecated instance for legacy globals mode support.
      Called when creating and resetting the application.
       This is orthogonal to autoboot: the deprecated instance needs to
      be created at Application construction (not boot) time to expose
      App.__container__. If autoboot sees that this instance exists,
      it will continue booting it to avoid doing unncessary work (as
      opposed to building a new instance at boot time), but they are
      otherwise unrelated.
       @private
      @method _buildDeprecatedInstance
    */
    _buildDeprecatedInstance: function () {
      // Build a default instance
      var instance = this.buildInstance();

      // Legacy support for App.__container__ and other global methods
      // on App that rely on a single, default instance.
      this.__deprecatedInstance__ = instance;
      this.__container__ = instance.__container__;
    },

    /**
      Automatically kick-off the boot process for the application once the
      DOM has become ready.
       The initialization itself is scheduled on the actions queue which
      ensures that code-loading finishes before booting.
       If you are asynchronously loading code, you should call `deferReadiness()`
      to defer booting, and then call `advanceReadiness()` once all of your code
      has finished loading.
       @private
      @method waitForDOMReady
    */
    waitForDOMReady: function () {
      if (!this.$ || this.$.isReady) {
        _emberMetal.run.schedule('actions', this, 'domReady');
      } else {
        this.$().ready(_emberMetal.run.bind(this, 'domReady'));
      }
    },

    /**
      This is the autoboot flow:
       1. Boot the app by calling `this.boot()`
      2. Create an instance (or use the `__deprecatedInstance__` in globals mode)
      3. Boot the instance by calling `instance.boot()`
      4. Invoke the `App.ready()` callback
      5. Kick-off routing on the instance
       Ideally, this is all we would need to do:
       ```javascript
      _autoBoot() {
        this.boot().then(() => {
          let instance = (this._globalsMode) ? this.__deprecatedInstance__ : this.buildInstance();
          return instance.boot();
        }).then((instance) => {
          App.ready();
          instance.startRouting();
        });
      }
      ```
       Unfortunately, we cannot actually write this because we need to participate
      in the "synchronous" boot process. While the code above would work fine on
      the initial boot (i.e. DOM ready), when `App.reset()` is called, we need to
      boot a new instance synchronously (see the documentation on `_bootSync()`
      for details).
       Because of this restriction, the actual logic of this method is located
      inside `didBecomeReady()`.
       @private
      @method domReady
    */
    domReady: function () {
      if (this.isDestroyed) {
        return;
      }

      this._bootSync();

      // Continues to `didBecomeReady`
    },

    /**
      Use this to defer readiness until some condition is true.
       Example:
       ```javascript
      let App = Ember.Application.create();
       App.deferReadiness();
       // Ember.$ is a reference to the jQuery object/function
      Ember.$.getJSON('/auth-token', function(token) {
        App.token = token;
        App.advanceReadiness();
      });
      ```
       This allows you to perform asynchronous setup logic and defer
      booting your application until the setup has finished.
       However, if the setup requires a loading UI, it might be better
      to use the router for this purpose.
       @method deferReadiness
      @public
    */
    deferReadiness: function () {
      _emberDebug.assert('You must call deferReadiness on an instance of Ember.Application', this instanceof Application);
      _emberDebug.assert('You cannot defer readiness since the `ready()` hook has already been called.', this._readinessDeferrals > 0);
      this._readinessDeferrals++;
    },

    /**
      Call `advanceReadiness` after any asynchronous setup logic has completed.
      Each call to `deferReadiness` must be matched by a call to `advanceReadiness`
      or the application will never become ready and routing will not begin.
       @method advanceReadiness
      @see {Ember.Application#deferReadiness}
      @public
    */
    advanceReadiness: function () {
      _emberDebug.assert('You must call advanceReadiness on an instance of Ember.Application', this instanceof Application);
      this._readinessDeferrals--;

      if (this._readinessDeferrals === 0) {
        _emberMetal.run.once(this, this.didBecomeReady);
      }
    },

    /**
      Initialize the application and return a promise that resolves with the `Ember.Application`
      object when the boot process is complete.
       Run any application initializers and run the application load hook. These hooks may
      choose to defer readiness. For example, an authentication hook might want to defer
      readiness until the auth token has been retrieved.
       By default, this method is called automatically on "DOM ready"; however, if autoboot
      is disabled, this is automatically called when the first application instance is
      created via `visit`.
       @private
      @method boot
      @return {Promise<Ember.Application,Error>}
    */
    boot: function () {
      if (this._bootPromise) {
        return this._bootPromise;
      }

      try {
        this._bootSync();
      } catch (_) {
        // Ignore th error: in the asynchronous boot path, the error is already reflected
        // in the promise rejection
      }

      return this._bootPromise;
    },

    /**
      Unfortunately, a lot of existing code assumes the booting process is
      "synchronous". Specifically, a lot of tests assumes the last call to
      `app.advanceReadiness()` or `app.reset()` will result in the app being
      fully-booted when the current runloop completes.
       We would like new code (like the `visit` API) to stop making this assumption,
      so we created the asynchronous version above that returns a promise. But until
      we have migrated all the code, we would have to expose this method for use
      *internally* in places where we need to boot an app "synchronously".
       @private
    */
    _bootSync: function () {
      if (this._booted) {
        return;
      }

      // Even though this returns synchronously, we still need to make sure the
      // boot promise exists for book-keeping purposes: if anything went wrong in
      // the boot process, we need to store the error as a rejection on the boot
      // promise so that a future caller of `boot()` can tell what failed.
      var defer = this._bootResolver = new _emberRuntime.RSVP.defer();
      this._bootPromise = defer.promise;

      try {
        this.runInitializers();
        _emberRuntime.runLoadHooks('application', this);
        this.advanceReadiness();
        // Continues to `didBecomeReady`
      } catch (error) {
        // For the asynchronous boot path
        defer.reject(error);

        // For the synchronous boot path
        throw error;
      }
    },

    /**
      Reset the application. This is typically used only in tests. It cleans up
      the application in the following order:
       1. Deactivate existing routes
      2. Destroy all objects in the container
      3. Create a new application container
      4. Re-route to the existing url
       Typical Example:
       ```javascript
      let App;
       run(function() {
        App = Ember.Application.create();
      });
       module('acceptance test', {
        setup: function() {
          App.reset();
        }
      });
       test('first test', function() {
        // App is freshly reset
      });
       test('second test', function() {
        // App is again freshly reset
      });
      ```
       Advanced Example:
       Occasionally you may want to prevent the app from initializing during
      setup. This could enable extra configuration, or enable asserting prior
      to the app becoming ready.
       ```javascript
      let App;
       run(function() {
        App = Ember.Application.create();
      });
       module('acceptance test', {
        setup: function() {
          run(function() {
            App.reset();
            App.deferReadiness();
          });
        }
      });
       test('first test', function() {
        ok(true, 'something before app is initialized');
         run(function() {
          App.advanceReadiness();
        });
         ok(true, 'something after app is initialized');
      });
      ```
       @method reset
      @public
    */
    reset: function () {
      _emberDebug.assert('Calling reset() on instances of `Ember.Application` is not\n            supported when globals mode is disabled; call `visit()` to\n            create new `Ember.ApplicationInstance`s and dispose them\n            via their `destroy()` method instead.', this._globalsMode && this.autoboot);

      var instance = this.__deprecatedInstance__;

      this._readinessDeferrals = 1;
      this._bootPromise = null;
      this._bootResolver = null;
      this._booted = false;

      function handleReset() {
        _emberMetal.run(instance, 'destroy');
        this._buildDeprecatedInstance();
        _emberMetal.run.schedule('actions', this, '_bootSync');
      }

      _emberMetal.run.join(this, handleReset);
    },

    /**
      @private
      @method didBecomeReady
    */
    didBecomeReady: function () {
      try {
        // TODO: Is this still needed for _globalsMode = false?
        if (!_emberDebug.isTesting()) {
          // Eagerly name all classes that are already loaded
          _emberRuntime.Namespace.processAll();
          _emberRuntime.setNamespaceSearchDisabled(true);
        }

        // See documentation on `_autoboot()` for details
        if (this.autoboot) {
          var instance = undefined;

          if (this._globalsMode) {
            // If we already have the __deprecatedInstance__ lying around, boot it to
            // avoid unnecessary work
            instance = this.__deprecatedInstance__;
          } else {
            // Otherwise, build an instance and boot it. This is currently unreachable,
            // because we forced _globalsMode to === autoboot; but having this branch
            // allows us to locally toggle that flag for weeding out legacy globals mode
            // dependencies independently
            instance = this.buildInstance();
          }

          instance._bootSync();

          // TODO: App.ready() is not called when autoboot is disabled, is this correct?
          this.ready();

          instance.startRouting();
        }

        // For the asynchronous boot path
        this._bootResolver.resolve(this);

        // For the synchronous boot path
        this._booted = true;
      } catch (error) {
        // For the asynchronous boot path
        this._bootResolver.reject(error);

        // For the synchronous boot path
        throw error;
      }
    },

    /**
      Called when the Application has become ready, immediately before routing
      begins. The call will be delayed until the DOM has become ready.
       @event ready
      @public
    */
    ready: function () {
      return this;
    },

    // This method must be moved to the application instance object
    willDestroy: function () {
      this._super.apply(this, arguments);
      _emberRuntime.setNamespaceSearchDisabled(false);
      this._booted = false;
      this._bootPromise = null;
      this._bootResolver = null;

      if (_emberRuntime._loaded.application === this) {
        _emberRuntime._loaded.application = undefined;
      }

      if (this._globalsMode && this.__deprecatedInstance__) {
        this.__deprecatedInstance__.destroy();
      }
    },

    /**
      Boot a new instance of `Ember.ApplicationInstance` for the current
      application and navigate it to the given `url`. Returns a `Promise` that
      resolves with the instance when the initial routing and rendering is
      complete, or rejects with any error that occured during the boot process.
       When `autoboot` is disabled, calling `visit` would first cause the
      application to boot, which runs the application initializers.
       This method also takes a hash of boot-time configuration options for
      customizing the instance's behavior. See the documentation on
      `Ember.ApplicationInstance.BootOptions` for details.
       `Ember.ApplicationInstance.BootOptions` is an interface class that exists
      purely to document the available options; you do not need to construct it
      manually. Simply pass a regular JavaScript object containing of the
      desired options:
       ```javascript
      MyApp.visit("/", { location: "none", rootElement: "#container" });
      ```
       ### Supported Scenarios
       While the `BootOptions` class exposes a large number of knobs, not all
      combinations of them are valid; certain incompatible combinations might
      result in unexpected behavior.
       For example, booting the instance in the full browser environment
      while specifying a foriegn `document` object (e.g. `{ isBrowser: true,
      document: iframe.contentDocument }`) does not work correctly today,
      largely due to Ember's jQuery dependency.
       Currently, there are three officially supported scenarios/configurations.
      Usages outside of these scenarios are not guaranteed to work, but please
      feel free to file bug reports documenting your experience and any issues
      you encountered to help expand support.
       #### Browser Applications (Manual Boot)
       The setup is largely similar to how Ember works out-of-the-box. Normally,
      Ember will boot a default instance for your Application on "DOM ready".
      However, you can customize this behavior by disabling `autoboot`.
       For example, this allows you to render a miniture demo of your application
      into a specific area on your marketing website:
       ```javascript
      import MyApp from 'my-app';
       $(function() {
        let App = MyApp.create({ autoboot: false });
         let options = {
          // Override the router's location adapter to prevent it from updating
          // the URL in the address bar
          location: 'none',
           // Override the default `rootElement` on the app to render into a
          // specific `div` on the page
          rootElement: '#demo'
        };
         // Start the app at the special demo URL
        App.visit('/demo', options);
      });
      ````
       Or perhaps you might want to boot two instances of your app on the same
      page for a split-screen multiplayer experience:
       ```javascript
      import MyApp from 'my-app';
       $(function() {
        let App = MyApp.create({ autoboot: false });
         let sessionId = MyApp.generateSessionID();
         let player1 = App.visit(`/matches/join?name=Player+1&session=${sessionId}`, { rootElement: '#left', location: 'none' });
        let player2 = App.visit(`/matches/join?name=Player+2&session=${sessionId}`, { rootElement: '#right', location: 'none' });
         Promise.all([player1, player2]).then(() => {
          // Both apps have completed the initial render
          $('#loading').fadeOut();
        });
      });
      ```
       Do note that each app instance maintains their own registry/container, so
      they will run in complete isolation by default.
       #### Server-Side Rendering (also known as FastBoot)
       This setup allows you to run your Ember app in a server environment using
      Node.js and render its content into static HTML for SEO purposes.
       ```javascript
      const HTMLSerializer = new SimpleDOM.HTMLSerializer(SimpleDOM.voidMap);
       function renderURL(url) {
        let dom = new SimpleDOM.Document();
        let rootElement = dom.body;
        let options = { isBrowser: false, document: dom, rootElement: rootElement };
         return MyApp.visit(options).then(instance => {
          try {
            return HTMLSerializer.serialize(rootElement.firstChild);
          } finally {
            instance.destroy();
          }
        });
      }
      ```
       In this scenario, because Ember does not have access to a global `document`
      object in the Node.js environment, you must provide one explicitly. In practice,
      in the non-browser environment, the stand-in `document` object only need to
      implement a limited subset of the full DOM API. The `SimpleDOM` library is known
      to work.
       Since there is no access to jQuery in the non-browser environment, you must also
      specify a DOM `Element` object in the same `document` for the `rootElement` option
      (as opposed to a selector string like `"body"`).
       See the documentation on the `isBrowser`, `document` and `rootElement` properties
      on `Ember.ApplicationInstance.BootOptions` for details.
       #### Server-Side Resource Discovery
       This setup allows you to run the routing layer of your Ember app in a server
      environment using Node.js and completely disable rendering. This allows you
      to simulate and discover the resources (i.e. AJAX requests) needed to fufill
      a given request and eagerly "push" these resources to the client.
       ```app/initializers/network-service.js
      import BrowserNetworkService from 'app/services/network/browser';
      import NodeNetworkService from 'app/services/network/node';
       // Inject a (hypothetical) service for abstracting all AJAX calls and use
      // the appropiate implementaion on the client/server. This also allows the
      // server to log all the AJAX calls made during a particular request and use
      // that for resource-discovery purpose.
       export function initialize(application) {
        if (window) { // browser
          application.register('service:network', BrowserNetworkService);
        } else { // node
          application.register('service:network', NodeNetworkService);
        }
         application.inject('route', 'network', 'service:network');
      };
       export default {
        name: 'network-service',
        initialize: initialize
      };
      ```
       ```app/routes/post.js
      import Ember from 'ember';
       // An example of how the (hypothetical) service is used in routes.
       export default Ember.Route.extend({
        model(params) {
          return this.network.fetch(`/api/posts/${params.post_id}.json`);
        },
         afterModel(post) {
          if (post.isExternalContent) {
            return this.network.fetch(`/api/external/?url=${post.externalURL}`);
          } else {
            return post;
          }
        }
      });
      ```
       ```javascript
      // Finally, put all the pieces together
       function discoverResourcesFor(url) {
        return MyApp.visit(url, { isBrowser: false, shouldRender: false }).then(instance => {
          let networkService = instance.lookup('service:network');
          return networkService.requests; // => { "/api/posts/123.json": "..." }
        });
      }
      ```
       @public
      @method visit
      @param url {String} The initial URL to navigate to
      @param options {Ember.ApplicationInstance.BootOptions}
      @return {Promise<Ember.ApplicationInstance, Error>}
    */
    visit: function (url, options) {
      var _this = this;

      return this.boot().then(function () {
        var instance = _this.buildInstance();

        return instance.boot(options).then(function () {
          return instance.visit(url);
        }).catch(function (error) {
          _emberMetal.run(instance, 'destroy');
          throw error;
        });
      });
    }
  });

  Object.defineProperty(Application.prototype, 'registry', {
    configurable: true,
    enumerable: false,
    get: function () {
      return _emberRuntime.buildFakeRegistryWithDeprecations(this, 'Application');
    }
  });

  Application.reopenClass({
    /**
      This creates a registry with the default Ember naming conventions.
       It also configures the registry:
       * registered views are created every time they are looked up (they are
        not singletons)
      * registered templates are not factories; the registered value is
        returned directly.
      * the router receives the application as its `namespace` property
      * all controllers receive the router as their `target` and `controllers`
        properties
      * all controllers receive the application as their `namespace` property
      * the application view receives the application controller as its
        `controller` property
      * the application view receives the application template as its
        `defaultTemplate` property
       @method buildRegistry
      @static
      @param {Ember.Application} namespace the application for which to
        build the registry
      @return {Ember.Registry} the built registry
      @private
    */
    buildRegistry: function (application) {
      var options = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

      var registry = this._super.apply(this, arguments);

      commonSetupRegistry(registry);

      _emberGlimmer.setupApplicationRegistry(registry);

      return registry;
    }
  });

  function commonSetupRegistry(registry) {
    registry.register('-view-registry:main', { create: function () {
        return _emberUtils.dictionary(null);
      } });

    registry.register('route:basic', _emberRouting.Route);
    registry.register('event_dispatcher:main', _emberViews.EventDispatcher);

    registry.injection('router:main', 'namespace', 'application:main');

    registry.register('location:auto', _emberRouting.AutoLocation);
    registry.register('location:hash', _emberRouting.HashLocation);
    registry.register('location:history', _emberRouting.HistoryLocation);
    registry.register('location:none', _emberRouting.NoneLocation);

    registry.register(_container.privatize(_templateObject), _emberRouting.BucketCache);

    if (false) {
      registry.register('service:router', _emberRouting.RouterService);
      registry.injection('service:router', 'router', 'router:main');
    }
  }

  function registerLibraries() {
    if (!librariesRegistered) {
      librariesRegistered = true;

      if (_emberEnvironment.environment.hasDOM && typeof _emberViews.jQuery === 'function') {
        _emberMetal.libraries.registerCoreLibrary('jQuery', _emberViews.jQuery().jquery);
      }
    }
  }

  function logLibraryVersions() {
    var _this2 = this;

    _emberDebug.runInDebug(function () {
      if (_emberEnvironment.ENV.LOG_VERSION) {
        // we only need to see this once per Application#init
        _emberEnvironment.ENV.LOG_VERSION = false;
        var libs = _emberMetal.libraries._registry;

        var nameLengths = libs.map(function (item) {
          return _emberMetal.get(item, 'name.length');
        });

        var maxNameLength = Math.max.apply(_this2, nameLengths);

        _emberDebug.debug('-------------------------------');
        for (var i = 0; i < libs.length; i++) {
          var lib = libs[i];
          var spaces = new Array(maxNameLength - lib.name.length + 1).join(' ');
          _emberDebug.debug([lib.name, spaces, ' : ', lib.version].join(''));
        }
        _emberDebug.debug('-------------------------------');
      }
    });
  }

  exports.default = Application;
});
enifed('ember-application/system/engine-instance', ['exports', 'ember-utils', 'ember-runtime', 'ember-debug', 'ember-metal', 'container', 'ember-application/system/engine-parent'], function (exports, _emberUtils, _emberRuntime, _emberDebug, _emberMetal, _container, _emberApplicationSystemEngineParent) {
  /**
  @module ember
  @submodule ember-application
  */

  'use strict';

  var _EmberObject$extend;

  var _templateObject = babelHelpers.taggedTemplateLiteralLoose(['-bucket-cache:main'], ['-bucket-cache:main']);

  /**
    The `EngineInstance` encapsulates all of the stateful aspects of a
    running `Engine`.
  
    @public
    @class Ember.EngineInstance
    @extends Ember.Object
    @uses RegistryProxyMixin
    @uses ContainerProxyMixin
  */

  var EngineInstance = _emberRuntime.Object.extend(_emberRuntime.RegistryProxyMixin, _emberRuntime.ContainerProxyMixin, (_EmberObject$extend = {
    /**
      The base `Engine` for which this is an instance.
       @property {Ember.Engine} engine
      @private
    */
    base: null,

    init: function () {
      this._super.apply(this, arguments);

      _emberUtils.guidFor(this);

      var base = this.base;

      if (!base) {
        base = this.application;
        this.base = base;
      }

      // Create a per-instance registry that will use the application's registry
      // as a fallback for resolving registrations.
      var registry = this.__registry__ = new _container.Registry({
        fallback: base.__registry__
      });

      // Create a per-instance container from the instance's registry
      this.__container__ = registry.container({ owner: this });

      this._booted = false;
    },

    /**
      Initialize the `Ember.EngineInstance` and return a promise that resolves
      with the instance itself when the boot process is complete.
       The primary task here is to run any registered instance initializers.
       See the documentation on `BootOptions` for the options it takes.
       @private
      @method boot
      @param options {Object}
      @return {Promise<Ember.EngineInstance,Error>}
    */
    boot: function (options) {
      var _this = this;

      if (this._bootPromise) {
        return this._bootPromise;
      }

      this._bootPromise = new _emberRuntime.RSVP.Promise(function (resolve) {
        return resolve(_this._bootSync(options));
      });

      return this._bootPromise;
    },

    /**
      Unfortunately, a lot of existing code assumes booting an instance is
      synchronous – specifically, a lot of tests assume the last call to
      `app.advanceReadiness()` or `app.reset()` will result in a new instance
      being fully-booted when the current runloop completes.
       We would like new code (like the `visit` API) to stop making this
      assumption, so we created the asynchronous version above that returns a
      promise. But until we have migrated all the code, we would have to expose
      this method for use *internally* in places where we need to boot an instance
      synchronously.
       @private
    */
    _bootSync: function (options) {
      if (this._booted) {
        return this;
      }

      _emberDebug.assert('An engine instance\'s parent must be set via `setEngineParent(engine, parent)` prior to calling `engine.boot()`.', _emberApplicationSystemEngineParent.getEngineParent(this));

      this.cloneParentDependencies();

      this.setupRegistry(options);

      this.base.runInstanceInitializers(this);

      this._booted = true;

      return this;
    },

    setupRegistry: function () {
      var options = arguments.length <= 0 || arguments[0] === undefined ? this.__container__.lookup('-environment:main') : arguments[0];

      this.constructor.setupRegistry(this.__registry__, options);
    },

    /**
     Unregister a factory.
      Overrides `RegistryProxy#unregister` in order to clear any cached instances
     of the unregistered factory.
      @public
     @method unregister
     @param {String} fullName
     */
    unregister: function (fullName) {
      this.__container__.reset(fullName);
      this._super.apply(this, arguments);
    },

    /**
      Build a new `Ember.EngineInstance` that's a child of this instance.
       Engines must be registered by name with their parent engine
      (or application).
       @private
      @method buildChildEngineInstance
      @param name {String} the registered name of the engine.
      @param options {Object} options provided to the engine instance.
      @return {Ember.EngineInstance,Error}
    */
    buildChildEngineInstance: function (name) {
      var options = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

      var Engine = this.lookup('engine:' + name);

      if (!Engine) {
        throw new _emberDebug.Error('You attempted to mount the engine \'' + name + '\', but it is not registered with its parent.');
      }

      var engineInstance = Engine.buildInstance(options);

      _emberApplicationSystemEngineParent.setEngineParent(engineInstance, this);

      return engineInstance;
    },

    /**
      Clone dependencies shared between an engine instance and its parent.
       @private
      @method cloneParentDependencies
    */
    cloneParentDependencies: function () {
      var _this2 = this;

      var parent = _emberApplicationSystemEngineParent.getEngineParent(this);

      var registrations = ['route:basic', 'event_dispatcher:main', 'service:-routing', 'service:-glimmer-environment'];

      registrations.forEach(function (key) {
        return _this2.register(key, parent.resolveRegistration(key));
      });

      var env = parent.lookup('-environment:main');
      this.register('-environment:main', env, { instantiate: false });

      var singletons = ['router:main', _container.privatize(_templateObject), '-view-registry:main', 'renderer:-' + (env.isInteractive ? 'dom' : 'inert'), 'service:-document'];

      singletons.forEach(function (key) {
        return _this2.register(key, parent.lookup(key), { instantiate: false });
      });

      this.inject('view', '_environment', '-environment:main');
      this.inject('route', '_environment', '-environment:main');
    }

  }, _EmberObject$extend[_container.FACTORY_FOR] = function (fullName, options) {
    return this.__container__[_container.FACTORY_FOR](fullName, options);
  }, _EmberObject$extend[_container.LOOKUP_FACTORY] = function (fullName, options) {
    return this.__container__[_container.LOOKUP_FACTORY](fullName, options);
  }, _EmberObject$extend));

  EngineInstance.reopenClass({
    /**
     @private
     @method setupRegistry
     @param {Registry} registry
     @param {BootOptions} options
     */
    setupRegistry: function (registry, options) {
      // when no options/environment is present, do nothing
      if (!options) {
        return;
      }

      registry.injection('view', '_environment', '-environment:main');
      registry.injection('route', '_environment', '-environment:main');

      if (options.isInteractive) {
        registry.injection('view', 'renderer', 'renderer:-dom');
        registry.injection('component', 'renderer', 'renderer:-dom');
      } else {
        registry.injection('view', 'renderer', 'renderer:-inert');
        registry.injection('component', 'renderer', 'renderer:-inert');
      }
    }
  });

  exports.default = EngineInstance;
});
enifed('ember-application/system/engine-parent', ['exports', 'ember-utils'], function (exports, _emberUtils) {
  'use strict';

  exports.getEngineParent = getEngineParent;
  exports.setEngineParent = setEngineParent;
  var ENGINE_PARENT = _emberUtils.symbol('ENGINE_PARENT');

  exports.ENGINE_PARENT = ENGINE_PARENT;
  /**
    `getEngineParent` retrieves an engine instance's parent instance.
  
    @method getEngineParent
    @param {EngineInstance} engine An engine instance.
    @return {EngineInstance} The parent engine instance.
    @for Ember
    @public
  */

  function getEngineParent(engine) {
    return engine[ENGINE_PARENT];
  }

  /**
    `setEngineParent` sets an engine instance's parent instance.
  
    @method setEngineParent
    @param {EngineInstance} engine An engine instance.
    @param {EngineInstance} parent The parent engine instance.
    @private
  */

  function setEngineParent(engine, parent) {
    engine[ENGINE_PARENT] = parent;
  }
});
enifed('ember-application/system/engine', ['exports', 'ember-utils', 'ember-runtime', 'container', 'dag-map', 'ember-debug', 'ember-metal', 'ember-application/system/resolver', 'ember-application/system/engine-instance', 'ember-routing', 'ember-extension-support', 'ember-views', 'ember-glimmer'], function (exports, _emberUtils, _emberRuntime, _container, _dagMap, _emberDebug, _emberMetal, _emberApplicationSystemResolver, _emberApplicationSystemEngineInstance, _emberRouting, _emberExtensionSupport, _emberViews, _emberGlimmer) {
  /**
  @module ember
  @submodule ember-application
  */
  'use strict';

  var _templateObject = babelHelpers.taggedTemplateLiteralLoose(['-bucket-cache:main'], ['-bucket-cache:main']);

  function props(obj) {
    var properties = [];

    for (var key in obj) {
      properties.push(key);
    }

    return properties;
  }

  /**
    The `Engine` class contains core functionality for both applications and
    engines.
  
    Each engine manages a registry that's used for dependency injection and
    exposed through `RegistryProxy`.
  
    Engines also manage initializers and instance initializers.
  
    Engines can spawn `EngineInstance` instances via `buildInstance()`.
  
    @class Engine
    @namespace Ember
    @extends Ember.Namespace
    @uses RegistryProxy
    @public
  */
  var Engine = _emberRuntime.Namespace.extend(_emberRuntime.RegistryProxyMixin, {
    init: function () {
      this._super.apply(this, arguments);

      this.buildRegistry();
    },

    /**
      A private flag indicating whether an engine's initializers have run yet.
       @private
      @property _initializersRan
    */
    _initializersRan: false,

    /**
      Ensure that initializers are run once, and only once, per engine.
       @private
      @method ensureInitializers
    */
    ensureInitializers: function () {
      if (!this._initializersRan) {
        this.runInitializers();
        this._initializersRan = true;
      }
    },

    /**
      Create an EngineInstance for this engine.
       @private
      @method buildInstance
      @return {Ember.EngineInstance} the engine instance
    */
    buildInstance: function () {
      var options = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

      this.ensureInitializers();
      options.base = this;
      return _emberApplicationSystemEngineInstance.default.create(options);
    },

    /**
      Build and configure the registry for the current engine.
       @private
      @method buildRegistry
      @return {Ember.Registry} the configured registry
    */
    buildRegistry: function () {
      var registry = this.__registry__ = this.constructor.buildRegistry(this);

      return registry;
    },

    /**
      @private
      @method initializer
    */
    initializer: function (options) {
      this.constructor.initializer(options);
    },

    /**
      @private
      @method instanceInitializer
    */
    instanceInitializer: function (options) {
      this.constructor.instanceInitializer(options);
    },

    /**
      @private
      @method runInitializers
    */
    runInitializers: function () {
      var _this = this;

      this._runInitializer('initializers', function (name, initializer) {
        _emberDebug.assert('No application initializer named \'' + name + '\'', !!initializer);
        if (initializer.initialize.length === 2) {
          _emberDebug.deprecate('The `initialize` method for Application initializer \'' + name + '\' should take only one argument - `App`, an instance of an `Application`.', false, {
            id: 'ember-application.app-initializer-initialize-arguments',
            until: '3.0.0',
            url: 'http://emberjs.com/deprecations/v2.x/#toc_initializer-arity'
          });

          initializer.initialize(_this.__registry__, _this);
        } else {
          initializer.initialize(_this);
        }
      });
    },

    /**
      @private
      @since 1.12.0
      @method runInstanceInitializers
    */
    runInstanceInitializers: function (instance) {
      this._runInitializer('instanceInitializers', function (name, initializer) {
        _emberDebug.assert('No instance initializer named \'' + name + '\'', !!initializer);
        initializer.initialize(instance);
      });
    },

    _runInitializer: function (bucketName, cb) {
      var initializersByName = _emberMetal.get(this.constructor, bucketName);
      var initializers = props(initializersByName);
      var graph = new _dagMap.default();
      var initializer = undefined;

      for (var i = 0; i < initializers.length; i++) {
        initializer = initializersByName[initializers[i]];
        graph.add(initializer.name, initializer, initializer.before, initializer.after);
      }

      graph.topsort(cb);
    }
  });

  Engine.reopenClass({
    initializers: Object.create(null),
    instanceInitializers: Object.create(null),

    /**
      The goal of initializers should be to register dependencies and injections.
      This phase runs once. Because these initializers may load code, they are
      allowed to defer application readiness and advance it. If you need to access
      the container or store you should use an InstanceInitializer that will be run
      after all initializers and therefore after all code is loaded and the app is
      ready.
       Initializer receives an object which has the following attributes:
      `name`, `before`, `after`, `initialize`. The only required attribute is
      `initialize`, all others are optional.
       * `name` allows you to specify under which name the initializer is registered.
      This must be a unique name, as trying to register two initializers with the
      same name will result in an error.
       ```javascript
      Ember.Application.initializer({
        name: 'namedInitializer',
         initialize: function(application) {
          Ember.debug('Running namedInitializer!');
        }
      });
      ```
       * `before` and `after` are used to ensure that this initializer is ran prior
      or after the one identified by the value. This value can be a single string
      or an array of strings, referencing the `name` of other initializers.
       An example of ordering initializers, we create an initializer named `first`:
       ```javascript
      Ember.Application.initializer({
        name: 'first',
         initialize: function(application) {
          Ember.debug('First initializer!');
        }
      });
       // DEBUG: First initializer!
      ```
       We add another initializer named `second`, specifying that it should run
      after the initializer named `first`:
       ```javascript
      Ember.Application.initializer({
        name: 'second',
        after: 'first',
         initialize: function(application) {
          Ember.debug('Second initializer!');
        }
      });
       // DEBUG: First initializer!
      // DEBUG: Second initializer!
      ```
       Afterwards we add a further initializer named `pre`, this time specifying
      that it should run before the initializer named `first`:
       ```javascript
      Ember.Application.initializer({
        name: 'pre',
        before: 'first',
         initialize: function(application) {
          Ember.debug('Pre initializer!');
        }
      });
       // DEBUG: Pre initializer!
      // DEBUG: First initializer!
      // DEBUG: Second initializer!
      ```
       Finally we add an initializer named `post`, specifying it should run after
      both the `first` and the `second` initializers:
       ```javascript
      Ember.Application.initializer({
        name: 'post',
        after: ['first', 'second'],
         initialize: function(application) {
          Ember.debug('Post initializer!');
        }
      });
       // DEBUG: Pre initializer!
      // DEBUG: First initializer!
      // DEBUG: Second initializer!
      // DEBUG: Post initializer!
      ```
       * `initialize` is a callback function that receives one argument,
        `application`, on which you can operate.
       Example of using `application` to register an adapter:
       ```javascript
      Ember.Application.initializer({
        name: 'api-adapter',
         initialize: function(application) {
          application.register('api-adapter:main', ApiAdapter);
        }
      });
      ```
       @method initializer
      @param initializer {Object}
      @public
    */

    initializer: buildInitializerMethod('initializers', 'initializer'),

    /**
      Instance initializers run after all initializers have run. Because
      instance initializers run after the app is fully set up. We have access
      to the store, container, and other items. However, these initializers run
      after code has loaded and are not allowed to defer readiness.
       Instance initializer receives an object which has the following attributes:
      `name`, `before`, `after`, `initialize`. The only required attribute is
      `initialize`, all others are optional.
       * `name` allows you to specify under which name the instanceInitializer is
      registered. This must be a unique name, as trying to register two
      instanceInitializer with the same name will result in an error.
       ```javascript
      Ember.Application.instanceInitializer({
        name: 'namedinstanceInitializer',
         initialize: function(application) {
          Ember.debug('Running namedInitializer!');
        }
      });
      ```
       * `before` and `after` are used to ensure that this initializer is ran prior
      or after the one identified by the value. This value can be a single string
      or an array of strings, referencing the `name` of other initializers.
       * See Ember.Application.initializer for discussion on the usage of before
      and after.
       Example instanceInitializer to preload data into the store.
       ```javascript
      Ember.Application.initializer({
        name: 'preload-data',
         initialize: function(application) {
          var userConfig, userConfigEncoded, store;
          // We have a HTML escaped JSON representation of the user's basic
          // configuration generated server side and stored in the DOM of the main
          // index.html file. This allows the app to have access to a set of data
          // without making any additional remote calls. Good for basic data that is
          // needed for immediate rendering of the page. Keep in mind, this data,
          // like all local models and data can be manipulated by the user, so it
          // should not be relied upon for security or authorization.
          //
          // Grab the encoded data from the meta tag
          userConfigEncoded = Ember.$('head meta[name=app-user-config]').attr('content');
          // Unescape the text, then parse the resulting JSON into a real object
          userConfig = JSON.parse(unescape(userConfigEncoded));
          // Lookup the store
          store = application.lookup('service:store');
          // Push the encoded JSON into the store
          store.pushPayload(userConfig);
        }
      });
      ```
       @method instanceInitializer
      @param instanceInitializer
      @public
    */
    instanceInitializer: buildInitializerMethod('instanceInitializers', 'instance initializer'),

    /**
      This creates a registry with the default Ember naming conventions.
       It also configures the registry:
       * registered views are created every time they are looked up (they are
        not singletons)
      * registered templates are not factories; the registered value is
        returned directly.
      * the router receives the application as its `namespace` property
      * all controllers receive the router as their `target` and `controllers`
        properties
      * all controllers receive the application as their `namespace` property
      * the application view receives the application controller as its
        `controller` property
      * the application view receives the application template as its
        `defaultTemplate` property
       @method buildRegistry
      @static
      @param {Ember.Application} namespace the application for which to
        build the registry
      @return {Ember.Registry} the built registry
      @private
    */
    buildRegistry: function (namespace) {
      var options = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

      var registry = new _container.Registry({
        resolver: resolverFor(namespace)
      });

      registry.set = _emberMetal.set;

      registry.register('application:main', namespace, { instantiate: false });

      commonSetupRegistry(registry);
      _emberGlimmer.setupEngineRegistry(registry);

      return registry;
    },

    /**
      Set this to provide an alternate class to `Ember.DefaultResolver`
        @deprecated Use 'Resolver' instead
      @property resolver
      @public
    */
    resolver: null,

    /**
      Set this to provide an alternate class to `Ember.DefaultResolver`
       @property resolver
      @public
    */
    Resolver: null
  });

  /**
    This function defines the default lookup rules for container lookups:
  
    * templates are looked up on `Ember.TEMPLATES`
    * other names are looked up on the application after classifying the name.
      For example, `controller:post` looks up `App.PostController` by default.
    * if the default lookup fails, look for registered classes on the container
  
    This allows the application to register default injections in the container
    that could be overridden by the normal naming convention.
  
    @private
    @method resolverFor
    @param {Ember.Namespace} namespace the namespace to look for classes
    @return {*} the resolved value for a given lookup
  */
  function resolverFor(namespace) {
    var ResolverClass = namespace.get('Resolver') || _emberApplicationSystemResolver.default;

    return ResolverClass.create({
      namespace: namespace
    });
  }

  function buildInitializerMethod(bucketName, humanName) {
    return function (initializer) {
      // If this is the first initializer being added to a subclass, we are going to reopen the class
      // to make sure we have a new `initializers` object, which extends from the parent class' using
      // prototypal inheritance. Without this, attempting to add initializers to the subclass would
      // pollute the parent class as well as other subclasses.
      if (this.superclass[bucketName] !== undefined && this.superclass[bucketName] === this[bucketName]) {
        var attrs = {};
        attrs[bucketName] = Object.create(this[bucketName]);
        this.reopenClass(attrs);
      }

      _emberDebug.assert('The ' + humanName + ' \'' + initializer.name + '\' has already been registered', !this[bucketName][initializer.name]);
      _emberDebug.assert('An ' + humanName + ' cannot be registered without an initialize function', _emberUtils.canInvoke(initializer, 'initialize'));
      _emberDebug.assert('An ' + humanName + ' cannot be registered without a name property', initializer.name !== undefined);

      this[bucketName][initializer.name] = initializer;
    };
  }

  function commonSetupRegistry(registry) {
    registry.optionsForType('component', { singleton: false });
    registry.optionsForType('view', { singleton: false });

    registry.register('controller:basic', _emberRuntime.Controller, { instantiate: false });

    registry.injection('view', '_viewRegistry', '-view-registry:main');
    registry.injection('renderer', '_viewRegistry', '-view-registry:main');
    registry.injection('event_dispatcher:main', '_viewRegistry', '-view-registry:main');

    registry.injection('route', '_topLevelViewTemplate', 'template:-outlet');

    registry.injection('view:-outlet', 'namespace', 'application:main');

    registry.injection('controller', 'target', 'router:main');
    registry.injection('controller', 'namespace', 'application:main');

    registry.injection('router', '_bucketCache', _container.privatize(_templateObject));
    registry.injection('route', '_bucketCache', _container.privatize(_templateObject));

    registry.injection('route', 'router', 'router:main');

    // Register the routing service...
    registry.register('service:-routing', _emberRouting.RoutingService);
    // Then inject the app router into it
    registry.injection('service:-routing', 'router', 'router:main');

    // DEBUGGING
    registry.register('resolver-for-debugging:main', registry.resolver, { instantiate: false });
    registry.injection('container-debug-adapter:main', 'resolver', 'resolver-for-debugging:main');
    registry.injection('data-adapter:main', 'containerDebugAdapter', 'container-debug-adapter:main');
    // Custom resolver authors may want to register their own ContainerDebugAdapter with this key

    registry.register('container-debug-adapter:main', _emberExtensionSupport.ContainerDebugAdapter);

    registry.register('component-lookup:main', _emberViews.ComponentLookup);
  }

  exports.default = Engine;
});
enifed('ember-application/system/resolver', ['exports', 'ember-utils', 'ember-metal', 'ember-debug', 'ember-runtime', 'ember-application/utils/validate-type', 'ember-glimmer'], function (exports, _emberUtils, _emberMetal, _emberDebug, _emberRuntime, _emberApplicationUtilsValidateType, _emberGlimmer) {
  /**
  @module ember
  @submodule ember-application
  */

  'use strict';

  var Resolver = _emberRuntime.Object.extend({
    /*
      This will be set to the Application instance when it is
      created.
       @property namespace
    */
    namespace: null,
    normalize: null, // required
    resolve: null, // required
    parseName: null, // required
    lookupDescription: null, // required
    makeToString: null, // required
    resolveOther: null, // required
    _logLookup: null // required
  });

  exports.Resolver = Resolver;
  /**
    The DefaultResolver defines the default lookup rules to resolve
    container lookups before consulting the container for registered
    items:
  
    * templates are looked up on `Ember.TEMPLATES`
    * other names are looked up on the application after converting
      the name. For example, `controller:post` looks up
      `App.PostController` by default.
    * there are some nuances (see examples below)
  
    ### How Resolving Works
  
    The container calls this object's `resolve` method with the
    `fullName` argument.
  
    It first parses the fullName into an object using `parseName`.
  
    Then it checks for the presence of a type-specific instance
    method of the form `resolve[Type]` and calls it if it exists.
    For example if it was resolving 'template:post', it would call
    the `resolveTemplate` method.
  
    Its last resort is to call the `resolveOther` method.
  
    The methods of this object are designed to be easy to override
    in a subclass. For example, you could enhance how a template
    is resolved like so:
  
    ```javascript
    App = Ember.Application.create({
      Resolver: Ember.DefaultResolver.extend({
        resolveTemplate: function(parsedName) {
          let resolvedTemplate = this._super(parsedName);
          if (resolvedTemplate) { return resolvedTemplate; }
          return Ember.TEMPLATES['not_found'];
        }
      })
    });
    ```
  
    Some examples of how names are resolved:
  
    ```
    'template:post'           //=> Ember.TEMPLATES['post']
    'template:posts/byline'   //=> Ember.TEMPLATES['posts/byline']
    'template:posts.byline'   //=> Ember.TEMPLATES['posts/byline']
    'template:blogPost'       //=> Ember.TEMPLATES['blogPost']
                              //   OR
                              //   Ember.TEMPLATES['blog_post']
    'controller:post'         //=> App.PostController
    'controller:posts.index'  //=> App.PostsIndexController
    'controller:blog/post'    //=> Blog.PostController
    'controller:basic'        //=> Ember.Controller
    'route:post'              //=> App.PostRoute
    'route:posts.index'       //=> App.PostsIndexRoute
    'route:blog/post'         //=> Blog.PostRoute
    'route:basic'             //=> Ember.Route
    'view:post'               //=> App.PostView
    'view:posts.index'        //=> App.PostsIndexView
    'view:blog/post'          //=> Blog.PostView
    'view:basic'              //=> Ember.View
    'foo:post'                //=> App.PostFoo
    'model:post'              //=> App.Post
    ```
  
    @class DefaultResolver
    @namespace Ember
    @extends Ember.Object
    @public
  */

  exports.default = _emberRuntime.Object.extend({
    /**
      This will be set to the Application instance when it is
      created.
       @property namespace
      @public
    */
    namespace: null,

    init: function () {
      this._parseNameCache = _emberUtils.dictionary(null);
    },
    normalize: function (fullName) {
      var _fullName$split = fullName.split(':', 2);

      var type = _fullName$split[0];
      var name = _fullName$split[1];

      _emberDebug.assert('Tried to normalize a container name without a colon (:) in it. ' + 'You probably tried to lookup a name that did not contain a type, ' + 'a colon, and a name. A proper lookup name would be `view:post`.', fullName.split(':').length === 2);

      if (type !== 'template') {
        var result = name;

        if (result.indexOf('.') > -1) {
          result = result.replace(/\.(.)/g, function (m) {
            return m.charAt(1).toUpperCase();
          });
        }

        if (name.indexOf('_') > -1) {
          result = result.replace(/_(.)/g, function (m) {
            return m.charAt(1).toUpperCase();
          });
        }

        if (name.indexOf('-') > -1) {
          result = result.replace(/-(.)/g, function (m) {
            return m.charAt(1).toUpperCase();
          });
        }

        return type + ':' + result;
      } else {
        return fullName;
      }
    },

    /**
      This method is called via the container's resolver method.
      It parses the provided `fullName` and then looks up and
      returns the appropriate template or class.
       @method resolve
      @param {String} fullName the lookup string
      @return {Object} the resolved factory
      @public
    */
    resolve: function (fullName) {
      var _this = this;

      var parsedName = this.parseName(fullName);
      var resolveMethodName = parsedName.resolveMethodName;
      var resolved = undefined;

      if (this[resolveMethodName]) {
        resolved = this[resolveMethodName](parsedName);
      }

      resolved = resolved || this.resolveOther(parsedName);

      _emberDebug.runInDebug(function () {
        if (parsedName.root && parsedName.root.LOG_RESOLVER) {
          _this._logLookup(resolved, parsedName);
        }
      });

      if (resolved) {
        _emberApplicationUtilsValidateType.default(resolved, parsedName);
      }

      return resolved;
    },

    /**
      Convert the string name of the form 'type:name' to
      a Javascript object with the parsed aspects of the name
      broken out.
       @param {String} fullName the lookup string
      @method parseName
      @protected
    */

    parseName: function (fullName) {
      return this._parseNameCache[fullName] || (this._parseNameCache[fullName] = this._parseName(fullName));
    },

    _parseName: function (fullName) {
      var _fullName$split2 = fullName.split(':');

      var type = _fullName$split2[0];
      var fullNameWithoutType = _fullName$split2[1];

      var name = fullNameWithoutType;
      var namespace = _emberMetal.get(this, 'namespace');
      var root = namespace;
      var lastSlashIndex = name.lastIndexOf('/');
      var dirname = lastSlashIndex !== -1 ? name.slice(0, lastSlashIndex) : null;

      if (type !== 'template' && lastSlashIndex !== -1) {
        var parts = name.split('/');
        name = parts[parts.length - 1];
        var namespaceName = _emberRuntime.String.capitalize(parts.slice(0, -1).join('.'));
        root = _emberRuntime.Namespace.byName(namespaceName);

        _emberDebug.assert('You are looking for a ' + name + ' ' + type + ' in the ' + namespaceName + ' namespace, but the namespace could not be found', root);
      }

      var resolveMethodName = fullNameWithoutType === 'main' ? 'Main' : _emberRuntime.String.classify(type);

      if (!(name && type)) {
        throw new TypeError('Invalid fullName: `' + fullName + '`, must be of the form `type:name` ');
      }

      return {
        fullName: fullName,
        type: type,
        fullNameWithoutType: fullNameWithoutType,
        dirname: dirname,
        name: name,
        root: root,
        resolveMethodName: 'resolve' + resolveMethodName
      };
    },

    /**
      Returns a human-readable description for a fullName. Used by the
      Application namespace in assertions to describe the
      precise name of the class that Ember is looking for, rather than
      container keys.
       @param {String} fullName the lookup string
      @method lookupDescription
      @protected
    */
    lookupDescription: function (fullName) {
      var parsedName = this.parseName(fullName);
      var description = undefined;

      if (parsedName.type === 'template') {
        return 'template at ' + parsedName.fullNameWithoutType.replace(/\./g, '/');
      }

      description = parsedName.root + '.' + _emberRuntime.String.classify(parsedName.name).replace(/\./g, '');

      if (parsedName.type !== 'model') {
        description += _emberRuntime.String.classify(parsedName.type);
      }

      return description;
    },

    makeToString: function (factory, fullName) {
      return factory.toString();
    },

    /**
      Given a parseName object (output from `parseName`), apply
      the conventions expected by `Ember.Router`
       @param {Object} parsedName a parseName object with the parsed
        fullName lookup string
      @method useRouterNaming
      @protected
    */
    useRouterNaming: function (parsedName) {
      parsedName.name = parsedName.name.replace(/\./g, '_');
      if (parsedName.name === 'basic') {
        parsedName.name = '';
      }
    },
    /**
      Look up the template in Ember.TEMPLATES
       @param {Object} parsedName a parseName object with the parsed
        fullName lookup string
      @method resolveTemplate
      @protected
    */
    resolveTemplate: function (parsedName) {
      var templateName = parsedName.fullNameWithoutType.replace(/\./g, '/');

      return _emberGlimmer.getTemplate(templateName) || _emberGlimmer.getTemplate(_emberRuntime.String.decamelize(templateName));
    },

    /**
      Lookup the view using `resolveOther`
       @param {Object} parsedName a parseName object with the parsed
        fullName lookup string
      @method resolveView
      @protected
    */
    resolveView: function (parsedName) {
      this.useRouterNaming(parsedName);
      return this.resolveOther(parsedName);
    },

    /**
      Lookup the controller using `resolveOther`
       @param {Object} parsedName a parseName object with the parsed
        fullName lookup string
      @method resolveController
      @protected
    */
    resolveController: function (parsedName) {
      this.useRouterNaming(parsedName);
      return this.resolveOther(parsedName);
    },
    /**
      Lookup the route using `resolveOther`
       @param {Object} parsedName a parseName object with the parsed
        fullName lookup string
      @method resolveRoute
      @protected
    */
    resolveRoute: function (parsedName) {
      this.useRouterNaming(parsedName);
      return this.resolveOther(parsedName);
    },

    /**
      Lookup the model on the Application namespace
       @param {Object} parsedName a parseName object with the parsed
        fullName lookup string
      @method resolveModel
      @protected
    */
    resolveModel: function (parsedName) {
      var className = _emberRuntime.String.classify(parsedName.name);
      var factory = _emberMetal.get(parsedName.root, className);

      return factory;
    },
    /**
      Look up the specified object (from parsedName) on the appropriate
      namespace (usually on the Application)
       @param {Object} parsedName a parseName object with the parsed
        fullName lookup string
      @method resolveHelper
      @protected
    */
    resolveHelper: function (parsedName) {
      return this.resolveOther(parsedName);
    },
    /**
      Look up the specified object (from parsedName) on the appropriate
      namespace (usually on the Application)
       @param {Object} parsedName a parseName object with the parsed
        fullName lookup string
      @method resolveOther
      @protected
    */
    resolveOther: function (parsedName) {
      var className = _emberRuntime.String.classify(parsedName.name) + _emberRuntime.String.classify(parsedName.type);
      var factory = _emberMetal.get(parsedName.root, className);
      return factory;
    },

    resolveMain: function (parsedName) {
      var className = _emberRuntime.String.classify(parsedName.type);
      return _emberMetal.get(parsedName.root, className);
    },

    /**
     @method _logLookup
     @param {Boolean} found
     @param {Object} parsedName
     @private
    */
    _logLookup: function (found, parsedName) {
      var symbol = undefined,
          padding = undefined;

      if (found) {
        symbol = '[✓]';
      } else {
        symbol = '[ ]';
      }

      if (parsedName.fullName.length > 60) {
        padding = '.';
      } else {
        padding = new Array(60 - parsedName.fullName.length).join('.');
      }

      _emberDebug.info(symbol, parsedName.fullName, padding, this.lookupDescription(parsedName.fullName));
    },

    /**
     Used to iterate all items of a given type.
      @method knownForType
     @param {String} type the type to search for
     @private
     */
    knownForType: function (type) {
      var namespace = _emberMetal.get(this, 'namespace');
      var suffix = _emberRuntime.String.classify(type);
      var typeRegexp = new RegExp(suffix + '$');

      var known = _emberUtils.dictionary(null);
      var knownKeys = Object.keys(namespace);
      for (var index = 0; index < knownKeys.length; index++) {
        var _name = knownKeys[index];

        if (typeRegexp.test(_name)) {
          var containerName = this.translateToContainerFullname(type, _name);

          known[containerName] = true;
        }
      }

      return known;
    },

    /**
     Converts provided name from the backing namespace into a container lookup name.
      Examples:
      App.FooBarHelper -> helper:foo-bar
     App.THelper -> helper:t
      @method translateToContainerFullname
     @param {String} type
     @param {String} name
     @private
     */

    translateToContainerFullname: function (type, name) {
      var suffix = _emberRuntime.String.classify(type);
      var namePrefix = name.slice(0, suffix.length * -1);
      var dasherizedName = _emberRuntime.String.dasherize(namePrefix);

      return type + ':' + dasherizedName;
    }
  });
});
enifed('ember-application/utils/validate-type', ['exports', 'ember-debug'], function (exports, _emberDebug) {
  /**
  @module ember
  @submodule ember-application
  */

  'use strict';

  exports.default = validateType;

  var VALIDATED_TYPES = {
    route: ['assert', 'isRouteFactory', 'Ember.Route'],
    component: ['deprecate', 'isComponentFactory', 'Ember.Component'],
    view: ['deprecate', 'isViewFactory', 'Ember.View'],
    service: ['deprecate', 'isServiceFactory', 'Ember.Service']
  };

  function validateType(resolvedType, parsedName) {
    var validationAttributes = VALIDATED_TYPES[parsedName.type];

    if (!validationAttributes) {
      return;
    }

    var action = validationAttributes[0];
    var factoryFlag = validationAttributes[1];
    var expectedType = validationAttributes[2];

    if (action === 'deprecate') {
      _emberDebug.deprecate('In Ember 2.0 ' + parsedName.type + ' factories must have an `' + factoryFlag + '` ' + ('property set to true. You registered ' + resolvedType + ' as a ' + parsedName.type + ' ') + ('factory. Either add the `' + factoryFlag + '` property to this factory or ') + ('extend from ' + expectedType + '.'), !!resolvedType[factoryFlag], { id: 'ember-application.validate-type', until: '3.0.0' });
    } else {
      _emberDebug.assert('Expected ' + parsedName.fullName + ' to resolve to an ' + expectedType + ' but ' + ('instead it was ' + resolvedType + '.'), !!resolvedType[factoryFlag]);
    }
  }
});
enifed('ember-console/index', ['exports', 'ember-environment'], function (exports, _emberEnvironment) {
  'use strict';

  function K() {}

  function consoleMethod(name) {
    var consoleObj = undefined;
    if (_emberEnvironment.context.imports.console) {
      consoleObj = _emberEnvironment.context.imports.console;
    } else if (typeof console !== 'undefined') {
      consoleObj = console;
    }

    var method = typeof consoleObj === 'object' ? consoleObj[name] : null;

    if (typeof method !== 'function') {
      return;
    }

    if (typeof method.bind === 'function') {
      return method.bind(consoleObj);
    }

    return function () {
      method.apply(consoleObj, arguments);
    };
  }

  function assertPolyfill(test, message) {
    if (!test) {
      try {
        // attempt to preserve the stack
        throw new Error('assertion failed: ' + message);
      } catch (error) {
        setTimeout(function () {
          throw error;
        }, 0);
      }
    }
  }

  /**
    Inside Ember-Metal, simply uses the methods from `imports.console`.
    Override this to provide more robust logging functionality.
  
    @class Logger
    @namespace Ember
    @public
  */
  exports.default = {
    /**
     Logs the arguments to the console.
     You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      var foo = 1;
      Ember.Logger.log('log value of foo:', foo);
      // "log value of foo: 1" will be printed to the console
      ```
      @method log
     @for Ember.Logger
     @param {*} arguments
     @public
    */
    log: consoleMethod('log') || K,

    /**
     Prints the arguments to the console with a warning icon.
     You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      Ember.Logger.warn('Something happened!');
      // "Something happened!" will be printed to the console with a warning icon.
      ```
      @method warn
     @for Ember.Logger
     @param {*} arguments
     @public
    */
    warn: consoleMethod('warn') || K,

    /**
     Prints the arguments to the console with an error icon, red text and a stack trace.
     You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      Ember.Logger.error('Danger! Danger!');
      // "Danger! Danger!" will be printed to the console in red text.
      ```
      @method error
     @for Ember.Logger
     @param {*} arguments
     @public
    */
    error: consoleMethod('error') || K,

    /**
     Logs the arguments to the console.
     You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      var foo = 1;
      Ember.Logger.info('log value of foo:', foo);
      // "log value of foo: 1" will be printed to the console
      ```
      @method info
     @for Ember.Logger
     @param {*} arguments
     @public
    */
    info: consoleMethod('info') || K,

    /**
     Logs the arguments to the console in blue text.
     You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      var foo = 1;
      Ember.Logger.debug('log value of foo:', foo);
      // "log value of foo: 1" will be printed to the console
      ```
      @method debug
     @for Ember.Logger
     @param {*} arguments
     @public
    */
    debug: consoleMethod('debug') || consoleMethod('info') || K,

    /**
     If the value passed into `Ember.Logger.assert` is not truthy it will throw an error with a stack trace.
       ```javascript
      Ember.Logger.assert(true); // undefined
      Ember.Logger.assert(true === false); // Throws an Assertion failed error.
      Ember.Logger.assert(true === false, 'Something invalid'); // Throws an Assertion failed error with message.
      ```
      @method assert
     @for Ember.Logger
     @param {Boolean} bool Value to test
     @param {String} message Assertion message on failed
     @public
    */
    assert: consoleMethod('assert') || assertPolyfill
  };
});
enifed('ember-debug/deprecate', ['exports', 'ember-debug/error', 'ember-console', 'ember-environment', 'ember-debug/handlers'], function (exports, _emberDebugError, _emberConsole, _emberEnvironment, _emberDebugHandlers) {
  /*global __fail__*/

  'use strict';

  exports.registerHandler = registerHandler;
  exports.default = deprecate;

  /**
    Allows for runtime registration of handler functions that override the default deprecation behavior.
    Deprecations are invoked by calls to [Ember.deprecate](http://emberjs.com/api/classes/Ember.html#method_deprecate).
    The following example demonstrates its usage by registering a handler that throws an error if the
    message contains the word "should", otherwise defers to the default handler.
  
    ```javascript
    Ember.Debug.registerDeprecationHandler((message, options, next) => {
      if (message.indexOf('should') !== -1) {
        throw new Error(`Deprecation message with should: ${message}`);
      } else {
        // defer to whatever handler was registered before this one
        next(message, options);
      }
    });
    ```
  
    The handler function takes the following arguments:
  
    <ul>
      <li> <code>message</code> - The message received from the deprecation call.</li>
      <li> <code>options</code> - An object passed in with the deprecation call containing additional information including:</li>
        <ul>
          <li> <code>id</code> - An id of the deprecation in the form of <code>package-name.specific-deprecation</code>.</li>
          <li> <code>until</code> - The Ember version number the feature and deprecation will be removed in.</li>
        </ul>
      <li> <code>next</code> - A function that calls into the previously registered handler.</li>
    </ul>
  
    @public
    @static
    @method registerDeprecationHandler
    @param handler {Function} A function to handle deprecation calls.
    @since 2.1.0
  */

  function registerHandler(handler) {
    _emberDebugHandlers.registerHandler('deprecate', handler);
  }

  function formatMessage(_message, options) {
    var message = _message;

    if (options && options.id) {
      message = message + (' [deprecation id: ' + options.id + ']');
    }

    if (options && options.url) {
      message += ' See ' + options.url + ' for more details.';
    }

    return message;
  }

  registerHandler(function logDeprecationToConsole(message, options) {
    var updatedMessage = formatMessage(message, options);

    _emberConsole.default.warn('DEPRECATION: ' + updatedMessage);
  });

  var captureErrorForStack = undefined;

  if (new Error().stack) {
    captureErrorForStack = function () {
      return new Error();
    };
  } else {
    captureErrorForStack = function () {
      try {
        __fail__.fail();
      } catch (e) {
        return e;
      }
    };
  }

  registerHandler(function logDeprecationStackTrace(message, options, next) {
    if (_emberEnvironment.ENV.LOG_STACKTRACE_ON_DEPRECATION) {
      var stackStr = '';
      var error = captureErrorForStack();
      var stack = undefined;

      if (error.stack) {
        if (error['arguments']) {
          // Chrome
          stack = error.stack.replace(/^\s+at\s+/gm, '').replace(/^([^\(]+?)([\n$])/gm, '{anonymous}($1)$2').replace(/^Object.<anonymous>\s*\(([^\)]+)\)/gm, '{anonymous}($1)').split('\n');
          stack.shift();
        } else {
          // Firefox
          stack = error.stack.replace(/(?:\n@:0)?\s+$/m, '').replace(/^\(/gm, '{anonymous}(').split('\n');
        }

        stackStr = '\n    ' + stack.slice(2).join('\n    ');
      }

      var updatedMessage = formatMessage(message, options);

      _emberConsole.default.warn('DEPRECATION: ' + updatedMessage + stackStr);
    } else {
      next.apply(undefined, arguments);
    }
  });

  registerHandler(function raiseOnDeprecation(message, options, next) {
    if (_emberEnvironment.ENV.RAISE_ON_DEPRECATION) {
      var updatedMessage = formatMessage(message);

      throw new _emberDebugError.default(updatedMessage);
    } else {
      next.apply(undefined, arguments);
    }
  });

  var missingOptionsDeprecation = 'When calling `Ember.deprecate` you ' + 'must provide an `options` hash as the third parameter.  ' + '`options` should include `id` and `until` properties.';
  exports.missingOptionsDeprecation = missingOptionsDeprecation;
  var missingOptionsIdDeprecation = 'When calling `Ember.deprecate` you must provide `id` in options.';
  exports.missingOptionsIdDeprecation = missingOptionsIdDeprecation;
  var missingOptionsUntilDeprecation = 'When calling `Ember.deprecate` you must provide `until` in options.';

  exports.missingOptionsUntilDeprecation = missingOptionsUntilDeprecation;
  /**
  @module ember
  @submodule ember-debug
  */

  /**
    Display a deprecation warning with the provided message and a stack trace
    (Chrome and Firefox only).
  
    * In a production build, this method is defined as an empty function (NOP).
    Uses of this method in Ember itself are stripped from the ember.prod.js build.
  
    @method deprecate
    @param {String} message A description of the deprecation.
    @param {Boolean} test A boolean. If falsy, the deprecation will be displayed.
    @param {Object} options
    @param {String} options.id A unique id for this deprecation. The id can be
      used by Ember debugging tools to change the behavior (raise, log or silence)
      for that specific deprecation. The id should be namespaced by dots, e.g.
      "view.helper.select".
    @param {string} options.until The version of Ember when this deprecation
      warning will be removed.
    @param {String} [options.url] An optional url to the transition guide on the
      emberjs.com website.
    @for Ember
    @public
    @since 1.0.0
  */

  function deprecate(message, test, options) {
    if (!options || !options.id && !options.until) {
      deprecate(missingOptionsDeprecation, false, {
        id: 'ember-debug.deprecate-options-missing',
        until: '3.0.0',
        url: 'http://emberjs.com/deprecations/v2.x/#toc_ember-debug-function-options'
      });
    }

    if (options && !options.id) {
      deprecate(missingOptionsIdDeprecation, false, {
        id: 'ember-debug.deprecate-id-missing',
        until: '3.0.0',
        url: 'http://emberjs.com/deprecations/v2.x/#toc_ember-debug-function-options'
      });
    }

    if (options && !options.until) {
      deprecate(missingOptionsUntilDeprecation, options && options.until, {
        id: 'ember-debug.deprecate-until-missing',
        until: '3.0.0',
        url: 'http://emberjs.com/deprecations/v2.x/#toc_ember-debug-function-options'
      });
    }

    _emberDebugHandlers.invoke.apply(undefined, ['deprecate'].concat(babelHelpers.slice.call(arguments)));
  }
});
enifed("ember-debug/error", ["exports"], function (exports) {

  /**
    A subclass of the JavaScript Error object for use in Ember.
  
    @class Error
    @namespace Ember
    @extends Error
    @constructor
    @public
  */
  "use strict";

  var EmberError = (function (_Error) {
    babelHelpers.inherits(EmberError, _Error);

    function EmberError(message) {
      babelHelpers.classCallCheck(this, EmberError);

      _Error.call(this);

      if (!(this instanceof EmberError)) {
        return new EmberError(message);
      }

      var error = Error.call(this, message);

      if (Error.captureStackTrace) {
        Error.captureStackTrace(this, EmberError);
      } else {
        this.stack = error.stack;
      }

      this.description = error.description;
      this.fileName = error.fileName;
      this.lineNumber = error.lineNumber;
      this.message = error.message;
      this.name = error.name;
      this.number = error.number;
      this.code = error.code;
    }

    return EmberError;
  })(Error);

  exports.default = EmberError;
});
enifed('ember-debug/features', ['exports', 'ember-utils', 'ember-environment', 'ember/features'], function (exports, _emberUtils, _emberEnvironment, _emberFeatures) {
  'use strict';

  exports.default = isEnabled;

  /**
    The hash of enabled Canary features. Add to this, any canary features
    before creating your application.
  
    Alternatively (and recommended), you can also define `EmberENV.FEATURES`
    if you need to enable features flagged at runtime.
  
    @class FEATURES
    @namespace Ember
    @static
    @since 1.1.0
    @public
  */
  var FEATURES = _emberUtils.assign(_emberFeatures.default, _emberEnvironment.ENV.FEATURES);

  exports.FEATURES = FEATURES;
  /**
    Determine whether the specified `feature` is enabled. Used by Ember's
    build tools to exclude experimental features from beta/stable builds.
  
    You can define the following configuration options:
  
    * `EmberENV.ENABLE_OPTIONAL_FEATURES` - enable any features that have not been explicitly
      enabled/disabled.
  
    @method isEnabled
    @param {String} feature The feature to check
    @return {Boolean}
    @for Ember.FEATURES
    @since 1.1.0
    @public
  */

  function isEnabled(feature) {
    var featureValue = FEATURES[feature];

    if (featureValue === true || featureValue === false || featureValue === undefined) {
      return featureValue;
    } else if (_emberEnvironment.ENV.ENABLE_OPTIONAL_FEATURES) {
      return true;
    } else {
      return false;
    }
  }

  exports.DEFAULT_FEATURES = _emberFeatures.default;
});
enifed("ember-debug/handlers", ["exports"], function (exports) {
  "use strict";

  exports.registerHandler = registerHandler;
  exports.invoke = invoke;
  var HANDLERS = {};

  exports.HANDLERS = HANDLERS;

  function registerHandler(type, callback) {
    var nextHandler = HANDLERS[type] || function () {};

    HANDLERS[type] = function (message, options) {
      callback(message, options, nextHandler);
    };
  }

  function invoke(type, message, test, options) {
    if (test) {
      return;
    }

    var handlerForType = HANDLERS[type];

    if (!handlerForType) {
      return;
    }

    if (handlerForType) {
      handlerForType(message, options);
    }
  }
});
enifed('ember-debug/index', ['exports', 'ember/features', 'ember-environment', 'ember-console', 'ember-debug/testing', 'ember-debug/error', 'ember-debug/features', 'ember-debug/deprecate', 'ember-debug/warn'], function (exports, _emberFeatures, _emberEnvironment, _emberConsole, _emberDebugTesting, _emberDebugError, _emberDebugFeatures, _emberDebugDeprecate, _emberDebugWarn) {
  'use strict';

  exports._warnIfUsingStrippedFeatureFlags = _warnIfUsingStrippedFeatureFlags;
  exports.getDebugFunction = getDebugFunction;
  exports.setDebugFunction = setDebugFunction;
  exports.assert = assert;
  exports.info = info;
  exports.warn = warn;
  exports.debug = debug;
  exports.deprecate = deprecate;
  exports.deprecateFunc = deprecateFunc;
  exports.runInDebug = runInDebug;
  exports.debugSeal = debugSeal;
  exports.debugFreeze = debugFreeze;
  exports.registerWarnHandler = _emberDebugWarn.registerHandler;
  exports.registerDeprecationHandler = _emberDebugDeprecate.registerHandler;
  exports.isFeatureEnabled = _emberDebugFeatures.default;
  exports.FEATURES = _emberDebugFeatures.FEATURES;
  exports.Error = _emberDebugError.default;
  exports.isTesting = _emberDebugTesting.isTesting;
  exports.setTesting = _emberDebugTesting.setTesting;
  var debugFunctions = {
    assert: function () {},
    info: function () {},
    warn: function () {},
    debug: function () {},
    deprecate: function () {},
    deprecateFunc: function () {
      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      return args[args.length - 1];
    },
    runInDebug: function () {},
    debugSeal: function () {},
    debugFreeze: function () {}
  };

  exports.debugFunctions = debugFunctions;
  /**
  @module ember
  @submodule ember-debug
  */

  /**
  @class Ember
  @public
  */

  /**
    Define an assertion that will throw an exception if the condition is not met.
  
    * In a production build, this method is defined as an empty function (NOP).
    Uses of this method in Ember itself are stripped from the ember.prod.js build.
  
    ```javascript
    // Test for truthiness
    Ember.assert('Must pass a valid object', obj);
  
    // Fail unconditionally
    Ember.assert('This code path should never be run');
    ```
  
    @method assert
    @param {String} desc A description of the assertion. This will become
      the text of the Error thrown if the assertion fails.
    @param {Boolean} test Must be truthy for the assertion to pass. If
      falsy, an exception will be thrown.
    @public
    @since 1.0.0
  */
  setDebugFunction('assert', function assert(desc, test) {
    if (!test) {
      throw new _emberDebugError.default('Assertion Failed: ' + desc);
    }
  });

  /**
    Display a debug notice.
  
    * In a production build, this method is defined as an empty function (NOP).
    Uses of this method in Ember itself are stripped from the ember.prod.js build.
  
    ```javascript
    Ember.debug('I\'m a debug notice!');
    ```
  
    @method debug
    @param {String} message A debug message to display.
    @public
  */
  setDebugFunction('debug', function debug(message) {
    _emberConsole.default.debug('DEBUG: ' + message);
  });

  /**
    Display an info notice.
  
    * In a production build, this method is defined as an empty function (NOP).
    Uses of this method in Ember itself are stripped from the ember.prod.js build.
  
    @method info
    @private
  */
  setDebugFunction('info', function info() {
    _emberConsole.default.info.apply(undefined, arguments);
  });

  /**
    Alias an old, deprecated method with its new counterpart.
  
    Display a deprecation warning with the provided message and a stack trace
    (Chrome and Firefox only) when the assigned method is called.
  
    * In a production build, this method is defined as an empty function (NOP).
  
    ```javascript
    Ember.oldMethod = Ember.deprecateFunc('Please use the new, updated method', Ember.newMethod);
    ```
  
    @method deprecateFunc
    @param {String} message A description of the deprecation.
    @param {Object} [options] The options object for Ember.deprecate.
    @param {Function} func The new function called to replace its deprecated counterpart.
    @return {Function} A new function that wraps the original function with a deprecation warning
    @private
  */
  setDebugFunction('deprecateFunc', function deprecateFunc() {
    for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }

    if (args.length === 3) {
      var _ret = (function () {
        var message = args[0];
        var options = args[1];
        var func = args[2];

        return {
          v: function () {
            deprecate(message, false, options);
            return func.apply(this, arguments);
          }
        };
      })();

      if (typeof _ret === 'object') return _ret.v;
    } else {
      var _ret2 = (function () {
        var message = args[0];
        var func = args[1];

        return {
          v: function () {
            deprecate(message);
            return func.apply(this, arguments);
          }
        };
      })();

      if (typeof _ret2 === 'object') return _ret2.v;
    }
  });

  /**
    Run a function meant for debugging.
  
    * In a production build, this method is defined as an empty function (NOP).
    Uses of this method in Ember itself are stripped from the ember.prod.js build.
  
    ```javascript
    Ember.runInDebug(() => {
      Ember.Component.reopen({
        didInsertElement() {
          console.log("I'm happy");
        }
      });
    });
    ```
  
    @method runInDebug
    @param {Function} func The function to be executed.
    @since 1.5.0
    @public
  */
  setDebugFunction('runInDebug', function runInDebug(func) {
    func();
  });

  setDebugFunction('debugSeal', function debugSeal(obj) {
    Object.seal(obj);
  });

  setDebugFunction('debugFreeze', function debugFreeze(obj) {
    Object.freeze(obj);
  });

  setDebugFunction('deprecate', _emberDebugDeprecate.default);

  setDebugFunction('warn', _emberDebugWarn.default);

  /**
    Will call `Ember.warn()` if ENABLE_OPTIONAL_FEATURES or
    any specific FEATURES flag is truthy.
  
    This method is called automatically in debug canary builds.
  
    @private
    @method _warnIfUsingStrippedFeatureFlags
    @return {void}
  */

  function _warnIfUsingStrippedFeatureFlags(FEATURES, knownFeatures, featuresWereStripped) {
    if (featuresWereStripped) {
      warn('Ember.ENV.ENABLE_OPTIONAL_FEATURES is only available in canary builds.', !_emberEnvironment.ENV.ENABLE_OPTIONAL_FEATURES, { id: 'ember-debug.feature-flag-with-features-stripped' });

      var keys = Object.keys(FEATURES || {});
      for (var i = 0; i < keys.length; i++) {
        var key = keys[i];
        if (key === 'isEnabled' || !(key in knownFeatures)) {
          continue;
        }

        warn('FEATURE["' + key + '"] is set as enabled, but FEATURE flags are only available in canary builds.', !FEATURES[key], { id: 'ember-debug.feature-flag-with-features-stripped' });
      }
    }
  }

  if (!_emberDebugTesting.isTesting()) {
    (function () {
      // Complain if they're using FEATURE flags in builds other than canary
      _emberDebugFeatures.FEATURES['features-stripped-test'] = true;
      var featuresWereStripped = true;

      if (false) {
        featuresWereStripped = false;
      }

      delete _emberDebugFeatures.FEATURES['features-stripped-test'];
      _warnIfUsingStrippedFeatureFlags(_emberEnvironment.ENV.FEATURES, _emberFeatures.default, featuresWereStripped);

      // Inform the developer about the Ember Inspector if not installed.
      var isFirefox = _emberEnvironment.environment.isFirefox;
      var isChrome = _emberEnvironment.environment.isChrome;

      if (typeof window !== 'undefined' && (isFirefox || isChrome) && window.addEventListener) {
        window.addEventListener('load', function () {
          if (document.documentElement && document.documentElement.dataset && !document.documentElement.dataset.emberExtension) {
            var downloadURL = undefined;

            if (isChrome) {
              downloadURL = 'https://chrome.google.com/webstore/detail/ember-inspector/bmdblncegkenkacieihfhpjfppoconhi';
            } else if (isFirefox) {
              downloadURL = 'https://addons.mozilla.org/en-US/firefox/addon/ember-inspector/';
            }

            debug('For more advanced debugging, install the Ember Inspector from ' + downloadURL);
          }
        }, false);
      }
    })();
  }

  /*
    We are transitioning away from `ember.js` to `ember.debug.js` to make
    it much clearer that it is only for local development purposes.
  
    This flag value is changed by the tooling (by a simple string replacement)
    so that if `ember.js` (which must be output for backwards compat reasons) is
    used a nice helpful warning message will be printed out.
  */
  var runningNonEmberDebugJS = false;
  exports.runningNonEmberDebugJS = runningNonEmberDebugJS;
  if (runningNonEmberDebugJS) {
    warn('Please use `ember.debug.js` instead of `ember.js` for development and debugging.');
  }

  function getDebugFunction(name) {
    return debugFunctions[name];
  }

  function setDebugFunction(name, fn) {
    debugFunctions[name] = fn;
  }

  function assert() {
    return debugFunctions.assert.apply(undefined, arguments);
  }

  function info() {
    return debugFunctions.info.apply(undefined, arguments);
  }

  function warn() {
    return debugFunctions.warn.apply(undefined, arguments);
  }

  function debug() {
    return debugFunctions.debug.apply(undefined, arguments);
  }

  function deprecate() {
    return debugFunctions.deprecate.apply(undefined, arguments);
  }

  function deprecateFunc() {
    return debugFunctions.deprecateFunc.apply(undefined, arguments);
  }

  function runInDebug() {
    return debugFunctions.runInDebug.apply(undefined, arguments);
  }

  function debugSeal() {
    return debugFunctions.debugSeal.apply(undefined, arguments);
  }

  function debugFreeze() {
    return debugFunctions.debugFreeze.apply(undefined, arguments);
  }
});
enifed("ember-debug/run-in-debug", ["exports"], function (exports) {
  "use strict";
});
enifed("ember-debug/testing", ["exports"], function (exports) {
  "use strict";

  exports.isTesting = isTesting;
  exports.setTesting = setTesting;
  var testing = false;

  function isTesting() {
    return testing;
  }

  function setTesting(value) {
    testing = !!value;
  }
});
enifed('ember-debug/warn', ['exports', 'ember-console', 'ember-debug/deprecate', 'ember-debug/handlers'], function (exports, _emberConsole, _emberDebugDeprecate, _emberDebugHandlers) {
  'use strict';

  exports.registerHandler = registerHandler;
  exports.default = warn;

  /**
    Allows for runtime registration of handler functions that override the default warning behavior.
    Warnings are invoked by calls made to [Ember.warn](http://emberjs.com/api/classes/Ember.html#method_warn).
    The following example demonstrates its usage by registering a handler that does nothing overriding Ember's
    default warning behavior.
  
    ```javascript
    // next is not called, so no warnings get the default behavior
    Ember.Debug.registerWarnHandler(() => {});
    ```
  
    The handler function takes the following arguments:
  
    <ul>
      <li> <code>message</code> - The message received from the warn call. </li>
      <li> <code>options</code> - An object passed in with the warn call containing additional information including:</li>
        <ul>
          <li> <code>id</code> - An id of the warning in the form of <code>package-name.specific-warning</code>.</li>
        </ul>
      <li> <code>next</code> - A function that calls into the previously registered handler.</li>
    </ul>
  
    @public
    @static
    @method registerWarnHandler
    @param handler {Function} A function to handle warnings.
    @since 2.1.0
  */

  function registerHandler(handler) {
    _emberDebugHandlers.registerHandler('warn', handler);
  }

  registerHandler(function logWarning(message, options) {
    _emberConsole.default.warn('WARNING: ' + message);
    if ('trace' in _emberConsole.default) {
      _emberConsole.default.trace();
    }
  });

  var missingOptionsDeprecation = 'When calling `Ember.warn` you ' + 'must provide an `options` hash as the third parameter.  ' + '`options` should include an `id` property.';
  exports.missingOptionsDeprecation = missingOptionsDeprecation;
  var missingOptionsIdDeprecation = 'When calling `Ember.warn` you must provide `id` in options.';

  exports.missingOptionsIdDeprecation = missingOptionsIdDeprecation;
  /**
  @module ember
  @submodule ember-debug
  */

  /**
    Display a warning with the provided message.
  
    * In a production build, this method is defined as an empty function (NOP).
    Uses of this method in Ember itself are stripped from the ember.prod.js build.
  
    @method warn
    @param {String} message A warning to display.
    @param {Boolean} test An optional boolean. If falsy, the warning
      will be displayed.
    @param {Object} options An object that can be used to pass a unique
      `id` for this warning.  The `id` can be used by Ember debugging tools
      to change the behavior (raise, log, or silence) for that specific warning.
      The `id` should be namespaced by dots, e.g. "ember-debug.feature-flag-with-features-stripped"
    @for Ember
    @public
    @since 1.0.0
  */

  function warn(message, test, options) {
    if (arguments.length === 2 && typeof test === 'object') {
      options = test;
      test = false;
    }
    if (!options) {
      _emberDebugDeprecate.default(missingOptionsDeprecation, false, {
        id: 'ember-debug.warn-options-missing',
        until: '3.0.0',
        url: 'http://emberjs.com/deprecations/v2.x/#toc_ember-debug-function-options'
      });
    }

    if (options && !options.id) {
      _emberDebugDeprecate.default(missingOptionsIdDeprecation, false, {
        id: 'ember-debug.warn-id-missing',
        until: '3.0.0',
        url: 'http://emberjs.com/deprecations/v2.x/#toc_ember-debug-function-options'
      });
    }

    _emberDebugHandlers.invoke('warn', message, test, options);
  }
});
enifed('ember-environment/global', ['exports'], function (exports) {
  /* globals global, window, self, mainContext */

  // from lodash to catch fake globals
  'use strict';

  function checkGlobal(value) {
    return value && value.Object === Object ? value : undefined;
  }

  // element ids can ruin global miss checks
  function checkElementIdShadowing(value) {
    return value && value.nodeType === undefined ? value : undefined;
  }

  // export real global
  exports.default = checkGlobal(checkElementIdShadowing(typeof global === 'object' && global)) || checkGlobal(typeof self === 'object' && self) || checkGlobal(typeof window === 'object' && window) || mainContext || // set before strict mode in Ember loader/wrapper
  new Function('return this')();
  // eval outside of strict mode
});
enifed('ember-environment/index', ['exports', 'ember-environment/global', 'ember-environment/utils'], function (exports, _emberEnvironmentGlobal, _emberEnvironmentUtils) {
  /* globals module */
  'use strict';

  /**
    The hash of environment variables used to control various configuration
    settings. To specify your own or override default settings, add the
    desired properties to a global hash named `EmberENV` (or `ENV` for
    backwards compatibility with earlier versions of Ember). The `EmberENV`
    hash must be created before loading Ember.
  
    @class EmberENV
    @type Object
    @public
  */
  var ENV = typeof _emberEnvironmentGlobal.default.EmberENV === 'object' && _emberEnvironmentGlobal.default.EmberENV || typeof _emberEnvironmentGlobal.default.ENV === 'object' && _emberEnvironmentGlobal.default.ENV || {};

  exports.ENV = ENV;
  // ENABLE_ALL_FEATURES was documented, but you can't actually enable non optional features.
  if (ENV.ENABLE_ALL_FEATURES) {
    ENV.ENABLE_OPTIONAL_FEATURES = true;
  }

  /**
    Determines whether Ember should add to `Array`, `Function`, and `String`
    native object prototypes, a few extra methods in order to provide a more
    friendly API.
  
    We generally recommend leaving this option set to true however, if you need
    to turn it off, you can add the configuration property
    `EXTEND_PROTOTYPES` to `EmberENV` and set it to `false`.
  
    Note, when disabled (the default configuration for Ember Addons), you will
    instead have to access all methods and functions from the Ember
    namespace.
  
    @property EXTEND_PROTOTYPES
    @type Boolean
    @default true
    @for EmberENV
    @public
  */
  ENV.EXTEND_PROTOTYPES = _emberEnvironmentUtils.normalizeExtendPrototypes(ENV.EXTEND_PROTOTYPES);

  /**
    The `LOG_STACKTRACE_ON_DEPRECATION` property, when true, tells Ember to log
    a full stack trace during deprecation warnings.
  
    @property LOG_STACKTRACE_ON_DEPRECATION
    @type Boolean
    @default true
    @for EmberENV
    @public
  */
  ENV.LOG_STACKTRACE_ON_DEPRECATION = _emberEnvironmentUtils.defaultTrue(ENV.LOG_STACKTRACE_ON_DEPRECATION);

  /**
    The `LOG_VERSION` property, when true, tells Ember to log versions of all
    dependent libraries in use.
  
    @property LOG_VERSION
    @type Boolean
    @default true
    @for EmberENV
    @public
  */
  ENV.LOG_VERSION = _emberEnvironmentUtils.defaultTrue(ENV.LOG_VERSION);

  /**
    Debug parameter you can turn on. This will log all bindings that fire to
    the console. This should be disabled in production code. Note that you
    can also enable this from the console or temporarily.
  
    @property LOG_BINDINGS
    @for EmberENV
    @type Boolean
    @default false
    @public
  */
  ENV.LOG_BINDINGS = _emberEnvironmentUtils.defaultFalse(ENV.LOG_BINDINGS);

  ENV.RAISE_ON_DEPRECATION = _emberEnvironmentUtils.defaultFalse(ENV.RAISE_ON_DEPRECATION);

  // check if window exists and actually is the global
  var hasDOM = typeof window !== 'undefined' && window === _emberEnvironmentGlobal.default && window.document && window.document.createElement && !ENV.disableBrowserEnvironment; // is this a public thing?

  // legacy imports/exports/lookup stuff (should we keep this??)
  var originalContext = _emberEnvironmentGlobal.default.Ember || {};

  var context = {
    // import jQuery
    imports: originalContext.imports || _emberEnvironmentGlobal.default,
    // export Ember
    exports: originalContext.exports || _emberEnvironmentGlobal.default,
    // search for Namespaces
    lookup: originalContext.lookup || _emberEnvironmentGlobal.default
  };

  exports.context = context;
  // TODO: cleanup single source of truth issues with this stuff
  var environment = hasDOM ? {
    hasDOM: true,
    isChrome: !!window.chrome && !window.opera,
    isFirefox: typeof InstallTrigger !== 'undefined',
    isPhantom: !!window.callPhantom,
    location: window.location,
    history: window.history,
    userAgent: window.navigator.userAgent,
    window: window
  } : {
    hasDOM: false,
    isChrome: false,
    isFirefox: false,
    isPhantom: false,
    location: null,
    history: null,
    userAgent: 'Lynx (textmode)',
    window: null
  };
  exports.environment = environment;
});
enifed("ember-environment/utils", ["exports"], function (exports) {
  "use strict";

  exports.defaultTrue = defaultTrue;
  exports.defaultFalse = defaultFalse;
  exports.normalizeExtendPrototypes = normalizeExtendPrototypes;

  function defaultTrue(v) {
    return v === false ? false : true;
  }

  function defaultFalse(v) {
    return v === true ? true : false;
  }

  function normalizeExtendPrototypes(obj) {
    if (obj === false) {
      return { String: false, Array: false, Function: false };
    } else if (!obj || obj === true) {
      return { String: true, Array: true, Function: true };
    } else {
      return {
        String: defaultTrue(obj.String),
        Array: defaultTrue(obj.Array),
        Function: defaultTrue(obj.Function)
      };
    }
  }
});
enifed('ember-extension-support/container_debug_adapter', ['exports', 'ember-metal', 'ember-runtime'], function (exports, _emberMetal, _emberRuntime) {
  'use strict';

  /**
  @module ember
  @submodule ember-extension-support
  */

  /**
    The `ContainerDebugAdapter` helps the container and resolver interface
    with tools that debug Ember such as the
    [Ember Inspector](https://github.com/emberjs/ember-inspector)
    for Chrome and Firefox.
  
    This class can be extended by a custom resolver implementer
    to override some of the methods with library-specific code.
  
    The methods likely to be overridden are:
  
    * `canCatalogEntriesByType`
    * `catalogEntriesByType`
  
    The adapter will need to be registered
    in the application's container as `container-debug-adapter:main`.
  
    Example:
  
    ```javascript
    Application.initializer({
      name: "containerDebugAdapter",
  
      initialize(application) {
        application.register('container-debug-adapter:main', require('app/container-debug-adapter'));
      }
    });
    ```
  
    @class ContainerDebugAdapter
    @namespace Ember
    @extends Ember.Object
    @since 1.5.0
    @public
  */
  exports.default = _emberRuntime.Object.extend({
    /**
      The resolver instance of the application
      being debugged. This property will be injected
      on creation.
       @property resolver
      @default null
      @public
    */
    resolver: null,

    /**
      Returns true if it is possible to catalog a list of available
      classes in the resolver for a given type.
       @method canCatalogEntriesByType
      @param {String} type The type. e.g. "model", "controller", "route".
      @return {boolean} whether a list is available for this type.
      @public
    */
    canCatalogEntriesByType: function (type) {
      if (type === 'model' || type === 'template') {
        return false;
      }

      return true;
    },

    /**
      Returns the available classes a given type.
       @method catalogEntriesByType
      @param {String} type The type. e.g. "model", "controller", "route".
      @return {Array} An array of strings.
      @public
    */
    catalogEntriesByType: function (type) {
      var namespaces = _emberRuntime.A(_emberRuntime.Namespace.NAMESPACES);
      var types = _emberRuntime.A();
      var typeSuffixRegex = new RegExp(_emberRuntime.String.classify(type) + '$');

      namespaces.forEach(function (namespace) {
        if (namespace !== _emberMetal.default) {
          for (var key in namespace) {
            if (!namespace.hasOwnProperty(key)) {
              continue;
            }
            if (typeSuffixRegex.test(key)) {
              var klass = namespace[key];
              if (_emberRuntime.typeOf(klass) === 'class') {
                types.push(_emberRuntime.String.dasherize(key.replace(typeSuffixRegex, '')));
              }
            }
          }
        }
      });
      return types;
    }
  });
});
// Ember as namespace
enifed('ember-extension-support/data_adapter', ['exports', 'ember-utils', 'ember-metal', 'ember-runtime', 'container', 'ember-application'], function (exports, _emberUtils, _emberMetal, _emberRuntime, _container, _emberApplication) {
  'use strict';

  /**
  @module ember
  @submodule ember-extension-support
  */

  /**
    The `DataAdapter` helps a data persistence library
    interface with tools that debug Ember such
    as the [Ember Extension](https://github.com/tildeio/ember-extension)
    for Chrome and Firefox.
  
    This class will be extended by a persistence library
    which will override some of the methods with
    library-specific code.
  
    The methods likely to be overridden are:
  
    * `getFilters`
    * `detect`
    * `columnsForType`
    * `getRecords`
    * `getRecordColumnValues`
    * `getRecordKeywords`
    * `getRecordFilterValues`
    * `getRecordColor`
    * `observeRecord`
  
    The adapter will need to be registered
    in the application's container as `dataAdapter:main`.
  
    Example:
  
    ```javascript
    Application.initializer({
      name: "data-adapter",
  
      initialize: function(application) {
        application.register('data-adapter:main', DS.DataAdapter);
      }
    });
    ```
  
    @class DataAdapter
    @namespace Ember
    @extends EmberObject
    @public
  */
  exports.default = _emberRuntime.Object.extend({
    init: function () {
      this._super.apply(this, arguments);
      this.releaseMethods = _emberRuntime.A();
    },

    /**
      The container-debug-adapter which is used
      to list all models.
       @property containerDebugAdapter
      @default undefined
      @since 1.5.0
      @public
    **/
    containerDebugAdapter: undefined,

    /**
      The number of attributes to send
      as columns. (Enough to make the record
      identifiable).
       @private
      @property attributeLimit
      @default 3
      @since 1.3.0
    */
    attributeLimit: 3,

    /**
       Ember Data > v1.0.0-beta.18
       requires string model names to be passed
       around instead of the actual factories.
        This is a stamp for the Ember Inspector
       to differentiate between the versions
       to be able to support older versions too.
        @public
       @property acceptsModelName
     */
    acceptsModelName: true,

    /**
      Stores all methods that clear observers.
      These methods will be called on destruction.
       @private
      @property releaseMethods
      @since 1.3.0
    */
    releaseMethods: _emberRuntime.A(),

    /**
      Specifies how records can be filtered.
      Records returned will need to have a `filterValues`
      property with a key for every name in the returned array.
       @public
      @method getFilters
      @return {Array} List of objects defining filters.
       The object should have a `name` and `desc` property.
    */
    getFilters: function () {
      return _emberRuntime.A();
    },

    /**
      Fetch the model types and observe them for changes.
       @public
      @method watchModelTypes
       @param {Function} typesAdded Callback to call to add types.
      Takes an array of objects containing wrapped types (returned from `wrapModelType`).
       @param {Function} typesUpdated Callback to call when a type has changed.
      Takes an array of objects containing wrapped types.
       @return {Function} Method to call to remove all observers
    */
    watchModelTypes: function (typesAdded, typesUpdated) {
      var _this = this;

      var modelTypes = this.getModelTypes();
      var releaseMethods = _emberRuntime.A();
      var typesToSend = undefined;

      typesToSend = modelTypes.map(function (type) {
        var klass = type.klass;
        var wrapped = _this.wrapModelType(klass, type.name);
        releaseMethods.push(_this.observeModelType(type.name, typesUpdated));
        return wrapped;
      });

      typesAdded(typesToSend);

      var release = function () {
        releaseMethods.forEach(function (fn) {
          return fn();
        });
        _this.releaseMethods.removeObject(release);
      };
      this.releaseMethods.pushObject(release);
      return release;
    },

    _nameToClass: function (type) {
      if (typeof type === 'string') {
        var owner = _emberUtils.getOwner(this);
        var Factory = owner[_container.FACTORY_FOR]('model:' + type);
        type = Factory && Factory.class;
      }
      return type;
    },

    /**
      Fetch the records of a given type and observe them for changes.
       @public
      @method watchRecords
       @param {String} modelName The model name.
       @param {Function} recordsAdded Callback to call to add records.
      Takes an array of objects containing wrapped records.
      The object should have the following properties:
        columnValues: {Object} The key and value of a table cell.
        object: {Object} The actual record object.
       @param {Function} recordsUpdated Callback to call when a record has changed.
      Takes an array of objects containing wrapped records.
       @param {Function} recordsRemoved Callback to call when a record has removed.
      Takes the following parameters:
        index: The array index where the records were removed.
        count: The number of records removed.
       @return {Function} Method to call to remove all observers.
    */
    watchRecords: function (modelName, recordsAdded, recordsUpdated, recordsRemoved) {
      var _this2 = this;

      var releaseMethods = _emberRuntime.A();
      var klass = this._nameToClass(modelName);
      var records = this.getRecords(klass, modelName);
      var release = undefined;

      function recordUpdated(updatedRecord) {
        recordsUpdated([updatedRecord]);
      }

      var recordsToSend = records.map(function (record) {
        releaseMethods.push(_this2.observeRecord(record, recordUpdated));
        return _this2.wrapRecord(record);
      });

      var contentDidChange = function (array, idx, removedCount, addedCount) {
        for (var i = idx; i < idx + addedCount; i++) {
          var record = _emberRuntime.objectAt(array, i);
          var wrapped = _this2.wrapRecord(record);
          releaseMethods.push(_this2.observeRecord(record, recordUpdated));
          recordsAdded([wrapped]);
        }

        if (removedCount) {
          recordsRemoved(idx, removedCount);
        }
      };

      var observer = { didChange: contentDidChange, willChange: function () {
          return this;
        } };
      _emberRuntime.addArrayObserver(records, this, observer);

      release = function () {
        releaseMethods.forEach(function (fn) {
          return fn();
        });
        _emberRuntime.removeArrayObserver(records, _this2, observer);
        _this2.releaseMethods.removeObject(release);
      };

      recordsAdded(recordsToSend);

      this.releaseMethods.pushObject(release);
      return release;
    },

    /**
      Clear all observers before destruction
      @private
      @method willDestroy
    */
    willDestroy: function () {
      this._super.apply(this, arguments);
      this.releaseMethods.forEach(function (fn) {
        return fn();
      });
    },

    /**
      Detect whether a class is a model.
       Test that against the model class
      of your persistence library.
       @private
      @method detect
      @param {Class} klass The class to test.
      @return boolean Whether the class is a model class or not.
    */
    detect: function (klass) {
      return false;
    },

    /**
      Get the columns for a given model type.
       @private
      @method columnsForType
      @param {Class} type The model type.
      @return {Array} An array of columns of the following format:
       name: {String} The name of the column.
       desc: {String} Humanized description (what would show in a table column name).
    */
    columnsForType: function (type) {
      return _emberRuntime.A();
    },

    /**
      Adds observers to a model type class.
       @private
      @method observeModelType
      @param {String} modelName The model type name.
      @param {Function} typesUpdated Called when a type is modified.
      @return {Function} The function to call to remove observers.
    */

    observeModelType: function (modelName, typesUpdated) {
      var _this3 = this;

      var klass = this._nameToClass(modelName);
      var records = this.getRecords(klass, modelName);

      function onChange() {
        typesUpdated([this.wrapModelType(klass, modelName)]);
      }

      var observer = {
        didChange: function () {
          _emberMetal.run.scheduleOnce('actions', this, onChange);
        },
        willChange: function () {
          return this;
        }
      };

      _emberRuntime.addArrayObserver(records, this, observer);

      var release = function () {
        return _emberRuntime.removeArrayObserver(records, _this3, observer);
      };

      return release;
    },

    /**
      Wraps a given model type and observes changes to it.
       @private
      @method wrapModelType
      @param {Class} klass A model class.
      @param {String} modelName Name of the class.
      @return {Object} Contains the wrapped type and the function to remove observers
      Format:
        type: {Object} The wrapped type.
          The wrapped type has the following format:
            name: {String} The name of the type.
            count: {Integer} The number of records available.
            columns: {Columns} An array of columns to describe the record.
            object: {Class} The actual Model type class.
        release: {Function} The function to remove observers.
    */
    wrapModelType: function (klass, name) {
      var records = this.getRecords(klass, name);
      var typeToSend = undefined;

      typeToSend = {
        name: name,
        count: _emberMetal.get(records, 'length'),
        columns: this.columnsForType(klass),
        object: klass
      };

      return typeToSend;
    },

    /**
      Fetches all models defined in the application.
       @private
      @method getModelTypes
      @return {Array} Array of model types.
    */
    getModelTypes: function () {
      var _this4 = this;

      var containerDebugAdapter = this.get('containerDebugAdapter');
      var types = undefined;

      if (containerDebugAdapter.canCatalogEntriesByType('model')) {
        types = containerDebugAdapter.catalogEntriesByType('model');
      } else {
        types = this._getObjectsOnNamespaces();
      }

      // New adapters return strings instead of classes.
      types = _emberRuntime.A(types).map(function (name) {
        return {
          klass: _this4._nameToClass(name),
          name: name
        };
      });
      types = _emberRuntime.A(types).filter(function (type) {
        return _this4.detect(type.klass);
      });

      return _emberRuntime.A(types);
    },

    /**
      Loops over all namespaces and all objects
      attached to them.
       @private
      @method _getObjectsOnNamespaces
      @return {Array} Array of model type strings.
    */
    _getObjectsOnNamespaces: function () {
      var _this5 = this;

      var namespaces = _emberRuntime.A(_emberRuntime.Namespace.NAMESPACES);
      var types = _emberRuntime.A();

      namespaces.forEach(function (namespace) {
        for (var key in namespace) {
          if (!namespace.hasOwnProperty(key)) {
            continue;
          }
          // Even though we will filter again in `getModelTypes`,
          // we should not call `lookupFactory` on non-models
          if (!_this5.detect(namespace[key])) {
            continue;
          }
          var _name = _emberRuntime.String.dasherize(key);
          if (!(namespace instanceof _emberApplication.Application) && namespace.toString()) {
            _name = namespace + '/' + _name;
          }
          types.push(_name);
        }
      });
      return types;
    },

    /**
      Fetches all loaded records for a given type.
       @private
      @method getRecords
      @return {Array} An array of records.
       This array will be observed for changes,
       so it should update when new records are added/removed.
    */
    getRecords: function (type) {
      return _emberRuntime.A();
    },

    /**
      Wraps a record and observers changes to it.
       @private
      @method wrapRecord
      @param {Object} record The record instance.
      @return {Object} The wrapped record. Format:
      columnValues: {Array}
      searchKeywords: {Array}
    */
    wrapRecord: function (record) {
      var recordToSend = { object: record };

      recordToSend.columnValues = this.getRecordColumnValues(record);
      recordToSend.searchKeywords = this.getRecordKeywords(record);
      recordToSend.filterValues = this.getRecordFilterValues(record);
      recordToSend.color = this.getRecordColor(record);

      return recordToSend;
    },

    /**
      Gets the values for each column.
       @private
      @method getRecordColumnValues
      @return {Object} Keys should match column names defined
      by the model type.
    */
    getRecordColumnValues: function (record) {
      return {};
    },

    /**
      Returns keywords to match when searching records.
       @private
      @method getRecordKeywords
      @return {Array} Relevant keywords for search.
    */
    getRecordKeywords: function (record) {
      return _emberRuntime.A();
    },

    /**
      Returns the values of filters defined by `getFilters`.
       @private
      @method getRecordFilterValues
      @param {Object} record The record instance.
      @return {Object} The filter values.
    */
    getRecordFilterValues: function (record) {
      return {};
    },

    /**
      Each record can have a color that represents its state.
       @private
      @method getRecordColor
      @param {Object} record The record instance
      @return {String} The records color.
        Possible options: black, red, blue, green.
    */
    getRecordColor: function (record) {
      return null;
    },

    /**
      Observes all relevant properties and re-sends the wrapped record
      when a change occurs.
       @private
      @method observerRecord
      @param {Object} record The record instance.
      @param {Function} recordUpdated The callback to call when a record is updated.
      @return {Function} The function to call to remove all observers.
    */
    observeRecord: function (record, recordUpdated) {
      return function () {};
    }
  });
});
enifed('ember-extension-support/index', ['exports', 'ember-extension-support/data_adapter', 'ember-extension-support/container_debug_adapter'], function (exports, _emberExtensionSupportData_adapter, _emberExtensionSupportContainer_debug_adapter) {
  /**
  @module ember
  @submodule ember-extension-support
  */

  'use strict';

  exports.DataAdapter = _emberExtensionSupportData_adapter.default;
  exports.ContainerDebugAdapter = _emberExtensionSupportContainer_debug_adapter.default;
});
enifed('ember-glimmer/component', ['exports', 'ember-utils', 'ember-views', 'ember-runtime', 'ember-debug', 'ember-metal', 'ember-glimmer/utils/references', '@glimmer/reference', '@glimmer/runtime'], function (exports, _emberUtils, _emberViews, _emberRuntime, _emberDebug, _emberMetal, _emberGlimmerUtilsReferences, _glimmerReference, _glimmerRuntime) {
  'use strict';

  var _CoreView$extend;

  var DIRTY_TAG = _emberUtils.symbol('DIRTY_TAG');
  exports.DIRTY_TAG = DIRTY_TAG;
  var ARGS = _emberUtils.symbol('ARGS');
  exports.ARGS = ARGS;
  var ROOT_REF = _emberUtils.symbol('ROOT_REF');
  exports.ROOT_REF = ROOT_REF;
  var IS_DISPATCHING_ATTRS = _emberUtils.symbol('IS_DISPATCHING_ATTRS');
  exports.IS_DISPATCHING_ATTRS = IS_DISPATCHING_ATTRS;
  var HAS_BLOCK = _emberUtils.symbol('HAS_BLOCK');
  exports.HAS_BLOCK = HAS_BLOCK;
  var BOUNDS = _emberUtils.symbol('BOUNDS');

  exports.BOUNDS = BOUNDS;
  /**
  @module ember
  @submodule ember-glimmer
  */

  /**
    An `Ember.Component` is a view that is completely
    isolated. Properties accessed in its templates go
    to the view object and actions are targeted at
    the view object. There is no access to the
    surrounding context or outer controller; all
    contextual information must be passed in.
  
    The easiest way to create an `Ember.Component` is via
    a template. If you name a template
    `app/components/my-foo.hbs`, you will be able to use
    `{{my-foo}}` in other templates, which will make
    an instance of the isolated component.
  
    ```app/components/my-foo.hbs
    {{person-profile person=currentUser}}
    ```
  
    ```app/components/person-profile.hbs
    <h1>{{person.title}}</h1>
    <img src={{person.avatar}}>
    <p class='signature'>{{person.signature}}</p>
    ```
  
    You can use `yield` inside a template to
    include the **contents** of any block attached to
    the component. The block will be executed in the
    context of the surrounding context or outer controller:
  
    ```handlebars
    {{#person-profile person=currentUser}}
      <p>Admin mode</p>
      {{! Executed in the controller's context. }}
    {{/person-profile}}
    ```
  
    ```app/components/person-profile.hbs
    <h1>{{person.title}}</h1>
    {{! Executed in the component's context. }}
    {{yield}} {{! block contents }}
    ```
  
    If you want to customize the component, in order to
    handle events or actions, you implement a subclass
    of `Ember.Component` named after the name of the
    component.
  
    For example, you could implement the action
    `hello` for the `person-profile` component:
  
    ```app/components/person-profile.js
    import Ember from 'ember';
  
    export default Ember.Component.extend({
      actions: {
        hello(name) {
          console.log("Hello", name);
        }
      }
    });
    ```
  
    And then use it in the component's template:
  
    ```app/templates/components/person-profile.hbs
    <h1>{{person.title}}</h1>
    {{yield}} <!-- block contents -->
    <button {{action 'hello' person.name}}>
      Say Hello to {{person.name}}
    </button>
    ```
  
    Components must have a `-` in their name to avoid
    conflicts with built-in controls that wrap HTML
    elements. This is consistent with the same
    requirement in web components.
  
  
    ## HTML Tag
  
    The default HTML tag name used for a component's DOM representation is `div`.
    This can be customized by setting the `tagName` property.
    The following component class:
  
    ```app/components/emphasized-paragraph.js
    import Ember from 'ember';
  
    export default Ember.Component.extend({
      tagName: 'em'
    });
    ```
  
    Would result in instances with the following HTML:
  
    ```html
    <em id="ember1" class="ember-view"></em>
    ```
  
  
    ## HTML `class` Attribute
  
    The HTML `class` attribute of a component's tag can be set by providing a
    `classNames` property that is set to an array of strings:
  
    ```app/components/my-widget.js
    import Ember from 'ember';
  
    export default Ember.Component.extend({
      classNames: ['my-class', 'my-other-class']
    });
    ```
  
    Will result in component instances with an HTML representation of:
  
    ```html
    <div id="ember1" class="ember-view my-class my-other-class"></div>
    ```
  
    `class` attribute values can also be set by providing a `classNameBindings`
    property set to an array of properties names for the component. The return value
    of these properties will be added as part of the value for the components's `class`
    attribute. These properties can be computed properties:
  
    ```app/components/my-widget.js
    import Ember from 'ember';
  
    export default Ember.Component.extend({
      classNameBindings: ['propertyA', 'propertyB'],
      propertyA: 'from-a',
      propertyB: Ember.computed(function() {
        if (someLogic) { return 'from-b'; }
      })
    });
    ```
  
    Will result in component instances with an HTML representation of:
  
    ```html
    <div id="ember1" class="ember-view from-a from-b"></div>
    ```
  
    If the value of a class name binding returns a boolean the property name
    itself will be used as the class name if the property is true.
    The class name will not be added if the value is `false` or `undefined`.
  
    ```app/components/my-widget.js
    import Ember from 'ember';
  
    export default Ember.Component.extend({
      classNameBindings: ['hovered'],
      hovered: true
    });
    ```
  
    Will result in component instances with an HTML representation of:
  
    ```html
    <div id="ember1" class="ember-view hovered"></div>
    ```
  
    When using boolean class name bindings you can supply a string value other
    than the property name for use as the `class` HTML attribute by appending the
    preferred value after a ":" character when defining the binding:
  
    ```app/components/my-widget.js
    import Ember from 'ember';
  
    export default Ember.Component.extend({
      classNameBindings: ['awesome:so-very-cool'],
      awesome: true
    });
    ```
  
    Will result in component instances with an HTML representation of:
  
    ```html
    <div id="ember1" class="ember-view so-very-cool"></div>
    ```
  
    Boolean value class name bindings whose property names are in a
    camelCase-style format will be converted to a dasherized format:
  
    ```app/components/my-widget.js
    import Ember from 'ember';
  
    export default Ember.Component.extend({
      classNameBindings: ['isUrgent'],
      isUrgent: true
    });
    ```
  
    Will result in component instances with an HTML representation of:
  
    ```html
    <div id="ember1" class="ember-view is-urgent"></div>
    ```
  
    Class name bindings can also refer to object values that are found by
    traversing a path relative to the component itself:
  
    ```app/components/my-widget.js
    import Ember from 'ember';
  
    export default Ember.Component.extend({
      classNameBindings: ['messages.empty'],
      messages: Ember.Object.create({
        empty: true
      })
    });
    ```
  
    Will result in component instances with an HTML representation of:
  
    ```html
    <div id="ember1" class="ember-view empty"></div>
    ```
  
    If you want to add a class name for a property which evaluates to true and
    and a different class name if it evaluates to false, you can pass a binding
    like this:
  
    ```app/components/my-widget.js
    import Ember from 'ember';
  
    export default Ember.Component.extend({
      classNameBindings: ['isEnabled:enabled:disabled'],
      isEnabled: true
    });
    ```
  
    Will result in component instances with an HTML representation of:
  
    ```html
    <div id="ember1" class="ember-view enabled"></div>
    ```
  
    When isEnabled is `false`, the resulting HTML representation looks like
    this:
  
    ```html
    <div id="ember1" class="ember-view disabled"></div>
    ```
  
    This syntax offers the convenience to add a class if a property is `false`:
  
    ```app/components/my-widget.js
    import Ember from 'ember';
  
    // Applies no class when isEnabled is true and class 'disabled' when isEnabled is false
    export default Ember.Component.extend({
      classNameBindings: ['isEnabled::disabled'],
      isEnabled: true
    });
    ```
  
    Will result in component instances with an HTML representation of:
  
    ```html
    <div id="ember1" class="ember-view"></div>
    ```
  
    When the `isEnabled` property on the component is set to `false`, it will result
    in component instances with an HTML representation of:
  
    ```html
    <div id="ember1" class="ember-view disabled"></div>
    ```
  
    Updates to the value of a class name binding will result in automatic
    update of the  HTML `class` attribute in the component's rendered HTML
    representation. If the value becomes `false` or `undefined` the class name
    will be removed.
    Both `classNames` and `classNameBindings` are concatenated properties. See
    [Ember.Object](/api/classes/Ember.Object.html) documentation for more
    information about concatenated properties.
  
  
    ## HTML Attributes
  
    The HTML attribute section of a component's tag can be set by providing an
    `attributeBindings` property set to an array of property names on the component.
    The return value of these properties will be used as the value of the component's
    HTML associated attribute:
  
    ```app/components/my-anchor.js
    import Ember from 'ember';
  
    export default Ember.Component.extend({
      tagName: 'a',
      attributeBindings: ['href'],
      href: 'http://google.com'
    });
    ```
  
    Will result in component instances with an HTML representation of:
  
    ```html
    <a id="ember1" class="ember-view" href="http://google.com"></a>
    ```
  
    One property can be mapped on to another by placing a ":" between
    the source property and the destination property:
  
    ```app/components/my-anchor.js
    import Ember from 'ember';
  
    export default Ember.Component.extend({
      tagName: 'a',
      attributeBindings: ['url:href'],
      url: 'http://google.com'
    });
    ```
  
    Will result in component instances with an HTML representation of:
  
    ```html
    <a id="ember1" class="ember-view" href="http://google.com"></a>
    ```
  
    Namespaced attributes (e.g. `xlink:href`) are supported, but have to be
    mapped, since `:` is not a valid character for properties in Javascript:
  
    ```app/components/my-use.js
    import Ember from 'ember';
  
    export default Ember.Component.extend({
      tagName: 'use',
      attributeBindings: ['xlinkHref:xlink:href'],
      xlinkHref: '#triangle'
    });
    ```
  
    Will result in component instances with an HTML representation of:
  
    ```html
    <use xlink:href="#triangle"></use>
    ```
  
    If the return value of an `attributeBindings` monitored property is a boolean
    the attribute will be present or absent depending on the value:
  
    ```app/components/my-text-input.js
    import Ember from 'ember';
  
    export default Ember.Component.extend({
      tagName: 'input',
      attributeBindings: ['disabled'],
      disabled: false
    });
    ```
  
    Will result in a component instance with an HTML representation of:
  
    ```html
    <input id="ember1" class="ember-view" />
    ```
  
    `attributeBindings` can refer to computed properties:
  
    ```app/components/my-text-input.js
    import Ember from 'ember';
  
    export default Ember.Component.extend({
      tagName: 'input',
      attributeBindings: ['disabled'],
      disabled: Ember.computed(function() {
        if (someLogic) {
          return true;
        } else {
          return false;
        }
      })
    });
    ```
  
    To prevent setting an attribute altogether, use `null` or `undefined` as the
    return value of the `attributeBindings` monitored property:
  
    ```app/components/my-text-input.js
    import Ember from 'ember';
  
    export default Ember.Component.extend({
      tagName: 'form',
      attributeBindings: ['novalidate'],
      novalidate: null
    });
    ```
  
    Updates to the property of an attribute binding will result in automatic
    update of the  HTML attribute in the component's rendered HTML representation.
    `attributeBindings` is a concatenated property. See [Ember.Object](/api/classes/Ember.Object.html)
    documentation for more information about concatenated properties.
  
  
    ## Layouts
  
    See [Ember.Templates.helpers.yield](/api/classes/Ember.Templates.helpers.html#method_yield)
    for more information.
  
  
    ## Responding to Browser Events
  
    Components can respond to user-initiated events in one of three ways: method
    implementation, through an event manager, and through `{{action}}` helper use
    in their template or layout.
  
  
    ### Method Implementation
  
    Components can respond to user-initiated events by implementing a method that
    matches the event name. A `jQuery.Event` object will be passed as the
    argument to this method.
  
    ```app/components/my-widget.js
    import Ember from 'ember';
  
    export default Ember.Component.extend({
      click(event) {
        // will be called when an instance's
        // rendered element is clicked
      }
    });
    ```
  
  
    ### `{{action}}` Helper
  
    See [Ember.Templates.helpers.action](/api/classes/Ember.Templates.helpers.html#method_action).
  
  
    ### Event Names
  
    All of the event handling approaches described above respond to the same set
    of events. The names of the built-in events are listed below. (The hash of
    built-in events exists in `Ember.EventDispatcher`.) Additional, custom events
    can be registered by using `Ember.Application.customEvents`.
  
    Touch events:
  
    * `touchStart`
    * `touchMove`
    * `touchEnd`
    * `touchCancel`
  
    Keyboard events:
  
    * `keyDown`
    * `keyUp`
    * `keyPress`
  
    Mouse events:
  
    * `mouseDown`
    * `mouseUp`
    * `contextMenu`
    * `click`
    * `doubleClick`
    * `mouseMove`
    * `focusIn`
    * `focusOut`
    * `mouseEnter`
    * `mouseLeave`
  
    Form events:
  
    * `submit`
    * `change`
    * `focusIn`
    * `focusOut`
    * `input`
  
    HTML5 drag and drop events:
  
    * `dragStart`
    * `drag`
    * `dragEnter`
    * `dragLeave`
    * `dragOver`
    * `dragEnd`
    * `drop`
  
    @class Component
    @namespace Ember
    @extends Ember.CoreView
    @uses Ember.TargetActionSupport
    @uses Ember.ClassNamesSupport
    @uses Ember.ActionSupport
    @uses Ember.ViewMixin
    @uses Ember.ViewStateSupport
    @public
  */
  var Component = _emberViews.CoreView.extend(_emberViews.ChildViewsSupport, _emberViews.ViewStateSupport, _emberViews.ClassNamesSupport, _emberRuntime.TargetActionSupport, _emberViews.ActionSupport, _emberViews.ViewMixin, (_CoreView$extend = {
    isComponent: true,

    init: function () {
      var _this = this;

      this._super.apply(this, arguments);
      this[IS_DISPATCHING_ATTRS] = false;
      this[DIRTY_TAG] = new _glimmerReference.DirtyableTag();
      this[ROOT_REF] = new _emberGlimmerUtilsReferences.RootReference(this);
      this[BOUNDS] = null;

      // If a `defaultLayout` was specified move it to the `layout` prop.
      // `layout` is no longer a CP, so this just ensures that the `defaultLayout`
      // logic is supported with a deprecation
      if (this.defaultLayout && !this.layout) {
        _emberDebug.deprecate('Specifying `defaultLayout` to ' + this + ' is deprecated. Please use `layout` instead.', false, {
          id: 'ember-views.component.defaultLayout',
          until: '3.0.0',
          url: 'http://emberjs.com/deprecations/v2.x/#toc_ember-component-defaultlayout'
        });

        this.layout = this.defaultLayout;
      }

      // If in a tagless component, assert that no event handlers are defined
      _emberDebug.assert('You can not define a function that handles DOM events in the `' + this + '` tagless component since it doesn\'t have any DOM element.', this.tagName !== '' || !this.renderer._destinedForDOM || !(function () {
        var eventDispatcher = _emberUtils.getOwner(_this).lookup('event_dispatcher:main');
        var events = eventDispatcher && eventDispatcher._finalEvents || {};

        for (var key in events) {
          var methodName = events[key];

          if (typeof _this[methodName] === 'function') {
            return true; // indicate that the assertion should be triggered
          }
        }
      })());

      _emberDebug.assert('You cannot use a computed property for the component\'s `tagName` (' + this + ').', !(this.tagName && this.tagName.isDescriptor));
    },

    rerender: function () {
      this[DIRTY_TAG].dirty();
      this._super();
    },

    __defineNonEnumerable: function (property) {
      this[property.name] = property.descriptor.value;
    }

  }, _CoreView$extend[_emberMetal.PROPERTY_DID_CHANGE] = function (key) {
    if (this[IS_DISPATCHING_ATTRS]) {
      return;
    }

    var args = undefined,
        reference = undefined;

    if ((args = this[ARGS]) && (reference = args[key])) {
      if (reference[_emberGlimmerUtilsReferences.UPDATE]) {
        reference[_emberGlimmerUtilsReferences.UPDATE](_emberMetal.get(this, key));
      }
    }
  }, _CoreView$extend.getAttr = function (key) {
    // TODO Intimate API should be deprecated
    return this.get(key);
  }, _CoreView$extend.readDOMAttr = function (name) {
    var element = _emberViews.getViewElement(this);
    return _glimmerRuntime.readDOMAttr(element, name);
  }, _CoreView$extend));

  /**
   The WAI-ARIA role of the control represented by this view. For example, a
   button may have a role of type 'button', or a pane may have a role of
   type 'alertdialog'. This property is used by assistive software to help
   visually challenged users navigate rich web applications.
    The full list of valid WAI-ARIA roles is available at:
   [http://www.w3.org/TR/wai-aria/roles#roles_categorization](http://www.w3.org/TR/wai-aria/roles#roles_categorization)
    @property ariaRole
   @type String
   @default null
   @public
   */

  /**
   Enables components to take a list of parameters as arguments.
   For example, a component that takes two parameters with the names
   `name` and `age`:
    ```javascript
   let MyComponent = Ember.Component.extend;
    MyComponent.reopenClass({
     positionalParams: ['name', 'age']
   });
   ```
    It can then be invoked like this:
    ```hbs
   {{my-component "John" 38}}
   ```
    The parameters can be referred to just like named parameters:
    ```hbs
   Name: {{name}}, Age: {{age}}.
   ```
    Using a string instead of an array allows for an arbitrary number of
   parameters:
    ```javascript
   let MyComponent = Ember.Component.extend;
    MyComponent.reopenClass({
     positionalParams: 'names'
   });
   ```
    It can then be invoked like this:
    ```hbs
   {{my-component "John" "Michael" "Scott"}}
   ```
   The parameters can then be referred to by enumerating over the list:
    ```hbs
   {{#each names as |name|}}{{name}}{{/each}}
   ```
    @static
   @public
   @property positionalParams
   @since 1.13.0
   */

  /**
   Called when the attributes passed into the component have been updated.
   Called both during the initial render of a container and during a rerender.
   Can be used in place of an observer; code placed here will be executed
   every time any attribute updates.
   @method didReceiveAttrs
   @public
   @since 1.13.0
   */

  /**
   Called when the attributes passed into the component have been updated.
   Called both during the initial render of a container and during a rerender.
   Can be used in place of an observer; code placed here will be executed
   every time any attribute updates.
   @event didReceiveAttrs
   @public
   @since 1.13.0
   */

  /**
   Called after a component has been rendered, both on initial render and
   in subsequent rerenders.
   @method didRender
   @public
   @since 1.13.0
   */

  /**
   Called after a component has been rendered, both on initial render and
   in subsequent rerenders.
   @event didRender
   @public
   @since 1.13.0
   */

  /**
   Called before a component has been rendered, both on initial render and
   in subsequent rerenders.
   @method willRender
   @public
   @since 1.13.0
   */

  /**
   Called before a component has been rendered, both on initial render and
   in subsequent rerenders.
   @event willRender
   @public
   @since 1.13.0
   */

  /**
   Called when the attributes passed into the component have been changed.
   Called only during a rerender, not during an initial render.
   @method didUpdateAttrs
   @public
   @since 1.13.0
   */

  /**
   Called when the attributes passed into the component have been changed.
   Called only during a rerender, not during an initial render.
   @event didUpdateAttrs
   @public
   @since 1.13.0
   */

  /**
   Called when the component is about to update and rerender itself.
   Called only during a rerender, not during an initial render.
   @method willUpdate
   @public
   @since 1.13.0
   */

  /**
   Called when the component is about to update and rerender itself.
   Called only during a rerender, not during an initial render.
   @event willUpdate
   @public
   @since 1.13.0
   */

  /**
   Called when the component has updated and rerendered itself.
   Called only during a rerender, not during an initial render.
   @method didUpdate
   @public
   @since 1.13.0
   */

  /**
   Called when the component has updated and rerendered itself.
   Called only during a rerender, not during an initial render.
   @event didUpdate
   @public
   @since 1.13.0
   */

  /**
    A component may contain a layout. A layout is a regular template but
    supersedes the `template` property during rendering. It is the
    responsibility of the layout template to retrieve the `template`
    property from the component (or alternatively, call `Handlebars.helpers.yield`,
    `{{yield}}`) to render it in the correct location.
    This is useful for a component that has a shared wrapper, but which delegates
    the rendering of the contents of the wrapper to the `template` property
    on a subclass.
    @property layout
    @type Function
    @public
  */

  /**
    The name of the layout to lookup if no layout is provided.
    By default `Ember.Component` will lookup a template with this name in
    `Ember.TEMPLATES` (a shared global object).
    @property layoutName
    @type String
    @default null
    @private
  */

  /**
    Returns a jQuery object for this component's element. If you pass in a selector
    string, this method will return a jQuery object, using the current element
    as its buffer.
    For example, calling `component.$('li')` will return a jQuery object containing
    all of the `li` elements inside the DOM element of this component.
    @method $
    @param {String} [selector] a jQuery-compatible selector string
    @return {jQuery} the jQuery object for the DOM node
    @public
  */

  /**
    The HTML `id` of the component's element in the DOM. You can provide this
    value yourself but it must be unique (just as in HTML):
     ```handlebars
    {{my-component elementId="a-really-cool-id"}}
    ```
    If not manually set a default value will be provided by the framework.
    Once rendered an element's `elementId` is considered immutable and you
    should never change it. If you need to compute a dynamic value for the
    `elementId`, you should do this when the component or element is being
    instantiated:
     ```javascript
    export default Ember.Component.extend({
      init() {
        this._super(...arguments);
         var index = this.get('index');
        this.set('elementId', `component-id${index}`);
      }
    });
    ```
     @property elementId
    @type String
    @public
  */

  /**
   If `false`, the view will appear hidden in DOM.
    @property isVisible
   @type Boolean
   @default null
   @public
   */
  Component[_emberUtils.NAME_KEY] = 'Ember.Component';

  Component.reopenClass({
    isComponentFactory: true,
    positionalParams: []
  });

  exports.default = Component;
});

/**
  Normally, Ember's component model is "write-only". The component takes a
  bunch of attributes that it got passed in, and uses them to render its
  template.
   One nice thing about this model is that if you try to set a value to the
  same thing as last time, Ember (through HTMLBars) will avoid doing any
  work on the DOM.
   This is not just a performance optimization. If an attribute has not
  changed, it is important not to clobber the element's "hidden state".
  For example, if you set an input's `value` to the same value as before,
  it will clobber selection state and cursor position. In other words,
  setting an attribute is not **always** idempotent.
   This method provides a way to read an element's attribute and also
  update the last value Ember knows about at the same time. This makes
  setting an attribute idempotent.
   In particular, what this means is that if you get an `<input>` element's
  `value` attribute and then re-render the template with the same value,
  it will avoid clobbering the cursor and selection position.
  Since most attribute sets are idempotent in the browser, you typically
  can get away with reading attributes using jQuery, but the most reliable
  way to do so is through this method.
  @method readDOMAttr
   @param {String} name the name of the attribute
  @return String
  @public
 */
enifed('ember-glimmer/components/checkbox', ['exports', 'ember-metal', 'ember-glimmer/component', 'ember-glimmer/templates/empty'], function (exports, _emberMetal, _emberGlimmerComponent, _emberGlimmerTemplatesEmpty) {
  'use strict';

  /**
  @module ember
  @submodule ember-views
  */

  /**
    The internal class used to create text inputs when the `{{input}}`
    helper is used with `type` of `checkbox`.
  
    See [Ember.Templates.helpers.input](/api/classes/Ember.Templates.helpers.html#method_input)  for usage details.
  
    ## Direct manipulation of `checked`
  
    The `checked` attribute of an `Ember.Checkbox` object should always be set
    through the Ember object or by interacting with its rendered element
    representation via the mouse, keyboard, or touch. Updating the value of the
    checkbox via jQuery will result in the checked value of the object and its
    element losing synchronization.
  
    ## Layout and LayoutName properties
  
    Because HTML `input` elements are self closing `layout` and `layoutName`
    properties will not be applied. See [Ember.View](/api/classes/Ember.View.html)'s
    layout section for more information.
  
    @class Checkbox
    @namespace Ember
    @extends Ember.Component
    @public
  */
  exports.default = _emberGlimmerComponent.default.extend({
    layout: _emberGlimmerTemplatesEmpty.default,
    classNames: ['ember-checkbox'],

    tagName: 'input',

    attributeBindings: ['type', 'checked', 'indeterminate', 'disabled', 'tabindex', 'name', 'autofocus', 'required', 'form'],

    type: 'checkbox',
    checked: false,
    disabled: false,
    indeterminate: false,

    didInsertElement: function () {
      this._super.apply(this, arguments);
      _emberMetal.get(this, 'element').indeterminate = !!_emberMetal.get(this, 'indeterminate');
    },

    change: function () {
      _emberMetal.set(this, 'checked', this.$().prop('checked'));
    }
  });
});
enifed('ember-glimmer/components/link-to', ['exports', 'ember-console', 'ember-debug', 'ember-metal', 'ember-runtime', 'ember-views', 'ember-glimmer/templates/link-to', 'ember-glimmer/component'], function (exports, _emberConsole, _emberDebug, _emberMetal, _emberRuntime, _emberViews, _emberGlimmerTemplatesLinkTo, _emberGlimmerComponent) {
  /**
  @module ember
  @submodule ember-glimmer
  */

  /**
    The `{{link-to}}` component renders a link to the supplied
    `routeName` passing an optionally supplied model to the
    route as its `model` context of the route. The block
    for `{{link-to}}` becomes the innerHTML of the rendered
    element:
  
    ```handlebars
    {{#link-to 'photoGallery'}}
      Great Hamster Photos
    {{/link-to}}
    ```
  
    You can also use an inline form of `{{link-to}}` component by
    passing the link text as the first argument
    to the component:
  
    ```handlebars
    {{link-to 'Great Hamster Photos' 'photoGallery'}}
    ```
  
    Both will result in:
  
    ```html
    <a href="/hamster-photos">
      Great Hamster Photos
    </a>
    ```
  
    ### Supplying a tagName
    By default `{{link-to}}` renders an `<a>` element. This can
    be overridden for a single use of `{{link-to}}` by supplying
    a `tagName` option:
  
    ```handlebars
    {{#link-to 'photoGallery' tagName="li"}}
      Great Hamster Photos
    {{/link-to}}
    ```
  
    ```html
    <li>
      Great Hamster Photos
    </li>
    ```
  
    To override this option for your entire application, see
    "Overriding Application-wide Defaults".
  
    ### Disabling the `link-to` component
    By default `{{link-to}}` is enabled.
    any passed value to the `disabled` component property will disable
    the `link-to` component.
  
    static use: the `disabled` option:
  
    ```handlebars
    {{#link-to 'photoGallery' disabled=true}}
      Great Hamster Photos
    {{/link-to}}
    ```
  
    dynamic use: the `disabledWhen` option:
  
    ```handlebars
    {{#link-to 'photoGallery' disabledWhen=controller.someProperty}}
      Great Hamster Photos
    {{/link-to}}
    ```
  
    any passed value to `disabled` will disable it except `undefined`.
    to ensure that only `true` disable the `link-to` component you can
    override the global behaviour of `Ember.LinkComponent`.
  
    ```javascript
    Ember.LinkComponent.reopen({
      disabled: Ember.computed(function(key, value) {
        if (value !== undefined) {
          this.set('_isDisabled', value === true);
        }
        return value === true ? get(this, 'disabledClass') : false;
      })
    });
    ```
  
    see "Overriding Application-wide Defaults" for more.
  
    ### Handling `href`
    `{{link-to}}` will use your application's Router to
    fill the element's `href` property with a url that
    matches the path to the supplied `routeName` for your
    router's configured `Location` scheme, which defaults
    to Ember.HashLocation.
  
    ### Handling current route
    `{{link-to}}` will apply a CSS class name of 'active'
    when the application's current route matches
    the supplied routeName. For example, if the application's
    current route is 'photoGallery.recent' the following
    use of `{{link-to}}`:
  
    ```handlebars
    {{#link-to 'photoGallery.recent'}}
      Great Hamster Photos
    {{/link-to}}
    ```
  
    will result in
  
    ```html
    <a href="/hamster-photos/this-week" class="active">
      Great Hamster Photos
    </a>
    ```
  
    The CSS class name used for active classes can be customized
    for a single use of `{{link-to}}` by passing an `activeClass`
    option:
  
    ```handlebars
    {{#link-to 'photoGallery.recent' activeClass="current-url"}}
      Great Hamster Photos
    {{/link-to}}
    ```
  
    ```html
    <a href="/hamster-photos/this-week" class="current-url">
      Great Hamster Photos
    </a>
    ```
  
    To override this option for your entire application, see
    "Overriding Application-wide Defaults".
  
    ### Keeping a link active for other routes
  
    If you need a link to be 'active' even when it doesn't match
    the current route, you can use the `current-when` argument.
  
    ```handlebars
    {{#link-to 'photoGallery' current-when='photos'}}
      Photo Gallery
    {{/link-to}}
    ```
  
    This may be helpful for keeping links active for:
  
    * non-nested routes that are logically related
    * some secondary menu approaches
    * 'top navigation' with 'sub navigation' scenarios
  
    A link will be active if `current-when` is `true` or the current
    route is the route this link would transition to.
  
    To match multiple routes 'space-separate' the routes:
  
    ```handlebars
    {{#link-to 'gallery' current-when='photos drawings paintings'}}
      Art Gallery
    {{/link-to}}
    ```
  
    ### Supplying a model
    An optional model argument can be used for routes whose
    paths contain dynamic segments. This argument will become
    the model context of the linked route:
  
    ```javascript
    Router.map(function() {
      this.route("photoGallery", {path: "hamster-photos/:photo_id"});
    });
    ```
  
    ```handlebars
    {{#link-to 'photoGallery' aPhoto}}
      {{aPhoto.title}}
    {{/link-to}}
    ```
  
    ```html
    <a href="/hamster-photos/42">
      Tomster
    </a>
    ```
  
    ### Supplying multiple models
    For deep-linking to route paths that contain multiple
    dynamic segments, multiple model arguments can be used.
    As the router transitions through the route path, each
    supplied model argument will become the context for the
    route with the dynamic segments:
  
    ```javascript
    Router.map(function() {
      this.route("photoGallery", { path: "hamster-photos/:photo_id" }, function() {
        this.route("comment", {path: "comments/:comment_id"});
      });
    });
    ```
    This argument will become the model context of the linked route:
  
    ```handlebars
    {{#link-to 'photoGallery.comment' aPhoto comment}}
      {{comment.body}}
    {{/link-to}}
    ```
  
    ```html
    <a href="/hamster-photos/42/comments/718">
      A+++ would snuggle again.
    </a>
    ```
  
    ### Supplying an explicit dynamic segment value
    If you don't have a model object available to pass to `{{link-to}}`,
    an optional string or integer argument can be passed for routes whose
    paths contain dynamic segments. This argument will become the value
    of the dynamic segment:
  
    ```javascript
    Router.map(function() {
      this.route("photoGallery", { path: "hamster-photos/:photo_id" });
    });
    ```
  
    ```handlebars
    {{#link-to 'photoGallery' aPhotoId}}
      {{aPhoto.title}}
    {{/link-to}}
    ```
  
    ```html
    <a href="/hamster-photos/42">
      Tomster
    </a>
    ```
  
    When transitioning into the linked route, the `model` hook will
    be triggered with parameters including this passed identifier.
  
    ### Allowing Default Action
  
   By default the `{{link-to}}` component prevents the default browser action
   by calling `preventDefault()` as this sort of action bubbling is normally
   handled internally and we do not want to take the browser to a new URL (for
   example).
  
   If you need to override this behavior specify `preventDefault=false` in
   your template:
  
    ```handlebars
    {{#link-to 'photoGallery' aPhotoId preventDefault=false}}
      {{aPhotoId.title}}
    {{/link-to}}
    ```
  
    ### Overriding attributes
    You can override any given property of the `Ember.LinkComponent`
    that is generated by the `{{link-to}}` component by passing
    key/value pairs, like so:
  
    ```handlebars
    {{#link-to  aPhoto tagName='li' title='Following this link will change your life' classNames='pic sweet'}}
      Uh-mazing!
    {{/link-to}}
    ```
  
    See [Ember.LinkComponent](/api/classes/Ember.LinkComponent.html) for a
    complete list of overrideable properties. Be sure to also
    check out inherited properties of `LinkComponent`.
  
    ### Overriding Application-wide Defaults
    ``{{link-to}}`` creates an instance of `Ember.LinkComponent`
    for rendering. To override options for your entire
    application, reopen `Ember.LinkComponent` and supply the
    desired values:
  
    ``` javascript
    Ember.LinkComponent.reopen({
      activeClass: "is-active",
      tagName: 'li'
    })
    ```
  
    It is also possible to override the default event in
    this manner:
  
    ``` javascript
    Ember.LinkComponent.reopen({
      eventName: 'customEventName'
    });
    ```
  
    @method link-to
    @for Ember.Templates.helpers
    @param {String} routeName
    @param {Object} [context]*
    @param [options] {Object} Handlebars key/value pairs of options, you can override any property of Ember.LinkComponent
    @return {String} HTML string
    @see {Ember.LinkComponent}
    @public
  */

  'use strict';

  /**
    `Ember.LinkComponent` renders an element whose `click` event triggers a
    transition of the application's instance of `Ember.Router` to
    a supplied route by name.
  
    `Ember.LinkComponent` components are invoked with {{#link-to}}. Properties
    of this class can be overridden with `reopen` to customize application-wide
    behavior.
  
    @class LinkComponent
    @namespace Ember
    @extends Ember.Component
    @see {Ember.Templates.helpers.link-to}
    @public
  **/
  var LinkComponent = _emberGlimmerComponent.default.extend({
    layout: _emberGlimmerTemplatesLinkTo.default,

    tagName: 'a',

    /**
      @deprecated Use current-when instead.
      @property currentWhen
      @private
    */
    currentWhen: _emberRuntime.deprecatingAlias('current-when', { id: 'ember-routing-view.deprecated-current-when', until: '3.0.0' }),

    /**
      Used to determine when this `LinkComponent` is active.
       @property currentWhen
      @public
    */
    'current-when': null,

    /**
      Sets the `title` attribute of the `LinkComponent`'s HTML element.
       @property title
      @default null
      @public
    **/
    title: null,

    /**
      Sets the `rel` attribute of the `LinkComponent`'s HTML element.
       @property rel
      @default null
      @public
    **/
    rel: null,

    /**
      Sets the `tabindex` attribute of the `LinkComponent`'s HTML element.
       @property tabindex
      @default null
      @public
    **/
    tabindex: null,

    /**
      Sets the `target` attribute of the `LinkComponent`'s HTML element.
       @since 1.8.0
      @property target
      @default null
      @public
    **/
    target: null,

    /**
      The CSS class to apply to `LinkComponent`'s element when its `active`
      property is `true`.
       @property activeClass
      @type String
      @default active
      @public
    **/
    activeClass: 'active',

    /**
      The CSS class to apply to `LinkComponent`'s element when its `loading`
      property is `true`.
       @property loadingClass
      @type String
      @default loading
      @private
    **/
    loadingClass: 'loading',

    /**
      The CSS class to apply to a `LinkComponent`'s element when its `disabled`
      property is `true`.
       @property disabledClass
      @type String
      @default disabled
      @private
    **/
    disabledClass: 'disabled',
    _isDisabled: false,

    /**
      Determines whether the `LinkComponent` will trigger routing via
      the `replaceWith` routing strategy.
       @property replace
      @type Boolean
      @default false
      @public
    **/
    replace: false,

    /**
      By default the `{{link-to}}` component will bind to the `href` and
      `title` attributes. It's discouraged that you override these defaults,
      however you can push onto the array if needed.
       @property attributeBindings
      @type Array | String
      @default ['title', 'rel', 'tabindex', 'target']
      @public
    */
    attributeBindings: ['href', 'title', 'rel', 'tabindex', 'target'],

    /**
      By default the `{{link-to}}` component will bind to the `active`, `loading`,
      and `disabled` classes. It is discouraged to override these directly.
       @property classNameBindings
      @type Array
      @default ['active', 'loading', 'disabled', 'ember-transitioning-in', 'ember-transitioning-out']
      @public
    */
    classNameBindings: ['active', 'loading', 'disabled', 'transitioningIn', 'transitioningOut'],

    /**
      By default the `{{link-to}}` component responds to the `click` event. You
      can override this globally by setting this property to your custom
      event name.
       This is particularly useful on mobile when one wants to avoid the 300ms
      click delay using some sort of custom `tap` event.
       @property eventName
      @type String
      @default click
      @private
    */
    eventName: 'click',

    // this is doc'ed here so it shows up in the events
    // section of the API documentation, which is where
    // people will likely go looking for it.
    /**
      Triggers the `LinkComponent`'s routing behavior. If
      `eventName` is changed to a value other than `click`
      the routing behavior will trigger on that custom event
      instead.
       @event click
      @private
    */

    /**
      An overridable method called when `LinkComponent` objects are instantiated.
       Example:
       ```javascript
      App.MyLinkComponent = Ember.LinkComponent.extend({
        init: function() {
          this._super(...arguments);
          Ember.Logger.log('Event is ' + this.get('eventName'));
        }
      });
      ```
       NOTE: If you do override `init` for a framework class like `Ember.View`,
      be sure to call `this._super(...arguments)` in your
      `init` declaration! If you don't, Ember may not have an opportunity to
      do important setup work, and you'll see strange behavior in your
      application.
       @method init
      @private
    */
    init: function () {
      this._super.apply(this, arguments);

      // Map desired event name to invoke function
      var eventName = _emberMetal.get(this, 'eventName');
      this.on(eventName, this, this._invoke);
    },

    _routing: _emberRuntime.inject.service('-routing'),

    /**
      Accessed as a classname binding to apply the `LinkComponent`'s `disabledClass`
      CSS `class` to the element when the link is disabled.
       When `true` interactions with the element will not trigger route changes.
      @property disabled
      @private
    */
    disabled: _emberMetal.computed({
      get: function (key, value) {
        return false;
      },
      set: function (key, value) {
        if (value !== undefined) {
          this.set('_isDisabled', value);
        }

        return value ? _emberMetal.get(this, 'disabledClass') : false;
      }
    }),

    _computeActive: function (routerState) {
      if (_emberMetal.get(this, 'loading')) {
        return false;
      }

      var routing = _emberMetal.get(this, '_routing');
      var models = _emberMetal.get(this, 'models');
      var resolvedQueryParams = _emberMetal.get(this, 'resolvedQueryParams');

      var currentWhen = _emberMetal.get(this, 'current-when');
      var isCurrentWhenSpecified = !!currentWhen;
      currentWhen = currentWhen || _emberMetal.get(this, 'qualifiedRouteName');
      currentWhen = currentWhen.split(' ');

      for (var i = 0; i < currentWhen.length; i++) {
        if (routing.isActiveForRoute(models, resolvedQueryParams, currentWhen[i], routerState, isCurrentWhenSpecified)) {
          return _emberMetal.get(this, 'activeClass');
        }
      }

      return false;
    },

    /**
      Accessed as a classname binding to apply the `LinkComponent`'s `activeClass`
      CSS `class` to the element when the link is active.
       A `LinkComponent` is considered active when its `currentWhen` property is `true`
      or the application's current route is the route the `LinkComponent` would trigger
      transitions into.
       The `currentWhen` property can match against multiple routes by separating
      route names using the ` ` (space) character.
       @property active
      @private
    */
    active: _emberMetal.computed('attrs.params', '_routing.currentState', function computeLinkToComponentActive() {
      var currentState = _emberMetal.get(this, '_routing.currentState');
      if (!currentState) {
        return false;
      }

      return this._computeActive(currentState);
    }),

    willBeActive: _emberMetal.computed('_routing.targetState', function computeLinkToComponentWillBeActive() {
      var routing = _emberMetal.get(this, '_routing');
      var targetState = _emberMetal.get(routing, 'targetState');
      if (_emberMetal.get(routing, 'currentState') === targetState) {
        return;
      }

      return !!this._computeActive(targetState);
    }),

    transitioningIn: _emberMetal.computed('active', 'willBeActive', function computeLinkToComponentTransitioningIn() {
      var willBeActive = _emberMetal.get(this, 'willBeActive');
      if (typeof willBeActive === 'undefined') {
        return false;
      }

      return !_emberMetal.get(this, 'active') && willBeActive && 'ember-transitioning-in';
    }),

    transitioningOut: _emberMetal.computed('active', 'willBeActive', function computeLinkToComponentTransitioningOut() {
      var willBeActive = _emberMetal.get(this, 'willBeActive');
      if (typeof willBeActive === 'undefined') {
        return false;
      }

      return _emberMetal.get(this, 'active') && !willBeActive && 'ember-transitioning-out';
    }),

    /**
      Event handler that invokes the link, activating the associated route.
       @method _invoke
      @param {Event} event
      @private
    */
    _invoke: function (event) {
      if (!_emberViews.isSimpleClick(event)) {
        return true;
      }

      var preventDefault = _emberMetal.get(this, 'preventDefault');
      var targetAttribute = _emberMetal.get(this, 'target');

      if (preventDefault !== false) {
        if (!targetAttribute || targetAttribute === '_self') {
          event.preventDefault();
        }
      }

      if (_emberMetal.get(this, 'bubbles') === false) {
        event.stopPropagation();
      }

      if (_emberMetal.get(this, '_isDisabled')) {
        return false;
      }

      if (_emberMetal.get(this, 'loading')) {
        _emberConsole.default.warn('This link-to is in an inactive loading state because at least one of its parameters presently has a null/undefined value, or the provided route name is invalid.');
        return false;
      }

      if (targetAttribute && targetAttribute !== '_self') {
        return false;
      }

      var qualifiedRouteName = _emberMetal.get(this, 'qualifiedRouteName');
      var models = _emberMetal.get(this, 'models');
      var queryParams = _emberMetal.get(this, 'queryParams.values');
      var shouldReplace = _emberMetal.get(this, 'replace');

      var payload = {
        queryParams: queryParams,
        routeName: qualifiedRouteName
      };

      _emberMetal.flaggedInstrument('interaction.link-to', payload, this._generateTransition(payload, qualifiedRouteName, models, queryParams, shouldReplace));
    },

    _generateTransition: function (payload, qualifiedRouteName, models, queryParams, shouldReplace) {
      var routing = _emberMetal.get(this, '_routing');
      return function () {
        payload.transition = routing.transitionTo(qualifiedRouteName, models, queryParams, shouldReplace);
      };
    },

    queryParams: null,

    qualifiedRouteName: _emberMetal.computed('targetRouteName', '_routing.currentState', function computeLinkToComponentQualifiedRouteName() {
      var params = _emberMetal.get(this, 'params').slice();
      var lastParam = params[params.length - 1];
      if (lastParam && lastParam.isQueryParams) {
        params.pop();
      }
      var onlyQueryParamsSupplied = this[_emberGlimmerComponent.HAS_BLOCK] ? params.length === 0 : params.length === 1;
      if (onlyQueryParamsSupplied) {
        return _emberMetal.get(this, '_routing.currentRouteName');
      }
      return _emberMetal.get(this, 'targetRouteName');
    }),

    resolvedQueryParams: _emberMetal.computed('queryParams', function computeLinkToComponentResolvedQueryParams() {
      var resolvedQueryParams = {};
      var queryParams = _emberMetal.get(this, 'queryParams');

      if (!queryParams) {
        return resolvedQueryParams;
      }

      var values = queryParams.values;
      for (var key in values) {
        if (!values.hasOwnProperty(key)) {
          continue;
        }
        resolvedQueryParams[key] = values[key];
      }

      return resolvedQueryParams;
    }),

    /**
      Sets the element's `href` attribute to the url for
      the `LinkComponent`'s targeted route.
       If the `LinkComponent`'s `tagName` is changed to a value other
      than `a`, this property will be ignored.
       @property href
      @private
    */
    href: _emberMetal.computed('models', 'qualifiedRouteName', function computeLinkToComponentHref() {
      if (_emberMetal.get(this, 'tagName') !== 'a') {
        return;
      }

      var qualifiedRouteName = _emberMetal.get(this, 'qualifiedRouteName');
      var models = _emberMetal.get(this, 'models');

      if (_emberMetal.get(this, 'loading')) {
        return _emberMetal.get(this, 'loadingHref');
      }

      var routing = _emberMetal.get(this, '_routing');
      var queryParams = _emberMetal.get(this, 'queryParams.values');

      _emberDebug.runInDebug(function () {
        /*
         * Unfortunately, to get decent error messages, we need to do this.
         * In some future state we should be able to use a "feature flag"
         * which allows us to strip this without needing to call it twice.
         *
         * if (isDebugBuild()) {
         *   // Do the useful debug thing, probably including try/catch.
         * } else {
         *   // Do the performant thing.
         * }
         */
        try {
          routing.generateURL(qualifiedRouteName, models, queryParams);
        } catch (e) {
          _emberDebug.assert('You attempted to define a `{{link-to "' + qualifiedRouteName + '"}}` but did not pass the parameters required for generating its dynamic segments. ' + e.message);
        }
      });

      return routing.generateURL(qualifiedRouteName, models, queryParams);
    }),

    loading: _emberMetal.computed('_modelsAreLoaded', 'qualifiedRouteName', function computeLinkToComponentLoading() {
      var qualifiedRouteName = _emberMetal.get(this, 'qualifiedRouteName');
      var modelsAreLoaded = _emberMetal.get(this, '_modelsAreLoaded');

      if (!modelsAreLoaded || qualifiedRouteName == null) {
        return _emberMetal.get(this, 'loadingClass');
      }
    }),

    _modelsAreLoaded: _emberMetal.computed('models', function computeLinkToComponentModelsAreLoaded() {
      var models = _emberMetal.get(this, 'models');
      for (var i = 0; i < models.length; i++) {
        if (models[i] == null) {
          return false;
        }
      }

      return true;
    }),

    _getModels: function (params) {
      var modelCount = params.length - 1;
      var models = new Array(modelCount);

      for (var i = 0; i < modelCount; i++) {
        var value = params[i + 1];

        while (_emberRuntime.ControllerMixin.detect(value)) {
          _emberDebug.deprecate('Providing `{{link-to}}` with a param that is wrapped in a controller is deprecated. ' + (this.parentView ? 'Please update `' + this.parentView + '` to use `{{link-to "post" someController.model}}` instead.' : ''), false, { id: 'ember-routing-views.controller-wrapped-param', until: '3.0.0' });
          value = value.get('model');
        }

        models[i] = value;
      }

      return models;
    },

    /**
      The default href value to use while a link-to is loading.
      Only applies when tagName is 'a'
       @property loadingHref
      @type String
      @default #
      @private
    */
    loadingHref: '#',

    didReceiveAttrs: function () {
      var queryParams = undefined;

      var params = _emberMetal.get(this, 'params');

      if (params) {
        // Do not mutate params in place
        params = params.slice();
      }

      _emberDebug.assert('You must provide one or more parameters to the link-to component.', (function () {
        if (!params) {
          return false;
        }

        return params.length;
      })());

      var disabledWhen = _emberMetal.get(this, 'disabledWhen');
      if (disabledWhen !== undefined) {
        this.set('disabled', disabledWhen);
      }

      // Process the positional arguments, in order.
      // 1. Inline link title comes first, if present.
      if (!this[_emberGlimmerComponent.HAS_BLOCK]) {
        this.set('linkTitle', params.shift());
      }

      // 2. `targetRouteName` is now always at index 0.
      this.set('targetRouteName', params[0]);

      // 3. The last argument (if still remaining) is the `queryParams` object.
      var lastParam = params[params.length - 1];

      if (lastParam && lastParam.isQueryParams) {
        queryParams = params.pop();
      } else {
        queryParams = { values: {} };
      }
      this.set('queryParams', queryParams);

      // 4. Any remaining indices (excepting `targetRouteName` at 0) are `models`.
      if (params.length > 1) {
        this.set('models', this._getModels(params));
      } else {
        this.set('models', []);
      }
    }
  });

  LinkComponent.toString = function () {
    return 'LinkComponent';
  };

  LinkComponent.reopenClass({
    positionalParams: 'params'
  });

  exports.default = LinkComponent;
});
enifed('ember-glimmer/components/text_area', ['exports', 'ember-glimmer/component', 'ember-views', 'ember-glimmer/templates/empty'], function (exports, _emberGlimmerComponent, _emberViews, _emberGlimmerTemplatesEmpty) {
  /**
  @module ember
  @submodule ember-glimmer
  */
  'use strict';

  /**
    `{{textarea}}` inserts a new instance of `<textarea>` tag into the template.
    The attributes of `{{textarea}}` match those of the native HTML tags as
    closely as possible.
  
    The following HTML attributes can be set:
  
      * `value`
      * `name`
      * `rows`
      * `cols`
      * `placeholder`
      * `disabled`
      * `maxlength`
      * `tabindex`
      * `selectionEnd`
      * `selectionStart`
      * `selectionDirection`
      * `wrap`
      * `readonly`
      * `autofocus`
      * `form`
      * `spellcheck`
      * `required`
  
    When set to a quoted string, these value will be directly applied to the HTML
    element. When left unquoted, these values will be bound to a property on the
    template's current rendering context (most typically a controller instance).
  
    Unbound:
  
    ```handlebars
    {{textarea value="Lots of static text that ISN'T bound"}}
    ```
  
    Would result in the following HTML:
  
    ```html
    <textarea class="ember-text-area">
      Lots of static text that ISN'T bound
    </textarea>
    ```
  
    Bound:
  
    In the following example, the `writtenWords` property on `App.ApplicationController`
    will be updated live as the user types 'Lots of text that IS bound' into
    the text area of their browser's window.
  
    ```javascript
    App.ApplicationController = Ember.Controller.extend({
      writtenWords: "Lots of text that IS bound"
    });
    ```
  
    ```handlebars
    {{textarea value=writtenWords}}
    ```
  
     Would result in the following HTML:
  
    ```html
    <textarea class="ember-text-area">
      Lots of text that IS bound
    </textarea>
    ```
  
    If you wanted a one way binding between the text area and a div tag
    somewhere else on your screen, you could use `Ember.computed.oneWay`:
  
    ```javascript
    App.ApplicationController = Ember.Controller.extend({
      writtenWords: "Lots of text that IS bound",
      outputWrittenWords: Ember.computed.oneWay("writtenWords")
    });
    ```
  
    ```handlebars
    {{textarea value=writtenWords}}
    <div>
      {{outputWrittenWords}}
    </div>
    ```
  
    Would result in the following HTML:
  
    ```html
    <textarea class="ember-text-area">
      Lots of text that IS bound
    </textarea>
    <-- the following div will be updated in real time as you type -->
    <div>
      Lots of text that IS bound
    </div>
    ```
  
    Finally, this example really shows the power and ease of Ember when two
    properties are bound to eachother via `Ember.computed.alias`. Type into
    either text area box and they'll both stay in sync. Note that
    `Ember.computed.alias` costs more in terms of performance, so only use it when
    your really binding in both directions:
  
    ```javascript
    App.ApplicationController = Ember.Controller.extend({
      writtenWords: "Lots of text that IS bound",
      twoWayWrittenWords: Ember.computed.alias("writtenWords")
    });
    ```
  
    ```handlebars
    {{textarea value=writtenWords}}
    {{textarea value=twoWayWrittenWords}}
    ```
  
    ```html
    <textarea id="ember1" class="ember-text-area">
      Lots of text that IS bound
    </textarea>
    <-- both updated in real time -->
    <textarea id="ember2" class="ember-text-area">
      Lots of text that IS bound
    </textarea>
    ```
  
    ### Actions
  
    The helper can send multiple actions based on user events.
    The action property defines the action which is send when
    the user presses the return key.
  
    ```handlebars
    {{input action="submit"}}
    ```
  
    The helper allows some user events to send actions.
  
    * `enter`
    * `insert-newline`
    * `escape-press`
    * `focus-in`
    * `focus-out`
    * `key-press`
  
    For example, if you desire an action to be sent when the input is blurred,
    you only need to setup the action name to the event name property.
  
    ```handlebars
    {{textarea focus-out="alertMessage"}}
    ```
  
    See more about [Text Support Actions](/api/classes/Ember.TextArea.html)
  
    ### Extension
  
    Internally, `{{textarea}}` creates an instance of `Ember.TextArea`, passing
    arguments from the helper to `Ember.TextArea`'s `create` method. You can
    extend the capabilities of text areas in your application by reopening this
    class. For example, if you are building a Bootstrap project where `data-*`
    attributes are used, you can globally add support for a `data-*` attribute
    on all `{{textarea}}`s' in your app by reopening `Ember.TextArea` or
    `Ember.TextSupport` and adding it to the `attributeBindings` concatenated
    property:
  
    ```javascript
    Ember.TextArea.reopen({
      attributeBindings: ['data-error']
    });
    ```
  
    Keep in mind when writing `Ember.TextArea` subclasses that `Ember.TextArea`
    itself extends `Ember.Component`. Expect isolated component semantics, not
    legacy 1.x view semantics (like `controller` being present).
  
    See more about [Ember components](/api/classes/Ember.Component.html)
  
    @method textarea
    @for Ember.Templates.helpers
    @param {Hash} options
    @public
  */

  /**
    The internal class used to create textarea element when the `{{textarea}}`
    helper is used.
  
    See [Ember.Templates.helpers.textarea](/api/classes/Ember.Templates.helpers.html#method_textarea)  for usage details.
  
    ## Layout and LayoutName properties
  
    Because HTML `textarea` elements do not contain inner HTML the `layout` and
    `layoutName` properties will not be applied. See [Ember.View](/api/classes/Ember.View.html)'s
    layout section for more information.
  
    @class TextArea
    @namespace Ember
    @extends Ember.Component
    @uses Ember.TextSupport
    @public
  */
  exports.default = _emberGlimmerComponent.default.extend(_emberViews.TextSupport, {
    classNames: ['ember-text-area'],

    layout: _emberGlimmerTemplatesEmpty.default,

    tagName: 'textarea',
    attributeBindings: ['rows', 'cols', 'name', 'selectionEnd', 'selectionStart', 'wrap', 'lang', 'dir', 'value'],
    rows: null,
    cols: null
  });
});
enifed('ember-glimmer/components/text_field', ['exports', 'ember-metal', 'ember-environment', 'ember-glimmer/component', 'ember-glimmer/templates/empty', 'ember-views'], function (exports, _emberMetal, _emberEnvironment, _emberGlimmerComponent, _emberGlimmerTemplatesEmpty, _emberViews) {
  /**
  @module ember
  @submodule ember-views
  */
  'use strict';

  var inputTypeTestElement = undefined;
  var inputTypes = Object.create(null);
  function canSetTypeOfInput(type) {
    if (type in inputTypes) {
      return inputTypes[type];
    }

    // if running in outside of a browser always return the
    // original type
    if (!_emberEnvironment.environment.hasDOM) {
      inputTypes[type] = type;

      return type;
    }

    if (!inputTypeTestElement) {
      inputTypeTestElement = document.createElement('input');
    }

    try {
      inputTypeTestElement.type = type;
    } catch (e) {
      // ignored
    }

    return inputTypes[type] = inputTypeTestElement.type === type;
  }

  /**
  
    The internal class used to create text inputs when the `{{input}}`
    helper is used with `type` of `text`.
  
    See [Ember.Templates.helpers.input](/api/classes/Ember.Templates.helpers.html#method_input)  for usage details.
  
    ## Layout and LayoutName properties
  
    Because HTML `input` elements are self closing `layout` and `layoutName`
    properties will not be applied. See [Ember.View](/api/classes/Ember.View.html)'s
    layout section for more information.
  
    @class TextField
    @namespace Ember
    @extends Ember.Component
    @uses Ember.TextSupport
    @public
  */
  exports.default = _emberGlimmerComponent.default.extend(_emberViews.TextSupport, {
    layout: _emberGlimmerTemplatesEmpty.default,
    classNames: ['ember-text-field'],
    tagName: 'input',
    attributeBindings: ['accept', 'autocomplete', 'autosave', 'dir', 'formaction', 'formenctype', 'formmethod', 'formnovalidate', 'formtarget', 'height', 'inputmode', 'lang', 'list', 'max', 'min', 'multiple', 'name', 'pattern', 'size', 'step', 'type', 'value', 'width'],

    /**
      The `value` attribute of the input element. As the user inputs text, this
      property is updated live.
       @property value
      @type String
      @default ""
      @public
    */
    value: '',

    /**
      The `type` attribute of the input element.
       @property type
      @type String
      @default "text"
      @public
    */
    type: _emberMetal.computed({
      get: function () {
        return 'text';
      },

      set: function (key, value) {
        var type = 'text';

        if (canSetTypeOfInput(value)) {
          type = value;
        }

        return type;
      }
    }),

    /**
      The `size` of the text field in characters.
       @property size
      @type String
      @default null
      @public
    */
    size: null,

    /**
      The `pattern` attribute of input element.
       @property pattern
      @type String
      @default null
      @public
    */
    pattern: null,

    /**
      The `min` attribute of input element used with `type="number"` or `type="range"`.
       @property min
      @type String
      @default null
      @since 1.4.0
      @public
    */
    min: null,

    /**
      The `max` attribute of input element used with `type="number"` or `type="range"`.
       @property max
      @type String
      @default null
      @since 1.4.0
      @public
    */
    max: null
  });
});
enifed('ember-glimmer/dom', ['exports', '@glimmer/runtime', '@glimmer/node'], function (exports, _glimmerRuntime, _glimmerNode) {
  'use strict';

  exports.DOMChanges = _glimmerRuntime.DOMChanges;
  exports.DOMTreeConstruction = _glimmerRuntime.DOMTreeConstruction;
  exports.NodeDOMTreeConstruction = _glimmerNode.NodeDOMTreeConstruction;
});
enifed('ember-glimmer/environment', ['exports', 'ember-utils', 'ember-metal', 'ember-debug', 'ember-views', '@glimmer/runtime', 'ember-glimmer/syntax/curly-component', 'ember-glimmer/syntax', 'ember-glimmer/utils/iterable', 'ember-glimmer/utils/references', 'ember-glimmer/utils/debug-stack', 'ember-glimmer/helpers/if-unless', 'ember-glimmer/helpers/action', 'ember-glimmer/helpers/component', 'ember-glimmer/helpers/concat', 'ember-glimmer/helpers/get', 'ember-glimmer/helpers/hash', 'ember-glimmer/helpers/loc', 'ember-glimmer/helpers/log', 'ember-glimmer/helpers/mut', 'ember-glimmer/helpers/readonly', 'ember-glimmer/helpers/unbound', 'ember-glimmer/helpers/-class', 'ember-glimmer/helpers/-input-type', 'ember-glimmer/helpers/query-param', 'ember-glimmer/helpers/each-in', 'ember-glimmer/helpers/-normalize-class', 'ember-glimmer/helpers/-html-safe', 'ember-glimmer/protocol-for-url', 'container', 'ember-glimmer/modifiers/action'], function (exports, _emberUtils, _emberMetal, _emberDebug, _emberViews, _glimmerRuntime, _emberGlimmerSyntaxCurlyComponent, _emberGlimmerSyntax, _emberGlimmerUtilsIterable, _emberGlimmerUtilsReferences, _emberGlimmerUtilsDebugStack, _emberGlimmerHelpersIfUnless, _emberGlimmerHelpersAction, _emberGlimmerHelpersComponent, _emberGlimmerHelpersConcat, _emberGlimmerHelpersGet, _emberGlimmerHelpersHash, _emberGlimmerHelpersLoc, _emberGlimmerHelpersLog, _emberGlimmerHelpersMut, _emberGlimmerHelpersReadonly, _emberGlimmerHelpersUnbound, _emberGlimmerHelpersClass, _emberGlimmerHelpersInputType, _emberGlimmerHelpersQueryParam, _emberGlimmerHelpersEachIn, _emberGlimmerHelpersNormalizeClass, _emberGlimmerHelpersHtmlSafe, _emberGlimmerProtocolForUrl, _container, _emberGlimmerModifiersAction) {
  'use strict';

  var Environment = (function (_GlimmerEnvironment) {
    babelHelpers.inherits(Environment, _GlimmerEnvironment);

    Environment.create = function create(options) {
      return new Environment(options);
    };

    function Environment(_ref) {
      var _this = this;

      var owner = _ref[_emberUtils.OWNER];
      babelHelpers.classCallCheck(this, Environment);

      _GlimmerEnvironment.apply(this, arguments);
      this.owner = owner;
      this.isInteractive = owner.lookup('-environment:main').isInteractive;

      // can be removed once https://github.com/tildeio/glimmer/pull/305 lands
      this.destroyedComponents = [];

      _emberGlimmerProtocolForUrl.default(this);

      this._definitionCache = new _emberMetal.Cache(2000, function (_ref2) {
        var name = _ref2.name;
        var source = _ref2.source;
        var owner = _ref2.owner;

        var _lookupComponent = _emberViews.lookupComponent(owner, name, { source: source });

        var componentFactory = _lookupComponent.component;
        var layout = _lookupComponent.layout;

        if (componentFactory || layout) {
          return new _emberGlimmerSyntaxCurlyComponent.CurlyComponentDefinition(name, componentFactory, layout);
        }
      }, function (_ref3) {
        var name = _ref3.name;
        var source = _ref3.source;
        var owner = _ref3.owner;

        var expandedName = source && owner._resolveLocalLookupName(name, source) || name;
        var ownerGuid = _emberUtils.guidFor(owner);

        return ownerGuid + '|' + expandedName;
      });

      this._templateCache = new _emberMetal.Cache(1000, function (_ref4) {
        var Template = _ref4.Template;
        var owner = _ref4.owner;

        if (Template.create) {
          var _Template$create;

          // we received a factory
          return Template.create((_Template$create = { env: _this }, _Template$create[_emberUtils.OWNER] = owner, _Template$create));
        } else {
          // we were provided an instance already
          return Template;
        }
      }, function (_ref5) {
        var Template = _ref5.Template;
        var owner = _ref5.owner;
        return _emberUtils.guidFor(owner) + '|' + Template.id;
      });

      this._compilerCache = new _emberMetal.Cache(10, function (Compiler) {
        return new _emberMetal.Cache(2000, function (template) {
          var compilable = new Compiler(template);
          return _glimmerRuntime.compileLayout(compilable, _this);
        }, function (template) {
          var owner = template.meta.owner;
          return _emberUtils.guidFor(owner) + '|' + template.id;
        });
      }, function (Compiler) {
        return Compiler.id;
      });

      this.builtInModifiers = {
        action: new _emberGlimmerModifiersAction.default()
      };

      this.builtInHelpers = {
        if: _emberGlimmerHelpersIfUnless.inlineIf,
        action: _emberGlimmerHelpersAction.default,
        component: _emberGlimmerHelpersComponent.default,
        concat: _emberGlimmerHelpersConcat.default,
        get: _emberGlimmerHelpersGet.default,
        hash: _emberGlimmerHelpersHash.default,
        loc: _emberGlimmerHelpersLoc.default,
        log: _emberGlimmerHelpersLog.default,
        mut: _emberGlimmerHelpersMut.default,
        'query-params': _emberGlimmerHelpersQueryParam.default,
        readonly: _emberGlimmerHelpersReadonly.default,
        unbound: _emberGlimmerHelpersUnbound.default,
        unless: _emberGlimmerHelpersIfUnless.inlineUnless,
        '-class': _emberGlimmerHelpersClass.default,
        '-each-in': _emberGlimmerHelpersEachIn.default,
        '-input-type': _emberGlimmerHelpersInputType.default,
        '-normalize-class': _emberGlimmerHelpersNormalizeClass.default,
        '-html-safe': _emberGlimmerHelpersHtmlSafe.default,
        '-get-dynamic-var': _glimmerRuntime.getDynamicVar
      };

      _emberDebug.runInDebug(function () {
        return _this.debugStack = new _emberGlimmerUtilsDebugStack.default();
      });
    }

    Environment.prototype.macros = function macros() {
      var macros = _GlimmerEnvironment.prototype.macros.call(this);
      _emberGlimmerSyntax.populateMacros(macros.blocks, macros.inlines);
      return macros;
    };

    Environment.prototype.hasComponentDefinition = function hasComponentDefinition() {
      return false;
    };

    Environment.prototype.getComponentDefinition = function getComponentDefinition(path, symbolTable) {
      var name = path[0];
      var blockMeta = symbolTable.getMeta();
      var owner = blockMeta.owner;
      var source = blockMeta.moduleName && 'template:' + blockMeta.moduleName;

      return this._definitionCache.get({ name: name, source: source, owner: owner });
    };

    // normally templates should be exported at the proper module name
    // and cached in the container, but this cache supports templates
    // that have been set directly on the component's layout property

    Environment.prototype.getTemplate = function getTemplate(Template, owner) {
      return this._templateCache.get({ Template: Template, owner: owner });
    };

    // a Compiler can wrap the template so it needs its own cache

    Environment.prototype.getCompiledBlock = function getCompiledBlock(Compiler, template) {
      var compilerCache = this._compilerCache.get(Compiler);
      return compilerCache.get(template);
    };

    Environment.prototype.hasPartial = function hasPartial(name, symbolTable) {
      var _symbolTable$getMeta = symbolTable.getMeta();

      var owner = _symbolTable$getMeta.owner;

      return _emberViews.hasPartial(name, owner);
    };

    Environment.prototype.lookupPartial = function lookupPartial(name, symbolTable) {
      var _symbolTable$getMeta2 = symbolTable.getMeta();

      var owner = _symbolTable$getMeta2.owner;

      var partial = {
        template: _emberViews.lookupPartial(name, owner)
      };

      if (partial.template) {
        return partial;
      } else {
        throw new Error(name + ' is not a partial');
      }
    };

    Environment.prototype.hasHelper = function hasHelper(name, symbolTable) {
      if (this.builtInHelpers[name]) {
        return true;
      }

      var blockMeta = symbolTable.getMeta();
      var owner = blockMeta.owner;
      var options = { source: 'template:' + blockMeta.moduleName };

      return owner.hasRegistration('helper:' + name, options) || owner.hasRegistration('helper:' + name);
    };

    Environment.prototype.lookupHelper = function lookupHelper(name, symbolTable) {
      var helper = this.builtInHelpers[name];

      if (helper) {
        return helper;
      }

      var blockMeta = symbolTable.getMeta();
      var owner = blockMeta.owner;
      var options = blockMeta.moduleName && { source: 'template:' + blockMeta.moduleName } || {};

      if (true) {
        var _ret = (function () {
          var helperFactory = owner[_container.FACTORY_FOR]('helper:' + name, options) || owner[_container.FACTORY_FOR]('helper:' + name);

          // TODO: try to unify this into a consistent protocol to avoid wasteful closure allocations
          if (helperFactory.class.isHelperInstance) {
            return {
              v: function (vm, args) {
                return _emberGlimmerUtilsReferences.SimpleHelperReference.create(helperFactory.class.compute, args);
              }
            };
          } else if (helperFactory.class.isHelperFactory) {
            if (!true) {
              helperFactory = helperFactory.create();
            }
            return {
              v: function (vm, args) {
                return _emberGlimmerUtilsReferences.ClassBasedHelperReference.create(helperFactory, vm, args);
              }
            };
          } else {
            throw new Error(name + ' is not a helper');
          }
        })();

        if (typeof _ret === 'object') return _ret.v;
      } else {
        var _ret2 = (function () {
          var helperFactory = owner.lookup('helper:' + name, options) || owner.lookup('helper:' + name);

          // TODO: try to unify this into a consistent protocol to avoid wasteful closure allocations
          if (helperFactory.isHelperInstance) {
            return {
              v: function (vm, args) {
                return _emberGlimmerUtilsReferences.SimpleHelperReference.create(helperFactory.compute, args);
              }
            };
          } else if (helperFactory.isHelperFactory) {
            return {
              v: function (vm, args) {
                return _emberGlimmerUtilsReferences.ClassBasedHelperReference.create(helperFactory, vm, args);
              }
            };
          } else {
            throw new Error(name + ' is not a helper');
          }
        })();

        if (typeof _ret2 === 'object') return _ret2.v;
      }
    };

    Environment.prototype.hasModifier = function hasModifier(name) {
      return !!this.builtInModifiers[name];
    };

    Environment.prototype.lookupModifier = function lookupModifier(name) {
      var modifier = this.builtInModifiers[name];

      if (modifier) {
        return modifier;
      } else {
        throw new Error(name + ' is not a modifier');
      }
    };

    Environment.prototype.toConditionalReference = function toConditionalReference(reference) {
      return _emberGlimmerUtilsReferences.ConditionalReference.create(reference);
    };

    Environment.prototype.iterableFor = function iterableFor(ref, args) {
      var keyPath = args.named.get('key').value();
      return _emberGlimmerUtilsIterable.default(ref, keyPath);
    };

    Environment.prototype.scheduleInstallModifier = function scheduleInstallModifier() {
      if (this.isInteractive) {
        var _GlimmerEnvironment$prototype$scheduleInstallModifier;

        (_GlimmerEnvironment$prototype$scheduleInstallModifier = _GlimmerEnvironment.prototype.scheduleInstallModifier).call.apply(_GlimmerEnvironment$prototype$scheduleInstallModifier, [this].concat(babelHelpers.slice.call(arguments)));
      }
    };

    Environment.prototype.scheduleUpdateModifier = function scheduleUpdateModifier() {
      if (this.isInteractive) {
        var _GlimmerEnvironment$prototype$scheduleUpdateModifier;

        (_GlimmerEnvironment$prototype$scheduleUpdateModifier = _GlimmerEnvironment.prototype.scheduleUpdateModifier).call.apply(_GlimmerEnvironment$prototype$scheduleUpdateModifier, [this].concat(babelHelpers.slice.call(arguments)));
      }
    };

    Environment.prototype.didDestroy = function didDestroy(destroyable) {
      destroyable.destroy();
    };

    Environment.prototype.begin = function begin() {
      this.inTransaction = true;

      _GlimmerEnvironment.prototype.begin.call(this);
    };

    Environment.prototype.commit = function commit() {
      var destroyedComponents = this.destroyedComponents;
      this.destroyedComponents = [];
      // components queued for destruction must be destroyed before firing
      // `didCreate` to prevent errors when removing and adding a component
      // with the same name (would throw an error when added to view registry)
      for (var i = 0; i < destroyedComponents.length; i++) {
        destroyedComponents[i].destroy();
      }

      _GlimmerEnvironment.prototype.commit.call(this);

      this.inTransaction = false;
    };

    return Environment;
  })(_glimmerRuntime.Environment);

  exports.default = Environment;

  _emberDebug.runInDebug(function () {
    var StyleAttributeManager = (function (_AttributeManager) {
      babelHelpers.inherits(StyleAttributeManager, _AttributeManager);

      function StyleAttributeManager() {
        babelHelpers.classCallCheck(this, StyleAttributeManager);

        _AttributeManager.apply(this, arguments);
      }

      StyleAttributeManager.prototype.setAttribute = function setAttribute(dom, element, value) {
        var _AttributeManager$prototype$setAttribute;

        _emberDebug.warn(_emberViews.constructStyleDeprecationMessage(value), (function () {
          if (value === null || value === undefined || _glimmerRuntime.isSafeString(value)) {
            return true;
          }
          return false;
        })(), { id: 'ember-htmlbars.style-xss-warning' });
        (_AttributeManager$prototype$setAttribute = _AttributeManager.prototype.setAttribute).call.apply(_AttributeManager$prototype$setAttribute, [this].concat(babelHelpers.slice.call(arguments)));
      };

      StyleAttributeManager.prototype.updateAttribute = function updateAttribute(dom, element, value) {
        var _AttributeManager$prototype$updateAttribute;

        _emberDebug.warn(_emberViews.constructStyleDeprecationMessage(value), (function () {
          if (value === null || value === undefined || _glimmerRuntime.isSafeString(value)) {
            return true;
          }
          return false;
        })(), { id: 'ember-htmlbars.style-xss-warning' });
        (_AttributeManager$prototype$updateAttribute = _AttributeManager.prototype.updateAttribute).call.apply(_AttributeManager$prototype$updateAttribute, [this].concat(babelHelpers.slice.call(arguments)));
      };

      return StyleAttributeManager;
    })(_glimmerRuntime.AttributeManager);

    var STYLE_ATTRIBUTE_MANANGER = new StyleAttributeManager('style');

    Environment.prototype.attributeFor = function (element, attribute, isTrusting, namespace) {
      if (attribute === 'style' && !isTrusting) {
        return STYLE_ATTRIBUTE_MANANGER;
      }

      return _glimmerRuntime.Environment.prototype.attributeFor.call(this, element, attribute, isTrusting);
    };
  });
});
enifed('ember-glimmer/helper', ['exports', 'ember-utils', 'ember-runtime', '@glimmer/reference'], function (exports, _emberUtils, _emberRuntime, _glimmerReference) {
  /**
  @module ember
  @submodule ember-glimmer
  */

  'use strict';

  exports.helper = helper;
  var RECOMPUTE_TAG = _emberUtils.symbol('RECOMPUTE_TAG');

  exports.RECOMPUTE_TAG = RECOMPUTE_TAG;
  /**
    Ember Helpers are functions that can compute values, and are used in templates.
    For example, this code calls a helper named `format-currency`:
  
    ```handlebars
    <div>{{format-currency cents currency="$"}}</div>
    ```
  
    Additionally a helper can be called as a nested helper (sometimes called a
    subexpression). In this example, the computed value of a helper is passed
    to a component named `show-money`:
  
    ```handlebars
    {{show-money amount=(format-currency cents currency="$")}}
    ```
  
    Helpers defined using a class must provide a `compute` function. For example:
  
    ```js
    export default Ember.Helper.extend({
      compute(params, hash) {
        let cents = params[0];
        let currency = hash.currency;
        return `${currency}${cents * 0.01}`;
      }
    });
    ```
  
    Each time the input to a helper changes, the `compute` function will be
    called again.
  
    As instances, these helpers also have access to the container an will accept
    injected dependencies.
  
    Additionally, class helpers can call `recompute` to force a new computation.
  
    @class Ember.Helper
    @public
    @since 1.13.0
  */
  var Helper = _emberRuntime.FrameworkObject.extend({
    isHelperInstance: true,

    init: function () {
      this._super.apply(this, arguments);
      this[RECOMPUTE_TAG] = new _glimmerReference.DirtyableTag();
    },

    /**
      On a class-based helper, it may be useful to force a recomputation of that
      helpers value. This is akin to `rerender` on a component.
       For example, this component will rerender when the `currentUser` on a
      session service changes:
       ```js
      // app/helpers/current-user-email.js
      export default Ember.Helper.extend({
        session: Ember.inject.service(),
        onNewUser: Ember.observer('session.currentUser', function() {
          this.recompute();
        }),
        compute() {
          return this.get('session.currentUser.email');
        }
      });
      ```
       @method recompute
      @public
      @since 1.13.0
    */
    recompute: function () {
      this[RECOMPUTE_TAG].dirty();
    }

    /**
      Override this function when writing a class-based helper.
       @method compute
      @param {Array} params The positional arguments to the helper
      @param {Object} hash The named arguments to the helper
      @public
      @since 1.13.0
    */
  });

  Helper.reopenClass({
    isHelperFactory: true
  });

  /**
    In many cases, the ceremony of a full `Ember.Helper` class is not required.
    The `helper` method create pure-function helpers without instances. For
    example:
  
    ```js
    // app/helpers/format-currency.js
    export default Ember.Helper.helper(function(params, hash) {
      let cents = params[0];
      let currency = hash.currency;
      return `${currency}${cents * 0.01}`;
    });
    ```
  
    @static
    @param {Function} helper The helper function
    @method helper
    @public
    @since 1.13.0
  */

  function helper(helperFn) {
    return {
      isHelperInstance: true,
      compute: helperFn
    };
  }

  exports.default = Helper;
});
enifed('ember-glimmer/helpers/-class', ['exports', 'ember-glimmer/utils/references', 'ember-runtime'], function (exports, _emberGlimmerUtilsReferences, _emberRuntime) {
  'use strict';

  function classHelper(_ref) {
    var positional = _ref.positional;

    var path = positional.at(0);
    var args = positional.length;
    var value = path.value();

    if (value === true) {
      if (args > 1) {
        return _emberRuntime.String.dasherize(positional.at(1).value());
      }
      return null;
    }

    if (value === false) {
      if (args > 2) {
        return _emberRuntime.String.dasherize(positional.at(2).value());
      }
      return null;
    }

    return value;
  }

  exports.default = function (vm, args) {
    return new _emberGlimmerUtilsReferences.InternalHelperReference(classHelper, args);
  };
});
enifed('ember-glimmer/helpers/-html-safe', ['exports', 'ember-glimmer/utils/references', 'ember-glimmer/utils/string'], function (exports, _emberGlimmerUtilsReferences, _emberGlimmerUtilsString) {
  'use strict';

  function htmlSafe(_ref) {
    var positional = _ref.positional;

    var path = positional.at(0);
    return new _emberGlimmerUtilsString.SafeString(path.value());
  }

  exports.default = function (vm, args) {
    return new _emberGlimmerUtilsReferences.InternalHelperReference(htmlSafe, args);
  };
});
enifed('ember-glimmer/helpers/-input-type', ['exports', 'ember-glimmer/utils/references'], function (exports, _emberGlimmerUtilsReferences) {
  'use strict';

  function inputTypeHelper(_ref) {
    var positional = _ref.positional;
    var named = _ref.named;

    var type = positional.at(0).value();
    if (type === 'checkbox') {
      return '-checkbox';
    }
    return '-text-field';
  }

  exports.default = function (vm, args) {
    return new _emberGlimmerUtilsReferences.InternalHelperReference(inputTypeHelper, args);
  };
});
enifed('ember-glimmer/helpers/-normalize-class', ['exports', 'ember-glimmer/utils/references', 'ember-runtime'], function (exports, _emberGlimmerUtilsReferences, _emberRuntime) {
  'use strict';

  function normalizeClass(_ref) {
    var positional = _ref.positional;
    var named = _ref.named;

    var classNameParts = positional.at(0).value().split('.');
    var className = classNameParts[classNameParts.length - 1];
    var value = positional.at(1).value();

    if (value === true) {
      return _emberRuntime.String.dasherize(className);
    } else if (!value && value !== 0) {
      return '';
    } else {
      return String(value);
    }
  }

  exports.default = function (vm, args) {
    return new _emberGlimmerUtilsReferences.InternalHelperReference(normalizeClass, args);
  };
});
enifed('ember-glimmer/helpers/action', ['exports', 'ember-utils', 'ember-metal', 'ember-glimmer/utils/references', '@glimmer/runtime', '@glimmer/reference', 'ember-debug'], function (exports, _emberUtils, _emberMetal, _emberGlimmerUtilsReferences, _glimmerRuntime, _glimmerReference, _emberDebug) {
  /**
  @module ember
  @submodule ember-glimmer
  */
  'use strict';

  var INVOKE = _emberUtils.symbol('INVOKE');
  exports.INVOKE = INVOKE;
  var ACTION = _emberUtils.symbol('ACTION');

  exports.ACTION = ACTION;
  /**
    The `{{action}}` helper provides a way to pass triggers for behavior (usually
    just a function) between components, and into components from controllers.
  
    ### Passing functions with the action helper
  
    There are three contexts an action helper can be used in. The first two
    contexts to discuss are attribute context, and Handlebars value context.
  
    ```handlebars
    {{! An example of attribute context }}
    <div onclick={{action "save"}}></div>
    {{! Examples of Handlebars value context }}
    {{input on-input=(action "save")}}
    {{yield (action "refreshData") andAnotherParam}}
    ```
  
    In these contexts,
    the helper is called a "closure action" helper. Its behavior is simple:
    If passed a function name, read that function off the `actions` property
    of the current context. Once that function is read (or if a function was
    passed), create a closure over that function and any arguments.
    The resulting value of an action helper used this way is simply a function.
  
    For example, in the attribute context:
  
    ```handlebars
    {{! An example of attribute context }}
    <div onclick={{action "save"}}></div>
    ```
  
    The resulting template render logic would be:
  
    ```js
    var div = document.createElement('div');
    var actionFunction = (function(context){
      return function() {
        return context.actions.save.apply(context, arguments);
      };
    })(context);
    div.onclick = actionFunction;
    ```
  
    Thus when the div is clicked, the action on that context is called.
    Because the `actionFunction` is just a function, closure actions can be
    passed between components and still execute in the correct context.
  
    Here is an example action handler on a component:
  
    ```js
    import Ember from 'ember';
  
    export default Ember.Component.extend({
      actions: {
        save() {
          this.get('model').save();
        }
      }
    });
    ```
  
    Actions are always looked up on the `actions` property of the current context.
    This avoids collisions in the naming of common actions, such as `destroy`.
    Two options can be passed to the `action` helper when it is used in this way.
  
    * `target=someProperty` will look to `someProperty` instead of the current
      context for the `actions` hash. This can be useful when targetting a
      service for actions.
    * `value="target.value"` will read the path `target.value` off the first
      argument to the action when it is called and rewrite the first argument
      to be that value. This is useful when attaching actions to event listeners.
  
    ### Invoking an action
  
    Closure actions curry both their scope and any arguments. When invoked, any
    additional arguments are added to the already curried list.
    Actions should be invoked using the [sendAction](/api/classes/Ember.Component.html#method_sendAction)
    method. The first argument to `sendAction` is the action to be called, and
    additional arguments are passed to the action function. This has interesting
    properties combined with currying of arguments. For example:
  
    ```js
    export default Ember.Component.extend({
      actions: {
        // Usage {{input on-input=(action (action 'setName' model) value="target.value")}}
        setName(model, name) {
          model.set('name', name);
        }
      }
    });
    ```
  
    The first argument (`model`) was curried over, and the run-time argument (`event`)
    becomes a second argument. Action calls can be nested this way because each simply
    returns a function. Any function can be passed to the `{{action}}` helper, including
    other actions.
  
    Actions invoked with `sendAction` have the same currying behavior as demonstrated
    with `on-input` above. For example:
  
    ```app/components/my-input.js
    import Ember from 'ember';
  
    export default Ember.Component.extend({
      actions: {
        setName(model, name) {
          model.set('name', name);
        }
      }
    });
    ```
  
    ```handlebars
    {{my-input submit=(action 'setName' model)}}
    ```
  
    ```app/components/my-component.js
    import Ember from 'ember';
  
    export default Ember.Component.extend({
      click() {
        // Note that model is not passed, it was curried in the template
        this.sendAction('submit', 'bob');
      }
    });
    ```
  
    ### Attaching actions to DOM elements
  
    The third context of the `{{action}}` helper can be called "element space".
    For example:
  
    ```handlebars
    {{! An example of element space }}
    <div {{action "save"}}></div>
    ```
  
    Used this way, the `{{action}}` helper provides a useful shortcut for
    registering an HTML element in a template for a single DOM event and
    forwarding that interaction to the template's context (controller or component).
    If the context of a template is a controller, actions used this way will
    bubble to routes when the controller does not implement the specified action.
    Once an action hits a route, it will bubble through the route hierarchy.
  
    ### Event Propagation
  
    `{{action}}` helpers called in element space can control event bubbling. Note
    that the closure style actions cannot.
  
    Events triggered through the action helper will automatically have
    `.preventDefault()` called on them. You do not need to do so in your event
    handlers. If you need to allow event propagation (to handle file inputs for
    example) you can supply the `preventDefault=false` option to the `{{action}}` helper:
  
    ```handlebars
    <div {{action "sayHello" preventDefault=false}}>
      <input type="file" />
      <input type="checkbox" />
    </div>
    ```
  
    To disable bubbling, pass `bubbles=false` to the helper:
  
    ```handlebars
    <button {{action 'edit' post bubbles=false}}>Edit</button>
    ```
  
    To disable bubbling with closure style actions you must create your own
    wrapper helper that makes use of `event.stopPropagation()`:
  
    ```handlebars
    <div onclick={{disable-bubbling (action "sayHello")}}>Hello</div>
    ```
  
    ```app/helpers/disable-bubbling.js
    import Ember from 'ember';
  
    export function disableBubbling([action]) {
      return function(event) {
        event.stopPropagation();
        return action(event);
      };
    }
    export default Ember.Helper.helper(disableBubbling);
    ```
  
    If you need the default handler to trigger you should either register your
    own event handler, or use event methods on your view class. See
    ["Responding to Browser Events"](/api/classes/Ember.View.html#toc_responding-to-browser-events)
    in the documentation for Ember.View for more information.
  
    ### Specifying DOM event type
  
    `{{action}}` helpers called in element space can specify an event type.
    By default the `{{action}}` helper registers for DOM `click` events. You can
    supply an `on` option to the helper to specify a different DOM event name:
  
    ```handlebars
    <div {{action "anActionName" on="doubleClick"}}>
      click me
    </div>
    ```
  
    See ["Event Names"](/api/classes/Ember.View.html#toc_event-names) for a list of
    acceptable DOM event names.
  
    ### Specifying whitelisted modifier keys
  
    `{{action}}` helpers called in element space can specify modifier keys.
    By default the `{{action}}` helper will ignore click events with pressed modifier
    keys. You can supply an `allowedKeys` option to specify which keys should not be ignored.
  
    ```handlebars
    <div {{action "anActionName" allowedKeys="alt"}}>
      click me
    </div>
    ```
  
    This way the action will fire when clicking with the alt key pressed down.
    Alternatively, supply "any" to the `allowedKeys` option to accept any combination of modifier keys.
  
    ```handlebars
    <div {{action "anActionName" allowedKeys="any"}}>
      click me with any key pressed
    </div>
    ```
  
    ### Specifying a Target
  
    A `target` option can be provided to the helper to change
    which object will receive the method call. This option must be a path
    to an object, accessible in the current context:
  
    ```app/templates/application.hbs
    <div {{action "anActionName" target=someService}}>
      click me
    </div>
    ```
  
    ```app/controllers/application.js
    import Ember from 'ember';
  
    export default Ember.Controller.extend({
      someService: Ember.inject.service()
    });
    ```
  
    @method action
    @for Ember.Templates.helpers
    @public
  */

  exports.default = function (vm, args) {
    var named = args.named;
    var positional = args.positional;

    // The first two argument slots are reserved.
    // pos[0] is the context (or `this`)
    // pos[1] is the action name or function
    // Anything else is an action argument.
    var context = positional.at(0);
    var action = positional.at(1);

    // TODO: Is there a better way of doing this?
    var debugKey = action._propertyKey;

    var restArgs = undefined;

    if (positional.length === 2) {
      restArgs = _glimmerRuntime.EvaluatedPositionalArgs.empty();
    } else {
      restArgs = _glimmerRuntime.EvaluatedPositionalArgs.create(positional.values.slice(2));
    }

    var target = named.has('target') ? named.get('target') : context;
    var processArgs = makeArgsProcessor(named.has('value') && named.get('value'), restArgs);

    var fn = undefined;

    if (typeof action[INVOKE] === 'function') {
      fn = makeClosureAction(action, action, action[INVOKE], processArgs, debugKey);
    } else if (_glimmerReference.isConst(target) && _glimmerReference.isConst(action)) {
      fn = makeClosureAction(context.value(), target.value(), action.value(), processArgs, debugKey);
    } else {
      fn = makeDynamicClosureAction(context.value(), target, action, processArgs, debugKey);
    }

    fn[ACTION] = true;

    return new _emberGlimmerUtilsReferences.UnboundReference(fn);
  };

  function NOOP(args) {
    return args;
  }

  function makeArgsProcessor(valuePathRef, actionArgsRef) {
    var mergeArgs = null;

    if (actionArgsRef.length > 0) {
      mergeArgs = function (args) {
        return actionArgsRef.value().concat(args);
      };
    }

    var readValue = null;

    if (valuePathRef) {
      readValue = function (args) {
        var valuePath = valuePathRef.value();

        if (valuePath && args.length > 0) {
          args[0] = _emberMetal.get(args[0], valuePath);
        }

        return args;
      };
    }

    if (mergeArgs && readValue) {
      return function (args) {
        return readValue(mergeArgs(args));
      };
    } else {
      return mergeArgs || readValue || NOOP;
    }
  }

  function makeDynamicClosureAction(context, targetRef, actionRef, processArgs, debugKey) {
    // We don't allow undefined/null values, so this creates a throw-away action to trigger the assertions
    _emberDebug.runInDebug(function () {
      makeClosureAction(context, targetRef.value(), actionRef.value(), processArgs, debugKey);
    });

    return function () {
      return makeClosureAction(context, targetRef.value(), actionRef.value(), processArgs, debugKey).apply(undefined, arguments);
    };
  }

  function makeClosureAction(context, target, action, processArgs, debugKey) {
    var self = undefined,
        fn = undefined;

    _emberDebug.assert('Action passed is null or undefined in (action) from ' + target + '.', !_emberMetal.isNone(action));

    if (typeof action[INVOKE] === 'function') {
      self = action;
      fn = action[INVOKE];
    } else {
      var typeofAction = typeof action;

      if (typeofAction === 'string') {
        self = target;
        fn = target.actions && target.actions[action];

        _emberDebug.assert('An action named \'' + action + '\' was not found in ' + target, fn);
      } else if (typeofAction === 'function') {
        self = context;
        fn = action;
      } else {
        _emberDebug.assert('An action could not be made for `' + (debugKey || action) + '` in ' + target + '. Please confirm that you are using either a quoted action name (i.e. `(action \'' + (debugKey || 'myAction') + '\')`) or a function available in ' + target + '.', false);
      }
    }

    return function () {
      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      var payload = { target: self, args: args, label: '@glimmer/closure-action' };
      return _emberMetal.flaggedInstrument('interaction.ember-action', payload, function () {
        return _emberMetal.run.join.apply(_emberMetal.run, [self, fn].concat(processArgs(args)));
      });
    };
  }
});
enifed('ember-glimmer/helpers/component', ['exports', 'ember-utils', 'ember-glimmer/utils/references', 'ember-glimmer/syntax/curly-component', '@glimmer/runtime', 'ember-debug'], function (exports, _emberUtils, _emberGlimmerUtilsReferences, _emberGlimmerSyntaxCurlyComponent, _glimmerRuntime, _emberDebug) {
  /**
    @module ember
    @submodule ember-glimmer
  */
  'use strict';

  /**
    The `{{component}}` helper lets you add instances of `Ember.Component` to a
    template. See [Ember.Component](/api/classes/Ember.Component.html) for
    additional information on how a `Component` functions.
    `{{component}}`'s primary use is for cases where you want to dynamically
    change which type of component is rendered as the state of your application
    changes. This helper has three modes: inline, block, and nested.
  
    ### Inline Form
  
    Given the following template:
  
    ```app/application.hbs
    {{component infographicComponentName}}
    ```
  
    And the following application code:
  
    ```app/controllers/application.js
    export default Ember.Controller.extend({
      infographicComponentName: computed('isMarketOpen', {
        get() {
          if (this.get('isMarketOpen')) {
            return 'live-updating-chart';
          } else {
            return 'market-close-summary';
          }
        }
      })
    });
    ```
  
    The `live-updating-chart` component will be appended when `isMarketOpen` is
    `true`, and the `market-close-summary` component will be appended when
    `isMarketOpen` is `false`. If the value changes while the app is running,
    the component will be automatically swapped out accordingly.
    Note: You should not use this helper when you are consistently rendering the same
    component. In that case, use standard component syntax, for example:
  
    ```app/templates/application.hbs
    {{live-updating-chart}}
    ```
  
    ### Block Form
  
    Using the block form of this helper is similar to using the block form
    of a component. Given the following application template:
  
    ```app/templates/application.hbs
    {{#component infographicComponentName}}
      Last update: {{lastUpdateTimestamp}}
    {{/component}}
    ```
  
    The following controller code:
  
    ```app/controllers/application.js
    export default Ember.Controller.extend({
      lastUpdateTimestamp: computed(function() {
        return new Date();
      }),
  
      infographicComponentName: computed('isMarketOpen', {
        get() {
          if (this.get('isMarketOpen')) {
            return 'live-updating-chart';
          } else {
            return 'market-close-summary';
          }
        }
      })
    });
    ```
  
    And the following component template:
  
    ```app/templates/components/live-updating-chart.hbs
    {{! chart }}
    {{yield}}
    ```
  
    The `Last Update: {{lastUpdateTimestamp}}` will be rendered in place of the `{{yield}}`.
  
    ### Nested Usage
  
    The `component` helper can be used to package a component path with initial attrs.
    The included attrs can then be merged during the final invocation.
    For example, given a `person-form` component with the following template:
  
    ```app/templates/components/person-form.hbs
    {{yield (hash
      nameInput=(component "my-input-component" value=model.name placeholder="First Name")
    )}}
    ```
  
    When yielding the component via the `hash` helper, the component is invoked directly.
    See the following snippet:
  
    ```
    {{#person-form as |form|}}
      {{form.nameInput placeholder="Username"}}
    {{/person-form}}
    ```
  
    Which outputs an input whose value is already bound to `model.name` and `placeholder`
    is "Username".
  
    When yielding the component without the hash helper use the `component` helper.
    For example, below is a `full-name` component template:
  
    ```handlebars
    {{yield (component "my-input-component" value=model.name placeholder="Name")}}
    ```
  
    ```
    {{#full-name as |field|}}
      {{component field placeholder="Full name"}}
    {{/full-name}}
    ```
  
    @method component
    @since 1.11.0
    @for Ember.Templates.helpers
    @public
  */

  var ClosureComponentReference = (function (_CachedReference) {
    babelHelpers.inherits(ClosureComponentReference, _CachedReference);

    ClosureComponentReference.create = function create(args, symbolTable, env) {
      return new ClosureComponentReference(args, symbolTable, env);
    };

    function ClosureComponentReference(args, symbolTable, env) {
      babelHelpers.classCallCheck(this, ClosureComponentReference);

      _CachedReference.call(this);

      var firstArg = args.positional.at(0);
      this.defRef = firstArg;
      this.tag = firstArg.tag;
      this.env = env;
      this.symbolTable = symbolTable;
      this.args = args;
      this.lastDefinition = undefined;
      this.lastName = undefined;
    }

    ClosureComponentReference.prototype.compute = function compute() {
      // TODO: Figure out how to extract this because it's nearly identical to
      // DynamicComponentReference::compute(). The only differences besides
      // currying are in the assertion messages.
      var args = this.args;
      var defRef = this.defRef;
      var env = this.env;
      var symbolTable = this.symbolTable;
      var lastDefinition = this.lastDefinition;
      var lastName = this.lastName;

      var nameOrDef = defRef.value();
      var definition = null;

      if (nameOrDef && nameOrDef === lastName) {
        return lastDefinition;
      }

      this.lastName = nameOrDef;

      if (typeof nameOrDef === 'string') {
        _emberDebug.assert('You cannot use the input helper as a contextual helper. Please extend Ember.TextField or Ember.Checkbox to use it as a contextual component.', nameOrDef !== 'input');
        _emberDebug.assert('You cannot use the textarea helper as a contextual helper. Please extend Ember.TextArea to use it as a contextual component.', nameOrDef !== 'textarea');
        definition = env.getComponentDefinition([nameOrDef], symbolTable);
        _emberDebug.assert('The component helper cannot be used without a valid component name. You used "' + nameOrDef + '" via (component "' + nameOrDef + '")', definition);
      } else if (_glimmerRuntime.isComponentDefinition(nameOrDef)) {
        definition = nameOrDef;
      } else {
        _emberDebug.assert('You cannot create a component from ' + nameOrDef + ' using the {{component}} helper', nameOrDef);
        return null;
      }

      var newDef = createCurriedDefinition(definition, args);

      this.lastDefinition = newDef;

      return newDef;
    };

    return ClosureComponentReference;
  })(_emberGlimmerUtilsReferences.CachedReference);

  exports.ClosureComponentReference = ClosureComponentReference;

  function createCurriedDefinition(definition, args) {
    var curriedArgs = curryArgs(definition, args);

    return new _emberGlimmerSyntaxCurlyComponent.CurlyComponentDefinition(definition.name, definition.ComponentClass, definition.template, curriedArgs);
  }

  var EMPTY_BLOCKS = {
    default: null,
    inverse: null
  };

  _emberDebug.runInDebug(function () {
    EMPTY_BLOCKS = Object.freeze(EMPTY_BLOCKS);
  });

  function curryArgs(definition, newArgs) {
    var args = definition.args;
    var ComponentClass = definition.ComponentClass;

    var positionalParams = ComponentClass.class.positionalParams;

    // The args being passed in are from the (component ...) invocation,
    // so the first positional argument is actually the name or component
    // definition. It needs to be dropped in order for any actual positional
    // args to coincide with the ComponentClass's positionParams.

    // For "normal" curly components this slicing is done at the syntax layer,
    // but we don't have that luxury here.

    var _newArgs$positional$values = newArgs.positional.values;

    var slicedPositionalArgs = _newArgs$positional$values.slice(1);

    if (positionalParams && slicedPositionalArgs.length) {
      _emberGlimmerSyntaxCurlyComponent.validatePositionalParameters(newArgs.named, slicedPositionalArgs, positionalParams);
    }

    var isRest = typeof positionalParams === 'string';

    // For non-rest position params, we need to perform the position -> name mapping
    // at each layer to avoid a collision later when the args are used to construct
    // the component instance (inside of processArgs(), inside of create()).
    var positionalToNamedParams = {};

    if (!isRest && positionalParams && positionalParams.length > 0) {
      var limit = Math.min(positionalParams.length, slicedPositionalArgs.length);

      for (var i = 0; i < limit; i++) {
        var _name = positionalParams[i];
        positionalToNamedParams[_name] = slicedPositionalArgs[i];
      }

      slicedPositionalArgs.length = 0; // Throw them away since you're merged in.
    }

    // args (aka 'oldArgs') may be undefined or simply be empty args, so
    // we need to fall back to an empty array or object.
    var oldNamed = args && args.named && args.named.map || {};
    var oldPositional = args && args.positional && args.positional.values || [];

    // Merge positional arrays
    var mergedPositional = new Array(Math.max(oldPositional.length, slicedPositionalArgs.length));
    mergedPositional.splice.apply(mergedPositional, [0, oldPositional.length].concat(oldPositional));
    mergedPositional.splice.apply(mergedPositional, [0, slicedPositionalArgs.length].concat(slicedPositionalArgs));

    // Merge named maps
    var mergedNamed = _emberUtils.assign({}, oldNamed, positionalToNamedParams, newArgs.named.map);

    var mergedArgs = _glimmerRuntime.EvaluatedArgs.create(_glimmerRuntime.EvaluatedPositionalArgs.create(mergedPositional), _glimmerRuntime.EvaluatedNamedArgs.create(mergedNamed), EMPTY_BLOCKS);

    return mergedArgs;
  }

  exports.default = function (vm, args, symbolTable) {
    return ClosureComponentReference.create(args, symbolTable, vm.env);
  };
});
enifed('ember-glimmer/helpers/concat', ['exports', 'ember-glimmer/utils/references', '@glimmer/runtime'], function (exports, _emberGlimmerUtilsReferences, _glimmerRuntime) {
  'use strict';

  /**
  @module ember
  @submodule ember-glimmer
  */

  /**
    Concatenates the given arguments into a string.
  
    Example:
  
    ```handlebars
    {{some-component name=(concat firstName " " lastName)}}
  
    {{! would pass name="<first name value> <last name value>" to the component}}
    ```
  
    @public
    @method concat
    @for Ember.Templates.helpers
    @since 1.13.0
  */
  function concat(_ref) {
    var positional = _ref.positional;

    return positional.value().map(_glimmerRuntime.normalizeTextValue).join('');
  }

  exports.default = function (vm, args) {
    return new _emberGlimmerUtilsReferences.InternalHelperReference(concat, args);
  };
});
enifed('ember-glimmer/helpers/each-in', ['exports', 'ember-utils'], function (exports, _emberUtils) {
  /**
  @module ember
  @submodule ember-glimmer
  */
  'use strict';

  exports.isEachIn = isEachIn;

  /**
    The `{{#each}}` helper loops over elements in a collection. It is an extension
    of the base Handlebars `{{#each}}` helper.
    The default behavior of `{{#each}}` is to yield its inner block once for every
    item in an array passing the item as the first block parameter.
  
    ```javascript
    var developers = [{ name: 'Yehuda' },{ name: 'Tom' }, { name: 'Paul' }];
    ```
  
    ```handlebars
    {{#each developers key="name" as |person|}}
      {{person.name}}
      {{! `this` is whatever it was outside the #each }}
    {{/each}}
    ```
  
    The same rules apply to arrays of primitives.
  
    ```javascript
    var developerNames = ['Yehuda', 'Tom', 'Paul']
    ```
  
    ```handlebars
    {{#each developerNames key="@index" as |name|}}
      {{name}}
    {{/each}}
    ```
  
    During iteration, the index of each item in the array is provided as a second block parameter.
  
    ```handlebars
    <ul>
      {{#each people as |person index|}}
        <li>Hello, {{person.name}}! You're number {{index}} in line</li>
      {{/each}}
    </ul>
    ```
  
    ### Specifying Keys
  
    The `key` option is used to tell Ember how to determine if the array being
    iterated over with `{{#each}}` has changed between renders. By helping Ember
    detect that some elements in the array are the same, DOM elements can be
    re-used, significantly improving rendering speed.
  
    For example, here's the `{{#each}}` helper with its `key` set to `id`:
  
    ```handlebars
    {{#each model key="id" as |item|}}
    {{/each}}
    ```
  
    When this `{{#each}}` re-renders, Ember will match up the previously rendered
    items (and reorder the generated DOM elements) based on each item's `id`
    property.
    By default the item's own reference is used.
  
    ### {{else}} condition
  
    `{{#each}}` can have a matching `{{else}}`. The contents of this block will render
    if the collection is empty.
  
    ```handlebars
    {{#each developers as |person|}}
      {{person.name}}
    {{else}}
      <p>Sorry, nobody is available for this task.</p>
    {{/each}}
    ```
  
    @method each
    @for Ember.Templates.helpers
    @public
   */

  /**
    The `{{each-in}}` helper loops over properties on an object.
  
    For example, given a `user` object that looks like:
  
    ```javascript
    {
      "name": "Shelly Sails",
      "age": 42
    }
    ```
  
    This template would display all properties on the `user`
    object in a list:
  
    ```handlebars
    <ul>
    {{#each-in user as |key value|}}
      <li>{{key}}: {{value}}</li>
    {{/each-in}}
    </ul>
    ```
  
    Outputting their name and age.
  
    @method each-in
    @for Ember.Templates.helpers
    @public
    @since 2.1.0
  */
  var EACH_IN_REFERENCE = _emberUtils.symbol('EACH_IN');

  function isEachIn(ref) {
    return ref && ref[EACH_IN_REFERENCE];
  }

  exports.default = function (vm, args) {
    var ref = Object.create(args.positional.at(0));
    ref[EACH_IN_REFERENCE] = true;
    return ref;
  };
});
enifed('ember-glimmer/helpers/get', ['exports', 'ember-metal', 'ember-glimmer/utils/references', '@glimmer/reference'], function (exports, _emberMetal, _emberGlimmerUtilsReferences, _glimmerReference) {
  'use strict';

  /**
  @module ember
  @submodule ember-glimmer
  */

  /**
    Dynamically look up a property on an object. The second argument to `{{get}}`
    should have a string value, although it can be bound.
  
    For example, these two usages are equivilent:
  
    ```handlebars
    {{person.height}}
    {{get person "height"}}
    ```
  
    If there were several facts about a person, the `{{get}}` helper can dynamically
    pick one:
  
    ```handlebars
    {{get person factName}}
    ```
  
    For a more complex example, this template would allow the user to switch
    between showing the user's height and weight with a click:
  
    ```handlebars
    {{get person factName}}
    <button {{action (action (mut factName)) "height"}}>Show height</button>
    <button {{action (action (mut factName)) "weight"}}>Show weight</button>
    ```
  
    The `{{get}}` helper can also respect mutable values itself. For example:
  
    ```handlebars
    {{input value=(mut (get person factName)) type="text"}}
    <button {{action (action (mut factName)) "height"}}>Show height</button>
    <button {{action (action (mut factName)) "weight"}}>Show weight</button>
    ```
  
    Would allow the user to swap what fact is being displayed, and also edit
    that fact via a two-way mutable binding.
  
    @public
    @method get
    @for Ember.Templates.helpers
    @since 2.1.0
   */

  exports.default = function (vm, args) {
    return GetHelperReference.create(args.positional.at(0), args.positional.at(1));
  };

  var GetHelperReference = (function (_CachedReference) {
    babelHelpers.inherits(GetHelperReference, _CachedReference);

    GetHelperReference.create = function create(sourceReference, pathReference) {
      if (_glimmerReference.isConst(pathReference)) {
        var parts = pathReference.value().split('.');
        return _glimmerReference.referenceFromParts(sourceReference, parts);
      } else {
        return new GetHelperReference(sourceReference, pathReference);
      }
    };

    function GetHelperReference(sourceReference, pathReference) {
      babelHelpers.classCallCheck(this, GetHelperReference);

      _CachedReference.call(this);
      this.sourceReference = sourceReference;
      this.pathReference = pathReference;

      this.lastPath = null;
      this.innerReference = null;

      var innerTag = this.innerTag = new _glimmerReference.UpdatableTag(_glimmerReference.CONSTANT_TAG);

      this.tag = _glimmerReference.combine([sourceReference.tag, pathReference.tag, innerTag]);
    }

    GetHelperReference.prototype.compute = function compute() {
      var lastPath = this.lastPath;
      var innerReference = this.innerReference;
      var innerTag = this.innerTag;

      var path = this.lastPath = this.pathReference.value();

      if (path !== lastPath) {
        if (path) {
          var pathType = typeof path;

          if (pathType === 'string') {
            innerReference = this.innerReference = _glimmerReference.referenceFromParts(this.sourceReference, path.split('.'));
          } else if (pathType === 'number') {
            innerReference = this.innerReference = this.sourceReference.get(path);
          }

          innerTag.update(innerReference.tag);
        } else {
          innerReference = this.innerReference = null;
          innerTag.update(_glimmerReference.CONSTANT_TAG);
        }
      }

      return innerReference ? innerReference.value() : null;
    };

    GetHelperReference.prototype[_emberGlimmerUtilsReferences.UPDATE] = function (value) {
      _emberMetal.set(this.sourceReference.value(), this.pathReference.value(), value);
    };

    return GetHelperReference;
  })(_emberGlimmerUtilsReferences.CachedReference);
});
enifed("ember-glimmer/helpers/hash", ["exports"], function (exports) {
   /**
   @module ember
   @submodule ember-glimmer
   */

   /**
      Use the `{{hash}}` helper to create a hash to pass as an option to your
      components. This is specially useful for contextual components where you can
      just yield a hash:
   
      ```handlebars
      {{yield (hash
         name='Sarah'
         title=office
      )}}
      ```
   
      Would result in an object such as:
   
      ```js
      { name: 'Sarah', title: this.get('office') }
      ```
   
      Where the `title` is bound to updates of the `office` property.
   
      @method hash
      @for Ember.Templates.helpers
      @param {Object} options
      @return {Object} Hash
      @since 2.3.0
      @public
    */

   "use strict";

   exports.default = function (vm, args) {
      return args.named;
   };
});
enifed('ember-glimmer/helpers/if-unless', ['exports', 'ember-debug', 'ember-glimmer/utils/references', '@glimmer/reference'], function (exports, _emberDebug, _emberGlimmerUtilsReferences, _glimmerReference) {
  /**
  @module ember
  @submodule ember-glimmer
  */

  'use strict';

  exports.inlineIf = inlineIf;
  exports.inlineUnless = inlineUnless;

  /**
    Use the `if` block helper to conditionally render a block depending on a
    property. If the property is "falsey", for example: `false`, `undefined`,
    `null`, `""`, `0`, `NaN` or an empty array, the block will not be rendered.
  
    ```handlebars
    {{! will not render if foo is falsey}}
    {{#if foo}}
      Welcome to the {{foo.bar}}
    {{/if}}
    ```
  
    You can also specify a template to show if the property is falsey by using
    the `else` helper.
  
    ```handlebars
    {{! is it raining outside?}}
    {{#if isRaining}}
      Yes, grab an umbrella!
    {{else}}
      No, it's lovely outside!
    {{/if}}
    ```
  
    You are also able to combine `else` and `if` helpers to create more complex
    conditional logic.
  
    ```handlebars
    {{#if isMorning}}
      Good morning
    {{else if isAfternoon}}
      Good afternoon
    {{else}}
      Good night
    {{/if}}
    ```
  
    You can use `if` inline to conditionally render a single property or string.
    This helper acts like a ternary operator. If the first property is truthy,
    the second argument will be displayed, if not, the third argument will be
    displayed
  
    ```handlebars
    {{if useLongGreeting "Hello" "Hi"}} Dave
    ```
  
    Finally, you can use the `if` helper inside another helper as a subexpression.
  
    ```handlebars
    {{some-component height=(if isBig "100" "10")}}
    ```
  
    @method if
    @for Ember.Templates.helpers
    @public
  */

  var ConditionalHelperReference = (function (_CachedReference) {
    babelHelpers.inherits(ConditionalHelperReference, _CachedReference);

    ConditionalHelperReference.create = function create(_condRef, _truthyRef, _falsyRef) {
      var condRef = _emberGlimmerUtilsReferences.ConditionalReference.create(_condRef);
      var truthyRef = _truthyRef || _emberGlimmerUtilsReferences.UNDEFINED_REFERENCE;
      var falsyRef = _falsyRef || _emberGlimmerUtilsReferences.UNDEFINED_REFERENCE;

      if (_glimmerReference.isConst(condRef)) {
        return condRef.value() ? truthyRef : falsyRef;
      } else {
        return new ConditionalHelperReference(condRef, truthyRef, falsyRef);
      }
    };

    function ConditionalHelperReference(cond, truthy, falsy) {
      babelHelpers.classCallCheck(this, ConditionalHelperReference);

      _CachedReference.call(this);

      this.branchTag = new _glimmerReference.UpdatableTag(_glimmerReference.CONSTANT_TAG);
      this.tag = _glimmerReference.combine([cond.tag, this.branchTag]);

      this.cond = cond;
      this.truthy = truthy;
      this.falsy = falsy;
    }

    /**
      The inline `if` helper conditionally renders a single property or string.
      This helper acts like a ternary operator. If the first property is truthy,
      the second argument will be displayed, otherwise, the third argument will be
      displayed
    
      ```handlebars
      {{if useLongGreeting "Hello" "Hi"}} Alex
      ```
    
      You can use the `if` helper inside another helper as a subexpression.
    
      ```handlebars
      {{some-component height=(if isBig "100" "10")}}
      ```
    
      @method if
      @for Ember.Templates.helpers
      @public
    */

    ConditionalHelperReference.prototype.compute = function compute() {
      var cond = this.cond;
      var truthy = this.truthy;
      var falsy = this.falsy;

      var branch = cond.value() ? truthy : falsy;

      this.branchTag.update(branch.tag);

      return branch.value();
    };

    return ConditionalHelperReference;
  })(_emberGlimmerUtilsReferences.CachedReference);

  function inlineIf(vm, _ref) {
    var positional = _ref.positional;

    switch (positional.length) {
      case 2:
        return ConditionalHelperReference.create(positional.at(0), positional.at(1), null);
      case 3:
        return ConditionalHelperReference.create(positional.at(0), positional.at(1), positional.at(2));
      default:
        _emberDebug.assert('The inline form of the `if` helper expects two or three arguments, e.g. ' + '`{{if trialExpired "Expired" expiryDate}}`.');
    }
  }

  /**
    The inline `unless` helper conditionally renders a single property or string.
    This helper acts like a ternary operator. If the first property is falsy,
    the second argument will be displayed, otherwise, the third argument will be
    displayed
  
    ```handlebars
    {{unless useLongGreeting "Hi" "Hello"}} Ben
    ```
  
    You can use the `unless` helper inside another helper as a subexpression.
  
    ```handlebars
    {{some-component height=(unless isBig "10" "100")}}
    ```
  
    @method unless
    @for Ember.Templates.helpers
    @public
  */

  function inlineUnless(vm, _ref2) {
    var positional = _ref2.positional;

    switch (positional.length) {
      case 2:
        return ConditionalHelperReference.create(positional.at(0), null, positional.at(1));
      case 3:
        return ConditionalHelperReference.create(positional.at(0), positional.at(2), positional.at(1));
      default:
        _emberDebug.assert('The inline form of the `unless` helper expects two or three arguments, e.g. ' + '`{{unless isFirstLogin "Welcome back!"}}`.');
    }
  }
});
enifed('ember-glimmer/helpers/loc', ['exports', 'ember-glimmer/utils/references', 'ember-runtime'], function (exports, _emberGlimmerUtilsReferences, _emberRuntime) {
  /**
  @module ember
  @submodule ember-glimmer
  */
  'use strict';

  /**
    Calls [Ember.String.loc](/api/classes/Ember.String.html#method_loc) with the
    provided string. This is a convenient way to localize text within a template.
    For example:
  
    ```javascript
    Ember.STRINGS = {
      '_welcome_': 'Bonjour'
    };
    ```
  
    ```handlebars
    <div class='message'>
      {{loc '_welcome_'}}
    </div>
    ```
  
    ```html
    <div class='message'>
      Bonjour
    </div>
    ```
  
    See [Ember.String.loc](/api/classes/Ember.String.html#method_loc) for how to
    set up localized string references.
  
    @method loc
    @for Ember.Templates.helpers
    @param {String} str The string to format.
    @see {Ember.String#loc}
    @public
  */
  function locHelper(_ref) {
    var positional = _ref.positional;

    return _emberRuntime.String.loc.apply(null, positional.value());
  }

  exports.default = function (vm, args) {
    return new _emberGlimmerUtilsReferences.InternalHelperReference(locHelper, args);
  };
});
enifed('ember-glimmer/helpers/log', ['exports', 'ember-glimmer/utils/references', 'ember-console'], function (exports, _emberGlimmerUtilsReferences, _emberConsole) {
  'use strict';

  /**
    `log` allows you to output the value of variables in the current rendering
    context. `log` also accepts primitive types such as strings or numbers.
  
    ```handlebars
    {{log "myVariable:" myVariable }}
    ```
  
    @method log
    @for Ember.Templates.helpers
    @param {Array} params
    @public
  */
  function log(_ref) {
    var positional = _ref.positional;

    _emberConsole.default.log.apply(null, positional.value());
  }

  exports.default = function (vm, args) {
    return new _emberGlimmerUtilsReferences.InternalHelperReference(log, args);
  };
});

/**
@module ember
@submodule ember-glimmer
*/
enifed('ember-glimmer/helpers/mut', ['exports', 'ember-utils', 'ember-debug', 'ember-glimmer/utils/references', 'ember-glimmer/helpers/action'], function (exports, _emberUtils, _emberDebug, _emberGlimmerUtilsReferences, _emberGlimmerHelpersAction) {
  /**
  @module ember
  @submodule ember-glimmer
  */
  'use strict';

  exports.isMut = isMut;
  exports.unMut = unMut;

  /**
    The `mut` helper lets you __clearly specify__ that a child `Component` can update the
    (mutable) value passed to it, which will __change the value of the parent component__.
  
    To specify that a parameter is mutable, when invoking the child `Component`:
  
    ```handlebars
    {{my-child childClickCount=(mut totalClicks)}}
    ```
  
    The child `Component` can then modify the parent's value just by modifying its own
    property:
  
    ```javascript
    // my-child.js
    export default Component.extend({
      click() {
        this.incrementProperty('childClickCount');
      }
    });
    ```
  
    Note that for curly components (`{{my-component}}`) the bindings are already mutable,
    making the `mut` unnecessary.
  
    Additionally, the `mut` helper can be combined with the `action` helper to
    mutate a value. For example:
  
    ```handlebars
    {{my-child childClickCount=totalClicks click-count-change=(action (mut totalClicks))}}
    ```
  
    The child `Component` would invoke the action with the new click value:
  
    ```javascript
    // my-child.js
    export default Component.extend({
      click() {
        this.get('click-count-change')(this.get('childClickCount') + 1);
      }
    });
    ```
  
    The `mut` helper changes the `totalClicks` value to what was provided as the action argument.
  
    The `mut` helper, when used with `action`, will return a function that
    sets the value passed to `mut` to its first argument. This works like any other
    closure action and interacts with the other features `action` provides.
    As an example, we can create a button that increments a value passing the value
    directly to the `action`:
  
    ```handlebars
    {{! inc helper is not provided by Ember }}
    <button onclick={{action (mut count) (inc count)}}>
      Increment count
    </button>
    ```
  
    You can also use the `value` option:
  
    ```handlebars
    <input value={{name}} oninput={{action (mut name) value="target.value"}}>
    ```
  
    @method mut
    @param {Object} [attr] the "two-way" attribute that can be modified.
    @for Ember.Templates.helpers
    @public
  */
  var MUT_REFERENCE = _emberUtils.symbol('MUT');
  var SOURCE = _emberUtils.symbol('SOURCE');

  function isMut(ref) {
    return ref && ref[MUT_REFERENCE];
  }

  function unMut(ref) {
    return ref[SOURCE] || ref;
  }

  exports.default = function (vm, args) {
    var rawRef = args.positional.at(0);

    if (isMut(rawRef)) {
      return rawRef;
    }

    // TODO: Improve this error message. This covers at least two distinct
    // cases:
    //
    // 1. (mut "not a path") – passing a literal, result from a helper
    //    invocation, etc
    //
    // 2. (mut receivedValue) – passing a value received from the caller
    //    that was originally derived from a literal, result from a helper
    //    invocation, etc
    //
    // This message is alright for the first case, but could be quite
    // confusing for the second case.
    _emberDebug.assert('You can only pass a path to mut', rawRef[_emberGlimmerUtilsReferences.UPDATE]);

    var wrappedRef = Object.create(rawRef);

    wrappedRef[SOURCE] = rawRef;
    wrappedRef[_emberGlimmerHelpersAction.INVOKE] = rawRef[_emberGlimmerUtilsReferences.UPDATE];
    wrappedRef[MUT_REFERENCE] = true;

    return wrappedRef;
  };
});
enifed('ember-glimmer/helpers/query-param', ['exports', 'ember-utils', 'ember-glimmer/utils/references', 'ember-debug', 'ember-routing'], function (exports, _emberUtils, _emberGlimmerUtilsReferences, _emberDebug, _emberRouting) {
  /**
  @module ember
  @submodule ember-glimmer
  */
  'use strict';

  /**
    This is a helper to be used in conjunction with the link-to helper.
    It will supply url query parameters to the target route.
  
    Example
  
    ```handlebars
    {{#link-to 'posts' (query-params direction="asc")}}Sort{{/link-to}}
    ```
  
    @method query-params
    @for Ember.Templates.helpers
    @param {Object} hash takes a hash of query parameters
    @return {Object} A `QueryParams` object for `{{link-to}}`
    @public
  */
  function queryParams(_ref) {
    var positional = _ref.positional;
    var named = _ref.named;

    _emberDebug.assert('The `query-params` helper only accepts hash parameters, e.g. (query-params queryParamPropertyName=\'foo\') as opposed to just (query-params \'foo\')', positional.value().length === 0);

    return _emberRouting.QueryParams.create({
      values: _emberUtils.assign({}, named.value())
    });
  }

  exports.default = function (vm, args) {
    return new _emberGlimmerUtilsReferences.InternalHelperReference(queryParams, args);
  };
});
enifed('ember-glimmer/helpers/readonly', ['exports', 'ember-glimmer/utils/references', 'ember-glimmer/helpers/mut'], function (exports, _emberGlimmerUtilsReferences, _emberGlimmerHelpersMut) {
  /**
  @module ember
  @submodule ember-glimmer
  */
  'use strict';

  /**
    The `readonly` helper let's you specify that a binding is one-way only,
    instead of two-way.
    When you pass a `readonly` binding from an outer context (e.g. parent component),
    to to an inner context (e.g. child component), you are saying that changing that
    property in the inner context does not change the value in the outer context.
  
    To specify that a binding is read-only, when invoking the child `Component`:
  
    ```app/components/my-parent.js
    export default Component.extend({
      totalClicks: 3
    });
    ```
  
    ```app/templates/components/my-parent.hbs
    {{log totalClicks}} // -> 3
    {{my-child childClickCount=(readonly totalClicks)}}
    ```
  
    Now, when you update `childClickCount`:
  
    ```app/components/my-child.js
    export default Component.extend({
      click() {
        this.incrementProperty('childClickCount');
      }
    });
    ```
  
    The value updates in the child component, but not the parent component:
  
    ```app/templates/components/my-child.hbs
    {{log childClickCount}} //-> 4
    ```
  
    ```app/templates/components/my-parent.hbs
    {{log totalClicks}} //-> 3
    {{my-child childClickCount=(readonly totalClicks)}}
    ```
  
    ### Objects and Arrays
  
    When passing a property that is a complex object (e.g. object, array) instead of a primitive object (e.g. number, string),
    only the reference to the object is protected using the readonly helper.
    This means that you can change properties of the object both on the parent component, as well as the child component.
    The `readonly` binding behaves similar to the `const` keyword in JavaScript.
  
    Let's look at an example:
  
    First let's set up the parent component:
  
    ```app/components/my-parent.js
    export default Ember.Component.extend({
      clicks: null,
  
      init() {
        this._super(...arguments);
        this.set('clicks', { total: 3 });
      }
    });
    ```
  
    ```app/templates/components/my-parent.hbs
    {{log clicks.total}} //-> 3
    {{my-child childClicks=(readonly clicks)}}
    ```
  
    Now, if you update the `total` property of `childClicks`:
  
    ```app/components/my-child.js
    export default Ember.Component.extend({
      click() {
        this.get('clicks').incrementProperty('total');
      }
    });
    ```
  
    You will see the following happen:
  
    ```app/templates/components/my-parent.hbs
    {{log clicks.total}} //-> 4
    {{my-child childClicks=(readonly clicks)}}
    ```
  
    ```app/templates/components/my-child.hbs
    {{log childClicks.total}} //-> 4
    ```
  
    @method readonly
    @param {Object} [attr] the read-only attribute.
    @for Ember.Templates.helpers
    @private
  */

  exports.default = function (vm, args) {
    var ref = _emberGlimmerHelpersMut.unMut(args.positional.at(0));

    var wrapped = Object.create(ref);

    wrapped[_emberGlimmerUtilsReferences.UPDATE] = undefined;

    return wrapped;
  };
});
enifed('ember-glimmer/helpers/unbound', ['exports', 'ember-debug', 'ember-glimmer/utils/references'], function (exports, _emberDebug, _emberGlimmerUtilsReferences) {
  /**
  @module ember
  @submodule ember-glimmer
  */

  'use strict';

  /**
    The `{{unbound}}` helper disconnects the one-way binding of a property,
    essentially freezing its value at the moment of rendering. For example,
    in this example the display of the variable `name` will not change even
    if it is set with a new value:
  
    ```handlebars
    {{unbound name}}
    ```
  
    Like any helper, the `unbound` helper can accept a nested helper expression.
    This allows for custom helpers to be rendered unbound:
  
    ```handlebars
    {{unbound (some-custom-helper)}}
    {{unbound (capitalize name)}}
    {{! You can use any helper, including unbound, in a nested expression }}
    {{capitalize (unbound name)}}
    ```
  
    The `unbound` helper only accepts a single argument, and it return an
    unbound value.
  
    @method unbound
    @for Ember.Templates.helpers
    @public
  */

  exports.default = function (vm, args) {
    _emberDebug.assert('unbound helper cannot be called with multiple params or hash params', args.positional.values.length === 1 && args.named.keys.length === 0);

    return _emberGlimmerUtilsReferences.UnboundReference.create(args.positional.at(0).value());
  };
});
enifed('ember-glimmer/index', ['exports', 'ember-glimmer/helpers/action', 'ember-glimmer/templates/root', 'ember-glimmer/template', 'ember-glimmer/components/checkbox', 'ember-glimmer/components/text_field', 'ember-glimmer/components/text_area', 'ember-glimmer/components/link-to', 'ember-glimmer/component', 'ember-glimmer/helper', 'ember-glimmer/environment', 'ember-glimmer/make-bound-helper', 'ember-glimmer/utils/string', 'ember-glimmer/renderer', 'ember-glimmer/template_registry', 'ember-glimmer/setup-registry', 'ember-glimmer/dom', 'ember-glimmer/syntax'], function (exports, _emberGlimmerHelpersAction, _emberGlimmerTemplatesRoot, _emberGlimmerTemplate, _emberGlimmerComponentsCheckbox, _emberGlimmerComponentsText_field, _emberGlimmerComponentsText_area, _emberGlimmerComponentsLinkTo, _emberGlimmerComponent, _emberGlimmerHelper, _emberGlimmerEnvironment, _emberGlimmerMakeBoundHelper, _emberGlimmerUtilsString, _emberGlimmerRenderer, _emberGlimmerTemplate_registry, _emberGlimmerSetupRegistry, _emberGlimmerDom, _emberGlimmerSyntax) {
  /**
    [Glimmer](https://github.com/tildeio/glimmer) is a templating engine used by Ember.js that is compatible with a subset of the [Handlebars](http://handlebarsjs.com/) syntax.
  
    ### Showing a property
  
    Templates manage the flow of an application's UI, and display state (through
    the DOM) to a user. For example, given a component with the property "name",
    that component's template can use the name in several ways:
  
    ```app/components/person.js
      export default Ember.Component.extend({
        name: 'Jill'
      });
    ```
  
    ```app/components/person.hbs
    {{name}}
    <div>{{name}}</div>
    <span data-name={{name}}></span>
    ```
  
    Any time the "name" property on the component changes, the DOM will be
    updated.
  
    Properties can be chained as well:
  
    ```handlebars
    {{aUserModel.name}}
    <div>{{listOfUsers.firstObject.name}}</div>
    ```
  
    ### Using Ember helpers
  
    When content is passed in mustaches `{{}}`, Ember will first try to find a helper
    or component with that name. For example, the `if` helper:
  
    ```handlebars
    {{if name "I have a name" "I have no name"}}
    <span data-has-name={{if name true}}></span>
    ```
  
    The returned value is placed where the `{{}}` is called. The above style is
    called "inline". A second style of helper usage is called "block". For example:
  
    ```handlebars
    {{#if name}}
    I have a name
    {{else}}
    I have no name
    {{/if}}
    ```
  
    The block form of helpers allows you to control how the UI is created based
    on the values of properties.
    A third form of helper is called "nested". For example here the concat
    helper will add " Doe" to a displayed name if the person has no last name:
  
    ```handlebars
    <span data-name={{concat firstName (
    if lastName (concat " " lastName) "Doe"
    )}}></span>
    ```
  
    Ember's built-in helpers are described under the [Ember.Templates.helpers](/api/classes/Ember.Templates.helpers.html)
    namespace. Documentation on creating custom helpers can be found under
    [Ember.Helper](/api/classes/Ember.Helper.html).
  
    ### Invoking a Component
  
    Ember components represent state to the UI of an application. Further
    reading on components can be found under [Ember.Component](/api/classes/Ember.Component.html).
  
    @module ember
    @submodule ember-glimmer
    @main ember-glimmer
    @public
   */

  /**
    Use the `{{with}}` helper when you want to alias a property to a new name. This is helpful
    for semantic clarity as it allows you to retain default scope or to reference a property from another
    `{{with}}` block.
  
    If the aliased property is "falsey", for example: `false`, `undefined` `null`, `""`, `0`, NaN or
    an empty array, the block will not be rendered.
  
    ```handlebars
    {{! Will only render if user.posts contains items}}
    {{#with user.posts as |blogPosts|}}
      <div class="notice">
        There are {{blogPosts.length}} blog posts written by {{user.name}}.
      </div>
      {{#each blogPosts as |post|}}
        <li>{{post.title}}</li>
      {{/each}}
    {{/with}}
    ```
  
    Without the `as` operator, it would be impossible to reference `user.name` in the example above.
  
    NOTE: The alias should not reuse a name from the bound property path.
  
    For example: `{{#with foo.bar as |foo|}}` is not supported because it attempts to alias using
    the first part of the property path, `foo`. Instead, use `{{#with foo.bar as |baz|}}`.
  
    @method with
    @for Ember.Templates.helpers
    @param {Object} options
    @return {String} HTML string
    @public
   */

  /**
    Execute the `debugger` statement in the current template's context.
  
    ```handlebars
    {{debugger}}
    ```
  
    When using the debugger helper you will have access to a `get` function. This
    function retrieves values available in the context of the template.
    For example, if you're wondering why a value `{{foo}}` isn't rendering as
    expected within a template, you could place a `{{debugger}}` statement and,
    when the `debugger;` breakpoint is hit, you can attempt to retrieve this value:
  
    ```
    > get('foo')
    ```
  
    `get` is also aware of keywords. So in this situation
  
    ```handlebars
    {{#each items as |item|}}
      {{debugger}}
    {{/each}}
    ```
  
    You'll be able to get values from the current item:
  
    ```
    > get('item.name')
    ```
  
    You can also access the context of the view to make sure it is the object that
    you expect:
  
    ```
    > context
    ```
  
    @method debugger
    @for Ember.Templates.helpers
    @public
   */

  /**
    The `partial` helper renders another template without
    changing the template context:
  
    ```handlebars
    {{foo}}
    {{partial "nav"}}
    ```
  
    The above example template will render a template named
    "-nav", which has the same context as the parent template
    it's rendered into, so if the "-nav" template also referenced
    `{{foo}}`, it would print the same thing as the `{{foo}}`
    in the above example.
  
    If a "-nav" template isn't found, the `partial` helper will
    fall back to a template named "nav".
  
    ### Bound template names
  
    The parameter supplied to `partial` can also be a path
    to a property containing a template name, e.g.:
  
    ```handlebars
    {{partial someTemplateName}}
    ```
  
    The above example will look up the value of `someTemplateName`
    on the template context (e.g. a controller) and use that
    value as the name of the template to render. If the resolved
    value is falsy, nothing will be rendered. If `someTemplateName`
    changes, the partial will be re-rendered using the new template
    name.
  
    @method partial
    @for Ember.Templates.helpers
    @param {String} partialName The name of the template to render minus the leading underscore.
    @public
  */

  'use strict';

  exports.INVOKE = _emberGlimmerHelpersAction.INVOKE;
  exports.RootTemplate = _emberGlimmerTemplatesRoot.default;
  exports.template = _emberGlimmerTemplate.default;
  exports.Checkbox = _emberGlimmerComponentsCheckbox.default;
  exports.TextField = _emberGlimmerComponentsText_field.default;
  exports.TextArea = _emberGlimmerComponentsText_area.default;
  exports.LinkComponent = _emberGlimmerComponentsLinkTo.default;
  exports.Component = _emberGlimmerComponent.default;
  exports.Helper = _emberGlimmerHelper.default;
  exports.helper = _emberGlimmerHelper.helper;
  exports.Environment = _emberGlimmerEnvironment.default;
  exports.makeBoundHelper = _emberGlimmerMakeBoundHelper.default;
  exports.SafeString = _emberGlimmerUtilsString.SafeString;
  exports.escapeExpression = _emberGlimmerUtilsString.escapeExpression;
  exports.htmlSafe = _emberGlimmerUtilsString.htmlSafe;
  exports.isHTMLSafe = _emberGlimmerUtilsString.isHTMLSafe;
  exports._getSafeString = _emberGlimmerUtilsString.getSafeString;
  exports.Renderer = _emberGlimmerRenderer.Renderer;
  exports.InertRenderer = _emberGlimmerRenderer.InertRenderer;
  exports.InteractiveRenderer = _emberGlimmerRenderer.InteractiveRenderer;
  exports.getTemplate = _emberGlimmerTemplate_registry.getTemplate;
  exports.setTemplate = _emberGlimmerTemplate_registry.setTemplate;
  exports.hasTemplate = _emberGlimmerTemplate_registry.hasTemplate;
  exports.getTemplates = _emberGlimmerTemplate_registry.getTemplates;
  exports.setTemplates = _emberGlimmerTemplate_registry.setTemplates;
  exports.setupEngineRegistry = _emberGlimmerSetupRegistry.setupEngineRegistry;
  exports.setupApplicationRegistry = _emberGlimmerSetupRegistry.setupApplicationRegistry;
  exports.DOMChanges = _emberGlimmerDom.DOMChanges;
  exports.NodeDOMTreeConstruction = _emberGlimmerDom.NodeDOMTreeConstruction;
  exports.DOMTreeConstruction = _emberGlimmerDom.DOMTreeConstruction;
  exports._registerMacros = _emberGlimmerSyntax.registerMacros;
  exports._experimentalMacros = _emberGlimmerSyntax.experimentalMacros;
});
enifed('ember-glimmer/make-bound-helper', ['exports', 'ember-debug', 'ember-glimmer/helper'], function (exports, _emberDebug, _emberGlimmerHelper) {
  /**
  @module ember
  @submodule ember-glimmer
  */
  'use strict';

  exports.default = makeBoundHelper;

  /**
    Create a bound helper. Accepts a function that receives the ordered and hash parameters
    from the template. If a bound property was provided in the template, it will be resolved to its
    value and any changes to the bound property cause the helper function to be re-run with the updated
    values.
  
    * `params` - An array of resolved ordered parameters.
    * `hash` - An object containing the hash parameters.
  
    For example:
  
    * With an unquoted ordered parameter:
  
      ```javascript
      {{x-capitalize foo}}
      ```
  
      Assuming `foo` was set to `"bar"`, the bound helper would receive `["bar"]` as its first argument, and
      an empty hash as its second.
  
    * With a quoted ordered parameter:
  
      ```javascript
      {{x-capitalize "foo"}}
      ```
  
      The bound helper would receive `["foo"]` as its first argument, and an empty hash as its second.
  
    * With an unquoted hash parameter:
  
      ```javascript
      {{x-repeat "foo" count=repeatCount}}
      ```
  
      Assuming that `repeatCount` resolved to 2, the bound helper would receive `["foo"]` as its first argument,
      and { count: 2 } as its second.
  
    @private
    @method makeBoundHelper
    @for Ember.HTMLBars
    @param {Function} fn
    @since 1.10.0
  */

  function makeBoundHelper(fn) {
    _emberDebug.deprecate('Using `Ember.HTMLBars.makeBoundHelper` is deprecated. Please refactor to use `Ember.Helper` or `Ember.Helper.helper`.', false, { id: 'ember-htmlbars.make-bound-helper', until: '3.0.0' });
    return _emberGlimmerHelper.helper(fn);
  }
});
enifed('ember-glimmer/modifiers/action', ['exports', 'ember-utils', 'ember-metal', 'ember-debug', 'ember-views', 'ember-glimmer/helpers/action'], function (exports, _emberUtils, _emberMetal, _emberDebug, _emberViews, _emberGlimmerHelpersAction) {
  'use strict';

  var MODIFIERS = ['alt', 'shift', 'meta', 'ctrl'];
  var POINTER_EVENT_TYPE_REGEX = /^click|mouse|touch/;

  function isAllowedEvent(event, allowedKeys) {
    if (allowedKeys === null || typeof allowedKeys === 'undefined') {
      if (POINTER_EVENT_TYPE_REGEX.test(event.type)) {
        return _emberViews.isSimpleClick(event);
      } else {
        allowedKeys = '';
      }
    }

    if (allowedKeys.indexOf('any') >= 0) {
      return true;
    }

    for (var i = 0; i < MODIFIERS.length; i++) {
      if (event[MODIFIERS[i] + 'Key'] && allowedKeys.indexOf(MODIFIERS[i]) === -1) {
        return false;
      }
    }

    return true;
  }

  var ActionHelper = {
    // registeredActions is re-exported for compatibility with older plugins
    // that were using this undocumented API.
    registeredActions: _emberViews.ActionManager.registeredActions,

    registerAction: function (actionState) {
      var actionId = actionState.actionId;

      _emberViews.ActionManager.registeredActions[actionId] = actionState;

      return actionId;
    },

    unregisterAction: function (actionState) {
      var actionId = actionState.actionId;

      delete _emberViews.ActionManager.registeredActions[actionId];
    }
  };

  exports.ActionHelper = ActionHelper;

  var ActionState = (function () {
    function ActionState(element, actionId, actionName, actionArgs, namedArgs, positionalArgs, implicitTarget, dom) {
      babelHelpers.classCallCheck(this, ActionState);

      this.element = element;
      this.actionId = actionId;
      this.actionName = actionName;
      this.actionArgs = actionArgs;
      this.namedArgs = namedArgs;
      this.positional = positionalArgs;
      this.implicitTarget = implicitTarget;
      this.dom = dom;
      this.eventName = this.getEventName();
    }

    // implements ModifierManager<Action>

    ActionState.prototype.getEventName = function getEventName() {
      return this.namedArgs.get('on').value() || 'click';
    };

    ActionState.prototype.getActionArgs = function getActionArgs() {
      var result = new Array(this.actionArgs.length);

      for (var i = 0; i < this.actionArgs.length; i++) {
        result[i] = this.actionArgs[i].value();
      }

      return result;
    };

    ActionState.prototype.getTarget = function getTarget() {
      var implicitTarget = this.implicitTarget;
      var namedArgs = this.namedArgs;

      var target = undefined;

      if (namedArgs.has('target')) {
        target = namedArgs.get('target').value();
      } else {
        target = implicitTarget.value();
      }

      return target;
    };

    ActionState.prototype.handler = function handler(event) {
      var _this = this;

      var actionName = this.actionName;
      var namedArgs = this.namedArgs;

      var bubbles = namedArgs.get('bubbles');
      var preventDefault = namedArgs.get('preventDefault');
      var allowedKeys = namedArgs.get('allowedKeys');
      var target = this.getTarget();

      if (!isAllowedEvent(event, allowedKeys.value())) {
        return true;
      }

      if (preventDefault.value() !== false) {
        event.preventDefault();
      }

      if (bubbles.value() === false) {
        event.stopPropagation();
      }

      _emberMetal.run(function () {
        var args = _this.getActionArgs();
        var payload = {
          args: args,
          target: target
        };
        if (typeof actionName[_emberGlimmerHelpersAction.INVOKE] === 'function') {
          _emberMetal.flaggedInstrument('interaction.ember-action', payload, function () {
            actionName[_emberGlimmerHelpersAction.INVOKE].apply(actionName, args);
          });
          return;
        }
        if (typeof actionName === 'function') {
          _emberMetal.flaggedInstrument('interaction.ember-action', payload, function () {
            actionName.apply(target, args);
          });
          return;
        }
        payload.name = actionName;
        if (target.send) {
          _emberMetal.flaggedInstrument('interaction.ember-action', payload, function () {
            target.send.apply(target, [actionName].concat(args));
          });
        } else {
          _emberDebug.assert('The action \'' + actionName + '\' did not exist on ' + target, typeof target[actionName] === 'function');
          _emberMetal.flaggedInstrument('interaction.ember-action', payload, function () {
            target[actionName].apply(target, args);
          });
        }
      });
    };

    ActionState.prototype.destroy = function destroy() {
      ActionHelper.unregisterAction(this);
    };

    return ActionState;
  })();

  exports.ActionState = ActionState;

  var ActionModifierManager = (function () {
    function ActionModifierManager() {
      babelHelpers.classCallCheck(this, ActionModifierManager);
    }

    ActionModifierManager.prototype.create = function create(element, args, dynamicScope, dom) {
      var named = args.named;
      var positional = args.positional;

      var implicitTarget = undefined;
      var actionName = undefined;
      var actionNameRef = undefined;
      if (positional.length > 1) {
        implicitTarget = positional.at(0);
        actionNameRef = positional.at(1);

        if (actionNameRef[_emberGlimmerHelpersAction.INVOKE]) {
          actionName = actionNameRef;
        } else {
          var actionLabel = actionNameRef._propertyKey;
          actionName = actionNameRef.value();

          _emberDebug.assert('You specified a quoteless path, `' + actionLabel + '`, to the ' + '{{action}} helper which did not resolve to an action name (a ' + 'string). Perhaps you meant to use a quoted actionName? (e.g. ' + '{{action "' + actionLabel + '"}}).', typeof actionName === 'string' || typeof actionName === 'function');
        }
      }

      var actionArgs = [];
      // The first two arguments are (1) `this` and (2) the action name.
      // Everything else is a param.
      for (var i = 2; i < positional.length; i++) {
        actionArgs.push(positional.at(i));
      }

      var actionId = _emberUtils.uuid();
      return new ActionState(element, actionId, actionName, actionArgs, named, positional, implicitTarget, dom);
    };

    ActionModifierManager.prototype.install = function install(actionState) {
      var dom = actionState.dom;
      var element = actionState.element;
      var actionId = actionState.actionId;

      ActionHelper.registerAction(actionState);

      dom.setAttribute(element, 'data-ember-action', '');
      dom.setAttribute(element, 'data-ember-action-' + actionId, actionId);
    };

    ActionModifierManager.prototype.update = function update(actionState) {
      var positional = actionState.positional;

      var actionNameRef = positional.at(1);

      if (!actionNameRef[_emberGlimmerHelpersAction.INVOKE]) {
        actionState.actionName = actionNameRef.value();
      }

      actionState.eventName = actionState.getEventName();
    };

    ActionModifierManager.prototype.getDestructor = function getDestructor(modifier) {
      return modifier;
    };

    return ActionModifierManager;
  })();

  exports.default = ActionModifierManager;
});
enifed('ember-glimmer/protocol-for-url', ['exports', 'ember-environment'], function (exports, _emberEnvironment) {
  /* globals module, URL */

  'use strict';

  exports.default = installProtocolForURL;

  var nodeURL = undefined;
  var parsingNode = undefined;

  function installProtocolForURL(environment) {
    var protocol = undefined;

    if (_emberEnvironment.environment.hasDOM) {
      protocol = browserProtocolForURL.call(environment, 'foobar:baz');
    }

    // Test to see if our DOM implementation parses
    // and normalizes URLs.
    if (protocol === 'foobar:') {
      // Swap in the method that doesn't do this test now that
      // we know it works.
      environment.protocolForURL = browserProtocolForURL;
    } else if (typeof URL === 'object') {
      // URL globally provided, likely from FastBoot's sandbox
      nodeURL = URL;
      environment.protocolForURL = nodeProtocolForURL;
    } else if (typeof module === 'object' && typeof module.require === 'function') {
      // Otherwise, we need to fall back to our own URL parsing.
      // Global `require` is shadowed by Ember's loader so we have to use the fully
      // qualified `module.require`.
      nodeURL = module.require('url');
      environment.protocolForURL = nodeProtocolForURL;
    } else {
      throw new Error('Could not find valid URL parsing mechanism for URL Sanitization');
    }
  }

  function browserProtocolForURL(url) {
    if (!parsingNode) {
      parsingNode = document.createElement('a');
    }

    parsingNode.href = url;
    return parsingNode.protocol;
  }

  function nodeProtocolForURL(url) {
    var protocol = null;
    if (typeof url === 'string') {
      protocol = nodeURL.parse(url).protocol;
    }
    return protocol === null ? ':' : protocol;
  }
});
enifed('ember-glimmer/renderer', ['exports', 'ember-glimmer/utils/references', 'ember-metal', '@glimmer/reference', 'ember-views', 'ember-glimmer/component', 'ember-glimmer/syntax/curly-component', 'ember-glimmer/syntax/outlet', 'ember-debug'], function (exports, _emberGlimmerUtilsReferences, _emberMetal, _glimmerReference, _emberViews, _emberGlimmerComponent, _emberGlimmerSyntaxCurlyComponent, _emberGlimmerSyntaxOutlet, _emberDebug) {
  'use strict';

  var backburner = _emberMetal.run.backburner;

  var DynamicScope = (function () {
    function DynamicScope(view, outletState, rootOutletState, targetObject) {
      babelHelpers.classCallCheck(this, DynamicScope);

      this.view = view;
      this.outletState = outletState;
      this.rootOutletState = rootOutletState;
    }

    DynamicScope.prototype.child = function child() {
      return new DynamicScope(this.view, this.outletState, this.rootOutletState);
    };

    DynamicScope.prototype.get = function get(key) {
      _emberDebug.assert('Using `-get-dynamic-scope` is only supported for `outletState` (you used `' + key + '`).', key === 'outletState');
      return this.outletState;
    };

    DynamicScope.prototype.set = function set(key, value) {
      _emberDebug.assert('Using `-with-dynamic-scope` is only supported for `outletState` (you used `' + key + '`).', key === 'outletState');
      this.outletState = value;
      return value;
    };

    return DynamicScope;
  })();

  var RootState = (function () {
    function RootState(root, env, template, self, parentElement, dynamicScope) {
      var _this = this;

      babelHelpers.classCallCheck(this, RootState);

      _emberDebug.assert('You cannot render `' + self.value() + '` without a template.', template);

      this.id = _emberViews.getViewId(root);
      this.env = env;
      this.root = root;
      this.result = undefined;
      this.shouldReflush = false;
      this.destroyed = false;
      this._removing = false;

      var options = this.options = {
        alwaysRevalidate: false
      };

      this.render = function () {
        var iterator = template.render(self, parentElement, dynamicScope);
        var iteratorResult = undefined;

        do {
          iteratorResult = iterator.next();
        } while (!iteratorResult.done);

        var result = _this.result = iteratorResult.value;

        // override .render function after initial render
        _this.render = function () {
          result.rerender(options);
        };
      };
    }

    RootState.prototype.isFor = function isFor(possibleRoot) {
      return this.root === possibleRoot;
    };

    RootState.prototype.destroy = function destroy() {
      var result = this.result;
      var env = this.env;

      this.destroyed = true;

      this.env = null;
      this.root = null;
      this.result = null;
      this.render = null;

      if (result) {
        /*
         Handles these scenarios:
          * When roots are removed during standard rendering process, a transaction exists already
           `.begin()` / `.commit()` are not needed.
         * When roots are being destroyed manually (`component.append(); component.destroy() case), no
           transaction exists already.
         * When roots are being destroyed during `Renderer#destroy`, no transaction exists
          */
        var needsTransaction = !env.inTransaction;

        if (needsTransaction) {
          env.begin();
        }

        result.destroy();

        if (needsTransaction) {
          env.commit();
        }
      }
    };

    return RootState;
  })();

  var renderers = [];

  _emberMetal.setHasViews(function () {
    return renderers.length > 0;
  });

  function register(renderer) {
    _emberDebug.assert('Cannot register the same renderer twice', renderers.indexOf(renderer) === -1);
    renderers.push(renderer);
  }

  function deregister(renderer) {
    var index = renderers.indexOf(renderer);
    _emberDebug.assert('Cannot deregister unknown unregistered renderer', index !== -1);
    renderers.splice(index, 1);
  }

  function loopBegin() {
    for (var i = 0; i < renderers.length; i++) {
      renderers[i]._scheduleRevalidate();
    }
  }

  function K() {}

  var loops = 0;
  function loopEnd(current, next) {
    for (var i = 0; i < renderers.length; i++) {
      if (!renderers[i]._isValid()) {
        if (loops > 10) {
          loops = 0;
          // TODO: do something better
          renderers[i].destroy();
          throw new Error('infinite rendering invalidation detected');
        }
        loops++;
        return backburner.join(null, K);
      }
    }
    loops = 0;
  }

  backburner.on('begin', loopBegin);
  backburner.on('end', loopEnd);

  var Renderer = (function () {
    function Renderer(env, rootTemplate) {
      var _viewRegistry = arguments.length <= 2 || arguments[2] === undefined ? _emberViews.fallbackViewRegistry : arguments[2];

      var destinedForDOM = arguments.length <= 3 || arguments[3] === undefined ? false : arguments[3];
      babelHelpers.classCallCheck(this, Renderer);

      this._env = env;
      this._rootTemplate = rootTemplate;
      this._viewRegistry = _viewRegistry;
      this._destinedForDOM = destinedForDOM;
      this._destroyed = false;
      this._roots = [];
      this._lastRevision = null;
      this._isRenderingRoots = false;
      this._removedRoots = [];
    }

    // renderer HOOKS

    Renderer.prototype.appendOutletView = function appendOutletView(view, target) {
      var definition = new _emberGlimmerSyntaxOutlet.TopLevelOutletComponentDefinition(view);
      var outletStateReference = view.toReference();
      var targetObject = view.outletState.render.controller;

      this._appendDefinition(view, definition, target, outletStateReference, targetObject);
    };

    Renderer.prototype.appendTo = function appendTo(view, target) {
      var rootDef = new _emberGlimmerSyntaxCurlyComponent.RootComponentDefinition(view);

      this._appendDefinition(view, rootDef, target);
    };

    Renderer.prototype._appendDefinition = function _appendDefinition(root, definition, target) {
      var outletStateReference = arguments.length <= 3 || arguments[3] === undefined ? _glimmerReference.UNDEFINED_REFERENCE : arguments[3];
      var targetObject = arguments.length <= 4 || arguments[4] === undefined ? null : arguments[4];

      var self = new _emberGlimmerUtilsReferences.RootReference(definition);
      var dynamicScope = new DynamicScope(null, outletStateReference, outletStateReference, true, targetObject);
      var rootState = new RootState(root, this._env, this._rootTemplate, self, target, dynamicScope);

      this._renderRoot(rootState);
    };

    Renderer.prototype.rerender = function rerender(view) {
      this._scheduleRevalidate();
    };

    Renderer.prototype.register = function register(view) {
      var id = _emberViews.getViewId(view);
      _emberDebug.assert('Attempted to register a view with an id already in use: ' + id, !this._viewRegistry[id]);
      this._viewRegistry[id] = view;
    };

    Renderer.prototype.unregister = function unregister(view) {
      delete this._viewRegistry[_emberViews.getViewId(view)];
    };

    Renderer.prototype.remove = function remove(view) {
      view._transitionTo('destroying');

      this.cleanupRootFor(view);

      _emberViews.setViewElement(view, null);

      if (this._destinedForDOM) {
        view.trigger('didDestroyElement');
      }

      if (!view.isDestroying) {
        view.destroy();
      }
    };

    Renderer.prototype.cleanupRootFor = function cleanupRootFor(view) {
      // no need to cleanup roots if we have already been destroyed
      if (this._destroyed) {
        return;
      }

      var roots = this._roots;

      // traverse in reverse so we can remove items
      // without mucking up the index
      var i = this._roots.length;
      while (i--) {
        var root = roots[i];
        if (root.isFor(view)) {
          root.destroy();
        }
      }
    };

    Renderer.prototype.destroy = function destroy() {
      if (this._destroyed) {
        return;
      }
      this._destroyed = true;
      this._clearAllRoots();
    };

    Renderer.prototype.getElement = function getElement(view) {
      // overriden in the subclasses
    };

    Renderer.prototype.getBounds = function getBounds(view) {
      var bounds = view[_emberGlimmerComponent.BOUNDS];

      var parentElement = bounds.parentElement();
      var firstNode = bounds.firstNode();
      var lastNode = bounds.lastNode();

      return { parentElement: parentElement, firstNode: firstNode, lastNode: lastNode };
    };

    Renderer.prototype.createElement = function createElement(tagName) {
      return this._env.getAppendOperations().createElement(tagName);
    };

    Renderer.prototype._renderRoot = function _renderRoot(root) {
      var roots = this._roots;

      roots.push(root);

      if (roots.length === 1) {
        register(this);
      }

      this._renderRootsTransaction();
    };

    Renderer.prototype._renderRoots = function _renderRoots() {
      var roots = this._roots;
      var env = this._env;
      var removedRoots = this._removedRoots;

      var globalShouldReflush = undefined,
          initialRootsLength = undefined;

      do {
        env.begin();

        // ensure that for the first iteration of the loop
        // each root is processed
        initialRootsLength = roots.length;
        globalShouldReflush = false;

        for (var i = 0; i < roots.length; i++) {
          var root = roots[i];

          if (root.destroyed) {
            // add to the list of roots to be removed
            // they will be removed from `this._roots` later
            removedRoots.push(root);

            // skip over roots that have been marked as destroyed
            continue;
          }

          var shouldReflush = root.shouldReflush;

          // when processing non-initial reflush loops,
          // do not process more roots than needed
          if (i >= initialRootsLength && !shouldReflush) {
            continue;
          }

          root.options.alwaysRevalidate = shouldReflush;
          // track shouldReflush based on this roots render result
          shouldReflush = root.shouldReflush = _emberMetal.runInTransaction(root, 'render');

          // globalShouldReflush should be `true` if *any* of
          // the roots need to reflush
          globalShouldReflush = globalShouldReflush || shouldReflush;
        }

        this._lastRevision = _glimmerReference.CURRENT_TAG.value();

        env.commit();
      } while (globalShouldReflush || roots.length > initialRootsLength);

      // remove any roots that were destroyed during this transaction
      while (removedRoots.length) {
        var root = removedRoots.pop();

        var rootIndex = roots.indexOf(root);
        roots.splice(rootIndex, 1);
      }

      if (this._roots.length === 0) {
        deregister(this);
      }
    };

    Renderer.prototype._renderRootsTransaction = function _renderRootsTransaction() {
      if (this._isRenderingRoots) {
        // currently rendering roots, a new root was added and will
        // be processed by the existing _renderRoots invocation
        return;
      }

      // used to prevent calling _renderRoots again (see above)
      // while we are actively rendering roots
      this._isRenderingRoots = true;

      var completedWithoutError = false;
      try {
        this._renderRoots();
        completedWithoutError = true;
      } finally {
        if (!completedWithoutError) {
          this._lastRevision = _glimmerReference.CURRENT_TAG.value();
        }
        this._isRenderingRoots = false;
      }
    };

    Renderer.prototype._clearAllRoots = function _clearAllRoots() {
      var roots = this._roots;
      for (var i = 0; i < roots.length; i++) {
        var root = roots[i];
        root.destroy();
      }

      this._removedRoots.length = 0;
      this._roots = null;

      // if roots were present before destroying
      // deregister this renderer instance
      if (roots.length) {
        deregister(this);
      }
    };

    Renderer.prototype._scheduleRevalidate = function _scheduleRevalidate() {
      backburner.scheduleOnce('render', this, this._revalidate);
    };

    Renderer.prototype._isValid = function _isValid() {
      return this._destroyed || this._roots.length === 0 || _glimmerReference.CURRENT_TAG.validate(this._lastRevision);
    };

    Renderer.prototype._revalidate = function _revalidate() {
      if (this._isValid()) {
        return;
      }
      this._renderRootsTransaction();
    };

    return Renderer;
  })();

  var InertRenderer = (function (_Renderer) {
    babelHelpers.inherits(InertRenderer, _Renderer);

    function InertRenderer() {
      babelHelpers.classCallCheck(this, InertRenderer);

      _Renderer.apply(this, arguments);
    }

    InertRenderer.create = function create(_ref) {
      var env = _ref.env;
      var rootTemplate = _ref.rootTemplate;
      var _viewRegistry = _ref._viewRegistry;

      return new this(env, rootTemplate, _viewRegistry, false);
    };

    InertRenderer.prototype.getElement = function getElement(view) {
      throw new Error('Accessing `this.element` is not allowed in non-interactive environments (such as FastBoot).');
    };

    return InertRenderer;
  })(Renderer);

  exports.InertRenderer = InertRenderer;

  var InteractiveRenderer = (function (_Renderer2) {
    babelHelpers.inherits(InteractiveRenderer, _Renderer2);

    function InteractiveRenderer() {
      babelHelpers.classCallCheck(this, InteractiveRenderer);

      _Renderer2.apply(this, arguments);
    }

    InteractiveRenderer.create = function create(_ref2) {
      var env = _ref2.env;
      var rootTemplate = _ref2.rootTemplate;
      var _viewRegistry = _ref2._viewRegistry;

      return new this(env, rootTemplate, _viewRegistry, true);
    };

    InteractiveRenderer.prototype.getElement = function getElement(view) {
      return _emberViews.getViewElement(view);
    };

    return InteractiveRenderer;
  })(Renderer);

  exports.InteractiveRenderer = InteractiveRenderer;
});
enifed('ember-glimmer/setup-registry', ['exports', 'ember-environment', 'container', 'ember-glimmer/renderer', 'ember-glimmer/dom', 'ember-glimmer/views/outlet', 'ember-glimmer/components/text_field', 'ember-glimmer/components/text_area', 'ember-glimmer/components/checkbox', 'ember-glimmer/components/link-to', 'ember-glimmer/component', 'ember-glimmer/templates/component', 'ember-glimmer/templates/root', 'ember-glimmer/templates/outlet', 'ember-glimmer/environment'], function (exports, _emberEnvironment, _container, _emberGlimmerRenderer, _emberGlimmerDom, _emberGlimmerViewsOutlet, _emberGlimmerComponentsText_field, _emberGlimmerComponentsText_area, _emberGlimmerComponentsCheckbox, _emberGlimmerComponentsLinkTo, _emberGlimmerComponent, _emberGlimmerTemplatesComponent, _emberGlimmerTemplatesRoot, _emberGlimmerTemplatesOutlet, _emberGlimmerEnvironment) {
  'use strict';

  exports.setupApplicationRegistry = setupApplicationRegistry;
  exports.setupEngineRegistry = setupEngineRegistry;

  var _templateObject = babelHelpers.taggedTemplateLiteralLoose(['template:-root'], ['template:-root']),
      _templateObject2 = babelHelpers.taggedTemplateLiteralLoose(['template:components/-default'], ['template:components/-default']),
      _templateObject3 = babelHelpers.taggedTemplateLiteralLoose(['component:-default'], ['component:-default']);

  function setupApplicationRegistry(registry) {
    registry.injection('service:-glimmer-environment', 'appendOperations', 'service:-dom-tree-construction');
    registry.injection('renderer', 'env', 'service:-glimmer-environment');

    registry.register(_container.privatize(_templateObject), _emberGlimmerTemplatesRoot.default);
    registry.injection('renderer', 'rootTemplate', _container.privatize(_templateObject));

    registry.register('renderer:-dom', _emberGlimmerRenderer.InteractiveRenderer);
    registry.register('renderer:-inert', _emberGlimmerRenderer.InertRenderer);

    if (_emberEnvironment.environment.hasDOM) {
      registry.injection('service:-glimmer-environment', 'updateOperations', 'service:-dom-changes');
    }

    registry.register('service:-dom-changes', {
      create: function (_ref) {
        var document = _ref.document;

        return new _emberGlimmerDom.DOMChanges(document);
      }
    });

    registry.register('service:-dom-tree-construction', {
      create: function (_ref2) {
        var document = _ref2.document;

        var Implementation = _emberEnvironment.environment.hasDOM ? _emberGlimmerDom.DOMTreeConstruction : _emberGlimmerDom.NodeDOMTreeConstruction;
        return new Implementation(document);
      }
    });
  }

  function setupEngineRegistry(registry) {
    registry.register('view:-outlet', _emberGlimmerViewsOutlet.default);
    registry.register('template:-outlet', _emberGlimmerTemplatesOutlet.default);
    registry.injection('view:-outlet', 'template', 'template:-outlet');

    registry.injection('service:-dom-changes', 'document', 'service:-document');
    registry.injection('service:-dom-tree-construction', 'document', 'service:-document');

    registry.register(_container.privatize(_templateObject2), _emberGlimmerTemplatesComponent.default);

    registry.register('service:-glimmer-environment', _emberGlimmerEnvironment.default);
    registry.injection('template', 'env', 'service:-glimmer-environment');

    registry.optionsForType('helper', { instantiate: false });

    registry.register('component:-text-field', _emberGlimmerComponentsText_field.default);
    registry.register('component:-text-area', _emberGlimmerComponentsText_area.default);
    registry.register('component:-checkbox', _emberGlimmerComponentsCheckbox.default);
    registry.register('component:link-to', _emberGlimmerComponentsLinkTo.default);
    registry.register(_container.privatize(_templateObject3), _emberGlimmerComponent.default);
  }
});
enifed('ember-glimmer/syntax', ['exports', 'ember-glimmer/syntax/render', 'ember-glimmer/syntax/outlet', 'ember-glimmer/syntax/mount', 'ember-glimmer/syntax/dynamic-component', 'ember-glimmer/utils/bindings', 'ember-glimmer/syntax/-with-dynamic-vars', 'ember-glimmer/syntax/-in-element', 'ember-glimmer/syntax/input', 'ember-glimmer/syntax/-text-area', 'ember-debug'], function (exports, _emberGlimmerSyntaxRender, _emberGlimmerSyntaxOutlet, _emberGlimmerSyntaxMount, _emberGlimmerSyntaxDynamicComponent, _emberGlimmerUtilsBindings, _emberGlimmerSyntaxWithDynamicVars, _emberGlimmerSyntaxInElement, _emberGlimmerSyntaxInput, _emberGlimmerSyntaxTextArea, _emberDebug) {
  'use strict';

  exports.registerMacros = registerMacros;
  exports.populateMacros = populateMacros;

  function refineInlineSyntax(path, params, hash, builder) {
    var name = path[0];

    _emberDebug.assert('You attempted to overwrite the built-in helper "' + name + '" which is not allowed. Please rename the helper.', !(builder.env.builtInHelpers[name] && builder.env.owner.hasRegistration('helper:' + name)));

    if (path.length > 1) {
      return _emberGlimmerSyntaxDynamicComponent.closureComponentMacro(path, params, hash, null, null, builder);
    }

    var symbolTable = builder.symbolTable;

    var definition = undefined;
    if (name.indexOf('-') > -1) {
      definition = builder.env.getComponentDefinition(path, symbolTable);
    }

    if (definition) {
      _emberGlimmerUtilsBindings.wrapComponentClassAttribute(hash);
      builder.component.static(definition, [params, hash, null, null], symbolTable);
      return true;
    }

    return false;
  }

  function refineBlockSyntax(sexp, builder) {
    var path = sexp[1];
    var params = sexp[2];
    var hash = sexp[3];
    var _default = sexp[4];
    var inverse = sexp[5];
    var name = path[0];

    if (path.length > 1) {
      return _emberGlimmerSyntaxDynamicComponent.closureComponentMacro(path, params, hash, _default, inverse, builder);
    }

    if (name.indexOf('-') === -1) {
      return false;
    }

    var symbolTable = builder.symbolTable;

    var definition = undefined;
    if (name.indexOf('-') > -1) {
      definition = builder.env.getComponentDefinition(path, symbolTable);
    }

    if (definition) {
      _emberGlimmerUtilsBindings.wrapComponentClassAttribute(hash);
      builder.component.static(definition, [params, hash, _default, inverse], symbolTable);
      return true;
    }

    _emberDebug.assert('A component or helper named "' + name + '" could not be found', builder.env.hasHelper(path, symbolTable));

    _emberDebug.assert('Helpers may not be used in the block form, for example {{#' + name + '}}{{/' + name + '}}. Please use a component, or alternatively use the helper in combination with a built-in Ember helper, for example {{#if (' + name + ')}}{{/if}}.', !builder.env.hasHelper(path, symbolTable));

    return false;
  }

  var experimentalMacros = [];

  exports.experimentalMacros = experimentalMacros;
  // This is a private API to allow for expiremental macros
  // to be created in user space. Registering a macro should
  // should be done in an initializer.

  function registerMacros(macro) {
    experimentalMacros.push(macro);
  }

  function populateMacros(blocks, inlines) {
    inlines.add('outlet', _emberGlimmerSyntaxOutlet.outletMacro);
    inlines.add('component', _emberGlimmerSyntaxDynamicComponent.inlineComponentMacro);
    inlines.add('render', _emberGlimmerSyntaxRender.renderMacro);
    inlines.add('mount', _emberGlimmerSyntaxMount.mountMacro);
    inlines.add('input', _emberGlimmerSyntaxInput.inputMacro);
    inlines.add('textarea', _emberGlimmerSyntaxTextArea.textAreaMacro);
    inlines.addMissing(refineInlineSyntax);
    blocks.add('component', _emberGlimmerSyntaxDynamicComponent.blockComponentMacro);
    blocks.add('-with-dynamic-vars', _emberGlimmerSyntaxWithDynamicVars._withDynamicVarsMacro);
    blocks.add('-in-element', _emberGlimmerSyntaxInElement._inElementMacro);
    blocks.addMissing(refineBlockSyntax);

    for (var i = 0; i < experimentalMacros.length; i++) {
      var macro = experimentalMacros[i];
      macro(blocks, inlines);
    }

    return { blocks: blocks, inlines: inlines };
  }
});
enifed('ember-glimmer/syntax/-in-element', ['exports', '@glimmer/runtime', '@glimmer/util'], function (exports, _glimmerRuntime, _glimmerUtil) {
  'use strict';

  exports._inElementMacro = _inElementMacro;
  var _BaselineSyntax$NestedBlock = _glimmerRuntime.BaselineSyntax.NestedBlock;
  var defaultBlock = _BaselineSyntax$NestedBlock.defaultBlock;
  var params = _BaselineSyntax$NestedBlock.params;
  var hash = _BaselineSyntax$NestedBlock.hash;

  function _inElementMacro(sexp, builder) {
    var block = defaultBlock(sexp);
    var args = _glimmerRuntime.compileArgs(params(sexp), hash(sexp), builder);

    builder.putArgs(args);
    builder.test('simple');

    builder.labelled(null, function (b) {
      b.jumpUnless('END');
      b.pushRemoteElement();
      b.evaluate(_glimmerUtil.unwrap(block));
      b.popRemoteElement();
    });
  }
});
enifed('ember-glimmer/syntax/-text-area', ['exports', 'ember-glimmer/utils/bindings'], function (exports, _emberGlimmerUtilsBindings) {
  'use strict';

  exports.textAreaMacro = textAreaMacro;

  function textAreaMacro(path, params, hash, builder) {
    var definition = builder.env.getComponentDefinition(['-text-area'], builder.symbolTable);
    _emberGlimmerUtilsBindings.wrapComponentClassAttribute(hash);
    builder.component.static(definition, [params, hash, null, null], builder.symbolTable);
    return true;
  }
});
enifed('ember-glimmer/syntax/-with-dynamic-vars', ['exports', '@glimmer/runtime', '@glimmer/util'], function (exports, _glimmerRuntime, _glimmerUtil) {
  'use strict';

  exports._withDynamicVarsMacro = _withDynamicVarsMacro;
  var _BaselineSyntax$NestedBlock = _glimmerRuntime.BaselineSyntax.NestedBlock;
  var defaultBlock = _BaselineSyntax$NestedBlock.defaultBlock;
  var params = _BaselineSyntax$NestedBlock.params;
  var hash = _BaselineSyntax$NestedBlock.hash;

  function _withDynamicVarsMacro(sexp, builder) {
    var block = defaultBlock(sexp);
    var args = _glimmerRuntime.compileArgs(params(sexp), hash(sexp), builder);

    builder.unit(function (b) {
      b.putArgs(args);
      b.pushDynamicScope();
      b.bindDynamicScope(args.named.keys);
      b.evaluate(_glimmerUtil.unwrap(block));
      b.popDynamicScope();
    });
  }
});
enifed('ember-glimmer/syntax/abstract-manager', ['exports', 'ember-debug'], function (exports, _emberDebug) {
  'use strict';

  var AbstractManager = function AbstractManager() {
    babelHelpers.classCallCheck(this, AbstractManager);
  };

  _emberDebug.runInDebug(function () {
    AbstractManager.prototype._pushToDebugStack = function (name, environment) {
      this.debugStack = environment.debugStack;
      this.debugStack.push(name);
    };

    AbstractManager.prototype._pushEngineToDebugStack = function (name, environment) {
      this.debugStack = environment.debugStack;
      this.debugStack.pushEngine(name);
    };
  });

  exports.default = AbstractManager;
});
enifed('ember-glimmer/syntax/curly-component', ['exports', 'ember-utils', '@glimmer/runtime', 'ember-glimmer/utils/bindings', 'ember-glimmer/component', 'ember-metal', 'ember-debug', 'ember-views', 'ember-glimmer/utils/process-args', 'container', 'ember-glimmer/syntax/abstract-manager'], function (exports, _emberUtils, _glimmerRuntime, _emberGlimmerUtilsBindings, _emberGlimmerComponent, _emberMetal, _emberDebug, _emberViews, _emberGlimmerUtilsProcessArgs, _container, _emberGlimmerSyntaxAbstractManager) {
  'use strict';

  exports.validatePositionalParameters = validatePositionalParameters;

  var _templateObject = babelHelpers.taggedTemplateLiteralLoose(['template:components/-default'], ['template:components/-default']);

  var DEFAULT_LAYOUT = _container.privatize(_templateObject);

  function processComponentInitializationAssertions(component, props) {
    _emberDebug.assert('classNameBindings must not have spaces in them: ' + component.toString(), (function () {
      var classNameBindings = component.classNameBindings;

      for (var i = 0; i < classNameBindings.length; i++) {
        var binding = classNameBindings[i];
        if (binding.split(' ').length > 1) {
          return false;
        }
      }
      return true;
    })());

    _emberDebug.assert('You cannot use `classNameBindings` on a tag-less component: ' + component.toString(), (function () {
      var classNameBindings = component.classNameBindings;
      var tagName = component.tagName;

      return tagName !== '' || !classNameBindings || classNameBindings.length === 0;
    })());

    _emberDebug.assert('You cannot use `elementId` on a tag-less component: ' + component.toString(), (function () {
      var elementId = component.elementId;
      var tagName = component.tagName;

      return tagName !== '' || props.id === elementId || !elementId && elementId !== '';
    })());

    _emberDebug.assert('You cannot use `attributeBindings` on a tag-less component: ' + component.toString(), (function () {
      var attributeBindings = component.attributeBindings;
      var tagName = component.tagName;

      return tagName !== '' || !attributeBindings || attributeBindings.length === 0;
    })());
  }

  function validatePositionalParameters(named, positional, positionalParamsDefinition) {
    _emberDebug.runInDebug(function () {
      if (!named || !positional || !positional.length) {
        return;
      }

      var paramType = typeof positionalParamsDefinition;

      if (paramType === 'string') {
        _emberDebug.assert('You cannot specify positional parameters and the hash argument `' + positionalParamsDefinition + '`.', !named.has(positionalParamsDefinition));
      } else {
        if (positional.length < positionalParamsDefinition.length) {
          positionalParamsDefinition = positionalParamsDefinition.slice(0, positional.length);
        }

        for (var i = 0; i < positionalParamsDefinition.length; i++) {
          var _name = positionalParamsDefinition[i];

          _emberDebug.assert('You cannot specify both a positional param (at position ' + i + ') and the hash argument `' + _name + '`.', !named.has(_name));
        }
      }
    });
  }

  function aliasIdToElementId(args, props) {
    if (args.named.has('id')) {
      _emberDebug.assert('You cannot invoke a component with both \'id\' and \'elementId\' at the same time.', !args.named.has('elementId'));
      props.elementId = props.id;
    }
  }

  // We must traverse the attributeBindings in reverse keeping track of
  // what has already been applied. This is essentially refining the concated
  // properties applying right to left.
  function applyAttributeBindings(element, attributeBindings, component, operations) {
    var seen = [];
    var i = attributeBindings.length - 1;

    while (i !== -1) {
      var binding = attributeBindings[i];
      var parsed = _emberGlimmerUtilsBindings.AttributeBinding.parse(binding);
      var attribute = parsed[1];

      if (seen.indexOf(attribute) === -1) {
        seen.push(attribute);
        _emberGlimmerUtilsBindings.AttributeBinding.install(element, component, parsed, operations);
      }

      i--;
    }

    if (seen.indexOf('id') === -1) {
      operations.addStaticAttribute(element, 'id', component.elementId);
    }

    if (seen.indexOf('style') === -1) {
      _emberGlimmerUtilsBindings.IsVisibleBinding.install(element, component, operations);
    }
  }

  function NOOP() {}

  var ComponentStateBucket = (function () {
    function ComponentStateBucket(environment, component, args, finalizer) {
babelHelpers.classCallCheck(this, ComponentStateBucket);

      this.environment = environment;
      this.component = component;
      this.classRef = null;
      this.args = args;
      this.argsRevision = args.tag.value();
      this.finalizer = finalizer;
    }

    ComponentStateBucket.prototype.destroy = function destroy() {
      var component = this.component;
      var environment = this.environment;

      if (environment.isInteractive) {
        component.trigger('willDestroyElement');
        component.trigger('willClearRender');
      }

      environment.destroyedComponents.push(component);
    };

    ComponentStateBucket.prototype.finalize = function finalize() {
      var finalizer = this.finalizer;

      finalizer();
      this.finalizer = NOOP;
    };

    return ComponentStateBucket;
  })();

  function initialRenderInstrumentDetails(component) {
    return component.instrumentDetails({ initialRender: true });
  }

  function rerenderInstrumentDetails(component) {
    return component.instrumentDetails({ initialRender: false });
  }

  var CurlyComponentManager = (function (_AbstractManager) {
babelHelpers.inherits(CurlyComponentManager, _AbstractManager);

    function CurlyComponentManager() {
babelHelpers.classCallCheck(this, CurlyComponentManager);

      _AbstractManager.apply(this, arguments);
    }

    CurlyComponentManager.prototype.prepareArgs = function prepareArgs(definition, args) {
      if (definition.ComponentClass) {
        validatePositionalParameters(args.named, args.positional.values, definition.ComponentClass.class.positionalParams);
      }

      return _emberGlimmerUtilsProcessArgs.gatherArgs(args, definition);
    };

    CurlyComponentManager.prototype.create = function create(environment, definition, args, dynamicScope, callerSelfRef, hasBlock) {
      var _this = this;

      _emberDebug.runInDebug(function () {
        return _this._pushToDebugStack('component:' + definition.name, environment);
      });

      var parentView = dynamicScope.view;

      var factory = definition.ComponentClass;

      var processedArgs = _emberGlimmerUtilsProcessArgs.ComponentArgs.create(args);

      var _processedArgs$value = processedArgs.value();

      var props = _processedArgs$value.props;

      aliasIdToElementId(args, props);

      props.parentView = parentView;
      props[_emberGlimmerComponent.HAS_BLOCK] = hasBlock;

      props._targetObject = callerSelfRef.value();

      var component = factory.create(props);

      var finalizer = _emberMetal._instrumentStart('render.component', initialRenderInstrumentDetails, component);

      dynamicScope.view = component;

      if (parentView !== null) {
        parentView.appendChild(component);
      }

      // We usually do this in the `didCreateElement`, but that hook doesn't fire for tagless components
      if (component.tagName === '') {
        if (environment.isInteractive) {
          component.trigger('willRender');
        }

        component._transitionTo('hasElement');

        if (environment.isInteractive) {
          component.trigger('willInsertElement');
        }
      }

      var bucket = new ComponentStateBucket(environment, component, processedArgs, finalizer);

      if (args.named.has('class')) {
        bucket.classRef = args.named.get('class');
      }

      _emberDebug.runInDebug(function () {
        processComponentInitializationAssertions(component, props);
      });

      if (environment.isInteractive && component.tagName !== '') {
        component.trigger('willRender');
      }

      return bucket;
    };

    CurlyComponentManager.prototype.layoutFor = function layoutFor(definition, bucket, env) {
      var template = definition.template;
      if (!template) {
        var component = bucket.component;

        template = this.templateFor(component, env);
      }
      return env.getCompiledBlock(CurlyComponentLayoutCompiler, template);
    };

    CurlyComponentManager.prototype.templateFor = function templateFor(component, env) {
      var Template = _emberMetal.get(component, 'layout');
      var owner = component[_emberUtils.OWNER];
      if (Template) {
        return env.getTemplate(Template, owner);
      }
      var layoutName = _emberMetal.get(component, 'layoutName');
      if (layoutName) {
        var template = owner.lookup('template:' + layoutName);
        if (template) {
          return template;
        }
      }
      return owner.lookup(DEFAULT_LAYOUT);
    };

    CurlyComponentManager.prototype.getSelf = function getSelf(_ref) {
      var component = _ref.component;

      return component[_emberGlimmerComponent.ROOT_REF];
    };

    CurlyComponentManager.prototype.didCreateElement = function didCreateElement(_ref2, element, operations) {
      var component = _ref2.component;
      var classRef = _ref2.classRef;
      var environment = _ref2.environment;

      _emberViews.setViewElement(component, element);

      var attributeBindings = component.attributeBindings;
      var classNames = component.classNames;
      var classNameBindings = component.classNameBindings;

      if (attributeBindings && attributeBindings.length) {
        applyAttributeBindings(element, attributeBindings, component, operations);
      } else {
        operations.addStaticAttribute(element, 'id', component.elementId);
        _emberGlimmerUtilsBindings.IsVisibleBinding.install(element, component, operations);
      }

      if (classRef) {
        operations.addDynamicAttribute(element, 'class', classRef);
      }

      if (classNames && classNames.length) {
        classNames.forEach(function (name) {
          operations.addStaticAttribute(element, 'class', name);
        });
      }

      if (classNameBindings && classNameBindings.length) {
        classNameBindings.forEach(function (binding) {
          _emberGlimmerUtilsBindings.ClassNameBinding.install(element, component, binding, operations);
        });
      }

      component._transitionTo('hasElement');

      if (environment.isInteractive) {
        component.trigger('willInsertElement');
      }
    };

    CurlyComponentManager.prototype.didRenderLayout = function didRenderLayout(bucket, bounds) {
      var _this2 = this;

      bucket.component[_emberGlimmerComponent.BOUNDS] = bounds;
      bucket.finalize();

      _emberDebug.runInDebug(function () {
        return _this2.debugStack.pop();
      });
    };

    CurlyComponentManager.prototype.getTag = function getTag(_ref3) {
      var component = _ref3.component;

      return component[_emberGlimmerComponent.DIRTY_TAG];
    };

    CurlyComponentManager.prototype.didCreate = function didCreate(_ref4) {
      var component = _ref4.component;
      var environment = _ref4.environment;

      if (environment.isInteractive) {
        component._transitionTo('inDOM');
        component.trigger('didInsertElement');
        component.trigger('didRender');
      }
    };

    CurlyComponentManager.prototype.update = function update(bucket, _, dynamicScope) {
      var _this3 = this;

      var component = bucket.component;
      var args = bucket.args;
      var argsRevision = bucket.argsRevision;
      var environment = bucket.environment;

      _emberDebug.runInDebug(function () {
        return _this3._pushToDebugStack(component._debugContainerKey, environment);
      });

      bucket.finalizer = _emberMetal._instrumentStart('render.component', rerenderInstrumentDetails, component);

      if (!args.tag.validate(argsRevision)) {
        var _args$value = args.value();

        var attrs = _args$value.attrs;
        var props = _args$value.props;

        bucket.argsRevision = args.tag.value();

        var oldAttrs = component.attrs;
        var newAttrs = attrs;

        component[_emberGlimmerComponent.IS_DISPATCHING_ATTRS] = true;
        component.setProperties(props);
        component[_emberGlimmerComponent.IS_DISPATCHING_ATTRS] = false;

        _emberViews.dispatchLifeCycleHook(component, 'didUpdateAttrs', oldAttrs, newAttrs);
        _emberViews.dispatchLifeCycleHook(component, 'didReceiveAttrs', oldAttrs, newAttrs);
      }

      if (environment.isInteractive) {
        component.trigger('willUpdate');
        component.trigger('willRender');
      }
    };

    CurlyComponentManager.prototype.didUpdateLayout = function didUpdateLayout(bucket) {
      var _this4 = this;

      bucket.finalize();

      _emberDebug.runInDebug(function () {
        return _this4.debugStack.pop();
      });
    };

    CurlyComponentManager.prototype.didUpdate = function didUpdate(_ref5) {
      var component = _ref5.component;
      var environment = _ref5.environment;

      if (environment.isInteractive) {
        component.trigger('didUpdate');
        component.trigger('didRender');
      }
    };

    CurlyComponentManager.prototype.getDestructor = function getDestructor(stateBucket) {
      return stateBucket;
    };

    return CurlyComponentManager;
  })(_emberGlimmerSyntaxAbstractManager.default);

  var MANAGER = new CurlyComponentManager();

  var TopComponentManager = (function (_CurlyComponentManager) {
babelHelpers.inherits(TopComponentManager, _CurlyComponentManager);

    function TopComponentManager() {
babelHelpers.classCallCheck(this, TopComponentManager);

      _CurlyComponentManager.apply(this, arguments);
    }

    TopComponentManager.prototype.create = function create(environment, definition, args, dynamicScope, currentScope, hasBlock) {
      var _this5 = this;

      var component = definition.ComponentClass.create();

      _emberDebug.runInDebug(function () {
        return _this5._pushToDebugStack(component._debugContainerKey, environment);
      });

      var finalizer = _emberMetal._instrumentStart('render.component', initialRenderInstrumentDetails, component);

      dynamicScope.view = component;

      // We usually do this in the `didCreateElement`, but that hook doesn't fire for tagless components
      if (component.tagName === '') {
        if (environment.isInteractive) {
          component.trigger('willRender');
        }

        component._transitionTo('hasElement');

        if (environment.isInteractive) {
          component.trigger('willInsertElement');
        }
      }

      _emberDebug.runInDebug(function () {
        processComponentInitializationAssertions(component, {});
      });

      return new ComponentStateBucket(environment, component, args, finalizer);
    };

    return TopComponentManager;
  })(CurlyComponentManager);

  var ROOT_MANAGER = new TopComponentManager();

  function tagName(vm) {
    var tagName = vm.dynamicScope().view.tagName;

    return _glimmerRuntime.PrimitiveReference.create(tagName === '' ? null : tagName || 'div');
  }

  function ariaRole(vm) {
    return vm.getSelf().get('ariaRole');
  }

  var CurlyComponentDefinition = (function (_ComponentDefinition) {
babelHelpers.inherits(CurlyComponentDefinition, _ComponentDefinition);

    function CurlyComponentDefinition(name, ComponentClass, template, args) {
babelHelpers.classCallCheck(this, CurlyComponentDefinition);

      _ComponentDefinition.call(this, name, MANAGER, ComponentClass);
      this.template = template;
      this.args = args;
    }

    return CurlyComponentDefinition;
  })(_glimmerRuntime.ComponentDefinition);

  exports.CurlyComponentDefinition = CurlyComponentDefinition;

  var RootComponentDefinition = (function (_ComponentDefinition2) {
babelHelpers.inherits(RootComponentDefinition, _ComponentDefinition2);

    function RootComponentDefinition(instance) {
babelHelpers.classCallCheck(this, RootComponentDefinition);

      _ComponentDefinition2.call(this, '-root', ROOT_MANAGER, {
        class: instance.constructor,
        create: function () {
          return instance;
        }
      });
      this.template = undefined;
      this.args = undefined;
    }

    return RootComponentDefinition;
  })(_glimmerRuntime.ComponentDefinition);

  exports.RootComponentDefinition = RootComponentDefinition;

  var CurlyComponentLayoutCompiler = (function () {
    function CurlyComponentLayoutCompiler(template) {
babelHelpers.classCallCheck(this, CurlyComponentLayoutCompiler);

      this.template = template;
    }

    CurlyComponentLayoutCompiler.prototype.compile = function compile(builder) {
      builder.wrapLayout(this.template.asLayout());
      builder.tag.dynamic(tagName);
      builder.attrs.dynamic('role', ariaRole);
      builder.attrs.static('class', 'ember-view');
    };

    return CurlyComponentLayoutCompiler;
  })();

  CurlyComponentLayoutCompiler.id = 'curly';
});
enifed('ember-glimmer/syntax/dynamic-component', ['exports', '@glimmer/runtime', '@glimmer/reference', 'ember-debug'], function (exports, _glimmerRuntime, _glimmerReference, _emberDebug) {
  'use strict';

  exports.closureComponentMacro = closureComponentMacro;
  exports.dynamicComponentMacro = dynamicComponentMacro;
  exports.blockComponentMacro = blockComponentMacro;
  exports.inlineComponentMacro = inlineComponentMacro;

  function dynamicComponentFor(vm, symbolTable) {
    var env = vm.env;
    var args = vm.getArgs();
    var nameRef = args.positional.at(0);

    return new DynamicComponentReference({ nameRef: nameRef, env: env, symbolTable: symbolTable });
  }

  function closureComponentMacro(path, params, hash, _default, inverse, builder) {
    var definitionArgs = [[['get', path]], hash, _default, inverse];
    var args = [params, hash, _default, inverse];
    builder.component.dynamic(definitionArgs, dynamicComponentFor, args, builder.symbolTable);
    return true;
  }

  function dynamicComponentMacro(params, hash, _default, inverse, builder) {
    var definitionArgs = [params.slice(0, 1), null, null, null];
    var args = [params.slice(1), hash, null, null];
    builder.component.dynamic(definitionArgs, dynamicComponentFor, args, builder.symbolTable);
    return true;
  }

  function blockComponentMacro(sexp, builder) {
    var params = sexp[2];
    var hash = sexp[3];
    var _default = sexp[4];
    var inverse = sexp[5];

    var definitionArgs = [params.slice(0, 1), null, null, null];
    var args = [params.slice(1), hash, _default, inverse];
    builder.component.dynamic(definitionArgs, dynamicComponentFor, args, builder.symbolTable);
    return true;
  }

  function inlineComponentMacro(path, params, hash, builder) {
    var definitionArgs = [params.slice(0, 1), null, null, null];
    var args = [params.slice(1), hash, null, null];
    builder.component.dynamic(definitionArgs, dynamicComponentFor, args, builder.symbolTable);
    return true;
  }

  var DynamicComponentReference = (function () {
    function DynamicComponentReference(_ref) {
      var nameRef = _ref.nameRef;
      var env = _ref.env;
      var symbolTable = _ref.symbolTable;
      var args = _ref.args;
      babelHelpers.classCallCheck(this, DynamicComponentReference);

      this.tag = nameRef.tag;
      this.nameRef = nameRef;
      this.env = env;
      this.symbolTable = symbolTable;
      this.args = args;
    }

    DynamicComponentReference.prototype.value = function value() {
      var env = this.env;
      var nameRef = this.nameRef;
      var symbolTable = this.symbolTable;

      var nameOrDef = nameRef.value();

      if (typeof nameOrDef === 'string') {
        var definition = env.getComponentDefinition([nameOrDef], symbolTable);

        _emberDebug.assert('Could not find component named "' + nameOrDef + '" (no component or template with that name was found)', definition);

        return definition;
      } else if (_glimmerRuntime.isComponentDefinition(nameOrDef)) {
        return nameOrDef;
      } else {
        return null;
      }
    };

    DynamicComponentReference.prototype.get = function get() {
      return _glimmerReference.UNDEFINED_REFERENCE;
    };

    return DynamicComponentReference;
  })();
});
enifed('ember-glimmer/syntax/input', ['exports', 'ember-debug', 'ember-glimmer/utils/bindings', 'ember-glimmer/syntax/dynamic-component'], function (exports, _emberDebug, _emberGlimmerUtilsBindings, _emberGlimmerSyntaxDynamicComponent) {
  /**
  @module ember
  @submodule ember-glimmer
  */
  'use strict';

  exports.inputMacro = inputMacro;

  function buildTextFieldSyntax(params, hash, builder) {
    var definition = builder.env.getComponentDefinition(['-text-field'], builder.symbolTable);
    builder.component.static(definition, [params, hash, null, null], builder.symbolTable);
    return true;
  }

  /**
    The `{{input}}` helper lets you create an HTML `<input />` component.
    It causes an `Ember.TextField` component to be rendered.  For more info,
    see the [Ember.TextField](/api/classes/Ember.TextField.html) docs and
    the [templates guide](http://emberjs.com/guides/templates/input-helpers/).
  
    ```handlebars
    {{input value="987"}}
    ```
  
    renders as:
  
    ```HTML
    <input type="text" value="987" />
    ```
  
    ### Text field
  
    If no `type` option is specified, a default of type 'text' is used.
    Many of the standard HTML attributes may be passed to this helper.
    <table>
      <tr><td>`readonly`</td><td>`required`</td><td>`autofocus`</td></tr>
      <tr><td>`value`</td><td>`placeholder`</td><td>`disabled`</td></tr>
      <tr><td>`size`</td><td>`tabindex`</td><td>`maxlength`</td></tr>
      <tr><td>`name`</td><td>`min`</td><td>`max`</td></tr>
      <tr><td>`pattern`</td><td>`accept`</td><td>`autocomplete`</td></tr>
      <tr><td>`autosave`</td><td>`formaction`</td><td>`formenctype`</td></tr>
      <tr><td>`formmethod`</td><td>`formnovalidate`</td><td>`formtarget`</td></tr>
      <tr><td>`height`</td><td>`inputmode`</td><td>`multiple`</td></tr>
      <tr><td>`step`</td><td>`width`</td><td>`form`</td></tr>
      <tr><td>`selectionDirection`</td><td>`spellcheck`</td><td>&nbsp;</td></tr>
    </table>
    When set to a quoted string, these values will be directly applied to the HTML
    element. When left unquoted, these values will be bound to a property on the
    template's current rendering context (most typically a controller instance).
    A very common use of this helper is to bind the `value` of an input to an Object's attribute:
  
    ```handlebars
    Search:
    {{input value=searchWord}}
    ```
  
    In this example, the inital value in the `<input />` will be set to the value of `searchWord`.
    If the user changes the text, the value of `searchWord` will also be updated.
  
    ### Actions
  
    The helper can send multiple actions based on user events.
    The action property defines the action which is sent when
    the user presses the return key.
  
    ```handlebars
    {{input action="submit"}}
    ```
  
    The helper allows some user events to send actions.
  
    * `enter`
    * `insert-newline`
    * `escape-press`
    * `focus-in`
    * `focus-out`
    * `key-press`
    * `key-up`
  
    For example, if you desire an action to be sent when the input is blurred,
    you only need to setup the action name to the event name property.
  
    ```handlebars
    {{input focus-out="alertMessage"}}
    ```
    See more about [Text Support Actions](/api/classes/Ember.TextField.html)
  
    ### Extending `Ember.TextField`
  
    Internally, `{{input type="text"}}` creates an instance of `Ember.TextField`, passing
    arguments from the helper to `Ember.TextField`'s `create` method. You can extend the
    capabilities of text inputs in your applications by reopening this class. For example,
    if you are building a Bootstrap project where `data-*` attributes are used, you
    can add one to the `TextField`'s `attributeBindings` property:
  
    ```javascript
    Ember.TextField.reopen({
      attributeBindings: ['data-error']
    });
    ```
  
    Keep in mind when writing `Ember.TextField` subclasses that `Ember.TextField`
    itself extends `Ember.Component`. Expect isolated component semantics, not
    legacy 1.x view semantics (like `controller` being present).
    See more about [Ember components](/api/classes/Ember.Component.html)
  
    ### Checkbox
  
    Checkboxes are special forms of the `{{input}}` helper.  To create a `<checkbox />`:
  
    ```handlebars
    Emberize Everything:
    {{input type="checkbox" name="isEmberized" checked=isEmberized}}
    ```
  
    This will bind checked state of this checkbox to the value of `isEmberized`  -- if either one changes,
    it will be reflected in the other.
  
    The following HTML attributes can be set via the helper:
  
    * `checked`
    * `disabled`
    * `tabindex`
    * `indeterminate`
    * `name`
    * `autofocus`
    * `form`
  
    ### Extending `Ember.Checkbox`
  
    Internally, `{{input type="checkbox"}}` creates an instance of `Ember.Checkbox`, passing
    arguments from the helper to `Ember.Checkbox`'s `create` method. You can extend the
    capablilties of checkbox inputs in your applications by reopening this class. For example,
    if you wanted to add a css class to all checkboxes in your application:
  
    ```javascript
    Ember.Checkbox.reopen({
      classNames: ['my-app-checkbox']
    });
    ```
  
    @method input
    @for Ember.Templates.helpers
    @param {Hash} options
    @public
  */

  function inputMacro(path, params, hash, builder) {
    var keys = undefined;
    var values = undefined;
    var typeIndex = -1;
    var valueIndex = -1;

    if (hash) {
      keys = hash[0];
      values = hash[1];
      typeIndex = keys.indexOf('type');
      valueIndex = keys.indexOf('value');
    }

    if (!params) {
      params = [];
    }

    if (typeIndex > -1) {
      var typeArg = values[typeIndex];
      if (!Array.isArray(typeArg)) {
        if (typeArg === 'checkbox') {
          _emberDebug.assert('{{input type=\'checkbox\'}} does not support setting `value=someBooleanValue`; ' + 'you must use `checked=someBooleanValue` instead.', valueIndex === -1);

          _emberGlimmerUtilsBindings.wrapComponentClassAttribute(hash);

          var definition = builder.env.getComponentDefinition(['-checkbox'], builder.symbolTable);
          builder.component.static(definition, [params, hash, null, null], builder.symbolTable);
          return true;
        } else {
          return buildTextFieldSyntax(params, hash, builder);
        }
      }
    } else {
      return buildTextFieldSyntax(params, hash, builder);
    }

    return _emberGlimmerSyntaxDynamicComponent.dynamicComponentMacro(params, hash, null, null, builder);
  }
});
enifed('ember-glimmer/syntax/mount', ['exports', '@glimmer/runtime', '@glimmer/reference', 'ember-debug', 'ember-glimmer/utils/references', 'ember-routing', 'ember-glimmer/syntax/outlet', 'container', 'ember-glimmer/syntax/abstract-manager'], function (exports, _glimmerRuntime, _glimmerReference, _emberDebug, _emberGlimmerUtilsReferences, _emberRouting, _emberGlimmerSyntaxOutlet, _container, _emberGlimmerSyntaxAbstractManager) {
  /**
  @module ember
  @submodule ember-glimmer
  */
  'use strict';

  exports.mountMacro = mountMacro;

  function dynamicEngineFor(vm, symbolTable) {
    var env = vm.env;
    var args = vm.getArgs();
    var nameRef = args.positional.at(0);

    return new DynamicEngineReference({ nameRef: nameRef, env: env, symbolTable: symbolTable });
  }

  /**
    The `{{mount}}` helper lets you embed a routeless engine in a template.
    Mounting an engine will cause an instance to be booted and its `application`
    template to be rendered.
  
    For example, the following template mounts the `ember-chat` engine:
  
    ```handlebars
    {{! application.hbs }}
    {{mount "ember-chat"}}
    ```
  
    Currently, the engine name is the only argument that can be passed to
    `{{mount}}`.
  
    @method mount
    @for Ember.Templates.helpers
    @category ember-application-engines
    @public
  */

  function mountMacro(path, params, hash, builder) {
    _emberDebug.assert('You can only pass a single argument to the {{mount}} helper, e.g. {{mount "chat-engine"}}.', params.length === 1 && hash === null);

    _emberDebug.assert('The first argument of {{mount}} must be quoted, e.g. {{mount "chat-engine"}}.', typeof params[0] === 'string');

    var definitionArgs = [params.slice(0, 1), null, null, null];
    var args = [null, null, null, null];
    builder.component.dynamic(definitionArgs, dynamicEngineFor, args, builder.symbolTable);
    return true;
  }

  var DynamicEngineReference = (function () {
    function DynamicEngineReference(_ref) {
      var nameRef = _ref.nameRef;
      var env = _ref.env;
      var symbolTable = _ref.symbolTable;
      var args = _ref.args;
      babelHelpers.classCallCheck(this, DynamicEngineReference);

      this.tag = nameRef.tag;
      this.nameRef = nameRef;
      this.env = env;
      this.symbolTable = symbolTable;
      this._lastName = undefined;
      this._lastDef = undefined;
    }

    DynamicEngineReference.prototype.value = function value() {
      var env = /*symbolTable*/this.env;
      var nameRef = this.nameRef;

      var nameOrDef = nameRef.value();

      if (this._lastName === nameOrDef) {
        return this._lastDef;
      }

      _emberDebug.assert('You used `{{mount \'' + nameOrDef + '\'}}`, but the engine \'' + nameOrDef + '\' can not be found.', env.owner.hasRegistration('engine:' + nameOrDef));

      if (!env.owner.hasRegistration('engine:' + nameOrDef)) {
        return null;
      }

      this._lastName = nameOrDef;
      this._lastDef = new MountDefinition(nameOrDef);

      return this._lastDef;
    };

    return DynamicEngineReference;
  })();

  var MountManager = (function (_AbstractManager) {
    babelHelpers.inherits(MountManager, _AbstractManager);

    function MountManager() {
      babelHelpers.classCallCheck(this, MountManager);

      _AbstractManager.apply(this, arguments);
    }

    MountManager.prototype.prepareArgs = function prepareArgs(definition, args) {
      return args;
    };

    MountManager.prototype.create = function create(environment, _ref2, args, dynamicScope) {
      var name = _ref2.name;

      var _this = this;

      _emberDebug.runInDebug(function () {
        return _this._pushEngineToDebugStack('engine:' + name, environment);
      });

      dynamicScope.outletState = _glimmerReference.UNDEFINED_REFERENCE;

      var engine = environment.owner.buildChildEngineInstance(name);

      engine.boot();

      return engine;
    };

    MountManager.prototype.layoutFor = function layoutFor(definition, engine, env) {
      var template = engine.lookup('template:application');
      return env.getCompiledBlock(_emberGlimmerSyntaxOutlet.OutletLayoutCompiler, template);
    };

    MountManager.prototype.getSelf = function getSelf(engine) {
      var applicationFactory = engine[_container.FACTORY_FOR]('controller:application');
      var factory = applicationFactory || _emberRouting.generateControllerFactory(engine, 'application');
      return new _emberGlimmerUtilsReferences.RootReference(factory.create());
    };

    MountManager.prototype.getTag = function getTag() {
      return null;
    };

    MountManager.prototype.getDestructor = function getDestructor(engine) {
      return engine;
    };

    MountManager.prototype.didCreateElement = function didCreateElement() {};

    MountManager.prototype.didRenderLayout = function didRenderLayout() {
      var _this2 = this;

      _emberDebug.runInDebug(function () {
        return _this2.debugStack.pop();
      });
    };

    MountManager.prototype.didCreate = function didCreate(state) {};

    MountManager.prototype.update = function update(state, args, dynamicScope) {};

    MountManager.prototype.didUpdateLayout = function didUpdateLayout() {};

    MountManager.prototype.didUpdate = function didUpdate(state) {};

    return MountManager;
  })(_emberGlimmerSyntaxAbstractManager.default);

  var MOUNT_MANAGER = new MountManager();

  var MountDefinition = (function (_ComponentDefinition) {
    babelHelpers.inherits(MountDefinition, _ComponentDefinition);

    function MountDefinition(name) {
      babelHelpers.classCallCheck(this, MountDefinition);

      _ComponentDefinition.call(this, name, MOUNT_MANAGER, null);
    }

    return MountDefinition;
  })(_glimmerRuntime.ComponentDefinition);
});
enifed('ember-glimmer/syntax/outlet', ['exports', 'ember-utils', '@glimmer/runtime', 'ember-debug', 'ember-metal', 'ember-glimmer/utils/references', 'ember-glimmer/syntax/abstract-manager', '@glimmer/reference'], function (exports, _emberUtils, _glimmerRuntime, _emberDebug, _emberMetal, _emberGlimmerUtilsReferences, _emberGlimmerSyntaxAbstractManager, _glimmerReference) {
  /**
  @module ember
  @submodule ember-glimmer
  */
  'use strict';

  exports.outletMacro = outletMacro;

  function outletComponentFor(vm) {
    var _vm$dynamicScope = vm.dynamicScope();

    var outletState = _vm$dynamicScope.outletState;

    var args = vm.getArgs();
    var outletNameRef = undefined;
    if (args.positional.length === 0) {
      outletNameRef = new _glimmerReference.ConstReference('main');
    } else {
      outletNameRef = args.positional.at(0);
    }

    return new OutletComponentReference(outletNameRef, outletState);
  }

  /**
    The `{{outlet}}` helper lets you specify where a child route will render in
    your template. An important use of the `{{outlet}}` helper is in your
    application's `application.hbs` file:
  
    ```handlebars
    {{! app/templates/application.hbs }}
    <!-- header content goes here, and will always display -->
    {{my-header}}
    <div class="my-dynamic-content">
      <!-- this content will change based on the current route, which depends on the current URL -->
      {{outlet}}
    </div>
    <!-- footer content goes here, and will always display -->
    {{my-footer}}
    ```
  
    See [templates guide](http://emberjs.com/guides/templates/the-application-template/) for
    additional information on using `{{outlet}}` in `application.hbs`.
    You may also specify a name for the `{{outlet}}`, which is useful when using more than one
    `{{outlet}}` in a template:
  
    ```handlebars
    {{outlet "menu"}}
    {{outlet "sidebar"}}
    {{outlet "main"}}
    ```
  
    Your routes can then render into a specific one of these `outlet`s by specifying the `outlet`
    attribute in your `renderTemplate` function:
  
    ```javascript
    // app/routes/menu.js
    export default Ember.Route.extend({
      renderTemplate() {
        this.render({ outlet: 'menu' });
      }
    });
    ```
  
    See the [routing guide](http://emberjs.com/guides/routing/rendering-a-template/) for more
    information on how your `route` interacts with the `{{outlet}}` helper.
    Note: Your content __will not render__ if there isn't an `{{outlet}}` for it.
  
    @method outlet
    @param {String} [name]
    @for Ember.Templates.helpers
    @public
  */

  function outletMacro(path, params, hash, builder) {
    if (!params) {
      params = [];
    }
    var definitionArgs = [params.slice(0, 1), null, null, null];
    builder.component.dynamic(definitionArgs, outletComponentFor, _glimmerRuntime.CompiledArgs.empty(), builder.symbolTable, null);
    return true;
  }

  var OutletComponentReference = (function () {
    function OutletComponentReference(outletNameRef, parentOutletStateRef) {
      babelHelpers.classCallCheck(this, OutletComponentReference);

      this.outletNameRef = outletNameRef;
      this.parentOutletStateRef = parentOutletStateRef;
      this.definition = null;
      this.lastState = null;
      var outletStateTag = this.outletStateTag = new _glimmerReference.UpdatableTag(parentOutletStateRef.tag);
      this.tag = _glimmerReference.combine([outletStateTag.tag, outletNameRef.tag]);
    }

    OutletComponentReference.prototype.value = function value() {
      var outletNameRef = this.outletNameRef;
      var parentOutletStateRef = this.parentOutletStateRef;
      var definition = this.definition;
      var lastState = this.lastState;

      var outletName = outletNameRef.value();
      var outletStateRef = parentOutletStateRef.get('outlets').get(outletName);
      var newState = this.lastState = outletStateRef.value();

      this.outletStateTag.update(outletStateRef.tag);

      definition = revalidate(definition, lastState, newState);

      var hasTemplate = newState && newState.render.template;

      if (definition) {
        return definition;
      } else if (hasTemplate) {
        return this.definition = new OutletComponentDefinition(outletName, newState.render.template);
      } else {
        return this.definition = null;
      }
    };

    return OutletComponentReference;
  })();

  function revalidate(definition, lastState, newState) {
    if (!lastState && !newState) {
      return definition;
    }

    if (!lastState && newState || lastState && !newState) {
      return null;
    }

    if (newState.render.template === lastState.render.template && newState.render.controller === lastState.render.controller) {
      return definition;
    }

    return null;
  }

  function instrumentationPayload(_ref) {
    var _ref$render = _ref.render;
    var name = _ref$render.name;
    var outlet = _ref$render.outlet;

    return { object: name + ':' + outlet };
  }

  function NOOP() {}

  var StateBucket = (function () {
    function StateBucket(outletState) {
      babelHelpers.classCallCheck(this, StateBucket);

      this.outletState = outletState;
      this.instrument();
    }

    StateBucket.prototype.instrument = function instrument() {
      this.finalizer = _emberMetal._instrumentStart('render.outlet', instrumentationPayload, this.outletState);
    };

    StateBucket.prototype.finalize = function finalize() {
      var finalizer = this.finalizer;

      finalizer();
      this.finalizer = NOOP;
    };

    return StateBucket;
  })();

  var OutletComponentManager = (function (_AbstractManager) {
    babelHelpers.inherits(OutletComponentManager, _AbstractManager);

    function OutletComponentManager() {
      babelHelpers.classCallCheck(this, OutletComponentManager);

      _AbstractManager.apply(this, arguments);
    }

    OutletComponentManager.prototype.prepareArgs = function prepareArgs(definition, args) {
      return args;
    };

    OutletComponentManager.prototype.create = function create(environment, definition, args, dynamicScope) {
      var _this = this;

      _emberDebug.runInDebug(function () {
        return _this._pushToDebugStack('template:' + definition.template.meta.moduleName, environment);
      });

      var outletStateReference = dynamicScope.outletState = dynamicScope.outletState.get('outlets').get(definition.outletName);
      var outletState = outletStateReference.value();
      return new StateBucket(outletState);
    };

    OutletComponentManager.prototype.layoutFor = function layoutFor(definition, bucket, env) {
      return env.getCompiledBlock(OutletLayoutCompiler, definition.template);
    };

    OutletComponentManager.prototype.getSelf = function getSelf(_ref2) {
      var outletState = _ref2.outletState;

      return new _emberGlimmerUtilsReferences.RootReference(outletState.render.controller);
    };

    OutletComponentManager.prototype.getTag = function getTag() {
      return null;
    };

    OutletComponentManager.prototype.getDestructor = function getDestructor() {
      return null;
    };

    OutletComponentManager.prototype.didRenderLayout = function didRenderLayout(bucket) {
      var _this2 = this;

      bucket.finalize();

      _emberDebug.runInDebug(function () {
        return _this2.debugStack.pop();
      });
    };

    OutletComponentManager.prototype.didCreateElement = function didCreateElement() {};

    OutletComponentManager.prototype.didCreate = function didCreate(state) {};

    OutletComponentManager.prototype.update = function update(bucket) {};

    OutletComponentManager.prototype.didUpdateLayout = function didUpdateLayout(bucket) {};

    OutletComponentManager.prototype.didUpdate = function didUpdate(state) {};

    return OutletComponentManager;
  })(_emberGlimmerSyntaxAbstractManager.default);

  var MANAGER = new OutletComponentManager();

  var TopLevelOutletComponentManager = (function (_OutletComponentManager) {
    babelHelpers.inherits(TopLevelOutletComponentManager, _OutletComponentManager);

    function TopLevelOutletComponentManager() {
      babelHelpers.classCallCheck(this, TopLevelOutletComponentManager);

      _OutletComponentManager.apply(this, arguments);
    }

    TopLevelOutletComponentManager.prototype.create = function create(environment, definition, args, dynamicScope) {
      var _this3 = this;

      _emberDebug.runInDebug(function () {
        return _this3._pushToDebugStack('template:' + definition.template.meta.moduleName, environment);
      });

      return new StateBucket(dynamicScope.outletState.value());
    };

    TopLevelOutletComponentManager.prototype.layoutFor = function layoutFor(definition, bucket, env) {
      return env.getCompiledBlock(TopLevelOutletLayoutCompiler, definition.template);
    };

    return TopLevelOutletComponentManager;
  })(OutletComponentManager);

  var TOP_LEVEL_MANAGER = new TopLevelOutletComponentManager();

  var TopLevelOutletComponentDefinition = (function (_ComponentDefinition) {
    babelHelpers.inherits(TopLevelOutletComponentDefinition, _ComponentDefinition);

    function TopLevelOutletComponentDefinition(instance) {
      babelHelpers.classCallCheck(this, TopLevelOutletComponentDefinition);

      _ComponentDefinition.call(this, 'outlet', TOP_LEVEL_MANAGER, instance);
      this.template = instance.template;
      _emberUtils.generateGuid(this);
    }

    return TopLevelOutletComponentDefinition;
  })(_glimmerRuntime.ComponentDefinition);

  exports.TopLevelOutletComponentDefinition = TopLevelOutletComponentDefinition;

  var TopLevelOutletLayoutCompiler = (function () {
    function TopLevelOutletLayoutCompiler(template) {
      babelHelpers.classCallCheck(this, TopLevelOutletLayoutCompiler);

      this.template = template;
    }

    TopLevelOutletLayoutCompiler.prototype.compile = function compile(builder) {
      builder.wrapLayout(this.template.asLayout());
      builder.tag.static('div');
      builder.attrs.static('id', _emberUtils.guidFor(this));
      builder.attrs.static('class', 'ember-view');
    };

    return TopLevelOutletLayoutCompiler;
  })();

  TopLevelOutletLayoutCompiler.id = 'top-level-outlet';

  var OutletComponentDefinition = (function (_ComponentDefinition2) {
    babelHelpers.inherits(OutletComponentDefinition, _ComponentDefinition2);

    function OutletComponentDefinition(outletName, template) {
      babelHelpers.classCallCheck(this, OutletComponentDefinition);

      _ComponentDefinition2.call(this, 'outlet', MANAGER, null);
      this.outletName = outletName;
      this.template = template;
      _emberUtils.generateGuid(this);
    }

    return OutletComponentDefinition;
  })(_glimmerRuntime.ComponentDefinition);

  var OutletLayoutCompiler = (function () {
    function OutletLayoutCompiler(template) {
      babelHelpers.classCallCheck(this, OutletLayoutCompiler);

      this.template = template;
    }

    OutletLayoutCompiler.prototype.compile = function compile(builder) {
      builder.wrapLayout(this.template.asLayout());
    };

    return OutletLayoutCompiler;
  })();

  exports.OutletLayoutCompiler = OutletLayoutCompiler;

  OutletLayoutCompiler.id = 'outlet';
});
enifed('ember-glimmer/syntax/render', ['exports', '@glimmer/runtime', '@glimmer/reference', 'ember-debug', 'ember-glimmer/utils/references', 'ember-routing', 'ember-glimmer/syntax/outlet', 'container', 'ember-glimmer/syntax/abstract-manager'], function (exports, _glimmerRuntime, _glimmerReference, _emberDebug, _emberGlimmerUtilsReferences, _emberRouting, _emberGlimmerSyntaxOutlet, _container, _emberGlimmerSyntaxAbstractManager) {
  /**
  @module ember
  @submodule ember-glimmer
  */
  'use strict';

  exports.renderMacro = renderMacro;

  function makeComponentDefinition(vm) {
    var env = vm.env;
    var args = vm.getArgs();
    var nameRef = args.positional.at(0);

    _emberDebug.assert('The first argument of {{render}} must be quoted, e.g. {{render "sidebar"}}.', _glimmerReference.isConst(nameRef));
    _emberDebug.assert('The second argument of {{render}} must be a path, e.g. {{render "post" post}}.', args.positional.length === 1 || !_glimmerReference.isConst(args.positional.at(1)));

    var templateName = nameRef.value();

    _emberDebug.assert('You used `{{render \'' + templateName + '\'}}`, but \'' + templateName + '\' can not be found as a template.', env.owner.hasRegistration('template:' + templateName));

    var template = env.owner.lookup('template:' + templateName);

    var controllerName = undefined;

    if (args.named.has('controller')) {
      var controllerNameRef = args.named.get('controller');

      _emberDebug.assert('The controller argument for {{render}} must be quoted, e.g. {{render "sidebar" controller="foo"}}.', _glimmerReference.isConst(controllerNameRef));

      controllerName = controllerNameRef.value();

      _emberDebug.assert('The controller name you supplied \'' + controllerName + '\' did not resolve to a controller.', env.owner.hasRegistration('controller:' + controllerName));
    } else {
      controllerName = templateName;
    }

    if (args.positional.length === 1) {
      return new _glimmerReference.ConstReference(new RenderDefinition(controllerName, template, env, SINGLETON_RENDER_MANAGER));
    } else {
      return new _glimmerReference.ConstReference(new RenderDefinition(controllerName, template, env, NON_SINGLETON_RENDER_MANAGER));
    }
  }

  /**
    Calling ``{{render}}`` from within a template will insert another
    template that matches the provided name. The inserted template will
    access its properties on its own controller (rather than the controller
    of the parent template).
  
    If a view class with the same name exists, the view class also will be used.
    Note: A given controller may only be used *once* in your app in this manner.
    A singleton instance of the controller will be created for you.
  
    Example:
  
    ```javascript
    App.NavigationController = Ember.Controller.extend({
      who: "world"
    });
    ```
  
    ```handlebars
    <!-- navigation.hbs -->
    Hello, {{who}}.
    ```
  
    ```handlebars
    <!-- application.hbs -->
    <h1>My great app</h1>
    {{render "navigation"}}
    ```
  
    ```html
    <h1>My great app</h1>
    <div class='ember-view'>
      Hello, world.
    </div>
    ```
  
    Optionally you may provide a second argument: a property path
    that will be bound to the `model` property of the controller.
    If a `model` property path is specified, then a new instance of the
    controller will be created and `{{render}}` can be used multiple times
    with the same name.
  
    For example if you had this `author` template.
  
    ```handlebars
    <div class="author">
      Written by {{firstName}} {{lastName}}.
      Total Posts: {{postCount}}
    </div>
    ```
  
    You could render it inside the `post` template using the `render` helper.
  
    ```handlebars
    <div class="post">
      <h1>{{title}}</h1>
      <div>{{body}}</div>
      {{render "author" author}}
    </div>
    ```
  
    @method render
    @for Ember.Templates.helpers
    @param {String} name
    @param {Object?} context
    @param {Hash} options
    @return {String} HTML string
    @public
  */

  function renderMacro(path, params, hash, builder) {
    if (!params) {
      params = [];
    }
    var definitionArgs = [params.slice(0), hash, null, null];
    var args = [params.slice(1), hash, null, null];
    builder.component.dynamic(definitionArgs, makeComponentDefinition, args, builder.symbolTable);
    return true;
  }

  var AbstractRenderManager = (function (_AbstractManager) {
    babelHelpers.inherits(AbstractRenderManager, _AbstractManager);

    function AbstractRenderManager() {
      babelHelpers.classCallCheck(this, AbstractRenderManager);

      _AbstractManager.apply(this, arguments);
    }

    AbstractRenderManager.prototype.prepareArgs = function prepareArgs(definition, args) {
      return args;
    };

    /* abstract create(environment, definition, args, dynamicScope); */

    AbstractRenderManager.prototype.layoutFor = function layoutFor(definition, bucket, env) {
      return env.getCompiledBlock(_emberGlimmerSyntaxOutlet.OutletLayoutCompiler, definition.template);
    };

    AbstractRenderManager.prototype.getSelf = function getSelf(_ref) {
      var controller = _ref.controller;

      return new _emberGlimmerUtilsReferences.RootReference(controller);
    };

    AbstractRenderManager.prototype.getTag = function getTag() {
      return null;
    };

    AbstractRenderManager.prototype.getDestructor = function getDestructor() {
      return null;
    };

    AbstractRenderManager.prototype.didCreateElement = function didCreateElement() {};

    AbstractRenderManager.prototype.didRenderLayout = function didRenderLayout() {};

    AbstractRenderManager.prototype.didCreate = function didCreate() {};

    AbstractRenderManager.prototype.update = function update() {};

    AbstractRenderManager.prototype.didUpdateLayout = function didUpdateLayout() {};

    AbstractRenderManager.prototype.didUpdate = function didUpdate() {};

    return AbstractRenderManager;
  })(_emberGlimmerSyntaxAbstractManager.default);

  _emberDebug.runInDebug(function () {
    AbstractRenderManager.prototype.didRenderLayout = function () {
      this.debugStack.pop();
    };
  });

  var SingletonRenderManager = (function (_AbstractRenderManager) {
    babelHelpers.inherits(SingletonRenderManager, _AbstractRenderManager);

    function SingletonRenderManager() {
      babelHelpers.classCallCheck(this, SingletonRenderManager);

      _AbstractRenderManager.apply(this, arguments);
    }

    SingletonRenderManager.prototype.create = function create(environment, definition, args, dynamicScope) {
      var _this = this;

      var name = definition.name;
      var env = definition.env;

      var controller = env.owner.lookup('controller:' + name) || _emberRouting.generateController(env.owner, name);

      _emberDebug.runInDebug(function () {
        return _this._pushToDebugStack('controller:' + name + ' (with the render helper)', environment);
      });

      if (dynamicScope.rootOutletState) {
        dynamicScope.outletState = dynamicScope.rootOutletState.getOrphan(name);
      }

      return { controller: controller };
    };

    return SingletonRenderManager;
  })(AbstractRenderManager);

  var SINGLETON_RENDER_MANAGER = new SingletonRenderManager();

  var NonSingletonRenderManager = (function (_AbstractRenderManager2) {
    babelHelpers.inherits(NonSingletonRenderManager, _AbstractRenderManager2);

    function NonSingletonRenderManager() {
      babelHelpers.classCallCheck(this, NonSingletonRenderManager);

      _AbstractRenderManager2.apply(this, arguments);
    }

    NonSingletonRenderManager.prototype.create = function create(environment, definition, args, dynamicScope) {
      var _this2 = this;

      var name = definition.name;
      var env = definition.env;

      var modelRef = args.positional.at(0);
      var controllerFactory = env.owner[_container.FACTORY_FOR]('controller:' + name);

      var factory = controllerFactory || _emberRouting.generateControllerFactory(env.owner, name);
      var controller = factory.create({ model: modelRef.value() });

      _emberDebug.runInDebug(function () {
        return _this2._pushToDebugStack('controller:' + name + ' (with the render helper)', environment);
      });

      if (dynamicScope.rootOutletState) {
        dynamicScope.outletState = dynamicScope.rootOutletState.getOrphan(name);
      }

      return { controller: controller };
    };

    NonSingletonRenderManager.prototype.update = function update(_ref2, args, dynamicScope) {
      var controller = _ref2.controller;

      controller.set('model', args.positional.at(0).value());
    };

    NonSingletonRenderManager.prototype.getDestructor = function getDestructor(_ref3) {
      var controller = _ref3.controller;

      return controller;
    };

    return NonSingletonRenderManager;
  })(AbstractRenderManager);

  var NON_SINGLETON_RENDER_MANAGER = new NonSingletonRenderManager();

  var RenderDefinition = (function (_ComponentDefinition) {
    babelHelpers.inherits(RenderDefinition, _ComponentDefinition);

    function RenderDefinition(name, template, env, manager) {
      babelHelpers.classCallCheck(this, RenderDefinition);

      _ComponentDefinition.call(this, 'render', manager, null);

      this.name = name;
      this.template = template;
      this.env = env;
    }

    return RenderDefinition;
  })(_glimmerRuntime.ComponentDefinition);
});
enifed('ember-glimmer/template', ['exports', 'ember-utils', '@glimmer/runtime'], function (exports, _emberUtils, _glimmerRuntime) {
  'use strict';

  exports.default = template;

  function template(json) {
    var factory = _glimmerRuntime.templateFactory(json);

    return {
      id: factory.id,
      meta: factory.meta,
      create: function (props) {
        return factory.create(props.env, { owner: props[_emberUtils.OWNER] });
      }
    };
  }
});
enifed("ember-glimmer/template_registry", ["exports"], function (exports) {
  // STATE within a module is frowned apon, this exists
  // to support Ember.TEMPLATES but shield ember internals from this legacy
  // global API.
  "use strict";

  exports.setTemplates = setTemplates;
  exports.getTemplates = getTemplates;
  exports.getTemplate = getTemplate;
  exports.hasTemplate = hasTemplate;
  exports.setTemplate = setTemplate;
  var TEMPLATES = {};

  function setTemplates(templates) {
    TEMPLATES = templates;
  }

  function getTemplates() {
    return TEMPLATES;
  }

  function getTemplate(name) {
    if (TEMPLATES.hasOwnProperty(name)) {
      return TEMPLATES[name];
    }
  }

  function hasTemplate(name) {
    return TEMPLATES.hasOwnProperty(name);
  }

  function setTemplate(name, template) {
    return TEMPLATES[name] = template;
  }
});
enifed("ember-glimmer/templates/component", ["exports", "ember-glimmer/template"], function (exports, _emberGlimmerTemplate) {
  "use strict";

  exports.default = _emberGlimmerTemplate.default({ "id": "n+3mKSnB", "block": "{\"statements\":[[18,\"default\"]],\"locals\":[],\"named\":[],\"yields\":[\"default\"],\"hasPartials\":false}", "meta": { "moduleName": "ember-glimmer/templates/component.hbs" } });
});
enifed("ember-glimmer/templates/empty", ["exports", "ember-glimmer/template"], function (exports, _emberGlimmerTemplate) {
  "use strict";

  exports.default = _emberGlimmerTemplate.default({ "id": "5QJJjniM", "block": "{\"statements\":[],\"locals\":[],\"named\":[],\"yields\":[],\"hasPartials\":false}", "meta": { "moduleName": "ember-glimmer/templates/empty.hbs" } });
});
enifed("ember-glimmer/templates/link-to", ["exports", "ember-glimmer/template"], function (exports, _emberGlimmerTemplate) {
  "use strict";

  exports.default = _emberGlimmerTemplate.default({ "id": "YUwHICAk", "block": "{\"statements\":[[6,[\"if\"],[[28,[\"linkTitle\"]]],null,{\"statements\":[[1,[26,[\"linkTitle\"]],false]],\"locals\":[]},{\"statements\":[[18,\"default\"]],\"locals\":[]}]],\"locals\":[],\"named\":[],\"yields\":[\"default\"],\"hasPartials\":false}", "meta": { "moduleName": "ember-glimmer/templates/link-to.hbs" } });
});
enifed("ember-glimmer/templates/outlet", ["exports", "ember-glimmer/template"], function (exports, _emberGlimmerTemplate) {
  "use strict";

  exports.default = _emberGlimmerTemplate.default({ "id": "bVP1WVLR", "block": "{\"statements\":[[1,[26,[\"outlet\"]],false]],\"locals\":[],\"named\":[],\"yields\":[],\"hasPartials\":false}", "meta": { "moduleName": "ember-glimmer/templates/outlet.hbs" } });
});
enifed("ember-glimmer/templates/root", ["exports", "ember-glimmer/template"], function (exports, _emberGlimmerTemplate) {
  "use strict";

  exports.default = _emberGlimmerTemplate.default({ "id": "Cjk2vS10", "block": "{\"statements\":[[1,[33,[\"component\"],[[28,[null]]],null],false]],\"locals\":[],\"named\":[],\"yields\":[],\"hasPartials\":false}", "meta": { "moduleName": "ember-glimmer/templates/root.hbs" } });
});
enifed('ember-glimmer/utils/bindings', ['exports', '@glimmer/reference', '@glimmer/wire-format', 'ember-debug', 'ember-metal', 'ember-runtime', 'ember-glimmer/component', 'ember-glimmer/utils/string'], function (exports, _glimmerReference, _glimmerWireFormat, _emberDebug, _emberMetal, _emberRuntime, _emberGlimmerComponent, _emberGlimmerUtilsString) {
  'use strict';

  exports.wrapComponentClassAttribute = wrapComponentClassAttribute;

  function referenceForKey(component, key) {
    return component[_emberGlimmerComponent.ROOT_REF].get(key);
  }

  function referenceForParts(component, parts) {
    var isAttrs = parts[0] === 'attrs';

    // TODO deprecate this
    if (isAttrs) {
      parts.shift();

      if (parts.length === 1) {
        return referenceForKey(component, parts[0]);
      }
    }

    return _glimmerReference.referenceFromParts(component[_emberGlimmerComponent.ROOT_REF], parts);
  }

  // TODO we should probably do this transform at build time

  function wrapComponentClassAttribute(hash) {
    if (!hash) {
      return hash;
    }

    var keys = hash[0];
    var values = hash[1];

    var index = keys.indexOf('class');

    if (index !== -1) {
      var _values$index = values[index];
      var type = _values$index[0];

      if (type === _glimmerWireFormat.Ops.Get) {
        var getExp = values[index];
        var path = getExp[1];
        var propName = path[path.length - 1];
        hash[1][index] = [_glimmerWireFormat.Ops.Helper, ['-class'], [getExp, propName]];
      }
    }

    return hash;
  }

  var AttributeBinding = {
    parse: function (microsyntax) {
      var colonIndex = microsyntax.indexOf(':');

      if (colonIndex === -1) {
        _emberDebug.assert('You cannot use class as an attributeBinding, use classNameBindings instead.', microsyntax !== 'class');
        return [microsyntax, microsyntax, true];
      } else {
        var prop = microsyntax.substring(0, colonIndex);
        var attribute = microsyntax.substring(colonIndex + 1);

        _emberDebug.assert('You cannot use class as an attributeBinding, use classNameBindings instead.', attribute !== 'class');

        return [prop, attribute, false];
      }
    },

    install: function (element, component, parsed, operations) {
      var prop = parsed[0];
      var attribute = parsed[1];
      var isSimple = parsed[2];

      if (attribute === 'id') {
        var elementId = _emberMetal.get(component, prop);
        if (elementId === undefined || elementId === null) {
          elementId = component.elementId;
        }
        operations.addStaticAttribute(element, 'id', elementId);
        return;
      }

      var isPath = prop.indexOf('.') > -1;
      var reference = isPath ? referenceForParts(component, prop.split('.')) : referenceForKey(component, prop);

      _emberDebug.assert('Illegal attributeBinding: \'' + prop + '\' is not a valid attribute name.', !(isSimple && isPath));

      if (attribute === 'style') {
        reference = new StyleBindingReference(reference, referenceForKey(component, 'isVisible'));
      }

      operations.addDynamicAttribute(element, attribute, reference);
    }
  };

  exports.AttributeBinding = AttributeBinding;
  var DISPLAY_NONE = 'display: none;';
  var SAFE_DISPLAY_NONE = _emberGlimmerUtilsString.htmlSafe(DISPLAY_NONE);

  var StyleBindingReference = (function (_CachedReference) {
    babelHelpers.inherits(StyleBindingReference, _CachedReference);

    function StyleBindingReference(inner, isVisible) {
      babelHelpers.classCallCheck(this, StyleBindingReference);

      _CachedReference.call(this);

      this.tag = _glimmerReference.combine([inner.tag, isVisible.tag]);
      this.inner = inner;
      this.isVisible = isVisible;
    }

    StyleBindingReference.prototype.compute = function compute() {
      var value = this.inner.value();
      var isVisible = this.isVisible.value();

      if (isVisible !== false) {
        return value;
      } else if (!value && value !== 0) {
        return SAFE_DISPLAY_NONE;
      } else {
        var style = value + ' ' + DISPLAY_NONE;
        return _emberGlimmerUtilsString.isHTMLSafe(value) ? _emberGlimmerUtilsString.htmlSafe(style) : style;
      }
    };

    return StyleBindingReference;
  })(_glimmerReference.CachedReference);

  var IsVisibleBinding = {
    install: function (element, component, operations) {
      operations.addDynamicAttribute(element, 'style', _glimmerReference.map(referenceForKey(component, 'isVisible'), this.mapStyleValue));
    },

    mapStyleValue: function (isVisible) {
      return isVisible === false ? SAFE_DISPLAY_NONE : null;
    }
  };

  exports.IsVisibleBinding = IsVisibleBinding;
  var ClassNameBinding = {
    install: function (element, component, microsyntax, operations) {
      var _microsyntax$split = microsyntax.split(':');

      var prop = _microsyntax$split[0];
      var truthy = _microsyntax$split[1];
      var falsy = _microsyntax$split[2];

      var isStatic = prop === '';

      if (isStatic) {
        operations.addStaticAttribute(element, 'class', truthy);
      } else {
        var isPath = prop.indexOf('.') > -1;
        var parts = isPath && prop.split('.');
        var value = isPath ? referenceForParts(component, parts) : referenceForKey(component, prop);
        var ref = undefined;

        if (truthy === undefined) {
          ref = new SimpleClassNameBindingReference(value, isPath ? parts[parts.length - 1] : prop);
        } else {
          ref = new ColonClassNameBindingReference(value, truthy, falsy);
        }

        operations.addDynamicAttribute(element, 'class', ref);
      }
    }
  };

  exports.ClassNameBinding = ClassNameBinding;

  var SimpleClassNameBindingReference = (function (_CachedReference2) {
    babelHelpers.inherits(SimpleClassNameBindingReference, _CachedReference2);

    function SimpleClassNameBindingReference(inner, path) {
      babelHelpers.classCallCheck(this, SimpleClassNameBindingReference);

      _CachedReference2.call(this);

      this.tag = inner.tag;
      this.inner = inner;
      this.path = path;
      this.dasherizedPath = null;
    }

    SimpleClassNameBindingReference.prototype.compute = function compute() {
      var value = this.inner.value();

      if (value === true) {
        var path = this.path;
        var dasherizedPath = this.dasherizedPath;

        return dasherizedPath || (this.dasherizedPath = _emberRuntime.String.dasherize(path));
      } else if (value || value === 0) {
        return value;
      } else {
        return null;
      }
    };

    return SimpleClassNameBindingReference;
  })(_glimmerReference.CachedReference);

  var ColonClassNameBindingReference = (function (_CachedReference3) {
    babelHelpers.inherits(ColonClassNameBindingReference, _CachedReference3);

    function ColonClassNameBindingReference(inner, truthy, falsy) {
      babelHelpers.classCallCheck(this, ColonClassNameBindingReference);

      _CachedReference3.call(this);

      this.tag = inner.tag;
      this.inner = inner;
      this.truthy = truthy || null;
      this.falsy = falsy || null;
    }

    ColonClassNameBindingReference.prototype.compute = function compute() {
      var inner = this.inner;
      var truthy = this.truthy;
      var falsy = this.falsy;

      return inner.value() ? truthy : falsy;
    };

    return ColonClassNameBindingReference;
  })(_glimmerReference.CachedReference);
});
enifed('ember-glimmer/utils/debug-stack', ['exports', 'ember-debug'], function (exports, _emberDebug) {
  'use strict';

  var DebugStack = undefined;

  _emberDebug.runInDebug(function () {
    var Element = function Element(name) {
      babelHelpers.classCallCheck(this, Element);

      this.name = name;
    };

    var TemplateElement = (function (_Element) {
      babelHelpers.inherits(TemplateElement, _Element);

      function TemplateElement() {
        babelHelpers.classCallCheck(this, TemplateElement);

        _Element.apply(this, arguments);
      }

      return TemplateElement;
    })(Element);

    var EngineElement = (function (_Element2) {
      babelHelpers.inherits(EngineElement, _Element2);

      function EngineElement() {
        babelHelpers.classCallCheck(this, EngineElement);

        _Element2.apply(this, arguments);
      }

      return EngineElement;
    })(Element);

    DebugStack = (function () {
      function DebugStack() {
        babelHelpers.classCallCheck(this, DebugStack);

        this._stack = [];
      }

      DebugStack.prototype.push = function push(name) {
        this._stack.push(new TemplateElement(name));
      };

      DebugStack.prototype.pushEngine = function pushEngine(name) {
        this._stack.push(new EngineElement(name));
      };

      DebugStack.prototype.pop = function pop() {
        var element = this._stack.pop();

        if (element) {
          return element.name;
        }
      };

      DebugStack.prototype.peek = function peek() {
        var template = this._currentTemplate();
        var engine = this._currentEngine();

        if (engine) {
          return '"' + template + '" (in "' + engine + '")';
        } else if (template) {
          return '"' + template + '"';
        }
      };

      DebugStack.prototype._currentTemplate = function _currentTemplate() {
        return this._getCurrentByType(TemplateElement);
      };

      DebugStack.prototype._currentEngine = function _currentEngine() {
        return this._getCurrentByType(EngineElement);
      };

      DebugStack.prototype._getCurrentByType = function _getCurrentByType(type) {
        for (var i = this._stack.length; i >= 0; i--) {
          var element = this._stack[i];
          if (element instanceof type) {
            return element.name;
          }
        }
      };

      return DebugStack;
    })();
  });

  exports.default = DebugStack;
});
enifed('ember-glimmer/utils/iterable', ['exports', 'ember-utils', 'ember-metal', 'ember-runtime', 'ember-glimmer/utils/references', 'ember-glimmer/helpers/each-in', '@glimmer/reference'], function (exports, _emberUtils, _emberMetal, _emberRuntime, _emberGlimmerUtilsReferences, _emberGlimmerHelpersEachIn, _glimmerReference) {
  'use strict';

  exports.default = iterableFor;

  var ITERATOR_KEY_GUID = 'be277757-bbbe-4620-9fcb-213ef433cca2';

  function iterableFor(ref, keyPath) {
    if (_emberGlimmerHelpersEachIn.isEachIn(ref)) {
      return new EachInIterable(ref, keyForEachIn(keyPath));
    } else {
      return new ArrayIterable(ref, keyForArray(keyPath));
    }
  }

  function keyForEachIn(keyPath) {
    switch (keyPath) {
      case '@index':
      case undefined:
      case null:
        return index;
      case '@identity':
        return identity;
      default:
        return function (item) {
          return _emberMetal.get(item, keyPath);
        };
    }
  }

  function keyForArray(keyPath) {
    switch (keyPath) {
      case '@index':
        return index;
      case '@identity':
      case undefined:
      case null:
        return identity;
      default:
        return function (item) {
          return _emberMetal.get(item, keyPath);
        };
    }
  }

  function index(item, index) {
    return String(index);
  }

  function identity(item) {
    switch (typeof item) {
      case 'string':
      case 'number':
        return String(item);
      default:
        return _emberUtils.guidFor(item);
    }
  }

  function ensureUniqueKey(seen, key) {
    var seenCount = seen[key];

    if (seenCount) {
      seen[key]++;
      return '' + key + ITERATOR_KEY_GUID + seenCount;
    } else {
      seen[key] = 1;
    }

    return key;
  }

  var ArrayIterator = (function () {
    function ArrayIterator(array, keyFor) {
      babelHelpers.classCallCheck(this, ArrayIterator);

      this.array = array;
      this.length = array.length;
      this.keyFor = keyFor;
      this.position = 0;
      this.seen = Object.create(null);
    }

    ArrayIterator.prototype.isEmpty = function isEmpty() {
      return false;
    };

    ArrayIterator.prototype.next = function next() {
      var array = this.array;
      var length = this.length;
      var keyFor = this.keyFor;
      var position = this.position;
      var seen = this.seen;

      if (position >= length) {
        return null;
      }

      var value = array[position];
      var memo = position;
      var key = ensureUniqueKey(seen, keyFor(value, memo));

      this.position++;

      return { key: key, value: value, memo: memo };
    };

    return ArrayIterator;
  })();

  var EmberArrayIterator = (function () {
    function EmberArrayIterator(array, keyFor) {
      babelHelpers.classCallCheck(this, EmberArrayIterator);

      this.array = array;
      this.length = _emberMetal.get(array, 'length');
      this.keyFor = keyFor;
      this.position = 0;
      this.seen = Object.create(null);
    }

    EmberArrayIterator.prototype.isEmpty = function isEmpty() {
      return this.length === 0;
    };

    EmberArrayIterator.prototype.next = function next() {
      var array = this.array;
      var length = this.length;
      var keyFor = this.keyFor;
      var position = this.position;
      var seen = this.seen;

      if (position >= length) {
        return null;
      }

      var value = _emberRuntime.objectAt(array, position);
      var memo = position;
      var key = ensureUniqueKey(seen, keyFor(value, memo));

      this.position++;

      return { key: key, value: value, memo: memo };
    };

    return EmberArrayIterator;
  })();

  var ObjectKeysIterator = (function () {
    function ObjectKeysIterator(keys, values, keyFor) {
      babelHelpers.classCallCheck(this, ObjectKeysIterator);

      this.keys = keys;
      this.values = values;
      this.keyFor = keyFor;
      this.position = 0;
      this.seen = Object.create(null);
    }

    ObjectKeysIterator.prototype.isEmpty = function isEmpty() {
      return this.keys.length === 0;
    };

    ObjectKeysIterator.prototype.next = function next() {
      var keys = this.keys;
      var values = this.values;
      var keyFor = this.keyFor;
      var position = this.position;
      var seen = this.seen;

      if (position >= keys.length) {
        return null;
      }

      var value = values[position];
      var memo = keys[position];
      var key = ensureUniqueKey(seen, keyFor(value, memo));

      this.position++;

      return { key: key, value: value, memo: memo };
    };

    return ObjectKeysIterator;
  })();

  var EmptyIterator = (function () {
    function EmptyIterator() {
      babelHelpers.classCallCheck(this, EmptyIterator);
    }

    EmptyIterator.prototype.isEmpty = function isEmpty() {
      return true;
    };

    EmptyIterator.prototype.next = function next() {
      throw new Error('Cannot call next() on an empty iterator');
    };

    return EmptyIterator;
  })();

  var EMPTY_ITERATOR = new EmptyIterator();

  var EachInIterable = (function () {
    function EachInIterable(ref, keyFor) {
      babelHelpers.classCallCheck(this, EachInIterable);

      this.ref = ref;
      this.keyFor = keyFor;

      var valueTag = this.valueTag = new _glimmerReference.UpdatableTag(_glimmerReference.CONSTANT_TAG);

      this.tag = _glimmerReference.combine([ref.tag, valueTag]);
    }

    EachInIterable.prototype.iterate = function iterate() {
      var ref = this.ref;
      var keyFor = this.keyFor;
      var valueTag = this.valueTag;

      var iterable = ref.value();

      valueTag.update(_emberMetal.tagFor(iterable));

      if (_emberMetal.isProxy(iterable)) {
        iterable = _emberMetal.get(iterable, 'content');
      }

      var typeofIterable = typeof iterable;

      if (iterable && (typeofIterable === 'object' || typeofIterable === 'function')) {
        var keys = Object.keys(iterable);
        var values = keys.map(function (key) {
          return iterable[key];
        });
        return keys.length > 0 ? new ObjectKeysIterator(keys, values, keyFor) : EMPTY_ITERATOR;
      } else {
        return EMPTY_ITERATOR;
      }
    };

    // {{each-in}} yields |key value| instead of |value key|, so the memo and
    // value are flipped

    EachInIterable.prototype.valueReferenceFor = function valueReferenceFor(item) {
      return new _emberGlimmerUtilsReferences.UpdatablePrimitiveReference(item.memo);
    };

    EachInIterable.prototype.updateValueReference = function updateValueReference(reference, item) {
      reference.update(item.memo);
    };

    EachInIterable.prototype.memoReferenceFor = function memoReferenceFor(item) {
      return new _emberGlimmerUtilsReferences.UpdatableReference(item.value);
    };

    EachInIterable.prototype.updateMemoReference = function updateMemoReference(reference, item) {
      reference.update(item.value);
    };

    return EachInIterable;
  })();

  var ArrayIterable = (function () {
    function ArrayIterable(ref, keyFor) {
      babelHelpers.classCallCheck(this, ArrayIterable);

      this.ref = ref;
      this.keyFor = keyFor;

      var valueTag = this.valueTag = new _glimmerReference.UpdatableTag(_glimmerReference.CONSTANT_TAG);

      this.tag = _glimmerReference.combine([ref.tag, valueTag]);
    }

    ArrayIterable.prototype.iterate = function iterate() {
      var ref = this.ref;
      var keyFor = this.keyFor;
      var valueTag = this.valueTag;

      var iterable = ref.value();

      valueTag.update(_emberMetal.tagForProperty(iterable, '[]'));

      if (!iterable || typeof iterable !== 'object') {
        return EMPTY_ITERATOR;
      }

      if (Array.isArray(iterable)) {
        return iterable.length > 0 ? new ArrayIterator(iterable, keyFor) : EMPTY_ITERATOR;
      } else if (_emberRuntime.isEmberArray(iterable)) {
        return _emberMetal.get(iterable, 'length') > 0 ? new EmberArrayIterator(iterable, keyFor) : EMPTY_ITERATOR;
      } else if (typeof iterable.forEach === 'function') {
        var _ret = (function () {
          var array = [];
          iterable.forEach(function (item) {
            array.push(item);
          });
          return {
            v: array.length > 0 ? new ArrayIterator(array, keyFor) : EMPTY_ITERATOR
          };
        })();

        if (typeof _ret === 'object') return _ret.v;
      } else {
        return EMPTY_ITERATOR;
      }
    };

    ArrayIterable.prototype.valueReferenceFor = function valueReferenceFor(item) {
      return new _emberGlimmerUtilsReferences.UpdatableReference(item.value);
    };

    ArrayIterable.prototype.updateValueReference = function updateValueReference(reference, item) {
      reference.update(item.value);
    };

    ArrayIterable.prototype.memoReferenceFor = function memoReferenceFor(item) {
      return new _emberGlimmerUtilsReferences.UpdatablePrimitiveReference(item.memo);
    };

    ArrayIterable.prototype.updateMemoReference = function updateMemoReference(reference, item) {
      reference.update(item.memo);
    };

    return ArrayIterable;
  })();
});
enifed('ember-glimmer/utils/process-args', ['exports', 'ember-utils', '@glimmer/reference', 'ember-glimmer/component', 'ember-glimmer/utils/references', 'ember-views', 'ember-glimmer/helpers/action', '@glimmer/runtime'], function (exports, _emberUtils, _glimmerReference, _emberGlimmerComponent, _emberGlimmerUtilsReferences, _emberViews, _emberGlimmerHelpersAction, _glimmerRuntime) {
  'use strict';

  exports.gatherArgs = gatherArgs;

  // Maps all variants of positional and dynamically scoped arguments
  // into the named arguments. Input `args` and return value are both
  // `EvaluatedArgs`.

  function gatherArgs(args, definition) {
    var namedMap = gatherNamedMap(args, definition);
    var positionalValues = gatherPositionalValues(args, definition);
    return mergeArgs(namedMap, positionalValues, args.blocks, definition.ComponentClass.class);
  }

  function gatherNamedMap(args, definition) {
    var namedMap = args.named.map;
    if (definition.args) {
      return _emberUtils.assign({}, definition.args.named.map, namedMap);
    } else {
      return namedMap;
    }
  }

  function gatherPositionalValues(args, definition) {
    var positionalValues = args.positional.values;
    if (definition.args) {
      var oldPositional = definition.args.positional.values;
      var newPositional = [];
      newPositional.push.apply(newPositional, oldPositional);
      newPositional.splice.apply(newPositional, [0, positionalValues.length].concat(positionalValues));
      return newPositional;
    } else {
      return positionalValues;
    }
  }

  function mergeArgs(namedMap, positionalValues, blocks, componentClass) {
    var positionalParamsDefinition = componentClass.positionalParams;

    if (positionalParamsDefinition && positionalParamsDefinition.length > 0 && positionalValues.length > 0) {
      if (typeof positionalParamsDefinition === 'string') {
        namedMap = mergeRestArg(namedMap, positionalValues, positionalParamsDefinition);
      } else {
        namedMap = mergePositionalParams(namedMap, positionalValues, positionalParamsDefinition);
      }
    }
    return _glimmerRuntime.EvaluatedArgs.named(namedMap, blocks);
  }

  var EMPTY_ARGS = {
    tag: _glimmerReference.CONSTANT_TAG,
    value: function () {
      var _props;

      return { attrs: {}, props: (_props = { attrs: {} }, _props[_emberGlimmerComponent.ARGS] = {}, _props) };
    }
  };

  // ComponentArgs takes EvaluatedNamedArgs and converts them into the
  // inputs needed by CurlyComponents (attrs and props, with mutable
  // cells, etc).

  var ComponentArgs = (function () {
    ComponentArgs.create = function create(args) {
      if (args.named.keys.length === 0) {
        return EMPTY_ARGS;
      } else {
        return new ComponentArgs(args.named);
      }
    };

    function ComponentArgs(namedArgs) {
      babelHelpers.classCallCheck(this, ComponentArgs);

      this.tag = namedArgs.tag;
      this.namedArgs = namedArgs;
    }

    ComponentArgs.prototype.value = function value() {
      var namedArgs = this.namedArgs;

      var keys = namedArgs.keys;
      var attrs = namedArgs.value();
      var props = Object.create(null);
      var args = Object.create(null);

      props[_emberGlimmerComponent.ARGS] = args;

      for (var i = 0, l = keys.length; i < l; i++) {
        var _name = keys[i];
        var ref = namedArgs.get(_name);
        var value = attrs[_name];

        if (typeof value === 'function' && value[_emberGlimmerHelpersAction.ACTION]) {
          attrs[_name] = value;
        } else if (ref[_emberGlimmerUtilsReferences.UPDATE]) {
          attrs[_name] = new MutableCell(ref, value);
        }

        args[_name] = ref;
        props[_name] = value;
      }

      props.attrs = attrs;

      return { attrs: attrs, props: props };
    };

    return ComponentArgs;
  })();

  exports.ComponentArgs = ComponentArgs;

  function mergeRestArg(namedMap, positionalValues, restArgName) {
    var mergedNamed = _emberUtils.assign({}, namedMap);
    mergedNamed[restArgName] = _glimmerRuntime.EvaluatedPositionalArgs.create(positionalValues);
    return mergedNamed;
  }

  function mergePositionalParams(namedMap, values, positionalParamNames) {
    var mergedNamed = _emberUtils.assign({}, namedMap);
    var length = Math.min(values.length, positionalParamNames.length);
    for (var i = 0; i < length; i++) {
      var _name2 = positionalParamNames[i];
      mergedNamed[_name2] = values[i];
    }
    return mergedNamed;
  }

  var REF = _emberUtils.symbol('REF');

  var MutableCell = (function () {
    function MutableCell(ref, value) {
      babelHelpers.classCallCheck(this, MutableCell);

      this[_emberViews.MUTABLE_CELL] = true;
      this[REF] = ref;
      this.value = value;
    }

    MutableCell.prototype.update = function update(val) {
      this[REF][_emberGlimmerUtilsReferences.UPDATE](val);
    };

    return MutableCell;
  })();
});
enifed('ember-glimmer/utils/references', ['exports', 'ember-utils', 'ember-metal', '@glimmer/reference', '@glimmer/runtime', 'ember-glimmer/utils/to-bool', 'ember-glimmer/helper', 'ember-debug'], function (exports, _emberUtils, _emberMetal, _glimmerReference, _glimmerRuntime, _emberGlimmerUtilsToBool, _emberGlimmerHelper, _emberDebug) {
  'use strict';

  var UPDATE = _emberUtils.symbol('UPDATE');

  exports.UPDATE = UPDATE;
  exports.NULL_REFERENCE = _glimmerRuntime.NULL_REFERENCE;
  exports.UNDEFINED_REFERENCE = _glimmerRuntime.UNDEFINED_REFERENCE;

  // @abstract
  // @implements PathReference

  var EmberPathReference = (function () {
    function EmberPathReference() {
      babelHelpers.classCallCheck(this, EmberPathReference);
    }

    // @abstract

    // @abstract get tag()
    // @abstract value()

    EmberPathReference.prototype.get = function get(key) {
      return PropertyReference.create(this, key);
    };

    return EmberPathReference;
  })();

  var CachedReference = (function (_EmberPathReference) {
    babelHelpers.inherits(CachedReference, _EmberPathReference);

    function CachedReference() {
      babelHelpers.classCallCheck(this, CachedReference);

      _EmberPathReference.call(this);
      this._lastRevision = null;
      this._lastValue = null;
    }

    // @implements PathReference

    CachedReference.prototype.value = function value() {
      var tag = this.tag;
      var _lastRevision = this._lastRevision;
      var _lastValue = this._lastValue;

      if (!_lastRevision || !tag.validate(_lastRevision)) {
        _lastValue = this._lastValue = this.compute();
        this._lastRevision = tag.value();
      }

      return _lastValue;
    };

    // @abstract compute()
    return CachedReference;
  })(EmberPathReference);

  exports.CachedReference = CachedReference;

  var RootReference = (function (_ConstReference) {
    babelHelpers.inherits(RootReference, _ConstReference);

    function RootReference(value) {
      babelHelpers.classCallCheck(this, RootReference);

      _ConstReference.call(this, value);
      this.children = Object.create(null);
    }

    RootReference.prototype.get = function get(propertyKey) {
      var ref = this.children[propertyKey];

      if (!ref) {
        ref = this.children[propertyKey] = new RootPropertyReference(this.inner, propertyKey);
      }

      return ref;
    };

    return RootReference;
  })(_glimmerReference.ConstReference);

  exports.RootReference = RootReference;

  var TwoWayFlushDetectionTag = undefined;

  if (true || false) {
    TwoWayFlushDetectionTag = (function () {
      function _class(tag, key, ref) {
        babelHelpers.classCallCheck(this, _class);

        this.tag = tag;
        this.parent = null;
        this.key = key;
        this.ref = ref;
      }

      _class.prototype.value = function value() {
        return this.tag.value();
      };

      _class.prototype.validate = function validate(ticket) {
        var parent = this.parent;
        var key = this.key;

        var isValid = this.tag.validate(ticket);

        if (isValid && parent) {
          _emberMetal.didRender(parent, key, this.ref);
        }

        return isValid;
      };

      _class.prototype.didCompute = function didCompute(parent) {
        this.parent = parent;
        _emberMetal.didRender(parent, this.key, this.ref);
      };

      return _class;
    })();
  }

  var PropertyReference = (function (_CachedReference) {
    babelHelpers.inherits(PropertyReference, _CachedReference);

    function PropertyReference() {
      babelHelpers.classCallCheck(this, PropertyReference);

      _CachedReference.apply(this, arguments);
    }

    PropertyReference.create = function create(parentReference, propertyKey) {
      if (_glimmerReference.isConst(parentReference)) {
        return new RootPropertyReference(parentReference.value(), propertyKey);
      } else {
        return new NestedPropertyReference(parentReference, propertyKey);
      }
    };

    PropertyReference.prototype.get = function get(key) {
      return new NestedPropertyReference(this, key);
    };

    return PropertyReference;
  })(CachedReference);

  exports.PropertyReference = PropertyReference;

  var RootPropertyReference = (function (_PropertyReference) {
    babelHelpers.inherits(RootPropertyReference, _PropertyReference);

    function RootPropertyReference(parentValue, propertyKey) {
      babelHelpers.classCallCheck(this, RootPropertyReference);

      _PropertyReference.call(this);

      this._parentValue = parentValue;
      this._propertyKey = propertyKey;

      if (true || false) {
        this.tag = new TwoWayFlushDetectionTag(_emberMetal.tagForProperty(parentValue, propertyKey), propertyKey, this);
      } else {
        this.tag = _emberMetal.tagForProperty(parentValue, propertyKey);
      }

      if (true) {
        _emberMetal.watchKey(parentValue, propertyKey);
      }
    }

    RootPropertyReference.prototype.compute = function compute() {
      var _parentValue = this._parentValue;
      var _propertyKey = this._propertyKey;

      if (true || false) {
        this.tag.didCompute(_parentValue);
      }

      return _emberMetal.get(_parentValue, _propertyKey);
    };

    RootPropertyReference.prototype[UPDATE] = function (value) {
      _emberMetal.set(this._parentValue, this._propertyKey, value);
    };

    return RootPropertyReference;
  })(PropertyReference);

  exports.RootPropertyReference = RootPropertyReference;

  var NestedPropertyReference = (function (_PropertyReference2) {
    babelHelpers.inherits(NestedPropertyReference, _PropertyReference2);

    function NestedPropertyReference(parentReference, propertyKey) {
      babelHelpers.classCallCheck(this, NestedPropertyReference);

      _PropertyReference2.call(this);

      var parentReferenceTag = parentReference.tag;
      var parentObjectTag = new _glimmerReference.UpdatableTag(_glimmerReference.CONSTANT_TAG);

      this._parentReference = parentReference;
      this._parentObjectTag = parentObjectTag;
      this._propertyKey = propertyKey;

      if (true || false) {
        var tag = _glimmerReference.combine([parentReferenceTag, parentObjectTag]);
        this.tag = new TwoWayFlushDetectionTag(tag, propertyKey, this);
      } else {
        this.tag = _glimmerReference.combine([parentReferenceTag, parentObjectTag]);
      }
    }

    NestedPropertyReference.prototype.compute = function compute() {
      var _parentReference = this._parentReference;
      var _parentObjectTag = this._parentObjectTag;
      var _propertyKey = this._propertyKey;

      var parentValue = _parentReference.value();

      _parentObjectTag.update(_emberMetal.tagForProperty(parentValue, _propertyKey));

      if (typeof parentValue === 'string' && _propertyKey === 'length') {
        return parentValue.length;
      }

      if (typeof parentValue === 'object' && parentValue) {
        if (true) {
          _emberMetal.watchKey(parentValue, _propertyKey);
        }

        if (true || false) {
          this.tag.didCompute(parentValue);
        }

        return _emberMetal.get(parentValue, _propertyKey);
      } else {
        return undefined;
      }
    };

    NestedPropertyReference.prototype[UPDATE] = function (value) {
      var parent = this._parentReference.value();
      _emberMetal.set(parent, this._propertyKey, value);
    };

    return NestedPropertyReference;
  })(PropertyReference);

  exports.NestedPropertyReference = NestedPropertyReference;

  var UpdatableReference = (function (_EmberPathReference2) {
    babelHelpers.inherits(UpdatableReference, _EmberPathReference2);

    function UpdatableReference(value) {
      babelHelpers.classCallCheck(this, UpdatableReference);

      _EmberPathReference2.call(this);

      this.tag = new _glimmerReference.DirtyableTag();
      this._value = value;
    }

    UpdatableReference.prototype.value = function value() {
      return this._value;
    };

    UpdatableReference.prototype.update = function update(value) {
      var _value = this._value;

      if (value !== _value) {
        this.tag.dirty();
        this._value = value;
      }
    };

    return UpdatableReference;
  })(EmberPathReference);

  exports.UpdatableReference = UpdatableReference;

  var UpdatablePrimitiveReference = (function (_UpdatableReference) {
    babelHelpers.inherits(UpdatablePrimitiveReference, _UpdatableReference);

    function UpdatablePrimitiveReference() {
      babelHelpers.classCallCheck(this, UpdatablePrimitiveReference);

      _UpdatableReference.apply(this, arguments);
    }

    UpdatablePrimitiveReference.prototype.get = function get() {
      return _glimmerRuntime.UNDEFINED_REFERENCE;
    };

    return UpdatablePrimitiveReference;
  })(UpdatableReference);

  exports.UpdatablePrimitiveReference = UpdatablePrimitiveReference;

  var ConditionalReference = (function (_GlimmerConditionalReference) {
    babelHelpers.inherits(ConditionalReference, _GlimmerConditionalReference);

    ConditionalReference.create = function create(reference) {
      if (_glimmerReference.isConst(reference)) {
        var value = reference.value();

        if (_emberMetal.isProxy(value)) {
          return new RootPropertyReference(value, 'isTruthy');
        } else {
          return _glimmerRuntime.PrimitiveReference.create(_emberGlimmerUtilsToBool.default(value));
        }
      }

      return new ConditionalReference(reference);
    };

    function ConditionalReference(reference) {
      babelHelpers.classCallCheck(this, ConditionalReference);

      _GlimmerConditionalReference.call(this, reference);

      this.objectTag = new _glimmerReference.UpdatableTag(_glimmerReference.CONSTANT_TAG);
      this.tag = _glimmerReference.combine([reference.tag, this.objectTag]);
    }

    ConditionalReference.prototype.toBool = function toBool(predicate) {
      if (_emberMetal.isProxy(predicate)) {
        this.objectTag.update(_emberMetal.tagForProperty(predicate, 'isTruthy'));
        return _emberMetal.get(predicate, 'isTruthy');
      } else {
        this.objectTag.update(_emberMetal.tagFor(predicate));
        return _emberGlimmerUtilsToBool.default(predicate);
      }
    };

    return ConditionalReference;
  })(_glimmerRuntime.ConditionalReference);

  exports.ConditionalReference = ConditionalReference;

  var SimpleHelperReference = (function (_CachedReference2) {
    babelHelpers.inherits(SimpleHelperReference, _CachedReference2);

    SimpleHelperReference.create = function create(helper, args) {
      if (_glimmerReference.isConst(args)) {
        var _ret = (function () {
          var positional = args.positional;
          var named = args.named;

          var positionalValue = positional.value();
          var namedValue = named.value();

          _emberDebug.runInDebug(function () {
            if (_emberUtils.HAS_NATIVE_WEAKMAP) {
              Object.freeze(positionalValue);
              Object.freeze(namedValue);
            }
          });

          var result = helper(positionalValue, namedValue);

          if (result === null) {
            return {
              v: _glimmerRuntime.NULL_REFERENCE
            };
          } else if (result === undefined) {
            return {
              v: _glimmerRuntime.UNDEFINED_REFERENCE
            };
          } else if (typeof result === 'object') {
            return {
              v: new RootReference(result)
            };
          } else {
            return {
              v: _glimmerRuntime.PrimitiveReference.create(result)
            };
          }
        })();

        if (typeof _ret === 'object') return _ret.v;
      } else {
        return new SimpleHelperReference(helper, args);
      }
    };

    function SimpleHelperReference(helper, args) {
      babelHelpers.classCallCheck(this, SimpleHelperReference);

      _CachedReference2.call(this);

      this.tag = args.tag;
      this.helper = helper;
      this.args = args;
    }

    SimpleHelperReference.prototype.compute = function compute() {
      var helper = this.helper;
      var _args = this.args;
      var positional = _args.positional;
      var named = _args.named;

      var positionalValue = positional.value();
      var namedValue = named.value();

      _emberDebug.runInDebug(function () {
        if (_emberUtils.HAS_NATIVE_WEAKMAP) {
          Object.freeze(positionalValue);
          Object.freeze(namedValue);
        }
      });

      return helper(positionalValue, namedValue);
    };

    return SimpleHelperReference;
  })(CachedReference);

  exports.SimpleHelperReference = SimpleHelperReference;

  var ClassBasedHelperReference = (function (_CachedReference3) {
    babelHelpers.inherits(ClassBasedHelperReference, _CachedReference3);

    ClassBasedHelperReference.create = function create(helperClass, vm, args) {
      var instance = helperClass.create();
      vm.newDestroyable(instance);
      return new ClassBasedHelperReference(instance, args);
    };

    function ClassBasedHelperReference(instance, args) {
      babelHelpers.classCallCheck(this, ClassBasedHelperReference);

      _CachedReference3.call(this);

      this.tag = _glimmerReference.combine([instance[_emberGlimmerHelper.RECOMPUTE_TAG], args.tag]);
      this.instance = instance;
      this.args = args;
    }

    ClassBasedHelperReference.prototype.compute = function compute() {
      var instance = this.instance;
      var _args2 = this.args;
      var positional = _args2.positional;
      var named = _args2.named;

      var positionalValue = positional.value();
      var namedValue = named.value();

      _emberDebug.runInDebug(function () {
        if (_emberUtils.HAS_NATIVE_WEAKMAP) {
          Object.freeze(positionalValue);
          Object.freeze(namedValue);
        }
      });

      return instance.compute(positionalValue, namedValue);
    };

    return ClassBasedHelperReference;
  })(CachedReference);

  exports.ClassBasedHelperReference = ClassBasedHelperReference;

  var InternalHelperReference = (function (_CachedReference4) {
    babelHelpers.inherits(InternalHelperReference, _CachedReference4);

    function InternalHelperReference(helper, args) {
      babelHelpers.classCallCheck(this, InternalHelperReference);

      _CachedReference4.call(this);

      this.tag = args.tag;
      this.helper = helper;
      this.args = args;
    }

    // @implements PathReference

    InternalHelperReference.prototype.compute = function compute() {
      var helper = this.helper;
      var args = this.args;

      return helper(args);
    };

    return InternalHelperReference;
  })(CachedReference);

  exports.InternalHelperReference = InternalHelperReference;

  var UnboundReference = (function (_ConstReference2) {
    babelHelpers.inherits(UnboundReference, _ConstReference2);

    function UnboundReference() {
      babelHelpers.classCallCheck(this, UnboundReference);

      _ConstReference2.apply(this, arguments);
    }

    UnboundReference.create = function create(value) {
      if (value === null) {
        return _glimmerRuntime.NULL_REFERENCE;
      } else if (value === undefined) {
        return _glimmerRuntime.UNDEFINED_REFERENCE;
      } else if (typeof value === 'object') {
        return new UnboundReference(value);
      } else {
        return _glimmerRuntime.PrimitiveReference.create(value);
      }
    };

    UnboundReference.prototype.get = function get(key) {
      return new UnboundReference(_emberMetal.get(this.inner, key));
    };

    return UnboundReference;
  })(_glimmerReference.ConstReference);

  exports.UnboundReference = UnboundReference;
});
enifed('ember-glimmer/utils/string', ['exports', 'ember-debug'], function (exports, _emberDebug) {
  /**
  @module ember
  @submodule ember-glimmer
  */

  'use strict';

  exports.getSafeString = getSafeString;
  exports.escapeExpression = escapeExpression;
  exports.htmlSafe = htmlSafe;
  exports.isHTMLSafe = isHTMLSafe;

  var SafeString = (function () {
    function SafeString(string) {
      babelHelpers.classCallCheck(this, SafeString);

      this.string = string;
    }

    SafeString.prototype.toString = function toString() {
      return '' + this.string;
    };

    SafeString.prototype.toHTML = function toHTML() {
      return this.toString();
    };

    return SafeString;
  })();

  exports.SafeString = SafeString;

  function getSafeString() {
    _emberDebug.deprecate('Ember.Handlebars.SafeString is deprecated in favor of Ember.String.htmlSafe', false, {
      id: 'ember-htmlbars.ember-handlebars-safestring',
      until: '3.0.0',
      url: 'http://emberjs.com/deprecations/v2.x#toc_use-ember-string-htmlsafe-over-ember-handlebars-safestring'
    });

    return SafeString;
  }

  var escape = {
    '&': '&amp;',
    '<': '&lt;',
    '>': '&gt;',
    '"': '&quot;',
    // jscs:disable
    "'": '&#x27;',
    // jscs:enable
    '`': '&#x60;',
    '=': '&#x3D;'
  };

  var possible = /[&<>"'`=]/;
  var badChars = /[&<>"'`=]/g;

  function escapeChar(chr) {
    return escape[chr];
  }

  function escapeExpression(string) {
    if (typeof string !== 'string') {
      // don't escape SafeStrings, since they're already safe
      if (string && string.toHTML) {
        return string.toHTML();
      } else if (string == null) {
        return '';
      } else if (!string) {
        return string + '';
      }

      // Force a string conversion as this will be done by the append regardless and
      // the regex test will do this transparently behind the scenes, causing issues if
      // an object's to string has escaped characters in it.
      string = '' + string;
    }

    if (!possible.test(string)) {
      return string;
    }
    return string.replace(badChars, escapeChar);
  }

  /**
    Mark a string as safe for unescaped output with Ember templates. If you
    return HTML from a helper, use this function to
    ensure Ember's rendering layer does not escape the HTML.
  
    ```javascript
    Ember.String.htmlSafe('<div>someString</div>')
    ```
  
    @method htmlSafe
    @for Ember.String
    @static
    @return {Handlebars.SafeString} A string that will not be HTML escaped by Handlebars.
    @public
  */

  function htmlSafe(str) {
    if (str === null || str === undefined) {
      str = '';
    } else if (typeof str !== 'string') {
      str = '' + str;
    }
    return new SafeString(str);
  }

  /**
    Detects if a string was decorated using `Ember.String.htmlSafe`.
  
    ```javascript
    var plainString = 'plain string',
        safeString = Ember.String.htmlSafe('<div>someValue</div>');
  
    Ember.String.isHTMLSafe(plainString); // false
    Ember.String.isHTMLSafe(safeString);  // true
    ```
  
    @method isHTMLSafe
    @for Ember.String
    @static
    @return {Boolean} `true` if the string was decorated with `htmlSafe`, `false` otherwise.
    @public
  */

  function isHTMLSafe(str) {
    return str && typeof str.toHTML === 'function';
  }
});
enifed('ember-glimmer/utils/to-bool', ['exports', 'ember-runtime', 'ember-metal'], function (exports, _emberRuntime, _emberMetal) {
  'use strict';

  exports.default = toBool;

  function toBool(predicate) {
    if (!predicate) {
      return false;
    }

    if (predicate === true) {
      return true;
    }

    if (_emberRuntime.isArray(predicate)) {
      return _emberMetal.get(predicate, 'length') !== 0;
    }

    return true;
  }
});
enifed('ember-glimmer/views/outlet', ['exports', 'ember-utils', '@glimmer/reference', 'ember-environment', 'ember-metal'], function (exports, _emberUtils, _glimmerReference, _emberEnvironment, _emberMetal) {
  /**
  @module ember
  @submodule ember-glimmer
  */
  'use strict';

  var OutletStateReference = (function () {
    function OutletStateReference(outletView) {
      babelHelpers.classCallCheck(this, OutletStateReference);

      this.outletView = outletView;
      this.tag = outletView._tag;
    }

    // So this is a relic of the past that SHOULD go away
    // in 3.0. Preferably it is deprecated in the release that
    // follows the Glimmer release.

    OutletStateReference.prototype.get = function get(key) {
      return new ChildOutletStateReference(this, key);
    };

    OutletStateReference.prototype.value = function value() {
      return this.outletView.outletState;
    };

    OutletStateReference.prototype.getOrphan = function getOrphan(name) {
      return new OrphanedOutletStateReference(this, name);
    };

    OutletStateReference.prototype.update = function update(state) {
      this.outletView.setOutletState(state);
    };

    return OutletStateReference;
  })();

  var OrphanedOutletStateReference = (function (_OutletStateReference) {
    babelHelpers.inherits(OrphanedOutletStateReference, _OutletStateReference);

    function OrphanedOutletStateReference(root, name) {
      babelHelpers.classCallCheck(this, OrphanedOutletStateReference);

      _OutletStateReference.call(this, root.outletView);
      this.root = root;
      this.name = name;
    }

    OrphanedOutletStateReference.prototype.value = function value() {
      var rootState = this.root.value();

      var orphans = rootState.outlets.main.outlets.__ember_orphans__;

      if (!orphans) {
        return null;
      }

      var matched = orphans.outlets[this.name];

      if (!matched) {
        return null;
      }

      var state = Object.create(null);
      state[matched.render.outlet] = matched;
      matched.wasUsed = true;
      return { outlets: state };
    };

    return OrphanedOutletStateReference;
  })(OutletStateReference);

  var ChildOutletStateReference = (function () {
    function ChildOutletStateReference(parent, key) {
      babelHelpers.classCallCheck(this, ChildOutletStateReference);

      this.parent = parent;
      this.key = key;
      this.tag = parent.tag;
    }

    ChildOutletStateReference.prototype.get = function get(key) {
      return new ChildOutletStateReference(this, key);
    };

    ChildOutletStateReference.prototype.value = function value() {
      return this.parent.value()[this.key];
    };

    return ChildOutletStateReference;
  })();

  var OutletView = (function () {
    OutletView.extend = function extend(injections) {
      return (function (_OutletView) {
        babelHelpers.inherits(_class, _OutletView);

        function _class() {
          babelHelpers.classCallCheck(this, _class);

          _OutletView.apply(this, arguments);
        }

        _class.create = function create(options) {
          if (options) {
            return _OutletView.create.call(this, _emberUtils.assign({}, injections, options));
          } else {
            return _OutletView.create.call(this, injections);
          }
        };

        return _class;
      })(OutletView);
    };

    OutletView.reopenClass = function reopenClass(injections) {
      _emberUtils.assign(this, injections);
    };

    OutletView.create = function create(options) {
      var _environment = options._environment;
      var renderer = options.renderer;
      var template = options.template;

      var owner = options[_emberUtils.OWNER];
      return new OutletView(_environment, renderer, owner, template);
    };

    function OutletView(_environment, renderer, owner, template) {
      babelHelpers.classCallCheck(this, OutletView);

      this._environment = _environment;
      this.renderer = renderer;
      this.owner = owner;
      this.template = template;
      this.outletState = null;
      this._tag = new _glimmerReference.DirtyableTag();
    }

    OutletView.prototype.appendTo = function appendTo(selector) {
      var env = this._environment || _emberEnvironment.environment;
      var target = undefined;

      if (env.hasDOM) {
        target = typeof selector === 'string' ? document.querySelector(selector) : selector;
      } else {
        target = selector;
      }

      _emberMetal.run.schedule('render', this.renderer, 'appendOutletView', this, target);
    };

    OutletView.prototype.rerender = function rerender() {};

    OutletView.prototype.setOutletState = function setOutletState(state) {
      this.outletState = {
        outlets: {
          main: state
        },
        render: {
          owner: undefined,
          into: undefined,
          outlet: 'main',
          name: '-top-level',
          controller: undefined,
          ViewClass: undefined,
          template: undefined
        }
      };
      this._tag.dirty();
    };

    OutletView.prototype.toReference = function toReference() {
      return new OutletStateReference(this);
    };

    OutletView.prototype.destroy = function destroy() {};

    return OutletView;
  })();

  exports.default = OutletView;
});
enifed('ember-metal/alias', ['exports', 'ember-utils', 'ember-debug', 'ember-metal/property_get', 'ember-metal/property_set', 'ember-metal/properties', 'ember-metal/computed', 'ember-metal/meta', 'ember-metal/dependent_keys'], function (exports, _emberUtils, _emberDebug, _emberMetalProperty_get, _emberMetalProperty_set, _emberMetalProperties, _emberMetalComputed, _emberMetalMeta, _emberMetalDependent_keys) {
  'use strict';

  exports.default = alias;

  var CONSUMED = {};

  function alias(altKey) {
    return new AliasedProperty(altKey);
  }

  var AliasedProperty = (function (_Descriptor) {
    babelHelpers.inherits(AliasedProperty, _Descriptor);

    function AliasedProperty(altKey) {
      babelHelpers.classCallCheck(this, AliasedProperty);

      _Descriptor.call(this);
      this.isDescriptor = true;
      this.altKey = altKey;
      this._dependentKeys = [altKey];
    }

    AliasedProperty.prototype.setup = function setup(obj, keyName) {
      _emberDebug.assert('Setting alias \'' + keyName + '\' on self', this.altKey !== keyName);
      var meta = _emberMetalMeta.meta(obj);
      if (meta.peekWatching(keyName)) {
        _emberMetalDependent_keys.addDependentKeys(this, obj, keyName, meta);
      }
    };

    AliasedProperty.prototype.teardown = function teardown(obj, keyName) {
      var meta = _emberMetalMeta.meta(obj);
      if (meta.peekWatching(keyName)) {
        _emberMetalDependent_keys.removeDependentKeys(this, obj, keyName, meta);
      }
    };

    AliasedProperty.prototype.willWatch = function willWatch(obj, keyName) {
      _emberMetalDependent_keys.addDependentKeys(this, obj, keyName, _emberMetalMeta.meta(obj));
    };

    AliasedProperty.prototype.didUnwatch = function didUnwatch(obj, keyName) {
      _emberMetalDependent_keys.removeDependentKeys(this, obj, keyName, _emberMetalMeta.meta(obj));
    };

    AliasedProperty.prototype.get = function get(obj, keyName) {
      var ret = _emberMetalProperty_get.get(obj, this.altKey);
      var meta = _emberMetalMeta.meta(obj);
      var cache = meta.writableCache();
      if (cache[keyName] !== CONSUMED) {
        cache[keyName] = CONSUMED;
        _emberMetalDependent_keys.addDependentKeys(this, obj, keyName, meta);
      }
      return ret;
    };

    AliasedProperty.prototype.set = function set(obj, keyName, value) {
      return _emberMetalProperty_set.set(obj, this.altKey, value);
    };

    AliasedProperty.prototype.readOnly = function readOnly() {
      this.set = AliasedProperty_readOnlySet;
      return this;
    };

    AliasedProperty.prototype.oneWay = function oneWay() {
      this.set = AliasedProperty_oneWaySet;
      return this;
    };

    return AliasedProperty;
  })(_emberMetalProperties.Descriptor);

  exports.AliasedProperty = AliasedProperty;

  function AliasedProperty_readOnlySet(obj, keyName, value) {
    throw new _emberDebug.Error('Cannot set read-only property \'' + keyName + '\' on object: ' + _emberUtils.inspect(obj));
  }

  function AliasedProperty_oneWaySet(obj, keyName, value) {
    _emberMetalProperties.defineProperty(obj, keyName, null);
    return _emberMetalProperty_set.set(obj, keyName, value);
  }

  // Backwards compatibility with Ember Data.
  AliasedProperty.prototype._meta = undefined;
  AliasedProperty.prototype.meta = _emberMetalComputed.ComputedProperty.prototype.meta;
});
enifed('ember-metal/binding', ['exports', 'ember-utils', 'ember-console', 'ember-environment', 'ember-metal/run_loop', 'ember-debug', 'ember-metal/property_get', 'ember-metal/property_set', 'ember-metal/events', 'ember-metal/observer', 'ember-metal/path_cache'], function (exports, _emberUtils, _emberConsole, _emberEnvironment, _emberMetalRun_loop, _emberDebug, _emberMetalProperty_get, _emberMetalProperty_set, _emberMetalEvents, _emberMetalObserver, _emberMetalPath_cache) {
  'use strict';

  exports.bind = bind;

  /**
  @module ember
  @submodule ember-metal
  */

  // ..........................................................
  // BINDING
  //

  var Binding = (function () {
    function Binding(toPath, fromPath) {
      babelHelpers.classCallCheck(this, Binding);

      // Configuration
      this._from = fromPath;
      this._to = toPath;
      this._oneWay = undefined;

      // State
      this._direction = undefined;
      this._readyToSync = undefined;
      this._fromObj = undefined;
      this._fromPath = undefined;
      this._toObj = undefined;
    }

    /**
      @class Binding
      @namespace Ember
      @deprecated See http://emberjs.com/deprecations/v2.x#toc_ember-binding
      @public
    */

    /**
      This copies the Binding so it can be connected to another object.
       @method copy
      @return {Ember.Binding} `this`
      @public
    */

    Binding.prototype.copy = function copy() {
      var copy = new Binding(this._to, this._from);
      if (this._oneWay) {
        copy._oneWay = true;
      }
      return copy;
    };

    // ..........................................................
    // CONFIG
    //

    /**
      This will set `from` property path to the specified value. It will not
      attempt to resolve this property path to an actual object until you
      connect the binding.
       The binding will search for the property path starting at the root object
      you pass when you `connect()` the binding. It follows the same rules as
      `get()` - see that method for more information.
       @method from
      @param {String} path The property path to connect to.
      @return {Ember.Binding} `this`
      @public
    */

    Binding.prototype.from = function from(path) {
      this._from = path;
      return this;
    };

    /**
      This will set the `to` property path to the specified value. It will not
      attempt to resolve this property path to an actual object until you
      connect the binding.
       The binding will search for the property path starting at the root object
      you pass when you `connect()` the binding. It follows the same rules as
      `get()` - see that method for more information.
       @method to
      @param {String|Tuple} path A property path or tuple.
      @return {Ember.Binding} `this`
      @public
    */

    Binding.prototype.to = function to(path) {
      this._to = path;
      return this;
    };

    /**
      Configures the binding as one way. A one-way binding will relay changes
      on the `from` side to the `to` side, but not the other way around. This
      means that if you change the `to` side directly, the `from` side may have
      a different value.
       @method oneWay
      @return {Ember.Binding} `this`
      @public
    */

    Binding.prototype.oneWay = function oneWay() {
      this._oneWay = true;
      return this;
    };

    /**
      @method toString
      @return {String} string representation of binding
      @public
    */

    Binding.prototype.toString = function toString() {
      var oneWay = this._oneWay ? '[oneWay]' : '';
      return 'Ember.Binding<' + _emberUtils.guidFor(this) + '>(' + this._from + ' -> ' + this._to + ')' + oneWay;
    };

    // ..........................................................
    // CONNECT AND SYNC
    //

    /**
      Attempts to connect this binding instance so that it can receive and relay
      changes. This method will raise an exception if you have not set the
      from/to properties yet.
       @method connect
      @param {Object} obj The root object for this binding.
      @return {Ember.Binding} `this`
      @public
    */

    Binding.prototype.connect = function connect(obj) {
      _emberDebug.assert('Must pass a valid object to Ember.Binding.connect()', !!obj);

      var fromObj = undefined,
          fromPath = undefined,
          possibleGlobal = undefined;

      // If the binding's "from" path could be interpreted as a global, verify
      // whether the path refers to a global or not by consulting `Ember.lookup`.
      if (_emberMetalPath_cache.isGlobalPath(this._from)) {
        var _name = _emberMetalPath_cache.getFirstKey(this._from);
        possibleGlobal = _emberEnvironment.context.lookup[_name];

        if (possibleGlobal) {
          fromObj = possibleGlobal;
          fromPath = _emberMetalPath_cache.getTailPath(this._from);
        }
      }

      if (fromObj === undefined) {
        fromObj = obj;
        fromPath = this._from;
      }

      _emberMetalProperty_set.trySet(obj, this._to, _emberMetalProperty_get.get(fromObj, fromPath));

      // Add an observer on the object to be notified when the binding should be updated.
      _emberMetalObserver.addObserver(fromObj, fromPath, this, 'fromDidChange');

      // If the binding is a two-way binding, also set up an observer on the target.
      if (!this._oneWay) {
        _emberMetalObserver.addObserver(obj, this._to, this, 'toDidChange');
      }

      _emberMetalEvents.addListener(obj, 'willDestroy', this, 'disconnect');

      fireDeprecations(obj, this._to, this._from, possibleGlobal, this._oneWay, !possibleGlobal && !this._oneWay);

      this._readyToSync = true;
      this._fromObj = fromObj;
      this._fromPath = fromPath;
      this._toObj = obj;

      return this;
    };

    /**
      Disconnects the binding instance. Changes will no longer be relayed. You
      will not usually need to call this method.
       @method disconnect
      @return {Ember.Binding} `this`
      @public
    */

    Binding.prototype.disconnect = function disconnect() {
      _emberDebug.assert('Must pass a valid object to Ember.Binding.disconnect()', !!this._toObj);

      // Remove an observer on the object so we're no longer notified of
      // changes that should update bindings.
      _emberMetalObserver.removeObserver(this._fromObj, this._fromPath, this, 'fromDidChange');

      // If the binding is two-way, remove the observer from the target as well.
      if (!this._oneWay) {
        _emberMetalObserver.removeObserver(this._toObj, this._to, this, 'toDidChange');
      }

      this._readyToSync = false; // Disable scheduled syncs...
      return this;
    };

    // ..........................................................
    // PRIVATE
    //

    /* Called when the from side changes. */

    Binding.prototype.fromDidChange = function fromDidChange(target) {
      this._scheduleSync('fwd');
    };

    /* Called when the to side changes. */

    Binding.prototype.toDidChange = function toDidChange(target) {
      this._scheduleSync('back');
    };

    Binding.prototype._scheduleSync = function _scheduleSync(dir) {
      var existingDir = this._direction;

      // If we haven't scheduled the binding yet, schedule it.
      if (existingDir === undefined) {
        _emberMetalRun_loop.default.schedule('sync', this, '_sync');
        this._direction = dir;
      }

      // If both a 'back' and 'fwd' sync have been scheduled on the same object,
      // default to a 'fwd' sync so that it remains deterministic.
      if (existingDir === 'back' && dir === 'fwd') {
        this._direction = 'fwd';
      }
    };

    Binding.prototype._sync = function _sync() {
      var _this = this;

      var log = _emberEnvironment.ENV.LOG_BINDINGS;

      var toObj = this._toObj;

      // Don't synchronize destroyed objects or disconnected bindings.
      if (toObj.isDestroyed || !this._readyToSync) {
        return;
      }

      // Get the direction of the binding for the object we are
      // synchronizing from.
      var direction = this._direction;

      var fromObj = this._fromObj;
      var fromPath = this._fromPath;

      this._direction = undefined;

      // If we're synchronizing from the remote object...
      if (direction === 'fwd') {
        (function () {
          var fromValue = _emberMetalProperty_get.get(fromObj, fromPath);
          if (log) {
            _emberConsole.default.log(' ', _this.toString(), '->', fromValue, fromObj);
          }
          if (_this._oneWay) {
            _emberMetalProperty_set.trySet(toObj, _this._to, fromValue);
          } else {
            _emberMetalObserver._suspendObserver(toObj, _this._to, _this, 'toDidChange', function () {
              _emberMetalProperty_set.trySet(toObj, this._to, fromValue);
            });
          }
          // If we're synchronizing *to* the remote object.
        })();
      } else if (direction === 'back') {
          (function () {
            var toValue = _emberMetalProperty_get.get(toObj, _this._to);
            if (log) {
              _emberConsole.default.log(' ', _this.toString(), '<-', toValue, toObj);
            }
            _emberMetalObserver._suspendObserver(fromObj, fromPath, _this, 'fromDidChange', function () {
              _emberMetalProperty_set.trySet(fromObj, fromPath, toValue);
            });
          })();
        }
    };

    return Binding;
  })();

  function fireDeprecations(obj, toPath, fromPath, deprecateGlobal, deprecateOneWay, deprecateAlias) {
    var deprecateGlobalMessage = '`Ember.Binding` is deprecated. Since you' + ' are binding to a global consider using a service instead.';
    var deprecateOneWayMessage = '`Ember.Binding` is deprecated. Since you' + ' are using a `oneWay` binding consider using a `readOnly` computed' + ' property instead.';
    var deprecateAliasMessage = '`Ember.Binding` is deprecated. Consider' + ' using an `alias` computed property instead.';

    var objectInfo = 'The `' + toPath + '` property of `' + obj + '` is an `Ember.Binding` connected to `' + fromPath + '`, but ';
    _emberDebug.deprecate(objectInfo + deprecateGlobalMessage, !deprecateGlobal, {
      id: 'ember-metal.binding',
      until: '3.0.0',
      url: 'http://emberjs.com/deprecations/v2.x#toc_ember-binding'
    });
    _emberDebug.deprecate(objectInfo + deprecateOneWayMessage, !deprecateOneWay, {
      id: 'ember-metal.binding',
      until: '3.0.0',
      url: 'http://emberjs.com/deprecations/v2.x#toc_ember-binding'
    });
    _emberDebug.deprecate(objectInfo + deprecateAliasMessage, !deprecateAlias, {
      id: 'ember-metal.binding',
      until: '3.0.0',
      url: 'http://emberjs.com/deprecations/v2.x#toc_ember-binding'
    });
  }

  function mixinProperties(to, from) {
    for (var key in from) {
      if (from.hasOwnProperty(key)) {
        to[key] = from[key];
      }
    }
  }

  mixinProperties(Binding, {

    /*
      See `Ember.Binding.from`.
       @method from
      @static
    */
    from: function (from) {
      var C = this;
      return new C(undefined, from);
    },

    /*
      See `Ember.Binding.to`.
       @method to
      @static
    */
    to: function (to) {
      var C = this;
      return new C(to, undefined);
    }
  });
  /**
    An `Ember.Binding` connects the properties of two objects so that whenever
    the value of one property changes, the other property will be changed also.
  
    ## Automatic Creation of Bindings with `/^*Binding/`-named Properties.
  
    You do not usually create Binding objects directly but instead describe
    bindings in your class or object definition using automatic binding
    detection.
  
    Properties ending in a `Binding` suffix will be converted to `Ember.Binding`
    instances. The value of this property should be a string representing a path
    to another object or a custom binding instance created using Binding helpers
    (see "One Way Bindings"):
  
    ```
    valueBinding: "MyApp.someController.title"
    ```
  
    This will create a binding from `MyApp.someController.title` to the `value`
    property of your object instance automatically. Now the two values will be
    kept in sync.
  
    ## One Way Bindings
  
    One especially useful binding customization you can use is the `oneWay()`
    helper. This helper tells Ember that you are only interested in
    receiving changes on the object you are binding from. For example, if you
    are binding to a preference and you want to be notified if the preference
    has changed, but your object will not be changing the preference itself, you
    could do:
  
    ```
    bigTitlesBinding: Ember.Binding.oneWay("MyApp.preferencesController.bigTitles")
    ```
  
    This way if the value of `MyApp.preferencesController.bigTitles` changes the
    `bigTitles` property of your object will change also. However, if you
    change the value of your `bigTitles` property, it will not update the
    `preferencesController`.
  
    One way bindings are almost twice as fast to setup and twice as fast to
    execute because the binding only has to worry about changes to one side.
  
    You should consider using one way bindings anytime you have an object that
    may be created frequently and you do not intend to change a property; only
    to monitor it for changes (such as in the example above).
  
    ## Adding Bindings Manually
  
    All of the examples above show you how to configure a custom binding, but the
    result of these customizations will be a binding template, not a fully active
    Binding instance. The binding will actually become active only when you
    instantiate the object the binding belongs to. It is useful, however, to
    understand what actually happens when the binding is activated.
  
    For a binding to function it must have at least a `from` property and a `to`
    property. The `from` property path points to the object/key that you want to
    bind from while the `to` path points to the object/key you want to bind to.
  
    When you define a custom binding, you are usually describing the property
    you want to bind from (such as `MyApp.someController.value` in the examples
    above). When your object is created, it will automatically assign the value
    you want to bind `to` based on the name of your binding key. In the
    examples above, during init, Ember objects will effectively call
    something like this on your binding:
  
    ```javascript
    binding = Ember.Binding.from("valueBinding").to("value");
    ```
  
    This creates a new binding instance based on the template you provide, and
    sets the to path to the `value` property of the new object. Now that the
    binding is fully configured with a `from` and a `to`, it simply needs to be
    connected to become active. This is done through the `connect()` method:
  
    ```javascript
    binding.connect(this);
    ```
  
    Note that when you connect a binding you pass the object you want it to be
    connected to. This object will be used as the root for both the from and
    to side of the binding when inspecting relative paths. This allows the
    binding to be automatically inherited by subclassed objects as well.
  
    This also allows you to bind between objects using the paths you declare in
    `from` and `to`:
  
    ```javascript
    // Example 1
    binding = Ember.Binding.from("App.someObject.value").to("value");
    binding.connect(this);
  
    // Example 2
    binding = Ember.Binding.from("parentView.value").to("App.someObject.value");
    binding.connect(this);
    ```
  
    Now that the binding is connected, it will observe both the from and to side
    and relay changes.
  
    If you ever needed to do so (you almost never will, but it is useful to
    understand this anyway), you could manually create an active binding by
    using the `Ember.bind()` helper method. (This is the same method used by
    to setup your bindings on objects):
  
    ```javascript
    Ember.bind(MyApp.anotherObject, "value", "MyApp.someController.value");
    ```
  
    Both of these code fragments have the same effect as doing the most friendly
    form of binding creation like so:
  
    ```javascript
    MyApp.anotherObject = Ember.Object.create({
      valueBinding: "MyApp.someController.value",
  
      // OTHER CODE FOR THIS OBJECT...
    });
    ```
  
    Ember's built in binding creation method makes it easy to automatically
    create bindings for you. You should always use the highest-level APIs
    available, even if you understand how it works underneath.
  
    @class Binding
    @namespace Ember
    @since Ember 0.9
    @public
  */
  // Ember.Binding = Binding; ES6TODO: where to put this?

  /**
    Global helper method to create a new binding. Just pass the root object
    along with a `to` and `from` path to create and connect the binding.
  
    @method bind
    @for Ember
    @param {Object} obj The root object of the transform.
    @param {String} to The path to the 'to' side of the binding.
      Must be relative to obj.
    @param {String} from The path to the 'from' side of the binding.
      Must be relative to obj or a global path.
    @return {Ember.Binding} binding instance
    @public
  */

  function bind(obj, to, from) {
    return new Binding(to, from).connect(obj);
  }

  exports.Binding = Binding;
});
enifed('ember-metal/cache', ['exports', 'ember-metal/meta'], function (exports, _emberMetalMeta) {
  'use strict';

  var Cache = (function () {
    function Cache(limit, func, key, store) {
      babelHelpers.classCallCheck(this, Cache);

      this.size = 0;
      this.misses = 0;
      this.hits = 0;
      this.limit = limit;
      this.func = func;
      this.key = key;
      this.store = store || new DefaultStore();
    }

    Cache.prototype.get = function get(obj) {
      var key = this.key === undefined ? obj : this.key(obj);
      var value = this.store.get(key);
      if (value === undefined) {
        this.misses++;
        value = this._set(key, this.func(obj));
      } else if (value === _emberMetalMeta.UNDEFINED) {
        this.hits++;
        value = undefined;
      } else {
        this.hits++;
        // nothing to translate
      }

      return value;
    };

    Cache.prototype.set = function set(obj, value) {
      var key = this.key === undefined ? obj : this.key(obj);
      return this._set(key, value);
    };

    Cache.prototype._set = function _set(key, value) {
      if (this.limit > this.size) {
        this.size++;
        if (value === undefined) {
          this.store.set(key, _emberMetalMeta.UNDEFINED);
        } else {
          this.store.set(key, value);
        }
      }

      return value;
    };

    Cache.prototype.purge = function purge() {
      this.store.clear();
      this.size = 0;
      this.hits = 0;
      this.misses = 0;
    };

    return Cache;
  })();

  exports.default = Cache;

  var DefaultStore = (function () {
    function DefaultStore() {
      babelHelpers.classCallCheck(this, DefaultStore);

      this.data = Object.create(null);
    }

    DefaultStore.prototype.get = function get(key) {
      return this.data[key];
    };

    DefaultStore.prototype.set = function set(key, value) {
      this.data[key] = value;
    };

    DefaultStore.prototype.clear = function clear() {
      this.data = Object.create(null);
    };

    return DefaultStore;
  })();
});
enifed('ember-metal/chains', ['exports', 'ember-metal/property_get', 'ember-metal/meta', 'ember-metal/watch_key', 'ember-metal/computed', 'ember-metal/watch_path'], function (exports, _emberMetalProperty_get, _emberMetalMeta, _emberMetalWatch_key, _emberMetalComputed, _emberMetalWatch_path) {
  'use strict';

  exports.finishChains = finishChains;

  var FIRST_KEY = /^([^\.]+)/;

  function firstKey(path) {
    return path.match(FIRST_KEY)[0];
  }

  function isObject(obj) {
    return typeof obj === 'object' && obj;
  }

  function isVolatile(obj) {
    return !(isObject(obj) && obj.isDescriptor && obj._volatile === false);
  }

  var ChainWatchers = (function () {
    function ChainWatchers() {
      babelHelpers.classCallCheck(this, ChainWatchers);

      // chain nodes that reference a key in this obj by key
      // we only create ChainWatchers when we are going to add them
      // so create this upfront
      this.chains = Object.create(null);
    }

    ChainWatchers.prototype.add = function add(key, node) {
      var nodes = this.chains[key];
      if (nodes === undefined) {
        this.chains[key] = [node];
      } else {
        nodes.push(node);
      }
    };

    ChainWatchers.prototype.remove = function remove(key, node) {
      var nodes = this.chains[key];
      if (nodes) {
        for (var i = 0; i < nodes.length; i++) {
          if (nodes[i] === node) {
            nodes.splice(i, 1);
            break;
          }
        }
      }
    };

    ChainWatchers.prototype.has = function has(key, node) {
      var nodes = this.chains[key];
      if (nodes) {
        for (var i = 0; i < nodes.length; i++) {
          if (nodes[i] === node) {
            return true;
          }
        }
      }
      return false;
    };

    ChainWatchers.prototype.revalidateAll = function revalidateAll() {
      for (var key in this.chains) {
        this.notify(key, true, undefined);
      }
    };

    ChainWatchers.prototype.revalidate = function revalidate(key) {
      this.notify(key, true, undefined);
    };

    // key: the string key that is part of a path changed
    // revalidate: boolean; the chains that are watching this value should revalidate
    // callback: function that will be called with the object and path that
    //           will be/are invalidated by this key change, depending on
    //           whether the revalidate flag is passed

    ChainWatchers.prototype.notify = function notify(key, revalidate, callback) {
      var nodes = this.chains[key];
      if (nodes === undefined || nodes.length === 0) {
        return;
      }

      var affected = undefined;

      if (callback) {
        affected = [];
      }

      for (var i = 0; i < nodes.length; i++) {
        nodes[i].notify(revalidate, affected);
      }

      if (callback === undefined) {
        return;
      }

      // we gather callbacks so we don't notify them during revalidation
      for (var i = 0; i < affected.length; i += 2) {
        var obj = affected[i];
        var path = affected[i + 1];
        callback(obj, path);
      }
    };

    return ChainWatchers;
  })();

  function makeChainWatcher() {
    return new ChainWatchers();
  }

  function addChainWatcher(obj, keyName, node) {
    var m = _emberMetalMeta.meta(obj);
    m.writableChainWatchers(makeChainWatcher).add(keyName, node);
    _emberMetalWatch_key.watchKey(obj, keyName, m);
  }

  function removeChainWatcher(obj, keyName, node, _meta) {
    if (!isObject(obj)) {
      return;
    }

    var meta = _meta || _emberMetalMeta.peekMeta(obj);

    if (!meta || !meta.readableChainWatchers()) {
      return;
    }

    // make meta writable
    meta = _emberMetalMeta.meta(obj);

    meta.readableChainWatchers().remove(keyName, node);

    _emberMetalWatch_key.unwatchKey(obj, keyName, meta);
  }

  // A ChainNode watches a single key on an object. If you provide a starting
  // value for the key then the node won't actually watch it. For a root node
  // pass null for parent and key and object for value.

  var ChainNode = (function () {
    function ChainNode(parent, key, value) {
      babelHelpers.classCallCheck(this, ChainNode);

      this._parent = parent;
      this._key = key;

      // _watching is true when calling get(this._parent, this._key) will
      // return the value of this node.
      //
      // It is false for the root of a chain (because we have no parent)
      // and for global paths (because the parent node is the object with
      // the observer on it)
      var isWatching = this._watching = value === undefined;

      this._chains = undefined;
      this._object = undefined;
      this.count = 0;

      this._value = value;
      this._paths = undefined;
      if (isWatching === true) {
        var obj = parent.value();

        if (!isObject(obj) === true) {
          return;
        }

        this._object = obj;

        addChainWatcher(this._object, this._key, this);
      }
    }

    ChainNode.prototype.value = function value() {
      if (this._value === undefined && this._watching === true) {
        var obj = this._parent.value();
        this._value = lazyGet(obj, this._key);
      }
      return this._value;
    };

    ChainNode.prototype.destroy = function destroy() {
      if (this._watching === true) {
        var obj = this._object;
        if (obj) {
          removeChainWatcher(obj, this._key, this);
        }
        this._watching = false; // so future calls do nothing
      }
    };

    // copies a top level object only

    ChainNode.prototype.copy = function copy(obj) {
      var ret = new ChainNode(null, null, obj);
      var paths = this._paths;
      var path = undefined;
      if (paths !== undefined) {
        for (path in paths) {
          // this check will also catch non-number vals.
          if (paths[path] <= 0) {
            continue;
          }
          ret.add(path);
        }
      }
      return ret;
    };

    // called on the root node of a chain to setup watchers on the specified
    // path.

    ChainNode.prototype.add = function add(path) {
      var paths = this._paths || (this._paths = {});
      paths[path] = (paths[path] || 0) + 1;

      var key = firstKey(path);
      var tail = path.slice(key.length + 1);

      this.chain(key, tail);
    };

    // called on the root node of a chain to teardown watcher on the specified
    // path

    ChainNode.prototype.remove = function remove(path) {
      var paths = this._paths;
      if (paths === undefined) {
        return;
      }
      if (paths[path] > 0) {
        paths[path]--;
      }

      var key = firstKey(path);
      var tail = path.slice(key.length + 1);

      this.unchain(key, tail);
    };

    ChainNode.prototype.chain = function chain(key, path) {
      var chains = this._chains;
      var node = undefined;
      if (chains === undefined) {
        chains = this._chains = Object.create(null);
      } else {
        node = chains[key];
      }

      if (node === undefined) {
        node = chains[key] = new ChainNode(this, key, undefined);
      }

      node.count++; // count chains...

      // chain rest of path if there is one
      if (path) {
        key = firstKey(path);
        path = path.slice(key.length + 1);
        node.chain(key, path);
      }
    };

    ChainNode.prototype.unchain = function unchain(key, path) {
      var chains = this._chains;
      var node = chains[key];

      // unchain rest of path first...
      if (path && path.length > 1) {
        var nextKey = firstKey(path);
        var nextPath = path.slice(nextKey.length + 1);
        node.unchain(nextKey, nextPath);
      }

      // delete node if needed.
      node.count--;
      if (node.count <= 0) {
        chains[node._key] = undefined;
        node.destroy();
      }
    };

    ChainNode.prototype.notify = function notify(revalidate, affected) {
      if (revalidate && this._watching === true) {
        var parentValue = this._parent.value();

        if (parentValue !== this._object) {
          if (this._object !== undefined) {
            removeChainWatcher(this._object, this._key, this);
          }

          if (isObject(parentValue)) {
            this._object = parentValue;
            addChainWatcher(parentValue, this._key, this);
          } else {
            this._object = undefined;
          }
        }
        this._value = undefined;
      }

      // then notify chains...
      var chains = this._chains;
      var node = undefined;
      if (chains !== undefined) {
        for (var key in chains) {
          node = chains[key];
          if (node !== undefined) {
            node.notify(revalidate, affected);
          }
        }
      }

      if (affected && this._parent) {
        this._parent.populateAffected(this._key, 1, affected);
      }
    };

    ChainNode.prototype.populateAffected = function populateAffected(path, depth, affected) {
      if (this._key) {
        path = this._key + '.' + path;
      }

      if (this._parent) {
        this._parent.populateAffected(path, depth + 1, affected);
      } else {
        if (depth > 1) {
          affected.push(this.value(), path);
        }
      }
    };

    return ChainNode;
  })();

  function lazyGet(obj, key) {
    if (!isObject(obj)) {
      return;
    }

    var meta = _emberMetalMeta.peekMeta(obj);

    // check if object meant only to be a prototype
    if (meta !== undefined && meta.proto === obj) {
      return;
    }

    // Use `get` if the return value is an EachProxy or an uncacheable value.
    if (isVolatile(obj[key]) === true) {
      return _emberMetalProperty_get.get(obj, key);
      // Otherwise attempt to get the cached value of the computed property
    } else {
        var cache = meta.readableCache();
        if (cache) {
          return _emberMetalComputed.cacheFor.get(cache, key);
        }
      }
  }

  function finishChains(meta) {
    // finish any current chains node watchers that reference obj
    var chainWatchers = meta.readableChainWatchers();
    if (chainWatchers !== undefined) {
      chainWatchers.revalidateAll();
    }
    // ensure that if we have inherited any chains they have been
    // copied onto our own meta.
    if (meta.readableChains() !== undefined) {
      meta.writableChains(_emberMetalWatch_path.makeChainNode);
    }
  }

  exports.removeChainWatcher = removeChainWatcher;
  exports.ChainNode = ChainNode;
});
enifed('ember-metal/computed', ['exports', 'ember-utils', 'ember-debug', 'ember-metal/property_set', 'ember-metal/meta', 'ember-metal/expand_properties', 'ember-metal/properties', 'ember-metal/property_events', 'ember-metal/dependent_keys'], function (exports, _emberUtils, _emberDebug, _emberMetalProperty_set, _emberMetalMeta, _emberMetalExpand_properties, _emberMetalProperties, _emberMetalProperty_events, _emberMetalDependent_keys) {
  'use strict';

  exports.default = computed;

  /**
  @module ember
  @submodule ember-metal
  */

  var DEEP_EACH_REGEX = /\.@each\.[^.]+\./;

  /**
    A computed property transforms an object literal with object's accessor function(s) into a property.
  
    By default the function backing the computed property will only be called
    once and the result will be cached. You can specify various properties
    that your computed property depends on. This will force the cached
    result to be recomputed if the dependencies are modified.
  
    In the following example we declare a computed property - `fullName` - by calling
    `.Ember.computed()` with property dependencies (`firstName` and `lastName`) as leading arguments and getter accessor function. The `fullName` getter function
    will be called once (regardless of how many times it is accessed) as long
    as its dependencies have not changed. Once `firstName` or `lastName` are updated
    any future calls (or anything bound) to `fullName` will incorporate the new
    values.
  
    ```javascript
    let Person = Ember.Object.extend({
      // these will be supplied by `create`
      firstName: null,
      lastName: null,
  
      fullName: Ember.computed('firstName', 'lastName', function() {
        let firstName = this.get('firstName'),
            lastName  = this.get('lastName');
  
        return firstName + ' ' + lastName;
      })
    });
  
    let tom = Person.create({
      firstName: 'Tom',
      lastName: 'Dale'
    });
  
    tom.get('fullName') // 'Tom Dale'
    ```
  
    You can also define what Ember should do when setting a computed property by providing additional function (`set`) in hash argument.
    If you try to set a computed property, it will try to invoke setter accessor function with the key and
    value you want to set it to as arguments.
  
    ```javascript
    let Person = Ember.Object.extend({
      // these will be supplied by `create`
      firstName: null,
      lastName: null,
  
      fullName: Ember.computed('firstName', 'lastName', {
        get(key) {
          let firstName = this.get('firstName'),
              lastName  = this.get('lastName');
  
          return firstName + ' ' + lastName;
        },
        set(key, value) {
          let [firstName, lastName] = value.split(' ');
  
          this.set('firstName', firstName);
          this.set('lastName', lastName);
  
          return value;
        }
      })
    });
  
    let person = Person.create();
  
    person.set('fullName', 'Peter Wagenet');
    person.get('firstName'); // 'Peter'
    person.get('lastName');  // 'Wagenet'
    ```
  
    You can overwrite computed property with normal property (no longer computed), that won't change if dependencies change, if you set computed property and it won't have setter accessor function defined.
  
    You can also mark computed property as `.readOnly()` and block all attempts to set it.
  
    ```javascript
    let Person = Ember.Object.extend({
      // these will be supplied by `create`
      firstName: null,
      lastName: null,
  
      fullName: Ember.computed('firstName', 'lastName', {
        get(key) {
          let firstName = this.get('firstName');
          let lastName  = this.get('lastName');
  
          return firstName + ' ' + lastName;
        }
      }).readOnly()
    });
  
    let person = Person.create();
    person.set('fullName', 'Peter Wagenet'); // Uncaught Error: Cannot set read-only property "fullName" on object: <(...):emberXXX>
    ```
  
    Additional resources:
    - [New CP syntax RFC](https://github.com/emberjs/rfcs/blob/master/text/0011-improved-cp-syntax.md)
    - [New computed syntax explained in "Ember 1.12 released" ](http://emberjs.com/blog/2015/05/13/ember-1-12-released.html#toc_new-computed-syntax)
  
    @class ComputedProperty
    @namespace Ember
    @public
  */
  function ComputedProperty(config, opts) {
    this.isDescriptor = true;
    if (typeof config === 'function') {
      this._getter = config;
    } else {
      _emberDebug.assert('Ember.computed expects a function or an object as last argument.', typeof config === 'object' && !Array.isArray(config));
      _emberDebug.assert('Config object passed to an Ember.computed can only contain `get` or `set` keys.', (function () {
        var keys = Object.keys(config);
        for (var i = 0; i < keys.length; i++) {
          if (keys[i] !== 'get' && keys[i] !== 'set') {
            return false;
          }
        }
        return true;
      })());
      this._getter = config.get;
      this._setter = config.set;
    }
    _emberDebug.assert('Computed properties must receive a getter or a setter, you passed none.', !!this._getter || !!this._setter);
    this._dependentKeys = undefined;
    this._suspended = undefined;
    this._meta = undefined;
    this._volatile = false;
    this._dependentKeys = opts && opts.dependentKeys;
    this._readOnly = false;
  }

  ComputedProperty.prototype = new _emberMetalProperties.Descriptor();
  ComputedProperty.prototype.constructor = ComputedProperty;

  var ComputedPropertyPrototype = ComputedProperty.prototype;

  /**
    Call on a computed property to set it into non-cached mode. When in this
    mode the computed property will not automatically cache the return value.
  
    It also does not automatically fire any change events. You must manually notify
    any changes if you want to observe this property.
  
    Dependency keys have no effect on volatile properties as they are for cache
    invalidation and notification when cached value is invalidated.
  
    ```javascript
    let outsideService = Ember.Object.extend({
      value: Ember.computed(function() {
        return OutsideService.getValue();
      }).volatile()
    }).create();
    ```
  
    @method volatile
    @return {Ember.ComputedProperty} this
    @chainable
    @public
  */
  ComputedPropertyPrototype.volatile = function () {
    this._volatile = true;
    return this;
  };

  /**
    Call on a computed property to set it into read-only mode. When in this
    mode the computed property will throw an error when set.
  
    ```javascript
    let Person = Ember.Object.extend({
      guid: Ember.computed(function() {
        return 'guid-guid-guid';
      }).readOnly()
    });
  
    let person = Person.create();
  
    person.set('guid', 'new-guid'); // will throw an exception
    ```
  
    @method readOnly
    @return {Ember.ComputedProperty} this
    @chainable
    @public
  */
  ComputedPropertyPrototype.readOnly = function () {
    this._readOnly = true;
    _emberDebug.assert('Computed properties that define a setter using the new syntax cannot be read-only', !(this._readOnly && this._setter && this._setter !== this._getter));
    return this;
  };

  /**
    Sets the dependent keys on this computed property. Pass any number of
    arguments containing key paths that this computed property depends on.
  
    ```javascript
    let President = Ember.Object.extend({
      fullName: Ember.computed(function() {
        return this.get('firstName') + ' ' + this.get('lastName');
  
        // Tell Ember that this computed property depends on firstName
        // and lastName
      }).property('firstName', 'lastName')
    });
  
    let president = President.create({
      firstName: 'Barack',
      lastName: 'Obama'
    });
  
    president.get('fullName'); // 'Barack Obama'
    ```
  
    @method property
    @param {String} path* zero or more property paths
    @return {Ember.ComputedProperty} this
    @chainable
    @public
  */
  ComputedPropertyPrototype.property = function () {
    var args = [];

    function addArg(property) {
      _emberDebug.warn('Dependent keys containing @each only work one level deep. ' + ('You used the key "' + property + '" which is invalid. ') + 'Please create an intermediary computed property.', DEEP_EACH_REGEX.test(property) === false, { id: 'ember-metal.computed-deep-each' });
      args.push(property);
    }

    for (var i = 0; i < arguments.length; i++) {
      _emberMetalExpand_properties.default(arguments[i], addArg);
    }

    this._dependentKeys = args;
    return this;
  };

  /**
    In some cases, you may want to annotate computed properties with additional
    metadata about how they function or what values they operate on. For example,
    computed property functions may close over variables that are then no longer
    available for introspection.
  
    You can pass a hash of these values to a computed property like this:
  
    ```
    person: Ember.computed(function() {
      let personId = this.get('personId');
      return App.Person.create({ id: personId });
    }).meta({ type: App.Person })
    ```
  
    The hash that you pass to the `meta()` function will be saved on the
    computed property descriptor under the `_meta` key. Ember runtime
    exposes a public API for retrieving these values from classes,
    via the `metaForProperty()` function.
  
    @method meta
    @param {Object} meta
    @chainable
    @public
  */
  ComputedPropertyPrototype.meta = function (meta) {
    if (arguments.length === 0) {
      return this._meta || {};
    } else {
      this._meta = meta;
      return this;
    }
  };

  // invalidate cache when CP key changes
  ComputedPropertyPrototype.didChange = function (obj, keyName) {
    // _suspended is set via a CP.set to ensure we don't clear
    // the cached value set by the setter
    if (this._volatile || this._suspended === obj) {
      return;
    }

    // don't create objects just to invalidate
    var meta = _emberMetalMeta.peekMeta(obj);
    if (!meta || meta.source !== obj) {
      return;
    }

    var cache = meta.readableCache();
    if (cache && cache[keyName] !== undefined) {
      cache[keyName] = undefined;
      _emberMetalDependent_keys.removeDependentKeys(this, obj, keyName, meta);
    }
  };

  ComputedPropertyPrototype.get = function (obj, keyName) {
    if (this._volatile) {
      return this._getter.call(obj, keyName);
    }

    var meta = _emberMetalMeta.meta(obj);
    var cache = meta.writableCache();

    var result = cache[keyName];
    if (result === _emberMetalMeta.UNDEFINED) {
      return undefined;
    } else if (result !== undefined) {
      return result;
    }

    var ret = this._getter.call(obj, keyName);
    if (ret === undefined) {
      cache[keyName] = _emberMetalMeta.UNDEFINED;
    } else {
      cache[keyName] = ret;
    }

    var chainWatchers = meta.readableChainWatchers();
    if (chainWatchers) {
      chainWatchers.revalidate(keyName);
    }
    _emberMetalDependent_keys.addDependentKeys(this, obj, keyName, meta);

    return ret;
  };

  ComputedPropertyPrototype.set = function computedPropertySetEntry(obj, keyName, value) {
    if (this._readOnly) {
      this._throwReadOnlyError(obj, keyName);
    }

    if (!this._setter) {
      return this.clobberSet(obj, keyName, value);
    }

    if (this._volatile) {
      return this.volatileSet(obj, keyName, value);
    }

    return this.setWithSuspend(obj, keyName, value);
  };

  ComputedPropertyPrototype._throwReadOnlyError = function computedPropertyThrowReadOnlyError(obj, keyName) {
    throw new _emberDebug.Error('Cannot set read-only property "' + keyName + '" on object: ' + _emberUtils.inspect(obj));
  };

  ComputedPropertyPrototype.clobberSet = function computedPropertyClobberSet(obj, keyName, value) {
    var cachedValue = cacheFor(obj, keyName);
    _emberMetalProperties.defineProperty(obj, keyName, null, cachedValue);
    _emberMetalProperty_set.set(obj, keyName, value);
    return value;
  };

  ComputedPropertyPrototype.volatileSet = function computedPropertyVolatileSet(obj, keyName, value) {
    return this._setter.call(obj, keyName, value);
  };

  ComputedPropertyPrototype.setWithSuspend = function computedPropertySetWithSuspend(obj, keyName, value) {
    var oldSuspended = this._suspended;
    this._suspended = obj;
    try {
      return this._set(obj, keyName, value);
    } finally {
      this._suspended = oldSuspended;
    }
  };

  ComputedPropertyPrototype._set = function computedPropertySet(obj, keyName, value) {
    // cache requires own meta
    var meta = _emberMetalMeta.meta(obj);
    // either there is a writable cache or we need one to update
    var cache = meta.writableCache();
    var hadCachedValue = false;
    var cachedValue = undefined;
    if (cache[keyName] !== undefined) {
      if (cache[keyName] !== _emberMetalMeta.UNDEFINED) {
        cachedValue = cache[keyName];
      }
      hadCachedValue = true;
    }

    var ret = this._setter.call(obj, keyName, value, cachedValue);

    // allows setter to return the same value that is cached already
    if (hadCachedValue && cachedValue === ret) {
      return ret;
    }

    _emberMetalProperty_events.propertyWillChange(obj, keyName);

    if (hadCachedValue) {
      cache[keyName] = undefined;
    }

    if (!hadCachedValue) {
      _emberMetalDependent_keys.addDependentKeys(this, obj, keyName, meta);
    }

    if (ret === undefined) {
      cache[keyName] = _emberMetalMeta.UNDEFINED;
    } else {
      cache[keyName] = ret;
    }

    _emberMetalProperty_events.propertyDidChange(obj, keyName);

    return ret;
  };

  /* called before property is overridden */
  ComputedPropertyPrototype.teardown = function (obj, keyName) {
    if (this._volatile) {
      return;
    }
    var meta = _emberMetalMeta.meta(obj);
    var cache = meta.readableCache();
    if (cache && cache[keyName] !== undefined) {
      _emberMetalDependent_keys.removeDependentKeys(this, obj, keyName, meta);
      cache[keyName] = undefined;
    }
  };

  /**
    This helper returns a new property descriptor that wraps the passed
    computed property function. You can use this helper to define properties
    with mixins or via `Ember.defineProperty()`.
  
    If you pass a function as an argument, it will be used as a getter. A computed
    property defined in this way might look like this:
  
    ```js
    let Person = Ember.Object.extend({
      init() {
        this._super(...arguments);
  
        this.firstName = 'Betty';
        this.lastName = 'Jones';
      },
  
      fullName: Ember.computed('firstName', 'lastName', function() {
        return `${this.get('firstName')} ${this.get('lastName')}`;
      })
    });
  
    let client = Person.create();
  
    client.get('fullName'); // 'Betty Jones'
  
    client.set('lastName', 'Fuller');
    client.get('fullName'); // 'Betty Fuller'
    ```
  
    You can pass a hash with two functions, `get` and `set`, as an
    argument to provide both a getter and setter:
  
    ```js
    let Person = Ember.Object.extend({
      init() {
        this._super(...arguments);
  
        this.firstName = 'Betty';
        this.lastName = 'Jones';
      },
  
      fullName: Ember.computed('firstName', 'lastName', {
        get(key) {
          return `${this.get('firstName')} ${this.get('lastName')}`;
        },
        set(key, value) {
          let [firstName, lastName] = value.split(/\s+/);
          this.setProperties({ firstName, lastName });
          return value;
        }
      })
    });
  
    let client = Person.create();
    client.get('firstName'); // 'Betty'
  
    client.set('fullName', 'Carroll Fuller');
    client.get('firstName'); // 'Carroll'
    ```
  
    The `set` function should accept two parameters, `key` and `value`. The value
    returned from `set` will be the new value of the property.
  
    _Note: This is the preferred way to define computed properties when writing third-party
    libraries that depend on or use Ember, since there is no guarantee that the user
    will have [prototype Extensions](http://emberjs.com/guides/configuring-ember/disabling-prototype-extensions/) enabled._
  
    The alternative syntax, with prototype extensions, might look like:
  
    ```js
    fullName: function() {
      return this.get('firstName') + ' ' + this.get('lastName');
    }.property('firstName', 'lastName')
    ```
  
    @class computed
    @namespace Ember
    @constructor
    @static
    @param {String} [dependentKeys*] Optional dependent keys that trigger this computed property.
    @param {Function} func The computed property function.
    @return {Ember.ComputedProperty} property descriptor instance
    @public
  */

  function computed(func) {
    var args = undefined;

    if (arguments.length > 1) {
      args = [].slice.call(arguments);
      func = args.pop();
    }

    var cp = new ComputedProperty(func);

    if (args) {
      cp.property.apply(cp, args);
    }

    return cp;
  }

  /**
    Returns the cached value for a property, if one exists.
    This can be useful for peeking at the value of a computed
    property that is generated lazily, without accidentally causing
    it to be created.
  
    @method cacheFor
    @for Ember
    @param {Object} obj the object whose property you want to check
    @param {String} key the name of the property whose cached value you want
      to return
    @return {Object} the cached value
    @public
  */
  function cacheFor(obj, key) {
    var meta = _emberMetalMeta.peekMeta(obj);
    var cache = meta && meta.source === obj && meta.readableCache();
    var ret = cache && cache[key];

    if (ret === _emberMetalMeta.UNDEFINED) {
      return undefined;
    }
    return ret;
  }

  cacheFor.set = function (cache, key, value) {
    if (value === undefined) {
      cache[key] = _emberMetalMeta.UNDEFINED;
    } else {
      cache[key] = value;
    }
  };

  cacheFor.get = function (cache, key) {
    var ret = cache[key];
    if (ret === _emberMetalMeta.UNDEFINED) {
      return undefined;
    }
    return ret;
  };

  cacheFor.remove = function (cache, key) {
    cache[key] = undefined;
  };

  exports.ComputedProperty = ComputedProperty;
  exports.computed = computed;
  exports.cacheFor = cacheFor;
});
enifed('ember-metal/core', ['exports', 'ember-environment'], function (exports, _emberEnvironment) {
  'use strict';

  /**
  @module ember
  @submodule ember-metal
  */

  /**
    This namespace contains all Ember methods and functions. Future versions of
    Ember may overwrite this namespace and therefore, you should avoid adding any
    new properties.
  
    At the heart of Ember is Ember-Runtime, a set of core functions that provide
    cross-platform compatibility and object property observing.  Ember-Runtime is
    small and performance-focused so you can use it alongside other
    cross-platform libraries such as jQuery. For more details, see
    [Ember-Runtime](http://emberjs.com/api/modules/ember-runtime.html).
  
    @class Ember
    @static
    @public
  */
  var Ember = typeof _emberEnvironment.context.imports.Ember === 'object' && _emberEnvironment.context.imports.Ember || {};

  // Make sure these are set whether Ember was already defined or not
  Ember.isNamespace = true;
  Ember.toString = function () {
    return 'Ember';
  };

  // ..........................................................
  // BOOTSTRAP
  //

  exports.default = Ember;
});
enifed('ember-metal/dependent_keys', ['exports', 'ember-metal/watching'], function (exports, _emberMetalWatching) {
  'use strict';

  exports.addDependentKeys = addDependentKeys;
  exports.removeDependentKeys = removeDependentKeys;

  /**
  @module ember
  @submodule ember-metal
  */

  // ..........................................................
  // DEPENDENT KEYS
  //

  function addDependentKeys(desc, obj, keyName, meta) {
    // the descriptor has a list of dependent keys, so
    // add all of its dependent keys.
    var idx = undefined,
        depKey = undefined;
    var depKeys = desc._dependentKeys;
    if (!depKeys) {
      return;
    }

    for (idx = 0; idx < depKeys.length; idx++) {
      depKey = depKeys[idx];
      // Increment the number of times depKey depends on keyName.
      meta.writeDeps(depKey, keyName, (meta.peekDeps(depKey, keyName) || 0) + 1);
      // Watch the depKey
      _emberMetalWatching.watch(obj, depKey, meta);
    }
  }

  function removeDependentKeys(desc, obj, keyName, meta) {
    // the descriptor has a list of dependent keys, so
    // remove all of its dependent keys.
    var depKeys = desc._dependentKeys;
    if (!depKeys) {
      return;
    }

    for (var idx = 0; idx < depKeys.length; idx++) {
      var depKey = depKeys[idx];
      // Decrement the number of times depKey depends on keyName.
      meta.writeDeps(depKey, keyName, (meta.peekDeps(depKey, keyName) || 0) - 1);
      // Unwatch the depKey
      _emberMetalWatching.unwatch(obj, depKey, meta);
    }
  }
});
enifed('ember-metal/deprecate_property', ['exports', 'ember-debug', 'ember-metal/property_get', 'ember-metal/property_set'], function (exports, _emberDebug, _emberMetalProperty_get, _emberMetalProperty_set) {
  /**
  @module ember
  @submodule ember-metal
  */

  'use strict';

  exports.deprecateProperty = deprecateProperty;

  /**
    Used internally to allow changing properties in a backwards compatible way, and print a helpful
    deprecation warning.
  
    @method deprecateProperty
    @param {Object} object The object to add the deprecated property to.
    @param {String} deprecatedKey The property to add (and print deprecation warnings upon accessing).
    @param {String} newKey The property that will be aliased.
    @private
    @since 1.7.0
  */

  function deprecateProperty(object, deprecatedKey, newKey, options) {
    function _deprecate() {
      _emberDebug.deprecate('Usage of `' + deprecatedKey + '` is deprecated, use `' + newKey + '` instead.', false, options);
    }

    Object.defineProperty(object, deprecatedKey, {
      configurable: true,
      enumerable: false,
      set: function (value) {
        _deprecate();
        _emberMetalProperty_set.set(this, newKey, value);
      },
      get: function () {
        _deprecate();
        return _emberMetalProperty_get.get(this, newKey);
      }
    });
  }
});
enifed('ember-metal/descriptor', ['exports', 'ember-metal/properties'], function (exports, _emberMetalProperties) {
  'use strict';

  exports.default = descriptor;

  function descriptor(desc) {
    return new Descriptor(desc);
  }

  /**
    A wrapper for a native ES5 descriptor. In an ideal world, we wouldn't need
    this at all, however, the way we currently flatten/merge our mixins require
    a special value to denote a descriptor.
  
    @class Descriptor
    @private
  */

  var Descriptor = (function (_EmberDescriptor) {
    babelHelpers.inherits(Descriptor, _EmberDescriptor);

    function Descriptor(desc) {
      babelHelpers.classCallCheck(this, Descriptor);

      _EmberDescriptor.call(this);
      this.desc = desc;
    }

    Descriptor.prototype.setup = function setup(obj, key) {
      Object.defineProperty(obj, key, this.desc);
    };

    Descriptor.prototype.teardown = function teardown(obj, key) {};

    return Descriptor;
  })(_emberMetalProperties.Descriptor);
});
enifed('ember-metal/error_handler', ['exports', 'ember-console', 'ember-debug'], function (exports, _emberConsole, _emberDebug) {
  'use strict';

  exports.getOnerror = getOnerror;
  exports.setOnerror = setOnerror;
  exports.dispatchError = dispatchError;
  exports.getDispatchOverride = getDispatchOverride;
  exports.setDispatchOverride = setDispatchOverride;

  // To maintain stacktrace consistency across browsers
  var getStack = function (error) {
    var stack = error.stack;
    var message = error.message;

    if (stack && stack.indexOf(message) === -1) {
      stack = message + '\n' + stack;
    }

    return stack;
  };

  var onerror = undefined;
  // Ember.onerror getter

  function getOnerror() {
    return onerror;
  }

  // Ember.onerror setter

  function setOnerror(handler) {
    onerror = handler;
  }

  var dispatchOverride = undefined;
  // dispatch error

  function dispatchError(error) {
    if (dispatchOverride) {
      dispatchOverride(error);
    } else {
      defaultDispatch(error);
    }
  }

  // allows testing adapter to override dispatch

  function getDispatchOverride() {
    return dispatchOverride;
  }

  function setDispatchOverride(handler) {
    dispatchOverride = handler;
  }

  function defaultDispatch(error) {
    if (_emberDebug.isTesting()) {
      throw error;
    }
    if (onerror) {
      onerror(error);
    } else {
      _emberConsole.default.error(getStack(error));
    }
  }
});
enifed('ember-metal/events', ['exports', 'ember-utils', 'ember-metal/meta', 'ember-debug', 'ember-metal/meta_listeners'], function (exports, _emberUtils, _emberMetalMeta, _emberDebug, _emberMetalMeta_listeners) {
  /**
  @module ember
  @submodule ember-metal
  */
  'use strict';

  exports.accumulateListeners = accumulateListeners;
  exports.addListener = addListener;
  exports.removeListener = removeListener;
  exports.suspendListener = suspendListener;
  exports.suspendListeners = suspendListeners;
  exports.watchedEvents = watchedEvents;
  exports.sendEvent = sendEvent;
  exports.hasListeners = hasListeners;
  exports.listenersFor = listenersFor;
  exports.on = on;

  /*
    The event system uses a series of nested hashes to store listeners on an
    object. When a listener is registered, or when an event arrives, these
    hashes are consulted to determine which target and action pair to invoke.
  
    The hashes are stored in the object's meta hash, and look like this:
  
        // Object's meta hash
        {
          listeners: {       // variable name: `listenerSet`
            "foo:changed": [ // variable name: `actions`
              target, method, flags
            ]
          }
        }
  
  */

  function indexOf(array, target, method) {
    var index = -1;
    // hashes are added to the end of the event array
    // so it makes sense to start searching at the end
    // of the array and search in reverse
    for (var i = array.length - 3; i >= 0; i -= 3) {
      if (target === array[i] && method === array[i + 1]) {
        index = i;
        break;
      }
    }
    return index;
  }

  function accumulateListeners(obj, eventName, otherActions) {
    var meta = _emberMetalMeta.peekMeta(obj);
    if (!meta) {
      return;
    }
    var actions = meta.matchingListeners(eventName);
    if (actions === undefined) {
      return;
    }
    var newActions = [];

    for (var i = actions.length - 3; i >= 0; i -= 3) {
      var target = actions[i];
      var method = actions[i + 1];
      var flags = actions[i + 2];
      var actionIndex = indexOf(otherActions, target, method);

      if (actionIndex === -1) {
        otherActions.push(target, method, flags);
        newActions.push(target, method, flags);
      }
    }

    return newActions;
  }

  /**
    Add an event listener
  
    @method addListener
    @for Ember
    @param obj
    @param {String} eventName
    @param {Object|Function} target A target object or a function
    @param {Function|String} method A function or the name of a function to be called on `target`
    @param {Boolean} once A flag whether a function should only be called once
    @public
  */

  function addListener(obj, eventName, target, method, once) {
    _emberDebug.assert('You must pass at least an object and event name to Ember.addListener', !!obj && !!eventName);

    _emberDebug.deprecate('didInitAttrs called in ' + (obj && obj.toString && obj.toString()) + '.', eventName !== 'didInitAttrs', {
      id: 'ember-views.did-init-attrs',
      until: '3.0.0',
      url: 'http://emberjs.com/deprecations/v2.x#toc_ember-component-didinitattrs'
    });

    if (!method && 'function' === typeof target) {
      method = target;
      target = null;
    }

    var flags = 0;
    if (once) {
      flags |= _emberMetalMeta_listeners.ONCE;
    }

    _emberMetalMeta.meta(obj).addToListeners(eventName, target, method, flags);

    if ('function' === typeof obj.didAddListener) {
      obj.didAddListener(eventName, target, method);
    }
  }

  /**
    Remove an event listener
  
    Arguments should match those passed to `Ember.addListener`.
  
    @method removeListener
    @for Ember
    @param obj
    @param {String} eventName
    @param {Object|Function} target A target object or a function
    @param {Function|String} method A function or the name of a function to be called on `target`
    @public
  */

  function removeListener(obj, eventName, target, method) {
    _emberDebug.assert('You must pass at least an object and event name to Ember.removeListener', !!obj && !!eventName);

    if (!method && 'function' === typeof target) {
      method = target;
      target = null;
    }

    _emberMetalMeta.meta(obj).removeFromListeners(eventName, target, method, function () {
      if ('function' === typeof obj.didRemoveListener) {
        obj.didRemoveListener.apply(obj, arguments);
      }
    });
  }

  /**
    Suspend listener during callback.
  
    This should only be used by the target of the event listener
    when it is taking an action that would cause the event, e.g.
    an object might suspend its property change listener while it is
    setting that property.
  
    @method suspendListener
    @for Ember
  
    @private
    @param obj
    @param {String} eventName
    @param {Object|Function} target A target object or a function
    @param {Function|String} method A function or the name of a function to be called on `target`
    @param {Function} callback
  */

  function suspendListener(obj, eventName, target, method, callback) {
    return suspendListeners(obj, [eventName], target, method, callback);
  }

  /**
    Suspends multiple listeners during a callback.
  
    @method suspendListeners
    @for Ember
  
    @private
    @param obj
    @param {Array} eventNames Array of event names
    @param {Object|Function} target A target object or a function
    @param {Function|String} method A function or the name of a function to be called on `target`
    @param {Function} callback
  */

  function suspendListeners(obj, eventNames, target, method, callback) {
    if (!method && 'function' === typeof target) {
      method = target;
      target = null;
    }
    return _emberMetalMeta.meta(obj).suspendListeners(eventNames, target, method, callback);
  }

  /**
    Return a list of currently watched events
  
    @private
    @method watchedEvents
    @for Ember
    @param obj
  */

  function watchedEvents(obj) {
    return _emberMetalMeta.meta(obj).watchedEvents();
  }

  /**
    Send an event. The execution of suspended listeners
    is skipped, and once listeners are removed. A listener without
    a target is executed on the passed object. If an array of actions
    is not passed, the actions stored on the passed object are invoked.
  
    @method sendEvent
    @for Ember
    @param obj
    @param {String} eventName
    @param {Array} params Optional parameters for each listener.
    @param {Array} actions Optional array of actions (listeners).
    @return true
    @public
  */

  function sendEvent(obj, eventName, params, actions) {
    if (!actions) {
      var meta = _emberMetalMeta.peekMeta(obj);
      actions = meta && meta.matchingListeners(eventName);
    }

    if (!actions || actions.length === 0) {
      return;
    }

    for (var i = actions.length - 3; i >= 0; i -= 3) {
      // looping in reverse for once listeners
      var target = actions[i];
      var method = actions[i + 1];
      var flags = actions[i + 2];

      if (!method) {
        continue;
      }
      if (flags & _emberMetalMeta_listeners.SUSPENDED) {
        continue;
      }
      if (flags & _emberMetalMeta_listeners.ONCE) {
        removeListener(obj, eventName, target, method);
      }
      if (!target) {
        target = obj;
      }
      if ('string' === typeof method) {
        if (params) {
          _emberUtils.applyStr(target, method, params);
        } else {
          target[method]();
        }
      } else {
        if (params) {
          method.apply(target, params);
        } else {
          method.call(target);
        }
      }
    }
    return true;
  }

  /**
    @private
    @method hasListeners
    @for Ember
    @param obj
    @param {String} eventName
  */

  function hasListeners(obj, eventName) {
    var meta = _emberMetalMeta.peekMeta(obj);
    if (!meta) {
      return false;
    }
    var matched = meta.matchingListeners(eventName);
    return matched !== undefined && matched.length > 0;
  }

  /**
    @private
    @method listenersFor
    @for Ember
    @param obj
    @param {String} eventName
  */

  function listenersFor(obj, eventName) {
    var ret = [];
    var meta = _emberMetalMeta.peekMeta(obj);
    var actions = meta && meta.matchingListeners(eventName);

    if (!actions) {
      return ret;
    }

    for (var i = 0; i < actions.length; i += 3) {
      var target = actions[i];
      var method = actions[i + 1];
      ret.push([target, method]);
    }

    return ret;
  }

  /**
    Define a property as a function that should be executed when
    a specified event or events are triggered.
  
  
    ``` javascript
    let Job = Ember.Object.extend({
      logCompleted: Ember.on('completed', function() {
        console.log('Job completed!');
      })
    });
  
    let job = Job.create();
  
    Ember.sendEvent(job, 'completed'); // Logs 'Job completed!'
   ```
  
    @method on
    @for Ember
    @param {String} eventNames*
    @param {Function} func
    @return func
    @public
  */

  function on() {
    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    var func = args.pop();
    var events = args;
    func.__ember_listens__ = events;
    return func;
  }
});
enifed('ember-metal/expand_properties', ['exports', 'ember-debug'], function (exports, _emberDebug) {
  'use strict';

  exports.default = expandProperties;

  /**
  @module ember
  @submodule ember-metal
  */

  var END_WITH_EACH_REGEX = /\.@each$/;

  /**
    Expands `pattern`, invoking `callback` for each expansion.
  
    The only pattern supported is brace-expansion, anything else will be passed
    once to `callback` directly.
  
    Example
  
    ```js
    function echo(arg){ console.log(arg); }
  
    Ember.expandProperties('foo.bar', echo);              //=> 'foo.bar'
    Ember.expandProperties('{foo,bar}', echo);            //=> 'foo', 'bar'
    Ember.expandProperties('foo.{bar,baz}', echo);        //=> 'foo.bar', 'foo.baz'
    Ember.expandProperties('{foo,bar}.baz', echo);        //=> 'foo.baz', 'bar.baz'
    Ember.expandProperties('foo.{bar,baz}.[]', echo)      //=> 'foo.bar.[]', 'foo.baz.[]'
    Ember.expandProperties('{foo,bar}.{spam,eggs}', echo) //=> 'foo.spam', 'foo.eggs', 'bar.spam', 'bar.eggs'
    Ember.expandProperties('{foo}.bar.{baz}')             //=> 'foo.bar.baz'
    ```
  
    @method expandProperties
    @for Ember
    @private
    @param {String} pattern The property pattern to expand.
    @param {Function} callback The callback to invoke.  It is invoked once per
    expansion, and is passed the expansion.
  */

  function expandProperties(pattern, callback) {
    _emberDebug.assert('A computed property key must be a string, you passed ' + typeof pattern + ' ' + pattern, typeof pattern === 'string');
    _emberDebug.assert('Brace expanded properties cannot contain spaces, e.g. "user.{firstName, lastName}" should be "user.{firstName,lastName}"', pattern.indexOf(' ') === -1);

    var unbalancedNestedError = 'Brace expanded properties have to be balanced and cannot be nested, pattern: ' + pattern;
    var properties = [pattern];

    // Iterating backward over the pattern makes dealing with indices easier.
    var bookmark = undefined;
    var inside = false;
    for (var i = pattern.length; i > 0; --i) {
      var current = pattern[i - 1];

      switch (current) {
        // Closing curly brace will be the first character of the brace expansion we encounter.
        // Bookmark its index so long as we're not already inside a brace expansion.
        case '}':
          if (!inside) {
            bookmark = i - 1;
            inside = true;
          } else {
            _emberDebug.assert(unbalancedNestedError, false);
          }
          break;
        // Opening curly brace will be the last character of the brace expansion we encounter.
        // Apply the brace expansion so long as we've already seen a closing curly brace.
        case '{':
          if (inside) {
            var expansion = pattern.slice(i, bookmark).split(',');
            // Iterating backward allows us to push new properties w/out affecting our "cursor".
            for (var j = properties.length; j > 0; --j) {
              // Extract the unexpanded property from the array.
              var property = properties.splice(j - 1, 1)[0];
              // Iterate over the expansion, pushing the newly formed properties onto the array.
              for (var k = 0; k < expansion.length; ++k) {
                properties.push(property.slice(0, i - 1) + expansion[k] + property.slice(bookmark + 1));
              }
            }
            inside = false;
          } else {
            _emberDebug.assert(unbalancedNestedError, false);
          }
          break;
      }
    }
    if (inside) {
      _emberDebug.assert(unbalancedNestedError, false);
    }

    for (var i = 0; i < properties.length; i++) {
      callback(properties[i].replace(END_WITH_EACH_REGEX, '.[]'));
    }
  }
});
enifed('ember-metal/get_properties', ['exports', 'ember-metal/property_get'], function (exports, _emberMetalProperty_get) {
  'use strict';

  exports.default = getProperties;

  /**
    To get multiple properties at once, call `Ember.getProperties`
    with an object followed by a list of strings or an array:
  
    ```javascript
    Ember.getProperties(record, 'firstName', 'lastName', 'zipCode');
    // { firstName: 'John', lastName: 'Doe', zipCode: '10011' }
    ```
  
    is equivalent to:
  
    ```javascript
    Ember.getProperties(record, ['firstName', 'lastName', 'zipCode']);
    // { firstName: 'John', lastName: 'Doe', zipCode: '10011' }
    ```
  
    @method getProperties
    @for Ember
    @param {Object} obj
    @param {String...|Array} list of keys to get
    @return {Object}
    @public
  */

  function getProperties(obj) {
    var ret = {};
    var propertyNames = arguments;
    var i = 1;

    if (arguments.length === 2 && Array.isArray(arguments[1])) {
      i = 0;
      propertyNames = arguments[1];
    }
    for (; i < propertyNames.length; i++) {
      ret[propertyNames[i]] = _emberMetalProperty_get.get(obj, propertyNames[i]);
    }
    return ret;
  }
});
enifed('ember-metal/index', ['exports', 'ember-metal/core', 'ember-metal/computed', 'ember-metal/alias', 'ember-metal/merge', 'ember-metal/deprecate_property', 'ember-metal/instrumentation', 'ember-metal/error_handler', 'ember-metal/meta', 'ember-metal/cache', 'ember-metal/property_get', 'ember-metal/property_set', 'ember-metal/weak_map', 'ember-metal/events', 'ember-metal/is_none', 'ember-metal/is_empty', 'ember-metal/is_blank', 'ember-metal/is_present', 'ember-metal/run_loop', 'ember-metal/observer_set', 'ember-metal/property_events', 'ember-metal/properties', 'ember-metal/watch_key', 'ember-metal/chains', 'ember-metal/watch_path', 'ember-metal/watching', 'ember-metal/libraries', 'ember-metal/map', 'ember-metal/get_properties', 'ember-metal/set_properties', 'ember-metal/expand_properties', 'ember-metal/observer', 'ember-metal/mixin', 'ember-metal/binding', 'ember-metal/path_cache', 'ember-metal/injected_property', 'ember-metal/tags', 'ember-metal/replace', 'ember-metal/transaction', 'ember-metal/is_proxy', 'ember-metal/descriptor'], function (exports, _emberMetalCore, _emberMetalComputed, _emberMetalAlias, _emberMetalMerge, _emberMetalDeprecate_property, _emberMetalInstrumentation, _emberMetalError_handler, _emberMetalMeta, _emberMetalCache, _emberMetalProperty_get, _emberMetalProperty_set, _emberMetalWeak_map, _emberMetalEvents, _emberMetalIs_none, _emberMetalIs_empty, _emberMetalIs_blank, _emberMetalIs_present, _emberMetalRun_loop, _emberMetalObserver_set, _emberMetalProperty_events, _emberMetalProperties, _emberMetalWatch_key, _emberMetalChains, _emberMetalWatch_path, _emberMetalWatching, _emberMetalLibraries, _emberMetalMap, _emberMetalGet_properties, _emberMetalSet_properties, _emberMetalExpand_properties, _emberMetalObserver, _emberMetalMixin, _emberMetalBinding, _emberMetalPath_cache, _emberMetalInjected_property, _emberMetalTags, _emberMetalReplace, _emberMetalTransaction, _emberMetalIs_proxy, _emberMetalDescriptor) {
  /**
  @module ember
  @submodule ember-metal
  */

  'use strict';

  exports.default = _emberMetalCore.default;
  // reexports
  exports.computed = _emberMetalComputed.default;
  exports.cacheFor = _emberMetalComputed.cacheFor;
  exports.ComputedProperty = _emberMetalComputed.ComputedProperty;
  exports.alias = _emberMetalAlias.default;
  exports.merge = _emberMetalMerge.default;
  exports.deprecateProperty = _emberMetalDeprecate_property.deprecateProperty;
  exports.instrument = _emberMetalInstrumentation.instrument;
  exports.flaggedInstrument = _emberMetalInstrumentation.flaggedInstrument;
  exports._instrumentStart = _emberMetalInstrumentation._instrumentStart;
  exports.instrumentationReset = _emberMetalInstrumentation.reset;
  exports.instrumentationSubscribe = _emberMetalInstrumentation.subscribe;
  exports.instrumentationUnsubscribe = _emberMetalInstrumentation.unsubscribe;
  exports.getOnerror = _emberMetalError_handler.getOnerror;
  exports.setOnerror = _emberMetalError_handler.setOnerror;
  exports.dispatchError = _emberMetalError_handler.dispatchError;
  exports.setDispatchOverride = _emberMetalError_handler.setDispatchOverride;
  exports.META_DESC = _emberMetalMeta.META_DESC;
  exports.meta = _emberMetalMeta.meta;
  exports.peekMeta = _emberMetalMeta.peekMeta;
  exports.Cache = _emberMetalCache.default;
  exports._getPath = _emberMetalProperty_get._getPath;
  exports.get = _emberMetalProperty_get.get;
  exports.getWithDefault = _emberMetalProperty_get.getWithDefault;
  exports.set = _emberMetalProperty_set.set;
  exports.trySet = _emberMetalProperty_set.trySet;
  exports.WeakMap = _emberMetalWeak_map.default;
  exports.accumulateListeners = _emberMetalEvents.accumulateListeners;
  exports.addListener = _emberMetalEvents.addListener;
  exports.hasListeners = _emberMetalEvents.hasListeners;
  exports.listenersFor = _emberMetalEvents.listenersFor;
  exports.on = _emberMetalEvents.on;
  exports.removeListener = _emberMetalEvents.removeListener;
  exports.sendEvent = _emberMetalEvents.sendEvent;
  exports.suspendListener = _emberMetalEvents.suspendListener;
  exports.suspendListeners = _emberMetalEvents.suspendListeners;
  exports.watchedEvents = _emberMetalEvents.watchedEvents;
  exports.isNone = _emberMetalIs_none.default;
  exports.isEmpty = _emberMetalIs_empty.default;
  exports.isBlank = _emberMetalIs_blank.default;
  exports.isPresent = _emberMetalIs_present.default;
  exports.run = _emberMetalRun_loop.default;
  exports.ObserverSet = _emberMetalObserver_set.default;
  exports.beginPropertyChanges = _emberMetalProperty_events.beginPropertyChanges;
  exports.changeProperties = _emberMetalProperty_events.changeProperties;
  exports.endPropertyChanges = _emberMetalProperty_events.endPropertyChanges;
  exports.overrideChains = _emberMetalProperty_events.overrideChains;
  exports.propertyDidChange = _emberMetalProperty_events.propertyDidChange;
  exports.propertyWillChange = _emberMetalProperty_events.propertyWillChange;
  exports.PROPERTY_DID_CHANGE = _emberMetalProperty_events.PROPERTY_DID_CHANGE;
  exports.defineProperty = _emberMetalProperties.defineProperty;
  exports.Descriptor = _emberMetalProperties.Descriptor;
  exports._hasCachedComputedProperties = _emberMetalProperties._hasCachedComputedProperties;
  exports.watchKey = _emberMetalWatch_key.watchKey;
  exports.unwatchKey = _emberMetalWatch_key.unwatchKey;
  exports.ChainNode = _emberMetalChains.ChainNode;
  exports.finishChains = _emberMetalChains.finishChains;
  exports.removeChainWatcher = _emberMetalChains.removeChainWatcher;
  exports.watchPath = _emberMetalWatch_path.watchPath;
  exports.unwatchPath = _emberMetalWatch_path.unwatchPath;
  exports.destroy = _emberMetalWatching.destroy;
  exports.isWatching = _emberMetalWatching.isWatching;
  exports.unwatch = _emberMetalWatching.unwatch;
  exports.watch = _emberMetalWatching.watch;
  exports.watcherCount = _emberMetalWatching.watcherCount;
  exports.libraries = _emberMetalLibraries.default;
  exports.Map = _emberMetalMap.Map;
  exports.MapWithDefault = _emberMetalMap.MapWithDefault;
  exports.OrderedSet = _emberMetalMap.OrderedSet;
  exports.getProperties = _emberMetalGet_properties.default;
  exports.setProperties = _emberMetalSet_properties.default;
  exports.expandProperties = _emberMetalExpand_properties.default;
  exports._suspendObserver = _emberMetalObserver._suspendObserver;
  exports._suspendObservers = _emberMetalObserver._suspendObservers;
  exports.addObserver = _emberMetalObserver.addObserver;
  exports.observersFor = _emberMetalObserver.observersFor;
  exports.removeObserver = _emberMetalObserver.removeObserver;
  exports._addBeforeObserver = _emberMetalObserver._addBeforeObserver;
  exports._removeBeforeObserver = _emberMetalObserver._removeBeforeObserver;
  exports.Mixin = _emberMetalMixin.Mixin;
  exports.aliasMethod = _emberMetalMixin.aliasMethod;
  exports._immediateObserver = _emberMetalMixin._immediateObserver;
  exports._beforeObserver = _emberMetalMixin._beforeObserver;
  exports.mixin = _emberMetalMixin.mixin;
  exports.observer = _emberMetalMixin.observer;
  exports.required = _emberMetalMixin.required;
  exports.REQUIRED = _emberMetalMixin.REQUIRED;
  exports.hasUnprocessedMixins = _emberMetalMixin.hasUnprocessedMixins;
  exports.clearUnprocessedMixins = _emberMetalMixin.clearUnprocessedMixins;
  exports.detectBinding = _emberMetalMixin.detectBinding;
  exports.Binding = _emberMetalBinding.Binding;
  exports.bind = _emberMetalBinding.bind;
  exports.isGlobalPath = _emberMetalPath_cache.isGlobalPath;
  exports.InjectedProperty = _emberMetalInjected_property.default;
  exports.setHasViews = _emberMetalTags.setHasViews;
  exports.tagForProperty = _emberMetalTags.tagForProperty;
  exports.tagFor = _emberMetalTags.tagFor;
  exports.markObjectAsDirty = _emberMetalTags.markObjectAsDirty;
  exports.replace = _emberMetalReplace.default;
  exports.runInTransaction = _emberMetalTransaction.default;
  exports.didRender = _emberMetalTransaction.didRender;
  exports.assertNotRendered = _emberMetalTransaction.assertNotRendered;
  exports.isProxy = _emberMetalIs_proxy.isProxy;
  exports.descriptor = _emberMetalDescriptor.default;
});
enifed('ember-metal/injected_property', ['exports', 'ember-utils', 'ember-debug', 'ember-metal/computed', 'ember-metal/alias', 'ember-metal/properties'], function (exports, _emberUtils, _emberDebug, _emberMetalComputed, _emberMetalAlias, _emberMetalProperties) {
  'use strict';

  exports.default = InjectedProperty;

  /**
    Read-only property that returns the result of a container lookup.
  
    @class InjectedProperty
    @namespace Ember
    @constructor
    @param {String} type The container type the property will lookup
    @param {String} name (optional) The name the property will lookup, defaults
           to the property's name
    @private
  */

  function InjectedProperty(type, name) {
    this.type = type;
    this.name = name;

    this._super$Constructor(injectedPropertyGet);
    AliasedPropertyPrototype.oneWay.call(this);
  }

  function injectedPropertyGet(keyName) {
    var desc = this[keyName];
    var owner = _emberUtils.getOwner(this) || this.container; // fallback to `container` for backwards compat

    _emberDebug.assert('InjectedProperties should be defined with the Ember.inject computed property macros.', desc && desc.isDescriptor && desc.type);
    _emberDebug.assert('Attempting to lookup an injected property on an object without a container, ensure that the object was instantiated via a container.', owner);

    return owner.lookup(desc.type + ':' + (desc.name || keyName));
  }

  InjectedProperty.prototype = Object.create(_emberMetalProperties.Descriptor.prototype);

  var InjectedPropertyPrototype = InjectedProperty.prototype;
  var ComputedPropertyPrototype = _emberMetalComputed.ComputedProperty.prototype;
  var AliasedPropertyPrototype = _emberMetalAlias.AliasedProperty.prototype;

  InjectedPropertyPrototype._super$Constructor = _emberMetalComputed.ComputedProperty;

  InjectedPropertyPrototype.get = ComputedPropertyPrototype.get;
  InjectedPropertyPrototype.readOnly = ComputedPropertyPrototype.readOnly;
  InjectedPropertyPrototype.teardown = ComputedPropertyPrototype.teardown;
});
enifed('ember-metal/instrumentation', ['exports', 'ember-environment', 'ember-debug'], function (exports, _emberEnvironment, _emberDebug) {
  /* eslint no-console:off */
  /* global console */

  'use strict';

  exports.instrument = instrument;
  exports._instrumentStart = _instrumentStart;
  exports.subscribe = subscribe;
  exports.unsubscribe = unsubscribe;
  exports.reset = reset;

  /**
    The purpose of the Ember Instrumentation module is
    to provide efficient, general-purpose instrumentation
    for Ember.
  
    Subscribe to a listener by using `Ember.subscribe`:
  
    ```javascript
    Ember.subscribe("render", {
      before(name, timestamp, payload) {
  
      },
  
      after(name, timestamp, payload) {
  
      }
    });
    ```
  
    If you return a value from the `before` callback, that same
    value will be passed as a fourth parameter to the `after`
    callback.
  
    Instrument a block of code by using `Ember.instrument`:
  
    ```javascript
    Ember.instrument("render.handlebars", payload, function() {
      // rendering logic
    }, binding);
    ```
  
    Event names passed to `Ember.instrument` are namespaced
    by periods, from more general to more specific. Subscribers
    can listen for events by whatever level of granularity they
    are interested in.
  
    In the above example, the event is `render.handlebars`,
    and the subscriber listened for all events beginning with
    `render`. It would receive callbacks for events named
    `render`, `render.handlebars`, `render.container`, or
    even `render.handlebars.layout`.
  
    @class Instrumentation
    @namespace Ember
    @static
    @private
  */
  var subscribers = [];
  exports.subscribers = subscribers;
  var cache = {};

  function populateListeners(name) {
    var listeners = [];
    var subscriber = undefined;

    for (var i = 0; i < subscribers.length; i++) {
      subscriber = subscribers[i];
      if (subscriber.regex.test(name)) {
        listeners.push(subscriber.object);
      }
    }

    cache[name] = listeners;
    return listeners;
  }

  var time = (function () {
    var perf = 'undefined' !== typeof window ? window.performance || {} : {};
    var fn = perf.now || perf.mozNow || perf.webkitNow || perf.msNow || perf.oNow;
    // fn.bind will be available in all the browsers that support the advanced window.performance... ;-)
    return fn ? fn.bind(perf) : function () {
      return +new Date();
    };
  })();

  /**
    Notifies event's subscribers, calls `before` and `after` hooks.
  
    @method instrument
    @namespace Ember.Instrumentation
  
    @param {String} [name] Namespaced event name.
    @param {Object} _payload
    @param {Function} callback Function that you're instrumenting.
    @param {Object} binding Context that instrument function is called with.
    @private
  */

  function instrument(name, _payload, callback, binding) {
    if (arguments.length <= 3 && typeof _payload === 'function') {
      binding = callback;
      callback = _payload;
      _payload = undefined;
    }
    if (subscribers.length === 0) {
      return callback.call(binding);
    }
    var payload = _payload || {};
    var finalizer = _instrumentStart(name, function () {
      return payload;
    });

    if (finalizer) {
      return withFinalizer(callback, finalizer, payload, binding);
    } else {
      return callback.call(binding);
    }
  }

  var flaggedInstrument = undefined;
  if (false) {
    exports.flaggedInstrument = flaggedInstrument = instrument;
  } else {
    exports.flaggedInstrument = flaggedInstrument = function (name, payload, callback) {
      return callback();
    };
  }
  exports.flaggedInstrument = flaggedInstrument;

  function withFinalizer(callback, finalizer, payload, binding) {
    var result = undefined;
    try {
      result = callback.call(binding);
    } catch (e) {
      payload.exception = e;
      result = payload;
    } finally {
      finalizer();
    }
    return result;
  }

  function NOOP() {}

  // private for now

  function _instrumentStart(name, _payload, _payloadParam) {
    if (subscribers.length === 0) {
      return NOOP;
    }

    var listeners = cache[name];

    if (!listeners) {
      listeners = populateListeners(name);
    }

    if (listeners.length === 0) {
      return NOOP;
    }

    var payload = _payload(_payloadParam);

    var STRUCTURED_PROFILE = _emberEnvironment.ENV.STRUCTURED_PROFILE;
    var timeName = undefined;
    if (STRUCTURED_PROFILE) {
      timeName = name + ': ' + payload.object;
      console.time(timeName);
    }

    var beforeValues = new Array(listeners.length);
    var i = undefined,
        listener = undefined;
    var timestamp = time();
    for (i = 0; i < listeners.length; i++) {
      listener = listeners[i];
      beforeValues[i] = listener.before(name, timestamp, payload);
    }

    return function _instrumentEnd() {
      var i = undefined,
          listener = undefined;
      var timestamp = time();
      for (i = 0; i < listeners.length; i++) {
        listener = listeners[i];
        if (typeof listener.after === 'function') {
          listener.after(name, timestamp, payload, beforeValues[i]);
        }
      }

      if (STRUCTURED_PROFILE) {
        console.timeEnd(timeName);
      }
    };
  }

  /**
    Subscribes to a particular event or instrumented block of code.
  
    @method subscribe
    @namespace Ember.Instrumentation
  
    @param {String} [pattern] Namespaced event name.
    @param {Object} [object] Before and After hooks.
  
    @return {Subscriber}
    @private
  */

  function subscribe(pattern, object) {
    var paths = pattern.split('.');
    var path = undefined;
    var regex = [];

    for (var i = 0; i < paths.length; i++) {
      path = paths[i];
      if (path === '*') {
        regex.push('[^\\.]*');
      } else {
        regex.push(path);
      }
    }

    regex = regex.join('\\.');
    regex = regex + '(\\..*)?';

    var subscriber = {
      pattern: pattern,
      regex: new RegExp('^' + regex + '$'),
      object: object
    };

    subscribers.push(subscriber);
    cache = {};

    return subscriber;
  }

  /**
    Unsubscribes from a particular event or instrumented block of code.
  
    @method unsubscribe
    @namespace Ember.Instrumentation
  
    @param {Object} [subscriber]
    @private
  */

  function unsubscribe(subscriber) {
    var index = undefined;

    for (var i = 0; i < subscribers.length; i++) {
      if (subscribers[i] === subscriber) {
        index = i;
      }
    }

    subscribers.splice(index, 1);
    cache = {};
  }

  /**
    Resets `Ember.Instrumentation` by flushing list of subscribers.
  
    @method reset
    @namespace Ember.Instrumentation
    @private
  */

  function reset() {
    subscribers.length = 0;
    cache = {};
  }
});
enifed('ember-metal/is_blank', ['exports', 'ember-metal/is_empty'], function (exports, _emberMetalIs_empty) {
  'use strict';

  exports.default = isBlank;

  /**
    A value is blank if it is empty or a whitespace string.
  
    ```javascript
    Ember.isBlank();                // true
    Ember.isBlank(null);            // true
    Ember.isBlank(undefined);       // true
    Ember.isBlank('');              // true
    Ember.isBlank([]);              // true
    Ember.isBlank('\n\t');          // true
    Ember.isBlank('  ');            // true
    Ember.isBlank({});              // false
    Ember.isBlank('\n\t Hello');    // false
    Ember.isBlank('Hello world');   // false
    Ember.isBlank([1,2,3]);         // false
    ```
  
    @method isBlank
    @for Ember
    @param {Object} obj Value to test
    @return {Boolean}
    @since 1.5.0
    @public
  */

  function isBlank(obj) {
    return _emberMetalIs_empty.default(obj) || typeof obj === 'string' && obj.match(/\S/) === null;
  }
});
enifed('ember-metal/is_empty', ['exports', 'ember-metal/property_get', 'ember-metal/is_none'], function (exports, _emberMetalProperty_get, _emberMetalIs_none) {
  'use strict';

  exports.default = isEmpty;

  /**
    Verifies that a value is `null` or an empty string, empty array,
    or empty function.
  
    Constrains the rules on `Ember.isNone` by returning true for empty
    string and empty arrays.
  
    ```javascript
    Ember.isEmpty();                // true
    Ember.isEmpty(null);            // true
    Ember.isEmpty(undefined);       // true
    Ember.isEmpty('');              // true
    Ember.isEmpty([]);              // true
    Ember.isEmpty({});              // false
    Ember.isEmpty('Adam Hawkins');  // false
    Ember.isEmpty([0,1,2]);         // false
    Ember.isEmpty('\n\t');          // false
    Ember.isEmpty('  ');            // false
    ```
  
    @method isEmpty
    @for Ember
    @param {Object} obj Value to test
    @return {Boolean}
    @public
  */

  function isEmpty(obj) {
    var none = _emberMetalIs_none.default(obj);
    if (none) {
      return none;
    }

    if (typeof obj.size === 'number') {
      return !obj.size;
    }

    var objectType = typeof obj;

    if (objectType === 'object') {
      var size = _emberMetalProperty_get.get(obj, 'size');
      if (typeof size === 'number') {
        return !size;
      }
    }

    if (typeof obj.length === 'number' && objectType !== 'function') {
      return !obj.length;
    }

    if (objectType === 'object') {
      var _length = _emberMetalProperty_get.get(obj, 'length');
      if (typeof _length === 'number') {
        return !_length;
      }
    }

    return false;
  }
});
enifed("ember-metal/is_none", ["exports"], function (exports) {
  /**
    Returns true if the passed value is null or undefined. This avoids errors
    from JSLint complaining about use of ==, which can be technically
    confusing.
  
    ```javascript
    Ember.isNone();              // true
    Ember.isNone(null);          // true
    Ember.isNone(undefined);     // true
    Ember.isNone('');            // false
    Ember.isNone([]);            // false
    Ember.isNone(function() {}); // false
    ```
  
    @method isNone
    @for Ember
    @param {Object} obj Value to test
    @return {Boolean}
    @public
  */
  "use strict";

  exports.default = isNone;

  function isNone(obj) {
    return obj === null || obj === undefined;
  }
});
enifed('ember-metal/is_present', ['exports', 'ember-metal/is_blank'], function (exports, _emberMetalIs_blank) {
  'use strict';

  exports.default = isPresent;

  /**
    A value is present if it not `isBlank`.
  
    ```javascript
    Ember.isPresent();                // false
    Ember.isPresent(null);            // false
    Ember.isPresent(undefined);       // false
    Ember.isPresent('');              // false
    Ember.isPresent('  ');            // false
    Ember.isPresent('\n\t');          // false
    Ember.isPresent([]);              // false
    Ember.isPresent({ length: 0 })    // false
    Ember.isPresent(false);           // true
    Ember.isPresent(true);            // true
    Ember.isPresent('string');        // true
    Ember.isPresent(0);               // true
    Ember.isPresent(function() {})    // true
    Ember.isPresent({});              // true
    Ember.isPresent(false);           // true
    Ember.isPresent('\n\t Hello');    // true
    Ember.isPresent([1,2,3]);         // true
    ```
  
    @method isPresent
    @for Ember
    @param {Object} obj Value to test
    @return {Boolean}
    @since 1.8.0
    @public
  */

  function isPresent(obj) {
    return !_emberMetalIs_blank.default(obj);
  }
});
enifed('ember-metal/is_proxy', ['exports', 'ember-metal/meta'], function (exports, _emberMetalMeta) {
  'use strict';

  exports.isProxy = isProxy;

  function isProxy(value) {
    if (typeof value === 'object' && value) {
      var meta = _emberMetalMeta.peekMeta(value);
      return meta && meta.isProxy();
    }

    return false;
  }
});
enifed('ember-metal/libraries', ['exports', 'ember-debug'], function (exports, _emberDebug) {
  'use strict';

  /**
    Helper class that allows you to register your library with Ember.
  
    Singleton created at `Ember.libraries`.
  
    @class Libraries
    @constructor
    @private
  */

  var Libraries = (function () {
    function Libraries() {
      babelHelpers.classCallCheck(this, Libraries);

      this._registry = [];
      this._coreLibIndex = 0;
    }

    Libraries.prototype.isRegistered = function isRegistered(name) {
      return !!this._getLibraryByName(name);
    };

    return Libraries;
  })();

  exports.Libraries = Libraries;

  Libraries.prototype = {
    constructor: Libraries,

    _getLibraryByName: function (name) {
      var libs = this._registry;
      var count = libs.length;

      for (var i = 0; i < count; i++) {
        if (libs[i].name === name) {
          return libs[i];
        }
      }
    },

    register: function (name, version, isCoreLibrary) {
      var index = this._registry.length;

      if (!this._getLibraryByName(name)) {
        if (isCoreLibrary) {
          index = this._coreLibIndex++;
        }
        this._registry.splice(index, 0, { name: name, version: version });
      } else {
        _emberDebug.warn('Library "' + name + '" is already registered with Ember.', false, { id: 'ember-metal.libraries-register' });
      }
    },

    registerCoreLibrary: function (name, version) {
      this.register(name, version, true);
    },

    deRegister: function (name) {
      var lib = this._getLibraryByName(name);
      var index = undefined;

      if (lib) {
        index = this._registry.indexOf(lib);
        this._registry.splice(index, 1);
      }
    }
  };

  if (false) {
    Libraries.prototype.isRegistered = function (name) {
      return !!this._getLibraryByName(name);
    };
  }

  exports.default = new Libraries();
});
enifed('ember-metal/map', ['exports', 'ember-utils'], function (exports, _emberUtils) {
  /**
  @module ember
  @submodule ember-metal
  */

  /*
    JavaScript (before ES6) does not have a Map implementation. Objects,
    which are often used as dictionaries, may only have Strings as keys.
  
    Because Ember has a way to get a unique identifier for every object
    via `Ember.guidFor`, we can implement a performant Map with arbitrary
    keys. Because it is commonly used in low-level bookkeeping, Map is
    implemented as a pure JavaScript object for performance.
  
    This implementation follows the current iteration of the ES6 proposal for
    maps (http://wiki.ecmascript.org/doku.php?id=harmony:simple_maps_and_sets),
    with one exception:  as we do not have the luxury of in-VM iteration, we implement a
    forEach method for iteration.
  
    Map is mocked out to look like an Ember object, so you can do
    `Ember.Map.create()` for symmetry with other Ember classes.
  */
  'use strict';

  function missingFunction(fn) {
    throw new TypeError(Object.prototype.toString.call(fn) + ' is not a function');
  }

  function missingNew(name) {
    throw new TypeError('Constructor ' + name + ' requires \'new\'');
  }

  function copyNull(obj) {
    var output = Object.create(null);

    for (var prop in obj) {
      // hasOwnPropery is not needed because obj is Object.create(null);
      output[prop] = obj[prop];
    }

    return output;
  }

  function copyMap(original, newObject) {
    var keys = original._keys.copy();
    var values = copyNull(original._values);

    newObject._keys = keys;
    newObject._values = values;
    newObject.size = original.size;

    return newObject;
  }

  /**
    This class is used internally by Ember and Ember Data.
    Please do not use it at this time. We plan to clean it up
    and add many tests soon.
  
    @class OrderedSet
    @namespace Ember
    @constructor
    @private
  */
  function OrderedSet() {
    if (this instanceof OrderedSet) {
      this.clear();
      this._silenceRemoveDeprecation = false;
    } else {
      missingNew('OrderedSet');
    }
  }

  /**
    @method create
    @static
    @return {Ember.OrderedSet}
    @private
  */
  OrderedSet.create = function () {
    var Constructor = this;

    return new Constructor();
  };

  OrderedSet.prototype = {
    constructor: OrderedSet,
    /**
      @method clear
      @private
    */
    clear: function () {
      this.presenceSet = Object.create(null);
      this.list = [];
      this.size = 0;
    },

    /**
      @method add
      @param obj
      @param guid (optional, and for internal use)
      @return {Ember.OrderedSet}
      @private
    */
    add: function (obj, _guid) {
      var guid = _guid || _emberUtils.guidFor(obj);
      var presenceSet = this.presenceSet;
      var list = this.list;

      if (presenceSet[guid] !== true) {
        presenceSet[guid] = true;
        this.size = list.push(obj);
      }

      return this;
    },

    /**
      @since 1.8.0
      @method delete
      @param obj
      @param _guid (optional and for internal use only)
      @return {Boolean}
      @private
    */
    delete: function (obj, _guid) {
      var guid = _guid || _emberUtils.guidFor(obj);
      var presenceSet = this.presenceSet;
      var list = this.list;

      if (presenceSet[guid] === true) {
        delete presenceSet[guid];
        var index = list.indexOf(obj);
        if (index > -1) {
          list.splice(index, 1);
        }
        this.size = list.length;
        return true;
      } else {
        return false;
      }
    },

    /**
      @method isEmpty
      @return {Boolean}
      @private
    */
    isEmpty: function () {
      return this.size === 0;
    },

    /**
      @method has
      @param obj
      @return {Boolean}
      @private
    */
    has: function (obj) {
      if (this.size === 0) {
        return false;
      }

      var guid = _emberUtils.guidFor(obj);
      var presenceSet = this.presenceSet;

      return presenceSet[guid] === true;
    },

    /**
      @method forEach
      @param {Function} fn
      @param self
      @private
    */
    forEach: function (fn /*, ...thisArg*/) {
      if (typeof fn !== 'function') {
        missingFunction(fn);
      }

      if (this.size === 0) {
        return;
      }

      var list = this.list;

      if (arguments.length === 2) {
        for (var i = 0; i < list.length; i++) {
          fn.call(arguments[1], list[i]);
        }
      } else {
        for (var i = 0; i < list.length; i++) {
          fn(list[i]);
        }
      }
    },

    /**
      @method toArray
      @return {Array}
      @private
    */
    toArray: function () {
      return this.list.slice();
    },

    /**
      @method copy
      @return {Ember.OrderedSet}
      @private
    */
    copy: function () {
      var Constructor = this.constructor;
      var set = new Constructor();

      set._silenceRemoveDeprecation = this._silenceRemoveDeprecation;
      set.presenceSet = copyNull(this.presenceSet);
      set.list = this.toArray();
      set.size = this.size;

      return set;
    }
  };

  /**
    A Map stores values indexed by keys. Unlike JavaScript's
    default Objects, the keys of a Map can be any JavaScript
    object.
  
    Internally, a Map has two data structures:
  
    1. `keys`: an OrderedSet of all of the existing keys
    2. `values`: a JavaScript Object indexed by the `Ember.guidFor(key)`
  
    When a key/value pair is added for the first time, we
    add the key to the `keys` OrderedSet, and create or
    replace an entry in `values`. When an entry is deleted,
    we delete its entry in `keys` and `values`.
  
    @class Map
    @namespace Ember
    @private
    @constructor
  */
  function Map() {
    if (this instanceof Map) {
      this._keys = OrderedSet.create();
      this._keys._silenceRemoveDeprecation = true;
      this._values = Object.create(null);
      this.size = 0;
    } else {
      missingNew('Map');
    }
  }

  /**
    @method create
    @static
    @private
  */
  Map.create = function () {
    var Constructor = this;
    return new Constructor();
  };

  Map.prototype = {
    constructor: Map,

    /**
      This property will change as the number of objects in the map changes.
       @since 1.8.0
      @property size
      @type number
      @default 0
      @private
    */
    size: 0,

    /**
      Retrieve the value associated with a given key.
       @method get
      @param {*} key
      @return {*} the value associated with the key, or `undefined`
      @private
    */
    get: function (key) {
      if (this.size === 0) {
        return;
      }

      var values = this._values;
      var guid = _emberUtils.guidFor(key);

      return values[guid];
    },

    /**
      Adds a value to the map. If a value for the given key has already been
      provided, the new value will replace the old value.
       @method set
      @param {*} key
      @param {*} value
      @return {Ember.Map}
      @private
    */
    set: function (key, value) {
      var keys = this._keys;
      var values = this._values;
      var guid = _emberUtils.guidFor(key);

      // ensure we don't store -0
      var k = key === -0 ? 0 : key;

      keys.add(k, guid);

      values[guid] = value;

      this.size = keys.size;

      return this;
    },

    /**
      Removes a value from the map for an associated key.
       @since 1.8.0
      @method delete
      @param {*} key
      @return {Boolean} true if an item was removed, false otherwise
      @private
    */
    delete: function (key) {
      if (this.size === 0) {
        return false;
      }
      // don't use ES6 "delete" because it will be annoying
      // to use in browsers that are not ES6 friendly;
      var keys = this._keys;
      var values = this._values;
      var guid = _emberUtils.guidFor(key);

      if (keys.delete(key, guid)) {
        delete values[guid];
        this.size = keys.size;
        return true;
      } else {
        return false;
      }
    },

    /**
      Check whether a key is present.
       @method has
      @param {*} key
      @return {Boolean} true if the item was present, false otherwise
      @private
    */
    has: function (key) {
      return this._keys.has(key);
    },

    /**
      Iterate over all the keys and values. Calls the function once
      for each key, passing in value, key, and the map being iterated over,
      in that order.
       The keys are guaranteed to be iterated over in insertion order.
       @method forEach
      @param {Function} callback
      @param {*} self if passed, the `this` value inside the
        callback. By default, `this` is the map.
      @private
    */
    forEach: function (callback /*, ...thisArg*/) {
      if (typeof callback !== 'function') {
        missingFunction(callback);
      }

      if (this.size === 0) {
        return;
      }

      var map = this;
      var cb = undefined,
          thisArg = undefined;

      if (arguments.length === 2) {
        thisArg = arguments[1];
        cb = function (key) {
          return callback.call(thisArg, map.get(key), key, map);
        };
      } else {
        cb = function (key) {
          return callback(map.get(key), key, map);
        };
      }

      this._keys.forEach(cb);
    },

    /**
      @method clear
      @private
    */
    clear: function () {
      this._keys.clear();
      this._values = Object.create(null);
      this.size = 0;
    },

    /**
      @method copy
      @return {Ember.Map}
      @private
    */
    copy: function () {
      return copyMap(this, new Map());
    }
  };

  /**
    @class MapWithDefault
    @namespace Ember
    @extends Ember.Map
    @private
    @constructor
    @param [options]
      @param {*} [options.defaultValue]
  */
  function MapWithDefault(options) {
    this._super$constructor();
    this.defaultValue = options.defaultValue;
  }

  /**
    @method create
    @static
    @param [options]
      @param {*} [options.defaultValue]
    @return {Ember.MapWithDefault|Ember.Map} If options are passed, returns
      `Ember.MapWithDefault` otherwise returns `Ember.Map`
    @private
  */
  MapWithDefault.create = function (options) {
    if (options) {
      return new MapWithDefault(options);
    } else {
      return new Map();
    }
  };

  MapWithDefault.prototype = Object.create(Map.prototype);
  MapWithDefault.prototype.constructor = MapWithDefault;
  MapWithDefault.prototype._super$constructor = Map;
  MapWithDefault.prototype._super$get = Map.prototype.get;

  /**
    Retrieve the value associated with a given key.
  
    @method get
    @param {*} key
    @return {*} the value associated with the key, or the default value
    @private
  */
  MapWithDefault.prototype.get = function (key) {
    var hasValue = this.has(key);

    if (hasValue) {
      return this._super$get(key);
    } else {
      var defaultValue = this.defaultValue(key);
      this.set(key, defaultValue);
      return defaultValue;
    }
  };

  /**
    @method copy
    @return {Ember.MapWithDefault}
    @private
  */
  MapWithDefault.prototype.copy = function () {
    var Constructor = this.constructor;
    return copyMap(this, new Constructor({
      defaultValue: this.defaultValue
    }));
  };

  exports.default = Map;
  exports.OrderedSet = OrderedSet;
  exports.Map = Map;
  exports.MapWithDefault = MapWithDefault;
});
enifed('ember-metal/merge', ['exports'], function (exports) {
  /**
    Merge the contents of two objects together into the first object.
  
    ```javascript
    Ember.merge({ first: 'Tom' }, { last: 'Dale' }); // { first: 'Tom', last: 'Dale' }
    var a = { first: 'Yehuda' };
    var b = { last: 'Katz' };
    Ember.merge(a, b); // a == { first: 'Yehuda', last: 'Katz' }, b == { last: 'Katz' }
    ```
  
    @method merge
    @for Ember
    @param {Object} original The object to merge into
    @param {Object} updates The object to copy properties from
    @return {Object}
    @public
  */
  'use strict';

  exports.default = merge;

  function merge(original, updates) {
    if (!updates || typeof updates !== 'object') {
      return original;
    }

    var props = Object.keys(updates);
    var prop = undefined;

    for (var i = 0; i < props.length; i++) {
      prop = props[i];
      original[prop] = updates[prop];
    }

    return original;
  }
});
enifed('ember-metal/meta', ['exports', 'ember-utils', 'ember-metal/meta_listeners', 'ember-debug', 'ember-metal/chains', 'require'], function (exports, _emberUtils, _emberMetalMeta_listeners, _emberDebug, _emberMetalChains, _require) {
  'use strict';

  exports.deleteMeta = deleteMeta;
  exports.meta = meta;

  var counters = {
    peekCalls: 0,
    peekParentCalls: 0,
    peekPrototypeWalks: 0,
    setCalls: 0,
    deleteCalls: 0,
    metaCalls: 0,
    metaInstantiated: 0
  };

  /**
  @module ember-metal
  */

  /*
   This declares several meta-programmed members on the Meta class. Such
   meta!
  
   In general, the `readable` variants will give you an object (if it
   already exists) that you can read but should not modify. The
   `writable` variants will give you a mutable object, and they will
   create it if it didn't already exist.
  
   The following methods will get generated metaprogrammatically, and
   I'm including them here for greppability:
  
   writableCache, readableCache, writeWatching,
   peekWatching, clearWatching, writeMixins,
   peekMixins, clearMixins, writeBindings,
   peekBindings, clearBindings, writeValues,
   peekValues, clearValues, writeDeps, forEachInDeps
   writableChainWatchers, readableChainWatchers, writableChains,
   readableChains, writableTag, readableTag, writableTags,
   readableTags
  */
  var members = {
    cache: ownMap,
    weak: ownMap,
    watching: inheritedMap,
    mixins: inheritedMap,
    bindings: inheritedMap,
    values: inheritedMap,
    chainWatchers: ownCustomObject,
    chains: inheritedCustomObject,
    tag: ownCustomObject,
    tags: ownMap
  };

  // FLAGS
  var SOURCE_DESTROYING = 1 << 1;
  var SOURCE_DESTROYED = 1 << 2;
  var META_DESTROYED = 1 << 3;
  var IS_PROXY = 1 << 4;

  if (true || false) {
    members.lastRendered = ownMap;
    if (_require.has('ember-debug')) {
      //https://github.com/emberjs/ember.js/issues/14732
      members.lastRenderedReferenceMap = ownMap;
      members.lastRenderedTemplateMap = ownMap;
    }
  }

  var memberNames = Object.keys(members);
  var META_FIELD = '__ember_meta__';

  var Meta = (function () {
    function Meta(obj, parentMeta) {
      var _this = this;

      babelHelpers.classCallCheck(this, Meta);

      _emberDebug.runInDebug(function () {
        return counters.metaInstantiated++;
      });

      this._cache = undefined;
      this._weak = undefined;
      this._watching = undefined;
      this._mixins = undefined;
      this._bindings = undefined;
      this._values = undefined;
      this._deps = undefined;
      this._chainWatchers = undefined;
      this._chains = undefined;
      this._tag = undefined;
      this._tags = undefined;
      this._factory = undefined;

      // initial value for all flags right now is false
      // see FLAGS const for detailed list of flags used
      this._flags = 0;

      // used only internally
      this.source = obj;

      // when meta(obj).proto === obj, the object is intended to be only a
      // prototype and doesn't need to actually be observable itself
      this.proto = undefined;

      // The next meta in our inheritance chain. We (will) track this
      // explicitly instead of using prototypical inheritance because we
      // have detailed knowledge of how each property should really be
      // inherited, and we can optimize it much better than JS runtimes.
      this.parent = parentMeta;

      if (true || false) {
        this._lastRendered = undefined;
        _emberDebug.runInDebug(function () {
          _this._lastRenderedReferenceMap = undefined;
          _this._lastRenderedTemplateMap = undefined;
        });
      }

      this._initializeListeners();
    }

    Meta.prototype.isInitialized = function isInitialized(obj) {
      return this.proto !== obj;
    };

    Meta.prototype.destroy = function destroy() {
      if (this.isMetaDestroyed()) {
        return;
      }

      // remove chainWatchers to remove circular references that would prevent GC
      var nodes = undefined,
          key = undefined,
          nodeObject = undefined;
      var node = this.readableChains();
      if (node) {
        NODE_STACK.push(node);
        // process tree
        while (NODE_STACK.length > 0) {
          node = NODE_STACK.pop();
          // push children
          nodes = node._chains;
          if (nodes) {
            for (key in nodes) {
              if (nodes[key] !== undefined) {
                NODE_STACK.push(nodes[key]);
              }
            }
          }

          // remove chainWatcher in node object
          if (node._watching) {
            nodeObject = node._object;
            if (nodeObject) {
              var foreignMeta = peekMeta(nodeObject);
              // avoid cleaning up chain watchers when both current and
              // foreign objects are being destroyed
              // if both are being destroyed manual cleanup is not needed
              // as they will be GC'ed and no non-destroyed references will
              // be remaining
              if (foreignMeta && !foreignMeta.isSourceDestroying()) {
                _emberMetalChains.removeChainWatcher(nodeObject, node._key, node, foreignMeta);
              }
            }
          }
        }
      }

      this.setMetaDestroyed();
    };

    Meta.prototype.isSourceDestroying = function isSourceDestroying() {
      return (this._flags & SOURCE_DESTROYING) !== 0;
    };

    Meta.prototype.setSourceDestroying = function setSourceDestroying() {
      this._flags |= SOURCE_DESTROYING;
    };

    Meta.prototype.isSourceDestroyed = function isSourceDestroyed() {
      return (this._flags & SOURCE_DESTROYED) !== 0;
    };

    Meta.prototype.setSourceDestroyed = function setSourceDestroyed() {
      this._flags |= SOURCE_DESTROYED;
    };

    Meta.prototype.isMetaDestroyed = function isMetaDestroyed() {
      return (this._flags & META_DESTROYED) !== 0;
    };

    Meta.prototype.setMetaDestroyed = function setMetaDestroyed() {
      this._flags |= META_DESTROYED;
    };

    Meta.prototype.isProxy = function isProxy() {
      return (this._flags & IS_PROXY) !== 0;
    };

    Meta.prototype.setProxy = function setProxy() {
      this._flags |= IS_PROXY;
    };

    Meta.prototype._getOrCreateOwnMap = function _getOrCreateOwnMap(key) {
      return this[key] || (this[key] = Object.create(null));
    };

    Meta.prototype._getInherited = function _getInherited(key) {
      var pointer = this;
      while (pointer !== undefined) {
        var map = pointer[key];
        if (map) {
          return map;
        }
        pointer = pointer.parent;
      }
    };

    Meta.prototype._findInherited = function _findInherited(key, subkey) {
      var pointer = this;
      while (pointer !== undefined) {
        var map = pointer[key];
        if (map) {
          var value = map[subkey];
          if (value !== undefined) {
            return value;
          }
        }
        pointer = pointer.parent;
      }
    };

    // Implements a member that provides a lazily created map of maps,
    // with inheritance at both levels.

    Meta.prototype.writeDeps = function writeDeps(subkey, itemkey, value) {
      _emberDebug.assert('Cannot call writeDeps after the object is destroyed.', !this.isMetaDestroyed());

      var outerMap = this._getOrCreateOwnMap('_deps');
      var innerMap = outerMap[subkey];
      if (!innerMap) {
        innerMap = outerMap[subkey] = Object.create(null);
      }
      innerMap[itemkey] = value;
    };

    Meta.prototype.peekDeps = function peekDeps(subkey, itemkey) {
      var pointer = this;
      while (pointer !== undefined) {
        var map = pointer._deps;
        if (map) {
          var value = map[subkey];
          if (value) {
            var itemvalue = value[itemkey];
            if (itemvalue !== undefined) {
              return itemvalue;
            }
          }
        }
        pointer = pointer.parent;
      }
    };

    Meta.prototype.hasDeps = function hasDeps(subkey) {
      var pointer = this;
      while (pointer !== undefined) {
        if (pointer._deps && pointer._deps[subkey]) {
          return true;
        }
        pointer = pointer.parent;
      }
      return false;
    };

    Meta.prototype.forEachInDeps = function forEachInDeps(subkey, fn) {
      return this._forEachIn('_deps', subkey, fn);
    };

    Meta.prototype._forEachIn = function _forEachIn(key, subkey, fn) {
      var pointer = this;
      var seen = undefined;
      var calls = undefined;
      while (pointer !== undefined) {
        var map = pointer[key];
        if (map) {
          var innerMap = map[subkey];
          if (innerMap) {
            for (var innerKey in innerMap) {
              seen = seen || Object.create(null);
              if (!seen[innerKey]) {
                seen[innerKey] = true;
                calls = calls || [];
                calls.push([innerKey, innerMap[innerKey]]);
              }
            }
          }
        }
        pointer = pointer.parent;
      }
      if (calls) {
        for (var i = 0; i < calls.length; i++) {
          var _calls$i = calls[i];
          var innerKey = _calls$i[0];
          var value = _calls$i[1];

          fn(innerKey, value);
        }
      }
    };

    Meta.prototype.readInheritedValue = function readInheritedValue(key, subkey) {
      var internalKey = '_' + key;

      var pointer = this;

      while (pointer !== undefined) {
        var map = pointer[internalKey];
        if (map) {
          var value = map[subkey];
          if (value !== undefined || subkey in map) {
            return value;
          }
        }
        pointer = pointer.parent;
      }

      return UNDEFINED;
    };

    Meta.prototype.writeValue = function writeValue(obj, key, value) {
      var descriptor = _emberUtils.lookupDescriptor(obj, key);
      var isMandatorySetter = descriptor && descriptor.set && descriptor.set.isMandatorySetter;

      if (isMandatorySetter) {
        this.writeValues(key, value);
      } else {
        obj[key] = value;
      }
    };

    babelHelpers.createClass(Meta, [{
      key: 'factory',
      set: function (factory) {
        this._factory = factory;
      },
      get: function () {
        return this._factory;
      }
    }]);
    return Meta;
  })();

  exports.Meta = Meta;

  var NODE_STACK = [];

  for (var _name in _emberMetalMeta_listeners.protoMethods) {
    Meta.prototype[_name] = _emberMetalMeta_listeners.protoMethods[_name];
  }
  memberNames.forEach(function (name) {
    return members[name](name, Meta);
  });

  // Implements a member that is a lazily created, non-inheritable
  // POJO.
  function ownMap(name, Meta) {
    var key = memberProperty(name);
    var capitalized = capitalize(name);
    Meta.prototype['writable' + capitalized] = function () {
      return this._getOrCreateOwnMap(key);
    };
    Meta.prototype['readable' + capitalized] = function () {
      return this[key];
    };
  }

  // Implements a member that is a lazily created POJO with inheritable
  // values.
  function inheritedMap(name, Meta) {
    var key = memberProperty(name);
    var capitalized = capitalize(name);

    Meta.prototype['write' + capitalized] = function (subkey, value) {
      _emberDebug.assert('Cannot call write' + capitalized + ' after the object is destroyed.', !this.isMetaDestroyed());

      var map = this._getOrCreateOwnMap(key);
      map[subkey] = value;
    };

    Meta.prototype['peek' + capitalized] = function (subkey) {
      return this._findInherited(key, subkey);
    };

    Meta.prototype['forEach' + capitalized] = function (fn) {
      var pointer = this;
      var seen = undefined;
      while (pointer !== undefined) {
        var map = pointer[key];
        if (map) {
          for (var _key in map) {
            seen = seen || Object.create(null);
            if (!seen[_key]) {
              seen[_key] = true;
              fn(_key, map[_key]);
            }
          }
        }
        pointer = pointer.parent;
      }
    };

    Meta.prototype['clear' + capitalized] = function () {
      _emberDebug.assert('Cannot call clear' + capitalized + ' after the object is destroyed.', !this.isMetaDestroyed());

      this[key] = undefined;
    };

    Meta.prototype['deleteFrom' + capitalized] = function (subkey) {
      delete this._getOrCreateOwnMap(key)[subkey];
    };

    Meta.prototype['hasIn' + capitalized] = function (subkey) {
      return this._findInherited(key, subkey) !== undefined;
    };
  }

  var UNDEFINED = _emberUtils.symbol('undefined');

  exports.UNDEFINED = UNDEFINED;
  // Implements a member that provides a non-heritable, lazily-created
  // object using the method you provide.
  function ownCustomObject(name, Meta) {
    var key = memberProperty(name);
    var capitalized = capitalize(name);
    Meta.prototype['writable' + capitalized] = function (create) {
      _emberDebug.assert('Cannot call writable' + capitalized + ' after the object is destroyed.', !this.isMetaDestroyed());

      var ret = this[key];
      if (!ret) {
        ret = this[key] = create(this.source);
      }
      return ret;
    };
    Meta.prototype['readable' + capitalized] = function () {
      return this[key];
    };
  }

  // Implements a member that provides an inheritable, lazily-created
  // object using the method you provide. We will derived children from
  // their parents by calling your object's `copy()` method.
  function inheritedCustomObject(name, Meta) {
    var key = memberProperty(name);
    var capitalized = capitalize(name);
    Meta.prototype['writable' + capitalized] = function (create) {
      _emberDebug.assert('Cannot call writable' + capitalized + ' after the object is destroyed.', !this.isMetaDestroyed());

      var ret = this[key];
      if (!ret) {
        if (this.parent) {
          ret = this[key] = this.parent['writable' + capitalized](create).copy(this.source);
        } else {
          ret = this[key] = create(this.source);
        }
      }
      return ret;
    };
    Meta.prototype['readable' + capitalized] = function () {
      return this._getInherited(key);
    };
  }

  function memberProperty(name) {
    return '_' + name;
  }

  // there's a more general-purpose capitalize in ember-runtime, but we
  // don't want to make ember-metal depend on ember-runtime.
  function capitalize(name) {
    return name.replace(/^\w/, function (m) {
      return m.toUpperCase();
    });
  }

  var META_DESC = {
    writable: true,
    configurable: true,
    enumerable: false,
    value: null
  };

  exports.META_DESC = META_DESC;
  var EMBER_META_PROPERTY = {
    name: META_FIELD,
    descriptor: META_DESC
  };

  if (true) {
    Meta.prototype.readInheritedValue = function (key, subkey) {
      var internalKey = '_' + key;

      var pointer = this;

      while (pointer !== undefined) {
        var map = pointer[internalKey];
        if (map) {
          var value = map[subkey];
          if (value !== undefined || subkey in map) {
            return value;
          }
        }
        pointer = pointer.parent;
      }

      return UNDEFINED;
    };

    Meta.prototype.writeValue = function (obj, key, value) {
      var descriptor = _emberUtils.lookupDescriptor(obj, key);
      var isMandatorySetter = descriptor && descriptor.set && descriptor.set.isMandatorySetter;

      if (isMandatorySetter) {
        this.writeValues(key, value);
      } else {
        obj[key] = value;
      }
    };
  }

  var setMeta = undefined,
      peekMeta = undefined;

  // choose the one appropriate for given platform
  if (_emberUtils.HAS_NATIVE_WEAKMAP) {
    (function () {
      var getPrototypeOf = Object.getPrototypeOf;
      var metaStore = new WeakMap();

      exports.setMeta = setMeta = function WeakMap_setMeta(obj, meta) {
        _emberDebug.runInDebug(function () {
          return counters.setCalls++;
        });
        metaStore.set(obj, meta);
      };

      exports.peekMeta = peekMeta = function WeakMap_peekMeta(obj) {
        _emberDebug.runInDebug(function () {
          return counters.peekCalls++;
        });

        return metaStore.get(obj);
      };

      exports.peekMeta = peekMeta = function WeakMap_peekParentMeta(obj) {
        var pointer = obj;
        var meta = undefined;
        while (pointer) {
          meta = metaStore.get(pointer);
          // jshint loopfunc:true
          _emberDebug.runInDebug(function () {
            return counters.peekCalls++;
          });
          // stop if we find a `null` value, since
          // that means the meta was deleted
          // any other truthy value is a "real" meta
          if (meta === null || meta) {
            return meta;
          }

          pointer = getPrototypeOf(pointer);
          _emberDebug.runInDebug(function () {
            return counters.peakPrototypeWalks++;
          });
        }
      };
    })();
  } else {
    exports.setMeta = setMeta = function Fallback_setMeta(obj, meta) {
      // if `null` already, just set it to the new value
      // otherwise define property first
      if (obj[META_FIELD] !== null) {
        if (obj.__defineNonEnumerable) {
          obj.__defineNonEnumerable(EMBER_META_PROPERTY);
        } else {
          Object.defineProperty(obj, META_FIELD, META_DESC);
        }
      }

      obj[META_FIELD] = meta;
    };

    exports.peekMeta = peekMeta = function Fallback_peekMeta(obj) {
      return obj[META_FIELD];
    };
  }

  function deleteMeta(obj) {
    _emberDebug.runInDebug(function () {
      return counters.deleteCalls++;
    });

    var meta = peekMeta(obj);
    if (meta) {
      meta.destroy();
    }
  }

  /**
    Retrieves the meta hash for an object. If `writable` is true ensures the
    hash is writable for this object as well.
  
    The meta object contains information about computed property descriptors as
    well as any watched properties and other information. You generally will
    not access this information directly but instead work with higher level
    methods that manipulate this hash indirectly.
  
    @method meta
    @for Ember
    @private
  
    @param {Object} obj The object to retrieve meta for
    @param {Boolean} [writable=true] Pass `false` if you do not intend to modify
      the meta hash, allowing the method to avoid making an unnecessary copy.
    @return {Object} the meta hash for an object
  */

  function meta(obj) {
    _emberDebug.runInDebug(function () {
      return counters.metaCalls++;
    });

    var maybeMeta = peekMeta(obj);
    var parent = undefined;

    // remove this code, in-favor of explicit parent
    if (maybeMeta) {
      if (maybeMeta.source === obj) {
        return maybeMeta;
      }
      parent = maybeMeta;
    }

    var newMeta = new Meta(obj, parent);
    setMeta(obj, newMeta);
    return newMeta;
  }

  exports.peekMeta = peekMeta;
  exports.setMeta = setMeta;
  exports.counters = counters;
});
enifed('ember-metal/meta_listeners', ['exports'], function (exports) {
  /*
   When we render a rich template hierarchy, the set of events that
   *might* happen tends to be much larger than the set of events that
   actually happen. This implies that we should make listener creation &
   destruction cheap, even at the cost of making event dispatch more
   expensive.
  
   Thus we store a new listener with a single push and no new
   allocations, without even bothering to do deduplication -- we can
   save that for dispatch time, if an event actually happens.
   */

  /* listener flags */
  'use strict';

  var ONCE = 1;
  exports.ONCE = ONCE;
  var SUSPENDED = 2;

  exports.SUSPENDED = SUSPENDED;
  var protoMethods = {

    addToListeners: function (eventName, target, method, flags) {
      if (!this._listeners) {
        this._listeners = [];
      }
      this._listeners.push(eventName, target, method, flags);
    },

    _finalizeListeners: function () {
      if (this._listenersFinalized) {
        return;
      }
      if (!this._listeners) {
        this._listeners = [];
      }
      var pointer = this.parent;
      while (pointer) {
        var listeners = pointer._listeners;
        if (listeners) {
          this._listeners = this._listeners.concat(listeners);
        }
        if (pointer._listenersFinalized) {
          break;
        }
        pointer = pointer.parent;
      }
      this._listenersFinalized = true;
    },

    removeFromListeners: function (eventName, target, method, didRemove) {
      var pointer = this;
      while (pointer) {
        var listeners = pointer._listeners;
        if (listeners) {
          for (var index = listeners.length - 4; index >= 0; index -= 4) {
            if (listeners[index] === eventName && (!method || listeners[index + 1] === target && listeners[index + 2] === method)) {
              if (pointer === this) {
                // we are modifying our own list, so we edit directly
                if (typeof didRemove === 'function') {
                  didRemove(eventName, target, listeners[index + 2]);
                }
                listeners.splice(index, 4);
              } else {
                // we are trying to remove an inherited listener, so we do
                // just-in-time copying to detach our own listeners from
                // our inheritance chain.
                this._finalizeListeners();
                return this.removeFromListeners(eventName, target, method);
              }
            }
          }
        }
        if (pointer._listenersFinalized) {
          break;
        }
        pointer = pointer.parent;
      }
    },

    matchingListeners: function (eventName) {
      var pointer = this;
      var result = undefined;
      while (pointer !== undefined) {
        var listeners = pointer._listeners;
        if (listeners !== undefined) {
          for (var index = 0; index < listeners.length - 3; index += 4) {
            if (listeners[index] === eventName) {
              result = result || [];
              pushUniqueListener(result, listeners, index);
            }
          }
        }
        if (pointer._listenersFinalized === true) {
          break;
        }
        pointer = pointer.parent;
      }
      var sus = this._suspendedListeners;
      if (sus !== undefined && result !== undefined) {
        for (var susIndex = 0; susIndex < sus.length - 2; susIndex += 3) {
          if (eventName === sus[susIndex]) {
            for (var resultIndex = 0; resultIndex < result.length - 2; resultIndex += 3) {
              if (result[resultIndex] === sus[susIndex + 1] && result[resultIndex + 1] === sus[susIndex + 2]) {
                result[resultIndex + 2] |= SUSPENDED;
              }
            }
          }
        }
      }
      return result;
    },

    suspendListeners: function (eventNames, target, method, callback) {
      var sus = this._suspendedListeners;
      if (!sus) {
        sus = this._suspendedListeners = [];
      }
      for (var i = 0; i < eventNames.length; i++) {
        sus.push(eventNames[i], target, method);
      }
      try {
        return callback.call(target);
      } finally {
        if (sus.length === eventNames.length) {
          this._suspendedListeners = undefined;
        } else {
          for (var i = sus.length - 3; i >= 0; i -= 3) {
            if (sus[i + 1] === target && sus[i + 2] === method && eventNames.indexOf(sus[i]) !== -1) {
              sus.splice(i, 3);
            }
          }
        }
      }
    },

    watchedEvents: function () {
      var pointer = this;
      var names = {};
      while (pointer) {
        var listeners = pointer._listeners;
        if (listeners) {
          for (var index = 0; index < listeners.length - 3; index += 4) {
            names[listeners[index]] = true;
          }
        }
        if (pointer._listenersFinalized) {
          break;
        }
        pointer = pointer.parent;
      }
      return Object.keys(names);
    },

    _initializeListeners: function () {
      this._listeners = undefined;
      this._listenersFinalized = undefined;
      this._suspendedListeners = undefined;
    }
  };

  exports.protoMethods = protoMethods;
  function pushUniqueListener(destination, source, index) {
    var target = source[index + 1];
    var method = source[index + 2];
    for (var destinationIndex = 0; destinationIndex < destination.length - 2; destinationIndex += 3) {
      if (destination[destinationIndex] === target && destination[destinationIndex + 1] === method) {
        return;
      }
    }
    destination.push(target, method, source[index + 3]);
  }
});
enifed('ember-metal/mixin', ['exports', 'ember-utils', 'ember-debug', 'ember-metal/meta', 'ember-metal/expand_properties', 'ember-metal/properties', 'ember-metal/computed', 'ember-metal/binding', 'ember-metal/observer', 'ember-metal/events'], function (exports, _emberUtils, _emberDebug, _emberMetalMeta, _emberMetalExpand_properties, _emberMetalProperties, _emberMetalComputed, _emberMetalBinding, _emberMetalObserver, _emberMetalEvents) {
  /**
  @module ember
  @submodule ember-metal
  */
  'use strict';

  exports.detectBinding = detectBinding;
  exports.mixin = mixin;
  exports.hasUnprocessedMixins = hasUnprocessedMixins;
  exports.clearUnprocessedMixins = clearUnprocessedMixins;
  exports.required = required;
  exports.aliasMethod = aliasMethod;
  exports.observer = observer;
  exports._immediateObserver = _immediateObserver;
  exports._beforeObserver = _beforeObserver;

  var a_slice = Array.prototype.slice;
  var a_concat = Array.prototype.concat;
  var isArray = Array.isArray;

  function isMethod(obj) {
    return 'function' === typeof obj && obj.isMethod !== false && obj !== Boolean && obj !== Object && obj !== Number && obj !== Array && obj !== Date && obj !== String;
  }

  var CONTINUE = {};

  function mixinProperties(mixinsMeta, mixin) {
    var guid = undefined;

    if (mixin instanceof Mixin) {
      guid = _emberUtils.guidFor(mixin);
      if (mixinsMeta.peekMixins(guid)) {
        return CONTINUE;
      }
      mixinsMeta.writeMixins(guid, mixin);
      return mixin.properties;
    } else {
      return mixin; // apply anonymous mixin properties
    }
  }

  function concatenatedMixinProperties(concatProp, props, values, base) {
    // reset before adding each new mixin to pickup concats from previous
    var concats = values[concatProp] || base[concatProp];
    if (props[concatProp]) {
      concats = concats ? a_concat.call(concats, props[concatProp]) : props[concatProp];
    }
    return concats;
  }

  function giveDescriptorSuper(meta, key, property, values, descs, base) {
    var superProperty = undefined;

    // Computed properties override methods, and do not call super to them
    if (values[key] === undefined) {
      // Find the original descriptor in a parent mixin
      superProperty = descs[key];
    }

    // If we didn't find the original descriptor in a parent mixin, find
    // it on the original object.
    if (!superProperty) {
      var possibleDesc = base[key];
      var superDesc = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor ? possibleDesc : undefined;

      superProperty = superDesc;
    }

    if (superProperty === undefined || !(superProperty instanceof _emberMetalComputed.ComputedProperty)) {
      return property;
    }

    // Since multiple mixins may inherit from the same parent, we need
    // to clone the computed property so that other mixins do not receive
    // the wrapped version.
    property = Object.create(property);
    property._getter = _emberUtils.wrap(property._getter, superProperty._getter);
    if (superProperty._setter) {
      if (property._setter) {
        property._setter = _emberUtils.wrap(property._setter, superProperty._setter);
      } else {
        property._setter = superProperty._setter;
      }
    }

    return property;
  }

  function giveMethodSuper(obj, key, method, values, descs) {
    var superMethod = undefined;

    // Methods overwrite computed properties, and do not call super to them.
    if (descs[key] === undefined) {
      // Find the original method in a parent mixin
      superMethod = values[key];
    }

    // If we didn't find the original value in a parent mixin, find it in
    // the original object
    superMethod = superMethod || obj[key];

    // Only wrap the new method if the original method was a function
    if (superMethod === undefined || 'function' !== typeof superMethod) {
      return method;
    }

    return _emberUtils.wrap(method, superMethod);
  }

  function applyConcatenatedProperties(obj, key, value, values) {
    var baseValue = values[key] || obj[key];
    var ret = undefined;

    if (baseValue === null || baseValue === undefined) {
      ret = _emberUtils.makeArray(value);
    } else {
      if (isArray(baseValue)) {
        if (value === null || value === undefined) {
          ret = baseValue;
        } else {
          ret = a_concat.call(baseValue, value);
        }
      } else {
        ret = a_concat.call(_emberUtils.makeArray(baseValue), value);
      }
    }

    _emberDebug.runInDebug(function () {
      // it is possible to use concatenatedProperties with strings (which cannot be frozen)
      // only freeze objects...
      if (typeof ret === 'object' && ret !== null) {
        // prevent mutating `concatenatedProperties` array after it is applied
        Object.freeze(ret);
      }
    });

    return ret;
  }

  function applyMergedProperties(obj, key, value, values) {
    var baseValue = values[key] || obj[key];

    _emberDebug.runInDebug(function () {
      if (isArray(value)) {
        // use conditional to avoid stringifying every time
        _emberDebug.assert('You passed in `' + JSON.stringify(value) + '` as the value for `' + key + '` but `' + key + '` cannot be an Array', false);
      }
    });

    if (!baseValue) {
      return value;
    }

    var newBase = _emberUtils.assign({}, baseValue);
    var hasFunction = false;

    for (var prop in value) {
      if (!value.hasOwnProperty(prop)) {
        continue;
      }

      var propValue = value[prop];
      if (isMethod(propValue)) {
        // TODO: support for Computed Properties, etc?
        hasFunction = true;
        newBase[prop] = giveMethodSuper(obj, prop, propValue, baseValue, {});
      } else {
        newBase[prop] = propValue;
      }
    }

    if (hasFunction) {
      newBase._super = _emberUtils.ROOT;
    }

    return newBase;
  }

  function addNormalizedProperty(base, key, value, meta, descs, values, concats, mergings) {
    if (value instanceof _emberMetalProperties.Descriptor) {
      if (value === REQUIRED && descs[key]) {
        return CONTINUE;
      }

      // Wrap descriptor function to implement
      // _super() if needed
      if (value._getter) {
        value = giveDescriptorSuper(meta, key, value, values, descs, base);
      }

      descs[key] = value;
      values[key] = undefined;
    } else {
      if (concats && concats.indexOf(key) >= 0 || key === 'concatenatedProperties' || key === 'mergedProperties') {
        value = applyConcatenatedProperties(base, key, value, values);
      } else if (mergings && mergings.indexOf(key) >= 0) {
        value = applyMergedProperties(base, key, value, values);
      } else if (isMethod(value)) {
        value = giveMethodSuper(base, key, value, values, descs);
      }

      descs[key] = undefined;
      values[key] = value;
    }
  }

  function mergeMixins(mixins, meta, descs, values, base, keys) {
    var currentMixin = undefined,
        props = undefined,
        key = undefined,
        concats = undefined,
        mergings = undefined;

    function removeKeys(keyName) {
      delete descs[keyName];
      delete values[keyName];
    }

    for (var i = 0; i < mixins.length; i++) {
      currentMixin = mixins[i];
      _emberDebug.assert('Expected hash or Mixin instance, got ' + Object.prototype.toString.call(currentMixin), typeof currentMixin === 'object' && currentMixin !== null && Object.prototype.toString.call(currentMixin) !== '[object Array]');

      props = mixinProperties(meta, currentMixin);
      if (props === CONTINUE) {
        continue;
      }

      if (props) {
        if (base.willMergeMixin) {
          base.willMergeMixin(props);
        }
        concats = concatenatedMixinProperties('concatenatedProperties', props, values, base);
        mergings = concatenatedMixinProperties('mergedProperties', props, values, base);

        for (key in props) {
          if (!props.hasOwnProperty(key)) {
            continue;
          }
          keys.push(key);
          addNormalizedProperty(base, key, props[key], meta, descs, values, concats, mergings);
        }

        // manually copy toString() because some JS engines do not enumerate it
        if (props.hasOwnProperty('toString')) {
          base.toString = props.toString;
        }
      } else if (currentMixin.mixins) {
        mergeMixins(currentMixin.mixins, meta, descs, values, base, keys);
        if (currentMixin._without) {
          currentMixin._without.forEach(removeKeys);
        }
      }
    }
  }

  function detectBinding(key) {
    var length = key.length;

    return length > 7 && key.charCodeAt(length - 7) === 66 && key.indexOf('inding', length - 6) !== -1;
  }

  // warm both paths of above function
  detectBinding('notbound');
  detectBinding('fooBinding');

  function connectBindings(obj, meta) {
    // TODO Mixin.apply(instance) should disconnect binding if exists
    meta.forEachBindings(function (key, binding) {
      if (binding) {
        var to = key.slice(0, -7); // strip Binding off end
        if (binding instanceof _emberMetalBinding.Binding) {
          binding = binding.copy(); // copy prototypes' instance
          binding.to(to);
        } else {
          // binding is string path
          binding = new _emberMetalBinding.Binding(to, binding);
        }
        binding.connect(obj);
        obj[key] = binding;
      }
    });
    // mark as applied
    meta.clearBindings();
  }

  function finishPartial(obj, meta) {
    connectBindings(obj, meta || _emberMetalMeta.meta(obj));
    return obj;
  }

  function followAlias(obj, desc, descs, values) {
    var altKey = desc.methodName;
    var value = undefined;
    var possibleDesc = undefined;
    if (descs[altKey] || values[altKey]) {
      value = values[altKey];
      desc = descs[altKey];
    } else if ((possibleDesc = obj[altKey]) && possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor) {
      desc = possibleDesc;
      value = undefined;
    } else {
      desc = undefined;
      value = obj[altKey];
    }

    return { desc: desc, value: value };
  }

  function updateObserversAndListeners(obj, key, observerOrListener, pathsKey, updateMethod) {
    var paths = observerOrListener[pathsKey];

    if (paths) {
      for (var i = 0; i < paths.length; i++) {
        updateMethod(obj, paths[i], null, key);
      }
    }
  }

  function replaceObserversAndListeners(obj, key, observerOrListener) {
    var prev = obj[key];

    if ('function' === typeof prev) {
      updateObserversAndListeners(obj, key, prev, '__ember_observesBefore__', _emberMetalObserver._removeBeforeObserver);
      updateObserversAndListeners(obj, key, prev, '__ember_observes__', _emberMetalObserver.removeObserver);
      updateObserversAndListeners(obj, key, prev, '__ember_listens__', _emberMetalEvents.removeListener);
    }

    if ('function' === typeof observerOrListener) {
      updateObserversAndListeners(obj, key, observerOrListener, '__ember_observesBefore__', _emberMetalObserver._addBeforeObserver);
      updateObserversAndListeners(obj, key, observerOrListener, '__ember_observes__', _emberMetalObserver.addObserver);
      updateObserversAndListeners(obj, key, observerOrListener, '__ember_listens__', _emberMetalEvents.addListener);
    }
  }

  function applyMixin(obj, mixins, partial) {
    var descs = {};
    var values = {};
    var meta = _emberMetalMeta.meta(obj);
    var keys = [];
    var key = undefined,
        value = undefined,
        desc = undefined;

    obj._super = _emberUtils.ROOT;

    // Go through all mixins and hashes passed in, and:
    //
    // * Handle concatenated properties
    // * Handle merged properties
    // * Set up _super wrapping if necessary
    // * Set up computed property descriptors
    // * Copying `toString` in broken browsers
    mergeMixins(mixins, meta, descs, values, obj, keys);

    for (var i = 0; i < keys.length; i++) {
      key = keys[i];
      if (key === 'constructor' || !values.hasOwnProperty(key)) {
        continue;
      }

      desc = descs[key];
      value = values[key];

      if (desc === REQUIRED) {
        continue;
      }

      while (desc && desc instanceof Alias) {
        var followed = followAlias(obj, desc, descs, values);
        desc = followed.desc;
        value = followed.value;
      }

      if (desc === undefined && value === undefined) {
        continue;
      }

      replaceObserversAndListeners(obj, key, value);

      if (detectBinding(key)) {
        meta.writeBindings(key, value);
      }

      _emberMetalProperties.defineProperty(obj, key, desc, value, meta);
    }

    if (!partial) {
      // don't apply to prototype
      finishPartial(obj, meta);
    }

    return obj;
  }

  /**
    @method mixin
    @for Ember
    @param obj
    @param mixins*
    @return obj
    @private
  */

  function mixin(obj) {
    for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }

    applyMixin(obj, args, false);
    return obj;
  }

  /**
    The `Ember.Mixin` class allows you to create mixins, whose properties can be
    added to other classes. For instance,
  
    ```javascript
    const EditableMixin = Ember.Mixin.create({
      edit() {
        console.log('starting to edit');
        this.set('isEditing', true);
      },
      isEditing: false
    });
  
    // Mix mixins into classes by passing them as the first arguments to
    // `.extend.`
    const Comment = Ember.Object.extend(EditableMixin, {
      post: null
    });
  
    let comment = Comment.create({
      post: somePost
    });
  
    comment.edit(); // outputs 'starting to edit'
    ```
  
    Note that Mixins are created with `Ember.Mixin.create`, not
    `Ember.Mixin.extend`.
  
    Note that mixins extend a constructor's prototype so arrays and object literals
    defined as properties will be shared amongst objects that implement the mixin.
    If you want to define a property in a mixin that is not shared, you can define
    it either as a computed property or have it be created on initialization of the object.
  
    ```javascript
    // filters array will be shared amongst any object implementing mixin
    const FilterableMixin = Ember.Mixin.create({
      filters: Ember.A()
    });
  
    // filters will be a separate array for every object implementing the mixin
    const FilterableMixin = Ember.Mixin.create({
      filters: Ember.computed(function() {
        return Ember.A();
      })
    });
  
    // filters will be created as a separate array during the object's initialization
    const Filterable = Ember.Mixin.create({
      init() {
        this._super(...arguments);
        this.set("filters", Ember.A());
      }
    });
    ```
  
    @class Mixin
    @namespace Ember
    @public
  */

  var Mixin = (function () {
    function Mixin(mixins, properties) {
      babelHelpers.classCallCheck(this, Mixin);

      this.properties = properties;

      var length = mixins && mixins.length;

      if (length > 0) {
        var m = new Array(length);

        for (var i = 0; i < length; i++) {
          var x = mixins[i];
          if (x instanceof Mixin) {
            m[i] = x;
          } else {
            m[i] = new Mixin(undefined, x);
          }
        }

        this.mixins = m;
      } else {
        this.mixins = undefined;
      }
      this.ownerConstructor = undefined;
      this._without = undefined;
      this[_emberUtils.GUID_KEY] = null;
      this[_emberUtils.NAME_KEY] = null;
      _emberDebug.debugSeal(this);
    }

    Mixin.applyPartial = function applyPartial(obj) {
      for (var _len2 = arguments.length, args = Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
        args[_key2 - 1] = arguments[_key2];
      }

      return applyMixin(obj, args, true);
    };

    /**
      @method create
      @static
      @param arguments*
      @public
    */

    Mixin.create = function create() {
      // ES6TODO: this relies on a global state?
      unprocessedFlag = true;
      var M = this;

      for (var _len3 = arguments.length, args = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
        args[_key3] = arguments[_key3];
      }

      return new M(args, undefined);
    };

    // returns the mixins currently applied to the specified object
    // TODO: Make Ember.mixin

    Mixin.mixins = function mixins(obj) {
      var meta = _emberMetalMeta.peekMeta(obj);
      var ret = [];
      if (!meta) {
        return ret;
      }

      meta.forEachMixins(function (key, currentMixin) {
        // skip primitive mixins since these are always anonymous
        if (!currentMixin.properties) {
          ret.push(currentMixin);
        }
      });

      return ret;
    };

    return Mixin;
  })();

  exports.default = Mixin;

  Mixin._apply = applyMixin;

  Mixin.finishPartial = finishPartial;

  var unprocessedFlag = false;

  function hasUnprocessedMixins() {
    return unprocessedFlag;
  }

  function clearUnprocessedMixins() {
    unprocessedFlag = false;
  }

  var MixinPrototype = Mixin.prototype;

  /**
    @method reopen
    @param arguments*
    @private
  */
  MixinPrototype.reopen = function () {
    var currentMixin = undefined;

    if (this.properties) {
      currentMixin = new Mixin(undefined, this.properties);
      this.properties = undefined;
      this.mixins = [currentMixin];
    } else if (!this.mixins) {
      this.mixins = [];
    }

    var mixins = this.mixins;
    var idx = undefined;

    for (idx = 0; idx < arguments.length; idx++) {
      currentMixin = arguments[idx];
      _emberDebug.assert('Expected hash or Mixin instance, got ' + Object.prototype.toString.call(currentMixin), typeof currentMixin === 'object' && currentMixin !== null && Object.prototype.toString.call(currentMixin) !== '[object Array]');

      if (currentMixin instanceof Mixin) {
        mixins.push(currentMixin);
      } else {
        mixins.push(new Mixin(undefined, currentMixin));
      }
    }

    return this;
  };

  /**
    @method apply
    @param obj
    @return applied object
    @private
  */
  MixinPrototype.apply = function (obj) {
    return applyMixin(obj, [this], false);
  };

  MixinPrototype.applyPartial = function (obj) {
    return applyMixin(obj, [this], true);
  };

  MixinPrototype.toString = Object.toString;

  function _detect(curMixin, targetMixin, seen) {
    var guid = _emberUtils.guidFor(curMixin);

    if (seen[guid]) {
      return false;
    }
    seen[guid] = true;

    if (curMixin === targetMixin) {
      return true;
    }
    var mixins = curMixin.mixins;
    var loc = mixins ? mixins.length : 0;
    while (--loc >= 0) {
      if (_detect(mixins[loc], targetMixin, seen)) {
        return true;
      }
    }
    return false;
  }

  /**
    @method detect
    @param obj
    @return {Boolean}
    @private
  */
  MixinPrototype.detect = function (obj) {
    if (typeof obj !== 'object' || obj === null) {
      return false;
    }
    if (obj instanceof Mixin) {
      return _detect(obj, this, {});
    }
    var meta = _emberMetalMeta.peekMeta(obj);
    if (!meta) {
      return false;
    }
    return !!meta.peekMixins(_emberUtils.guidFor(this));
  };

  MixinPrototype.without = function () {
    var ret = new Mixin([this]);

    for (var _len4 = arguments.length, args = Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
      args[_key4] = arguments[_key4];
    }

    ret._without = args;
    return ret;
  };

  function _keys(ret, mixin, seen) {
    if (seen[_emberUtils.guidFor(mixin)]) {
      return;
    }
    seen[_emberUtils.guidFor(mixin)] = true;

    if (mixin.properties) {
      var props = Object.keys(mixin.properties);
      for (var i = 0; i < props.length; i++) {
        var key = props[i];
        ret[key] = true;
      }
    } else if (mixin.mixins) {
      mixin.mixins.forEach(function (x) {
        return _keys(ret, x, seen);
      });
    }
  }

  MixinPrototype.keys = function () {
    var keys = {};
    var seen = {};

    _keys(keys, this, seen);
    var ret = Object.keys(keys);
    return ret;
  };

  _emberDebug.debugSeal(MixinPrototype);

  var REQUIRED = new _emberMetalProperties.Descriptor();
  REQUIRED.toString = function () {
    return '(Required Property)';
  };

  /**
    Denotes a required property for a mixin
  
    @method required
    @for Ember
    @private
  */

  function required() {
    _emberDebug.deprecate('Ember.required is deprecated as its behavior is inconsistent and unreliable.', false, { id: 'ember-metal.required', until: '3.0.0' });
    return REQUIRED;
  }

  function Alias(methodName) {
    this.isDescriptor = true;
    this.methodName = methodName;
  }

  Alias.prototype = new _emberMetalProperties.Descriptor();

  /**
    Makes a method available via an additional name.
  
    ```javascript
    App.Person = Ember.Object.extend({
      name: function() {
        return 'Tomhuda Katzdale';
      },
      moniker: Ember.aliasMethod('name')
    });
  
    let goodGuy = App.Person.create();
  
    goodGuy.name();    // 'Tomhuda Katzdale'
    goodGuy.moniker(); // 'Tomhuda Katzdale'
    ```
  
    @method aliasMethod
    @for Ember
    @param {String} methodName name of the method to alias
    @public
  */

  function aliasMethod(methodName) {
    return new Alias(methodName);
  }

  // ..........................................................
  // OBSERVER HELPER
  //

  /**
    Specify a method that observes property changes.
  
    ```javascript
    Ember.Object.extend({
      valueObserver: Ember.observer('value', function() {
        // Executes whenever the "value" property changes
      })
    });
    ```
  
    Also available as `Function.prototype.observes` if prototype extensions are
    enabled.
  
    @method observer
    @for Ember
    @param {String} propertyNames*
    @param {Function} func
    @return func
    @public
  */

  function observer() {
    for (var _len5 = arguments.length, args = Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
      args[_key5] = arguments[_key5];
    }

    var func = args.slice(-1)[0];
    var paths = undefined;

    var addWatchedProperty = function (path) {
      paths.push(path);
    };
    var _paths = args.slice(0, -1);

    if (typeof func !== 'function') {
      // revert to old, soft-deprecated argument ordering
      _emberDebug.deprecate('Passing the dependentKeys after the callback function in Ember.observer is deprecated. Ensure the callback function is the last argument.', false, { id: 'ember-metal.observer-argument-order', until: '3.0.0' });

      func = args[0];
      _paths = args.slice(1);
    }

    paths = [];

    for (var i = 0; i < _paths.length; ++i) {
      _emberMetalExpand_properties.default(_paths[i], addWatchedProperty);
    }

    if (typeof func !== 'function') {
      throw new _emberDebug.EmberError('Ember.observer called without a function');
    }

    func.__ember_observes__ = paths;
    return func;
  }

  /**
    Specify a method that observes property changes.
  
    ```javascript
    Ember.Object.extend({
      valueObserver: Ember.immediateObserver('value', function() {
        // Executes whenever the "value" property changes
      })
    });
    ```
  
    In the future, `Ember.observer` may become asynchronous. In this event,
    `Ember.immediateObserver` will maintain the synchronous behavior.
  
    Also available as `Function.prototype.observesImmediately` if prototype extensions are
    enabled.
  
    @method _immediateObserver
    @for Ember
    @param {String} propertyNames*
    @param {Function} func
    @deprecated Use `Ember.observer` instead.
    @return func
    @private
  */

  function _immediateObserver() {
    _emberDebug.deprecate('Usage of `Ember.immediateObserver` is deprecated, use `Ember.observer` instead.', false, { id: 'ember-metal.immediate-observer', until: '3.0.0' });

    for (var i = 0; i < arguments.length; i++) {
      var arg = arguments[i];
      _emberDebug.assert('Immediate observers must observe internal properties only, not properties on other objects.', typeof arg !== 'string' || arg.indexOf('.') === -1);
    }

    return observer.apply(this, arguments);
  }

  /**
    When observers fire, they are called with the arguments `obj`, `keyName`.
  
    Note, `@each.property` observer is called per each add or replace of an element
    and it's not called with a specific enumeration item.
  
    A `_beforeObserver` fires before a property changes.
  
    @method beforeObserver
    @for Ember
    @param {String} propertyNames*
    @param {Function} func
    @return func
    @deprecated
    @private
  */

  function _beforeObserver() {
    for (var _len6 = arguments.length, args = Array(_len6), _key6 = 0; _key6 < _len6; _key6++) {
      args[_key6] = arguments[_key6];
    }

    var func = args.slice(-1)[0];
    var paths = undefined;

    var addWatchedProperty = function (path) {
      paths.push(path);
    };

    var _paths = args.slice(0, -1);

    if (typeof func !== 'function') {
      // revert to old, soft-deprecated argument ordering

      func = args[0];
      _paths = args.slice(1);
    }

    paths = [];

    for (var i = 0; i < _paths.length; ++i) {
      _emberMetalExpand_properties.default(_paths[i], addWatchedProperty);
    }

    if (typeof func !== 'function') {
      throw new _emberDebug.EmberError('_beforeObserver called without a function');
    }

    func.__ember_observesBefore__ = paths;
    return func;
  }

  exports.Mixin = Mixin;
  exports.REQUIRED = REQUIRED;
});
enifed('ember-metal/observer', ['exports', 'ember-metal/watching', 'ember-metal/events'], function (exports, _emberMetalWatching, _emberMetalEvents) {
  'use strict';

  exports.addObserver = addObserver;
  exports.observersFor = observersFor;
  exports.removeObserver = removeObserver;
  exports._addBeforeObserver = _addBeforeObserver;
  exports._suspendObserver = _suspendObserver;
  exports._suspendObservers = _suspendObservers;
  exports._removeBeforeObserver = _removeBeforeObserver;

  /**
  @module ember-metal
  */

  var AFTER_OBSERVERS = ':change';
  var BEFORE_OBSERVERS = ':before';

  function changeEvent(keyName) {
    return keyName + AFTER_OBSERVERS;
  }

  function beforeEvent(keyName) {
    return keyName + BEFORE_OBSERVERS;
  }

  /**
    @method addObserver
    @for Ember
    @param obj
    @param {String} _path
    @param {Object|Function} target
    @param {Function|String} [method]
    @public
  */

  function addObserver(obj, _path, target, method) {
    _emberMetalEvents.addListener(obj, changeEvent(_path), target, method);
    _emberMetalWatching.watch(obj, _path);

    return this;
  }

  function observersFor(obj, path) {
    return _emberMetalEvents.listenersFor(obj, changeEvent(path));
  }

  /**
    @method removeObserver
    @for Ember
    @param obj
    @param {String} path
    @param {Object|Function} target
    @param {Function|String} [method]
    @public
  */

  function removeObserver(obj, path, target, method) {
    _emberMetalWatching.unwatch(obj, path);
    _emberMetalEvents.removeListener(obj, changeEvent(path), target, method);

    return this;
  }

  /**
    @method _addBeforeObserver
    @for Ember
    @param obj
    @param {String} path
    @param {Object|Function} target
    @param {Function|String} [method]
    @deprecated
    @private
  */

  function _addBeforeObserver(obj, path, target, method) {
    _emberMetalEvents.addListener(obj, beforeEvent(path), target, method);
    _emberMetalWatching.watch(obj, path);

    return this;
  }

  // Suspend observer during callback.
  //
  // This should only be used by the target of the observer
  // while it is setting the observed path.

  function _suspendObserver(obj, path, target, method, callback) {
    return _emberMetalEvents.suspendListener(obj, changeEvent(path), target, method, callback);
  }

  function _suspendObservers(obj, paths, target, method, callback) {
    var events = paths.map(changeEvent);
    return _emberMetalEvents.suspendListeners(obj, events, target, method, callback);
  }

  /**
    @method removeBeforeObserver
    @for Ember
    @param obj
    @param {String} path
    @param {Object|Function} target
    @param {Function|String} [method]
    @deprecated
    @private
  */

  function _removeBeforeObserver(obj, path, target, method) {
    _emberMetalWatching.unwatch(obj, path);
    _emberMetalEvents.removeListener(obj, beforeEvent(path), target, method);

    return this;
  }
});
enifed('ember-metal/observer_set', ['exports', 'ember-utils', 'ember-metal/events'], function (exports, _emberUtils, _emberMetalEvents) {
  'use strict';

  /*
    this.observerSet = {
      [senderGuid]: { // variable name: `keySet`
        [keyName]: listIndex
      }
    },
    this.observers = [
      {
        sender: obj,
        keyName: keyName,
        eventName: eventName,
        listeners: [
          [target, method, flags]
        ]
      },
      ...
    ]
  */

  var ObserverSet = (function () {
    function ObserverSet() {
      babelHelpers.classCallCheck(this, ObserverSet);

      this.clear();
    }

    ObserverSet.prototype.add = function add(sender, keyName, eventName) {
      var observerSet = this.observerSet;
      var observers = this.observers;
      var senderGuid = _emberUtils.guidFor(sender);
      var keySet = observerSet[senderGuid];
      var index = undefined;

      if (!keySet) {
        observerSet[senderGuid] = keySet = {};
      }
      index = keySet[keyName];
      if (index === undefined) {
        index = observers.push({
          sender: sender,
          keyName: keyName,
          eventName: eventName,
          listeners: []
        }) - 1;
        keySet[keyName] = index;
      }
      return observers[index].listeners;
    };

    ObserverSet.prototype.flush = function flush() {
      var observers = this.observers;
      var i = undefined,
          observer = undefined,
          sender = undefined;
      this.clear();
      for (i = 0; i < observers.length; ++i) {
        observer = observers[i];
        sender = observer.sender;
        if (sender.isDestroying || sender.isDestroyed) {
          continue;
        }
        _emberMetalEvents.sendEvent(sender, observer.eventName, [sender, observer.keyName], observer.listeners);
      }
    };

    ObserverSet.prototype.clear = function clear() {
      this.observerSet = {};
      this.observers = [];
    };

    return ObserverSet;
  })();

  exports.default = ObserverSet;
});
enifed('ember-metal/path_cache', ['exports', 'ember-metal/cache'], function (exports, _emberMetalCache) {
  'use strict';

  exports.isGlobal = isGlobal;
  exports.isGlobalPath = isGlobalPath;
  exports.hasThis = hasThis;
  exports.isPath = isPath;
  exports.getFirstKey = getFirstKey;
  exports.getTailPath = getTailPath;

  var IS_GLOBAL = /^[A-Z$]/;
  var IS_GLOBAL_PATH = /^[A-Z$].*[\.]/;
  var HAS_THIS = 'this.';

  var isGlobalCache = new _emberMetalCache.default(1000, function (key) {
    return IS_GLOBAL.test(key);
  });
  var isGlobalPathCache = new _emberMetalCache.default(1000, function (key) {
    return IS_GLOBAL_PATH.test(key);
  });
  var hasThisCache = new _emberMetalCache.default(1000, function (key) {
    return key.lastIndexOf(HAS_THIS, 0) === 0;
  });
  var firstDotIndexCache = new _emberMetalCache.default(1000, function (key) {
    return key.indexOf('.');
  });

  var firstKeyCache = new _emberMetalCache.default(1000, function (path) {
    var index = firstDotIndexCache.get(path);
    if (index === -1) {
      return path;
    } else {
      return path.slice(0, index);
    }
  });

  var tailPathCache = new _emberMetalCache.default(1000, function (path) {
    var index = firstDotIndexCache.get(path);
    if (index !== -1) {
      return path.slice(index + 1);
    }
  });

  var caches = {
    isGlobalCache: isGlobalCache,
    isGlobalPathCache: isGlobalPathCache,
    hasThisCache: hasThisCache,
    firstDotIndexCache: firstDotIndexCache,
    firstKeyCache: firstKeyCache,
    tailPathCache: tailPathCache
  };

  exports.caches = caches;

  function isGlobal(path) {
    return isGlobalCache.get(path);
  }

  function isGlobalPath(path) {
    return isGlobalPathCache.get(path);
  }

  function hasThis(path) {
    return hasThisCache.get(path);
  }

  function isPath(path) {
    return firstDotIndexCache.get(path) !== -1;
  }

  function getFirstKey(path) {
    return firstKeyCache.get(path);
  }

  function getTailPath(path) {
    return tailPathCache.get(path);
  }
});
enifed('ember-metal/properties', ['exports', 'ember-debug', 'ember-metal/meta', 'ember-metal/property_events'], function (exports, _emberDebug, _emberMetalMeta, _emberMetalProperty_events) {
  /**
  @module ember-metal
  */

  'use strict';

  exports.Descriptor = Descriptor;
  exports.MANDATORY_SETTER_FUNCTION = MANDATORY_SETTER_FUNCTION;
  exports.DEFAULT_GETTER_FUNCTION = DEFAULT_GETTER_FUNCTION;
  exports.INHERITING_GETTER_FUNCTION = INHERITING_GETTER_FUNCTION;
  exports.defineProperty = defineProperty;
  exports._hasCachedComputedProperties = _hasCachedComputedProperties;

  // ..........................................................
  // DESCRIPTOR
  //

  /**
    Objects of this type can implement an interface to respond to requests to
    get and set. The default implementation handles simple properties.
  
    @class Descriptor
    @private
  */

  function Descriptor() {
    this.isDescriptor = true;
  }

  var REDEFINE_SUPPORTED = (function () {
    // https://github.com/spalger/kibana/commit/b7e35e6737df585585332857a4c397dc206e7ff9
    var a = Object.create(Object.prototype, {
      prop: {
        configurable: true,
        value: 1
      }
    });

    Object.defineProperty(a, 'prop', {
      configurable: true,
      value: 2
    });

    return a.prop === 2;
  })();
  // ..........................................................
  // DEFINING PROPERTIES API
  //

  function MANDATORY_SETTER_FUNCTION(name) {
    function SETTER_FUNCTION(value) {
      var m = _emberMetalMeta.peekMeta(this);
      if (!m.isInitialized(this)) {
        m.writeValues(name, value);
      } else {
        _emberDebug.assert('You must use Ember.set() to set the `' + name + '` property (of ' + this + ') to `' + value + '`.', false);
      }
    }

    SETTER_FUNCTION.isMandatorySetter = true;
    return SETTER_FUNCTION;
  }

  function DEFAULT_GETTER_FUNCTION(name) {
    return function GETTER_FUNCTION() {
      var meta = _emberMetalMeta.peekMeta(this);
      return meta && meta.peekValues(name);
    };
  }

  function INHERITING_GETTER_FUNCTION(name) {
    function IGETTER_FUNCTION() {
      var meta = _emberMetalMeta.peekMeta(this);
      var val = meta && meta.readInheritedValue('values', name);

      if (val === _emberMetalMeta.UNDEFINED) {
        var proto = Object.getPrototypeOf(this);
        return proto && proto[name];
      } else {
        return val;
      }
    }

    IGETTER_FUNCTION.isInheritingGetter = true;
    return IGETTER_FUNCTION;
  }

  /**
    NOTE: This is a low-level method used by other parts of the API. You almost
    never want to call this method directly. Instead you should use
    `Ember.mixin()` to define new properties.
  
    Defines a property on an object. This method works much like the ES5
    `Object.defineProperty()` method except that it can also accept computed
    properties and other special descriptors.
  
    Normally this method takes only three parameters. However if you pass an
    instance of `Descriptor` as the third param then you can pass an
    optional value as the fourth parameter. This is often more efficient than
    creating new descriptor hashes for each property.
  
    ## Examples
  
    ```javascript
    // ES5 compatible mode
    Ember.defineProperty(contact, 'firstName', {
      writable: true,
      configurable: false,
      enumerable: true,
      value: 'Charles'
    });
  
    // define a simple property
    Ember.defineProperty(contact, 'lastName', undefined, 'Jolley');
  
    // define a computed property
    Ember.defineProperty(contact, 'fullName', Ember.computed('firstName', 'lastName', function() {
      return this.firstName+' '+this.lastName;
    }));
    ```
  
    @private
    @method defineProperty
    @for Ember
    @param {Object} obj the object to define this property on. This may be a prototype.
    @param {String} keyName the name of the property
    @param {Descriptor} [desc] an instance of `Descriptor` (typically a
      computed property) or an ES5 descriptor.
      You must provide this or `data` but not both.
    @param {*} [data] something other than a descriptor, that will
      become the explicit value of this property.
  */

  function defineProperty(obj, keyName, desc, data, meta) {
    if (!meta) {
      meta = _emberMetalMeta.meta(obj);
    }
    var watchEntry = meta.peekWatching(keyName);
    var possibleDesc = obj[keyName];
    var existingDesc = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor ? possibleDesc : undefined;

    var watching = watchEntry !== undefined && watchEntry > 0;

    if (existingDesc) {
      existingDesc.teardown(obj, keyName);
    }

    var value = undefined;
    if (desc instanceof Descriptor) {
      value = desc;
      if (true) {
        if (watching) {
          Object.defineProperty(obj, keyName, {
            configurable: true,
            enumerable: true,
            writable: true,
            value: value
          });
        } else {
          obj[keyName] = value;
        }
      } else {
        obj[keyName] = value;
      }

      didDefineComputedProperty(obj.constructor);

      if (typeof desc.setup === 'function') {
        desc.setup(obj, keyName);
      }
    } else {
      if (desc == null) {
        value = data;

        if (true) {
          if (watching) {
            meta.writeValues(keyName, data);

            var defaultDescriptor = {
              configurable: true,
              enumerable: true,
              set: MANDATORY_SETTER_FUNCTION(keyName),
              get: DEFAULT_GETTER_FUNCTION(keyName)
            };

            if (REDEFINE_SUPPORTED) {
              Object.defineProperty(obj, keyName, defaultDescriptor);
            } else {
              handleBrokenPhantomDefineProperty(obj, keyName, defaultDescriptor);
            }
          } else {
            obj[keyName] = data;
          }
        } else {
          obj[keyName] = data;
        }
      } else {
        value = desc;

        // fallback to ES5
        Object.defineProperty(obj, keyName, desc);
      }
    }

    // if key is being watched, override chains that
    // were initialized with the prototype
    if (watching) {
      _emberMetalProperty_events.overrideChains(obj, keyName, meta);
    }

    // The `value` passed to the `didDefineProperty` hook is
    // either the descriptor or data, whichever was passed.
    if (typeof obj.didDefineProperty === 'function') {
      obj.didDefineProperty(obj, keyName, value);
    }

    return this;
  }

  var hasCachedComputedProperties = false;

  function _hasCachedComputedProperties() {
    hasCachedComputedProperties = true;
  }

  function didDefineComputedProperty(constructor) {
    if (hasCachedComputedProperties === false) {
      return;
    }
    var cache = _emberMetalMeta.meta(constructor).readableCache();

    if (cache && cache._computedProperties !== undefined) {
      cache._computedProperties = undefined;
    }
  }

  function handleBrokenPhantomDefineProperty(obj, keyName, desc) {
    // https://github.com/ariya/phantomjs/issues/11856
    Object.defineProperty(obj, keyName, { configurable: true, writable: true, value: 'iCry' });
    Object.defineProperty(obj, keyName, desc);
  }
});
enifed('ember-metal/property_events', ['exports', 'ember-utils', 'ember-metal/meta', 'ember-metal/events', 'ember-metal/tags', 'ember-metal/observer_set', 'ember-debug', 'ember-metal/transaction'], function (exports, _emberUtils, _emberMetalMeta, _emberMetalEvents, _emberMetalTags, _emberMetalObserver_set, _emberDebug, _emberMetalTransaction) {
  'use strict';

  var PROPERTY_DID_CHANGE = _emberUtils.symbol('PROPERTY_DID_CHANGE');

  exports.PROPERTY_DID_CHANGE = PROPERTY_DID_CHANGE;
  var beforeObserverSet = new _emberMetalObserver_set.default();
  var observerSet = new _emberMetalObserver_set.default();
  var deferred = 0;

  // ..........................................................
  // PROPERTY CHANGES
  //

  /**
    This function is called just before an object property is about to change.
    It will notify any before observers and prepare caches among other things.
  
    Normally you will not need to call this method directly but if for some
    reason you can't directly watch a property you can invoke this method
    manually along with `Ember.propertyDidChange()` which you should call just
    after the property value changes.
  
    @method propertyWillChange
    @for Ember
    @param {Object} obj The object with the property that will change
    @param {String} keyName The property key (or path) that will change.
    @return {void}
    @private
  */
  function propertyWillChange(obj, keyName, _meta) {
    var meta = _meta || _emberMetalMeta.peekMeta(obj);

    if (meta && !meta.isInitialized(obj)) {
      return;
    }

    var watching = meta && meta.peekWatching(keyName) > 0;
    var possibleDesc = obj[keyName];
    var desc = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor ? possibleDesc : undefined;

    if (desc && desc.willChange) {
      desc.willChange(obj, keyName);
    }

    if (watching) {
      dependentKeysWillChange(obj, keyName, meta);
      chainsWillChange(obj, keyName, meta);
      notifyBeforeObservers(obj, keyName, meta);
    }
  }

  /**
    This function is called just after an object property has changed.
    It will notify any observers and clear caches among other things.
  
    Normally you will not need to call this method directly but if for some
    reason you can't directly watch a property you can invoke this method
    manually along with `Ember.propertyWillChange()` which you should call just
    before the property value changes.
  
    @method propertyDidChange
    @for Ember
    @param {Object} obj The object with the property that will change
    @param {String} keyName The property key (or path) that will change.
    @param {Meta} meta The objects meta.
    @return {void}
    @private
  */
  function propertyDidChange(obj, keyName, _meta) {
    var meta = _meta || _emberMetalMeta.peekMeta(obj);

    if (meta && !meta.isInitialized(obj)) {
      return;
    }

    var watching = meta && meta.peekWatching(keyName) > 0;
    var possibleDesc = obj[keyName];
    var desc = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor ? possibleDesc : undefined;

    // shouldn't this mean that we're watching this key?
    if (desc && desc.didChange) {
      desc.didChange(obj, keyName);
    }

    if (watching) {
      if (meta.hasDeps(keyName)) {
        dependentKeysDidChange(obj, keyName, meta);
      }

      chainsDidChange(obj, keyName, meta, false);
      notifyObservers(obj, keyName, meta);
    }

    if (obj[PROPERTY_DID_CHANGE]) {
      obj[PROPERTY_DID_CHANGE](keyName);
    }

    if (meta && meta.isSourceDestroying()) {
      return;
    }

    _emberMetalTags.markObjectAsDirty(meta, keyName);

    if (true || false) {
      _emberMetalTransaction.assertNotRendered(obj, keyName, meta);
    }
  }

  var WILL_SEEN = undefined,
      DID_SEEN = undefined;
  // called whenever a property is about to change to clear the cache of any dependent keys (and notify those properties of changes, etc...)
  function dependentKeysWillChange(obj, depKey, meta) {
    if (meta && meta.isSourceDestroying()) {
      return;
    }

    if (meta && meta.hasDeps(depKey)) {
      var seen = WILL_SEEN;
      var _top = !seen;

      if (_top) {
        seen = WILL_SEEN = {};
      }

      iterDeps(propertyWillChange, obj, depKey, seen, meta);

      if (_top) {
        WILL_SEEN = null;
      }
    }
  }

  // called whenever a property has just changed to update dependent keys
  function dependentKeysDidChange(obj, depKey, meta) {
    if (meta && meta.isSourceDestroying()) {
      return;
    }

    if (meta && meta.hasDeps(depKey)) {
      var seen = DID_SEEN;
      var _top2 = !seen;

      if (_top2) {
        seen = DID_SEEN = {};
      }

      iterDeps(propertyDidChange, obj, depKey, seen, meta);

      if (_top2) {
        DID_SEEN = null;
      }
    }
  }

  function iterDeps(method, obj, depKey, seen, meta) {
    var possibleDesc = undefined,
        desc = undefined;
    var guid = _emberUtils.guidFor(obj);
    var current = seen[guid];

    if (!current) {
      current = seen[guid] = {};
    }

    if (current[depKey]) {
      return;
    }

    current[depKey] = true;

    meta.forEachInDeps(depKey, function (key, value) {
      if (!value) {
        return;
      }

      possibleDesc = obj[key];
      desc = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor ? possibleDesc : undefined;

      if (desc && desc._suspended === obj) {
        return;
      }

      method(obj, key, meta);
    });
  }

  function chainsWillChange(obj, keyName, meta) {
    var chainWatchers = meta.readableChainWatchers();
    if (chainWatchers) {
      chainWatchers.notify(keyName, false, propertyWillChange);
    }
  }

  function chainsDidChange(obj, keyName, meta) {
    var chainWatchers = meta.readableChainWatchers();
    if (chainWatchers) {
      chainWatchers.notify(keyName, true, propertyDidChange);
    }
  }

  function overrideChains(obj, keyName, meta) {
    var chainWatchers = meta.readableChainWatchers();
    if (chainWatchers) {
      chainWatchers.revalidate(keyName);
    }
  }

  /**
    @method beginPropertyChanges
    @chainable
    @private
  */
  function beginPropertyChanges() {
    deferred++;
  }

  /**
    @method endPropertyChanges
    @private
  */
  function endPropertyChanges() {
    deferred--;
    if (deferred <= 0) {
      beforeObserverSet.clear();
      observerSet.flush();
    }
  }

  /**
    Make a series of property changes together in an
    exception-safe way.
  
    ```javascript
    Ember.changeProperties(function() {
      obj1.set('foo', mayBlowUpWhenSet);
      obj2.set('bar', baz);
    });
    ```
  
    @method changeProperties
    @param {Function} callback
    @param [binding]
    @private
  */
  function changeProperties(callback, binding) {
    beginPropertyChanges();
    try {
      callback.call(binding);
    } finally {
      endPropertyChanges.call(binding);
    }
  }

  function notifyBeforeObservers(obj, keyName, meta) {
    if (meta && meta.isSourceDestroying()) {
      return;
    }

    var eventName = keyName + ':before';
    var listeners = undefined,
        added = undefined;
    if (deferred) {
      listeners = beforeObserverSet.add(obj, keyName, eventName);
      added = _emberMetalEvents.accumulateListeners(obj, eventName, listeners);
      _emberMetalEvents.sendEvent(obj, eventName, [obj, keyName], added);
    } else {
      _emberMetalEvents.sendEvent(obj, eventName, [obj, keyName]);
    }
  }

  function notifyObservers(obj, keyName, meta) {
    if (meta && meta.isSourceDestroying()) {
      return;
    }

    var eventName = keyName + ':change';
    var listeners = undefined;
    if (deferred) {
      listeners = observerSet.add(obj, keyName, eventName);
      _emberMetalEvents.accumulateListeners(obj, eventName, listeners);
    } else {
      _emberMetalEvents.sendEvent(obj, eventName, [obj, keyName]);
    }
  }

  exports.propertyWillChange = propertyWillChange;
  exports.propertyDidChange = propertyDidChange;
  exports.overrideChains = overrideChains;
  exports.beginPropertyChanges = beginPropertyChanges;
  exports.endPropertyChanges = endPropertyChanges;
  exports.changeProperties = changeProperties;
});
enifed('ember-metal/property_get', ['exports', 'ember-debug', 'ember-metal/path_cache'], function (exports, _emberDebug, _emberMetalPath_cache) {
  /**
  @module ember-metal
  */

  'use strict';

  exports.get = get;
  exports._getPath = _getPath;
  exports.getWithDefault = getWithDefault;

  var ALLOWABLE_TYPES = {
    object: true,
    function: true,
    string: true
  };

  // ..........................................................
  // GET AND SET
  //
  // If we are on a platform that supports accessors we can use those.
  // Otherwise simulate accessors by looking up the property directly on the
  // object.

  /**
    Gets the value of a property on an object. If the property is computed,
    the function will be invoked. If the property is not defined but the
    object implements the `unknownProperty` method then that will be invoked.
  
    ```javascript
    Ember.get(obj, "name");
    ```
  
    If you plan to run on IE8 and older browsers then you should use this
    method anytime you want to retrieve a property on an object that you don't
    know for sure is private. (Properties beginning with an underscore '_'
    are considered private.)
  
    On all newer browsers, you only need to use this method to retrieve
    properties if the property might not be defined on the object and you want
    to respect the `unknownProperty` handler. Otherwise you can ignore this
    method.
  
    Note that if the object itself is `undefined`, this method will throw
    an error.
  
    @method get
    @for Ember
    @param {Object} obj The object to retrieve from.
    @param {String} keyName The property key to retrieve
    @return {Object} the property value or `null`.
    @public
  */

  function get(obj, keyName) {
    _emberDebug.assert('Get must be called with two arguments; an object and a property key', arguments.length === 2);
    _emberDebug.assert('Cannot call get with \'' + keyName + '\' on an undefined object.', obj !== undefined && obj !== null);
    _emberDebug.assert('The key provided to get must be a string, you passed ' + keyName, typeof keyName === 'string');
    _emberDebug.assert('\'this\' in paths is not supported', !_emberMetalPath_cache.hasThis(keyName));
    _emberDebug.assert('Cannot call `Ember.get` with an empty string', keyName !== '');

    var value = obj[keyName];
    var desc = value !== null && typeof value === 'object' && value.isDescriptor ? value : undefined;
    var ret = undefined;

    if (desc === undefined && _emberMetalPath_cache.isPath(keyName)) {
      return _getPath(obj, keyName);
    }

    if (desc) {
      return desc.get(obj, keyName);
    } else {
      ret = value;

      if (ret === undefined && 'object' === typeof obj && !(keyName in obj) && 'function' === typeof obj.unknownProperty) {
        return obj.unknownProperty(keyName);
      }

      return ret;
    }
  }

  function _getPath(root, path) {
    var obj = root;
    var parts = path.split('.');

    for (var i = 0; i < parts.length; i++) {
      if (!isGettable(obj)) {
        return undefined;
      }

      obj = get(obj, parts[i]);

      if (obj && obj.isDestroyed) {
        return undefined;
      }
    }

    return obj;
  }

  function isGettable(obj) {
    if (obj == null) {
      return false;
    }

    return ALLOWABLE_TYPES[typeof obj];
  }

  /**
    Retrieves the value of a property from an Object, or a default value in the
    case that the property returns `undefined`.
  
    ```javascript
    Ember.getWithDefault(person, 'lastName', 'Doe');
    ```
  
    @method getWithDefault
    @for Ember
    @param {Object} obj The object to retrieve from.
    @param {String} keyName The name of the property to retrieve
    @param {Object} defaultValue The value to return if the property value is undefined
    @return {Object} The property value or the defaultValue.
    @public
  */

  function getWithDefault(root, key, defaultValue) {
    var value = get(root, key);

    if (value === undefined) {
      return defaultValue;
    }
    return value;
  }

  exports.default = get;
});
enifed('ember-metal/property_set', ['exports', 'ember-utils', 'ember-debug', 'ember-metal/property_get', 'ember-metal/property_events', 'ember-metal/path_cache', 'ember-metal/meta'], function (exports, _emberUtils, _emberDebug, _emberMetalProperty_get, _emberMetalProperty_events, _emberMetalPath_cache, _emberMetalMeta) {
  'use strict';

  exports.set = set;
  exports.trySet = trySet;

  /**
    Sets the value of a property on an object, respecting computed properties
    and notifying observers and other listeners of the change. If the
    property is not defined but the object implements the `setUnknownProperty`
    method then that will be invoked as well.
  
    ```javascript
    Ember.set(obj, "name", value);
    ```
  
    @method set
    @for Ember
    @param {Object} obj The object to modify.
    @param {String} keyName The property key to set
    @param {Object} value The value to set
    @return {Object} the passed value.
    @public
  */

  function set(obj, keyName, value, tolerant) {
    _emberDebug.assert('Set must be called with three or four arguments; an object, a property key, a value and tolerant true/false', arguments.length === 3 || arguments.length === 4);
    _emberDebug.assert('Cannot call set with \'' + keyName + '\' on an undefined object.', obj && typeof obj === 'object' || typeof obj === 'function');
    _emberDebug.assert('The key provided to set must be a string, you passed ' + keyName, typeof keyName === 'string');
    _emberDebug.assert('\'this\' in paths is not supported', !_emberMetalPath_cache.hasThis(keyName));
    _emberDebug.assert('calling set on destroyed object: ' + _emberUtils.toString(obj) + '.' + keyName + ' = ' + _emberUtils.toString(value), !obj.isDestroyed);

    if (_emberMetalPath_cache.isPath(keyName)) {
      return setPath(obj, keyName, value, tolerant);
    }

    var meta = _emberMetalMeta.peekMeta(obj);
    var possibleDesc = obj[keyName];

    var desc = undefined,
        currentValue = undefined;
    if (possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor) {
      desc = possibleDesc;
    } else {
      currentValue = possibleDesc;
    }

    if (desc) {
      /* computed property */
      desc.set(obj, keyName, value);
    } else if (obj.setUnknownProperty && currentValue === undefined && !(keyName in obj)) {
      /* unknown property */
      _emberDebug.assert('setUnknownProperty must be a function', typeof obj.setUnknownProperty === 'function');
      obj.setUnknownProperty(keyName, value);
    } else if (currentValue === value) {
      /* no change */
      return value;
    } else {
      _emberMetalProperty_events.propertyWillChange(obj, keyName);

      if (true) {
        setWithMandatorySetter(meta, obj, keyName, value);
      } else {
        obj[keyName] = value;
      }

      _emberMetalProperty_events.propertyDidChange(obj, keyName);
    }

    return value;
  }

  if (true) {
    var setWithMandatorySetter = function (meta, obj, keyName, value) {
      if (meta && meta.peekWatching(keyName) > 0) {
        makeEnumerable(obj, keyName);
        meta.writeValue(obj, keyName, value);
      } else {
        obj[keyName] = value;
      }
    };

    var makeEnumerable = function (obj, key) {
      var desc = Object.getOwnPropertyDescriptor(obj, key);

      if (desc && desc.set && desc.set.isMandatorySetter) {
        desc.enumerable = true;
        Object.defineProperty(obj, key, desc);
      }
    };
  }

  function setPath(root, path, value, tolerant) {
    // get the last part of the path
    var keyName = path.slice(path.lastIndexOf('.') + 1);

    // get the first part of the part
    path = path === keyName ? keyName : path.slice(0, path.length - (keyName.length + 1));

    // unless the path is this, look up the first part to
    // get the root
    if (path !== 'this') {
      root = _emberMetalProperty_get._getPath(root, path);
    }

    if (!keyName || keyName.length === 0) {
      throw new _emberDebug.Error('Property set failed: You passed an empty path');
    }

    if (!root) {
      if (tolerant) {
        return;
      } else {
        throw new _emberDebug.Error('Property set failed: object in path "' + path + '" could not be found or was destroyed.');
      }
    }

    return set(root, keyName, value);
  }

  /**
    Error-tolerant form of `Ember.set`. Will not blow up if any part of the
    chain is `undefined`, `null`, or destroyed.
  
    This is primarily used when syncing bindings, which may try to update after
    an object has been destroyed.
  
    @method trySet
    @for Ember
    @param {Object} root The object to modify.
    @param {String} path The property path to set
    @param {Object} value The value to set
    @public
  */

  function trySet(root, path, value) {
    return set(root, path, value, true);
  }
});
enifed("ember-metal/replace", ["exports"], function (exports) {
  "use strict";

  exports.default = replace;
  var splice = Array.prototype.splice;

  function replace(array, idx, amt, objects) {
    var args = [].concat(objects);
    var ret = [];
    // https://code.google.com/p/chromium/issues/detail?id=56588
    var size = 60000;
    var start = idx;
    var ends = amt;
    var count = undefined,
        chunk = undefined;

    while (args.length) {
      count = ends > size ? size : ends;
      if (count <= 0) {
        count = 0;
      }

      chunk = args.splice(0, size);
      chunk = [start, count].concat(chunk);

      start += size;
      ends -= count;

      ret = ret.concat(splice.apply(array, chunk));
    }
    return ret;
  }
});
enifed('ember-metal/run_loop', ['exports', 'ember-utils', 'ember-debug', 'ember-metal/error_handler', 'ember-metal/property_events', 'backburner'], function (exports, _emberUtils, _emberDebug, _emberMetalError_handler, _emberMetalProperty_events, _backburner) {
  'use strict';

  exports.default = run;

  function onBegin(current) {
    run.currentRunLoop = current;
  }

  function onEnd(current, next) {
    run.currentRunLoop = next;
  }

  var onErrorTarget = {
    get onerror() {
      return _emberMetalError_handler.dispatchError;
    },
    set onerror(handler) {
      return _emberMetalError_handler.setOnerror(handler);
    }
  };

  var backburner = new _backburner.default(['sync', 'actions', 'destroy'], {
    GUID_KEY: _emberUtils.GUID_KEY,
    sync: {
      before: _emberMetalProperty_events.beginPropertyChanges,
      after: _emberMetalProperty_events.endPropertyChanges
    },
    defaultQueue: 'actions',
    onBegin: onBegin,
    onEnd: onEnd,
    onErrorTarget: onErrorTarget,
    onErrorMethod: 'onerror'
  });

  // ..........................................................
  // run - this is ideally the only public API the dev sees
  //

  /**
    Runs the passed target and method inside of a RunLoop, ensuring any
    deferred actions including bindings and views updates are flushed at the
    end.
  
    Normally you should not need to invoke this method yourself. However if
    you are implementing raw event handlers when interfacing with other
    libraries or plugins, you should probably wrap all of your code inside this
    call.
  
    ```javascript
    run(function() {
      // code to be executed within a RunLoop
    });
    ```
  
    @class run
    @namespace Ember
    @static
    @constructor
    @param {Object} [target] target of method to call
    @param {Function|String} method Method to invoke.
      May be a function or a string. If you pass a string
      then it will be looked up on the passed target.
    @param {Object} [args*] Any additional arguments you wish to pass to the method.
    @return {Object} return value from invoking the passed function.
    @public
  */

  function run() {
    return backburner.run.apply(backburner, arguments);
  }

  /**
    If no run-loop is present, it creates a new one. If a run loop is
    present it will queue itself to run on the existing run-loops action
    queue.
  
    Please note: This is not for normal usage, and should be used sparingly.
  
    If invoked when not within a run loop:
  
    ```javascript
    run.join(function() {
      // creates a new run-loop
    });
    ```
  
    Alternatively, if called within an existing run loop:
  
    ```javascript
    run(function() {
      // creates a new run-loop
      run.join(function() {
        // joins with the existing run-loop, and queues for invocation on
        // the existing run-loops action queue.
      });
    });
    ```
  
    @method join
    @namespace Ember
    @param {Object} [target] target of method to call
    @param {Function|String} method Method to invoke.
      May be a function or a string. If you pass a string
      then it will be looked up on the passed target.
    @param {Object} [args*] Any additional arguments you wish to pass to the method.
    @return {Object} Return value from invoking the passed function. Please note,
    when called within an existing loop, no return value is possible.
    @public
  */
  run.join = function () {
    return backburner.join.apply(backburner, arguments);
  };

  /**
    Allows you to specify which context to call the specified function in while
    adding the execution of that function to the Ember run loop. This ability
    makes this method a great way to asynchronously integrate third-party libraries
    into your Ember application.
  
    `run.bind` takes two main arguments, the desired context and the function to
    invoke in that context. Any additional arguments will be supplied as arguments
    to the function that is passed in.
  
    Let's use the creation of a TinyMCE component as an example. Currently,
    TinyMCE provides a setup configuration option we can use to do some processing
    after the TinyMCE instance is initialized but before it is actually rendered.
    We can use that setup option to do some additional setup for our component.
    The component itself could look something like the following:
  
    ```javascript
    App.RichTextEditorComponent = Ember.Component.extend({
      initializeTinyMCE: Ember.on('didInsertElement', function() {
        tinymce.init({
          selector: '#' + this.$().prop('id'),
          setup: Ember.run.bind(this, this.setupEditor)
        });
      }),
  
      setupEditor: function(editor) {
        this.set('editor', editor);
  
        editor.on('change', function() {
          console.log('content changed!');
        });
      }
    });
    ```
  
    In this example, we use Ember.run.bind to bind the setupEditor method to the
    context of the App.RichTextEditorComponent and to have the invocation of that
    method be safely handled and executed by the Ember run loop.
  
    @method bind
    @namespace Ember
    @param {Object} [target] target of method to call
    @param {Function|String} method Method to invoke.
      May be a function or a string. If you pass a string
      then it will be looked up on the passed target.
    @param {Object} [args*] Any additional arguments you wish to pass to the method.
    @return {Function} returns a new function that will always have a particular context
    @since 1.4.0
    @public
  */
  run.bind = function () {
    for (var _len = arguments.length, curried = Array(_len), _key = 0; _key < _len; _key++) {
      curried[_key] = arguments[_key];
    }

    return function () {
      for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }

      return run.join.apply(run, curried.concat(args));
    };
  };

  run.backburner = backburner;
  run.currentRunLoop = null;
  run.queues = backburner.queueNames;

  /**
    Begins a new RunLoop. Any deferred actions invoked after the begin will
    be buffered until you invoke a matching call to `run.end()`. This is
    a lower-level way to use a RunLoop instead of using `run()`.
  
    ```javascript
    run.begin();
    // code to be executed within a RunLoop
    run.end();
    ```
  
    @method begin
    @return {void}
    @public
  */
  run.begin = function () {
    backburner.begin();
  };

  /**
    Ends a RunLoop. This must be called sometime after you call
    `run.begin()` to flush any deferred actions. This is a lower-level way
    to use a RunLoop instead of using `run()`.
  
    ```javascript
    run.begin();
    // code to be executed within a RunLoop
    run.end();
    ```
  
    @method end
    @return {void}
    @public
  */
  run.end = function () {
    backburner.end();
  };

  /**
    Array of named queues. This array determines the order in which queues
    are flushed at the end of the RunLoop. You can define your own queues by
    simply adding the queue name to this array. Normally you should not need
    to inspect or modify this property.
  
    @property queues
    @type Array
    @default ['sync', 'actions', 'destroy']
    @private
  */

  /**
    Adds the passed target/method and any optional arguments to the named
    queue to be executed at the end of the RunLoop. If you have not already
    started a RunLoop when calling this method one will be started for you
    automatically.
  
    At the end of a RunLoop, any methods scheduled in this way will be invoked.
    Methods will be invoked in an order matching the named queues defined in
    the `run.queues` property.
  
    ```javascript
    run.schedule('sync', this, function() {
      // this will be executed in the first RunLoop queue, when bindings are synced
      console.log('scheduled on sync queue');
    });
  
    run.schedule('actions', this, function() {
      // this will be executed in the 'actions' queue, after bindings have synced.
      console.log('scheduled on actions queue');
    });
  
    // Note the functions will be run in order based on the run queues order.
    // Output would be:
    //   scheduled on sync queue
    //   scheduled on actions queue
    ```
  
    @method schedule
    @param {String} queue The name of the queue to schedule against.
      Default queues are 'sync' and 'actions'
    @param {Object} [target] target object to use as the context when invoking a method.
    @param {String|Function} method The method to invoke. If you pass a string it
      will be resolved on the target object at the time the scheduled item is
      invoked allowing you to change the target function.
    @param {Object} [arguments*] Optional arguments to be passed to the queued method.
    @return {*} Timer information for use in cancelling, see `run.cancel`.
    @public
  */
  run.schedule = function () /* queue, target, method */{
    _emberDebug.assert('You have turned on testing mode, which disabled the run-loop\'s autorun. ' + 'You will need to wrap any code with asynchronous side-effects in a run', run.currentRunLoop || !_emberDebug.isTesting());

    return backburner.schedule.apply(backburner, arguments);
  };

  // Used by global test teardown
  run.hasScheduledTimers = function () {
    return backburner.hasTimers();
  };

  // Used by global test teardown
  run.cancelTimers = function () {
    backburner.cancelTimers();
  };

  /**
    Immediately flushes any events scheduled in the 'sync' queue. Bindings
    use this queue so this method is a useful way to immediately force all
    bindings in the application to sync.
  
    You should call this method anytime you need any changed state to propagate
    throughout the app immediately without repainting the UI (which happens
    in the later 'render' queue added by the `ember-views` package).
  
    ```javascript
    run.sync();
    ```
  
    @method sync
    @return {void}
    @private
  */
  run.sync = function () {
    if (backburner.currentInstance) {
      backburner.currentInstance.queues.sync.flush();
    }
  };

  /**
    Invokes the passed target/method and optional arguments after a specified
    period of time. The last parameter of this method must always be a number
    of milliseconds.
  
    You should use this method whenever you need to run some action after a
    period of time instead of using `setTimeout()`. This method will ensure that
    items that expire during the same script execution cycle all execute
    together, which is often more efficient than using a real setTimeout.
  
    ```javascript
    run.later(myContext, function() {
      // code here will execute within a RunLoop in about 500ms with this == myContext
    }, 500);
    ```
  
    @method later
    @param {Object} [target] target of method to invoke
    @param {Function|String} method The method to invoke.
      If you pass a string it will be resolved on the
      target at the time the method is invoked.
    @param {Object} [args*] Optional arguments to pass to the timeout.
    @param {Number} wait Number of milliseconds to wait.
    @return {*} Timer information for use in cancelling, see `run.cancel`.
    @public
  */
  run.later = function () /*target, method*/{
    return backburner.later.apply(backburner, arguments);
  };

  /**
    Schedule a function to run one time during the current RunLoop. This is equivalent
    to calling `scheduleOnce` with the "actions" queue.
  
    @method once
    @param {Object} [target] The target of the method to invoke.
    @param {Function|String} method The method to invoke.
      If you pass a string it will be resolved on the
      target at the time the method is invoked.
    @param {Object} [args*] Optional arguments to pass to the timeout.
    @return {Object} Timer information for use in cancelling, see `run.cancel`.
    @public
  */
  run.once = function () {
    _emberDebug.assert('You have turned on testing mode, which disabled the run-loop\'s autorun. ' + 'You will need to wrap any code with asynchronous side-effects in a run', run.currentRunLoop || !_emberDebug.isTesting());

    for (var _len3 = arguments.length, args = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
      args[_key3] = arguments[_key3];
    }

    args.unshift('actions');
    return backburner.scheduleOnce.apply(backburner, args);
  };

  /**
    Schedules a function to run one time in a given queue of the current RunLoop.
    Calling this method with the same queue/target/method combination will have
    no effect (past the initial call).
  
    Note that although you can pass optional arguments these will not be
    considered when looking for duplicates. New arguments will replace previous
    calls.
  
    ```javascript
    function sayHi() {
      console.log('hi');
    }
  
    run(function() {
      run.scheduleOnce('afterRender', myContext, sayHi);
      run.scheduleOnce('afterRender', myContext, sayHi);
      // sayHi will only be executed once, in the afterRender queue of the RunLoop
    });
    ```
  
    Also note that passing an anonymous function to `run.scheduleOnce` will
    not prevent additional calls with an identical anonymous function from
    scheduling the items multiple times, e.g.:
  
    ```javascript
    function scheduleIt() {
      run.scheduleOnce('actions', myContext, function() {
        console.log('Closure');
      });
    }
  
    scheduleIt();
    scheduleIt();
  
    // "Closure" will print twice, even though we're using `run.scheduleOnce`,
    // because the function we pass to it is anonymous and won't match the
    // previously scheduled operation.
    ```
  
    Available queues, and their order, can be found at `run.queues`
  
    @method scheduleOnce
    @param {String} [queue] The name of the queue to schedule against. Default queues are 'sync' and 'actions'.
    @param {Object} [target] The target of the method to invoke.
    @param {Function|String} method The method to invoke.
      If you pass a string it will be resolved on the
      target at the time the method is invoked.
    @param {Object} [args*] Optional arguments to pass to the timeout.
    @return {Object} Timer information for use in cancelling, see `run.cancel`.
    @public
  */
  run.scheduleOnce = function () /*queue, target, method*/{
    _emberDebug.assert('You have turned on testing mode, which disabled the run-loop\'s autorun. ' + 'You will need to wrap any code with asynchronous side-effects in a run', run.currentRunLoop || !_emberDebug.isTesting());
    return backburner.scheduleOnce.apply(backburner, arguments);
  };

  /**
    Schedules an item to run from within a separate run loop, after
    control has been returned to the system. This is equivalent to calling
    `run.later` with a wait time of 1ms.
  
    ```javascript
    run.next(myContext, function() {
      // code to be executed in the next run loop,
      // which will be scheduled after the current one
    });
    ```
  
    Multiple operations scheduled with `run.next` will coalesce
    into the same later run loop, along with any other operations
    scheduled by `run.later` that expire right around the same
    time that `run.next` operations will fire.
  
    Note that there are often alternatives to using `run.next`.
    For instance, if you'd like to schedule an operation to happen
    after all DOM element operations have completed within the current
    run loop, you can make use of the `afterRender` run loop queue (added
    by the `ember-views` package, along with the preceding `render` queue
    where all the DOM element operations happen).
  
    Example:
  
    ```javascript
    export default Ember.Component.extend({
      didInsertElement() {
        this._super(...arguments);
        run.scheduleOnce('afterRender', this, 'processChildElements');
      },
  
      processChildElements() {
        // ... do something with component's child component
        // elements after they've finished rendering, which
        // can't be done within this component's
        // `didInsertElement` hook because that gets run
        // before the child elements have been added to the DOM.
      }
    });
    ```
  
    One benefit of the above approach compared to using `run.next` is
    that you will be able to perform DOM/CSS operations before unprocessed
    elements are rendered to the screen, which may prevent flickering or
    other artifacts caused by delaying processing until after rendering.
  
    The other major benefit to the above approach is that `run.next`
    introduces an element of non-determinism, which can make things much
    harder to test, due to its reliance on `setTimeout`; it's much harder
    to guarantee the order of scheduled operations when they are scheduled
    outside of the current run loop, i.e. with `run.next`.
  
    @method next
    @param {Object} [target] target of method to invoke
    @param {Function|String} method The method to invoke.
      If you pass a string it will be resolved on the
      target at the time the method is invoked.
    @param {Object} [args*] Optional arguments to pass to the timeout.
    @return {Object} Timer information for use in cancelling, see `run.cancel`.
    @public
  */
  run.next = function () {
    for (var _len4 = arguments.length, args = Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
      args[_key4] = arguments[_key4];
    }

    args.push(1);
    return backburner.later.apply(backburner, args);
  };

  /**
    Cancels a scheduled item. Must be a value returned by `run.later()`,
    `run.once()`, `run.scheduleOnce()`, `run.next()`, `run.debounce()`, or
    `run.throttle()`.
  
    ```javascript
    let runNext = run.next(myContext, function() {
      // will not be executed
    });
  
    run.cancel(runNext);
  
    let runLater = run.later(myContext, function() {
      // will not be executed
    }, 500);
  
    run.cancel(runLater);
  
    let runScheduleOnce = run.scheduleOnce('afterRender', myContext, function() {
      // will not be executed
    });
  
    run.cancel(runScheduleOnce);
  
    let runOnce = run.once(myContext, function() {
      // will not be executed
    });
  
    run.cancel(runOnce);
  
    let throttle = run.throttle(myContext, function() {
      // will not be executed
    }, 1, false);
  
    run.cancel(throttle);
  
    let debounce = run.debounce(myContext, function() {
      // will not be executed
    }, 1);
  
    run.cancel(debounce);
  
    let debounceImmediate = run.debounce(myContext, function() {
      // will be executed since we passed in true (immediate)
    }, 100, true);
  
    // the 100ms delay until this method can be called again will be cancelled
    run.cancel(debounceImmediate);
    ```
  
    @method cancel
    @param {Object} timer Timer object to cancel
    @return {Boolean} true if cancelled or false/undefined if it wasn't found
    @public
  */
  run.cancel = function (timer) {
    return backburner.cancel(timer);
  };

  /**
    Delay calling the target method until the debounce period has elapsed
    with no additional debounce calls. If `debounce` is called again before
    the specified time has elapsed, the timer is reset and the entire period
    must pass again before the target method is called.
  
    This method should be used when an event may be called multiple times
    but the action should only be called once when the event is done firing.
    A common example is for scroll events where you only want updates to
    happen once scrolling has ceased.
  
    ```javascript
    function whoRan() {
      console.log(this.name + ' ran.');
    }
  
    let myContext = { name: 'debounce' };
  
    run.debounce(myContext, whoRan, 150);
  
    // less than 150ms passes
    run.debounce(myContext, whoRan, 150);
  
    // 150ms passes
    // whoRan is invoked with context myContext
    // console logs 'debounce ran.' one time.
    ```
  
    Immediate allows you to run the function immediately, but debounce
    other calls for this function until the wait time has elapsed. If
    `debounce` is called again before the specified time has elapsed,
    the timer is reset and the entire period must pass again before
    the method can be called again.
  
    ```javascript
    function whoRan() {
      console.log(this.name + ' ran.');
    }
  
    let myContext = { name: 'debounce' };
  
    run.debounce(myContext, whoRan, 150, true);
  
    // console logs 'debounce ran.' one time immediately.
    // 100ms passes
    run.debounce(myContext, whoRan, 150, true);
  
    // 150ms passes and nothing else is logged to the console and
    // the debouncee is no longer being watched
    run.debounce(myContext, whoRan, 150, true);
  
    // console logs 'debounce ran.' one time immediately.
    // 150ms passes and nothing else is logged to the console and
    // the debouncee is no longer being watched
  
    ```
  
    @method debounce
    @param {Object} [target] target of method to invoke
    @param {Function|String} method The method to invoke.
      May be a function or a string. If you pass a string
      then it will be looked up on the passed target.
    @param {Object} [args*] Optional arguments to pass to the timeout.
    @param {Number} wait Number of milliseconds to wait.
    @param {Boolean} immediate Trigger the function on the leading instead
      of the trailing edge of the wait interval. Defaults to false.
    @return {Array} Timer information for use in cancelling, see `run.cancel`.
    @public
  */
  run.debounce = function () {
    return backburner.debounce.apply(backburner, arguments);
  };

  /**
    Ensure that the target method is never called more frequently than
    the specified spacing period. The target method is called immediately.
  
    ```javascript
    function whoRan() {
      console.log(this.name + ' ran.');
    }
  
    let myContext = { name: 'throttle' };
  
    run.throttle(myContext, whoRan, 150);
    // whoRan is invoked with context myContext
    // console logs 'throttle ran.'
  
    // 50ms passes
    run.throttle(myContext, whoRan, 150);
  
    // 50ms passes
    run.throttle(myContext, whoRan, 150);
  
    // 150ms passes
    run.throttle(myContext, whoRan, 150);
    // whoRan is invoked with context myContext
    // console logs 'throttle ran.'
    ```
  
    @method throttle
    @param {Object} [target] target of method to invoke
    @param {Function|String} method The method to invoke.
      May be a function or a string. If you pass a string
      then it will be looked up on the passed target.
    @param {Object} [args*] Optional arguments to pass to the timeout.
    @param {Number} spacing Number of milliseconds to space out requests.
    @param {Boolean} immediate Trigger the function on the leading instead
      of the trailing edge of the wait interval. Defaults to true.
    @return {Array} Timer information for use in cancelling, see `run.cancel`.
    @public
  */
  run.throttle = function () {
    return backburner.throttle.apply(backburner, arguments);
  };

  /**
    Add a new named queue after the specified queue.
  
    The queue to add will only be added once.
  
    @method _addQueue
    @param {String} name the name of the queue to add.
    @param {String} after the name of the queue to add after.
    @private
  */
  run._addQueue = function (name, after) {
    if (run.queues.indexOf(name) === -1) {
      run.queues.splice(run.queues.indexOf(after) + 1, 0, name);
    }
  };
});
enifed('ember-metal/set_properties', ['exports', 'ember-metal/property_events', 'ember-metal/property_set'], function (exports, _emberMetalProperty_events, _emberMetalProperty_set) {
  'use strict';

  exports.default = setProperties;

  /**
    Set a list of properties on an object. These properties are set inside
    a single `beginPropertyChanges` and `endPropertyChanges` batch, so
    observers will be buffered.
  
    ```javascript
    let anObject = Ember.Object.create();
  
    anObject.setProperties({
      firstName: 'Stanley',
      lastName: 'Stuart',
      age: 21
    });
    ```
  
    @method setProperties
    @param obj
    @param {Object} properties
    @return properties
    @public
  */

  function setProperties(obj, properties) {
    if (!properties || typeof properties !== 'object') {
      return properties;
    }
    _emberMetalProperty_events.changeProperties(function () {
      var props = Object.keys(properties);
      var propertyName = undefined;

      for (var i = 0; i < props.length; i++) {
        propertyName = props[i];

        _emberMetalProperty_set.set(obj, propertyName, properties[propertyName]);
      }
    });
    return properties;
  }
});
enifed('ember-metal/tags', ['exports', '@glimmer/reference', 'ember-metal/meta', 'require', 'ember-metal/is_proxy'], function (exports, _glimmerReference, _emberMetalMeta, _require, _emberMetalIs_proxy) {
  'use strict';

  exports.setHasViews = setHasViews;
  exports.tagForProperty = tagForProperty;
  exports.tagFor = tagFor;
  exports.markObjectAsDirty = markObjectAsDirty;

  var hasViews = function () {
    return false;
  };

  function setHasViews(fn) {
    hasViews = fn;
  }

  function makeTag() {
    return new _glimmerReference.DirtyableTag();
  }

  function tagForProperty(object, propertyKey, _meta) {
    if (_emberMetalIs_proxy.isProxy(object)) {
      return tagFor(object, _meta);
    }

    if (typeof object === 'object' && object) {
      var meta = _meta || _emberMetalMeta.meta(object);
      var tags = meta.writableTags();
      var tag = tags[propertyKey];
      if (tag) {
        return tag;
      }

      return tags[propertyKey] = makeTag();
    } else {
      return _glimmerReference.CONSTANT_TAG;
    }
  }

  function tagFor(object, _meta) {
    if (typeof object === 'object' && object) {
      var meta = _meta || _emberMetalMeta.meta(object);
      return meta.writableTag(makeTag);
    } else {
      return _glimmerReference.CONSTANT_TAG;
    }
  }

  function markObjectAsDirty(meta, propertyKey) {
    var objectTag = meta && meta.readableTag();

    if (objectTag) {
      objectTag.dirty();
    }

    var tags = meta && meta.readableTags();
    var propertyTag = tags && tags[propertyKey];

    if (propertyTag) {
      propertyTag.dirty();
    }

    if (objectTag || propertyTag) {
      ensureRunloop();
    }
  }

  var run = undefined;

  function K() {}

  function ensureRunloop() {
    if (!run) {
      run = _require.default('ember-metal/run_loop').default;
    }

    if (hasViews() && !run.backburner.currentInstance) {
      run.schedule('actions', K);
    }
  }
});
enifed('ember-metal/transaction', ['exports', 'ember-metal/meta', 'ember-debug'], function (exports, _emberMetalMeta, _emberDebug) {
  'use strict';

  var runInTransaction = undefined,
      didRender = undefined,
      assertNotRendered = undefined;

  // detect-backtracking-rerender by default is debug build only
  // detect-glimmer-allow-backtracking-rerender can be enabled in custom builds
  if (true || false) {
    (function () {
      var counter = 0;
      var inTransaction = false;
      var shouldReflush = undefined;
      var debugStack = undefined;

      exports.default = runInTransaction = function (context, methodName) {
        shouldReflush = false;
        inTransaction = true;
        _emberDebug.runInDebug(function () {
          debugStack = context.env.debugStack;
        });
        context[methodName]();
        inTransaction = false;
        counter++;
        return shouldReflush;
      };

      exports.didRender = didRender = function (object, key, reference) {
        if (!inTransaction) {
          return;
        }
        var meta = _emberMetalMeta.meta(object);
        var lastRendered = meta.writableLastRendered();
        lastRendered[key] = counter;

        _emberDebug.runInDebug(function () {
          var referenceMap = meta.writableLastRenderedReferenceMap();
          referenceMap[key] = reference;

          var templateMap = meta.writableLastRenderedTemplateMap();
          if (templateMap[key] === undefined) {
            templateMap[key] = debugStack.peek();
          }
        });
      };

      exports.assertNotRendered = assertNotRendered = function (object, key, _meta) {
        var meta = _meta || _emberMetalMeta.meta(object);
        var lastRendered = meta.readableLastRendered();

        if (lastRendered && lastRendered[key] === counter) {
          _emberDebug.runInDebug(function () {
            var templateMap = meta.readableLastRenderedTemplateMap();
            var lastRenderedIn = templateMap[key];
            var currentlyIn = debugStack.peek();

            var referenceMap = meta.readableLastRenderedReferenceMap();
            var lastRef = referenceMap[key];
            var parts = [];
            var label = undefined;

            if (lastRef) {
              while (lastRef && lastRef._propertyKey) {
                parts.unshift(lastRef._propertyKey);
                lastRef = lastRef._parentReference;
              }

              label = parts.join('.');
            } else {
              label = 'the same value';
            }

            var message = 'You modified "' + label + '" twice on ' + object + ' in a single render. It was rendered in ' + lastRenderedIn + ' and modified in ' + currentlyIn + '. This was unreliable and slow in Ember 1.x and';

            if (false) {
              _emberDebug.deprecate(message + ' will be removed in Ember 3.0.', false, { id: 'ember-views.render-double-modify', until: '3.0.0' });
            } else {
              _emberDebug.assert(message + ' is no longer supported. See https://github.com/emberjs/ember.js/issues/13948 for more details.', false);
            }
          });

          shouldReflush = true;
        }
      };
    })();
  } else {
    // in production do nothing to detect reflushes
    exports.default = runInTransaction = function (context, methodName) {
      context[methodName]();
      return false;
    };
  }

  exports.default = runInTransaction;
  exports.didRender = didRender;
  exports.assertNotRendered = assertNotRendered;
});
enifed('ember-metal/watch_key', ['exports', 'ember-utils', 'ember-debug', 'ember-metal/meta', 'ember-metal/properties'], function (exports, _emberUtils, _emberDebug, _emberMetalMeta, _emberMetalProperties) {
  'use strict';

  exports.watchKey = watchKey;
  exports.unwatchKey = unwatchKey;

  var handleMandatorySetter = undefined;

  function watchKey(obj, keyName, meta) {
    if (typeof obj !== 'object' || obj === null) {
      return;
    }
    var m = meta || _emberMetalMeta.meta(obj);

    // activate watching first time
    if (!m.peekWatching(keyName)) {
      m.writeWatching(keyName, 1);

      var possibleDesc = obj[keyName];
      var desc = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor ? possibleDesc : undefined;
      if (desc && desc.willWatch) {
        desc.willWatch(obj, keyName);
      }

      if ('function' === typeof obj.willWatchProperty) {
        obj.willWatchProperty(keyName);
      }

      if (true) {
        // NOTE: this is dropped for prod + minified builds
        handleMandatorySetter(m, obj, keyName);
      }
    } else {
      m.writeWatching(keyName, (m.peekWatching(keyName) || 0) + 1);
    }
  }

  if (true) {
    (function () {
      var hasOwnProperty = function (obj, key) {
        return Object.prototype.hasOwnProperty.call(obj, key);
      };

      var propertyIsEnumerable = function (obj, key) {
        return Object.prototype.propertyIsEnumerable.call(obj, key);
      };

      // Future traveler, although this code looks scary. It merely exists in
      // development to aid in development asertions. Production builds of
      // ember strip this entire block out
      handleMandatorySetter = function handleMandatorySetter(m, obj, keyName) {
        var descriptor = _emberUtils.lookupDescriptor(obj, keyName);
        var configurable = descriptor ? descriptor.configurable : true;
        var isWritable = descriptor ? descriptor.writable : true;
        var hasValue = descriptor ? 'value' in descriptor : true;
        var possibleDesc = descriptor && descriptor.value;
        var isDescriptor = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor;

        if (isDescriptor) {
          return;
        }

        // this x in Y deopts, so keeping it in this function is better;
        if (configurable && isWritable && hasValue && keyName in obj) {
          var desc = {
            configurable: true,
            set: _emberMetalProperties.MANDATORY_SETTER_FUNCTION(keyName),
            enumerable: propertyIsEnumerable(obj, keyName),
            get: undefined
          };

          if (hasOwnProperty(obj, keyName)) {
            m.writeValues(keyName, obj[keyName]);
            desc.get = _emberMetalProperties.DEFAULT_GETTER_FUNCTION(keyName);
          } else {
            desc.get = _emberMetalProperties.INHERITING_GETTER_FUNCTION(keyName);
          }

          Object.defineProperty(obj, keyName, desc);
        }
      };
    })();
  }

  function unwatchKey(obj, keyName, _meta) {
    if (typeof obj !== 'object' || obj === null) {
      return;
    }
    var meta = _meta || _emberMetalMeta.meta(obj);

    // do nothing of this object has already been destroyed
    if (meta.isSourceDestroyed()) {
      return;
    }

    var count = meta.peekWatching(keyName);
    if (count === 1) {
      meta.writeWatching(keyName, 0);

      var possibleDesc = obj[keyName];
      var desc = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor ? possibleDesc : undefined;

      if (desc && desc.didUnwatch) {
        desc.didUnwatch(obj, keyName);
      }

      if ('function' === typeof obj.didUnwatchProperty) {
        obj.didUnwatchProperty(keyName);
      }

      if (true) {
        // It is true, the following code looks quite WAT. But have no fear, It
        // exists purely to improve development ergonomics and is removed from
        // ember.min.js and ember.prod.js builds.
        //
        // Some further context: Once a property is watched by ember, bypassing `set`
        // for mutation, will bypass observation. This code exists to assert when
        // that occurs, and attempt to provide more helpful feedback. The alternative
        // is tricky to debug partially observable properties.
        if (!desc && keyName in obj) {
          var maybeMandatoryDescriptor = _emberUtils.lookupDescriptor(obj, keyName);

          if (maybeMandatoryDescriptor.set && maybeMandatoryDescriptor.set.isMandatorySetter) {
            if (maybeMandatoryDescriptor.get && maybeMandatoryDescriptor.get.isInheritingGetter) {
              var possibleValue = meta.readInheritedValue('values', keyName);
              if (possibleValue === _emberMetalMeta.UNDEFINED) {
                delete obj[keyName];
                return;
              }
            }

            Object.defineProperty(obj, keyName, {
              configurable: true,
              enumerable: Object.prototype.propertyIsEnumerable.call(obj, keyName),
              writable: true,
              value: meta.peekValues(keyName)
            });
            meta.deleteFromValues(keyName);
          }
        }
      }
    } else if (count > 1) {
      meta.writeWatching(keyName, count - 1);
    }
  }
});
enifed('ember-metal/watch_path', ['exports', 'ember-metal/meta', 'ember-metal/chains'], function (exports, _emberMetalMeta, _emberMetalChains) {
  'use strict';

  exports.makeChainNode = makeChainNode;
  exports.watchPath = watchPath;
  exports.unwatchPath = unwatchPath;

  // get the chains for the current object. If the current object has
  // chains inherited from the proto they will be cloned and reconfigured for
  // the current object.
  function chainsFor(obj, meta) {
    return (meta || _emberMetalMeta.meta(obj)).writableChains(makeChainNode);
  }

  function makeChainNode(obj) {
    return new _emberMetalChains.ChainNode(null, null, obj);
  }

  function watchPath(obj, keyPath, meta) {
    if (typeof obj !== 'object' || obj === null) {
      return;
    }
    var m = meta || _emberMetalMeta.meta(obj);
    var counter = m.peekWatching(keyPath) || 0;
    if (!counter) {
      // activate watching first time
      m.writeWatching(keyPath, 1);
      chainsFor(obj, m).add(keyPath);
    } else {
      m.writeWatching(keyPath, counter + 1);
    }
  }

  function unwatchPath(obj, keyPath, meta) {
    if (typeof obj !== 'object' || obj === null) {
      return;
    }
    var m = meta || _emberMetalMeta.meta(obj);
    var counter = m.peekWatching(keyPath) || 0;

    if (counter === 1) {
      m.writeWatching(keyPath, 0);
      chainsFor(obj, m).remove(keyPath);
    } else if (counter > 1) {
      m.writeWatching(keyPath, counter - 1);
    }
  }
});
enifed('ember-metal/watching', ['exports', 'ember-metal/watch_key', 'ember-metal/watch_path', 'ember-metal/path_cache', 'ember-metal/meta'], function (exports, _emberMetalWatch_key, _emberMetalWatch_path, _emberMetalPath_cache, _emberMetalMeta) {
  /**
  @module ember-metal
  */

  'use strict';

  exports.isWatching = isWatching;
  exports.watcherCount = watcherCount;
  exports.unwatch = unwatch;
  exports.destroy = destroy;

  /**
    Starts watching a property on an object. Whenever the property changes,
    invokes `Ember.propertyWillChange` and `Ember.propertyDidChange`. This is the
    primitive used by observers and dependent keys; usually you will never call
    this method directly but instead use higher level methods like
    `Ember.addObserver()`
  
    @private
    @method watch
    @for Ember
    @param obj
    @param {String} _keyPath
  */
  function watch(obj, _keyPath, m) {
    if (!_emberMetalPath_cache.isPath(_keyPath)) {
      _emberMetalWatch_key.watchKey(obj, _keyPath, m);
    } else {
      _emberMetalWatch_path.watchPath(obj, _keyPath, m);
    }
  }

  exports.watch = watch;

  function isWatching(obj, key) {
    if (typeof obj !== 'object' || obj === null) {
      return false;
    }
    var meta = _emberMetalMeta.peekMeta(obj);
    return (meta && meta.peekWatching(key)) > 0;
  }

  function watcherCount(obj, key) {
    var meta = _emberMetalMeta.peekMeta(obj);
    return meta && meta.peekWatching(key) || 0;
  }

  function unwatch(obj, _keyPath, m) {
    if (!_emberMetalPath_cache.isPath(_keyPath)) {
      _emberMetalWatch_key.unwatchKey(obj, _keyPath, m);
    } else {
      _emberMetalWatch_path.unwatchPath(obj, _keyPath, m);
    }
  }

  /**
    Tears down the meta on an object so that it can be garbage collected.
    Multiple calls will have no effect.
  
    @method destroy
    @for Ember
    @param {Object} obj  the object to destroy
    @return {void}
    @private
  */

  function destroy(obj) {
    _emberMetalMeta.deleteMeta(obj);
  }
});
enifed('ember-metal/weak_map', ['exports', 'ember-utils', 'ember-metal/meta'], function (exports, _emberUtils, _emberMetalMeta) {
  'use strict';

  exports.default = WeakMap;

  var id = 0;

  // Returns whether Type(value) is Object according to the terminology in the spec
  function isObject(value) {
    return typeof value === 'object' && value !== null || typeof value === 'function';
  }

  /*
   * @class Ember.WeakMap
   * @public
   * @category ember-metal-weakmap
   *
   * A partial polyfill for [WeakMap](http://www.ecma-international.org/ecma-262/6.0/#sec-weakmap-objects).
   *
   * There is a small but important caveat. This implementation assumes that the
   * weak map will live longer (in the sense of garbage collection) than all of its
   * keys, otherwise it is possible to leak the values stored in the weak map. In
   * practice, most use cases satisfy this limitation which is why it is included
   * in ember-metal.
   */

  function WeakMap(iterable) {
    if (!(this instanceof WeakMap)) {
      throw new TypeError('Constructor WeakMap requires \'new\'');
    }

    this._id = _emberUtils.GUID_KEY + id++;

    if (iterable === null || iterable === undefined) {
      return;
    } else if (Array.isArray(iterable)) {
      for (var i = 0; i < iterable.length; i++) {
        var _iterable$i = iterable[i];
        var key = _iterable$i[0];
        var value = _iterable$i[1];

        this.set(key, value);
      }
    } else {
      throw new TypeError('The weak map constructor polyfill only supports an array argument');
    }
  }

  /*
   * @method get
   * @param key {Object | Function}
   * @return {Any} stored value
   */
  WeakMap.prototype.get = function (obj) {
    if (!isObject(obj)) {
      return undefined;
    }

    var meta = _emberMetalMeta.peekMeta(obj);
    if (meta) {
      var map = meta.readableWeak();
      if (map) {
        if (map[this._id] === _emberMetalMeta.UNDEFINED) {
          return undefined;
        }

        return map[this._id];
      }
    }
  };

  /*
   * @method set
   * @param key {Object | Function}
   * @param value {Any}
   * @return {WeakMap} the weak map
   */
  WeakMap.prototype.set = function (obj, value) {
    if (!isObject(obj)) {
      throw new TypeError('Invalid value used as weak map key');
    }

    if (value === undefined) {
      value = _emberMetalMeta.UNDEFINED;
    }

    _emberMetalMeta.meta(obj).writableWeak()[this._id] = value;

    return this;
  };

  /*
   * @method has
   * @param key {Object | Function}
   * @return {boolean} if the key exists
   */
  WeakMap.prototype.has = function (obj) {
    if (!isObject(obj)) {
      return false;
    }

    var meta = _emberMetalMeta.peekMeta(obj);
    if (meta) {
      var map = meta.readableWeak();
      if (map) {
        return map[this._id] !== undefined;
      }
    }

    return false;
  };

  /*
   * @method delete
   * @param key {Object | Function}
   * @return {boolean} if the key was deleted
   */
  WeakMap.prototype.delete = function (obj) {
    if (this.has(obj)) {
      delete _emberMetalMeta.meta(obj).writableWeak()[this._id];
      return true;
    } else {
      return false;
    }
  };

  /*
   * @method toString
   * @return {String}
   */
  WeakMap.prototype.toString = function () {
    return '[object WeakMap]';
  };
});
enifed('ember-routing/ext/controller', ['exports', 'ember-metal', 'ember-runtime', 'ember-routing/utils'], function (exports, _emberMetal, _emberRuntime, _emberRoutingUtils) {
  'use strict';

  /**
  @module ember
  @submodule ember-routing
  */

  _emberRuntime.ControllerMixin.reopen({
    concatenatedProperties: ['queryParams'],

    /**
      Defines which query parameters the controller accepts.
      If you give the names `['category','page']` it will bind
      the values of these query parameters to the variables
      `this.category` and `this.page`.
      By default, Ember coerces query parameter values using `toggleProperty`.
      This behavior may lead to unexpected results.
      To explicity configure a query parameter property so it coerces as expected, you must define a type property:
      ```javascript
        queryParams: [{
          category: {
            type: 'boolean'
          }
        }]
      ```
      @property queryParams
      @public
    */
    queryParams: null,

    /**
     This property is updated to various different callback functions depending on
     the current "state" of the backing route. It is used by
     `Ember.Controller.prototype._qpChanged`.
      The methods backing each state can be found in the `Ember.Route.prototype._qp` computed
     property return value (the `.states` property). The current values are listed here for
     the sanity of future travelers:
      * `inactive` - This state is used when this controller instance is not part of the active
       route heirarchy. Set in `Ember.Route.prototype._reset` (a `router.js` microlib hook) and
       `Ember.Route.prototype.actions.finalizeQueryParamChange`.
     * `active` - This state is used when this controller instance is part of the active
       route heirarchy. Set in `Ember.Route.prototype.actions.finalizeQueryParamChange`.
     * `allowOverrides` - This state is used in `Ember.Route.prototype.setup` (`route.js` microlib hook).
       @method _qpDelegate
      @private
    */
    _qpDelegate: null, // set by route

    /**
     During `Ember.Route#setup` observers are created to invoke this method
     when any of the query params declared in `Ember.Controller#queryParams` property
     are changed.
       When invoked this method uses the currently active query param update delegate
     (see `Ember.Controller.prototype._qpDelegate` for details) and invokes it with
     the QP key/value being changed.
       @method _qpChanged
   