// Generated by CoffeeScript 1.8.0
(function() {
  var cluster, master, os, worker;

  cluster = require("cluster");

  os = require("os");

  master = function(config) {
    var i, respawn, worker, workerCount, workers, _i, _ref, _ref1;
    workerCount = ((_ref = config.count) != null ? _ref : parseInt(process.env.WORKER_COUNT)) || os.cpus().length;
    respawn = typeof config.respawn === "undefined" ? true : Boolean(config.respawn);
    workers = [];
    if (config.verbose) {
      console.log("Master started on pid " + process.pid + ", forking " + workerCount + " processes");
    }
    for (i = _i = 0, _ref1 = workerCount - 1; 0 <= _ref1 ? _i <= _ref1 : _i >= _ref1; i = 0 <= _ref1 ? ++_i : --_i) {
      worker = cluster.fork();
      if (typeof config.workerListener === "function") {
        worker.on("message", config.workerListener);
      }
      workers.push(worker);
    }
    cluster.on("exit", function(worker, code, signal) {
      var idx;
      if (config.verbose) {
        console.log("" + worker.process.pid + " died with code " + code, respawn ? "restarting" : "");
      }
      idx = workers.indexOf(worker);
      if (idx > -1) {
        workers.splice(idx, 1);
      }
      if (respawn) {
        worker = cluster.fork();
        if (typeof config.workerListener === "function") {
          worker.on("message", config.workerListener);
        }
        return workers.push(worker);
      }
    });
    return process.on("SIGQUIT", function() {
      var _j, _len, _results;
      respawn = false;
      if (config.verbose) {
        console.log("QUIT received, will exit once all workers have finished current requests");
      }
      _results = [];
      for (_j = 0, _len = workers.length; _j < _len; _j++) {
        worker = workers[_j];
        _results.push(worker.send("quit"));
      }
      return _results;
    });
  };

  worker = function(fn, worker) {
    var server;
    server = fn(worker);
    if (!server) {
      return;
    }
    if (typeof server.on === "function") {
      server.on("close", function() {
        return process.exit();
      });
    }
    if (typeof server.close === "function") {
      return process.on("message", function(msg) {
        if (msg === "quit") {
          return server.close();
        }
      });
    }
  };

  module.exports = function(arg0, arg1) {
    var config, fn;
    fn = function() {};
    config = {};
    if (typeof arg0 === 'function') {
      fn = arg0;
      config = arg1 || config;
    } else if (typeof arg1 === 'function') {
      fn = arg1;
      config = arg0 || config;
    }
    if (cluster.isMaster) {
      return master(config);
    } else {
      return worker(fn, cluster.worker);
    }
  };

}).call(this);
