"use strict";
var chalk = require('chalk');
var cluster = require('cluster');
var UI = (function () {
    function UI() {
        var type = cluster.isMaster ? 'm' : 'w';
        this.pid = "" + type + process.pid;
    }
    UI.prototype.writeLine = function () {
        var args = Array.prototype.slice.apply(arguments);
        args.unshift('blue');
        this._write.apply(this, args);
    };
    UI.prototype.writeError = function (message) {
        console.log(this._errorPrefix() + chalk.red(message));
    };
    UI.prototype._write = function () {
        var args = Array.prototype.slice.apply(arguments);
        var color = args.shift();
        if (args[0] !== null || args[0] !== undefined) {
            args[0] = this._prefix(color) + args[0];
        }
        console.log.apply(console, args);
    };
    UI.prototype._prefix = function () {
        var timestamp = chalk.bgBlue.white(this._timestamp());
        var pid = chalk.blue(this._pid());
        return "" + timestamp + pid + " ";
    };
    UI.prototype._errorPrefix = function () {
        var timestamp = chalk.bgRed.white(this._timestamp());
        var pid = chalk.red(this._pid());
        return "" + timestamp + pid + " ";
    };
    UI.prototype._timestamp = function () {
        return "[" + (new Date()).toISOString() + "]";
    };
    UI.prototype._pid = function () {
        return this.pid ? "[" + this.pid + "]" : '';
    };
    return UI;
}());
module.exports = UI;
