"use strict";
var sourceMapSupport = require('source-map-support');
function prepareStackTrace(error, stack) {
    return error + stack.map(function (frame) {
        return '\n    at ' + sourceMapSupport.wrapCallSite(frame);
    }).join('');
}
function install(errorClass) {
    if (errorClass) {
        errorClass.prepareStackTrace = prepareStackTrace;
        errorClass.stackTraceLimit = Infinity;
        sourceMapSupport.install({
            environment: 'node',
            handleUncaughtExceptions: false,
        });
    }
}
module.exports = {
    install: install
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5zdGFsbC1zb3VyY2UtbWFwLXN1cHBvcnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbnN0YWxsLXNvdXJjZS1tYXAtc3VwcG9ydC5qcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsSUFBSSxnQkFBZ0IsR0FBRyxPQUFPLENBQUMsb0JBQW9CLENBQUMsQ0FBQztBQUVyRCwyQkFBMkIsS0FBSyxFQUFFLEtBQUs7SUFDckMsTUFBTSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUMsR0FBRyxDQUFDLFVBQVMsS0FBSztRQUNyQyxNQUFNLENBQUMsV0FBVyxHQUFHLGdCQUFnQixDQUFDLFlBQVksQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUM1RCxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDLENBQUM7QUFDZCxDQUFDO0FBRUQsaUJBQWlCLFVBQVU7SUFDekIsRUFBRSxDQUFDLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQztRQUNmLFVBQVUsQ0FBQyxpQkFBaUIsR0FBRyxpQkFBaUIsQ0FBQztRQUNqRCxVQUFVLENBQUMsZUFBZSxHQUFHLFFBQVEsQ0FBQztRQUN0QyxnQkFBZ0IsQ0FBQyxPQUFPLENBQUM7WUFDdkIsV0FBVyxFQUFFLE1BQU07WUFDbkIsd0JBQXdCLEVBQUUsS0FBSztTQUNoQyxDQUFDLENBQUM7SUFDTCxDQUFDO0FBQ0gsQ0FBQztBQUVELE1BQU0sQ0FBQyxPQUFPLEdBQUc7SUFDZixPQUFPLEVBQUUsT0FBTztDQUNqQixDQUFDIn0=