"use strict";
var chalk = require('chalk');
function Sandbox() {
}
Sandbox.prototype.init = function (options) {
    this.globals = options.globals;
    this.sandbox = this.buildSandbox();
};
Sandbox.prototype.buildSandbox = function () {
    var console = this.buildWrappedConsole();
    var sourceMapSupport = require('./install-source-map-support');
    var URL = require('url');
    var globals = this.globals;
    var sandbox = {
        sourceMapSupport: sourceMapSupport,
        console: console,
        setTimeout: setTimeout,
        clearTimeout: clearTimeout,
        URL: URL,
        // Convince jQuery not to assume it's in a browser
        module: { exports: {} }
    };
    for (var key in globals) {
        sandbox[key] = globals[key];
    }
    // Set the global as `window`.
    sandbox.window = sandbox;
    sandbox.window.self = sandbox;
    return sandbox;
};
Sandbox.prototype.buildWrappedConsole = function () {
    var wrappedConsole = Object.create(console);
    wrappedConsole.error = function () {
        console.error.apply(console, Array.prototype.map.call(arguments, function (a) {
            return typeof a === 'string' ? chalk.red(a) : a;
        }));
    };
    return wrappedConsole;
};
module.exports = Sandbox;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2FuZGJveC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInNhbmRib3guanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLElBQUksS0FBSyxHQUFHLE9BQU8sQ0FBQyxPQUFPLENBQUMsQ0FBQztBQUU3QjtBQUNBLENBQUM7QUFFRCxPQUFPLENBQUMsU0FBUyxDQUFDLElBQUksR0FBRyxVQUFTLE9BQU87SUFDdkMsSUFBSSxDQUFDLE9BQU8sR0FBRyxPQUFPLENBQUMsT0FBTyxDQUFDO0lBQy9CLElBQUksQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFDLFlBQVksRUFBRSxDQUFDO0FBQ3JDLENBQUMsQ0FBQztBQUVGLE9BQU8sQ0FBQyxTQUFTLENBQUMsWUFBWSxHQUFHO0lBQy9CLElBQUksT0FBTyxHQUFHLElBQUksQ0FBQyxtQkFBbUIsRUFBRSxDQUFDO0lBQ3pDLElBQUksZ0JBQWdCLEdBQUcsT0FBTyxDQUFDLDhCQUE4QixDQUFDLENBQUM7SUFDL0QsSUFBSSxHQUFHLEdBQUcsT0FBTyxDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQ3pCLElBQUksT0FBTyxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUM7SUFFM0IsSUFBSSxPQUFPLEdBQUc7UUFDWixnQkFBZ0IsRUFBRSxnQkFBZ0I7UUFDbEMsT0FBTyxFQUFFLE9BQU87UUFDaEIsVUFBVSxFQUFFLFVBQVU7UUFDdEIsWUFBWSxFQUFFLFlBQVk7UUFDMUIsR0FBRyxFQUFFLEdBQUc7UUFFUixrREFBa0Q7UUFDbEQsTUFBTSxFQUFFLEVBQUUsT0FBTyxFQUFFLEVBQUUsRUFBRTtLQUN4QixDQUFDO0lBRUYsR0FBRyxDQUFDLENBQUMsSUFBSSxHQUFHLElBQUksT0FBTyxDQUFDLENBQUMsQ0FBQztRQUN4QixPQUFPLENBQUMsR0FBRyxDQUFDLEdBQUcsT0FBTyxDQUFDLEdBQUcsQ0FBQyxDQUFDO0lBQzlCLENBQUM7SUFFRCw4QkFBOEI7SUFDOUIsT0FBTyxDQUFDLE1BQU0sR0FBRyxPQUFPLENBQUM7SUFDekIsT0FBTyxDQUFDLE1BQU0sQ0FBQyxJQUFJLEdBQUcsT0FBTyxDQUFDO0lBRTlCLE1BQU0sQ0FBQyxPQUFPLENBQUM7QUFDakIsQ0FBQyxDQUFDO0FBRUYsT0FBTyxDQUFDLFNBQVMsQ0FBQyxtQkFBbUIsR0FBRztJQUN0QyxJQUFJLGNBQWMsR0FBSSxNQUFNLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxDQUFDO0lBQzdDLGNBQWMsQ0FBQyxLQUFLLEdBQUc7UUFDckIsT0FBTyxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsT0FBTyxFQUFFLEtBQUssQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsVUFBUyxDQUFDO1lBQ3pFLE1BQU0sQ0FBQyxPQUFPLENBQUMsS0FBSyxRQUFRLEdBQUcsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUM7UUFDbEQsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNOLENBQUMsQ0FBQztJQUVGLE1BQU0sQ0FBQyxjQUFjLENBQUM7QUFDeEIsQ0FBQyxDQUFDO0FBRUYsTUFBTSxDQUFDLE9BQU8sR0FBRyxPQUFPLENBQUMifQ==