// Generated by CoffeeScript 1.9.1
(function() {
  var Git, exec, fs, options_to_argv, ref, spawn;

  fs = require('fs');

  ref = require('child_process'), exec = ref.exec, spawn = ref.spawn;

  module.exports = Git = function(git_dir, dot_git, git_options) {
    var git;
    git_options || (git_options = {});
    dot_git || (dot_git = git_dir + "/.git");
    git = function(command, options, args, callback, encoding) {
      var bash, ref1, ref2;
      if (!callback) {
        ref1 = [args, callback], callback = ref1[0], args = ref1[1];
      }
      if (!callback) {
        ref2 = [options, callback], callback = ref2[0], options = ref2[1];
      }
      if (options == null) {
        options = {};
      }
      options = options_to_argv(options);
      options = options.join(" ");
      if (args == null) {
        args = [];
      }
      if (args instanceof Array) {
        args = args.join(" ");
      }
      if (encoding == null) {
        encoding = 'utf8';
      }
      bash = (git_options.bin || Git.bin) + " " + command + " " + options + " " + args;
      exec(bash, {
        cwd: git_dir,
        encoding: encoding,
        maxBuffer: 5000 * 1024
      }, callback);
      return bash;
    };
    git.cmd = function(command, options, args, callback, encoding) {
      return git(command, options, args, encoding, callback);
    };
    git.streamCmd = function(command, options, args, encoding) {
      var allargs, process;
      if (options == null) {
        options = {};
      }
      options = options_to_argv(options);
      if (args == null) {
        args = [];
      }
      allargs = [command].concat(options).concat(args);
      if (encoding == null) {
        encoding = 'utf8';
      }
      process = spawn(Git.bin, allargs, {
        cwd: git_dir,
        encoding: encoding
      });
      return [process.stdout, process.stderr];
    };
    git.list_remotes = function(callback) {
      return fs.readdir(dot_git + "/refs/remotes", function(err, files) {
        return callback(err, files || []);
      });
    };
    git.refs = function(type, options, callback) {
      var prefix, ref1;
      if (!callback) {
        ref1 = [options, callback], callback = ref1[0], options = ref1[1];
      }
      prefix = "refs/" + type + "s/";
      return git("show-ref", function(err, text) {
        var i, id, len, line, matches, name, ref2, ref3;
        if ((err != null ? err.code : void 0) === 1) {
          err = null;
        }
        matches = [];
        ref2 = (text || "").split("\n");
        for (i = 0, len = ref2.length; i < len; i++) {
          line = ref2[i];
          if (!line) {
            continue;
          }
          ref3 = line.split(' '), id = ref3[0], name = ref3[1];
          if (name.substr(0, prefix.length) === prefix) {
            matches.push((name.substr(prefix.length)) + " " + id);
          }
        }
        return callback(err, matches.join("\n"));
      });
    };
    return git;
  };

  Git.bin = "git";

  Git.options_to_argv = options_to_argv = function(options) {
    var argv, key, val;
    argv = [];
    for (key in options) {
      val = options[key];
      if (key.length === 1) {
        if (val === true) {
          argv.push("-" + key);
        } else if (val === false) {

        } else {
          argv.push("-" + key);
          argv.push(val);
        }
      } else {
        if (val === true) {
          argv.push("--" + key);
        } else if (val === false) {

        } else {
          argv.push("--" + key + "=" + val);
        }
      }
    }
    return argv;
  };

}).call(this);
