// Generated by CoffeeScript 1.9.1
(function() {
  var S, Status;

  module.exports = S = function(repo, options, callback) {
    return repo.git("status --porcelain", options, function(err, stdout, stderr) {
      var status;
      status = new Status(repo);
      status.parse(stdout);
      return callback(err, status);
    });
  };

  S.Status = Status = (function() {
    function Status(repo1) {
      this.repo = repo1;
    }

    Status.prototype.parse = function(text) {
      var file, i, len, line, ref, results, type;
      this.files = {};
      this.clean = text.length === 0;
      ref = text.split("\n");
      results = [];
      for (i = 0, len = ref.length; i < len; i++) {
        line = ref[i];
        if (line.length === 0) {
          continue;
        }
        file = line.substr(3);
        type = line.substr(0, 2);
        this.files[file] = {
          staged: line[0] !== " " && line[0] !== "?",
          tracked: line[0] !== "?"
        };
        if (type !== "??") {
          results.push(this.files[file].type = type.trim());
        } else {
          results.push(void 0);
        }
      }
      return results;
    };

    return Status;

  })();

}).call(this);
