// Generated by CoffeeScript 1.9.1
(function() {
  var Blob, Submodule, Tree, _;

  _ = require('underscore');

  Blob = require('./blob');

  Submodule = require('./submodule');

  module.exports = Tree = (function() {
    function Tree(repo, options) {
      this.repo = repo;
      if (_.isString(options)) {
        this.id = options;
      } else {
        this.id = options.id, this.name = options.name, this.mode = options.mode;
      }
    }

    Tree.prototype.contents = function(callback) {
      if (this._contents) {
        return callback(null, this._contents);
      }
      return this.repo.git("ls-tree", {}, this.id, (function(_this) {
        return function(err, stdout, stderr) {
          var i, len, line, ref;
          if (err) {
            return callback(err);
          }
          _this._contents = [];
          ref = stdout.split("\n");
          for (i = 0, len = ref.length; i < len; i++) {
            line = ref[i];
            if (line) {
              _this._contents.push(_this.content_from_string(line));
            }
          }
          return callback(null, _this._contents);
        };
      })(this), 'binary');
    };

    Tree.prototype.blobs = function(callback) {
      return this.contents(function(err, children) {
        if (err) {
          return callback(err);
        }
        return callback(null, _.filter(children, function(child) {
          return child instanceof Blob;
        }));
      });
    };

    Tree.prototype.trees = function(callback) {
      return this.contents(function(err, children) {
        if (err) {
          return callback(err);
        }
        return callback(null, _.filter(children, function(child) {
          return child instanceof Tree;
        }));
      });
    };

    Tree.prototype.find = function(file, callback) {
      var dir, ref, rest;
      if (/\//.test(file)) {
        ref = file.split("/", 2), dir = ref[0], rest = ref[1];
        return this.trees((function(_this) {
          return function(err, _trees) {
            var i, len, tree;
            for (i = 0, len = _trees.length; i < len; i++) {
              tree = _trees[i];
              if (tree.name === dir) {
                return tree.find(rest, callback);
              }
            }
            return callback(null, null);
          };
        })(this));
      } else {
        return this.contents(function(err, children) {
          var child, i, len;
          if (err) {
            return callback(err);
          }
          for (i = 0, len = children.length; i < len; i++) {
            child = children[i];
            if (child.name === file) {
              return callback(null, child);
            }
          }
          return callback(null, null);
        });
      }
    };

    Tree.prototype.content_from_string = function(line) {
      var id, mode, name, ref, type;
      ref = line.split(/[\t ]+/, 4), mode = ref[0], type = ref[1], id = ref[2], name = ref[3];
      switch (type) {
        case "tree":
          return new Tree(this.repo, {
            id: id,
            name: name,
            mode: mode
          });
        case "blob":
          return new Blob(this.repo, {
            id: id,
            name: name,
            mode: mode
          });
        case "link":
          return new Blob(this.repo, {
            id: id,
            name: name,
            mode: mode
          });
        case "commit":
          return new Submodule(this.repo, {
            id: id,
            name: name,
            mode: mode
          });
        default:
          throw new Error("Invalid object type: '" + type + "'");
      }
    };

    Tree.prototype.toString = function() {
      return "#<Tree '" + this.id + "'>";
    };

    return Tree;

  })();

}).call(this);
