// Code generated by protoc-gen-go. DO NOT EDIT.
// source: gossip/message.proto

/*
Package gossip is a generated protocol buffer package.

It is generated from these files:
	gossip/message.proto

It has these top-level messages:
	Envelope
	SecretEnvelope
	Secret
	GossipMessage
	StateInfo
	StateInfoSnapshot
	StateInfoPullRequest
	ConnEstablish
	PeerIdentity
	DataRequest
	GossipHello
	DataUpdate
	DataDigest
	DataMessage
	Payload
	AliveMessage
	LeadershipMessage
	PeerTime
	MembershipRequest
	MembershipResponse
	Member
	Empty
	RemoteStateRequest
	RemoteStateResponse
*/
package gossip

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type PullMsgType int32

const (
	PullMsgType_UNDEFINED    PullMsgType = 0
	PullMsgType_BLOCK_MSG    PullMsgType = 1
	PullMsgType_IDENTITY_MSG PullMsgType = 2
)

var PullMsgType_name = map[int32]string{
	0: "UNDEFINED",
	1: "BLOCK_MSG",
	2: "IDENTITY_MSG",
}
var PullMsgType_value = map[string]int32{
	"UNDEFINED":    0,
	"BLOCK_MSG":    1,
	"IDENTITY_MSG": 2,
}

func (x PullMsgType) String() string {
	return proto.EnumName(PullMsgType_name, int32(x))
}
func (PullMsgType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type GossipMessage_Tag int32

const (
	GossipMessage_UNDEFINED    GossipMessage_Tag = 0
	GossipMessage_EMPTY        GossipMessage_Tag = 1
	GossipMessage_ORG_ONLY     GossipMessage_Tag = 2
	GossipMessage_CHAN_ONLY    GossipMessage_Tag = 3
	GossipMessage_CHAN_AND_ORG GossipMessage_Tag = 4
	GossipMessage_CHAN_OR_ORG  GossipMessage_Tag = 5
)

var GossipMessage_Tag_name = map[int32]string{
	0: "UNDEFINED",
	1: "EMPTY",
	2: "ORG_ONLY",
	3: "CHAN_ONLY",
	4: "CHAN_AND_ORG",
	5: "CHAN_OR_ORG",
}
var GossipMessage_Tag_value = map[string]int32{
	"UNDEFINED":    0,
	"EMPTY":        1,
	"ORG_ONLY":     2,
	"CHAN_ONLY":    3,
	"CHAN_AND_ORG": 4,
	"CHAN_OR_ORG":  5,
}

func (x GossipMessage_Tag) String() string {
	return proto.EnumName(GossipMessage_Tag_name, int32(x))
}
func (GossipMessage_Tag) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{3, 0} }

// Envelope contains a marshalled
// GossipMessage and a signature over it.
// It may also contain a SecretEnvelope
// which is a marshalled Secret
type Envelope struct {
	Payload        []byte          `protobuf:"bytes,1,opt,name=payload,proto3" json:"payload,omitempty"`
	Signature      []byte          `protobuf:"bytes,2,opt,name=signature,proto3" json:"signature,omitempty"`
	SecretEnvelope *SecretEnvelope `protobuf:"bytes,3,opt,name=secret_envelope,json=secretEnvelope" json:"secret_envelope,omitempty"`
}

func (m *Envelope) Reset()                    { *m = Envelope{} }
func (m *Envelope) String() string            { return proto.CompactTextString(m) }
func (*Envelope) ProtoMessage()               {}
func (*Envelope) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Envelope) GetPayload() []byte {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *Envelope) GetSignature() []byte {
	if m != nil {
		return m.Signature
	}
	return nil
}

func (m *Envelope) GetSecretEnvelope() *SecretEnvelope {
	if m != nil {
		return m.SecretEnvelope
	}
	return nil
}

// SecretEnvelope is a marshalled Secret
// and a signature over it.
// The signature should be validated by the peer
// that signed the Envelope the SecretEnvelope
// came with
type SecretEnvelope struct {
	Payload   []byte `protobuf:"bytes,1,opt,name=payload,proto3" json:"payload,omitempty"`
	Signature []byte `protobuf:"bytes,2,opt,name=signature,proto3" json:"signature,omitempty"`
}

func (m *SecretEnvelope) Reset()                    { *m = SecretEnvelope{} }
func (m *SecretEnvelope) String() string            { return proto.CompactTextString(m) }
func (*SecretEnvelope) ProtoMessage()               {}
func (*SecretEnvelope) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *SecretEnvelope) GetPayload() []byte {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *SecretEnvelope) GetSignature() []byte {
	if m != nil {
		return m.Signature
	}
	return nil
}

// Secret is an entity that might be omitted
// from an Envelope when the remote peer that is receiving
// the Envelope shouldn't know the secret's content.
type Secret struct {
	// Types that are valid to be assigned to Content:
	//	*Secret_InternalEndpoint
	Content isSecret_Content `protobuf_oneof:"content"`
}

func (m *Secret) Reset()                    { *m = Secret{} }
func (m *Secret) String() string            { return proto.CompactTextString(m) }
func (*Secret) ProtoMessage()               {}
func (*Secret) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

type isSecret_Content interface {
	isSecret_Content()
}

type Secret_InternalEndpoint struct {
	InternalEndpoint string `protobuf:"bytes,1,opt,name=internalEndpoint,oneof"`
}

func (*Secret_InternalEndpoint) isSecret_Content() {}

func (m *Secret) GetContent() isSecret_Content {
	if m != nil {
		return m.Content
	}
	return nil
}

func (m *Secret) GetInternalEndpoint() string {
	if x, ok := m.GetContent().(*Secret_InternalEndpoint); ok {
		return x.InternalEndpoint
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Secret) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Secret_OneofMarshaler, _Secret_OneofUnmarshaler, _Secret_OneofSizer, []interface{}{
		(*Secret_InternalEndpoint)(nil),
	}
}

func _Secret_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Secret)
	// content
	switch x := m.Content.(type) {
	case *Secret_InternalEndpoint:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.InternalEndpoint)
	case nil:
	default:
		return fmt.Errorf("Secret.Content has unexpected type %T", x)
	}
	return nil
}

func _Secret_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Secret)
	switch tag {
	case 1: // content.internalEndpoint
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Content = &Secret_InternalEndpoint{x}
		return true, err
	default:
		return false, nil
	}
}

func _Secret_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Secret)
	// content
	switch x := m.Content.(type) {
	case *Secret_InternalEndpoint:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.InternalEndpoint)))
		n += len(x.InternalEndpoint)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// GossipMessage defines the message sent in a gossip network
type GossipMessage struct {
	// used mainly for testing, but will might be used in the future
	// for ensuring message delivery by acking
	Nonce uint64 `protobuf:"varint,1,opt,name=nonce" json:"nonce,omitempty"`
	// The channel of the message.
	// Some GossipMessages may set this to nil, because
	// they are cross-channels but some may not
	Channel []byte `protobuf:"bytes,2,opt,name=channel,proto3" json:"channel,omitempty"`
	// determines to which peers it is allowed
	// to forward the message
	Tag GossipMessage_Tag `protobuf:"varint,3,opt,name=tag,enum=gossip.GossipMessage_Tag" json:"tag,omitempty"`
	// Types that are valid to be assigned to Content:
	//	*GossipMessage_AliveMsg
	//	*GossipMessage_MemReq
	//	*GossipMessage_MemRes
	//	*GossipMessage_DataMsg
	//	*GossipMessage_Hello
	//	*GossipMessage_DataDig
	//	*GossipMessage_DataReq
	//	*GossipMessage_DataUpdate
	//	*GossipMessage_Empty
	//	*GossipMessage_Conn
	//	*GossipMessage_StateInfo
	//	*GossipMessage_StateSnapshot
	//	*GossipMessage_StateInfoPullReq
	//	*GossipMessage_StateRequest
	//	*GossipMessage_StateResponse
	//	*GossipMessage_LeadershipMsg
	//	*GossipMessage_PeerIdentity
	Content isGossipMessage_Content `protobuf_oneof:"content"`
}

func (m *GossipMessage) Reset()                    { *m = GossipMessage{} }
func (m *GossipMessage) String() string            { return proto.CompactTextString(m) }
func (*GossipMessage) ProtoMessage()               {}
func (*GossipMessage) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

type isGossipMessage_Content interface {
	isGossipMessage_Content()
}

type GossipMessage_AliveMsg struct {
	AliveMsg *AliveMessage `protobuf:"bytes,5,opt,name=alive_msg,json=aliveMsg,oneof"`
}
type GossipMessage_MemReq struct {
	MemReq *MembershipRequest `protobuf:"bytes,6,opt,name=mem_req,json=memReq,oneof"`
}
type GossipMessage_MemRes struct {
	MemRes *MembershipResponse `protobuf:"bytes,7,opt,name=mem_res,json=memRes,oneof"`
}
type GossipMessage_DataMsg struct {
	DataMsg *DataMessage `protobuf:"bytes,8,opt,name=data_msg,json=dataMsg,oneof"`
}
type GossipMessage_Hello struct {
	Hello *GossipHello `protobuf:"bytes,9,opt,name=hello,oneof"`
}
type GossipMessage_DataDig struct {
	DataDig *DataDigest `protobuf:"bytes,10,opt,name=data_dig,json=dataDig,oneof"`
}
type GossipMessage_DataReq struct {
	DataReq *DataRequest `protobuf:"bytes,11,opt,name=data_req,json=dataReq,oneof"`
}
type GossipMessage_DataUpdate struct {
	DataUpdate *DataUpdate `protobuf:"bytes,12,opt,name=data_update,json=dataUpdate,oneof"`
}
type GossipMessage_Empty struct {
	Empty *Empty `protobuf:"bytes,13,opt,name=empty,oneof"`
}
type GossipMessage_Conn struct {
	Conn *ConnEstablish `protobuf:"bytes,14,opt,name=conn,oneof"`
}
type GossipMessage_StateInfo struct {
	StateInfo *StateInfo `protobuf:"bytes,15,opt,name=state_info,json=stateInfo,oneof"`
}
type GossipMessage_StateSnapshot struct {
	StateSnapshot *StateInfoSnapshot `protobuf:"bytes,16,opt,name=state_snapshot,json=stateSnapshot,oneof"`
}
type GossipMessage_StateInfoPullReq struct {
	StateInfoPullReq *StateInfoPullRequest `protobuf:"bytes,17,opt,name=state_info_pull_req,json=stateInfoPullReq,oneof"`
}
type GossipMessage_StateRequest struct {
	StateRequest *RemoteStateRequest `protobuf:"bytes,18,opt,name=state_request,json=stateRequest,oneof"`
}
type GossipMessage_StateResponse struct {
	StateResponse *RemoteStateResponse `protobuf:"bytes,19,opt,name=state_response,json=stateResponse,oneof"`
}
type GossipMessage_LeadershipMsg struct {
	LeadershipMsg *LeadershipMessage `protobuf:"bytes,20,opt,name=leadership_msg,json=leadershipMsg,oneof"`
}
type GossipMessage_PeerIdentity struct {
	PeerIdentity *PeerIdentity `protobuf:"bytes,21,opt,name=peer_identity,json=peerIdentity,oneof"`
}

func (*GossipMessage_AliveMsg) isGossipMessage_Content()         {}
func (*GossipMessage_MemReq) isGossipMessage_Content()           {}
func (*GossipMessage_MemRes) isGossipMessage_Content()           {}
func (*GossipMessage_DataMsg) isGossipMessage_Content()          {}
func (*GossipMessage_Hello) isGossipMessage_Content()            {}
func (*GossipMessage_DataDig) isGossipMessage_Content()          {}
func (*GossipMessage_DataReq) isGossipMessage_Content()          {}
func (*GossipMessage_DataUpdate) isGossipMessage_Content()       {}
func (*GossipMessage_Empty) isGossipMessage_Content()            {}
func (*GossipMessage_Conn) isGossipMessage_Content()             {}
func (*GossipMessage_StateInfo) isGossipMessage_Content()        {}
func (*GossipMessage_StateSnapshot) isGossipMessage_Content()    {}
func (*GossipMessage_StateInfoPullReq) isGossipMessage_Content() {}
func (*GossipMessage_StateRequest) isGossipMessage_Content()     {}
func (*GossipMessage_StateResponse) isGossipMessage_Content()    {}
func (*GossipMessage_LeadershipMsg) isGossipMessage_Content()    {}
func (*GossipMessage_PeerIdentity) isGossipMessage_Content()     {}

func (m *GossipMessage) GetContent() isGossipMessage_Content {
	if m != nil {
		return m.Content
	}
	return nil
}

func (m *GossipMessage) GetNonce() uint64 {
	if m != nil {
		return m.Nonce
	}
	return 0
}

func (m *GossipMessage) GetChannel() []byte {
	if m != nil {
		return m.Channel
	}
	return nil
}

func (m *GossipMessage) GetTag() GossipMessage_Tag {
	if m != nil {
		return m.Tag
	}
	return GossipMessage_UNDEFINED
}

func (m *GossipMessage) GetAliveMsg() *AliveMessage {
	if x, ok := m.GetContent().(*GossipMessage_AliveMsg); ok {
		return x.AliveMsg
	}
	return nil
}

func (m *GossipMessage) GetMemReq() *MembershipRequest {
	if x, ok := m.GetContent().(*GossipMessage_MemReq); ok {
		return x.MemReq
	}
	return nil
}

func (m *GossipMessage) GetMemRes() *MembershipResponse {
	if x, ok := m.GetContent().(*GossipMessage_MemRes); ok {
		return x.MemRes
	}
	return nil
}

func (m *GossipMessage) GetDataMsg() *DataMessage {
	if x, ok := m.GetContent().(*GossipMessage_DataMsg); ok {
		return x.DataMsg
	}
	return nil
}

func (m *GossipMessage) GetHello() *GossipHello {
	if x, ok := m.GetContent().(*GossipMessage_Hello); ok {
		return x.Hello
	}
	return nil
}

func (m *GossipMessage) GetDataDig() *DataDigest {
	if x, ok := m.GetContent().(*GossipMessage_DataDig); ok {
		return x.DataDig
	}
	return nil
}

func (m *GossipMessage) GetDataReq() *DataRequest {
	if x, ok := m.GetContent().(*GossipMessage_DataReq); ok {
		return x.DataReq
	}
	return nil
}

func (m *GossipMessage) GetDataUpdate() *DataUpdate {
	if x, ok := m.GetContent().(*GossipMessage_DataUpdate); ok {
		return x.DataUpdate
	}
	return nil
}

func (m *GossipMessage) GetEmpty() *Empty {
	if x, ok := m.GetContent().(*GossipMessage_Empty); ok {
		return x.Empty
	}
	return nil
}

func (m *GossipMessage) GetConn() *ConnEstablish {
	if x, ok := m.GetContent().(*GossipMessage_Conn); ok {
		return x.Conn
	}
	return nil
}

func (m *GossipMessage) GetStateInfo() *StateInfo {
	if x, ok := m.GetContent().(*GossipMessage_StateInfo); ok {
		return x.StateInfo
	}
	return nil
}

func (m *GossipMessage) GetStateSnapshot() *StateInfoSnapshot {
	if x, ok := m.GetContent().(*GossipMessage_StateSnapshot); ok {
		return x.StateSnapshot
	}
	return nil
}

func (m *GossipMessage) GetStateInfoPullReq() *StateInfoPullRequest {
	if x, ok := m.GetContent().(*GossipMessage_StateInfoPullReq); ok {
		return x.StateInfoPullReq
	}
	return nil
}

func (m *GossipMessage) GetStateRequest() *RemoteStateRequest {
	if x, ok := m.GetContent().(*GossipMessage_StateRequest); ok {
		return x.StateRequest
	}
	return nil
}

func (m *GossipMessage) GetStateResponse() *RemoteStateResponse {
	if x, ok := m.GetContent().(*GossipMessage_StateResponse); ok {
		return x.StateResponse
	}
	return nil
}

func (m *GossipMessage) GetLeadershipMsg() *LeadershipMessage {
	if x, ok := m.GetContent().(*GossipMessage_LeadershipMsg); ok {
		return x.LeadershipMsg
	}
	return nil
}

func (m *GossipMessage) GetPeerIdentity() *PeerIdentity {
	if x, ok := m.GetContent().(*GossipMessage_PeerIdentity); ok {
		return x.PeerIdentity
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*GossipMessage) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _GossipMessage_OneofMarshaler, _GossipMessage_OneofUnmarshaler, _GossipMessage_OneofSizer, []interface{}{
		(*GossipMessage_AliveMsg)(nil),
		(*GossipMessage_MemReq)(nil),
		(*GossipMessage_MemRes)(nil),
		(*GossipMessage_DataMsg)(nil),
		(*GossipMessage_Hello)(nil),
		(*GossipMessage_DataDig)(nil),
		(*GossipMessage_DataReq)(nil),
		(*GossipMessage_DataUpdate)(nil),
		(*GossipMessage_Empty)(nil),
		(*GossipMessage_Conn)(nil),
		(*GossipMessage_StateInfo)(nil),
		(*GossipMessage_StateSnapshot)(nil),
		(*GossipMessage_StateInfoPullReq)(nil),
		(*GossipMessage_StateRequest)(nil),
		(*GossipMessage_StateResponse)(nil),
		(*GossipMessage_LeadershipMsg)(nil),
		(*GossipMessage_PeerIdentity)(nil),
	}
}

func _GossipMessage_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*GossipMessage)
	// content
	switch x := m.Content.(type) {
	case *GossipMessage_AliveMsg:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AliveMsg); err != nil {
			return err
		}
	case *GossipMessage_MemReq:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MemReq); err != nil {
			return err
		}
	case *GossipMessage_MemRes:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MemRes); err != nil {
			return err
		}
	case *GossipMessage_DataMsg:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DataMsg); err != nil {
			return err
		}
	case *GossipMessage_Hello:
		b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Hello); err != nil {
			return err
		}
	case *GossipMessage_DataDig:
		b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DataDig); err != nil {
			return err
		}
	case *GossipMessage_DataReq:
		b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DataReq); err != nil {
			return err
		}
	case *GossipMessage_DataUpdate:
		b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DataUpdate); err != nil {
			return err
		}
	case *GossipMessage_Empty:
		b.EncodeVarint(13<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Empty); err != nil {
			return err
		}
	case *GossipMessage_Conn:
		b.EncodeVarint(14<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Conn); err != nil {
			return err
		}
	case *GossipMessage_StateInfo:
		b.EncodeVarint(15<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StateInfo); err != nil {
			return err
		}
	case *GossipMessage_StateSnapshot:
		b.EncodeVarint(16<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StateSnapshot); err != nil {
			return err
		}
	case *GossipMessage_StateInfoPullReq:
		b.EncodeVarint(17<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StateInfoPullReq); err != nil {
			return err
		}
	case *GossipMessage_StateRequest:
		b.EncodeVarint(18<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StateRequest); err != nil {
			return err
		}
	case *GossipMessage_StateResponse:
		b.EncodeVarint(19<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StateResponse); err != nil {
			return err
		}
	case *GossipMessage_LeadershipMsg:
		b.EncodeVarint(20<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.LeadershipMsg); err != nil {
			return err
		}
	case *GossipMessage_PeerIdentity:
		b.EncodeVarint(21<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PeerIdentity); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("GossipMessage.Content has unexpected type %T", x)
	}
	return nil
}

func _GossipMessage_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*GossipMessage)
	switch tag {
	case 5: // content.alive_msg
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AliveMessage)
		err := b.DecodeMessage(msg)
		m.Content = &GossipMessage_AliveMsg{msg}
		return true, err
	case 6: // content.mem_req
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MembershipRequest)
		err := b.DecodeMessage(msg)
		m.Content = &GossipMessage_MemReq{msg}
		return true, err
	case 7: // content.mem_res
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MembershipResponse)
		err := b.DecodeMessage(msg)
		m.Content = &GossipMessage_MemRes{msg}
		return true, err
	case 8: // content.data_msg
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DataMessage)
		err := b.DecodeMessage(msg)
		m.Content = &GossipMessage_DataMsg{msg}
		return true, err
	case 9: // content.hello
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GossipHello)
		err := b.DecodeMessage(msg)
		m.Content = &GossipMessage_Hello{msg}
		return true, err
	case 10: // content.data_dig
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DataDigest)
		err := b.DecodeMessage(msg)
		m.Content = &GossipMessage_DataDig{msg}
		return true, err
	case 11: // content.data_req
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DataRequest)
		err := b.DecodeMessage(msg)
		m.Content = &GossipMessage_DataReq{msg}
		return true, err
	case 12: // content.data_update
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DataUpdate)
		err := b.DecodeMessage(msg)
		m.Content = &GossipMessage_DataUpdate{msg}
		return true, err
	case 13: // content.empty
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Empty)
		err := b.DecodeMessage(msg)
		m.Content = &GossipMessage_Empty{msg}
		return true, err
	case 14: // content.conn
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ConnEstablish)
		err := b.DecodeMessage(msg)
		m.Content = &GossipMessage_Conn{msg}
		return true, err
	case 15: // content.state_info
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StateInfo)
		err := b.DecodeMessage(msg)
		m.Content = &GossipMessage_StateInfo{msg}
		return true, err
	case 16: // content.state_snapshot
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StateInfoSnapshot)
		err := b.DecodeMessage(msg)
		m.Content = &GossipMessage_StateSnapshot{msg}
		return true, err
	case 17: // content.state_info_pull_req
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StateInfoPullRequest)
		err := b.DecodeMessage(msg)
		m.Content = &GossipMessage_StateInfoPullReq{msg}
		return true, err
	case 18: // content.state_request
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RemoteStateRequest)
		err := b.DecodeMessage(msg)
		m.Content = &GossipMessage_StateRequest{msg}
		return true, err
	case 19: // content.state_response
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RemoteStateResponse)
		err := b.DecodeMessage(msg)
		m.Content = &GossipMessage_StateResponse{msg}
		return true, err
	case 20: // content.leadership_msg
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(LeadershipMessage)
		err := b.DecodeMessage(msg)
		m.Content = &GossipMessage_LeadershipMsg{msg}
		return true, err
	case 21: // content.peer_identity
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PeerIdentity)
		err := b.DecodeMessage(msg)
		m.Content = &GossipMessage_PeerIdentity{msg}
		return true, err
	default:
		return false, nil
	}
}

func _GossipMessage_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*GossipMessage)
	// content
	switch x := m.Content.(type) {
	case *GossipMessage_AliveMsg:
		s := proto.Size(x.AliveMsg)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GossipMessage_MemReq:
		s := proto.Size(x.MemReq)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GossipMessage_MemRes:
		s := proto.Size(x.MemRes)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GossipMessage_DataMsg:
		s := proto.Size(x.DataMsg)
		n += proto.SizeVarint(8<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GossipMessage_Hello:
		s := proto.Size(x.Hello)
		n += proto.SizeVarint(9<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GossipMessage_DataDig:
		s := proto.Size(x.DataDig)
		n += proto.SizeVarint(10<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GossipMessage_DataReq:
		s := proto.Size(x.DataReq)
		n += proto.SizeVarint(11<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GossipMessage_DataUpdate:
		s := proto.Size(x.DataUpdate)
		n += proto.SizeVarint(12<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GossipMessage_Empty:
		s := proto.Size(x.Empty)
		n += proto.SizeVarint(13<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GossipMessage_Conn:
		s := proto.Size(x.Conn)
		n += proto.SizeVarint(14<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GossipMessage_StateInfo:
		s := proto.Size(x.StateInfo)
		n += proto.SizeVarint(15<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GossipMessage_StateSnapshot:
		s := proto.Size(x.StateSnapshot)
		n += proto.SizeVarint(16<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GossipMessage_StateInfoPullReq:
		s := proto.Size(x.StateInfoPullReq)
		n += proto.SizeVarint(17<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GossipMessage_StateRequest:
		s := proto.Size(x.StateRequest)
		n += proto.SizeVarint(18<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GossipMessage_StateResponse:
		s := proto.Size(x.StateResponse)
		n += proto.SizeVarint(19<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GossipMessage_LeadershipMsg:
		s := proto.Size(x.LeadershipMsg)
		n += proto.SizeVarint(20<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GossipMessage_PeerIdentity:
		s := proto.Size(x.PeerIdentity)
		n += proto.SizeVarint(21<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// StateInfo is used for a peer to relay its state information
// to other peers
type StateInfo struct {
	Metadata  []byte    `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	Timestamp *PeerTime `protobuf:"bytes,2,opt,name=timestamp" json:"timestamp,omitempty"`
	PkiId     []byte    `protobuf:"bytes,3,opt,name=pki_id,json=pkiId,proto3" json:"pki_id,omitempty"`
	// channel_MAC is an authentication code that proves
	// that the peer that sent this message knows
	// the name of the channel.
	Channel_MAC []byte `protobuf:"bytes,4,opt,name=channel_MAC,json=channelMAC,proto3" json:"channel_MAC,omitempty"`
}

func (m *StateInfo) Reset()                    { *m = StateInfo{} }
func (m *StateInfo) String() string            { return proto.CompactTextString(m) }
func (*StateInfo) ProtoMessage()               {}
func (*StateInfo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *StateInfo) GetMetadata() []byte {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *StateInfo) GetTimestamp() *PeerTime {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *StateInfo) GetPkiId() []byte {
	if m != nil {
		return m.PkiId
	}
	return nil
}

func (m *StateInfo) GetChannel_MAC() []byte {
	if m != nil {
		return m.Channel_MAC
	}
	return nil
}

// StateInfoSnapshot is an aggregation of StateInfo messages
type StateInfoSnapshot struct {
	Elements []*Envelope `protobuf:"bytes,1,rep,name=elements" json:"elements,omitempty"`
}

func (m *StateInfoSnapshot) Reset()                    { *m = StateInfoSnapshot{} }
func (m *StateInfoSnapshot) String() string            { return proto.CompactTextString(m) }
func (*StateInfoSnapshot) ProtoMessage()               {}
func (*StateInfoSnapshot) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *StateInfoSnapshot) GetElements() []*Envelope {
	if m != nil {
		return m.Elements
	}
	return nil
}

// StateInfoPullRequest is used to fetch a StateInfoSnapshot
// from a remote peer
type StateInfoPullRequest struct {
	// channel_MAC is an authentication code that proves
	// that the peer that sent this message knows
	// the name of the channel.
	Channel_MAC []byte `protobuf:"bytes,1,opt,name=channel_MAC,json=channelMAC,proto3" json:"channel_MAC,omitempty"`
}

func (m *StateInfoPullRequest) Reset()                    { *m = StateInfoPullRequest{} }
func (m *StateInfoPullRequest) String() string            { return proto.CompactTextString(m) }
func (*StateInfoPullRequest) ProtoMessage()               {}
func (*StateInfoPullRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *StateInfoPullRequest) GetChannel_MAC() []byte {
	if m != nil {
		return m.Channel_MAC
	}
	return nil
}

// ConnEstablish is the message used for the gossip handshake
// Whenever a peer connects to another peer, it handshakes
// with it by sending this message that proves its identity
type ConnEstablish struct {
	PkiId       []byte `protobuf:"bytes,1,opt,name=pki_id,json=pkiId,proto3" json:"pki_id,omitempty"`
	Identity    []byte `protobuf:"bytes,2,opt,name=identity,proto3" json:"identity,omitempty"`
	TlsCertHash []byte `protobuf:"bytes,3,opt,name=tls_cert_hash,json=tlsCertHash,proto3" json:"tls_cert_hash,omitempty"`
}

func (m *ConnEstablish) Reset()                    { *m = ConnEstablish{} }
func (m *ConnEstablish) String() string            { return proto.CompactTextString(m) }
func (*ConnEstablish) ProtoMessage()               {}
func (*ConnEstablish) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *ConnEstablish) GetPkiId() []byte {
	if m != nil {
		return m.PkiId
	}
	return nil
}

func (m *ConnEstablish) GetIdentity() []byte {
	if m != nil {
		return m.Identity
	}
	return nil
}

func (m *ConnEstablish) GetTlsCertHash() []byte {
	if m != nil {
		return m.TlsCertHash
	}
	return nil
}

// PeerIdentity defines the identity of the peer
// Used to make other peers learn of the identity
// of a certain peer
type PeerIdentity struct {
	PkiId    []byte `protobuf:"bytes,1,opt,name=pki_id,json=pkiId,proto3" json:"pki_id,omitempty"`
	Cert     []byte `protobuf:"bytes,2,opt,name=cert,proto3" json:"cert,omitempty"`
	Metadata []byte `protobuf:"bytes,3,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (m *PeerIdentity) Reset()                    { *m = PeerIdentity{} }
func (m *PeerIdentity) String() string            { return proto.CompactTextString(m) }
func (*PeerIdentity) ProtoMessage()               {}
func (*PeerIdentity) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *PeerIdentity) GetPkiId() []byte {
	if m != nil {
		return m.PkiId
	}
	return nil
}

func (m *PeerIdentity) GetCert() []byte {
	if m != nil {
		return m.Cert
	}
	return nil
}

func (m *PeerIdentity) GetMetadata() []byte {
	if m != nil {
		return m.Metadata
	}
	return nil
}

// DataRequest is a message used for a peer to request
// certain data blocks from a remote peer
type DataRequest struct {
	Nonce   uint64      `protobuf:"varint,1,opt,name=nonce" json:"nonce,omitempty"`
	Digests []string    `protobuf:"bytes,2,rep,name=digests" json:"digests,omitempty"`
	MsgType PullMsgType `protobuf:"varint,3,opt,name=msg_type,json=msgType,enum=gossip.PullMsgType" json:"msg_type,omitempty"`
}

func (m *DataRequest) Reset()                    { *m = DataRequest{} }
func (m *DataRequest) String() string            { return proto.CompactTextString(m) }
func (*DataRequest) ProtoMessage()               {}
func (*DataRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *DataRequest) GetNonce() uint64 {
	if m != nil {
		return m.Nonce
	}
	return 0
}

func (m *DataRequest) GetDigests() []string {
	if m != nil {
		return m.Digests
	}
	return nil
}

func (m *DataRequest) GetMsgType() PullMsgType {
	if m != nil {
		return m.MsgType
	}
	return PullMsgType_UNDEFINED
}

// GossipHello is the message that is used for the peer to initiate
// a pull round with another peer
type GossipHello struct {
	Nonce    uint64      `protobuf:"varint,1,opt,name=nonce" json:"nonce,omitempty"`
	Metadata []byte      `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	MsgType  PullMsgType `protobuf:"varint,3,opt,name=msg_type,json=msgType,enum=gossip.PullMsgType" json:"msg_type,omitempty"`
}

func (m *GossipHello) Reset()                    { *m = GossipHello{} }
func (m *GossipHello) String() string            { return proto.CompactTextString(m) }
func (*GossipHello) ProtoMessage()               {}
func (*GossipHello) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *GossipHello) GetNonce() uint64 {
	if m != nil {
		return m.Nonce
	}
	return 0
}

func (m *GossipHello) GetMetadata() []byte {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *GossipHello) GetMsgType() PullMsgType {
	if m != nil {
		return m.MsgType
	}
	return PullMsgType_UNDEFINED
}

// DataUpdate is the final message in the pull phase
// sent from the receiver to the initiator
type DataUpdate struct {
	Nonce   uint64      `protobuf:"varint,1,opt,name=nonce" json:"nonce,omitempty"`
	Data    []*Envelope `protobuf:"bytes,2,rep,name=data" json:"data,omitempty"`
	MsgType PullMsgType `protobuf:"varint,3,opt,name=msg_type,json=msgType,enum=gossip.PullMsgType" json:"msg_type,omitempty"`
}

func (m *DataUpdate) Reset()                    { *m = DataUpdate{} }
func (m *DataUpdate) String() string            { return proto.CompactTextString(m) }
func (*DataUpdate) ProtoMessage()               {}
func (*DataUpdate) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *DataUpdate) GetNonce() uint64 {
	if m != nil {
		return m.Nonce
	}
	return 0
}

func (m *DataUpdate) GetData() []*Envelope {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *DataUpdate) GetMsgType() PullMsgType {
	if m != nil {
		return m.MsgType
	}
	return PullMsgType_UNDEFINED
}

// DataDigest is the message sent from the receiver peer
// to the initator peer and contains the data items it has
type DataDigest struct {
	Nonce   uint64      `protobuf:"varint,1,opt,name=nonce" json:"nonce,omitempty"`
	Digests []string    `protobuf:"bytes,2,rep,name=digests" json:"digests,omitempty"`
	MsgType PullMsgType `protobuf:"varint,3,opt,name=msg_type,json=msgType,enum=gossip.PullMsgType" json:"msg_type,omitempty"`
}

func (m *DataDigest) Reset()                    { *m = DataDigest{} }
func (m *DataDigest) String() string            { return proto.CompactTextString(m) }
func (*DataDigest) ProtoMessage()               {}
func (*DataDigest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *DataDigest) GetNonce() uint64 {
	if m != nil {
		return m.Nonce
	}
	return 0
}

func (m *DataDigest) GetDigests() []string {
	if m != nil {
		return m.Digests
	}
	return nil
}

func (m *DataDigest) GetMsgType() PullMsgType {
	if m != nil {
		return m.MsgType
	}
	return PullMsgType_UNDEFINED
}

// DataMessage is the message that contains a block
type DataMessage struct {
	Payload *Payload `protobuf:"bytes,1,opt,name=payload" json:"payload,omitempty"`
}

func (m *DataMessage) Reset()                    { *m = DataMessage{} }
func (m *DataMessage) String() string            { return proto.CompactTextString(m) }
func (*DataMessage) ProtoMessage()               {}
func (*DataMessage) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *DataMessage) GetPayload() *Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

// Payload contains a block
type Payload struct {
	SeqNum uint64 `protobuf:"varint,1,opt,name=seq_num,json=seqNum" json:"seq_num,omitempty"`
	Data   []byte `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
}

func (m *Payload) Reset()                    { *m = Payload{} }
func (m *Payload) String() string            { return proto.CompactTextString(m) }
func (*Payload) ProtoMessage()               {}
func (*Payload) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *Payload) GetSeqNum() uint64 {
	if m != nil {
		return m.SeqNum
	}
	return 0
}

func (m *Payload) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// AliveMessage is sent to inform remote peers
// of a peer's existence and activity
type AliveMessage struct {
	Membership *Member   `protobuf:"bytes,1,opt,name=membership" json:"membership,omitempty"`
	Timestamp  *PeerTime `protobuf:"bytes,2,opt,name=timestamp" json:"timestamp,omitempty"`
	Identity   []byte    `protobuf:"bytes,4,opt,name=identity,proto3" json:"identity,omitempty"`
}

func (m *AliveMessage) Reset()                    { *m = AliveMessage{} }
func (m *AliveMessage) String() string            { return proto.CompactTextString(m) }
func (*AliveMessage) ProtoMessage()               {}
func (*AliveMessage) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *AliveMessage) GetMembership() *Member {
	if m != nil {
		return m.Membership
	}
	return nil
}

func (m *AliveMessage) GetTimestamp() *PeerTime {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *AliveMessage) GetIdentity() []byte {
	if m != nil {
		return m.Identity
	}
	return nil
}

// Leadership Message is sent during leader election to inform
// remote peers about intent of peer to proclaim itself as leader
type LeadershipMessage struct {
	PkiId         []byte    `protobuf:"bytes,1,opt,name=pki_id,json=pkiId,proto3" json:"pki_id,omitempty"`
	Timestamp     *PeerTime `protobuf:"bytes,2,opt,name=timestamp" json:"timestamp,omitempty"`
	IsDeclaration bool      `protobuf:"varint,3,opt,name=is_declaration,json=isDeclaration" json:"is_declaration,omitempty"`
}

func (m *LeadershipMessage) Reset()                    { *m = LeadershipMessage{} }
func (m *LeadershipMessage) String() string            { return proto.CompactTextString(m) }
func (*LeadershipMessage) ProtoMessage()               {}
func (*LeadershipMessage) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *LeadershipMessage) GetPkiId() []byte {
	if m != nil {
		return m.PkiId
	}
	return nil
}

func (m *LeadershipMessage) GetTimestamp() *PeerTime {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *LeadershipMessage) GetIsDeclaration() bool {
	if m != nil {
		return m.IsDeclaration
	}
	return false
}

// PeerTime defines the logical time of a peer's life
type PeerTime struct {
	IncNum uint64 `protobuf:"varint,1,opt,name=inc_num,json=incNum" json:"inc_num,omitempty"`
	SeqNum uint64 `protobuf:"varint,2,opt,name=seq_num,json=seqNum" json:"seq_num,omitempty"`
}

func (m *PeerTime) Reset()                    { *m = PeerTime{} }
func (m *PeerTime) String() string            { return proto.CompactTextString(m) }
func (*PeerTime) ProtoMessage()               {}
func (*PeerTime) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *PeerTime) GetIncNum() uint64 {
	if m != nil {
		return m.IncNum
	}
	return 0
}

func (m *PeerTime) GetSeqNum() uint64 {
	if m != nil {
		return m.SeqNum
	}
	return 0
}

// MembershipRequest is used to ask membership information
// from a remote peer
type MembershipRequest struct {
	SelfInformation *Envelope `protobuf:"bytes,1,opt,name=self_information,json=selfInformation" json:"self_information,omitempty"`
	Known           [][]byte  `protobuf:"bytes,2,rep,name=known,proto3" json:"known,omitempty"`
}

func (m *MembershipRequest) Reset()                    { *m = MembershipRequest{} }
func (m *MembershipRequest) String() string            { return proto.CompactTextString(m) }
func (*MembershipRequest) ProtoMessage()               {}
func (*MembershipRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *MembershipRequest) GetSelfInformation() *Envelope {
	if m != nil {
		return m.SelfInformation
	}
	return nil
}

func (m *MembershipRequest) GetKnown() [][]byte {
	if m != nil {
		return m.Known
	}
	return nil
}

// MembershipResponse is used for replying to MembershipRequests
type MembershipResponse struct {
	Alive []*Envelope `protobuf:"bytes,1,rep,name=alive" json:"alive,omitempty"`
	Dead  []*Envelope `protobuf:"bytes,2,rep,name=dead" json:"dead,omitempty"`
}

func (m *MembershipResponse) Reset()                    { *m = MembershipResponse{} }
func (m *MembershipResponse) String() string            { return proto.CompactTextString(m) }
func (*MembershipResponse) ProtoMessage()               {}
func (*MembershipResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *MembershipResponse) GetAlive() []*Envelope {
	if m != nil {
		return m.Alive
	}
	return nil
}

func (m *MembershipResponse) GetDead() []*Envelope {
	if m != nil {
		return m.Dead
	}
	return nil
}

// Member holds membership-related information
// about a peer
type Member struct {
	Endpoint string `protobuf:"bytes,1,opt,name=endpoint" json:"endpoint,omitempty"`
	Metadata []byte `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	PkiId    []byte `protobuf:"bytes,3,opt,name=pki_id,json=pkiId,proto3" json:"pki_id,omitempty"`
}

func (m *Member) Reset()                    { *m = Member{} }
func (m *Member) String() string            { return proto.CompactTextString(m) }
func (*Member) ProtoMessage()               {}
func (*Member) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *Member) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *Member) GetMetadata() []byte {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Member) GetPkiId() []byte {
	if m != nil {
		return m.PkiId
	}
	return nil
}

// Empty is used for pinging and in tests
type Empty struct {
}

func (m *Empty) Reset()                    { *m = Empty{} }
func (m *Empty) String() string            { return proto.CompactTextString(m) }
func (*Empty) ProtoMessage()               {}
func (*Empty) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

// RemoteStateRequest is used to ask a set of blocks
// from a remote peer
type RemoteStateRequest struct {
	StartSeqNum uint64 `protobuf:"varint,1,opt,name=start_seq_num,json=startSeqNum" json:"start_seq_num,omitempty"`
	EndSeqNum   uint64 `protobuf:"varint,2,opt,name=end_seq_num,json=endSeqNum" json:"end_seq_num,omitempty"`
}

func (m *RemoteStateRequest) Reset()                    { *m = RemoteStateRequest{} }
func (m *RemoteStateRequest) String() string            { return proto.CompactTextString(m) }
func (*RemoteStateRequest) ProtoMessage()               {}
func (*RemoteStateRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *RemoteStateRequest) GetStartSeqNum() uint64 {
	if m != nil {
		return m.StartSeqNum
	}
	return 0
}

func (m *RemoteStateRequest) GetEndSeqNum() uint64 {
	if m != nil {
		return m.EndSeqNum
	}
	return 0
}

// RemoteStateResponse is used to send a set of blocks
// to a remote peer
type RemoteStateResponse struct {
	Payloads []*Payload `protobuf:"bytes,1,rep,name=payloads" json:"payloads,omitempty"`
}

func (m *RemoteStateResponse) Reset()                    { *m = RemoteStateResponse{} }
func (m *RemoteStateResponse) String() string            { return proto.CompactTextString(m) }
func (*RemoteStateResponse) ProtoMessage()               {}
func (*RemoteStateResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *RemoteStateResponse) GetPayloads() []*Payload {
	if m != nil {
		return m.Payloads
	}
	return nil
}

func init() {
	proto.RegisterType((*Envelope)(nil), "gossip.Envelope")
	proto.RegisterType((*SecretEnvelope)(nil), "gossip.SecretEnvelope")
	proto.RegisterType((*Secret)(nil), "gossip.Secret")
	proto.RegisterType((*GossipMessage)(nil), "gossip.GossipMessage")
	proto.RegisterType((*StateInfo)(nil), "gossip.StateInfo")
	proto.RegisterType((*StateInfoSnapshot)(nil), "gossip.StateInfoSnapshot")
	proto.RegisterType((*StateInfoPullRequest)(nil), "gossip.StateInfoPullRequest")
	proto.RegisterType((*ConnEstablish)(nil), "gossip.ConnEstablish")
	proto.RegisterType((*PeerIdentity)(nil), "gossip.PeerIdentity")
	proto.RegisterType((*DataRequest)(nil), "gossip.DataRequest")
	proto.RegisterType((*GossipHello)(nil), "gossip.GossipHello")
	proto.RegisterType((*DataUpdate)(nil), "gossip.DataUpdate")
	proto.RegisterType((*DataDigest)(nil), "gossip.DataDigest")
	proto.RegisterType((*DataMessage)(nil), "gossip.DataMessage")
	proto.RegisterType((*Payload)(nil), "gossip.Payload")
	proto.RegisterType((*AliveMessage)(nil), "gossip.AliveMessage")
	proto.RegisterType((*LeadershipMessage)(nil), "gossip.LeadershipMessage")
	proto.RegisterType((*PeerTime)(nil), "gossip.PeerTime")
	proto.RegisterType((*MembershipRequest)(nil), "gossip.MembershipRequest")
	proto.RegisterType((*MembershipResponse)(nil), "gossip.MembershipResponse")
	proto.RegisterType((*Member)(nil), "gossip.Member")
	proto.RegisterType((*Empty)(nil), "gossip.Empty")
	proto.RegisterType((*RemoteStateRequest)(nil), "gossip.RemoteStateRequest")
	proto.RegisterType((*RemoteStateResponse)(nil), "gossip.RemoteStateResponse")
	proto.RegisterEnum("gossip.PullMsgType", PullMsgType_name, PullMsgType_value)
	proto.RegisterEnum("gossip.GossipMessage_Tag", GossipMessage_Tag_name, GossipMessage_Tag_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Gossip service

type GossipClient interface {
	// GossipStream is the gRPC stream used for sending and receiving messages
	GossipStream(ctx context.Context, opts ...grpc.CallOption) (Gossip_GossipStreamClient, error)
	// Ping is used to probe a remote peer's aliveness
	Ping(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*Empty, error)
}

type gossipClient struct {
	cc *grpc.ClientConn
}

func NewGossipClient(cc *grpc.ClientConn) GossipClient {
	return &gossipClient{cc}
}

func (c *gossipClient) GossipStream(ctx context.Context, opts ...grpc.CallOption) (Gossip_GossipStreamClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Gossip_serviceDesc.Streams[0], c.cc, "/gossip.Gossip/GossipStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &gossipGossipStreamClient{stream}
	return x, nil
}

type Gossip_GossipStreamClient interface {
	Send(*Envelope) error
	Recv() (*Envelope, error)
	grpc.ClientStream
}

type gossipGossipStreamClient struct {
	grpc.ClientStream
}

func (x *gossipGossipStreamClient) Send(m *Envelope) error {
	return x.ClientStream.SendMsg(m)
}

func (x *gossipGossipStreamClient) Recv() (*Envelope, error) {
	m := new(Envelope)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *gossipClient) Ping(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := grpc.Invoke(ctx, "/gossip.Gossip/Ping", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Gossip service

type GossipServer interface {
	// GossipStream is the gRPC stream used for sending and receiving messages
	GossipStream(Gossip_GossipStreamServer) error
	// Ping is used to probe a remote peer's aliveness
	Ping(context.Context, *Empty) (*Empty, error)
}

func RegisterGossipServer(s *grpc.Server, srv GossipServer) {
	s.RegisterService(&_Gossip_serviceDesc, srv)
}

func _Gossip_GossipStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(GossipServer).GossipStream(&gossipGossipStreamServer{stream})
}

type Gossip_GossipStreamServer interface {
	Send(*Envelope) error
	Recv() (*Envelope, error)
	grpc.ServerStream
}

type gossipGossipStreamServer struct {
	grpc.ServerStream
}

func (x *gossipGossipStreamServer) Send(m *Envelope) error {
	return x.ServerStream.SendMsg(m)
}

func (x *gossipGossipStreamServer) Recv() (*Envelope, error) {
	m := new(Envelope)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Gossip_Ping_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GossipServer).Ping(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gossip.Gossip/Ping",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GossipServer).Ping(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

var _Gossip_serviceDesc = grpc.ServiceDesc{
	ServiceName: "gossip.Gossip",
	HandlerType: (*GossipServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Ping",
			Handler:    _Gossip_Ping_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GossipStream",
			Handler:       _Gossip_GossipStream_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "gossip/message.proto",
}

func init() { proto.RegisterFile("gossip/message.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 1366 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xb4, 0x57, 0xdd, 0x6f, 0xdc, 0x44,
	0x10, 0x3f, 0x27, 0xf7, 0x39, 0xf7, 0x91, 0xcb, 0x26, 0x05, 0x13, 0x2a, 0x88, 0x2c, 0x5a, 0x05,
	0x52, 0x2e, 0x55, 0xca, 0x47, 0xa5, 0x82, 0xd0, 0x25, 0x77, 0xe4, 0x22, 0x7a, 0x49, 0xe4, 0xa4,
	0x82, 0xf2, 0x62, 0x6d, 0xce, 0x13, 0x9f, 0xa9, 0xbd, 0x76, 0xbc, 0x7b, 0x85, 0x3c, 0x22, 0xde,
	0x78, 0xe1, 0x95, 0x3f, 0x17, 0x79, 0xd7, 0xf6, 0xd9, 0x75, 0x52, 0xa9, 0x95, 0x78, 0xf3, 0x7c,
	0xfc, 0x66, 0x66, 0x67, 0xe7, 0x63, 0x0d, 0x9b, 0x4e, 0xc0, 0xb9, 0x1b, 0xee, 0xf9, 0xc8, 0x39,
	0x75, 0x70, 0x10, 0x46, 0x81, 0x08, 0x48, 0x5d, 0x71, 0x8d, 0xbf, 0x34, 0x68, 0x8e, 0xd9, 0x6b,
	0xf4, 0x82, 0x10, 0x89, 0x0e, 0x8d, 0x90, 0xde, 0x78, 0x01, 0xb5, 0x75, 0x6d, 0x5b, 0xdb, 0xe9,
	0x98, 0x29, 0x49, 0xee, 0x43, 0x8b, 0xbb, 0x0e, 0xa3, 0x62, 0x11, 0xa1, 0xbe, 0x22, 0x65, 0x4b,
	0x06, 0xf9, 0x01, 0xd6, 0x38, 0xce, 0x22, 0x14, 0x16, 0x26, 0xa6, 0xf4, 0xd5, 0x6d, 0x6d, 0xa7,
	0xbd, 0xff, 0xc1, 0x40, 0xb9, 0x19, 0x9c, 0x4b, 0x71, 0xea, 0xc8, 0xec, 0xf1, 0x02, 0x6d, 0x4c,
	0xa0, 0x57, 0xd4, 0x78, 0xdf, 0x50, 0x8c, 0x21, 0xd4, 0x95, 0x25, 0xf2, 0x08, 0xfa, 0x2e, 0x13,
	0x18, 0x31, 0xea, 0x8d, 0x99, 0x1d, 0x06, 0x2e, 0x13, 0xd2, 0x54, 0x6b, 0x52, 0x31, 0x4b, 0x92,
	0x83, 0x16, 0x34, 0x66, 0x01, 0x13, 0xc8, 0x84, 0xf1, 0x6f, 0x0b, 0xba, 0x47, 0x32, 0xec, 0xa9,
	0x4a, 0x19, 0xd9, 0x84, 0x1a, 0x0b, 0xd8, 0x0c, 0x25, 0xbe, 0x6a, 0x2a, 0x22, 0x0e, 0x71, 0x36,
	0xa7, 0x8c, 0xa1, 0x97, 0x84, 0x91, 0x92, 0x64, 0x17, 0x56, 0x05, 0x75, 0x64, 0x0e, 0x7a, 0xfb,
	0x1f, 0xa5, 0x39, 0x28, 0xd8, 0x1c, 0x5c, 0x50, 0xc7, 0x8c, 0xb5, 0xc8, 0x13, 0x68, 0x51, 0xcf,
	0x7d, 0x8d, 0x96, 0xcf, 0x1d, 0xbd, 0x26, 0xd3, 0xb6, 0x99, 0x42, 0x86, 0xb1, 0x20, 0x41, 0x4c,
	0x2a, 0x66, 0x53, 0x2a, 0x4e, 0xb9, 0x43, 0xbe, 0x82, 0x86, 0x8f, 0xbe, 0x15, 0xe1, 0xb5, 0x5e,
	0x97, 0x90, 0xcc, 0xcb, 0x14, 0xfd, 0x4b, 0x8c, 0xf8, 0xdc, 0x0d, 0x4d, 0xbc, 0x5e, 0x20, 0x17,
	0x93, 0x8a, 0x59, 0xf7, 0xd1, 0x37, 0xf1, 0x9a, 0x7c, 0x9d, 0xa2, 0xb8, 0xde, 0x90, 0xa8, 0xad,
	0xdb, 0x50, 0x3c, 0x0c, 0x18, 0xc7, 0x0c, 0xc6, 0xc9, 0x63, 0x68, 0xda, 0x54, 0x50, 0x19, 0x60,
	0x53, 0xe2, 0x36, 0x52, 0xdc, 0x88, 0x0a, 0xba, 0x8c, 0xaf, 0x11, 0xab, 0xc5, 0xe1, 0xed, 0x42,
	0x6d, 0x8e, 0x9e, 0x17, 0xe8, 0xad, 0xa2, 0xba, 0x4a, 0xc1, 0x24, 0x16, 0x4d, 0x2a, 0xa6, 0xd2,
	0x21, 0x7b, 0x89, 0x79, 0xdb, 0x75, 0x74, 0x90, 0xfa, 0x24, 0x6f, 0x7e, 0xe4, 0x3a, 0xea, 0x14,
	0xd2, 0xfa, 0xc8, 0x75, 0xb2, 0x78, 0xe2, 0xd3, 0xb7, 0xcb, 0xf1, 0x2c, 0xcf, 0x2d, 0x11, 0xea,
	0xe0, 0x6d, 0x89, 0x58, 0x84, 0x36, 0x15, 0xa8, 0x77, 0xca, 0x5e, 0x5e, 0x48, 0xc9, 0xa4, 0x62,
	0x82, 0x9d, 0x51, 0xe4, 0x01, 0xd4, 0xd0, 0x0f, 0xc5, 0x8d, 0xde, 0x95, 0x80, 0x6e, 0x0a, 0x18,
	0xc7, 0xcc, 0xf8, 0x00, 0x52, 0x4a, 0x76, 0xa1, 0x3a, 0x0b, 0x18, 0xd3, 0x7b, 0x52, 0xeb, 0x5e,
	0xaa, 0x75, 0x18, 0x30, 0x36, 0xe6, 0x82, 0x5e, 0x7a, 0x2e, 0x9f, 0x4f, 0x2a, 0xa6, 0x54, 0x22,
	0xfb, 0x00, 0x5c, 0x50, 0x81, 0x96, 0xcb, 0xae, 0x02, 0x7d, 0x4d, 0x42, 0xd6, 0xb3, 0x36, 0x89,
	0x25, 0xc7, 0xec, 0x2a, 0xce, 0x4e, 0x8b, 0xa7, 0x04, 0x39, 0x80, 0x9e, 0xc2, 0x70, 0x46, 0x43,
	0x3e, 0x0f, 0x84, 0xde, 0x2f, 0x5e, 0x7a, 0x86, 0x3b, 0x4f, 0x14, 0x26, 0x15, 0xb3, 0x2b, 0x21,
	0x29, 0x83, 0x4c, 0x61, 0x63, 0xe9, 0xd7, 0x0a, 0x17, 0x9e, 0x27, 0xf3, 0xb7, 0x2e, 0x0d, 0xdd,
	0x2f, 0x19, 0x3a, 0x5b, 0x78, 0xde, 0x32, 0x91, 0x7d, 0xfe, 0x06, 0x9f, 0x0c, 0x41, 0xd9, 0x8f,
	0x8d, 0xc4, 0x4a, 0x3a, 0x29, 0x16, 0x94, 0x89, 0x7e, 0x20, 0x50, 0x9a, 0x5b, 0x9a, 0xe9, 0xf0,
	0x1c, 0x4d, 0x46, 0xe9, 0xa9, 0xa2, 0xa4, 0xe4, 0xf4, 0x0d, 0x69, 0xe3, 0xe3, 0x5b, 0x6d, 0x64,
	0x55, 0xd9, 0xe5, 0x79, 0x46, 0x9c, 0x1b, 0x0f, 0xa9, 0xad, 0x8a, 0x57, 0x96, 0xe8, 0x66, 0x31,
	0x37, 0xcf, 0x33, 0xe9, 0xb2, 0x50, 0xbb, 0x4b, 0x48, 0x5c, 0xae, 0xcf, 0xa0, 0x1b, 0x22, 0x46,
	0x96, 0x6b, 0x23, 0x13, 0xae, 0xb8, 0xd1, 0xef, 0x15, 0xdb, 0xf0, 0x0c, 0x31, 0x3a, 0x4e, 0x64,
	0xf1, 0x31, 0xc2, 0x1c, 0x6d, 0x58, 0xb0, 0x7a, 0x41, 0x1d, 0xd2, 0x85, 0xd6, 0x8b, 0x93, 0xd1,
	0xf8, 0xc7, 0xe3, 0x93, 0xf1, 0xa8, 0x5f, 0x21, 0x2d, 0xa8, 0x8d, 0xa7, 0x67, 0x17, 0x2f, 0xfb,
	0x1a, 0xe9, 0x40, 0xf3, 0xd4, 0x3c, 0xb2, 0x4e, 0x4f, 0x9e, 0xbf, 0xec, 0xaf, 0xc4, 0x7a, 0x87,
	0x93, 0xe1, 0x89, 0x22, 0x57, 0x49, 0x1f, 0x3a, 0x92, 0x1c, 0x9e, 0x8c, 0xac, 0x53, 0xf3, 0xa8,
	0x5f, 0x25, 0x6b, 0xd0, 0x56, 0x0a, 0xa6, 0x64, 0xd4, 0xf2, 0xa3, 0xe9, 0x1f, 0x0d, 0x5a, 0xd9,
	0x15, 0x91, 0x2d, 0x68, 0xfa, 0x28, 0x68, 0x5c, 0xb0, 0xc9, 0x90, 0xcc, 0x68, 0x32, 0x80, 0x96,
	0x70, 0x7d, 0xe4, 0x82, 0xfa, 0xa1, 0x1c, 0x4f, 0xed, 0xfd, 0x7e, 0xfe, 0x38, 0x17, 0xae, 0x8f,
	0xe6, 0x52, 0x85, 0xdc, 0x83, 0x7a, 0xf8, 0xca, 0xb5, 0x5c, 0x5b, 0x4e, 0xad, 0x8e, 0x59, 0x0b,
	0x5f, 0xb9, 0xc7, 0x36, 0xf9, 0x14, 0xda, 0xc9, 0x50, 0xb3, 0xa6, 0xc3, 0x43, 0xbd, 0x2a, 0x65,
	0x90, 0xb0, 0xa6, 0xc3, 0x43, 0x63, 0x08, 0xeb, 0xa5, 0xe2, 0x23, 0x8f, 0xa0, 0x89, 0x1e, 0xfa,
	0xc8, 0x04, 0xd7, 0xb5, 0xed, 0xd5, 0xbc, 0xef, 0x6c, 0x05, 0x64, 0x1a, 0xc6, 0xb7, 0xb0, 0x79,
	0x5b, 0xd9, 0xbd, 0xe9, 0x5b, 0x2b, 0xf9, 0xbe, 0x82, 0x6e, 0xa1, 0xc7, 0x72, 0x87, 0xd0, 0xf2,
	0x87, 0xd8, 0x82, 0x66, 0x76, 0xb3, 0x6a, 0x52, 0x67, 0x34, 0x31, 0xa0, 0x2b, 0x3c, 0x6e, 0xcd,
	0x30, 0x12, 0xd6, 0x9c, 0xf2, 0x79, 0x72, 0xfc, 0xb6, 0xf0, 0xf8, 0x21, 0x46, 0x62, 0x42, 0xf9,
	0xdc, 0x78, 0x01, 0x9d, 0x7c, 0x05, 0xdc, 0xe5, 0x86, 0x40, 0x35, 0x36, 0x93, 0xb8, 0x90, 0xdf,
	0x85, 0x2b, 0x5a, 0x2d, 0x5e, 0x91, 0xe1, 0x43, 0x3b, 0x37, 0xae, 0xee, 0x5e, 0x32, 0xb6, 0x1c,
	0x80, 0x5c, 0x5f, 0xd9, 0x5e, 0xdd, 0x69, 0x99, 0x29, 0x49, 0x06, 0xd0, 0xf4, 0xb9, 0x63, 0x89,
	0x9b, 0x64, 0xdb, 0xf6, 0x96, 0x53, 0x30, 0xce, 0xe2, 0x94, 0x3b, 0x17, 0x37, 0x21, 0x9a, 0x0d,
	0x5f, 0x7d, 0x18, 0x01, 0xb4, 0x73, 0xe3, 0xf7, 0x0e, 0x77, 0xf9, 0x78, 0x57, 0x4a, 0x25, 0xf5,
	0x6e, 0x0e, 0xff, 0x00, 0x58, 0x4e, 0xd6, 0x3b, 0xfc, 0x7d, 0x06, 0xd5, 0xc4, 0xd7, 0xed, 0x55,
	0x52, 0x7d, 0x2f, 0xcf, 0x9e, 0xf2, 0xac, 0x36, 0xc7, 0xff, 0x9e, 0xd8, 0xa7, 0xea, 0x1e, 0xd3,
	0xc7, 0xc2, 0xe7, 0xc5, 0x97, 0x4b, 0x7b, 0x7f, 0x2d, 0x43, 0x2b, 0x76, 0xf6, 0x94, 0x31, 0xbe,
	0x81, 0x46, 0xc2, 0x23, 0x1f, 0x42, 0x83, 0xe3, 0xb5, 0xc5, 0x16, 0x7e, 0x12, 0x66, 0x9d, 0xe3,
	0xf5, 0xc9, 0xc2, 0x8f, 0xab, 0x2a, 0x77, 0x1b, 0xf2, 0xdb, 0xf8, 0x5b, 0x83, 0x4e, 0xfe, 0x69,
	0x40, 0x06, 0x00, 0x7e, 0xb6, 0xc1, 0x13, 0xb7, 0xbd, 0xe2, 0x6e, 0x37, 0x73, 0x1a, 0xef, 0x3c,
	0x1d, 0xf2, 0x1d, 0x54, 0x2d, 0x76, 0x90, 0xf1, 0xa7, 0x06, 0xeb, 0xa5, 0x19, 0x7b, 0x57, 0x8f,
	0xbc, 0xab, 0xe3, 0x07, 0xd0, 0x73, 0xb9, 0x65, 0xe3, 0xcc, 0xa3, 0x11, 0x15, 0x6e, 0xc0, 0xe4,
	0x8d, 0x34, 0xcd, 0xae, 0xcb, 0x47, 0x4b, 0xa6, 0xf1, 0x1d, 0x34, 0x53, 0x74, 0x9c, 0x49, 0x97,
	0xcd, 0xf2, 0x99, 0x74, 0xd9, 0x2c, 0xce, 0x64, 0x2e, 0xc5, 0x2b, 0xf9, 0x14, 0x1b, 0x57, 0xb0,
	0x5e, 0x7a, 0x35, 0x91, 0x67, 0xd0, 0xe7, 0xe8, 0x5d, 0xc9, 0x75, 0x19, 0xf9, 0xca, 0xb7, 0x56,
	0x0c, 0x38, 0xab, 0xd2, 0xb5, 0x58, 0xf3, 0x78, 0xa9, 0x18, 0x97, 0xdc, 0x2b, 0x16, 0xfc, 0xce,
	0x64, 0x69, 0x75, 0x4c, 0x45, 0x18, 0x97, 0x40, 0xca, 0xef, 0x2c, 0xf2, 0x10, 0x6a, 0xf2, 0x59,
	0x77, 0xe7, 0xa4, 0x54, 0x62, 0xd9, 0x2a, 0x48, 0xed, 0xb7, 0xb4, 0x0a, 0x52, 0xdb, 0xf8, 0x19,
	0xea, 0xca, 0x47, 0x7c, 0x67, 0x58, 0x78, 0xf7, 0x9a, 0x19, 0xfd, 0xd6, 0x36, 0xbf, 0x7d, 0x13,
	0x18, 0x0d, 0xa8, 0xc9, 0x67, 0x8f, 0xf1, 0x0b, 0x90, 0xf2, 0x72, 0x8f, 0xe7, 0x28, 0x17, 0x34,
	0x12, 0x56, 0xb1, 0x8a, 0xdb, 0x92, 0x79, 0xae, 0x4a, 0xf9, 0x13, 0x68, 0x23, 0xb3, 0xad, 0xe2,
	0x25, 0xb4, 0x90, 0xd9, 0x4a, 0x6e, 0x1c, 0xc0, 0xc6, 0x2d, 0x2b, 0x9f, 0xec, 0x42, 0x33, 0x69,
	0x98, 0x74, 0x9b, 0x94, 0x3a, 0x2a, 0x53, 0xf8, 0xe2, 0x7b, 0x68, 0xe7, 0x9a, 0xf4, 0xcd, 0xad,
	0xdc, 0x85, 0xd6, 0xc1, 0xf3, 0xd3, 0xc3, 0x9f, 0xac, 0xe9, 0xf9, 0x51, 0x5f, 0x8b, 0x97, 0xef,
	0xf1, 0x68, 0x7c, 0x72, 0x71, 0x7c, 0xf1, 0x52, 0x72, 0x56, 0xf6, 0x7f, 0x83, 0xba, 0x1a, 0x92,
	0xe4, 0x29, 0x74, 0xd4, 0xd7, 0xb9, 0x88, 0x90, 0xfa, 0xa4, 0x94, 0xf0, 0xad, 0x12, 0xc7, 0xa8,
	0xec, 0x68, 0x8f, 0x35, 0xf2, 0x10, 0xaa, 0x67, 0x2e, 0x73, 0x48, 0xf1, 0xb9, 0xb8, 0x55, 0x24,
	0x8d, 0xca, 0xc1, 0x97, 0xbf, 0xee, 0x3a, 0xae, 0x98, 0x2f, 0x2e, 0x07, 0xb3, 0xc0, 0xdf, 0x9b,
	0xdf, 0x84, 0x18, 0x79, 0x68, 0x3b, 0x18, 0xed, 0x5d, 0xd1, 0xcb, 0xc8, 0x9d, 0xed, 0xc9, 0x3f,
	0x35, 0xbe, 0xa7, 0x60, 0x97, 0x75, 0x49, 0x3e, 0xf9, 0x2f, 0x00, 0x00, 0xff, 0xff, 0x74, 0x25,
	0x05, 0xf1, 0xd0, 0x0d, 0x00, 0x00,
}
