// Code generated by protoc-gen-go. DO NOT EDIT.
// source: ledger/rwset/kvrwset/kv_rwset.proto

/*
Package kvrwset is a generated protocol buffer package.

It is generated from these files:
	ledger/rwset/kvrwset/kv_rwset.proto

It has these top-level messages:
	KVRWSet
	KVRead
	KVWrite
	Version
	RangeQueryInfo
	QueryReads
	QueryReadsMerkleSummary
*/
package kvrwset

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// KVRWSet encapsulates the read-write set for a chaincode that operates upon a KV or Document data model
type KVRWSet struct {
	Reads            []*KVRead         `protobuf:"bytes,1,rep,name=reads" json:"reads,omitempty"`
	RangeQueriesInfo []*RangeQueryInfo `protobuf:"bytes,2,rep,name=range_queries_info,json=rangeQueriesInfo" json:"range_queries_info,omitempty"`
	Writes           []*KVWrite        `protobuf:"bytes,3,rep,name=writes" json:"writes,omitempty"`
}

func (m *KVRWSet) Reset()                    { *m = KVRWSet{} }
func (m *KVRWSet) String() string            { return proto.CompactTextString(m) }
func (*KVRWSet) ProtoMessage()               {}
func (*KVRWSet) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *KVRWSet) GetReads() []*KVRead {
	if m != nil {
		return m.Reads
	}
	return nil
}

func (m *KVRWSet) GetRangeQueriesInfo() []*RangeQueryInfo {
	if m != nil {
		return m.RangeQueriesInfo
	}
	return nil
}

func (m *KVRWSet) GetWrites() []*KVWrite {
	if m != nil {
		return m.Writes
	}
	return nil
}

// KVRead captures a read operation performed during transaction simulation
// A 'nil' version indicates a non-existing key read by the transaction
type KVRead struct {
	Key     string   `protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
	Version *Version `protobuf:"bytes,2,opt,name=version" json:"version,omitempty"`
}

func (m *KVRead) Reset()                    { *m = KVRead{} }
func (m *KVRead) String() string            { return proto.CompactTextString(m) }
func (*KVRead) ProtoMessage()               {}
func (*KVRead) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *KVRead) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *KVRead) GetVersion() *Version {
	if m != nil {
		return m.Version
	}
	return nil
}

// KVWrite captures a write (update/delete) operation performed during transaction simulation
type KVWrite struct {
	Key      string `protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
	IsDelete bool   `protobuf:"varint,2,opt,name=is_delete,json=isDelete" json:"is_delete,omitempty"`
	Value    []byte `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *KVWrite) Reset()                    { *m = KVWrite{} }
func (m *KVWrite) String() string            { return proto.CompactTextString(m) }
func (*KVWrite) ProtoMessage()               {}
func (*KVWrite) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *KVWrite) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *KVWrite) GetIsDelete() bool {
	if m != nil {
		return m.IsDelete
	}
	return false
}

func (m *KVWrite) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

// Version encapsulates the version of a Key
// A version of a committed key is maintained as the height of the transaction that committed the key.
// The height is represenetd as a tuple <blockNum, txNum> where the txNum is the height of the transaction
// (starting with 1) within block
type Version struct {
	BlockNum uint64 `protobuf:"varint,1,opt,name=block_num,json=blockNum" json:"block_num,omitempty"`
	TxNum    uint64 `protobuf:"varint,2,opt,name=tx_num,json=txNum" json:"tx_num,omitempty"`
}

func (m *Version) Reset()                    { *m = Version{} }
func (m *Version) String() string            { return proto.CompactTextString(m) }
func (*Version) ProtoMessage()               {}
func (*Version) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *Version) GetBlockNum() uint64 {
	if m != nil {
		return m.BlockNum
	}
	return 0
}

func (m *Version) GetTxNum() uint64 {
	if m != nil {
		return m.TxNum
	}
	return 0
}

// RangeQueryInfo encapsulates the details of a range query performed by a transaction during simulation.
// This helps protect transactions from phantom reads by varifying during validation whether any new items
// got committed within the given range between transaction simuation and validation
// (in addition to regular checks for updates/deletes of the existing items).
// readInfo field contains either the KVReads (for the items read by the range query) or a merkle-tree hash
// if the KVReads exceeds a pre-configured numbers
type RangeQueryInfo struct {
	StartKey     string `protobuf:"bytes,1,opt,name=start_key,json=startKey" json:"start_key,omitempty"`
	EndKey       string `protobuf:"bytes,2,opt,name=end_key,json=endKey" json:"end_key,omitempty"`
	ItrExhausted bool   `protobuf:"varint,3,opt,name=itr_exhausted,json=itrExhausted" json:"itr_exhausted,omitempty"`
	// Types that are valid to be assigned to ReadsInfo:
	//	*RangeQueryInfo_RawReads
	//	*RangeQueryInfo_ReadsMerkleHashes
	ReadsInfo isRangeQueryInfo_ReadsInfo `protobuf_oneof:"reads_info"`
}

func (m *RangeQueryInfo) Reset()                    { *m = RangeQueryInfo{} }
func (m *RangeQueryInfo) String() string            { return proto.CompactTextString(m) }
func (*RangeQueryInfo) ProtoMessage()               {}
func (*RangeQueryInfo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

type isRangeQueryInfo_ReadsInfo interface {
	isRangeQueryInfo_ReadsInfo()
}

type RangeQueryInfo_RawReads struct {
	RawReads *QueryReads `protobuf:"bytes,4,opt,name=raw_reads,json=rawReads,oneof"`
}
type RangeQueryInfo_ReadsMerkleHashes struct {
	ReadsMerkleHashes *QueryReadsMerkleSummary `protobuf:"bytes,5,opt,name=reads_merkle_hashes,json=readsMerkleHashes,oneof"`
}

func (*RangeQueryInfo_RawReads) isRangeQueryInfo_ReadsInfo()          {}
func (*RangeQueryInfo_ReadsMerkleHashes) isRangeQueryInfo_ReadsInfo() {}

func (m *RangeQueryInfo) GetReadsInfo() isRangeQueryInfo_ReadsInfo {
	if m != nil {
		return m.ReadsInfo
	}
	return nil
}

func (m *RangeQueryInfo) GetStartKey() string {
	if m != nil {
		return m.StartKey
	}
	return ""
}

func (m *RangeQueryInfo) GetEndKey() string {
	if m != nil {
		return m.EndKey
	}
	return ""
}

func (m *RangeQueryInfo) GetItrExhausted() bool {
	if m != nil {
		return m.ItrExhausted
	}
	return false
}

func (m *RangeQueryInfo) GetRawReads() *QueryReads {
	if x, ok := m.GetReadsInfo().(*RangeQueryInfo_RawReads); ok {
		return x.RawReads
	}
	return nil
}

func (m *RangeQueryInfo) GetReadsMerkleHashes() *QueryReadsMerkleSummary {
	if x, ok := m.GetReadsInfo().(*RangeQueryInfo_ReadsMerkleHashes); ok {
		return x.ReadsMerkleHashes
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RangeQueryInfo) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RangeQueryInfo_OneofMarshaler, _RangeQueryInfo_OneofUnmarshaler, _RangeQueryInfo_OneofSizer, []interface{}{
		(*RangeQueryInfo_RawReads)(nil),
		(*RangeQueryInfo_ReadsMerkleHashes)(nil),
	}
}

func _RangeQueryInfo_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RangeQueryInfo)
	// reads_info
	switch x := m.ReadsInfo.(type) {
	case *RangeQueryInfo_RawReads:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RawReads); err != nil {
			return err
		}
	case *RangeQueryInfo_ReadsMerkleHashes:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ReadsMerkleHashes); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("RangeQueryInfo.ReadsInfo has unexpected type %T", x)
	}
	return nil
}

func _RangeQueryInfo_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RangeQueryInfo)
	switch tag {
	case 4: // reads_info.raw_reads
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(QueryReads)
		err := b.DecodeMessage(msg)
		m.ReadsInfo = &RangeQueryInfo_RawReads{msg}
		return true, err
	case 5: // reads_info.reads_merkle_hashes
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(QueryReadsMerkleSummary)
		err := b.DecodeMessage(msg)
		m.ReadsInfo = &RangeQueryInfo_ReadsMerkleHashes{msg}
		return true, err
	default:
		return false, nil
	}
}

func _RangeQueryInfo_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RangeQueryInfo)
	// reads_info
	switch x := m.ReadsInfo.(type) {
	case *RangeQueryInfo_RawReads:
		s := proto.Size(x.RawReads)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RangeQueryInfo_ReadsMerkleHashes:
		s := proto.Size(x.ReadsMerkleHashes)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// QueryReads encapsulates the KVReads for the items read by a transaction as a result of a query execution
type QueryReads struct {
	KvReads []*KVRead `protobuf:"bytes,1,rep,name=kv_reads,json=kvReads" json:"kv_reads,omitempty"`
}

func (m *QueryReads) Reset()                    { *m = QueryReads{} }
func (m *QueryReads) String() string            { return proto.CompactTextString(m) }
func (*QueryReads) ProtoMessage()               {}
func (*QueryReads) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *QueryReads) GetKvReads() []*KVRead {
	if m != nil {
		return m.KvReads
	}
	return nil
}

// QueryReadsMerkleSummary encapsulates the Merkle-tree hashes for the QueryReads
// This allows to reduce the size of RWSet in the presence of query results
// by storing certain hashes instead of actual results.
// maxDegree field refers to the maximum number of children in the tree at any level
// maxLevel field contains the lowest level which has lesser nodes than maxDegree (starting from leaf level)
type QueryReadsMerkleSummary struct {
	MaxDegree      uint32   `protobuf:"varint,1,opt,name=max_degree,json=maxDegree" json:"max_degree,omitempty"`
	MaxLevel       uint32   `protobuf:"varint,2,opt,name=max_level,json=maxLevel" json:"max_level,omitempty"`
	MaxLevelHashes [][]byte `protobuf:"bytes,3,rep,name=max_level_hashes,json=maxLevelHashes,proto3" json:"max_level_hashes,omitempty"`
}

func (m *QueryReadsMerkleSummary) Reset()                    { *m = QueryReadsMerkleSummary{} }
func (m *QueryReadsMerkleSummary) String() string            { return proto.CompactTextString(m) }
func (*QueryReadsMerkleSummary) ProtoMessage()               {}
func (*QueryReadsMerkleSummary) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *QueryReadsMerkleSummary) GetMaxDegree() uint32 {
	if m != nil {
		return m.MaxDegree
	}
	return 0
}

func (m *QueryReadsMerkleSummary) GetMaxLevel() uint32 {
	if m != nil {
		return m.MaxLevel
	}
	return 0
}

func (m *QueryReadsMerkleSummary) GetMaxLevelHashes() [][]byte {
	if m != nil {
		return m.MaxLevelHashes
	}
	return nil
}

func init() {
	proto.RegisterType((*KVRWSet)(nil), "kvrwset.KVRWSet")
	proto.RegisterType((*KVRead)(nil), "kvrwset.KVRead")
	proto.RegisterType((*KVWrite)(nil), "kvrwset.KVWrite")
	proto.RegisterType((*Version)(nil), "kvrwset.Version")
	proto.RegisterType((*RangeQueryInfo)(nil), "kvrwset.RangeQueryInfo")
	proto.RegisterType((*QueryReads)(nil), "kvrwset.QueryReads")
	proto.RegisterType((*QueryReadsMerkleSummary)(nil), "kvrwset.QueryReadsMerkleSummary")
}

func init() { proto.RegisterFile("ledger/rwset/kvrwset/kv_rwset.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 552 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x7c, 0x53, 0x4d, 0x6b, 0xdb, 0x40,
	0x10, 0x8d, 0xec, 0xd8, 0x92, 0xa7, 0x4e, 0xea, 0x6e, 0x5a, 0x22, 0x28, 0x05, 0xa3, 0x50, 0x30,
	0x39, 0x48, 0x90, 0x5e, 0xda, 0x43, 0x2f, 0x25, 0x29, 0x29, 0x69, 0x03, 0xdd, 0x80, 0x03, 0xbd,
	0x88, 0xb5, 0x35, 0xb6, 0x85, 0xf5, 0x91, 0xee, 0xae, 0x6c, 0xf9, 0x54, 0xfa, 0x53, 0xfa, 0x4f,
	0xcb, 0x8e, 0x24, 0x3b, 0x01, 0xb7, 0x27, 0xed, 0xbc, 0x37, 0x6f, 0x76, 0xe6, 0x69, 0x16, 0xce,
	0x12, 0x8c, 0xe6, 0x28, 0x03, 0xb9, 0x56, 0xa8, 0x83, 0xe5, 0xaa, 0xf9, 0x86, 0x74, 0xf0, 0x1f,
	0x64, 0xae, 0x73, 0x66, 0xd7, 0xb8, 0xf7, 0xc7, 0x02, 0xfb, 0x66, 0xcc, 0xef, 0xef, 0x50, 0xb3,
	0xb7, 0xd0, 0x91, 0x28, 0x22, 0xe5, 0x5a, 0xc3, 0xf6, 0xe8, 0xd9, 0xc5, 0x73, 0xbf, 0x4e, 0xf2,
	0x6f, 0xc6, 0x1c, 0x45, 0xc4, 0x2b, 0x96, 0x5d, 0x01, 0x93, 0x22, 0x9b, 0x63, 0xf8, 0xb3, 0x40,
	0x19, 0xa3, 0x0a, 0xe3, 0x6c, 0x96, 0xbb, 0x2d, 0xd2, 0x9c, 0x6e, 0x35, 0xdc, 0xa4, 0x7c, 0x2f,
	0x50, 0x6e, 0xbe, 0x64, 0xb3, 0x9c, 0x0f, 0x64, 0x13, 0xc7, 0xa8, 0x0c, 0xc2, 0x46, 0xd0, 0x5d,
	0xcb, 0x58, 0xa3, 0x72, 0xdb, 0x24, 0x1d, 0x3c, 0xba, 0xee, 0xde, 0x10, 0xbc, 0xe6, 0xbd, 0xcf,
	0xd0, 0xad, 0x3a, 0x60, 0x03, 0x68, 0x2f, 0x71, 0xe3, 0x5a, 0x43, 0x6b, 0xd4, 0xe3, 0xe6, 0xc8,
	0xce, 0xc1, 0x5e, 0xa1, 0x54, 0x71, 0x9e, 0xb9, 0xad, 0xa1, 0xf5, 0xa4, 0xcc, 0xb8, 0xc2, 0x79,
	0x93, 0xe0, 0xdd, 0x9a, 0x51, 0xa9, 0xf4, 0x9e, 0x42, 0xaf, 0xa1, 0x17, 0xab, 0x30, 0xc2, 0x04,
	0x35, 0x52, 0x29, 0x87, 0x3b, 0xb1, 0xba, 0xa4, 0x98, 0xbd, 0x84, 0xce, 0x4a, 0x24, 0x05, 0xba,
	0xed, 0xa1, 0x35, 0xea, 0xf3, 0x2a, 0xf0, 0x3e, 0x82, 0x5d, 0xdf, 0x61, 0xd4, 0x93, 0x24, 0x9f,
	0x2e, 0xc3, 0xac, 0x48, 0xa9, 0xea, 0x21, 0x77, 0x08, 0xb8, 0x2d, 0x52, 0xf6, 0x0a, 0xba, 0xba,
	0x24, 0xa6, 0x45, 0x4c, 0x47, 0x97, 0xb7, 0x45, 0xea, 0xfd, 0x6e, 0xc1, 0xf1, 0x53, 0x97, 0x4c,
	0x19, 0xa5, 0x85, 0xd4, 0xe1, 0xae, 0x39, 0x87, 0x80, 0x1b, 0xdc, 0xb0, 0x53, 0xb0, 0x31, 0x8b,
	0x88, 0x6a, 0x11, 0xd5, 0xc5, 0x2c, 0x32, 0xc4, 0x19, 0x1c, 0xc5, 0x5a, 0x86, 0x58, 0x2e, 0x44,
	0xa1, 0x34, 0x46, 0xd4, 0xa5, 0xc3, 0xfb, 0xb1, 0x96, 0x57, 0x0d, 0xc6, 0x2e, 0xa0, 0x27, 0xc5,
	0x3a, 0xac, 0x7e, 0xf0, 0x21, 0x59, 0x75, 0xb2, 0xb5, 0x8a, 0x3a, 0x30, 0x0e, 0xab, 0xeb, 0x03,
	0xee, 0x48, 0xb1, 0xa6, 0x33, 0xe3, 0x70, 0x42, 0xf9, 0x61, 0x8a, 0x72, 0x99, 0x60, 0xb8, 0x10,
	0x6a, 0x81, 0xca, 0xed, 0x90, 0x7a, 0xb8, 0x47, 0xfd, 0x8d, 0xf2, 0xee, 0x8a, 0x34, 0x15, 0x72,
	0x73, 0x7d, 0xc0, 0x5f, 0xc8, 0x1d, 0x7a, 0x4d, 0xe2, 0x4f, 0x7d, 0x80, 0xaa, 0xa6, 0xd9, 0x1a,
	0xef, 0x3d, 0xc0, 0x4e, 0xcd, 0xce, 0xc1, 0x31, 0x7b, 0xfa, 0xbf, 0x1d, 0xb4, 0x97, 0x2b, 0xca,
	0xf5, 0x7e, 0xc1, 0xe9, 0x3f, 0xee, 0x65, 0x6f, 0x00, 0x52, 0x51, 0x86, 0x11, 0xce, 0x25, 0x22,
	0xd9, 0x78, 0xc4, 0x7b, 0xa9, 0x28, 0x2f, 0x09, 0x30, 0x26, 0x1b, 0x3a, 0xc1, 0x15, 0x26, 0xe4,
	0xe4, 0x11, 0x77, 0x52, 0x51, 0x7e, 0x35, 0x31, 0x1b, 0xc1, 0x60, 0x4b, 0x36, 0xf3, 0x9a, 0xfd,
	0xec, 0xf3, 0xe3, 0x26, 0xa7, 0x1e, 0x24, 0x87, 0x8b, 0x5c, 0xce, 0xfd, 0xc5, 0xe6, 0x01, 0x65,
	0xf5, 0xe4, 0xfc, 0x99, 0x98, 0xc8, 0x78, 0x5a, 0x3d, 0x31, 0xe5, 0xd7, 0x60, 0xd5, 0x7e, 0x3d,
	0xc6, 0x8f, 0x0f, 0xf3, 0x58, 0x2f, 0x8a, 0x89, 0x3f, 0xcd, 0xd3, 0xe0, 0x91, 0x34, 0xa8, 0xa4,
	0x41, 0x25, 0x0d, 0xf6, 0x3d, 0xe1, 0x49, 0x97, 0xc8, 0x77, 0x7f, 0x03, 0x00, 0x00, 0xff, 0xff,
	0x7e, 0x2f, 0xc5, 0xa9, 0xe1, 0x03, 0x00, 0x00,
}
